/* PowerManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PowerManager.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2011-2024 elementary, Inc. (https://elementary.io)
 */

#include "power.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#define POWER_POWER_MANAGER_UPOWER_NAME "org.freedesktop.UPower"
#define POWER_POWER_MANAGER_UPOWER_PATH "/org/freedesktop/UPower"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define POWER_TYPE_UPOWER (power_upower_get_type ())
#define POWER_UPOWER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWER_TYPE_UPOWER, PowerUpower))
#define POWER_IS_UPOWER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWER_TYPE_UPOWER))
#define POWER_UPOWER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), POWER_TYPE_UPOWER, PowerUpowerIface))

typedef struct _PowerUpower PowerUpower;
typedef struct _PowerUpowerIface PowerUpowerIface;

#define POWER_TYPE_UPOWER_PROXY (power_upower_proxy_get_type ())
enum  {
	POWER_POWER_MANAGER_0_PROPERTY,
	POWER_POWER_MANAGER_BATTERIES_PROPERTY,
	POWER_POWER_MANAGER_DEVICES_PROPERTY,
	POWER_POWER_MANAGER_NUM_PROPERTIES
};
static GParamSpec* power_power_manager_properties[POWER_POWER_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PowerUpowerIface {
	GTypeInterface parent_iface;
	char** (*enumerate_devices) (PowerUpower* self, gint* result_length1, GError** error);
	gboolean (*get_on_battery) (PowerUpower* self);
	gboolean (*get_lid_is_present) (PowerUpower* self);
	gboolean (*get_low_on_battery) (PowerUpower* self);
};

struct _PowerPowerManagerPrivate {
	GListStore* _batteries;
	GListStore* _devices;
	PowerUpower* upower;
};

static gint PowerPowerManager_private_offset;
static gpointer power_power_manager_parent_class = NULL;
static GOnce power_power_manager_instance;
static GOnce power_power_manager_instance = G_ONCE_INIT;

VALA_EXTERN GType power_upower_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint power_upower_register_object (void* object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error);
VALA_EXTERN GType power_upower_get_type (void) G_GNUC_CONST ;
static PowerPowerManager* __lambda4_ (void);
static gpointer ___lambda4__gthread_func (gpointer self);
VALA_EXTERN gboolean power_upower_get_on_battery (PowerUpower* self);
VALA_EXTERN gboolean power_upower_get_lid_is_present (PowerUpower* self);
static void power_power_manager_on_device_added (PowerPowerManager* self,
                                          const char* device_path);
static void power_power_manager_on_device_removed (PowerPowerManager* self,
                                            const char* device_path);
static void power_power_manager_set_batteries (PowerPowerManager* self,
                                        GListStore* value);
static void power_power_manager_set_devices (PowerPowerManager* self,
                                      GListStore* value);
static GObject * power_power_manager_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _power_power_manager_on_device_added_power_upower_device_added (PowerUpower* _sender,
                                                                     const char* device_path,
                                                                     gpointer self);
static void _power_power_manager_on_device_removed_power_upower_device_removed (PowerUpower* _sender,
                                                                         const char* device_path,
                                                                         gpointer self);
VALA_EXTERN char** power_upower_enumerate_devices (PowerUpower* self,
                                       gint* result_length1,
                                       GError** error);
static void power_power_manager_finalize (GObject * obj);
static GType power_power_manager_get_type_once (void);
static void _vala_power_power_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_power_power_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
power_power_manager_get_instance_private (PowerPowerManager* self)
{
	return G_STRUCT_MEMBER_P (self, PowerPowerManager_private_offset);
}

static PowerPowerManager*
__lambda4_ (void)
{
	PowerPowerManager* _tmp0_;
	PowerPowerManager* result;
	_tmp0_ = power_power_manager_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda4_ ();
	return result;
}

PowerPowerManager*
power_power_manager_get_default (void)
{
	gconstpointer _tmp0_;
	PowerPowerManager* result;
	_tmp0_ = g_once (&power_power_manager_instance, ___lambda4__gthread_func, NULL);
	result = (PowerPowerManager*) _tmp0_;
	return result;
}

gboolean
power_power_manager_on_battery (PowerPowerManager* self)
{
	PowerUpower* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->upower;
	_tmp1_ = power_upower_get_on_battery (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

gboolean
power_power_manager_has_lid (PowerPowerManager* self)
{
	PowerUpower* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->upower;
	_tmp1_ = power_upower_get_lid_is_present (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
power_power_manager_on_device_added (PowerPowerManager* self,
                                     const char* device_path)
{
	PowerDevice* device = NULL;
	PowerDevice* _tmp0_;
	guint position = 0U;
	PowerDevice* _tmp1_;
	PowerDeviceType _tmp2_;
	PowerDeviceType _tmp3_;
	gboolean _tmp4_ = FALSE;
	PowerDevice* _tmp5_;
	PowerDeviceType _tmp6_;
	PowerDeviceType _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	_tmp0_ = power_device_new ((const gchar*) device_path);
	device = _tmp0_;
	position = (guint) -1;
	_tmp1_ = device;
	_tmp2_ = power_device_get_device_type (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == POWER_DEVICE_TYPE_LINE_POWER) {
		_g_object_unref0 (device);
		return;
	}
	_tmp5_ = device;
	_tmp6_ = power_device_get_device_type (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == POWER_DEVICE_TYPE_BATTERY) {
		PowerDevice* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp8_ = device;
		_tmp9_ = power_device_get_power_supply (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = _tmp10_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean found = FALSE;
		GListStore* _tmp11_;
		PowerDevice* _tmp12_;
		guint _tmp13_ = 0U;
		gboolean _tmp14_;
		_tmp11_ = self->priv->_batteries;
		_tmp12_ = device;
		_tmp14_ = g_list_store_find_with_equal_func (_tmp11_, (GObject*) _tmp12_, (GEqualFunc) power_device_equal_func, &_tmp13_);
		position = _tmp13_;
		found = _tmp14_;
		if (!found) {
			GListStore* _tmp15_;
			PowerDevice* _tmp16_;
			_tmp15_ = self->priv->_batteries;
			_tmp16_ = device;
			g_list_store_append (_tmp15_, (GObject*) _tmp16_);
		}
	} else {
		gboolean found = FALSE;
		GListStore* _tmp17_;
		PowerDevice* _tmp18_;
		guint _tmp19_ = 0U;
		gboolean _tmp20_;
		_tmp17_ = self->priv->_devices;
		_tmp18_ = device;
		_tmp20_ = g_list_store_find_with_equal_func (_tmp17_, (GObject*) _tmp18_, (GEqualFunc) power_device_equal_func, &_tmp19_);
		position = _tmp19_;
		found = _tmp20_;
		if (!found) {
			GListStore* _tmp21_;
			PowerDevice* _tmp22_;
			_tmp21_ = self->priv->_devices;
			_tmp22_ = device;
			g_list_store_append (_tmp21_, (GObject*) _tmp22_);
		}
	}
	_g_object_unref0 (device);
}

static void
power_power_manager_on_device_removed (PowerPowerManager* self,
                                       const char* device_path)
{
	guint position = 0U;
	GListStore* _tmp0_;
	PowerDevice* _tmp1_;
	PowerDevice* _tmp2_;
	guint _tmp3_ = 0U;
	GListStore* _tmp5_;
	PowerDevice* _tmp6_;
	PowerDevice* _tmp7_;
	guint _tmp8_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_path != NULL);
	position = (guint) -1;
	_tmp0_ = self->priv->_devices;
	_tmp1_ = power_device_new ((const gchar*) device_path);
	_tmp2_ = _tmp1_;
	g_list_store_find_with_equal_func (_tmp0_, (GObject*) _tmp2_, (GEqualFunc) power_device_equal_func, &_tmp3_);
	position = _tmp3_;
	_g_object_unref0 (_tmp2_);
	if (position != ((guint) -1)) {
		GListStore* _tmp4_;
		_tmp4_ = self->priv->_devices;
		g_list_store_remove (_tmp4_, position);
		return;
	}
	_tmp5_ = self->priv->_batteries;
	_tmp6_ = power_device_new ((const gchar*) device_path);
	_tmp7_ = _tmp6_;
	g_list_store_find_with_equal_func (_tmp5_, (GObject*) _tmp7_, (GEqualFunc) power_device_equal_func, &_tmp8_);
	position = _tmp8_;
	_g_object_unref0 (_tmp7_);
	if (position != ((guint) -1)) {
		GListStore* _tmp9_;
		_tmp9_ = self->priv->_batteries;
		g_list_store_remove (_tmp9_, position);
	}
}

PowerPowerManager*
power_power_manager_construct (GType object_type)
{
	PowerPowerManager * self = NULL;
	self = (PowerPowerManager*) g_object_new (object_type, NULL);
	return self;
}

PowerPowerManager*
power_power_manager_new (void)
{
	return power_power_manager_construct (POWER_TYPE_POWER_MANAGER);
}

GListStore*
power_power_manager_get_batteries (PowerPowerManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_batteries;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
power_power_manager_set_batteries (PowerPowerManager* self,
                                   GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_power_manager_get_batteries (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_batteries);
		self->priv->_batteries = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_power_manager_properties[POWER_POWER_MANAGER_BATTERIES_PROPERTY]);
	}
}

GListStore*
power_power_manager_get_devices (PowerPowerManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_devices;
	result = _tmp0_;
	return result;
}

static void
power_power_manager_set_devices (PowerPowerManager* self,
                                 GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = power_power_manager_get_devices (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_devices);
		self->priv->_devices = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, power_power_manager_properties[POWER_POWER_MANAGER_DEVICES_PROPERTY]);
	}
}

static void
_power_power_manager_on_device_added_power_upower_device_added (PowerUpower* _sender,
                                                                const char* device_path,
                                                                gpointer self)
{
	power_power_manager_on_device_added ((PowerPowerManager*) self, device_path);
}

static void
_power_power_manager_on_device_removed_power_upower_device_removed (PowerUpower* _sender,
                                                                    const char* device_path,
                                                                    gpointer self)
{
	power_power_manager_on_device_removed ((PowerPowerManager*) self, device_path);
}

static GObject *
power_power_manager_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerPowerManager * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	GListStore* _tmp3_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (power_power_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_POWER_MANAGER, PowerPowerManager);
	_tmp0_ = g_list_store_new (POWER_TYPE_DEVICE);
	_tmp1_ = _tmp0_;
	power_power_manager_set_batteries (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = g_list_store_new (POWER_TYPE_DEVICE);
	_tmp3_ = _tmp2_;
	power_power_manager_set_devices (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	{
		PowerUpower* _tmp4_ = NULL;
		PowerUpower* _tmp5_;
		PowerUpower* _tmp6_;
		PowerUpower* _tmp7_;
		PowerUpower* _tmp8_;
		_tmp5_ = (PowerUpower*) g_initable_new (POWER_TYPE_UPOWER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", POWER_POWER_MANAGER_UPOWER_NAME, "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", POWER_POWER_MANAGER_UPOWER_PATH, "g-interface-name", "org.freedesktop.UPower", NULL);
		_tmp4_ = (PowerUpower*) _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp6_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (self->priv->upower);
		self->priv->upower = _tmp6_;
		_tmp7_ = self->priv->upower;
		g_signal_connect_object (_tmp7_, "device-added", (GCallback) _power_power_manager_on_device_added_power_upower_device_added, self, 0);
		_tmp8_ = self->priv->upower;
		g_signal_connect_object (_tmp8_, "device-removed", (GCallback) _power_power_manager_on_device_removed_power_upower_device_removed, self, 0);
		{
			char** _tmp9_ = NULL;
			PowerUpower* _tmp10_;
			gint _tmp11_ = 0;
			char** _tmp12_;
			gint _tmp9__length1;
			gint __tmp9__size_;
			_tmp10_ = self->priv->upower;
			_tmp12_ = power_upower_enumerate_devices (_tmp10_, &_tmp11_, &_inner_error0_);
			_tmp9_ = _tmp12_;
			_tmp9__length1 = _tmp11_;
			__tmp9__size_ = _tmp9__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			{
				char** path_collection = NULL;
				gint path_collection_length1 = 0;
				gint _path_collection_size_ = 0;
				gint path_it = 0;
				path_collection = _tmp9_;
				path_collection_length1 = _tmp9__length1;
				for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
					const char* path = NULL;
					path = path_collection[path_it];
					{
						const char* _tmp13_;
						_tmp13_ = path;
						power_power_manager_on_device_added (self, _tmp13_);
					}
				}
			}
			_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_critical ("PowerManager.vala:34: acpi couldn't get upower devices: %s", _tmp15_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp4_);
			goto __catch0_g_error;
		}
		_g_object_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_critical ("PowerManager.vala:37: Connecting to UPower bus failed: %s", _tmp17_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
power_power_manager_class_init (PowerPowerManagerClass * klass,
                                gpointer klass_data)
{
	power_power_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerPowerManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_power_power_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_power_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_power_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_power_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_POWER_MANAGER_BATTERIES_PROPERTY, power_power_manager_properties[POWER_POWER_MANAGER_BATTERIES_PROPERTY] = g_param_spec_object ("batteries", "batteries", "batteries", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_POWER_MANAGER_DEVICES_PROPERTY, power_power_manager_properties[POWER_POWER_MANAGER_DEVICES_PROPERTY] = g_param_spec_object ("devices", "devices", "devices", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
power_power_manager_instance_init (PowerPowerManager * self,
                                   gpointer klass)
{
	self->priv = power_power_manager_get_instance_private (self);
}

static void
power_power_manager_finalize (GObject * obj)
{
	PowerPowerManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_POWER_MANAGER, PowerPowerManager);
	_g_object_unref0 (self->priv->_batteries);
	_g_object_unref0 (self->priv->_devices);
	_g_object_unref0 (self->priv->upower);
	G_OBJECT_CLASS (power_power_manager_parent_class)->finalize (obj);
}

static GType
power_power_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerPowerManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_power_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerPowerManager), 0, (GInstanceInitFunc) power_power_manager_instance_init, NULL };
	GType power_power_manager_type_id;
	power_power_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "PowerPowerManager", &g_define_type_info, 0);
	PowerPowerManager_private_offset = g_type_add_instance_private (power_power_manager_type_id, sizeof (PowerPowerManagerPrivate));
	return power_power_manager_type_id;
}

GType
power_power_manager_get_type (void)
{
	static volatile gsize power_power_manager_type_id__once = 0;
	if (g_once_init_enter (&power_power_manager_type_id__once)) {
		GType power_power_manager_type_id;
		power_power_manager_type_id = power_power_manager_get_type_once ();
		g_once_init_leave (&power_power_manager_type_id__once, power_power_manager_type_id);
	}
	return power_power_manager_type_id__once;
}

static void
_vala_power_power_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	PowerPowerManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_POWER_MANAGER, PowerPowerManager);
	switch (property_id) {
		case POWER_POWER_MANAGER_BATTERIES_PROPERTY:
		g_value_set_object (value, power_power_manager_get_batteries (self));
		break;
		case POWER_POWER_MANAGER_DEVICES_PROPERTY:
		g_value_set_object (value, power_power_manager_get_devices (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_power_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	PowerPowerManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_POWER_MANAGER, PowerPowerManager);
	switch (property_id) {
		case POWER_POWER_MANAGER_BATTERIES_PROPERTY:
		power_power_manager_set_batteries (self, g_value_get_object (value));
		break;
		case POWER_POWER_MANAGER_DEVICES_PROPERTY:
		power_power_manager_set_devices (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

