/* SnapshotRepo.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SnapshotRepo.vala, do not modify */

/*
 * SnapshotRepo.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>

#define TEE_JEE_FILE_SYSTEM_KB ((gint64) 1000)
#define TEE_JEE_FILE_SYSTEM_MB (1000 * TEE_JEE_FILE_SYSTEM_KB)
#define TEE_JEE_FILE_SYSTEM_GB (1000 * TEE_JEE_FILE_SYSTEM_MB)
#define MAIN_MIN_FREE_SPACE ((guint64) (1 * TEE_JEE_FILE_SYSTEM_GB))
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())
enum  {
	SNAPSHOT_REPO_0_PROPERTY,
	SNAPSHOT_REPO_TIMESHIFT_PATH_PROPERTY,
	SNAPSHOT_REPO_SNAPSHOTS_PATH_PROPERTY,
	SNAPSHOT_REPO_NUM_PROPERTIES
};
static GParamSpec* snapshot_repo_properties[SNAPSHOT_REPO_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DevicePrivate DevicePrivate;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef struct _SubvolumePrivate SubvolumePrivate;
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

struct _SnapshotRepoPrivate {
	GtkWindow* parent_window;
	gboolean thr_success;
	gboolean thr_running;
	gchar* thr_args1;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_estimate_running;
	gboolean thread_estimate_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _Subvolume {
	GObject parent_instance;
	SubvolumePrivate * priv;
	gchar* device_uuid;
	gchar* name;
	gchar* path;
	glong id;
	gint64 total_bytes;
	gint64 unshared_bytes;
	gchar* mount_path;
	SnapshotRepo* repo;
};

struct _SubvolumeClass {
	GObjectClass parent_class;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

static gint SnapshotRepo_private_offset;
static gpointer snapshot_repo_parent_class = NULL;
VALA_EXTERN Main* App;
VALA_EXTERN guint64 main_first_snapshot_size;

VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_path (const gchar* path,
                                           GtkWindow* parent_win,
                                           gboolean _btrfs_mode);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_path (GType object_type,
                                                 const gchar* path,
                                                 GtkWindow* parent_win,
                                                 gboolean _btrfs_mode);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN GeeArrayList* device_get_disk_space_using_df (const gchar* dev_name_or_mount_point);
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN guint64 device_get_free_bytes (Device* self);
VALA_EXTERN void snapshot_repo_check_status (SnapshotRepo* self);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_device (Device* dev,
                                             GtkWindow* parent_win,
                                             gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_device (GType object_type,
                                                   Device* dev,
                                                   GtkWindow* parent_win,
                                                   gboolean btrfs_repo);
static void snapshot_repo_init_from_device (SnapshotRepo* self);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_uuid (const gchar* uuid,
                                           GtkWindow* parent_win,
                                           gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_uuid (GType object_type,
                                                 const gchar* uuid,
                                                 GtkWindow* parent_win,
                                                 gboolean btrfs_repo);
VALA_EXTERN Device* device_get_device_by_uuid (const gchar* uuid);
VALA_EXTERN Device* device_new (void);
VALA_EXTERN Device* device_construct (GType object_type);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_null (void);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_null (GType object_type);
VALA_EXTERN gboolean snapshot_repo_unlock_and_mount_devices (SnapshotRepo* self);
VALA_EXTERN gchar* snapshot_repo_unlock_and_mount_device (SnapshotRepo* self,
                                              Device* device_to_mount,
                                              const gchar* path_to_mount);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GeeHashMap* subvolume_detect_subvolumes_for_system_by_path (const gchar* system_path,
                                                            SnapshotRepo* repo,
                                                            GtkWindow* parent_window);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN Device* subvolume_get_device (Subvolume* self);
VALA_EXTERN gboolean snapshot_repo_load_snapshots (SnapshotRepo* self);
VALA_EXTERN gboolean device_is_encrypted_partition (Device* self);
VALA_EXTERN Device* snapshot_repo_unlock_encrypted_device (SnapshotRepo* self,
                                               Device* luks_device);
VALA_EXTERN gboolean device_mount (const gchar* dev_name_or_uuid,
                       const gchar* mount_point,
                       const gchar* mount_options,
                       gboolean silent);
VALA_EXTERN Device* device_luks_unlock (Device* luks_device,
                            const gchar* mapped_name,
                            const gchar* passphrase,
                            GtkWindow* parent_window,
                            gchar** message,
                            gchar** details);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN gchar* snapshot_repo_get_snapshots_path (SnapshotRepo* self);
VALA_EXTERN Snapshot* snapshot_new (const gchar* dir_path,
                        gboolean btrfs_snapshot,
                        SnapshotRepo* _repo);
VALA_EXTERN Snapshot* snapshot_construct (GType object_type,
                              const gchar* dir_path,
                              gboolean btrfs_snapshot,
                              SnapshotRepo* _repo);
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
static gint __lambda12_ (SnapshotRepo* self,
                  Snapshot* a,
                  Snapshot* b);
static gint ___lambda12__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN gdouble tee_jee_system_get_system_uptime_seconds (void);
VALA_EXTERN void snapshot_update_control_file (Snapshot* self);
VALA_EXTERN void main_query_subvolume_info (Main* self,
                                SnapshotRepo* parent_repo);
VALA_EXTERN GeeArrayList* snapshot_repo_get_snapshots_by_tag (SnapshotRepo* self,
                                                  const gchar* tag);
VALA_EXTERN gboolean snapshot_has_tag (Snapshot* self,
                           const gchar* tag);
static gint __lambda14_ (SnapshotRepo* self,
                  Snapshot* a,
                  Snapshot* b);
static gint ___lambda14__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN Snapshot* snapshot_repo_get_latest_snapshot (SnapshotRepo* self,
                                             const gchar* tag,
                                             const gchar* sys_uuid);
VALA_EXTERN Snapshot* snapshot_repo_get_oldest_snapshot (SnapshotRepo* self,
                                             const gchar* tag,
                                             const gchar* sys_uuid);
VALA_EXTERN gboolean snapshot_repo_available (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_repo_has_snapshots (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_repo_has_space (SnapshotRepo* self,
                                  guint64 needed);
VALA_EXTERN gboolean snapshot_repo_has_btrfs_system (SnapshotRepo* self);
VALA_EXTERN void device_query_disk_space (Device* self);
VALA_EXTERN void snapshot_repo_print_status (SnapshotRepo* self);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gchar* device_get_device_name_with_parent (Device* self);
VALA_EXTERN void snapshot_repo_auto_remove (SnapshotRepo* self);
VALA_EXTERN void snapshot_remove_tag (Snapshot* self,
                          const gchar* tag);
VALA_EXTERN void snapshot_repo_remove_untagged (SnapshotRepo* self);
VALA_EXTERN void snapshot_repo_remove_marked_for_deletion (SnapshotRepo* self);
VALA_EXTERN void snapshot_repo_remove_invalid (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_remove (Snapshot* self,
                          gboolean wait);
VALA_EXTERN gboolean snapshot_repo_remove_all (SnapshotRepo* self);
VALA_EXTERN gchar* snapshot_repo_get_timeshift_path (SnapshotRepo* self);
VALA_EXTERN gboolean snapshot_repo_remove_sync_dir (SnapshotRepo* self);
static gboolean snapshot_repo_delete_directory (SnapshotRepo* self,
                                         const gchar* dir_path);
VALA_EXTERN gboolean snapshot_repo_remove_timeshift_dir (SnapshotRepo* self);
static void ___lambda15_ (SnapshotRepo* self);
static void snapshot_repo_delete_directory_thread (SnapshotRepo* self);
static gpointer ____lambda15__gthread_func (gpointer self);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN gboolean tee_jee_file_system_dir_delete_recursive (const gchar* dir);
VALA_EXTERN void snapshot_repo_create_symlinks (SnapshotRepo* self);
VALA_EXTERN void snapshot_repo_cleanup_symlink_dir (SnapshotRepo* self,
                                        const gchar* tag);
VALA_EXTERN SnapshotRepo* snapshot_repo_new (void);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct (GType object_type);
static void snapshot_repo_finalize (GObject * obj);
static GType snapshot_repo_get_type_once (void);
static void _vala_snapshot_repo_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
snapshot_repo_get_instance_private (SnapshotRepo* self)
{
	return G_STRUCT_MEMBER_P (self, SnapshotRepo_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

SnapshotRepo*
snapshot_repo_construct_from_path (GType object_type,
                                   const gchar* path,
                                   GtkWindow* parent_win,
                                   gboolean _btrfs_mode)
{
	SnapshotRepo * self = NULL;
	gchar* _tmp0_;
	GtkWindow* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_val_if_fail (path != NULL, NULL);
	self = (SnapshotRepo*) g_object_new (object_type, NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: from_path()");
	_tmp0_ = g_strdup (path);
	_g_free0 (self->mount_path);
	self->mount_path = _tmp0_;
	_tmp1_ = _g_object_ref0 (parent_win);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp1_;
	self->btrfs_mode = _btrfs_mode;
	_tmp2_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->snapshots);
	self->snapshots = _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->invalid_snapshots);
	self->invalid_snapshots = _tmp3_;
	_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->mount_paths);
	self->mount_paths = _tmp4_;
	_tmp5_ = device_get_disk_space_using_df (path);
	list = _tmp5_;
	_tmp6_ = list;
	_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > 0) {
		GeeArrayList* _tmp9_;
		gpointer _tmp10_;
		Device* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		Device* _tmp17_;
		guint64 _tmp18_;
		guint64 _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp9_ = list;
		_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, 0);
		_g_object_unref0 (self->device);
		self->device = (Device*) _tmp10_;
		_tmp11_ = self->device;
		_tmp12_ = _tmp11_->device;
		_tmp13_ = g_strdup_printf (": %s", _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_ ("Device"), _tmp14_, NULL);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_debug (_tmp16_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_tmp17_ = self->device;
		_tmp18_ = device_get_free_bytes (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = tee_jee_file_system_format_file_size (_tmp19_, FALSE, "", TRUE, 1);
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf (": %s", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_ ("Free space"), _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		tee_jee_logging_log_debug (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
	}
	snapshot_repo_check_status (self);
	_g_object_unref0 (list);
	return self;
}

SnapshotRepo*
snapshot_repo_new_from_path (const gchar* path,
                             GtkWindow* parent_win,
                             gboolean _btrfs_mode)
{
	return snapshot_repo_construct_from_path (TYPE_SNAPSHOT_REPO, path, parent_win, _btrfs_mode);
}

SnapshotRepo*
snapshot_repo_construct_from_device (GType object_type,
                                     Device* dev,
                                     GtkWindow* parent_win,
                                     gboolean btrfs_repo)
{
	SnapshotRepo * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	Device* _tmp3_;
	GtkWindow* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeHashMap* _tmp7_;
	g_return_val_if_fail (dev != NULL, NULL);
	self = (SnapshotRepo*) g_object_new (object_type, NULL);
	if (btrfs_repo) {
		_tmp0_ = "BTRFS";
	} else {
		_tmp0_ = "RSYNC";
	}
	_tmp1_ = g_strdup_printf ("SnapshotRepo: from_device(): %s", _tmp0_);
	_tmp2_ = _tmp1_;
	tee_jee_logging_log_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = _g_object_ref0 (dev);
	_g_object_unref0 (self->device);
	self->device = _tmp3_;
	_tmp4_ = _g_object_ref0 (parent_win);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp4_;
	self->btrfs_mode = btrfs_repo;
	_tmp5_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->snapshots);
	self->snapshots = _tmp5_;
	_tmp6_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->invalid_snapshots);
	self->invalid_snapshots = _tmp6_;
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->mount_paths);
	self->mount_paths = _tmp7_;
	snapshot_repo_init_from_device (self);
	return self;
}

SnapshotRepo*
snapshot_repo_new_from_device (Device* dev,
                               GtkWindow* parent_win,
                               gboolean btrfs_repo)
{
	return snapshot_repo_construct_from_device (TYPE_SNAPSHOT_REPO, dev, parent_win, btrfs_repo);
}

SnapshotRepo*
snapshot_repo_construct_from_uuid (GType object_type,
                                   const gchar* uuid,
                                   GtkWindow* parent_win,
                                   gboolean btrfs_repo)
{
	SnapshotRepo * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	Device* _tmp5_;
	Device* _tmp6_;
	GtkWindow* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeHashMap* _tmp13_;
	g_return_val_if_fail (uuid != NULL, NULL);
	self = (SnapshotRepo*) g_object_new (object_type, NULL);
	if (btrfs_repo) {
		_tmp0_ = "BTRFS";
	} else {
		_tmp0_ = "RSYNC";
	}
	_tmp1_ = g_strdup_printf ("SnapshotRepo: from_uuid(): %s", _tmp0_);
	_tmp2_ = _tmp1_;
	tee_jee_logging_log_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_strdup_printf ("uuid=%s", uuid);
	_tmp4_ = _tmp3_;
	tee_jee_logging_log_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = device_get_device_by_uuid (uuid);
	_g_object_unref0 (self->device);
	self->device = _tmp5_;
	_tmp6_ = self->device;
	if (_tmp6_ == NULL) {
		Device* _tmp7_;
		Device* _tmp8_;
		gchar* _tmp9_;
		_tmp7_ = device_new ();
		_g_object_unref0 (self->device);
		self->device = _tmp7_;
		_tmp8_ = self->device;
		_tmp9_ = g_strdup (uuid);
		_g_free0 (_tmp8_->uuid);
		_tmp8_->uuid = _tmp9_;
	}
	_tmp10_ = _g_object_ref0 (parent_win);
	_g_object_unref0 (self->priv->parent_window);
	self->priv->parent_window = _tmp10_;
	self->btrfs_mode = btrfs_repo;
	_tmp11_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->snapshots);
	self->snapshots = _tmp11_;
	_tmp12_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->invalid_snapshots);
	self->invalid_snapshots = _tmp12_;
	_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->mount_paths);
	self->mount_paths = _tmp13_;
	snapshot_repo_init_from_device (self);
	tee_jee_logging_log_debug ("SnapshotRepo: from_uuid(): exit");
	return self;
}

SnapshotRepo*
snapshot_repo_new_from_uuid (const gchar* uuid,
                             GtkWindow* parent_win,
                             gboolean btrfs_repo)
{
	return snapshot_repo_construct_from_uuid (TYPE_SNAPSHOT_REPO, uuid, parent_win, btrfs_repo);
}

SnapshotRepo*
snapshot_repo_construct_from_null (GType object_type)
{
	SnapshotRepo * self = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	self = (SnapshotRepo*) g_object_new (object_type, NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: from_null()");
	tee_jee_logging_log_debug ("device not set");
	_tmp0_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->snapshots);
	self->snapshots = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->invalid_snapshots);
	self->invalid_snapshots = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->mount_paths);
	self->mount_paths = _tmp2_;
	tee_jee_logging_log_debug ("SnapshotRepo: from_null(): exit");
	return self;
}

SnapshotRepo*
snapshot_repo_new_from_null (void)
{
	return snapshot_repo_construct_from_null (TYPE_SNAPSHOT_REPO);
}

static void
snapshot_repo_init_from_device (SnapshotRepo* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Device* _tmp2_;
	gboolean _tmp32_ = FALSE;
	Device* _tmp33_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: init_from_device()");
	_tmp2_ = self->device;
	if (_tmp2_ != NULL) {
		Device* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = self->device;
		_tmp4_ = _tmp3_->uuid;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ > 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Device* _tmp7_;
		const gchar* _tmp8_;
		Device* _tmp9_;
		Device* _tmp10_;
		_tmp7_ = self->device;
		_tmp8_ = _tmp7_->uuid;
		_tmp9_ = device_get_device_by_uuid (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp0_ = _tmp10_ != NULL;
		_g_object_unref0 (_tmp10_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp11_ = FALSE;
		Device* _tmp12_;
		tee_jee_logging_log_debug ("");
		snapshot_repo_unlock_and_mount_devices (self);
		_tmp12_ = self->device;
		if (_tmp12_ != NULL) {
			Device* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp13_ = self->device;
			_tmp14_ = _tmp13_->device;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp11_ = _tmp16_ > 0;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			Device* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			Device* _tmp23_;
			guint64 _tmp24_;
			guint64 _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp17_ = self->device;
			_tmp18_ = _tmp17_->device;
			_tmp19_ = g_strdup_printf (": %s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_ ("Selected snapshot device"), _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			tee_jee_logging_log_debug (_tmp22_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp23_ = self->device;
			_tmp24_ = device_get_free_bytes (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = tee_jee_file_system_format_file_size (_tmp25_, FALSE, "", TRUE, 1);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strdup_printf (": %s", _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat (_ ("Free space"), _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			tee_jee_logging_log_debug (_tmp31_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
		}
	}
	_tmp33_ = self->device;
	if (_tmp33_ != NULL) {
		Device* _tmp34_;
		const gchar* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		_tmp34_ = self->device;
		_tmp35_ = _tmp34_->device;
		_tmp36_ = strlen (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp32_ = _tmp37_ > 0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		snapshot_repo_check_status (self);
	}
	tee_jee_logging_log_debug ("SnapshotRepo: init_from_device(): exit");
}

gboolean
snapshot_repo_unlock_and_mount_devices (SnapshotRepo* self)
{
	Device* _tmp0_;
	Device* _tmp5_;
	Main* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	GeeHashMap* _tmp14_;
	GeeHashMap* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("SnapshotRepo: unlock_and_mount_devices()");
	_tmp0_ = self->device;
	if (_tmp0_ == NULL) {
		tee_jee_logging_log_debug ("device=null");
	} else {
		Device* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->device;
		_tmp2_ = _tmp1_->device;
		_tmp3_ = g_strdup_printf ("device=%s", _tmp2_);
		_tmp4_ = _tmp3_;
		tee_jee_logging_log_debug (_tmp4_);
		_g_free0 (_tmp4_);
	}
	_tmp5_ = self->device;
	_tmp6_ = App;
	_tmp7_ = _tmp6_->mount_point_app;
	_tmp8_ = g_strconcat (_tmp7_, "/backup", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = snapshot_repo_unlock_and_mount_device (self, _tmp5_, _tmp9_);
	_g_free0 (self->mount_path);
	self->mount_path = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = self->mount_path;
	_tmp12_ = strlen (_tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp14_ = self->mount_paths;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, "@", "");
	_tmp15_ = self->mount_paths;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "@home", "");
	if (self->btrfs_mode) {
		GeeHashMap* _tmp16_;
		const gchar* _tmp17_;
		GeeHashMap* _tmp18_;
		const gchar* _tmp19_;
		Device* _tmp20_;
		Device* _tmp21_;
		GeeHashMap* repo_subvolumes = NULL;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		GtkWindow* _tmp25_;
		GeeHashMap* _tmp26_;
		GeeHashMap* _tmp27_;
		GeeHashMap* _tmp28_;
		_tmp16_ = self->mount_paths;
		_tmp17_ = self->mount_path;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, "@", _tmp17_);
		_tmp18_ = self->mount_paths;
		_tmp19_ = self->mount_path;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, "@home", _tmp19_);
		_tmp20_ = self->device;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_g_object_unref0 (self->device_home);
		self->device_home = _tmp21_;
		_tmp22_ = self->mount_path;
		_tmp23_ = tee_jee_file_system_path_combine (_tmp22_, "@");
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->parent_window;
		_tmp26_ = subvolume_detect_subvolumes_for_system_by_path (_tmp24_, self, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp24_);
		repo_subvolumes = _tmp27_;
		_tmp28_ = repo_subvolumes;
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp28_, "@home")) {
			Subvolume* subvol = NULL;
			GeeHashMap* _tmp29_;
			gpointer _tmp30_;
			Subvolume* _tmp31_;
			const gchar* _tmp32_;
			Device* _tmp33_;
			const gchar* _tmp34_;
			_tmp29_ = repo_subvolumes;
			_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, "@home");
			subvol = (Subvolume*) _tmp30_;
			_tmp31_ = subvol;
			_tmp32_ = _tmp31_->device_uuid;
			_tmp33_ = self->device;
			_tmp34_ = _tmp33_->uuid;
			if (g_strcmp0 (_tmp32_, _tmp34_) != 0) {
				Subvolume* _tmp35_;
				Device* _tmp36_;
				GeeHashMap* _tmp37_;
				Device* _tmp38_;
				Main* _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				GeeHashMap* _tmp45_;
				gpointer _tmp46_;
				gchar* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gboolean _tmp50_;
				_tmp35_ = subvol;
				_tmp36_ = subvolume_get_device (_tmp35_);
				_g_object_unref0 (self->device_home);
				self->device_home = _tmp36_;
				_tmp37_ = self->mount_paths;
				_tmp38_ = self->device_home;
				_tmp39_ = App;
				_tmp40_ = _tmp39_->mount_point_app;
				_tmp41_ = g_strconcat (_tmp40_, "/backup-home", NULL);
				_tmp42_ = _tmp41_;
				_tmp43_ = snapshot_repo_unlock_and_mount_device (self, _tmp38_, _tmp42_);
				_tmp44_ = _tmp43_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp37_, "@home", _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_tmp45_ = self->mount_paths;
				_tmp46_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp45_, "@home");
				_tmp47_ = (gchar*) _tmp46_;
				_tmp48_ = strlen (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = _tmp49_ == 0;
				_g_free0 (_tmp47_);
				if (_tmp50_) {
					result = FALSE;
					_g_object_unref0 (subvol);
					_g_object_unref0 (repo_subvolumes);
					return result;
				}
			}
			_g_object_unref0 (subvol);
		}
		_g_object_unref0 (repo_subvolumes);
	}
	snapshot_repo_load_snapshots (self);
	tee_jee_logging_log_debug ("SnapshotRepo: unlock_and_mount_device(): exit");
	result = TRUE;
	return result;
}

gchar*
snapshot_repo_unlock_and_mount_device (SnapshotRepo* self,
                                       Device* device_to_mount,
                                       const gchar* path_to_mount)
{
	Device* dev = NULL;
	Device* _tmp0_;
	Device* _tmp1_;
	Device* _tmp6_;
	gchar* mount_options = NULL;
	gchar* _tmp13_;
	gboolean ok = FALSE;
	Device* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device_to_mount != NULL, NULL);
	g_return_val_if_fail (path_to_mount != NULL, NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: unlock_and_mount_device()");
	_tmp0_ = _g_object_ref0 (device_to_mount);
	dev = _tmp0_;
	_tmp1_ = dev;
	if (_tmp1_ == NULL) {
		tee_jee_logging_log_debug ("device=null");
	} else {
		Device* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = dev;
		_tmp3_ = _tmp2_->device;
		_tmp4_ = g_strdup_printf ("device=%s", _tmp3_);
		_tmp5_ = _tmp4_;
		tee_jee_logging_log_debug (_tmp5_);
		_g_free0 (_tmp5_);
	}
	_tmp6_ = dev;
	if (device_is_encrypted_partition (_tmp6_)) {
		Device* _tmp7_;
		Device* _tmp8_;
		Device* _tmp9_;
		Device* _tmp10_;
		Device* _tmp11_;
		_tmp7_ = dev;
		_tmp8_ = snapshot_repo_unlock_encrypted_device (self, _tmp7_);
		_g_object_unref0 (dev);
		dev = _tmp8_;
		_tmp9_ = dev;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (self->device);
		self->device = _tmp10_;
		_tmp11_ = dev;
		if (_tmp11_ == NULL) {
			gchar* _tmp12_;
			tee_jee_logging_log_debug ("device is null");
			tee_jee_logging_log_debug ("SnapshotRepo: unlock_and_mount_device(): exit");
			_tmp12_ = g_strdup ("");
			result = _tmp12_;
			_g_object_unref0 (dev);
			return result;
		}
	}
	_tmp13_ = g_strdup ("");
	mount_options = _tmp13_;
	if (self->btrfs_mode) {
		gchar* _tmp14_;
		_tmp14_ = g_strdup ("subvolid=0");
		_g_free0 (mount_options);
		mount_options = _tmp14_;
	}
	_tmp15_ = dev;
	_tmp16_ = _tmp15_->uuid;
	_tmp17_ = mount_options;
	ok = device_mount (_tmp16_, path_to_mount, _tmp17_, FALSE);
	if (ok) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup (path_to_mount);
		result = _tmp18_;
		_g_free0 (mount_options);
		_g_object_unref0 (dev);
		return result;
	} else {
		gchar* _tmp19_;
		_tmp19_ = g_strdup ("");
		result = _tmp19_;
		_g_free0 (mount_options);
		_g_object_unref0 (dev);
		return result;
	}
}

Device*
snapshot_repo_unlock_encrypted_device (SnapshotRepo* self,
                                       Device* luks_device)
{
	gchar* msg_out = NULL;
	gchar* msg_err = NULL;
	Device* luks_unlocked = NULL;
	GtkWindow* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Device* _tmp6_;
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (luks_device != NULL, NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: unlock_encrypted_device()");
	if (luks_device == NULL) {
		tee_jee_logging_log_debug ("luks_device=null");
		result = NULL;
		return result;
	} else {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = luks_device->device;
		_tmp1_ = g_strdup_printf ("luks_device=%s", _tmp0_);
		_tmp2_ = _tmp1_;
		tee_jee_logging_log_debug (_tmp2_);
		_g_free0 (_tmp2_);
	}
	_tmp3_ = self->priv->parent_window;
	_tmp6_ = device_luks_unlock (luks_device, "", "", _tmp3_, &_tmp4_, &_tmp5_);
	_g_free0 (msg_out);
	msg_out = _tmp4_;
	_g_free0 (msg_err);
	msg_err = _tmp5_;
	luks_unlocked = _tmp6_;
	result = luks_unlocked;
	_g_free0 (msg_err);
	_g_free0 (msg_out);
	return result;
}

static gint
__lambda12_ (SnapshotRepo* self,
             Snapshot* a,
             Snapshot* b)
{
	Snapshot* t1 = NULL;
	Snapshot* _tmp0_;
	Snapshot* t2 = NULL;
	Snapshot* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SNAPSHOT, Snapshot));
	t1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SNAPSHOT, Snapshot));
	t2 = _tmp1_;
	_tmp2_ = t1->date;
	_tmp3_ = t2->date;
	result = g_date_time_compare (_tmp2_, _tmp3_);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gint
___lambda12__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda12_ ((SnapshotRepo*) self, (Snapshot*) a, (Snapshot*) b);
	return result;
}

gboolean
snapshot_repo_load_snapshots (SnapshotRepo* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	Device* _tmp3_;
	GeeArrayList* _tmp43_;
	GDateTime* dt_boot = NULL;
	GDateTime* _tmp44_;
	GDateTime* _tmp45_;
	GDateTime* _tmp46_;
	gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	GeeArrayList* _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("SnapshotRepo: load_snapshots()");
	_tmp0_ = self->snapshots;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->invalid_snapshots;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = self->device;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = snapshot_repo_get_snapshots_path (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp2_ = !tee_jee_file_system_dir_exists (_tmp6_);
		_g_free0 (_tmp6_);
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	{
		GFile* dir = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp12_;
		GFileEnumerator* _tmp13_;
		GFileInfo* info = NULL;
		GFileEnumerator* _tmp14_;
		GFileInfo* _tmp15_;
		_tmp7_ = snapshot_repo_get_snapshots_path (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp10_ = g_file_new_for_path (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		dir = _tmp11_;
		_tmp12_ = dir;
		_tmp13_ = g_file_enumerate_children (_tmp12_, "*", 0, NULL, &_inner_error0_);
		enumerator = _tmp13_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		_tmp14_ = enumerator;
		_tmp15_ = g_file_enumerator_next_file (_tmp14_, NULL, &_inner_error0_);
		info = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp16_;
			GFileInfo* _tmp17_;
			GFileInfo* _tmp36_ = NULL;
			GFileEnumerator* _tmp37_;
			GFileInfo* _tmp38_;
			GFileInfo* _tmp39_;
			_tmp16_ = info;
			if (!(_tmp16_ != NULL)) {
				break;
			}
			_tmp17_ = info;
			if (g_file_info_get_file_type (_tmp17_) == G_FILE_TYPE_DIRECTORY) {
				GFileInfo* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = info;
				_tmp19_ = g_file_info_get_name (_tmp18_);
				if (g_strcmp0 (_tmp19_, ".sync") != 0) {
					Snapshot* bak = NULL;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					GFileInfo* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					gchar* _tmp28_;
					Snapshot* _tmp29_;
					Snapshot* _tmp30_;
					Snapshot* _tmp31_;
					_tmp20_ = snapshot_repo_get_snapshots_path (self);
					_tmp21_ = _tmp20_;
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp22_, "/", NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = info;
					_tmp26_ = g_file_info_get_name (_tmp25_);
					_tmp27_ = g_strconcat (_tmp24_, _tmp26_, NULL);
					_tmp28_ = _tmp27_;
					_tmp29_ = snapshot_new (_tmp28_, self->btrfs_mode, self);
					_tmp30_ = _tmp29_;
					_g_free0 (_tmp28_);
					_g_free0 (_tmp24_);
					_g_free0 (_tmp22_);
					bak = _tmp30_;
					_tmp31_ = bak;
					if (_tmp31_->valid) {
						GeeArrayList* _tmp32_;
						Snapshot* _tmp33_;
						_tmp32_ = self->snapshots;
						_tmp33_ = bak;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp33_);
					} else {
						GeeArrayList* _tmp34_;
						Snapshot* _tmp35_;
						_tmp34_ = self->invalid_snapshots;
						_tmp35_ = bak;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
					}
					_g_object_unref0 (bak);
				}
			}
			_tmp37_ = enumerator;
			_tmp38_ = g_file_enumerator_next_file (_tmp37_, NULL, &_inner_error0_);
			_tmp36_ = _tmp38_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (dir);
				goto __catch0_g_error;
			}
			_tmp39_ = _tmp36_;
			_tmp36_ = NULL;
			_g_object_unref0 (info);
			info = _tmp39_;
			_g_object_unref0 (_tmp36_);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		tee_jee_logging_log_error (_tmp41_, FALSE, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp42_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp42_;
	}
	_tmp43_ = self->snapshots;
	gee_list_sort ((GeeList*) _tmp43_, ___lambda12__gcompare_data_func, g_object_ref (self), g_object_unref);
	_tmp44_ = g_date_time_new_now_local ();
	dt_boot = _tmp44_;
	_tmp45_ = dt_boot;
	_tmp46_ = g_date_time_add_seconds (_tmp45_, (-1.0) * tee_jee_system_get_system_uptime_seconds ());
	_g_date_time_unref0 (dt_boot);
	dt_boot = _tmp46_;
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp47_;
		gint _bak_size = 0;
		GeeArrayList* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _bak_index = 0;
		_tmp47_ = self->snapshots;
		_bak_list = _tmp47_;
		_tmp48_ = _bak_list;
		_tmp49_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_bak_size = _tmp50_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp51_;
			gint _tmp52_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp53_;
			gpointer _tmp54_;
			Snapshot* _tmp55_;
			_bak_index = _bak_index + 1;
			_tmp51_ = _bak_index;
			_tmp52_ = _bak_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _bak_list;
			_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, _bak_index);
			bak = (Snapshot*) _tmp54_;
			_tmp55_ = bak;
			if (_tmp55_->live) {
				gboolean _tmp56_ = FALSE;
				Main* _tmp57_;
				Device* _tmp58_;
				_tmp57_ = App;
				_tmp58_ = _tmp57_->sys_root;
				if (_tmp58_ == NULL) {
					_tmp56_ = TRUE;
				} else {
					Main* _tmp59_;
					Device* _tmp60_;
					const gchar* _tmp61_;
					Snapshot* _tmp62_;
					const gchar* _tmp63_;
					_tmp59_ = App;
					_tmp60_ = _tmp59_->sys_root;
					_tmp61_ = _tmp60_->uuid;
					_tmp62_ = bak;
					_tmp63_ = _tmp62_->sys_uuid;
					_tmp56_ = g_strcmp0 (_tmp61_, _tmp63_) != 0;
				}
				if (_tmp56_) {
					Snapshot* _tmp64_;
					Snapshot* _tmp65_;
					_tmp64_ = bak;
					_tmp64_->live = FALSE;
					_tmp65_ = bak;
					snapshot_update_control_file (_tmp65_);
				} else {
					Snapshot* _tmp66_;
					GDateTime* _tmp67_;
					GDateTime* _tmp68_;
					_tmp66_ = bak;
					_tmp67_ = _tmp66_->date;
					_tmp68_ = dt_boot;
					if (g_date_time_difference (_tmp67_, _tmp68_) < ((GTimeSpan) 0)) {
						Snapshot* _tmp69_;
						Snapshot* _tmp70_;
						_tmp69_ = bak;
						_tmp69_->live = FALSE;
						_tmp70_ = bak;
						snapshot_update_control_file (_tmp70_);
					} else {
					}
				}
			}
			_g_object_unref0 (bak);
		}
	}
	if (self->btrfs_mode) {
		Main* _tmp71_;
		_tmp71_ = App;
		main_query_subvolume_info (_tmp71_, self);
	}
	_tmp72_ = snapshot_repo_get_snapshots_path (self);
	_tmp73_ = _tmp72_;
	_tmp74_ = _tmp73_;
	_tmp75_ = self->snapshots;
	_tmp76_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strdup_printf ("loading snapshots from '%s': %d found", _tmp74_, _tmp77_);
	_tmp79_ = _tmp78_;
	tee_jee_logging_log_debug (_tmp79_);
	_g_free0 (_tmp79_);
	_g_free0 (_tmp74_);
	result = TRUE;
	_g_date_time_unref0 (dt_boot);
	return result;
}

static gint
__lambda14_ (SnapshotRepo* self,
             Snapshot* a,
             Snapshot* b)
{
	Snapshot* t1 = NULL;
	Snapshot* _tmp0_;
	Snapshot* t2 = NULL;
	Snapshot* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gint result;
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_SNAPSHOT, Snapshot));
	t1 = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_SNAPSHOT, Snapshot));
	t2 = _tmp1_;
	_tmp2_ = t1->date;
	_tmp3_ = t2->date;
	result = g_date_time_compare (_tmp2_, _tmp3_);
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}

static gint
___lambda14__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda14_ ((SnapshotRepo*) self, (Snapshot*) a, (Snapshot*) b);
	return result;
}

GeeArrayList*
snapshot_repo_get_snapshots_by_tag (SnapshotRepo* self,
                                    const gchar* tag)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp17_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp1_;
		gint _bak_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _bak_index = 0;
		_tmp1_ = self->snapshots;
		_bak_list = _tmp1_;
		_tmp2_ = _bak_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_bak_size = _tmp4_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			Snapshot* _tmp11_;
			_bak_index = _bak_index + 1;
			_tmp5_ = _bak_index;
			_tmp6_ = _bak_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _bak_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _bak_index);
			bak = (Snapshot*) _tmp8_;
			_tmp11_ = bak;
			if (_tmp11_->valid) {
				gint _tmp12_;
				gint _tmp13_;
				_tmp12_ = strlen (tag);
				_tmp13_ = _tmp12_;
				_tmp10_ = _tmp13_ == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				Snapshot* _tmp14_;
				_tmp14_ = bak;
				_tmp9_ = snapshot_has_tag (_tmp14_, tag);
			}
			if (_tmp9_) {
				GeeArrayList* _tmp15_;
				Snapshot* _tmp16_;
				_tmp15_ = list;
				_tmp16_ = bak;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp16_);
			}
			_g_object_unref0 (bak);
		}
	}
	_tmp17_ = list;
	gee_list_sort ((GeeList*) _tmp17_, ___lambda14__gcompare_data_func, g_object_ref (self), g_object_unref);
	result = list;
	return result;
}

Snapshot*
snapshot_repo_get_latest_snapshot (SnapshotRepo* self,
                                   const gchar* tag,
                                   const gchar* sys_uuid)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	Snapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (sys_uuid != NULL, NULL);
	_tmp0_ = snapshot_repo_get_snapshots_by_tag (self, tag);
	list = _tmp0_;
	{
		gint i = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				Snapshot* bak = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				Snapshot* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, i);
				bak = (Snapshot*) _tmp7_;
				_tmp8_ = bak;
				_tmp9_ = _tmp8_->sys_uuid;
				if (g_strcmp0 (_tmp9_, sys_uuid) == 0) {
					result = bak;
					_g_object_unref0 (list);
					return result;
				}
				_g_object_unref0 (bak);
			}
		}
	}
	result = NULL;
	_g_object_unref0 (list);
	return result;
}

Snapshot*
snapshot_repo_get_oldest_snapshot (SnapshotRepo* self,
                                   const gchar* tag,
                                   const gchar* sys_uuid)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	Snapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (sys_uuid != NULL, NULL);
	_tmp0_ = snapshot_repo_get_snapshots_by_tag (self, tag);
	list = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeArrayList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				Snapshot* bak = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				Snapshot* _tmp8_;
				const gchar* _tmp9_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = list;
				_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, i);
				bak = (Snapshot*) _tmp7_;
				_tmp8_ = bak;
				_tmp9_ = _tmp8_->sys_uuid;
				if (g_strcmp0 (_tmp9_, sys_uuid) == 0) {
					result = bak;
					_g_object_unref0 (list);
					return result;
				}
				_g_object_unref0 (bak);
			}
		}
	}
	result = NULL;
	_g_object_unref0 (list);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

void
snapshot_repo_check_status (SnapshotRepo* self)
{
	gboolean _tmp2_ = FALSE;
	Main* _tmp3_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: check_status()");
	if (!self->last_snapshot_failed_space) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		self->status_code = SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE;
		_tmp0_ = g_strdup ("");
		_g_free0 (self->status_message);
		self->status_message = _tmp0_;
		_tmp1_ = g_strdup ("");
		_g_free0 (self->status_details);
		self->status_details = _tmp1_;
	}
	if (snapshot_repo_available (self)) {
		snapshot_repo_has_snapshots (self);
		if (!self->last_snapshot_failed_space) {
			snapshot_repo_has_space (self, (guint64) 0);
		}
	}
	_tmp3_ = App;
	if (_tmp3_ != NULL) {
		Main* _tmp4_;
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = App;
		_tmp5_ = _tmp4_->app_mode;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp8_ = NULL;
		Device* _tmp9_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		GEnumValue* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp9_ = self->device;
		if (_tmp9_ == NULL) {
			_tmp8_ = " UNKNOWN";
		} else {
			Device* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = self->device;
			_tmp11_ = _tmp10_->device;
			_tmp8_ = _tmp11_;
		}
		_tmp12_ = g_strdup_printf ("%s: '%s'", _ ("Snapshot device"), _tmp8_);
		_tmp13_ = _tmp12_;
		tee_jee_logging_log_debug (_tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = self->mount_path;
		_tmp15_ = g_strdup_printf ("%s: %s", _ ("Snapshot location"), _tmp14_);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_debug (_tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = self->status_message;
		tee_jee_logging_log_debug (_tmp17_);
		_tmp18_ = self->status_details;
		tee_jee_logging_log_debug (_tmp18_);
		_tmp19_ = g_enum_get_value (g_type_class_ref (TYPE_SNAPSHOT_LOCATION_STATUS), self->status_code);
		_tmp20_ = string_replace ((_tmp19_ != NULL) ? _tmp19_->value_name : NULL, "SNAPSHOT_LOCATION_STATUS_", "");
		_tmp21_ = _tmp20_;
		_tmp22_ = g_strdup_printf ("%s: %s", _ ("Status"), _tmp21_);
		_tmp23_ = _tmp22_;
		tee_jee_logging_log_debug (_tmp23_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp21_);
		tee_jee_logging_log_debug ("");
	}
	self->last_snapshot_failed_space = FALSE;
	tee_jee_logging_log_debug ("SnapshotRepo: check_status(): exit");
}

gboolean
snapshot_repo_available (SnapshotRepo* self)
{
	Device* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("SnapshotRepo: available()");
	_tmp0_ = self->device;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		Main* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = App;
		_tmp3_ = _tmp2_->backup_uuid;
		if (_tmp3_ == NULL) {
			_tmp1_ = TRUE;
		} else {
			Main* _tmp4_;
			const gchar* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp4_ = App;
			_tmp5_ = _tmp4_->backup_uuid;
			_tmp6_ = strlen (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = _tmp7_ == 0;
		}
		if (_tmp1_) {
			gchar* _tmp8_;
			gchar* _tmp9_;
			tee_jee_logging_log_debug ("device is null");
			_tmp8_ = g_strdup (_ ("Snapshot device not selected"));
			_g_free0 (self->status_message);
			self->status_message = _tmp8_;
			_tmp9_ = g_strdup (_ ("Select the snapshot device"));
			_g_free0 (self->status_details);
			self->status_details = _tmp9_;
			self->status_code = SNAPSHOT_LOCATION_STATUS_NOT_SELECTED;
			tee_jee_logging_log_debug ("is_available: false");
			result = FALSE;
			return result;
		} else {
			gchar* _tmp10_;
			Main* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = g_strdup (_ ("Snapshot device not available"));
			_g_free0 (self->status_message);
			self->status_message = _tmp10_;
			_tmp11_ = App;
			_tmp12_ = _tmp11_->backup_uuid;
			_tmp13_ = g_strdup_printf (": UUID='%s'", _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_ ("Device not found"), _tmp14_, NULL);
			_g_free0 (self->status_details);
			self->status_details = _tmp15_;
			_g_free0 (_tmp14_);
			self->status_code = SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE;
			tee_jee_logging_log_debug ("is_available: false");
			result = FALSE;
			return result;
		}
	} else {
		if (self->btrfs_mode) {
			gboolean ok = FALSE;
			ok = snapshot_repo_has_btrfs_system (self);
			if (ok) {
				tee_jee_logging_log_debug ("is_available: ok");
			}
			result = ok;
			return result;
		} else {
			tee_jee_logging_log_debug ("is_available: ok");
			result = TRUE;
			return result;
		}
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

gboolean
snapshot_repo_has_btrfs_system (SnapshotRepo* self)
{
	gchar* root_path = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("SnapshotRepo: has_btrfs_system()");
	_tmp0_ = self->mount_paths;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, "@");
	_tmp2_ = (gchar*) _tmp1_;
	_tmp3_ = tee_jee_file_system_path_combine (_tmp2_, "@");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	root_path = _tmp4_;
	_tmp5_ = root_path;
	_tmp6_ = g_strdup_printf ("root_path=%s", _tmp5_);
	_tmp7_ = _tmp6_;
	tee_jee_logging_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = bool_to_string (self->btrfs_mode);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strdup_printf ("btrfs_mode=%s", _tmp9_);
	_tmp11_ = _tmp10_;
	tee_jee_logging_log_debug (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	if (self->btrfs_mode) {
		const gchar* _tmp12_;
		_tmp12_ = root_path;
		if (!tee_jee_file_system_dir_exists (_tmp12_)) {
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp13_ = g_strdup (_ ("Selected snapshot device is not a system disk"));
			_g_free0 (self->status_message);
			self->status_message = _tmp13_;
			_tmp14_ = g_strdup (_ ("Select BTRFS system disk with root subvolume (@)"));
			_g_free0 (self->status_details);
			self->status_details = _tmp14_;
			self->status_code = SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM;
			_tmp15_ = self->status_message;
			tee_jee_logging_log_debug (_tmp15_);
			result = FALSE;
			_g_free0 (root_path);
			return result;
		}
	}
	result = TRUE;
	_g_free0 (root_path);
	return result;
}

gboolean
snapshot_repo_has_snapshots (SnapshotRepo* self)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("SnapshotRepo: has_snapshots()");
	_tmp0_ = self->snapshots;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ > 0;
	return result;
}

gboolean
snapshot_repo_has_space (SnapshotRepo* self,
                         guint64 needed)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Device* _tmp5_;
	GeeArrayList* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tee_jee_file_system_format_file_size (needed, FALSE, "", TRUE, 1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("SnapshotRepo: has_space() - %llu required (%s)", needed, _tmp1_);
	_tmp3_ = _tmp2_;
	tee_jee_logging_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp5_ = self->device;
	if (_tmp5_ != NULL) {
		Device* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = self->device;
		_tmp7_ = _tmp6_->device;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp4_ = _tmp9_ > 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Device* _tmp10_;
		_tmp10_ = self->device;
		device_query_disk_space (_tmp10_);
	} else {
		tee_jee_logging_log_debug ("device is NULL");
		result = FALSE;
		return result;
	}
	_tmp11_ = self->snapshots;
	_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
	_tmp13_ = _tmp12_;
	if (_tmp13_ > 0) {
		guint64 _tmp14_ = 0ULL;
		Device* _tmp15_;
		guint64 _tmp16_;
		guint64 _tmp17_;
		if (needed > ((guint64) 0)) {
			_tmp14_ = needed;
		} else {
			_tmp14_ = MAIN_MIN_FREE_SPACE;
		}
		_tmp15_ = self->device;
		_tmp16_ = device_get_free_bytes (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ < _tmp14_) {
			gchar* _tmp18_;
			guint64 _tmp19_ = 0ULL;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp18_ = g_strdup (_ ("Not enough disk space"));
			_g_free0 (self->status_message);
			self->status_message = _tmp18_;
			if (needed > ((guint64) 0)) {
				_tmp19_ = needed;
			} else {
				_tmp19_ = MAIN_MIN_FREE_SPACE;
			}
			_tmp20_ = self->status_message;
			_tmp21_ = tee_jee_file_system_format_file_size (_tmp19_, FALSE, "", TRUE, 0);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strdup_printf (" (< %s)", _tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp20_, _tmp24_, NULL);
			_g_free0 (self->status_message);
			self->status_message = _tmp25_;
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			_tmp26_ = g_strdup (_ ("Select another device or free up some space"));
			_g_free0 (self->status_details);
			self->status_details = _tmp26_;
			self->status_code = SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE;
			self->last_snapshot_failed_space = TRUE;
			result = FALSE;
			return result;
		} else {
			gchar* _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			Device* _tmp31_;
			guint64 _tmp32_;
			guint64 _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp27_ = g_strdup (_ ("OK"));
			_g_free0 (self->status_message);
			self->status_message = _tmp27_;
			_tmp28_ = self->snapshots;
			_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = self->device;
			_tmp32_ = device_get_free_bytes (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = tee_jee_file_system_format_file_size (_tmp33_, FALSE, "", TRUE, 1);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf (_ ("%d snapshots, %s free"), _tmp30_, _tmp35_);
			_g_free0 (self->status_details);
			self->status_details = _tmp36_;
			_g_free0 (_tmp35_);
			self->last_snapshot_failed_space = FALSE;
			self->status_code = SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE;
			result = TRUE;
			return result;
		}
	} else {
		guint64 required_space = 0ULL;
		Device* _tmp37_;
		guint64 _tmp38_;
		guint64 _tmp39_;
		tee_jee_logging_log_debug ("no snapshots");
		required_space = main_first_snapshot_size;
		_tmp37_ = self->device;
		_tmp38_ = device_get_free_bytes (_tmp37_);
		_tmp39_ = _tmp38_;
		if (_tmp39_ < required_space) {
			gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp40_ = g_strdup (_ ("Not enough disk space"));
			_g_free0 (self->status_message);
			self->status_message = _tmp40_;
			_tmp41_ = self->status_message;
			_tmp42_ = tee_jee_file_system_format_file_size (required_space, FALSE, "", TRUE, 1);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strdup_printf (" (< %s)", _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strconcat (_tmp41_, _tmp45_, NULL);
			_g_free0 (self->status_message);
			self->status_message = _tmp46_;
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_tmp47_ = g_strdup (_ ("Select another device or free up some space"));
			_g_free0 (self->status_details);
			self->status_details = _tmp47_;
			self->status_code = SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE;
			result = FALSE;
			return result;
		} else {
			gchar* _tmp48_;
			gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp48_ = g_strdup (_ ("No snapshots on this device"));
			_g_free0 (self->status_message);
			self->status_message = _tmp48_;
			_tmp49_ = g_strdup (_ ("First snapshot requires:"));
			_g_free0 (self->status_details);
			self->status_details = _tmp49_;
			_tmp50_ = self->status_details;
			_tmp51_ = tee_jee_file_system_format_file_size (required_space, FALSE, "", TRUE, 1);
			_tmp52_ = _tmp51_;
			_tmp53_ = g_strdup_printf (" %s", _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat (_tmp50_, _tmp54_, NULL);
			_g_free0 (self->status_details);
			self->status_details = _tmp55_;
			_g_free0 (_tmp54_);
			_g_free0 (_tmp52_);
			self->status_code = SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE;
			result = TRUE;
			return result;
		}
	}
}

void
snapshot_repo_print_status (SnapshotRepo* self)
{
	Device* _tmp0_;
	g_return_if_fail (self != NULL);
	snapshot_repo_check_status (self);
	_tmp0_ = self->device;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_strdup_printf ("%-6s : %s", _ ("Device"), _ ("Not Selected"));
		_tmp2_ = _tmp1_;
		tee_jee_logging_log_msg (_tmp2_, FALSE);
		_g_free0 (_tmp2_);
	} else {
		Device* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		Device* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp3_ = self->device;
		_tmp4_ = device_get_device_name_with_parent (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("%-6s : %s", _ ("Device"), _tmp6_);
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_msg (_tmp8_, FALSE);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_tmp9_ = self->device;
		_tmp10_ = _tmp9_->uuid;
		_tmp11_ = g_strdup_printf ("%-6s : %s", "UUID", _tmp10_);
		_tmp12_ = _tmp11_;
		tee_jee_logging_log_msg (_tmp12_, FALSE);
		_g_free0 (_tmp12_);
		_tmp13_ = self->mount_path;
		_tmp14_ = g_strdup_printf ("%-6s : %s", _ ("Path"), _tmp13_);
		_tmp15_ = _tmp14_;
		tee_jee_logging_log_msg (_tmp15_, FALSE);
		_g_free0 (_tmp15_);
		if (self->btrfs_mode) {
			_tmp16_ = "BTRFS";
		} else {
			_tmp16_ = "RSYNC";
		}
		_tmp17_ = g_strdup_printf ("%-6s : %s", _ ("Mode"), _tmp16_);
		_tmp18_ = _tmp17_;
		tee_jee_logging_log_msg (_tmp18_, FALSE);
		_g_free0 (_tmp18_);
		_tmp19_ = self->status_message;
		_tmp20_ = g_strdup_printf ("%-6s : %s", _ ("Status"), _tmp19_);
		_tmp21_ = _tmp20_;
		tee_jee_logging_log_msg (_tmp21_, FALSE);
		_g_free0 (_tmp21_);
		_tmp22_ = self->status_details;
		tee_jee_logging_log_msg (_tmp22_, FALSE);
	}
	tee_jee_logging_log_msg ("", FALSE);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

void
snapshot_repo_auto_remove (SnapshotRepo* self)
{
	GDateTime* now = NULL;
	GDateTime* _tmp0_;
	GDateTime* dt_limit = NULL;
	gint count_limit = 0;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	Main* _tmp5_;
	gchar** levels = NULL;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar** _tmp36_;
	gint levels_length1;
	gint _levels_size_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: auto_remove()");
	self->last_snapshot_failed_space = FALSE;
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = snapshot_repo_get_snapshots_by_tag (self, "boot");
	list = _tmp1_;
	_tmp2_ = list;
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = App;
	if (_tmp4_ > _tmp5_->count_boot) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = g_strdup_printf (" '%s'", "boot");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_ ("Maximum backups exceeded for backup level"), _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		tee_jee_logging_log_msg (_tmp9_, FALSE);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		while (TRUE) {
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			Main* _tmp13_;
			GeeArrayList* _tmp14_;
			gpointer _tmp15_;
			Snapshot* _tmp16_;
			GeeArrayList* _tmp17_;
			gpointer _tmp18_;
			Snapshot* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			GeeArrayList* _tmp31_;
			_tmp10_ = list;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = App;
			if (!(_tmp12_ > _tmp13_->count_boot)) {
				break;
			}
			_tmp14_ = list;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, 0);
			_tmp16_ = (Snapshot*) _tmp15_;
			snapshot_remove_tag (_tmp16_, "boot");
			_g_object_unref0 (_tmp16_);
			_tmp17_ = list;
			_tmp18_ = gee_abstract_list_get ((GeeAbstractList*) _tmp17_, 0);
			_tmp19_ = (Snapshot*) _tmp18_;
			_tmp20_ = _tmp19_->name;
			_tmp21_ = g_strdup_printf (" '%s' ", _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_ ("Snapshot"), _tmp22_, NULL);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp24_, _ ("un-tagged"), NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf (" '%s'", "boot");
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp26_, _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			tee_jee_logging_log_msg (_tmp30_, FALSE);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			_g_object_unref0 (_tmp19_);
			_tmp31_ = snapshot_repo_get_snapshots_by_tag (self, "boot");
			_g_object_unref0 (list);
			list = _tmp31_;
		}
	}
	_tmp32_ = g_strdup ("hourly");
	_tmp33_ = g_strdup ("daily");
	_tmp34_ = g_strdup ("weekly");
	_tmp35_ = g_strdup ("monthly");
	_tmp36_ = g_new0 (gchar*, 4 + 1);
	_tmp36_[0] = _tmp32_;
	_tmp36_[1] = _tmp33_;
	_tmp36_[2] = _tmp34_;
	_tmp36_[3] = _tmp35_;
	levels = _tmp36_;
	levels_length1 = 4;
	_levels_size_ = levels_length1;
	_tmp37_ = levels;
	_tmp37__length1 = levels_length1;
	{
		gchar** level_collection = NULL;
		gint level_collection_length1 = 0;
		gint _level_collection_size_ = 0;
		gint level_it = 0;
		level_collection = _tmp37_;
		level_collection_length1 = _tmp37__length1;
		for (level_it = 0; level_it < level_collection_length1; level_it = level_it + 1) {
			gchar* _tmp38_;
			gchar* level = NULL;
			_tmp38_ = g_strdup (level_collection[level_it]);
			level = _tmp38_;
			{
				const gchar* _tmp39_;
				GeeArrayList* _tmp40_;
				GeeArrayList* _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				GQuark _tmp47_ = 0U;
				static GQuark _tmp46_label0 = 0;
				static GQuark _tmp46_label1 = 0;
				static GQuark _tmp46_label2 = 0;
				static GQuark _tmp46_label3 = 0;
				GeeArrayList* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				_tmp39_ = level;
				_tmp40_ = snapshot_repo_get_snapshots_by_tag (self, _tmp39_);
				_g_object_unref0 (list);
				list = _tmp40_;
				_tmp41_ = list;
				_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
				_tmp43_ = _tmp42_;
				if (_tmp43_ == 0) {
					_g_free0 (level);
					continue;
				}
				_tmp44_ = level;
				_tmp45_ = _tmp44_;
				_tmp47_ = (NULL == _tmp45_) ? 0 : g_quark_from_string (_tmp45_);
				if (_tmp47_ == ((0 != _tmp46_label0) ? _tmp46_label0 : (_tmp46_label0 = g_quark_from_static_string ("hourly")))) {
					switch (0) {
						default:
						{
							GDateTime* _tmp48_;
							Main* _tmp49_;
							GDateTime* _tmp50_;
							Main* _tmp51_;
							_tmp48_ = now;
							_tmp49_ = App;
							_tmp50_ = g_date_time_add_hours (_tmp48_, -1 * _tmp49_->count_hourly);
							_g_date_time_unref0 (dt_limit);
							dt_limit = _tmp50_;
							_tmp51_ = App;
							count_limit = _tmp51_->count_hourly;
							break;
						}
					}
				} else if (_tmp47_ == ((0 != _tmp46_label1) ? _tmp46_label1 : (_tmp46_label1 = g_quark_from_static_string ("daily")))) {
					switch (0) {
						default:
						{
							GDateTime* _tmp52_;
							Main* _tmp53_;
							GDateTime* _tmp54_;
							Main* _tmp55_;
							_tmp52_ = now;
							_tmp53_ = App;
							_tmp54_ = g_date_time_add_days (_tmp52_, -1 * _tmp53_->count_daily);
							_g_date_time_unref0 (dt_limit);
							dt_limit = _tmp54_;
							_tmp55_ = App;
							count_limit = _tmp55_->count_daily;
							break;
						}
					}
				} else if (_tmp47_ == ((0 != _tmp46_label2) ? _tmp46_label2 : (_tmp46_label2 = g_quark_from_static_string ("weekly")))) {
					switch (0) {
						default:
						{
							GDateTime* _tmp56_;
							Main* _tmp57_;
							GDateTime* _tmp58_;
							Main* _tmp59_;
							_tmp56_ = now;
							_tmp57_ = App;
							_tmp58_ = g_date_time_add_weeks (_tmp56_, -1 * _tmp57_->count_weekly);
							_g_date_time_unref0 (dt_limit);
							dt_limit = _tmp58_;
							_tmp59_ = App;
							count_limit = _tmp59_->count_weekly;
							break;
						}
					}
				} else if (_tmp47_ == ((0 != _tmp46_label3) ? _tmp46_label3 : (_tmp46_label3 = g_quark_from_static_string ("monthly")))) {
					switch (0) {
						default:
						{
							GDateTime* _tmp60_;
							Main* _tmp61_;
							GDateTime* _tmp62_;
							Main* _tmp63_;
							_tmp60_ = now;
							_tmp61_ = App;
							_tmp62_ = g_date_time_add_months (_tmp60_, -1 * _tmp61_->count_monthly);
							_g_date_time_unref0 (dt_limit);
							dt_limit = _tmp62_;
							_tmp63_ = App;
							count_limit = _tmp63_->count_monthly;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							GDateTime* _tmp64_;
							GDateTime* _tmp65_;
							_tmp64_ = now;
							_tmp65_ = g_date_time_add_years (_tmp64_, -1 * 10);
							_g_date_time_unref0 (dt_limit);
							dt_limit = _tmp65_;
							count_limit = 100000;
							break;
						}
					}
				}
				_tmp66_ = list;
				_tmp67_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp66_);
				_tmp68_ = _tmp67_;
				if (_tmp68_ > count_limit) {
					const gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					gint snaps_count = 0;
					GeeArrayList* _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					_tmp69_ = level;
					_tmp70_ = g_strdup_printf (" '%s'", _tmp69_);
					_tmp71_ = _tmp70_;
					_tmp72_ = g_strconcat (_ ("Maximum backups exceeded for backup level"), _tmp71_, NULL);
					_tmp73_ = _tmp72_;
					tee_jee_logging_log_msg (_tmp73_, FALSE);
					_g_free0 (_tmp73_);
					_g_free0 (_tmp71_);
					_tmp74_ = list;
					_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
					_tmp76_ = _tmp75_;
					snaps_count = _tmp76_;
					{
						GeeArrayList* _snap_list = NULL;
						GeeArrayList* _tmp77_;
						gint _snap_size = 0;
						GeeArrayList* _tmp78_;
						gint _tmp79_;
						gint _tmp80_;
						gint _snap_index = 0;
						_tmp77_ = list;
						_snap_list = _tmp77_;
						_tmp78_ = _snap_list;
						_tmp79_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp78_);
						_tmp80_ = _tmp79_;
						_snap_size = _tmp80_;
						_snap_index = -1;
						while (TRUE) {
							gint _tmp81_;
							gint _tmp82_;
							Snapshot* snap = NULL;
							GeeArrayList* _tmp83_;
							gpointer _tmp84_;
							Snapshot* _tmp85_;
							const gchar* _tmp86_;
							gchar* _tmp87_;
							gchar* _tmp88_;
							gint _tmp89_;
							gint _tmp90_;
							gboolean _tmp91_;
							gboolean _tmp92_ = FALSE;
							Snapshot* _tmp93_;
							GDateTime* _tmp94_;
							GDateTime* _tmp95_;
							_snap_index = _snap_index + 1;
							_tmp81_ = _snap_index;
							_tmp82_ = _snap_size;
							if (!(_tmp81_ < _tmp82_)) {
								break;
							}
							_tmp83_ = _snap_list;
							_tmp84_ = gee_abstract_list_get ((GeeAbstractList*) _tmp83_, _snap_index);
							snap = (Snapshot*) _tmp84_;
							_tmp85_ = snap;
							_tmp86_ = _tmp85_->description;
							_tmp87_ = string_strip (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = strlen (_tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = _tmp90_ > 0;
							_g_free0 (_tmp88_);
							if (_tmp91_) {
								_g_object_unref0 (snap);
								continue;
							}
							_tmp93_ = snap;
							_tmp94_ = _tmp93_->date;
							_tmp95_ = dt_limit;
							if (g_date_time_compare (_tmp94_, _tmp95_) < 0) {
								_tmp92_ = snaps_count > count_limit;
							} else {
								_tmp92_ = FALSE;
							}
							if (_tmp92_) {
								Snapshot* _tmp96_;
								const gchar* _tmp97_;
								gint _tmp98_;
								GeeArrayList* _tmp99_;
								gpointer _tmp100_;
								Snapshot* _tmp101_;
								const gchar* _tmp102_;
								gchar* _tmp103_;
								gchar* _tmp104_;
								gchar* _tmp105_;
								gchar* _tmp106_;
								gchar* _tmp107_;
								gchar* _tmp108_;
								const gchar* _tmp109_;
								gchar* _tmp110_;
								gchar* _tmp111_;
								gchar* _tmp112_;
								gchar* _tmp113_;
								_tmp96_ = snap;
								_tmp97_ = level;
								snapshot_remove_tag (_tmp96_, _tmp97_);
								_tmp98_ = snaps_count;
								snaps_count = _tmp98_ - 1;
								_tmp99_ = list;
								_tmp100_ = gee_abstract_list_get ((GeeAbstractList*) _tmp99_, 0);
								_tmp101_ = (Snapshot*) _tmp100_;
								_tmp102_ = _tmp101_->name;
								_tmp103_ = g_strdup_printf (" '%s' ", _tmp102_);
								_tmp104_ = _tmp103_;
								_tmp105_ = g_strconcat (_ ("Snapshot"), _tmp104_, NULL);
								_tmp106_ = _tmp105_;
								_tmp107_ = g_strconcat (_tmp106_, _ ("un-tagged"), NULL);
								_tmp108_ = _tmp107_;
								_tmp109_ = level;
								_tmp110_ = g_strdup_printf (" '%s'", _tmp109_);
								_tmp111_ = _tmp110_;
								_tmp112_ = g_strconcat (_tmp108_, _tmp111_, NULL);
								_tmp113_ = _tmp112_;
								tee_jee_logging_log_msg (_tmp113_, FALSE);
								_g_free0 (_tmp113_);
								_g_free0 (_tmp111_);
								_g_free0 (_tmp108_);
								_g_free0 (_tmp106_);
								_g_free0 (_tmp104_);
								_g_object_unref0 (_tmp101_);
							}
							_g_object_unref0 (snap);
						}
					}
				}
				_g_free0 (level);
			}
		}
	}
	snapshot_repo_remove_untagged (self);
	snapshot_repo_remove_marked_for_deletion (self);
	snapshot_repo_remove_invalid (self);
	levels = (_vala_array_free (levels, levels_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (list);
	_g_date_time_unref0 (dt_limit);
	_g_date_time_unref0 (now);
}

void
snapshot_repo_remove_untagged (SnapshotRepo* self)
{
	gboolean show_msg = FALSE;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("SnapshotRepo: remove_untagged()");
	show_msg = TRUE;
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp0_;
		gint _bak_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bak_index = 0;
		_tmp0_ = self->snapshots;
		_bak_list = _tmp0_;
		_tmp1_ = _bak_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bak_size = _tmp3_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			Snapshot* _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			_bak_index = _bak_index + 1;
			_tmp4_ = _bak_index;
			_tmp5_ = _bak_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bak_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bak_index);
			bak = (Snapshot*) _tmp7_;
			_tmp8_ = bak;
			_tmp9_ = _tmp8_->tags;
			_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == 0) {
				Snapshot* _tmp14_;
				if (show_msg) {
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp12_ = g_strdup_printf ("%s (%s):", _ ("Removing snapshots"), _ ("un-tagged"));
					_tmp13_ = _tmp12_;
					tee_jee_logging_log_msg (_tmp13_, FALSE);
					_g_free0 (_tmp13_);
					show_msg = FALSE;
				}
				_tmp14_ = bak;
				snapshot_remove (_tmp14_, TRUE);
			}
			_g_object_unref0 (bak);
		}
	}
	snapshot_repo_load_snapshots (self);
}

void
snapshot_repo_remove_marked_for_deletion (SnapshotRepo* self)
{
	gboolean show_msg = FALSE;
	g_return_if_fail (self != NULL);
	show_msg = TRUE;
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp0_;
		gint _bak_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bak_index = 0;
		_tmp0_ = self->snapshots;
		_bak_list = _tmp0_;
		_tmp1_ = _bak_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bak_size = _tmp3_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			Snapshot* _tmp8_;
			_bak_index = _bak_index + 1;
			_tmp4_ = _bak_index;
			_tmp5_ = _bak_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bak_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bak_index);
			bak = (Snapshot*) _tmp7_;
			_tmp8_ = bak;
			if (_tmp8_->marked_for_deletion) {
				Snapshot* _tmp11_;
				if (show_msg) {
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp9_ = g_strdup_printf ("%s (%s):", _ ("Removing snapshots"), _ ("marked for deletion"));
					_tmp10_ = _tmp9_;
					tee_jee_logging_log_msg (_tmp10_, FALSE);
					_g_free0 (_tmp10_);
					show_msg = FALSE;
				}
				_tmp11_ = bak;
				snapshot_remove (_tmp11_, TRUE);
			}
			_g_object_unref0 (bak);
		}
	}
	snapshot_repo_load_snapshots (self);
}

void
snapshot_repo_remove_invalid (SnapshotRepo* self)
{
	gboolean show_msg = FALSE;
	g_return_if_fail (self != NULL);
	show_msg = TRUE;
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp0_;
		gint _bak_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bak_index = 0;
		_tmp0_ = self->invalid_snapshots;
		_bak_list = _tmp0_;
		_tmp1_ = _bak_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bak_size = _tmp3_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			Snapshot* _tmp10_;
			_bak_index = _bak_index + 1;
			_tmp4_ = _bak_index;
			_tmp5_ = _bak_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bak_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bak_index);
			bak = (Snapshot*) _tmp7_;
			if (show_msg) {
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp8_ = g_strdup_printf ("%s (%s):", _ ("Removing snapshots"), _ ("incomplete"));
				_tmp9_ = _tmp8_;
				tee_jee_logging_log_msg (_tmp9_, FALSE);
				_g_free0 (_tmp9_);
				show_msg = FALSE;
			}
			_tmp10_ = bak;
			snapshot_remove (_tmp10_, TRUE);
			_g_object_unref0 (bak);
		}
	}
	snapshot_repo_load_snapshots (self);
}

gboolean
snapshot_repo_remove_all (SnapshotRepo* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = snapshot_repo_get_timeshift_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = tee_jee_file_system_dir_exists (_tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gboolean ok = FALSE;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gboolean _tmp22_;
		_tmp4_ = g_strconcat (_ ("Removing snapshots"), " > ", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strconcat (_tmp5_, _ ("all"), NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "...", NULL);
		_tmp9_ = _tmp8_;
		tee_jee_logging_log_msg (_tmp9_, FALSE);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		{
			GeeArrayList* _bak_list = NULL;
			GeeArrayList* _tmp10_;
			gint _bak_size = 0;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _bak_index = 0;
			_tmp10_ = self->snapshots;
			_bak_list = _tmp10_;
			_tmp11_ = _bak_list;
			_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			_bak_size = _tmp13_;
			_bak_index = -1;
			while (TRUE) {
				gint _tmp14_;
				gint _tmp15_;
				Snapshot* bak = NULL;
				GeeArrayList* _tmp16_;
				gpointer _tmp17_;
				Snapshot* _tmp18_;
				_bak_index = _bak_index + 1;
				_tmp14_ = _bak_index;
				_tmp15_ = _bak_size;
				if (!(_tmp14_ < _tmp15_)) {
					break;
				}
				_tmp16_ = _bak_list;
				_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _bak_index);
				bak = (Snapshot*) _tmp17_;
				_tmp18_ = bak;
				snapshot_remove (_tmp18_, TRUE);
				_g_object_unref0 (bak);
			}
		}
		snapshot_repo_remove_sync_dir (self);
		_tmp19_ = snapshot_repo_get_timeshift_path (self);
		_tmp20_ = _tmp19_;
		_tmp21_ = _tmp20_;
		_tmp22_ = snapshot_repo_delete_directory (self, _tmp21_);
		_g_free0 (_tmp21_);
		ok = _tmp22_;
		snapshot_repo_load_snapshots (self);
		result = ok;
		return result;
	} else {
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp23_ = self->mount_path;
		_tmp24_ = g_strdup_printf (" '%s'", _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_ ("No snapshots found"), _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		tee_jee_logging_log_msg (_tmp27_, FALSE);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		result = TRUE;
		return result;
	}
}

gboolean
snapshot_repo_remove_sync_dir (SnapshotRepo* self)
{
	gchar* sync_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->mount_path;
	_tmp1_ = g_strconcat (_tmp0_, "/timeshift/snapshots/.sync", NULL);
	sync_dir = _tmp1_;
	_tmp2_ = sync_dir;
	if (tee_jee_file_system_dir_exists (_tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = sync_dir;
		if (!snapshot_repo_delete_directory (self, _tmp3_)) {
			result = FALSE;
			_g_free0 (sync_dir);
			return result;
		}
	}
	result = TRUE;
	_g_free0 (sync_dir);
	return result;
}

gboolean
snapshot_repo_remove_timeshift_dir (SnapshotRepo* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = snapshot_repo_get_timeshift_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = tee_jee_file_system_dir_exists (_tmp2_);
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = snapshot_repo_get_timeshift_path (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = !snapshot_repo_delete_directory (self, _tmp6_);
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}

static void
___lambda15_ (SnapshotRepo* self)
{
	snapshot_repo_delete_directory_thread (self);
}

static gpointer
____lambda15__gthread_func (gpointer self)
{
	gpointer result;
	___lambda15_ ((SnapshotRepo*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

static gboolean
snapshot_repo_delete_directory (SnapshotRepo* self,
                                const gchar* dir_path)
{
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dir_path != NULL, FALSE);
	_tmp0_ = g_strdup (dir_path);
	_g_free0 (self->priv->thr_args1);
	self->priv->thr_args1 = _tmp0_;
	{
		GThread* _tmp1_;
		GThread* _tmp2_;
		self->priv->thr_running = TRUE;
		self->priv->thr_success = FALSE;
		_tmp1_ = g_thread_try_new ("delete-directory", ____lambda15__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_thread_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->priv->thr_running = FALSE;
		self->priv->thr_success = FALSE;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	while (TRUE) {
		if (!self->priv->thr_running) {
			break;
		}
		tee_jee_gtk_helper_gtk_do_events ();
		g_usleep (((gulong) G_TIME_SPAN_MILLISECOND) * 100);
	}
	_g_free0 (self->priv->thr_args1);
	self->priv->thr_args1 = NULL;
	result = self->priv->thr_success;
	return result;
}

static void
snapshot_repo_delete_directory_thread (SnapshotRepo* self)
{
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->thr_args1;
	self->priv->thr_success = tee_jee_file_system_dir_delete_recursive (_tmp0_);
	if (self->priv->thr_success) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->thr_args1;
		_tmp2_ = g_strdup_printf (": '%s'", _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_ ("Removed"), _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		tee_jee_logging_log_msg (_tmp5_, FALSE);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = self->priv->thr_args1;
		_tmp7_ = g_strdup_printf (": '%s'", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_ ("Failed to remove"), _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
	}
	self->priv->thr_running = FALSE;
}

void
snapshot_repo_create_symlinks (SnapshotRepo* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	snapshot_repo_cleanup_symlink_dir (self, "boot");
	snapshot_repo_cleanup_symlink_dir (self, "hourly");
	snapshot_repo_cleanup_symlink_dir (self, "daily");
	snapshot_repo_cleanup_symlink_dir (self, "weekly");
	snapshot_repo_cleanup_symlink_dir (self, "monthly");
	snapshot_repo_cleanup_symlink_dir (self, "ondemand");
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp0_;
		gint _bak_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bak_index = 0;
		_tmp0_ = self->snapshots;
		_bak_list = _tmp0_;
		_tmp1_ = _bak_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bak_size = _tmp3_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_bak_index = _bak_index + 1;
			_tmp4_ = _bak_index;
			_tmp5_ = _bak_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bak_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bak_index);
			bak = (Snapshot*) _tmp7_;
			{
				GeeArrayList* _tag_list = NULL;
				Snapshot* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _tag_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tag_index = 0;
				_tmp8_ = bak;
				_tmp9_ = _tmp8_->tags;
				_tag_list = _tmp9_;
				_tmp10_ = _tag_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tag_size = _tmp12_;
				_tag_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					gchar* tag = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					gchar* linkTarget = NULL;
					gchar* _tmp17_;
					gchar* _tmp18_;
					gchar* _tmp19_;
					const gchar* _tmp20_;
					Snapshot* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* linkValue = NULL;
					Snapshot* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					_tag_index = _tag_index + 1;
					_tmp13_ = _tag_index;
					_tmp14_ = _tag_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _tag_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tag_index);
					tag = (gchar*) _tmp16_;
					_tmp17_ = snapshot_repo_get_snapshots_path (self);
					_tmp18_ = _tmp17_;
					_tmp19_ = _tmp18_;
					_tmp20_ = tag;
					_tmp21_ = bak;
					_tmp22_ = _tmp21_->name;
					_tmp23_ = g_strdup_printf ("%s-%s/%s", _tmp19_, _tmp20_, _tmp22_);
					_tmp24_ = _tmp23_;
					_g_free0 (_tmp19_);
					linkTarget = _tmp24_;
					_tmp25_ = bak;
					_tmp26_ = _tmp25_->name;
					_tmp27_ = g_strconcat ("../snapshots/", _tmp26_, NULL);
					linkValue = _tmp27_;
					{
						GFile* f = NULL;
						const gchar* _tmp28_;
						GFile* _tmp29_;
						gboolean _tmp30_ = FALSE;
						GFile* _tmp31_;
						const gchar* _tmp32_;
						_tmp28_ = linkTarget;
						_tmp29_ = g_file_new_for_path (_tmp28_);
						f = _tmp29_;
						_tmp31_ = f;
						_tmp32_ = linkValue;
						_tmp30_ = g_file_make_symbolic_link (_tmp31_, _tmp32_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (f);
							goto __catch0_g_error;
						}
						if (!_tmp30_) {
							const gchar* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp33_ = linkTarget;
							_tmp34_ = g_strdup_printf (": %s", _tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = g_strconcat (_ ("Failed to create symlinks"), _tmp35_, NULL);
							_tmp37_ = _tmp36_;
							tee_jee_logging_log_error (_tmp37_, FALSE, FALSE);
							_g_free0 (_tmp37_);
							_g_free0 (_tmp35_);
						}
						_g_object_unref0 (f);
					}
					goto __finally0;
					__catch0_g_error:
					{
						GError* e = NULL;
						GError* _tmp38_;
						const gchar* _tmp39_;
						const gchar* _tmp40_;
						gchar* _tmp41_;
						gchar* _tmp42_;
						gchar* _tmp43_;
						gchar* _tmp44_;
						e = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp38_ = e;
						_tmp39_ = _tmp38_->message;
						tee_jee_logging_log_debug (_tmp39_);
						_tmp40_ = linkTarget;
						_tmp41_ = g_strdup_printf (": %s", _tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strconcat (_ ("Failed to create symlinks"), _tmp42_, NULL);
						_tmp44_ = _tmp43_;
						tee_jee_logging_log_error (_tmp44_, FALSE, FALSE);
						_g_free0 (_tmp44_);
						_g_free0 (_tmp42_);
						_g_error_free0 (e);
					}
					__finally0:
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_free0 (linkValue);
						_g_free0 (linkTarget);
						_g_free0 (tag);
						_g_object_unref0 (bak);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
					_g_free0 (linkValue);
					_g_free0 (linkTarget);
					_g_free0 (tag);
				}
			}
			_g_object_unref0 (bak);
		}
	}
	tee_jee_logging_log_debug (_ ("Symlinks updated"));
}

void
snapshot_repo_cleanup_symlink_dir (SnapshotRepo* self,
                                   const gchar* tag)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tag != NULL);
	{
		gchar* path = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GFile* f = NULL;
		const gchar* _tmp11_;
		GFile* _tmp12_;
		_tmp0_ = snapshot_repo_get_snapshots_path (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("%s-%s", _tmp2_, tag);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		path = _tmp4_;
		_tmp5_ = path;
		if (!tee_jee_file_system_dir_delete_recursive (_tmp5_)) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp6_ = path;
			_tmp7_ = g_strdup_printf (": '%s'", _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_strconcat (_ ("Failed to delete symlinks"), _tmp8_, NULL);
			_tmp10_ = _tmp9_;
			tee_jee_logging_log_error (_tmp10_, FALSE, FALSE);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
		}
		_tmp11_ = path;
		_tmp12_ = g_file_new_for_path (_tmp11_);
		f = _tmp12_;
		g_file_make_directory_with_parents (f, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (f);
			_g_free0 (path);
			goto __catch0_g_error;
		}
		_g_object_unref0 (f);
		_g_free0 (path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		tee_jee_logging_log_error (_tmp14_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

SnapshotRepo*
snapshot_repo_construct (GType object_type)
{
	SnapshotRepo * self = NULL;
	self = (SnapshotRepo*) g_object_new (object_type, NULL);
	return self;
}

SnapshotRepo*
snapshot_repo_new (void)
{
	return snapshot_repo_construct (TYPE_SNAPSHOT_REPO);
}

gchar*
snapshot_repo_get_timeshift_path (SnapshotRepo* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->btrfs_mode) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = self->mount_path;
		_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "timeshift-btrfs");
		result = _tmp1_;
		return result;
	} else {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->mount_path;
		_tmp3_ = tee_jee_file_system_path_combine (_tmp2_, "timeshift");
		result = _tmp3_;
		return result;
	}
}

gchar*
snapshot_repo_get_snapshots_path (SnapshotRepo* self)
{
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = snapshot_repo_get_timeshift_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = tee_jee_file_system_path_combine (_tmp2_, "snapshots");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
snapshot_repo_class_init (SnapshotRepoClass * klass,
                          gpointer klass_data)
{
	snapshot_repo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SnapshotRepo_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_snapshot_repo_get_property;
	G_OBJECT_CLASS (klass)->finalize = snapshot_repo_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_REPO_TIMESHIFT_PATH_PROPERTY, snapshot_repo_properties[SNAPSHOT_REPO_TIMESHIFT_PATH_PROPERTY] = g_param_spec_string ("timeshift-path", "timeshift-path", "timeshift-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SNAPSHOT_REPO_SNAPSHOTS_PATH_PROPERTY, snapshot_repo_properties[SNAPSHOT_REPO_SNAPSHOTS_PATH_PROPERTY] = g_param_spec_string ("snapshots-path", "snapshots-path", "snapshots-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
snapshot_repo_instance_init (SnapshotRepo * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = snapshot_repo_get_instance_private (self);
	self->device = NULL;
	self->device_home = NULL;
	_tmp0_ = g_strdup ("");
	self->mount_path = _tmp0_;
	self->btrfs_mode = FALSE;
	_tmp1_ = g_strdup ("");
	self->status_message = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->status_details = _tmp2_;
	self->last_snapshot_failed_space = FALSE;
	self->priv->parent_window = NULL;
	self->priv->thr_success = FALSE;
	self->priv->thr_running = FALSE;
	_tmp3_ = g_strdup ("");
	self->priv->thr_args1 = _tmp3_;
}

static void
snapshot_repo_finalize (GObject * obj)
{
	SnapshotRepo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SNAPSHOT_REPO, SnapshotRepo);
	_g_object_unref0 (self->device);
	_g_object_unref0 (self->device_home);
	_g_free0 (self->mount_path);
	_g_object_unref0 (self->mount_paths);
	_g_object_unref0 (self->snapshots);
	_g_object_unref0 (self->invalid_snapshots);
	_g_free0 (self->status_message);
	_g_free0 (self->status_details);
	_g_object_unref0 (self->priv->parent_window);
	_g_free0 (self->priv->thr_args1);
	G_OBJECT_CLASS (snapshot_repo_parent_class)->finalize (obj);
}

static GType
snapshot_repo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SnapshotRepoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) snapshot_repo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SnapshotRepo), 0, (GInstanceInitFunc) snapshot_repo_instance_init, NULL };
	GType snapshot_repo_type_id;
	snapshot_repo_type_id = g_type_register_static (G_TYPE_OBJECT, "SnapshotRepo", &g_define_type_info, 0);
	SnapshotRepo_private_offset = g_type_add_instance_private (snapshot_repo_type_id, sizeof (SnapshotRepoPrivate));
	return snapshot_repo_type_id;
}

GType
snapshot_repo_get_type (void)
{
	static volatile gsize snapshot_repo_type_id__once = 0;
	if (g_once_init_enter (&snapshot_repo_type_id__once)) {
		GType snapshot_repo_type_id;
		snapshot_repo_type_id = snapshot_repo_get_type_once ();
		g_once_init_leave (&snapshot_repo_type_id__once, snapshot_repo_type_id);
	}
	return snapshot_repo_type_id__once;
}

static void
_vala_snapshot_repo_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SnapshotRepo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SNAPSHOT_REPO, SnapshotRepo);
	switch (property_id) {
		case SNAPSHOT_REPO_TIMESHIFT_PATH_PROPERTY:
		g_value_take_string (value, snapshot_repo_get_timeshift_path (self));
		break;
		case SNAPSHOT_REPO_SNAPSHOTS_PATH_PROPERTY:
		g_value_take_string (value, snapshot_repo_get_snapshots_path (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
snapshot_location_status_get_type_once (void)
{
	static const GEnumValue values[] = {{SNAPSHOT_LOCATION_STATUS_NOT_SELECTED, "SNAPSHOT_LOCATION_STATUS_NOT_SELECTED", "not-selected"}, {SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE, "SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE", "not-available"}, {SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE, "SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE", "has-snapshots-has-space"}, {SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE, "SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE", "has-snapshots-no-space"}, {SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE, "SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE", "no-snapshots-no-space"}, {SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE, "SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE", "no-snapshots-has-space"}, {SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS, "SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS", "read-only-fs"}, {SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED, "SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED", "hardlinks-not-supported"}, {SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM, "SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM", "no-btrfs-system"}, {0, NULL, NULL}};
	GType snapshot_location_status_type_id;
	snapshot_location_status_type_id = g_enum_register_static ("SnapshotLocationStatus", values);
	return snapshot_location_status_type_id;
}

GType
snapshot_location_status_get_type (void)
{
	static volatile gsize snapshot_location_status_type_id__once = 0;
	if (g_once_init_enter (&snapshot_location_status_type_id__once)) {
		GType snapshot_location_status_type_id;
		snapshot_location_status_type_id = snapshot_location_status_get_type_once ();
		g_once_init_leave (&snapshot_location_status_type_id__once, snapshot_location_status_type_id);
	}
	return snapshot_location_status_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

