/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// HTTPAuthConfigApplyConfiguration represents a declarative configuration of the HTTPAuthConfig type for use
// with apply.
type HTTPAuthConfigApplyConfiguration struct {
	Path                   *string  `json:"path,omitempty"`
	AllowedRequestHeaders  []string `json:"allowedHeaders,omitempty"`
	AllowedResponseHeaders []string `json:"allowedResponseHeaders,omitempty"`
}

// HTTPAuthConfigApplyConfiguration constructs a declarative configuration of the HTTPAuthConfig type for use with
// apply.
func HTTPAuthConfig() *HTTPAuthConfigApplyConfiguration {
	return &HTTPAuthConfigApplyConfiguration{}
}

// WithPath sets the Path field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Path field is set to the value of the last call.
func (b *HTTPAuthConfigApplyConfiguration) WithPath(value string) *HTTPAuthConfigApplyConfiguration {
	b.Path = &value
	return b
}

// WithAllowedRequestHeaders adds the given value to the AllowedRequestHeaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AllowedRequestHeaders field.
func (b *HTTPAuthConfigApplyConfiguration) WithAllowedRequestHeaders(values ...string) *HTTPAuthConfigApplyConfiguration {
	for i := range values {
		b.AllowedRequestHeaders = append(b.AllowedRequestHeaders, values[i])
	}
	return b
}

// WithAllowedResponseHeaders adds the given value to the AllowedResponseHeaders field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the AllowedResponseHeaders field.
func (b *HTTPAuthConfigApplyConfiguration) WithAllowedResponseHeaders(values ...string) *HTTPAuthConfigApplyConfiguration {
	for i := range values {
		b.AllowedResponseHeaders = append(b.AllowedResponseHeaders, values[i])
	}
	return b
}
