/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha2

import (
	labels "k8s.io/apimachinery/pkg/labels"
	listers "k8s.io/client-go/listers"
	cache "k8s.io/client-go/tools/cache"
	apisv1alpha2 "sigs.k8s.io/gateway-api/apis/v1alpha2"
)

// GRPCRouteLister helps list GRPCRoutes.
// All objects returned here must be treated as read-only.
type GRPCRouteLister interface {
	// List lists all GRPCRoutes in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha2.GRPCRoute, err error)
	// GRPCRoutes returns an object that can list and get GRPCRoutes.
	GRPCRoutes(namespace string) GRPCRouteNamespaceLister
	GRPCRouteListerExpansion
}

// gRPCRouteLister implements the GRPCRouteLister interface.
type gRPCRouteLister struct {
	listers.ResourceIndexer[*apisv1alpha2.GRPCRoute]
}

// NewGRPCRouteLister returns a new GRPCRouteLister.
func NewGRPCRouteLister(indexer cache.Indexer) GRPCRouteLister {
	return &gRPCRouteLister{listers.New[*apisv1alpha2.GRPCRoute](indexer, apisv1alpha2.Resource("grpcroute"))}
}

// GRPCRoutes returns an object that can list and get GRPCRoutes.
func (s *gRPCRouteLister) GRPCRoutes(namespace string) GRPCRouteNamespaceLister {
	return gRPCRouteNamespaceLister{listers.NewNamespaced[*apisv1alpha2.GRPCRoute](s.ResourceIndexer, namespace)}
}

// GRPCRouteNamespaceLister helps list and get GRPCRoutes.
// All objects returned here must be treated as read-only.
type GRPCRouteNamespaceLister interface {
	// List lists all GRPCRoutes in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*apisv1alpha2.GRPCRoute, err error)
	// Get retrieves the GRPCRoute from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*apisv1alpha2.GRPCRoute, error)
	GRPCRouteNamespaceListerExpansion
}

// gRPCRouteNamespaceLister implements the GRPCRouteNamespaceLister
// interface.
type gRPCRouteNamespaceLister struct {
	listers.ResourceIndexer[*apisv1alpha2.GRPCRoute]
}
