//
// Copyright 2016 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
#include "pxr/usd/usdLux/tokens.h"

PXR_NAMESPACE_OPEN_SCOPE

UsdLuxTokensType::UsdLuxTokensType() :
    angular("angular", TfToken::Immortal),
    automatic("automatic", TfToken::Immortal),
    collectionFilterLinkIncludeRoot("collection:filterLink:includeRoot", TfToken::Immortal),
    collectionLightLinkIncludeRoot("collection:lightLink:includeRoot", TfToken::Immortal),
    collectionShadowLinkIncludeRoot("collection:shadowLink:includeRoot", TfToken::Immortal),
    consumeAndContinue("consumeAndContinue", TfToken::Immortal),
    consumeAndHalt("consumeAndHalt", TfToken::Immortal),
    cubeMapVerticalCross("cubeMapVerticalCross", TfToken::Immortal),
    filterLink("filterLink", TfToken::Immortal),
    geometry("geometry", TfToken::Immortal),
    guideRadius("guideRadius", TfToken::Immortal),
    ignore("ignore", TfToken::Immortal),
    independent("independent", TfToken::Immortal),
    inputsAngle("inputs:angle", TfToken::Immortal),
    inputsColor("inputs:color", TfToken::Immortal),
    inputsColorTemperature("inputs:colorTemperature", TfToken::Immortal),
    inputsDiffuse("inputs:diffuse", TfToken::Immortal),
    inputsEnableColorTemperature("inputs:enableColorTemperature", TfToken::Immortal),
    inputsExposure("inputs:exposure", TfToken::Immortal),
    inputsHeight("inputs:height", TfToken::Immortal),
    inputsIntensity("inputs:intensity", TfToken::Immortal),
    inputsLength("inputs:length", TfToken::Immortal),
    inputsNormalize("inputs:normalize", TfToken::Immortal),
    inputsRadius("inputs:radius", TfToken::Immortal),
    inputsShadowColor("inputs:shadow:color", TfToken::Immortal),
    inputsShadowDistance("inputs:shadow:distance", TfToken::Immortal),
    inputsShadowEnable("inputs:shadow:enable", TfToken::Immortal),
    inputsShadowFalloff("inputs:shadow:falloff", TfToken::Immortal),
    inputsShadowFalloffGamma("inputs:shadow:falloffGamma", TfToken::Immortal),
    inputsShapingConeAngle("inputs:shaping:cone:angle", TfToken::Immortal),
    inputsShapingConeSoftness("inputs:shaping:cone:softness", TfToken::Immortal),
    inputsShapingFocus("inputs:shaping:focus", TfToken::Immortal),
    inputsShapingFocusTint("inputs:shaping:focusTint", TfToken::Immortal),
    inputsShapingIesAngleScale("inputs:shaping:ies:angleScale", TfToken::Immortal),
    inputsShapingIesFile("inputs:shaping:ies:file", TfToken::Immortal),
    inputsShapingIesNormalize("inputs:shaping:ies:normalize", TfToken::Immortal),
    inputsSpecular("inputs:specular", TfToken::Immortal),
    inputsTextureFile("inputs:texture:file", TfToken::Immortal),
    inputsTextureFormat("inputs:texture:format", TfToken::Immortal),
    inputsWidth("inputs:width", TfToken::Immortal),
    latlong("latlong", TfToken::Immortal),
    lightFilters("light:filters", TfToken::Immortal),
    lightFilterShaderId("lightFilter:shaderId", TfToken::Immortal),
    lightLink("lightLink", TfToken::Immortal),
    lightList("lightList", TfToken::Immortal),
    lightListCacheBehavior("lightList:cacheBehavior", TfToken::Immortal),
    lightMaterialSyncMode("light:materialSyncMode", TfToken::Immortal),
    lightShaderId("light:shaderId", TfToken::Immortal),
    materialGlowTintsLight("materialGlowTintsLight", TfToken::Immortal),
    MeshLight("MeshLight", TfToken::Immortal),
    mirroredBall("mirroredBall", TfToken::Immortal),
    noMaterialResponse("noMaterialResponse", TfToken::Immortal),
    orientToStageUpAxis("orientToStageUpAxis", TfToken::Immortal),
    poleAxis("poleAxis", TfToken::Immortal),
    portals("portals", TfToken::Immortal),
    scene("scene", TfToken::Immortal),
    shadowLink("shadowLink", TfToken::Immortal),
    treatAsLine("treatAsLine", TfToken::Immortal),
    treatAsPoint("treatAsPoint", TfToken::Immortal),
    VolumeLight("VolumeLight", TfToken::Immortal),
    Y("Y", TfToken::Immortal),
    Z("Z", TfToken::Immortal),
    BoundableLightBase("BoundableLightBase", TfToken::Immortal),
    CylinderLight("CylinderLight", TfToken::Immortal),
    DiskLight("DiskLight", TfToken::Immortal),
    DistantLight("DistantLight", TfToken::Immortal),
    DomeLight("DomeLight", TfToken::Immortal),
    DomeLight_1("DomeLight_1", TfToken::Immortal),
    GeometryLight("GeometryLight", TfToken::Immortal),
    LightAPI("LightAPI", TfToken::Immortal),
    LightFilter("LightFilter", TfToken::Immortal),
    LightListAPI("LightListAPI", TfToken::Immortal),
    ListAPI("ListAPI", TfToken::Immortal),
    MeshLightAPI("MeshLightAPI", TfToken::Immortal),
    NonboundableLightBase("NonboundableLightBase", TfToken::Immortal),
    PluginLight("PluginLight", TfToken::Immortal),
    PluginLightFilter("PluginLightFilter", TfToken::Immortal),
    PortalLight("PortalLight", TfToken::Immortal),
    RectLight("RectLight", TfToken::Immortal),
    ShadowAPI("ShadowAPI", TfToken::Immortal),
    ShapingAPI("ShapingAPI", TfToken::Immortal),
    SphereLight("SphereLight", TfToken::Immortal),
    VolumeLightAPI("VolumeLightAPI", TfToken::Immortal),
    allTokens({
        angular,
        automatic,
        collectionFilterLinkIncludeRoot,
        collectionLightLinkIncludeRoot,
        collectionShadowLinkIncludeRoot,
        consumeAndContinue,
        consumeAndHalt,
        cubeMapVerticalCross,
        filterLink,
        geometry,
        guideRadius,
        ignore,
        independent,
        inputsAngle,
        inputsColor,
        inputsColorTemperature,
        inputsDiffuse,
        inputsEnableColorTemperature,
        inputsExposure,
        inputsHeight,
        inputsIntensity,
        inputsLength,
        inputsNormalize,
        inputsRadius,
        inputsShadowColor,
        inputsShadowDistance,
        inputsShadowEnable,
        inputsShadowFalloff,
        inputsShadowFalloffGamma,
        inputsShapingConeAngle,
        inputsShapingConeSoftness,
        inputsShapingFocus,
        inputsShapingFocusTint,
        inputsShapingIesAngleScale,
        inputsShapingIesFile,
        inputsShapingIesNormalize,
        inputsSpecular,
        inputsTextureFile,
        inputsTextureFormat,
        inputsWidth,
        latlong,
        lightFilters,
        lightFilterShaderId,
        lightLink,
        lightList,
        lightListCacheBehavior,
        lightMaterialSyncMode,
        lightShaderId,
        materialGlowTintsLight,
        MeshLight,
        mirroredBall,
        noMaterialResponse,
        orientToStageUpAxis,
        poleAxis,
        portals,
        scene,
        shadowLink,
        treatAsLine,
        treatAsPoint,
        VolumeLight,
        Y,
        Z,
        BoundableLightBase,
        CylinderLight,
        DiskLight,
        DistantLight,
        DomeLight,
        DomeLight_1,
        GeometryLight,
        LightAPI,
        LightFilter,
        LightListAPI,
        ListAPI,
        MeshLightAPI,
        NonboundableLightBase,
        PluginLight,
        PluginLightFilter,
        PortalLight,
        RectLight,
        ShadowAPI,
        ShapingAPI,
        SphereLight,
        VolumeLightAPI
    })
{
}

TfStaticData<UsdLuxTokensType> UsdLuxTokens;

PXR_NAMESPACE_CLOSE_SCOPE
