// Code generated by Microsoft Kiota - DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package users

import (
    "context"
    i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f "github.com/microsoft/kiota-abstractions-go"
    iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242 "github.com/microsoftgraph/msgraph-sdk-go/models"
    ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a "github.com/microsoftgraph/msgraph-sdk-go/models/odataerrors"
)

// ItemDataSecurityAndGovernanceRequestBuilder provides operations to manage the dataSecurityAndGovernance property of the microsoft.graph.user entity.
type ItemDataSecurityAndGovernanceRequestBuilder struct {
    i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.BaseRequestBuilder
}
// ItemDataSecurityAndGovernanceRequestBuilderDeleteRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type ItemDataSecurityAndGovernanceRequestBuilderDeleteRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
}
// ItemDataSecurityAndGovernanceRequestBuilderGetQueryParameters the data security and governance settings for the user. Read-only. Nullable.
type ItemDataSecurityAndGovernanceRequestBuilderGetQueryParameters struct {
    // Expand related entities
    Expand []string `uriparametername:"%24expand"`
    // Select properties to be returned
    Select []string `uriparametername:"%24select"`
}
// ItemDataSecurityAndGovernanceRequestBuilderGetRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type ItemDataSecurityAndGovernanceRequestBuilderGetRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
    // Request query parameters
    QueryParameters *ItemDataSecurityAndGovernanceRequestBuilderGetQueryParameters
}
// ItemDataSecurityAndGovernanceRequestBuilderPatchRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type ItemDataSecurityAndGovernanceRequestBuilderPatchRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
}
// Activities provides operations to manage the activities property of the microsoft.graph.userDataSecurityAndGovernance entity.
// returns a *ItemDataSecurityAndGovernanceActivitiesRequestBuilder when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) Activities()(*ItemDataSecurityAndGovernanceActivitiesRequestBuilder) {
    return NewItemDataSecurityAndGovernanceActivitiesRequestBuilderInternal(m.BaseRequestBuilder.PathParameters, m.BaseRequestBuilder.RequestAdapter)
}
// NewItemDataSecurityAndGovernanceRequestBuilderInternal instantiates a new ItemDataSecurityAndGovernanceRequestBuilder and sets the default values.
func NewItemDataSecurityAndGovernanceRequestBuilderInternal(pathParameters map[string]string, requestAdapter i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestAdapter)(*ItemDataSecurityAndGovernanceRequestBuilder) {
    m := &ItemDataSecurityAndGovernanceRequestBuilder{
        BaseRequestBuilder: *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewBaseRequestBuilder(requestAdapter, "{+baseurl}/users/{user%2Did}/dataSecurityAndGovernance{?%24expand,%24select}", pathParameters),
    }
    return m
}
// NewItemDataSecurityAndGovernanceRequestBuilder instantiates a new ItemDataSecurityAndGovernanceRequestBuilder and sets the default values.
func NewItemDataSecurityAndGovernanceRequestBuilder(rawUrl string, requestAdapter i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestAdapter)(*ItemDataSecurityAndGovernanceRequestBuilder) {
    urlParams := make(map[string]string)
    urlParams["request-raw-url"] = rawUrl
    return NewItemDataSecurityAndGovernanceRequestBuilderInternal(urlParams, requestAdapter)
}
// Delete delete navigation property dataSecurityAndGovernance for users
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *ItemDataSecurityAndGovernanceRequestBuilder) Delete(ctx context.Context, requestConfiguration *ItemDataSecurityAndGovernanceRequestBuilderDeleteRequestConfiguration)(error) {
    requestInfo, err := m.ToDeleteRequestInformation(ctx, requestConfiguration);
    if err != nil {
        return err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    err = m.BaseRequestBuilder.RequestAdapter.SendNoContent(ctx, requestInfo, errorMapping)
    if err != nil {
        return err
    }
    return nil
}
// Get the data security and governance settings for the user. Read-only. Nullable.
// returns a UserDataSecurityAndGovernanceable when successful
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *ItemDataSecurityAndGovernanceRequestBuilder) Get(ctx context.Context, requestConfiguration *ItemDataSecurityAndGovernanceRequestBuilderGetRequestConfiguration)(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.UserDataSecurityAndGovernanceable, error) {
    requestInfo, err := m.ToGetRequestInformation(ctx, requestConfiguration);
    if err != nil {
        return nil, err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    res, err := m.BaseRequestBuilder.RequestAdapter.Send(ctx, requestInfo, iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.CreateUserDataSecurityAndGovernanceFromDiscriminatorValue, errorMapping)
    if err != nil {
        return nil, err
    }
    if res == nil {
        return nil, nil
    }
    return res.(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.UserDataSecurityAndGovernanceable), nil
}
// Patch update the navigation property dataSecurityAndGovernance in users
// returns a UserDataSecurityAndGovernanceable when successful
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *ItemDataSecurityAndGovernanceRequestBuilder) Patch(ctx context.Context, body iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.UserDataSecurityAndGovernanceable, requestConfiguration *ItemDataSecurityAndGovernanceRequestBuilderPatchRequestConfiguration)(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.UserDataSecurityAndGovernanceable, error) {
    requestInfo, err := m.ToPatchRequestInformation(ctx, body, requestConfiguration);
    if err != nil {
        return nil, err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    res, err := m.BaseRequestBuilder.RequestAdapter.Send(ctx, requestInfo, iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.CreateUserDataSecurityAndGovernanceFromDiscriminatorValue, errorMapping)
    if err != nil {
        return nil, err
    }
    if res == nil {
        return nil, nil
    }
    return res.(iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.UserDataSecurityAndGovernanceable), nil
}
// ProcessContent provides operations to call the processContent method.
// returns a *ItemDataSecurityAndGovernanceProcessContentRequestBuilder when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) ProcessContent()(*ItemDataSecurityAndGovernanceProcessContentRequestBuilder) {
    return NewItemDataSecurityAndGovernanceProcessContentRequestBuilderInternal(m.BaseRequestBuilder.PathParameters, m.BaseRequestBuilder.RequestAdapter)
}
// ProtectionScopes provides operations to manage the protectionScopes property of the microsoft.graph.userDataSecurityAndGovernance entity.
// returns a *ItemDataSecurityAndGovernanceProtectionScopesRequestBuilder when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) ProtectionScopes()(*ItemDataSecurityAndGovernanceProtectionScopesRequestBuilder) {
    return NewItemDataSecurityAndGovernanceProtectionScopesRequestBuilderInternal(m.BaseRequestBuilder.PathParameters, m.BaseRequestBuilder.RequestAdapter)
}
// SensitivityLabels provides operations to manage the sensitivityLabels property of the microsoft.graph.dataSecurityAndGovernance entity.
// returns a *ItemDataSecurityAndGovernanceSensitivityLabelsRequestBuilder when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) SensitivityLabels()(*ItemDataSecurityAndGovernanceSensitivityLabelsRequestBuilder) {
    return NewItemDataSecurityAndGovernanceSensitivityLabelsRequestBuilderInternal(m.BaseRequestBuilder.PathParameters, m.BaseRequestBuilder.RequestAdapter)
}
// ToDeleteRequestInformation delete navigation property dataSecurityAndGovernance for users
// returns a *RequestInformation when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) ToDeleteRequestInformation(ctx context.Context, requestConfiguration *ItemDataSecurityAndGovernanceRequestBuilderDeleteRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.DELETE, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "application/json")
    return requestInfo, nil
}
// ToGetRequestInformation the data security and governance settings for the user. Read-only. Nullable.
// returns a *RequestInformation when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) ToGetRequestInformation(ctx context.Context, requestConfiguration *ItemDataSecurityAndGovernanceRequestBuilderGetRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.GET, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        if requestConfiguration.QueryParameters != nil {
            requestInfo.AddQueryParameters(*(requestConfiguration.QueryParameters))
        }
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "application/json")
    return requestInfo, nil
}
// ToPatchRequestInformation update the navigation property dataSecurityAndGovernance in users
// returns a *RequestInformation when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) ToPatchRequestInformation(ctx context.Context, body iadcd81124412c61e647227ecfc4449d8bba17de0380ddda76f641a29edf2b242.UserDataSecurityAndGovernanceable, requestConfiguration *ItemDataSecurityAndGovernanceRequestBuilderPatchRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.PATCH, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "application/json")
    err := requestInfo.SetContentFromParsable(ctx, m.BaseRequestBuilder.RequestAdapter, "application/json", body)
    if err != nil {
        return nil, err
    }
    return requestInfo, nil
}
// WithUrl returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
// returns a *ItemDataSecurityAndGovernanceRequestBuilder when successful
func (m *ItemDataSecurityAndGovernanceRequestBuilder) WithUrl(rawUrl string)(*ItemDataSecurityAndGovernanceRequestBuilder) {
    return NewItemDataSecurityAndGovernanceRequestBuilder(rawUrl, m.BaseRequestBuilder.RequestAdapter);
}
