/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPathSegCurvetoCubicRel.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRelConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_x);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_x);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_y);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_y);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_x1);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_x1);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_y1);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_y1);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_x2);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_x2);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_y2);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_y2);

class JSSVGPathSegCurvetoCubicRelPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPathSegCurvetoCubicRelPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPathSegCurvetoCubicRelPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPathSegCurvetoCubicRelPrototype>(vm)) JSSVGPathSegCurvetoCubicRelPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoCubicRelPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPathSegCurvetoCubicRelPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPathSegCurvetoCubicRelPrototype, JSSVGPathSegCurvetoCubicRelPrototype::Base);

using JSSVGPathSegCurvetoCubicRelDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPathSegCurvetoCubicRel>;

template<> const ClassInfo JSSVGPathSegCurvetoCubicRelDOMConstructor::s_info = { "SVGPathSegCurvetoCubicRel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoCubicRelDOMConstructor) };

template<> JSValue JSSVGPathSegCurvetoCubicRelDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSSVGPathSeg::getConstructor(vm, &globalObject);
}

template<> void JSSVGPathSegCurvetoCubicRelDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPathSegCurvetoCubicRel"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPathSegCurvetoCubicRel::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 7> JSSVGPathSegCurvetoCubicRelPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRelConstructor, 0 } },
    HashTableValue { "x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRel_x, setJSSVGPathSegCurvetoCubicRel_x } },
    HashTableValue { "y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRel_y, setJSSVGPathSegCurvetoCubicRel_y } },
    HashTableValue { "x1"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRel_x1, setJSSVGPathSegCurvetoCubicRel_x1 } },
    HashTableValue { "y1"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRel_y1, setJSSVGPathSegCurvetoCubicRel_y1 } },
    HashTableValue { "x2"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRel_x2, setJSSVGPathSegCurvetoCubicRel_x2 } },
    HashTableValue { "y2"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPathSegCurvetoCubicRel_y2, setJSSVGPathSegCurvetoCubicRel_y2 } },
};

const ClassInfo JSSVGPathSegCurvetoCubicRelPrototype::s_info = { "SVGPathSegCurvetoCubicRel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoCubicRelPrototype) };

void JSSVGPathSegCurvetoCubicRelPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPathSegCurvetoCubicRel::info(), JSSVGPathSegCurvetoCubicRelPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPathSegCurvetoCubicRel::s_info = { "SVGPathSegCurvetoCubicRel"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPathSegCurvetoCubicRel) };

JSSVGPathSegCurvetoCubicRel::JSSVGPathSegCurvetoCubicRel(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPathSegCurvetoCubicRel>&& impl)
    : JSSVGPathSeg(structure, globalObject, WTFMove(impl))
{
}

Ref<SVGPathSegCurvetoCubicRel> JSSVGPathSegCurvetoCubicRel::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPathSegCurvetoCubicRel>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPathSegCurvetoCubicRel::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPathSegCurvetoCubicRelPrototype::createStructure(vm, &globalObject, JSSVGPathSeg::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSSVGPathSegCurvetoCubicRelPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPathSegCurvetoCubicRel::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPathSegCurvetoCubicRel>(vm, globalObject);
}

JSValue JSSVGPathSegCurvetoCubicRel::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPathSegCurvetoCubicRelDOMConstructor, DOMConstructorID::SVGPathSegCurvetoCubicRel>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRelConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPathSegCurvetoCubicRelPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPathSegCurvetoCubicRel::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPathSegCurvetoCubicRel_xGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::get<jsSVGPathSegCurvetoCubicRel_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoCubicRel_xSetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::set<setJSSVGPathSegCurvetoCubicRel_xSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoCubicRel_yGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::get<jsSVGPathSegCurvetoCubicRel_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoCubicRel_ySetter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setY(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::set<setJSSVGPathSegCurvetoCubicRel_ySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoCubicRel_x1Getter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x1())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_x1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::get<jsSVGPathSegCurvetoCubicRel_x1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoCubicRel_x1Setter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX1(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_x1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::set<setJSSVGPathSegCurvetoCubicRel_x1Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoCubicRel_y1Getter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y1())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_y1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::get<jsSVGPathSegCurvetoCubicRel_y1Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoCubicRel_y1Setter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setY1(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_y1, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::set<setJSSVGPathSegCurvetoCubicRel_y1Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoCubicRel_x2Getter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.x2())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_x2, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::get<jsSVGPathSegCurvetoCubicRel_x2Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoCubicRel_x2Setter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setX2(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_x2, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::set<setJSSVGPathSegCurvetoCubicRel_x2Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGPathSegCurvetoCubicRel_y2Getter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnrestrictedFloat>(lexicalGlobalObject, throwScope, impl.y2())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPathSegCurvetoCubicRel_y2, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::get<jsSVGPathSegCurvetoCubicRel_y2Getter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGPathSegCurvetoCubicRel_y2Setter(JSGlobalObject& lexicalGlobalObject, JSSVGPathSegCurvetoCubicRel& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnrestrictedFloat>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setY2(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGPathSegCurvetoCubicRel_y2, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPathSegCurvetoCubicRel>::set<setJSSVGPathSegCurvetoCubicRel_y2Setter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGPathSegCurvetoCubicRel::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPathSegCurvetoCubicRel, UseCustomHeapCellType::No>(vm, "JSSVGPathSegCurvetoCubicRel"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPathSegCurvetoCubicRel.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPathSegCurvetoCubicRel = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPathSegCurvetoCubicRel.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPathSegCurvetoCubicRel = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPathSegCurvetoCubicRel::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPathSegCurvetoCubicRel*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}
