/*
 * Copyright (c) 2015 Canon Inc.
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WritableStreamInternalsBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

constinit const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsIsWritableStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsIsWritableStreamCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsIsWritableStreamCodeLength = 126;
static constinit const JSC::Intrinsic s_writableStreamInternalsIsWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsIsWritableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return @isObject(stream) && !!@getByIdDirectPrivate(stream, \"underlyingSink\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamDefaultWriterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamDefaultWriterCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsIsWritableStreamDefaultWriterCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsIsWritableStreamDefaultWriterCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsIsWritableStreamDefaultWriterCodeLength = 125;
static constinit const JSC::Intrinsic s_writableStreamInternalsIsWritableStreamDefaultWriterCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsIsWritableStreamDefaultWriterCode =
    "(function (writer)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return @isObject(writer) && !!@getByIdDirectPrivate(writer, \"closedPromise\");\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeLength = 77;
static constinit const JSC::Intrinsic s_writableStreamInternalsAcquireWritableStreamDefaultWriterCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsAcquireWritableStreamDefaultWriterCode =
    "(function (stream)\n" \
    "{\n" \
    "    return new @WritableStreamDefaultWriter(stream);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsCreateWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsCreateWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsCreateWritableStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsCreateWritableStreamCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsCreateWritableStreamCodeLength = 614;
static constinit const JSC::Intrinsic s_writableStreamInternalsCreateWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsCreateWritableStreamCode =
    "(function (startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm)\n" \
    "{\n" \
    "    @assert(typeof highWaterMark === \"number\" && highWaterMark === highWaterMark && highWaterMark >= 0);\n" \
    "\n" \
    "    const internalStream = { };\n" \
    "    @initializeWritableStreamSlots(internalStream, { });\n" \
    "    const controller = new @WritableStreamDefaultController(@isWritableStream);\n" \
    "\n" \
    "    @setUpWritableStreamDefaultController(internalStream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm);\n" \
    "\n" \
    "    return @createWritableStreamFromInternal(internalStream);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCodeLength = 1776;
static constinit const JSC::Intrinsic s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsCreateInternalWritableStreamFromUnderlyingSinkCode =
    "(function (underlyingSink, strategy)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = { };\n" \
    "\n" \
    "    if (underlyingSink === @undefined)\n" \
    "        underlyingSink = { };\n" \
    "\n" \
    "    if (strategy === @undefined)\n" \
    "        strategy = { };\n" \
    "\n" \
    "    if (!@isObject(underlyingSink))\n" \
    "        @throwTypeError(\"WritableStream constructor takes an object as first argument\");\n" \
    "\n" \
    "    if (\"type\" in underlyingSink)\n" \
    "        @throwRangeError(\"Invalid type is specified\");\n" \
    "\n" \
    "    const sizeAlgorithm = @extractSizeAlgorithm(strategy);\n" \
    "    const highWaterMark = @extractHighWaterMark(strategy, 1);\n" \
    "\n" \
    "    const underlyingSinkDict = { };\n" \
    "    if (\"start\" in underlyingSink) {\n" \
    "        underlyingSinkDict[\"start\"] = underlyingSink[\"start\"];\n" \
    "        if (typeof underlyingSinkDict[\"start\"] !== \"function\")\n" \
    "            @throwTypeError(\"underlyingSink.start should be a function\");\n" \
    "    }\n" \
    "    if (\"write\" in underlyingSink) {\n" \
    "        underlyingSinkDict[\"write\"] = underlyingSink[\"write\"];\n" \
    "        if (typeof underlyingSinkDict[\"write\"] !== \"function\")\n" \
    "            @throwTypeError(\"underlyingSink.write should be a function\");\n" \
    "    }\n" \
    "    if (\"close\" in underlyingSink) {\n" \
    "        underlyingSinkDict[\"close\"] = underlyingSink[\"close\"];\n" \
    "        if (typeof underlyingSinkDict[\"close\"] !== \"function\")\n" \
    "            @throwTypeError(\"underlyingSink.close should be a function\");\n" \
    "    }\n" \
    "    if (\"abort\" in underlyingSink) {\n" \
    "        underlyingSinkDict[\"abort\"] = underlyingSink[\"abort\"];\n" \
    "        if (typeof underlyingSinkDict[\"abort\"] !== \"function\")\n" \
    "            @throwTypeError(\"underlyingSink.abort should be a function\");\n" \
    "    }\n" \
    "\n" \
    "    @initializeWritableStreamSlots(stream, underlyingSink);\n" \
    "    @setUpWritableStreamDefaultControllerFromUnderlyingSink(stream, underlyingSink, underlyingSinkDict, highWaterMark, sizeAlgorithm);\n" \
    "\n" \
    "    return stream;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsInitializeWritableStreamSlotsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsInitializeWritableStreamSlotsCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsInitializeWritableStreamSlotsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsInitializeWritableStreamSlotsCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsInitializeWritableStreamSlotsCodeLength = 734;
static constinit const JSC::Intrinsic s_writableStreamInternalsInitializeWritableStreamSlotsCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsInitializeWritableStreamSlotsCode =
    "(function (stream, underlyingSink)\n" \
    "{\n" \
    "    @putByIdDirectPrivate(stream, \"state\", \"writable\");\n" \
    "    @putByIdDirectPrivate(stream, \"storedError\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"writer\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"controller\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightWriteRequest\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"closeRequest\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightCloseRequest\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"pendingAbortRequest\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"writeRequests\", []);\n" \
    "    @putByIdDirectPrivate(stream, \"backpressure\", false);\n" \
    "    @putByIdDirectPrivate(stream, \"underlyingSink\", underlyingSink);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamCloseForBindingsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamCloseForBindingsCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamCloseForBindingsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamCloseForBindingsCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamCloseForBindingsCodeLength = 417;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamCloseForBindingsCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamCloseForBindingsCode =
    "(function (stream)\n" \
    "{\n" \
    "    if (@isWritableStreamLocked(stream))\n" \
    "        return @Promise.@reject(@makeTypeError(\"WritableStream.close method can only be used on non locked WritableStream\"));\n" \
    "\n" \
    "    if (@writableStreamCloseQueuedOrInFlight(stream))\n" \
    "        return @Promise.@reject(@makeTypeError(\"WritableStream.close method can only be used on a being close WritableStream\"));\n" \
    "\n" \
    "    return @writableStreamClose(stream);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAbortForBindingsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamAbortForBindingsCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamAbortForBindingsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamAbortForBindingsCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamAbortForBindingsCodeLength = 249;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamAbortForBindingsCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamAbortForBindingsCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    if (@isWritableStreamLocked(stream))\n" \
    "        return @Promise.@reject(@makeTypeError(\"WritableStream.abort method can only be used on non locked WritableStream\"));\n" \
    "\n" \
    "    return @writableStreamAbort(stream, reason);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsIsWritableStreamLockedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsIsWritableStreamLockedCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsIsWritableStreamLockedCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsIsWritableStreamLockedCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsIsWritableStreamLockedCodeLength = 91;
static constinit const JSC::Intrinsic s_writableStreamInternalsIsWritableStreamLockedCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsIsWritableStreamLockedCode =
    "(function (stream)\n" \
    "{\n" \
    "    return @getByIdDirectPrivate(stream, \"writer\") !== @undefined;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeLength = 1512;
static constinit const JSC::Intrinsic s_writableStreamInternalsSetUpWritableStreamDefaultWriterCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsSetUpWritableStreamDefaultWriterCode =
    "(function (writer, stream)\n" \
    "{\n" \
    "    if (@isWritableStreamLocked(stream))\n" \
    "        @throwTypeError(\"WritableStream is locked\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(writer, \"stream\", stream);\n" \
    "    @putByIdDirectPrivate(stream, \"writer\", writer);\n" \
    "\n" \
    "    const readyPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    const closedPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    @putByIdDirectPrivate(writer, \"readyPromise\", readyPromiseCapability);\n" \
    "    @putByIdDirectPrivate(writer, \"closedPromise\", closedPromiseCapability);\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === \"writable\") {\n" \
    "        if (@writableStreamCloseQueuedOrInFlight(stream) || !@getByIdDirectPrivate(stream, \"backpressure\"))\n" \
    "            readyPromiseCapability.resolve.@call();\n" \
    "    } else if (state === \"erroring\") {\n" \
    "        readyPromiseCapability.reject.@call(@undefined, @getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "        @markPromiseAsHandled(readyPromiseCapability.promise);\n" \
    "    } else if (state === \"closed\") {\n" \
    "        readyPromiseCapability.resolve.@call();\n" \
    "        closedPromiseCapability.resolve.@call();\n" \
    "    } else {\n" \
    "        @assert(state === \"errored\");\n" \
    "        const storedError = @getByIdDirectPrivate(stream, \"storedError\");\n" \
    "        readyPromiseCapability.reject.@call(@undefined, storedError);\n" \
    "        @markPromiseAsHandled(readyPromiseCapability.promise);\n" \
    "        closedPromiseCapability.reject.@call(@undefined, storedError);\n" \
    "        @markPromiseAsHandled(closedPromiseCapability.promise);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAbortCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamAbortCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamAbortCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamAbortCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamAbortCodeLength = 1048;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamAbortCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamAbortCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === \"closed\" || state === \"errored\")\n" \
    "        return @Promise.@resolve();\n" \
    "\n" \
    "    const controller = @getByIdDirectPrivate(stream, \"controller\");\n" \
    "    @signalAbort(@getByIdDirectPrivate(controller, \"signal\"), reason);\n" \
    "\n" \
    "    const pendingAbortRequest = @getByIdDirectPrivate(stream, \"pendingAbortRequest\");\n" \
    "    if (pendingAbortRequest !== @undefined)\n" \
    "        return pendingAbortRequest.promise.promise;\n" \
    "\n" \
    "    @assert(state === \"writable\" || state === \"erroring\");\n" \
    "    let wasAlreadyErroring = false;\n" \
    "    if (state === \"erroring\") {\n" \
    "        wasAlreadyErroring = true;\n" \
    "        reason = @undefined;\n" \
    "    }\n" \
    "\n" \
    "    const abortPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    @putByIdDirectPrivate(stream, \"pendingAbortRequest\", { promise : abortPromiseCapability, reason : reason, wasAlreadyErroring : wasAlreadyErroring });\n" \
    "\n" \
    "    if (!wasAlreadyErroring)\n" \
    "        @writableStreamStartErroring(stream, reason);\n" \
    "    return abortPromiseCapability.promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamErrorIfPossibleCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamErrorIfPossibleCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamErrorIfPossibleCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamErrorIfPossibleCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamErrorIfPossibleCodeLength = 268;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamErrorIfPossibleCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamErrorIfPossibleCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state !== \"writable\")\n" \
    "        return;\n" \
    "\n" \
    "    const controller = @getByIdDirectPrivate(stream, \"controller\");\n" \
    "    @writableStreamDefaultControllerError(controller, reason);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamCloseIfPossibleCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamCloseIfPossibleCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamCloseIfPossibleCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamCloseIfPossibleCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamCloseIfPossibleCodeLength = 215;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamCloseIfPossibleCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamCloseIfPossibleCode =
    "(function (stream)\n" \
    "{\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state !== \"writable\")\n" \
    "        return;\n" \
    "\n" \
    "    const promise = @writableStreamClose(stream);\n" \
    "    @markPromiseAsHandled(promise);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamCloseCodeLength = 883;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamCloseCode =
    "(function (stream)\n" \
    "{\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === \"closed\" || state === \"errored\")\n" \
    "        return @Promise.@reject(@makeTypeError(\"Cannot close a writable stream that is closed or errored\"));\n" \
    "\n" \
    "    @assert(state === \"writable\" || state === \"erroring\");\n" \
    "    @assert(!@writableStreamCloseQueuedOrInFlight(stream));\n" \
    "\n" \
    "    const closePromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    @putByIdDirectPrivate(stream, \"closeRequest\", closePromiseCapability);\n" \
    "\n" \
    "    const writer = @getByIdDirectPrivate(stream, \"writer\");\n" \
    "    if (writer !== @undefined && @getByIdDirectPrivate(stream, \"backpressure\") && state === \"writable\")\n" \
    "        @getByIdDirectPrivate(writer, \"readyPromise\").resolve.@call();\n" \
    "        \n" \
    "    @writableStreamDefaultControllerClose(@getByIdDirectPrivate(stream, \"controller\"));\n" \
    "\n" \
    "    return closePromiseCapability.promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamAddWriteRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamAddWriteRequestCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamAddWriteRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamAddWriteRequestCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamAddWriteRequestCodeLength = 378;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamAddWriteRequestCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamAddWriteRequestCode =
    "(function (stream)\n" \
    "{\n" \
    "    @assert(@isWritableStreamLocked(stream))\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === \"writable\");\n" \
    "\n" \
    "    const writePromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    const writeRequests = @getByIdDirectPrivate(stream, \"writeRequests\");\n" \
    "    @arrayPush(writeRequests, writePromiseCapability);\n" \
    "    return writePromiseCapability.promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeLength = 169;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamCloseQueuedOrInFlightCode =
    "(function (stream)\n" \
    "{\n" \
    "    return @getByIdDirectPrivate(stream, \"closeRequest\") !== @undefined || @getByIdDirectPrivate(stream, \"inFlightCloseRequest\") !== @undefined;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDealWithRejectionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDealWithRejectionCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDealWithRejectionCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDealWithRejectionCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDealWithRejectionCodeLength = 275;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDealWithRejectionCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDealWithRejectionCode =
    "(function (stream, error)\n" \
    "{\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === \"writable\") {\n" \
    "        @writableStreamStartErroring(stream, error);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @assert(state === \"erroring\");\n" \
    "    @writableStreamFinishErroring(stream);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishErroringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishErroringCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamFinishErroringCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamFinishErroringCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamFinishErroringCodeLength = 1539;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamFinishErroringCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamFinishErroringCode =
    "(function (stream)\n" \
    "{\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === \"erroring\");\n" \
    "    @assert(!@writableStreamHasOperationMarkedInFlight(stream));\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"state\", \"errored\");\n" \
    "\n" \
    "    const controller = @getByIdDirectPrivate(stream, \"controller\");\n" \
    "    @getByIdDirectPrivate(controller, \"errorSteps\").@call();\n" \
    "\n" \
    "    const storedError = @getByIdDirectPrivate(stream, \"storedError\");\n" \
    "    const requests = @getByIdDirectPrivate(stream, \"writeRequests\");\n" \
    "    for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "        requests[index].reject.@call(@undefined, storedError);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"writeRequests\", []);\n" \
    "\n" \
    "    const abortRequest = @getByIdDirectPrivate(stream, \"pendingAbortRequest\");\n" \
    "    if (abortRequest === @undefined) {\n" \
    "        @writableStreamRejectCloseAndClosedPromiseIfNeeded(stream);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"pendingAbortRequest\", @undefined);\n" \
    "    if (abortRequest.wasAlreadyErroring) {\n" \
    "        abortRequest.promise.reject.@call(@undefined, storedError);\n" \
    "        @writableStreamRejectCloseAndClosedPromiseIfNeeded(stream);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @getByIdDirectPrivate(controller, \"abortSteps\").@call(@undefined, abortRequest.reason).@then(() => {\n" \
    "        abortRequest.promise.resolve.@call();\n" \
    "        @writableStreamRejectCloseAndClosedPromiseIfNeeded(stream);\n" \
    "    }, (reason) => {\n" \
    "        abortRequest.promise.reject.@call(@undefined, reason);\n" \
    "        @writableStreamRejectCloseAndClosedPromiseIfNeeded(stream);\n" \
    "    });\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeLength = 1089;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamFinishInFlightCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamFinishInFlightCloseCode =
    "(function (stream)\n" \
    "{\n" \
    "    const inFlightCloseRequest = @getByIdDirectPrivate(stream, \"inFlightCloseRequest\");\n" \
    "    inFlightCloseRequest.resolve.@call();\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightCloseRequest\", @undefined);\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    @assert(state === \"writable\" || state === \"erroring\");\n" \
    "\n" \
    "    if (state === \"erroring\") {\n" \
    "        @putByIdDirectPrivate(stream, \"storedError\", @undefined);\n" \
    "        const abortRequest = @getByIdDirectPrivate(stream, \"pendingAbortRequest\");\n" \
    "        if (abortRequest !== @undefined) {\n" \
    "            abortRequest.promise.resolve.@call();\n" \
    "            @putByIdDirectPrivate(stream, \"pendingAbortRequest\", @undefined);\n" \
    "        }\n" \
    "    }\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"state\", \"closed\");\n" \
    "\n" \
    "    const writer = @getByIdDirectPrivate(stream, \"writer\");\n" \
    "    if (writer !== @undefined)\n" \
    "        @getByIdDirectPrivate(writer, \"closedPromise\").resolve.@call();\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"pendingAbortRequest\") === @undefined);\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"storedError\") === @undefined);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeLength = 732;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamFinishInFlightCloseWithErrorCode =
    "(function (stream, error)\n" \
    "{\n" \
    "    const inFlightCloseRequest = @getByIdDirectPrivate(stream, \"inFlightCloseRequest\");\n" \
    "    @assert(inFlightCloseRequest !== @undefined);\n" \
    "    inFlightCloseRequest.reject.@call(@undefined, error);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightCloseRequest\", @undefined);\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    @assert(state === \"writable\" || state === \"erroring\");\n" \
    "\n" \
    "    const abortRequest = @getByIdDirectPrivate(stream, \"pendingAbortRequest\");\n" \
    "    if (abortRequest !== @undefined) {\n" \
    "        abortRequest.promise.reject.@call(@undefined, error);\n" \
    "        @putByIdDirectPrivate(stream, \"pendingAbortRequest\", @undefined);\n" \
    "    }\n" \
    "\n" \
    "    @writableStreamDealWithRejection(stream, error);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeLength = 276;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamFinishInFlightWriteCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamFinishInFlightWriteCode =
    "(function (stream)\n" \
    "{\n" \
    "    const inFlightWriteRequest = @getByIdDirectPrivate(stream, \"inFlightWriteRequest\");\n" \
    "    @assert(inFlightWriteRequest !== @undefined);\n" \
    "    inFlightWriteRequest.resolve.@call();\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightWriteRequest\", @undefined);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeLength = 471;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamFinishInFlightWriteWithErrorCode =
    "(function (stream, error)\n" \
    "{\n" \
    "    const inFlightWriteRequest = @getByIdDirectPrivate(stream, \"inFlightWriteRequest\");\n" \
    "    @assert(inFlightWriteRequest !== @undefined);\n" \
    "    inFlightWriteRequest.reject.@call(@undefined, error);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightWriteRequest\", @undefined);\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    @assert(state === \"writable\" || state === \"erroring\");\n" \
    "\n" \
    "    @writableStreamDealWithRejection(stream, error);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeLength = 177;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamHasOperationMarkedInFlightCode =
    "(function (stream)\n" \
    "{\n" \
    "    return @getByIdDirectPrivate(stream, \"inFlightWriteRequest\") !== @undefined || @getByIdDirectPrivate(stream, \"inFlightCloseRequest\") !== @undefined;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeLength = 358;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamMarkCloseRequestInFlightCode =
    "(function (stream)\n" \
    "{\n" \
    "    const closeRequest = @getByIdDirectPrivate(stream, \"closeRequest\");\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"inFlightCloseRequest\") === @undefined);\n" \
    "    @assert(closeRequest !== @undefined);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightCloseRequest\", closeRequest);\n" \
    "    @putByIdDirectPrivate(stream, \"closeRequest\", @undefined);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeLength = 343;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamMarkFirstWriteRequestInFlightCode =
    "(function (stream)\n" \
    "{\n" \
    "    const writeRequests = @getByIdDirectPrivate(stream, \"writeRequests\");\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"inFlightWriteRequest\") === @undefined);\n" \
    "    @assert(writeRequests.length > 0);\n" \
    "\n" \
    "    const writeRequest = writeRequests.@shift();\n" \
    "    @putByIdDirectPrivate(stream, \"inFlightWriteRequest\", writeRequest);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeLength = 787;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamRejectCloseAndClosedPromiseIfNeededCode =
    "(function (stream)\n" \
    "{\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === \"errored\");\n" \
    "\n" \
    "    const storedError = @getByIdDirectPrivate(stream, \"storedError\");\n" \
    "\n" \
    "    const closeRequest = @getByIdDirectPrivate(stream, \"closeRequest\");\n" \
    "    if (closeRequest !== @undefined) {\n" \
    "        @assert(@getByIdDirectPrivate(stream, \"inFlightCloseRequest\") === @undefined);\n" \
    "        closeRequest.reject.@call(@undefined, storedError);\n" \
    "        @putByIdDirectPrivate(stream, \"closeRequest\", @undefined);\n" \
    "    }\n" \
    "\n" \
    "    const writer = @getByIdDirectPrivate(stream, \"writer\");\n" \
    "    if (writer !== @undefined) {\n" \
    "        const closedPromise = @getByIdDirectPrivate(writer, \"closedPromise\");\n" \
    "        closedPromise.reject.@call(@undefined, storedError);\n" \
    "        @markPromiseAsHandled(closedPromise.promise);\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamStartErroringCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamStartErroringCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamStartErroringCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamStartErroringCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamStartErroringCodeLength = 727;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamStartErroringCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamStartErroringCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"storedError\") === @undefined);\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === \"writable\");\n" \
    " \n" \
    "    const controller = @getByIdDirectPrivate(stream, \"controller\");\n" \
    "    @assert(controller !== @undefined);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"state\", \"erroring\");\n" \
    "    @putByIdDirectPrivate(stream, \"storedError\", reason);\n" \
    "\n" \
    "    const writer = @getByIdDirectPrivate(stream, \"writer\");\n" \
    "    if (writer !== @undefined)\n" \
    "        @writableStreamDefaultWriterEnsureReadyPromiseRejected(writer, reason);\n" \
    "\n" \
    "    if (!@writableStreamHasOperationMarkedInFlight(stream) && @getByIdDirectPrivate(controller, \"started\"))\n" \
    "        @writableStreamFinishErroring(stream);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamUpdateBackpressureCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamUpdateBackpressureCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamUpdateBackpressureCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamUpdateBackpressureCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamUpdateBackpressureCodeLength = 602;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamUpdateBackpressureCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamUpdateBackpressureCode =
    "(function (stream, backpressure)\n" \
    "{\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === \"writable\");\n" \
    "    @assert(!@writableStreamCloseQueuedOrInFlight(stream));\n" \
    "\n" \
    "    const writer = @getByIdDirectPrivate(stream, \"writer\");\n" \
    "    if (writer !== @undefined && backpressure !== @getByIdDirectPrivate(stream, \"backpressure\")) {\n" \
    "        if (backpressure)\n" \
    "           @putByIdDirectPrivate(writer, \"readyPromise\", @newPromiseCapability(@Promise));\n" \
    "        else\n" \
    "            @getByIdDirectPrivate(writer, \"readyPromise\").resolve.@call();\n" \
    "    }\n" \
    "    @putByIdDirectPrivate(stream, \"backpressure\", backpressure);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeLength = 177;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterAbortCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterAbortCode =
    "(function (writer, reason)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(writer, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "    return @writableStreamAbort(stream, reason);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeLength = 161;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterCloseCode =
    "(function (writer)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(writer, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "    return @writableStreamClose(stream);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeLength = 515;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterCloseWithErrorPropagationCode =
    "(function (writer)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(writer, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    if (@writableStreamCloseQueuedOrInFlight(stream) || state === \"closed\")\n" \
    "        return @Promise.@resolve();\n" \
    "\n" \
    "    if (state === \"errored\")\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "\n" \
    "    @assert(state === \"writable\" || state === \"erroring\");\n" \
    "    return @writableStreamDefaultWriterClose(writer);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeLength = 604;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterEnsureClosedPromiseRejectedCode =
    "(function (writer, error)\n" \
    "{\n" \
    "    let closedPromiseCapability = @getByIdDirectPrivate(writer, \"closedPromise\");\n" \
    "    let closedPromise = closedPromiseCapability.promise;\n" \
    "\n" \
    "    if ((@getPromiseInternalField(closedPromise, @promiseFieldFlags) & @promiseStateMask) !== @promiseStatePending) {\n" \
    "        closedPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "        closedPromise = closedPromiseCapability.promise;\n" \
    "        @putByIdDirectPrivate(writer, \"closedPromise\", closedPromiseCapability);\n" \
    "    }\n" \
    "\n" \
    "    closedPromiseCapability.reject.@call(@undefined, error);\n" \
    "    @markPromiseAsHandled(closedPromise);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeLength = 592;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterEnsureReadyPromiseRejectedCode =
    "(function (writer, error)\n" \
    "{\n" \
    "    let readyPromiseCapability = @getByIdDirectPrivate(writer, \"readyPromise\");\n" \
    "    let readyPromise = readyPromiseCapability.promise;\n" \
    "\n" \
    "    if ((@getPromiseInternalField(readyPromise, @promiseFieldFlags) & @promiseStateMask) !== @promiseStatePending) {\n" \
    "        readyPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "        readyPromise = readyPromiseCapability.promise;\n" \
    "        @putByIdDirectPrivate(writer, \"readyPromise\", readyPromiseCapability);\n" \
    "    }\n" \
    "\n" \
    "    readyPromiseCapability.reject.@call(@undefined, error);\n" \
    "    @markPromiseAsHandled(readyPromise);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeLength = 406;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterGetDesiredSizeCode =
    "(function (writer)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(writer, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    if (state === \"errored\" || state === \"erroring\")\n" \
    "        return null;\n" \
    "\n" \
    "    if (state === \"closed\")\n" \
    "        return 0;\n" \
    "\n" \
    "    return @writableStreamDefaultControllerGetDesiredSize(@getByIdDirectPrivate(stream, \"controller\"));\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeLength = 549;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterReleaseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterReleaseCode =
    "(function (writer)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(writer, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"writer\") === writer);\n" \
    "\n" \
    "    const releasedError = @makeTypeError(\"writableStreamDefaultWriterRelease\");\n" \
    "\n" \
    "    @writableStreamDefaultWriterEnsureReadyPromiseRejected(writer, releasedError);\n" \
    "    @writableStreamDefaultWriterEnsureClosedPromiseRejected(writer, releasedError);\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"writer\", @undefined);\n" \
    "    @putByIdDirectPrivate(writer, \"stream\", @undefined);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeLength = 1247;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultWriterWriteCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultWriterWriteCode =
    "(function (writer, chunk)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(writer, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "\n" \
    "    const controller = @getByIdDirectPrivate(stream, \"controller\");\n" \
    "    @assert(controller !== @undefined);\n" \
    "    const chunkSize = @writableStreamDefaultControllerGetChunkSize(controller, chunk);\n" \
    "\n" \
    "    if (stream !== @getByIdDirectPrivate(writer, \"stream\"))\n" \
    "        return @Promise.@reject(@makeTypeError(\"writer is not stream's writer\"));\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === \"errored\")\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "\n" \
    "    if (@writableStreamCloseQueuedOrInFlight(stream) || state === \"closed\")\n" \
    "        return @Promise.@reject(@makeTypeError(\"stream is closing or closed\"));\n" \
    "\n" \
    "    if (@writableStreamCloseQueuedOrInFlight(stream) || state === \"closed\")\n" \
    "        return @Promise.@reject(@makeTypeError(\"stream is closing or closed\"));\n" \
    "\n" \
    "    if (state === \"erroring\")\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "\n" \
    "    @assert(state === \"writable\");\n" \
    "\n" \
    "    const promise = @writableStreamAddWriteRequest(stream);\n" \
    "    @writableStreamDefaultControllerWrite(controller, chunk, chunkSize);\n" \
    "    return promise;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeLength = 1658;
static constinit const JSC::Intrinsic s_writableStreamInternalsSetUpWritableStreamDefaultControllerCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsSetUpWritableStreamDefaultControllerCode =
    "(function (stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm)\n" \
    "{\n" \
    "    @assert(@isWritableStream(stream));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"controller\") === @undefined);\n" \
    "\n" \
    "    @putByIdDirectPrivate(controller, \"stream\", stream);\n" \
    "    @putByIdDirectPrivate(stream, \"controller\", controller);\n" \
    "\n" \
    "    @resetQueue(@getByIdDirectPrivate(controller, \"queue\"));\n" \
    "\n" \
    "    @putByIdDirectPrivate(controller, \"signal\", @createAbortSignal());\n" \
    "    @putByIdDirectPrivate(controller, \"started\", false);\n" \
    "    @putByIdDirectPrivate(controller, \"strategySizeAlgorithm\", sizeAlgorithm);\n" \
    "    @putByIdDirectPrivate(controller, \"strategyHWM\", highWaterMark);\n" \
    "    @putByIdDirectPrivate(controller, \"writeAlgorithm\", writeAlgorithm);\n" \
    "    @putByIdDirectPrivate(controller, \"closeAlgorithm\", closeAlgorithm);\n" \
    "    @putByIdDirectPrivate(controller, \"abortAlgorithm\", abortAlgorithm);\n" \
    "\n" \
    "    const backpressure = @writableStreamDefaultControllerGetBackpressure(controller);\n" \
    "    @writableStreamUpdateBackpressure(stream, backpressure);\n" \
    "\n" \
    "    @Promise.@resolve(startAlgorithm.@call()).@then(() => {\n" \
    "        const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "        @assert(state === \"writable\" || state === \"erroring\");\n" \
    "        @putByIdDirectPrivate(controller, \"started\", true);\n" \
    "        @writableStreamDefaultControllerAdvanceQueueIfNeeded(controller);\n" \
    "    }, (error) => {\n" \
    "        const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "        @assert(state === \"writable\" || state === \"erroring\");\n" \
    "        @putByIdDirectPrivate(controller, \"started\", true);\n" \
    "        @writableStreamDealWithRejection(stream, error);\n" \
    "    });\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeLength = 1393;
static constinit const JSC::Intrinsic s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsSetUpWritableStreamDefaultControllerFromUnderlyingSinkCode =
    "(function (stream, underlyingSink, underlyingSinkDict, highWaterMark, sizeAlgorithm)\n" \
    "{\n" \
    "    const controller = new @WritableStreamDefaultController(@isWritableStream);\n" \
    "\n" \
    "    let startAlgorithm = () => { };\n" \
    "    let writeAlgorithm = () => { return @Promise.@resolve(); };\n" \
    "    let closeAlgorithm = () => { return @Promise.@resolve(); };\n" \
    "    let abortAlgorithm = () => { return @Promise.@resolve(); };\n" \
    "\n" \
    "    if (\"start\" in underlyingSinkDict) {\n" \
    "        const startMethod = underlyingSinkDict[\"start\"];\n" \
    "        startAlgorithm = () => @promiseInvokeOrNoopMethodNoCatch(underlyingSink, startMethod, [controller]);\n" \
    "    }\n" \
    "    if (\"write\" in underlyingSinkDict) {\n" \
    "        const writeMethod = underlyingSinkDict[\"write\"];\n" \
    "        writeAlgorithm = (chunk) => @promiseInvokeOrNoopMethod(underlyingSink, writeMethod, [chunk, controller]);\n" \
    "    }\n" \
    "    if (\"close\" in underlyingSinkDict) {\n" \
    "        const closeMethod = underlyingSinkDict[\"close\"];\n" \
    "        closeAlgorithm = () => @promiseInvokeOrNoopMethod(underlyingSink, closeMethod, []);\n" \
    "    }\n" \
    "    if (\"abort\" in underlyingSinkDict) {\n" \
    "        const abortMethod = underlyingSinkDict[\"abort\"];\n" \
    "        abortAlgorithm = (reason) => @promiseInvokeOrNoopMethod(underlyingSink, abortMethod, [reason]);\n" \
    "    }\n" \
    "\n" \
    "    @setUpWritableStreamDefaultController(stream, controller, startAlgorithm, writeAlgorithm, closeAlgorithm, abortAlgorithm, highWaterMark, sizeAlgorithm);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeLength = 865;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerAdvanceQueueIfNeededCode =
    "(function (controller)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"stream\");\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(controller, \"started\"))\n" \
    "        return;\n" \
    "\n" \
    "    @assert(stream !== @undefined);\n" \
    "    if (@getByIdDirectPrivate(stream, \"inFlightWriteRequest\") !== @undefined)\n" \
    "        return;\n" \
    "\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    @assert(state !== \"closed\" || state !== \"errored\");\n" \
    "    if (state === \"erroring\") {\n" \
    "        @writableStreamFinishErroring(stream);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").content.length === 0)\n" \
    "        return;\n" \
    "\n" \
    "    const value = @peekQueueValue(@getByIdDirectPrivate(controller, \"queue\"));\n" \
    "    if (value === @isCloseSentinel)\n" \
    "        @writableStreamDefaultControllerProcessClose(controller);\n" \
    "    else\n" \
    "        @writableStreamDefaultControllerProcessWrite(controller, value);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsIsCloseSentinelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsIsCloseSentinelCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsIsCloseSentinelCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsIsCloseSentinelCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsIsCloseSentinelCodeLength = 18;
static constinit const JSC::Intrinsic s_writableStreamInternalsIsCloseSentinelCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsIsCloseSentinelCode =
    "(function ()\n" \
    "{\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeLength = 311;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerClearAlgorithmsCode =
    "(function (controller)\n" \
    "{\n" \
    "    @putByIdDirectPrivate(controller, \"writeAlgorithm\", @undefined);\n" \
    "    @putByIdDirectPrivate(controller, \"closeAlgorithm\", @undefined);\n" \
    "    @putByIdDirectPrivate(controller, \"abortAlgorithm\", @undefined);\n" \
    "    @putByIdDirectPrivate(controller, \"strategySizeAlgorithm\", @undefined);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeLength = 190;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerCloseCode =
    "(function (controller)\n" \
    "{\n" \
    "    @enqueueValueWithSize(@getByIdDirectPrivate(controller, \"queue\"), @isCloseSentinel, 0);\n" \
    "    @writableStreamDefaultControllerAdvanceQueueIfNeeded(controller);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeLength = 318;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerErrorCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerErrorCode =
    "(function (controller, error)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"stream\");\n" \
    "    @assert(stream !== @undefined);\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === \"writable\");\n" \
    "\n" \
    "    @writableStreamDefaultControllerClearAlgorithms(controller);\n" \
    "    @writableStreamStartErroring(stream, error);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeLength = 228;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerErrorIfNeededCode =
    "(function (controller, error)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"stream\");\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === \"writable\")\n" \
    "        @writableStreamDefaultControllerError(controller, error);\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeLength = 141;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerGetBackpressureCode =
    "(function (controller)\n" \
    "{\n" \
    "    const desiredSize = @writableStreamDefaultControllerGetDesiredSize(controller);\n" \
    "    return desiredSize <= 0;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeLength = 257;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerGetChunkSizeCode =
    "(function (controller, chunk)\n" \
    "{\n" \
    "    try {\n" \
    "        return @getByIdDirectPrivate(controller, \"strategySizeAlgorithm\").@call(@undefined, chunk);\n" \
    "    } catch (e) {\n" \
    "        @writableStreamDefaultControllerErrorIfNeeded(controller, e);\n" \
    "        return 1;\n" \
    "    }\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeLength = 139;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerGetDesiredSizeCode =
    "(function (controller)\n" \
    "{\n" \
    "    return @getByIdDirectPrivate(controller, \"strategyHWM\") - @getByIdDirectPrivate(controller, \"queue\").size;\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeLength = 630;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerProcessCloseCode =
    "(function (controller)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"stream\");\n" \
    "\n" \
    "    @writableStreamMarkCloseRequestInFlight(stream);\n" \
    "    @dequeueValue(@getByIdDirectPrivate(controller, \"queue\"));\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(controller, \"queue\").content.length === 0);\n" \
    "\n" \
    "    const sinkClosePromise = @getByIdDirectPrivate(controller, \"closeAlgorithm\").@call();\n" \
    "    @writableStreamDefaultControllerClearAlgorithms(controller);\n" \
    "\n" \
    "    sinkClosePromise.@then(() => {\n" \
    "        @writableStreamFinishInFlightClose(stream);\n" \
    "    }, (reason) => {\n" \
    "        @writableStreamFinishInFlightCloseWithError(stream, reason);\n" \
    "    });\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeLength = 1147;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerProcessWriteCode =
    "(function (controller, chunk)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"stream\");\n" \
    "\n" \
    "    @writableStreamMarkFirstWriteRequestInFlight(stream);\n" \
    "\n" \
    "    const sinkWritePromise = @getByIdDirectPrivate(controller, \"writeAlgorithm\").@call(@undefined, chunk);\n" \
    "\n" \
    "    sinkWritePromise.@then(() => {\n" \
    "        @writableStreamFinishInFlightWrite(stream);\n" \
    "        const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "        @assert(state === \"writable\" || state === \"erroring\");\n" \
    "\n" \
    "        @dequeueValue(@getByIdDirectPrivate(controller, \"queue\"));\n" \
    "        if (!@writableStreamCloseQueuedOrInFlight(stream) && state === \"writable\") {\n" \
    "            const backpressure = @writableStreamDefaultControllerGetBackpressure(controller);\n" \
    "            @writableStreamUpdateBackpressure(stream, backpressure);\n" \
    "        }\n" \
    "        @writableStreamDefaultControllerAdvanceQueueIfNeeded(controller);\n" \
    "    }, (reason) => {\n" \
    "        const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "        if (state === \"writable\")\n" \
    "            @writableStreamDefaultControllerClearAlgorithms(controller);\n" \
    "\n" \
    "        @writableStreamFinishInFlightWriteWithError(stream, reason);\n" \
    "    });\n" \
    "})\n" \
;

constinit const JSC::ConstructAbility s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
constinit const JSC::ConstructorKind s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeConstructorKind = JSC::ConstructorKind::None;
constinit const JSC::ImplementationVisibility s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
constinit const JSC::InlineAttribute s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeInlineAttribute = JSC::InlineAttribute::None;
constinit const int s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeLength = 707;
static constinit const JSC::Intrinsic s_writableStreamInternalsWritableStreamDefaultControllerWriteCodeIntrinsic = JSC::NoIntrinsic;
constinit const char* const s_writableStreamInternalsWritableStreamDefaultControllerWriteCode =
    "(function (controller, chunk, chunkSize)\n" \
    "{\n" \
    "    try {\n" \
    "        @enqueueValueWithSize(@getByIdDirectPrivate(controller, \"queue\"), chunk, chunkSize);\n" \
    "\n" \
    "        const stream = @getByIdDirectPrivate(controller, \"stream\");\n" \
    "\n" \
    "        const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "        if (!@writableStreamCloseQueuedOrInFlight(stream) && state === \"writable\") {\n" \
    "            const backpressure = @writableStreamDefaultControllerGetBackpressure(controller);\n" \
    "            @writableStreamUpdateBackpressure(stream, backpressure);\n" \
    "        }\n" \
    "        @writableStreamDefaultControllerAdvanceQueueIfNeeded(controller);\n" \
    "    } catch (e) {\n" \
    "        @writableStreamDefaultControllerErrorIfNeeded(controller, e);\n" \
    "    }\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = downcast<JSVMClientData>(vm.clientData); \
    return clientData->builtinFunctions().writableStreamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().writableStreamInternalsBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
