// MicrotonalUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef MicrotonalUI_h
#define MicrotonalUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009, Alan Calvert
// Copyright 2016-2024, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.


#include <FL/fl_ask.H>
#include "Misc/Microtonal.h"
#include "UI/MiscGui.h"
    #include "EffUI.h"
    #include "BankUI.h"
    #include "ADnoteUI.h"
    #include "SUBnoteUI.h"
    #include "PADnoteUI.h"
    #include "UI/WidgetMWSlider.h"
    #include "UI/WidgetCheckButton.h"
    #include "Interface/TextLists.h"
    #include "Params/Controller.h"
#include "UI/WidgetSpinner.h"
#include <FL/Fl_Group.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Value_Input.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Value_Output.H>
#include <FL/Fl_Box.H>

class MicrotonalUI {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *microtonaluiwindow;
private:
  inline void cb_microtonaluiwindow_i(ScaleTrackedWindow*, void*);
  static void cb_microtonaluiwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Text_Display *invertlabel;
  Fl_Text_Display *keyslabel;
  Fl_Check_Button2 *invertKeys;
private:
  inline void cb_invertKeys_i(Fl_Check_Button2*, void*);
  static void cb_invertKeys(Fl_Check_Button2*, void*);
public:
  Fl_Text_Display *centerlabel;
  WidgetSpinner *centerinvertcounter;
private:
  inline void cb_centerinvertcounter_i(WidgetSpinner*, void*);
  static void cb_centerinvertcounter(WidgetSpinner*, void*);
public:
  Fl_Text_Display *reflabel;
  Fl_Text_Display *notelabel;
  WidgetSpinner *anotecounter;
private:
  inline void cb_anotecounter_i(WidgetSpinner*, void*);
  static void cb_anotecounter(WidgetSpinner*, void*);
public:
  Fl_Value_Input *afreqinput;
private:
  inline void cb_afreqinput_i(Fl_Value_Input*, void*);
  static void cb_afreqinput(Fl_Value_Input*, void*);
public:
  Fl_Button *AsetBack;
private:
  inline void cb_AsetBack_i(Fl_Button*, void*);
  static void cb_AsetBack(Fl_Button*, void*);
public:
  Fl_Return_Button *afreqset;
private:
  inline void cb_afreqset_i(Fl_Return_Button*, void*);
  static void cb_afreqset(Fl_Return_Button*, void*);
public:
  Fl_Group *microtonalgroup;
  Fl_Input *nameinput;
private:
  inline void cb_nameinput_i(Fl_Input*, void*);
  static void cb_nameinput(Fl_Input*, void*);
public:
  Fl_Input *commentinput;
private:
  inline void cb_commentinput_i(Fl_Input*, void*);
  static void cb_commentinput(Fl_Input*, void*);
public:
  Fl_Text_Display *shiftlabel;
  WidgetSpinner *scaleShift;
private:
  inline void cb_scaleShift_i(WidgetSpinner*, void*);
  static void cb_scaleShift(WidgetSpinner*, void*);
public:
  Fl_Group *Tuning;
  Fl_Input *tuningsinput;
  Fl_Value_Output *octavesizeoutput;
private:
  inline void cb_octavesizeoutput_i(Fl_Value_Output*, void*);
  static void cb_octavesizeoutput(Fl_Value_Output*, void*);
public:
  Fl_Button *importscl;
private:
  inline void cb_importscl_i(Fl_Button*, void*);
  static void cb_importscl(Fl_Button*, void*);
public:
  Fl_Button *exportscl;
private:
  inline void cb_exportscl_i(Fl_Button*, void*);
  static void cb_exportscl(Fl_Button*, void*);
public:
  Fl_Group *Keymap;
  Fl_Input *mappinginput;
  Fl_Box *first1;
  Fl_Box *first2;
  WidgetSpinner *firstnotecounter;
private:
  inline void cb_firstnotecounter_i(WidgetSpinner*, void*);
  static void cb_firstnotecounter(WidgetSpinner*, void*);
public:
  Fl_Box *middle1;
  Fl_Box *middle2;
  WidgetSpinner *middlenotecounter;
private:
  inline void cb_middlenotecounter_i(WidgetSpinner*, void*);
  static void cb_middlenotecounter(WidgetSpinner*, void*);
public:
  Fl_Box *last1;
  Fl_Box *last2;
  WidgetSpinner *lastnotecounter;
private:
  inline void cb_lastnotecounter_i(WidgetSpinner*, void*);
  static void cb_lastnotecounter(WidgetSpinner*, void*);
public:
  WidgetSpinner *mapsizecounter;
  Fl_Button *exportkbm;
private:
  inline void cb_exportkbm_i(Fl_Button*, void*);
  static void cb_exportkbm(Fl_Button*, void*);
public:
  Fl_Check_Button2 *mappingenabledbutton;
private:
  inline void cb_mappingenabledbutton_i(Fl_Check_Button2*, void*);
  static void cb_mappingenabledbutton(Fl_Check_Button2*, void*);
public:
  Fl_Button *retunebutton;
private:
  inline void cb_retunebutton_i(Fl_Button*, void*);
  static void cb_retunebutton(Fl_Button*, void*);
public:
  Fl_Button *clearbutton;
private:
  inline void cb_clearbutton_i(Fl_Button*, void*);
  static void cb_clearbutton(Fl_Button*, void*);
public:
  Fl_Button *importkbm;
private:
  inline void cb_importkbm_i(Fl_Button*, void*);
  static void cb_importkbm(Fl_Button*, void*);
public:
  Fl_Text_Display *enablelabel;
  Fl_Text_Display *microtonallabel;
  Fl_Check_Button2 *enableMicrotonal;
private:
  inline void cb_enableMicrotonal_i(Fl_Check_Button2*, void*);
  static void cb_enableMicrotonal(Fl_Check_Button2*, void*);
public:
  Fl_Button *scaleClose;
private:
  inline void cb_scaleClose_i(Fl_Button*, void*);
  static void cb_scaleClose(Fl_Button*, void*);
public:
  void send_data(int action, int control, float value, int type, int par = UNUSED, int miscmsg = UNUSED);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED, int request = UNUSED);
  void returns_update(CommandBlock *getData);
  void updateTuningsInput();
  void updateMappingInput();
  string splitline(string& page);
  MicrotonalUI(Microtonal *microtonal_, SynthEngine *synth_);
  ~MicrotonalUI();
  void showScales();
  void scaleRtext();
  void retune();
  void checkInvert();
  void errors(int value, bool type);
private:
  Microtonal *microtonal;
  string winlabel;
  SynthEngine *synth;
  float refFreq;
  int scaleDW;
  int scaleDH;
public:
  int lastscaleW;
private:
  bool lastscaleSeen;
};
#endif
