#include <gio/gio.h>

#if defined (__ELF__) && ( __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 6))
# define SECTION __attribute__ ((section (".gresource.zathura_resources"), aligned (sizeof(void *) > 8 ? sizeof(void *) : 8)))
#else
# define SECTION
#endif

static const SECTION union { const guint8 data[1167]; const double alignment; void * const ptr;}  zathura_resources_resource_data = {
  "\107\126\141\162\151\141\156\164\000\000\000\000\000\000\000\000"
  "\030\000\000\000\000\001\000\000\000\000\000\050\010\000\000\000"
  "\000\000\000\000\002\000\000\000\003\000\000\000\004\000\000\000"
  "\005\000\000\000\006\000\000\000\007\000\000\000\007\000\000\000"
  "\210\242\151\120\001\000\000\000\000\001\000\000\004\000\114\000"
  "\004\001\000\000\010\001\000\000\060\141\226\026\003\000\000\000"
  "\010\001\000\000\010\000\114\000\020\001\000\000\030\001\000\000"
  "\261\302\374\222\000\000\000\000\030\001\000\000\015\000\166\000"
  "\050\001\000\000\245\001\000\000\202\017\143\031\004\000\000\000"
  "\245\001\000\000\005\000\114\000\254\001\000\000\260\001\000\000"
  "\113\120\220\013\005\000\000\000\260\001\000\000\004\000\114\000"
  "\264\001\000\000\270\001\000\000\324\265\002\000\377\377\377\377"
  "\270\001\000\000\001\000\114\000\274\001\000\000\300\001\000\000"
  "\055\123\247\135\001\000\000\000\300\001\000\000\005\000\114\000"
  "\310\001\000\000\314\001\000\000\067\210\035\203\006\000\000\000"
  "\314\001\000\000\024\000\166\000\340\001\000\000\216\004\000\000"
  "\103\123\123\057\002\000\000\000\172\141\164\150\165\162\141\057"
  "\000\000\000\000\006\000\000\000\172\141\164\150\165\162\141\056"
  "\143\163\163\137\164\000\000\000\317\000\000\000\001\000\000\000"
  "\170\332\323\327\122\360\314\113\111\255\120\310\315\117\111\125"
  "\110\316\317\311\057\052\126\320\322\347\342\122\166\050\116\055"
  "\056\316\314\317\163\120\320\313\004\251\000\053\250\346\122\200"
  "\050\262\122\160\000\213\352\246\245\073\130\003\005\223\022\223"
  "\263\323\213\362\113\363\122\164\121\345\223\100\362\265\070\314"
  "\263\052\116\315\111\115\056\111\115\301\142\160\142\162\111\146"
  "\131\052\101\363\241\312\240\326\000\000\244\231\104\343\000\050"
  "\165\165\141\171\051\160\167\155\164\057\000\000\001\000\000\000"
  "\157\162\147\057\003\000\000\000\057\000\000\000\004\000\000\000"
  "\104\102\165\163\057\000\000\000\007\000\000\000\157\162\147\056"
  "\160\167\155\164\056\172\141\164\150\165\162\141\056\170\155\154"
  "\163\012\000\000\001\000\000\000\170\332\275\126\311\156\333\060"
  "\020\275\347\053\046\047\265\100\055\266\327\302\311\041\266\233"
  "\006\050\232\040\033\332\123\101\213\043\211\255\104\012\134\242"
  "\270\137\337\241\026\073\116\055\327\156\026\003\006\264\314\173"
  "\174\363\146\206\342\370\160\172\076\271\376\176\061\003\245\005"
  "\302\305\315\311\227\263\011\104\043\306\122\203\050\320\376\162"
  "\272\142\154\172\075\205\351\350\344\346\012\316\347\077\061\161"
  "\160\246\234\321\266\242\113\251\025\174\210\337\063\066\373\032"
  "\035\000\104\271\163\325\107\306\352\272\216\037\120\304\332\144"
  "\314\072\256\004\067\302\062\061\367\226\005\224\134\362\304\302"
  "\211\350\370\140\034\164\034\023\321\230\136\241\111\171\202\240"
  "\170\211\107\021\061\304\125\135\272\370\067\167\271\067\074\012"
  "\121\024\167\070\032\301\171\205\012\070\010\235\370\022\225\003"
  "\031\356\214\127\112\252\014\272\170\172\030\004\044\030\303\150"
  "\324\141\113\164\271\026\335\002\201\144\332\061\164\344\024\302"
  "\115\006\156\121\321\173\033\165\201\025\021\106\040\244\151\323"
  "\077\212\244\212\200\155\107\130\133\153\043\166\102\311\025\052"
  "\303\235\020\363\036\141\320\171\243\326\060\332\273\045\150\314"
  "\332\204\037\070\067\051\264\105\320\301\277\336\275\041\177\232"
  "\320\155\006\075\101\306\251\006\247\251\146\241\025\144\052\023"
  "\010\271\303\220\222\123\355\364\105\060\147\203\010\377\232\356"
  "\365\262\033\265\324\334\220\313\054\057\350\357\040\120\160\225"
  "\025\150\301\345\150\006\273\356\163\217\270\044\200\175\236\214"
  "\370\033\101\277\267\253\274\172\051\073\242\375\032\334\142\242"
  "\303\334\056\176\354\111\364\237\306\126\206\332\321\270\305\343"
  "\041\112\145\201\341\052\002\236\044\150\155\340\345\142\305\362"
  "\010\267\146\233\362\345\034\315\276\310\026\245\323\300\140\167"
  "\004\057\345\366\343\044\125\252\207\260\313\275\013\205\164\332"
  "\100\055\135\016\231\274\243\047\122\125\336\101\310\031\270\203"
  "\102\252\266\301\022\135\370\122\075\150\046\053\063\305\213\156"
  "\315\031\321\154\335\272\032\326\301\102\154\156\273\260\366\236"
  "\220\126\345\226\202\267\252\127\056\164\134\173\314\023\314\271"
  "\105\001\364\365\241\133\010\046\233\222\207\245\072\252\253\205"
  "\112\256\361\033\120\171\356\044\175\205\200\002\232\320\307\366"
  "\276\373\313\334\206\141\363\264\006\126\207\367\267\022\353\075"
  "\175\036\032\222\141\233\377\211\330\340\362\013\354\161\263\173"
  "\114\274\043\203\310\236\262\014\066\161\013\062\005\014\337\147"
  "\252\200\354\053\100\031\317\271\031\332\347\072\232\111\313\361"
  "\114\346\075\041\255\113\054\064\017\045\127\251\314\350\170\320"
  "\034\144\232\161\033\250\274\366\046\041\371\041\074\172\055\051"
  "\251\321\145\070\327\064\124\332\054\166\320\366\211\040\323\076"
  "\176\253\315\113\326\027\263\172\314\226\207\070\072\331\261\366"
  "\150\367\007\226\074\076\154\000\050\165\165\141\171\051" };

static GStaticResource static_resource = { zathura_resources_resource_data.data, sizeof (zathura_resources_resource_data.data) - 1 /* nul terminator */, NULL, NULL, NULL };

G_GNUC_INTERNAL
GResource *zathura_resources_get_resource (void);
GResource *zathura_resources_get_resource (void)
{
  return g_static_resource_get_resource (&static_resource);
}
/* GLIB - Library of useful routines for C programming
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */

/*
 * Modified by the GLib Team and others 1997-2000.  See the AUTHORS
 * file for a list of people on the GLib Team.  See the ChangeLog
 * files for a list of changes.  These files are distributed with
 * GLib at ftp://ftp.gtk.org/pub/gtk/.
 */

#ifndef __G_CONSTRUCTOR_H__
#define __G_CONSTRUCTOR_H__

/*
  If G_HAS_CONSTRUCTORS is true then the compiler support *both* constructors and
  destructors, in a usable way, including e.g. on library unload. If not you're on
  your own.

  Some compilers need #pragma to handle this, which does not work with macros,
  so the way you need to use this is (for constructors):

  #ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
  #pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(my_constructor)
  #endif
  G_DEFINE_CONSTRUCTOR(my_constructor)
  static void my_constructor(void) {
   ...
  }

*/

#ifndef __GTK_DOC_IGNORE__

#if  __GNUC__ > 2 || (__GNUC__ == 2 && __GNUC_MINOR__ >= 7)

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR(_func) static void __attribute__((constructor)) _func (void);
#define G_DEFINE_DESTRUCTOR(_func) static void __attribute__((destructor)) _func (void);

#elif defined (_MSC_VER)

/*
 * Only try to include gslist.h if not already included via glib.h,
 * so that items using gconstructor.h outside of GLib (such as
 * GResources) continue to build properly.
 */
#ifndef __G_LIB_H__
#include "gslist.h"
#endif

#include <stdlib.h>

#define G_HAS_CONSTRUCTORS 1

/* We do some weird things to avoid the constructors being optimized
 * away on VS2015 if WholeProgramOptimization is enabled. First we
 * make a reference to the array from the wrapper to make sure its
 * references. Then we use a pragma to make sure the wrapper function
 * symbol is always included at the link stage. Also, the symbols
 * need to be extern (but not dllexport), even though they are not
 * really used from another object file.
 */

/* We need to account for differences between the mangling of symbols
 * for x86 and x64/ARM/ARM64 programs, as symbols on x86 are prefixed
 * with an underscore but symbols on x64/ARM/ARM64 are not.
 */
#ifdef _M_IX86
#define G_MSVC_SYMBOL_PREFIX "_"
#else
#define G_MSVC_SYMBOL_PREFIX ""
#endif

#define G_DEFINE_CONSTRUCTOR(_func) G_MSVC_CTOR (_func, G_MSVC_SYMBOL_PREFIX)
#define G_DEFINE_DESTRUCTOR(_func) G_MSVC_DTOR (_func, G_MSVC_SYMBOL_PREFIX)

#define G_MSVC_CTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _wrapper(void);              \
  int _func ## _wrapper(void) { _func(); g_slist_find (NULL,  _array ## _func); return 0; } \
  __pragma(comment(linker,"/include:" _sym_prefix # _func "_wrapper")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _wrapper;

#define G_MSVC_DTOR(_func,_sym_prefix) \
  static void _func(void); \
  extern int (* _array ## _func)(void);              \
  int _func ## _constructor(void);              \
  int _func ## _constructor(void) { atexit (_func); g_slist_find (NULL,  _array ## _func); return 0; } \
   __pragma(comment(linker,"/include:" _sym_prefix # _func "_constructor")) \
  __pragma(section(".CRT$XCU",read)) \
  __declspec(allocate(".CRT$XCU")) int (* _array ## _func)(void) = _func ## _constructor;

#elif defined(__SUNPRO_C)

/* This is not tested, but i believe it should work, based on:
 * http://opensource.apple.com/source/OpenSSL098/OpenSSL098-35/src/fips/fips_premain.c
 */

#define G_HAS_CONSTRUCTORS 1

#define G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA 1
#define G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA 1

#define G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(_func) \
  init(_func)
#define G_DEFINE_CONSTRUCTOR(_func) \
  static void _func(void);

#define G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(_func) \
  fini(_func)
#define G_DEFINE_DESTRUCTOR(_func) \
  static void _func(void);

#else

/* constructors not supported for this compiler */

#endif

#endif /* __GTK_DOC_IGNORE__ */
#endif /* __G_CONSTRUCTOR_H__ */

#ifdef G_HAS_CONSTRUCTORS

#ifdef G_DEFINE_CONSTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_CONSTRUCTOR_PRAGMA_ARGS(zathura_resourcesresource_constructor)
#endif
G_DEFINE_CONSTRUCTOR(zathura_resourcesresource_constructor)
#ifdef G_DEFINE_DESTRUCTOR_NEEDS_PRAGMA
#pragma G_DEFINE_DESTRUCTOR_PRAGMA_ARGS(zathura_resourcesresource_destructor)
#endif
G_DEFINE_DESTRUCTOR(zathura_resourcesresource_destructor)

#else
#warning "Constructor not supported on this compiler, linking in resources will not work"
#endif

static void zathura_resourcesresource_constructor (void)
{
  g_static_resource_init (&static_resource);
}

static void zathura_resourcesresource_destructor (void)
{
  g_static_resource_fini (&static_resource);
}
