/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.execution.target.TargetConfigurationWithLocalFsAccess;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.python.SdkUiUtilKt;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.TargetConfigurationWithLocalFsAccessExKt;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class PyConfigurableInterpreterList {
    private ProjectSdksModel myModel;

    public static PyConfigurableInterpreterList getInstance(@Nullable Project project) {
        Project effectiveProject = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        PyConfigurableInterpreterList instance = (PyConfigurableInterpreterList)effectiveProject.getService(PyConfigurableInterpreterList.class);
        if (effectiveProject != project) {
            instance.disposeModel();
        }
        return instance;
    }

    public ProjectSdksModel getModel() {
        if (this.myModel == null) {
            this.myModel = new ProjectSdksModel();
            this.myModel.reset(null);
        }
        return this.myModel;
    }

    public void disposeModel() {
        if (this.myModel != null) {
            this.myModel.disposeUIResources();
            this.myModel = null;
        }
    }

    @ApiStatus.Internal
    @NotNull
    public List<Sdk> getAllPythonSdks(@Nullable Project project, @Nullable Module module2, boolean allowRemoteInFreeTier) {
        TargetConfigurationWithLocalFsAccess targetModuleSitsOn = module2 != null ? PythonInterpreterTargetEnvironmentFactory.Companion.getTargetModuleResidesOn(module2) : null;
        ArrayList<Sdk> result2 = new ArrayList<Sdk>();
        for (Sdk sdk2 : this.getModel().getSdks()) {
            TargetEnvironmentConfiguration sdkConfig;
            if (!PythonSdkUtil.isPythonSdk((Sdk)sdk2, (boolean)allowRemoteInFreeTier) || targetModuleSitsOn != null && !TargetConfigurationWithLocalFsAccessExKt.codeCouldProbablyBeRunWithConfig(targetModuleSitsOn, sdkConfig = PySdkExtKt.getTargetEnvConfiguration(sdk2))) continue;
            result2.add(sdk2);
        }
        result2.sort(new PyInterpreterComparator(project));
        ArrayList<Sdk> arrayList = result2;
        if (arrayList == null) {
            PyConfigurableInterpreterList.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    public List<Sdk> getAllPythonSdks() {
        List<Sdk> list = this.getAllPythonSdks(null, null, false);
        if (list == null) {
            PyConfigurableInterpreterList.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/configuration/PyConfigurableInterpreterList", "getAllPythonSdks"));
    }

    private static class PyInterpreterComparator
    implements Comparator<Sdk> {
        @Nullable
        private final Project myProject;

        PyInterpreterComparator(@Nullable Project project) {
            this.myProject = project;
        }

        @Override
        public int compare(@NotNull Sdk o1, Sdk o2) {
            if (o1 == null) {
                PyInterpreterComparator.$$$reportNull$$$0(0);
            }
            if (!(o1.getSdkType() instanceof PythonSdkType) || !(o2.getSdkType() instanceof PythonSdkType)) {
                return -Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
            boolean isVEnv1 = SdkUiUtilKt.isVirtualEnv(o1) || SdkUiUtilKt.isCondaVirtualEnv(o1);
            boolean isVEnv2 = SdkUiUtilKt.isVirtualEnv(o2) || SdkUiUtilKt.isCondaVirtualEnv(o2);
            boolean isRemote1 = PythonSdkUtil.isRemote((Sdk)o1);
            boolean isRemote2 = PythonSdkUtil.isRemote((Sdk)o2);
            if (isVEnv1) {
                if (isVEnv2) {
                    if (this.myProject != null && PyInterpreterComparator.associatedWithCurrent(o1, this.myProject)) {
                        if (PyInterpreterComparator.associatedWithCurrent(o2, this.myProject)) {
                            return PyInterpreterComparator.compareSdk(o1, o2);
                        }
                        return -1;
                    }
                    return PyInterpreterComparator.compareSdk(o1, o2);
                }
                return -1;
            }
            if (isVEnv2) {
                return 1;
            }
            if (isRemote1) {
                if (isRemote2) {
                    return PyInterpreterComparator.compareSdk(o1, o2);
                }
                return 1;
            }
            if (isRemote2) {
                return -1;
            }
            return PyInterpreterComparator.compareSdk(o1, o2);
        }

        private static int compareSdk(Sdk o1, Sdk o2) {
            PythonSdkFlavor flavor2;
            LanguageLevel level2;
            PythonSdkFlavor flavor1 = PythonSdkFlavor.getFlavor((Sdk)o1);
            LanguageLevel level1 = flavor1 != null ? flavor1.getLanguageLevel(o1) : LanguageLevel.getDefault();
            int compare = Comparing.compare((Comparable)level1, (Comparable)(level2 = (flavor2 = PythonSdkFlavor.getFlavor((Sdk)o2)) != null ? flavor2.getLanguageLevel(o2) : LanguageLevel.getDefault()));
            if (compare != 0) {
                return -compare;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }

        private static boolean associatedWithCurrent(@NotNull Sdk o1, Project project) {
            PythonSdkAdditionalData data;
            if (o1 == null) {
                PyInterpreterComparator.$$$reportNull$$$0(1);
            }
            if ((data = (PythonSdkAdditionalData)o1.getSdkAdditionalData()) != null) {
                String path2 = data.getAssociatedModulePath();
                String projectBasePath = project.getBasePath();
                if (path2 != null && path2.equals(projectBasePath)) {
                    return true;
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "o1";
            objectArray2[1] = "com/jetbrains/python/configuration/PyConfigurableInterpreterList$PyInterpreterComparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "associatedWithCurrent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

