/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import javax.swing.JProgressBar;
import org.assertj.core.description.Description;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.driver.JProgressBarValueQuery;
import org.assertj.swing.edt.GuiLazyLoadingDescription;
import org.assertj.swing.format.Formatting;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.timing.Timeout;

final class JProgressBarWaitUntilValueIsEqualToExpectedTask {
    @RunsInEDT
    static void waitUntilValueIsEqualToExpected(final @Nonnull JProgressBar progressBar, final int expected, @Nonnull Timeout timeout) {
        Pause.pause(new Condition(JProgressBarWaitUntilValueIsEqualToExpectedTask.untilValueIsEqualTo(progressBar, expected)){

            @Override
            public boolean test() {
                return JProgressBarValueQuery.valueOf(progressBar) == expected;
            }
        }, timeout);
    }

    private static Description untilValueIsEqualTo(final @Nonnull JProgressBar progressBar, final int expected) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return String.format("value of %s to be equal to %d", Formatting.format(progressBar), expected);
            }
        };
    }

    private JProgressBarWaitUntilValueIsEqualToExpectedTask() {
    }
}

