/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.vcs.VcsNotifier;
import git4idea.branch.GitBranchOperation;
import git4idea.branch.GitBranchUiHandler;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitCompoundResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u0014\u001a\u00020\tH\u0014J\b\u0010\u0015\u001a\u00020\tH\u0014J\r\u0010\u0016\u001a\u00070\t\u00a2\u0006\u0002\b\u0017H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgit4idea/branch/GitCreateBranchOperation;", "Lgit4idea/branch/GitBranchOperation;", "project", "Lcom/intellij/openapi/project/Project;", "git", "Lgit4idea/commands/Git;", "uiHandler", "Lgit4idea/branch/GitBranchUiHandler;", "branchName", "", "startPoints", "", "Lgit4idea/repo/GitRepository;", "force", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/commands/Git;Lgit4idea/branch/GitBranchUiHandler;Ljava/lang/String;Ljava/util/Map;Z)V", "execute", "", "rollback", "getSuccessMessage", "getRollbackProposal", "getOperationName", "Lorg/jetbrains/annotations/Nls;", "intellij.vcs.git"})
public final class GitCreateBranchOperation
extends GitBranchOperation {
    @NotNull
    private final String branchName;
    @NotNull
    private final Map<GitRepository, String> startPoints;
    private final boolean force;

    public GitCreateBranchOperation(@NotNull Project project, @NotNull Git git, @NotNull GitBranchUiHandler uiHandler, @NotNull String branchName, @NotNull Map<GitRepository, String> startPoints, boolean force) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)uiHandler, (String)"uiHandler");
        Intrinsics.checkNotNullParameter((Object)branchName, (String)"branchName");
        Intrinsics.checkNotNullParameter(startPoints, (String)"startPoints");
        super(project, git, uiHandler, (Collection<? extends GitRepository>)startPoints.keySet());
        this.branchName = branchName;
        this.startPoints = startPoints;
        this.force = force;
    }

    @Override
    public void execute() {
        boolean fatalErrorHappened = false;
        while (this.hasMoreRepositories() && !fatalErrorHappened) {
            Object[] objectArray;
            GitCommandResult result2;
            GitRepository repository2;
            Intrinsics.checkNotNullExpressionValue((Object)this.next(), (String)"next(...)");
            String string = this.startPoints.get(repository2);
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)this.myGit.branchCreate(repository2, this.branchName, string, this.force), (String)"branchCreate(...)");
            if (result2.success()) {
                repository2.update();
                objectArray = new GitRepository[]{repository2};
                this.markSuccessful((GitRepository[])objectArray);
                continue;
            }
            objectArray = new Object[]{this.branchName};
            this.fatalError(GitBundle.message("create.branch.operation.could.not.create.new.branch", objectArray), result2);
            fatalErrorHappened = true;
        }
        if (!fatalErrorHappened) {
            this.notifySuccess();
            this.updateRecentBranch();
        }
    }

    @Override
    protected void rollback() {
        Collection<GitRepository> collection = this.getSuccessfulRepositories();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getSuccessfulRepositories(...)");
        Collection<GitRepository> repositories = collection;
        GitCompoundResult deleteResult = new GitCompoundResult(this.myProject);
        for (GitRepository repository2 : repositories) {
            deleteResult.append(repository2, this.myGit.branchDelete(repository2, this.branchName, false, new GitLineHandlerListener[0]));
            repository2.update();
        }
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.myProject);
        if (deleteResult.totalSuccess()) {
            Object[] objectArray = new Object[]{this.branchName};
            v1 = vcsNotifier.notifySuccess("git.create.branch.rollback.successful", GitBundle.message("create.branch.operation.rollback.successful", new Object[0]), GitBundle.message("create.branch.operation.deleted.branch", objectArray));
        } else {
            v1 = vcsNotifier.notifyError("git.create.branch.rollback.error", GitBundle.message("create.branch.operation.error.during.rollback", new Object[0]), deleteResult.getErrorOutputWithReposIndication(), true);
        }
    }

    @Override
    @NotNull
    protected String getSuccessMessage() {
        Object[] objectArray = new Object[]{GitUIUtil.code(this.branchName)};
        String string = GitBundle.message("create.branch.operation.branch.created", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getRollbackProposal() {
        Object[] objectArray = new Object[]{this.getSuccessfulRepositories().size()};
        HtmlBuilder htmlBuilder = new HtmlBuilder().append(GitBundle.message("create.branch.operation.however.the.branch.was.created.in.the.following.repositories", objectArray)).br().appendRaw(this.successfulRepositoriesJoined()).br();
        objectArray = new Object[]{this.branchName};
        String string = htmlBuilder.append(GitBundle.message("create.branch.operation.you.may.rollback.not.to.let.branches.diverge", objectArray)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    @NotNull
    protected String getOperationName() {
        String string = GitBundle.message("create.branch.operation.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

