﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/qapps/QAppsRequest.h>
#include <aws/qapps/QApps_EXPORTS.h>

#include <utility>

namespace Aws {
namespace QApps {
namespace Model {

/**
 */
class DeleteLibraryItemRequest : public QAppsRequest {
 public:
  AWS_QAPPS_API DeleteLibraryItemRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteLibraryItem"; }

  AWS_QAPPS_API Aws::String SerializePayload() const override;

  AWS_QAPPS_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The unique identifier of the Amazon Q Business application environment
   * instance.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  inline bool InstanceIdHasBeenSet() const { return m_instanceIdHasBeenSet; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  DeleteLibraryItemRequest& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the library item to delete.</p>
   */
  inline const Aws::String& GetLibraryItemId() const { return m_libraryItemId; }
  inline bool LibraryItemIdHasBeenSet() const { return m_libraryItemIdHasBeenSet; }
  template <typename LibraryItemIdT = Aws::String>
  void SetLibraryItemId(LibraryItemIdT&& value) {
    m_libraryItemIdHasBeenSet = true;
    m_libraryItemId = std::forward<LibraryItemIdT>(value);
  }
  template <typename LibraryItemIdT = Aws::String>
  DeleteLibraryItemRequest& WithLibraryItemId(LibraryItemIdT&& value) {
    SetLibraryItemId(std::forward<LibraryItemIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;

  Aws::String m_libraryItemId;
  bool m_instanceIdHasBeenSet = false;
  bool m_libraryItemIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace QApps
}  // namespace Aws
