# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class RuleSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule severity."""

    HIGH = "High"
    """High"""
    MEDIUM = "Medium"
    """Medium"""
    LOW = "Low"
    """Low"""
    INFORMATIONAL = "Informational"
    """Informational"""
    OBSOLETE = "Obsolete"
    """Obsolete"""


class RuleStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule result status."""

    NON_FINDING = "NonFinding"
    """NonFinding"""
    FINDING = "Finding"
    """Finding"""
    INTERNAL_ERROR = "InternalError"
    """InternalError"""


class RuleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The rule type."""

    BINARY = "Binary"
    """Binary"""
    BASELINE_EXPECTED = "BaselineExpected"
    """BaselineExpected"""
    POSITIVE_LIST = "PositiveList"
    """PositiveList"""
    NEGATIVE_LIST = "NegativeList"
    """NegativeList"""


class ScanState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scan status."""

    FAILED = "Failed"
    """Failed"""
    FAILED_TO_RUN = "FailedToRun"
    """FailedToRun"""
    IN_PROGRESS = "InProgress"
    """InProgress"""
    PASSED = "Passed"
    """Passed"""


class ScanTriggerType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The scan trigger type."""

    ON_DEMAND = "OnDemand"
    """OnDemand"""
    RECURRING = "Recurring"
    """Recurring"""
