/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.collection.DependencyGraphTransformer;
import org.eclipse.aether.collection.DependencyTraverser;
import org.eclipse.aether.collection.VersionFilter;
import org.eclipse.aether.graph.DefaultDependencyNode;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.impl.VersionRangeResolver;
import org.eclipse.aether.internal.impl.collect.CachingArtifactTypeRegistry;
import org.eclipse.aether.internal.impl.collect.CollectStepDataImpl;
import org.eclipse.aether.internal.impl.collect.DataPool;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCollectionContext;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyCycle;
import org.eclipse.aether.internal.impl.collect.DefaultDependencyGraphTransformationContext;
import org.eclipse.aether.internal.impl.collect.DefaultVersionFilterContext;
import org.eclipse.aether.internal.impl.collect.PremanagedDependency;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.util.ConfigUtils;
import org.eclipse.aether.util.graph.transformer.TransformationContextKeys;
import org.eclipse.aether.version.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DependencyCollectorDelegate
implements DependencyCollector {
    protected static final String CONFIG_PROP_MAX_EXCEPTIONS = "aether.dependencyCollector.maxExceptions";
    protected static final int CONFIG_PROP_MAX_EXCEPTIONS_DEFAULT = 50;
    protected static final String CONFIG_PROP_MAX_CYCLES = "aether.dependencyCollector.maxCycles";
    protected static final int CONFIG_PROP_MAX_CYCLES_DEFAULT = 10;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected RemoteRepositoryManager remoteRepositoryManager;
    protected ArtifactDescriptorReader descriptorReader;
    protected VersionRangeResolver versionRangeResolver;

    @Deprecated
    protected DependencyCollectorDelegate() {
    }

    protected DependencyCollectorDelegate(RemoteRepositoryManager remoteRepositoryManager, ArtifactDescriptorReader artifactDescriptorReader, VersionRangeResolver versionRangeResolver) {
        this.setRemoteRepositoryManager(remoteRepositoryManager);
        this.setArtifactDescriptorReader(artifactDescriptorReader);
        this.setVersionRangeResolver(versionRangeResolver);
    }

    public void initService(ServiceLocator locator) {
        this.setRemoteRepositoryManager(locator.getService(RemoteRepositoryManager.class));
        this.setArtifactDescriptorReader(locator.getService(ArtifactDescriptorReader.class));
        this.setVersionRangeResolver(locator.getService(VersionRangeResolver.class));
    }

    public DependencyCollector setRemoteRepositoryManager(RemoteRepositoryManager remoteRepositoryManager) {
        this.remoteRepositoryManager = Objects.requireNonNull(remoteRepositoryManager, "remote repository manager cannot be null");
        return this;
    }

    public DependencyCollector setArtifactDescriptorReader(ArtifactDescriptorReader artifactDescriptorReader) {
        this.descriptorReader = Objects.requireNonNull(artifactDescriptorReader, "artifact descriptor reader cannot be null");
        return this;
    }

    public DependencyCollector setVersionRangeResolver(VersionRangeResolver versionRangeResolver) {
        this.versionRangeResolver = Objects.requireNonNull(versionRangeResolver, "version range resolver cannot be null");
        return this;
    }

    @Override
    public final CollectResult collectDependencies(RepositorySystemSession session2, CollectRequest request) throws DependencyCollectionException {
        DefaultDependencyNode node2;
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(request, "request cannot be null");
        session2 = this.optimizeSession(session2);
        RequestTrace trace2 = RequestTrace.newChild(request.getTrace(), request);
        CollectResult result = new CollectResult(request);
        DependencyTraverser depTraverser = session2.getDependencyTraverser();
        VersionFilter verFilter = session2.getVersionFilter();
        Dependency root2 = request.getRoot();
        List<RemoteRepository> repositories = request.getRepositories();
        List<Dependency> dependencies = request.getDependencies();
        List<Dependency> managedDependencies = request.getManagedDependencies();
        LinkedHashMap<String, Long> stats = new LinkedHashMap<String, Long>();
        long time1 = System.nanoTime();
        if (root2 != null) {
            ArtifactDescriptorResult descriptorResult;
            List<? extends Version> versions;
            VersionRangeResult rangeResult;
            try {
                VersionRangeRequest rangeRequest = new VersionRangeRequest(root2.getArtifact(), request.getRepositories(), request.getRequestContext());
                rangeRequest.setTrace(trace2);
                rangeResult = this.versionRangeResolver.resolveVersionRange(session2, rangeRequest);
                versions = DependencyCollectorDelegate.filterVersions(root2, rangeResult, verFilter, new DefaultVersionFilterContext(session2));
            }
            catch (VersionRangeResolutionException e2) {
                result.addException(e2);
                throw new DependencyCollectionException(result, e2.getMessage());
            }
            Version version = versions.get(versions.size() - 1);
            root2 = root2.setArtifact(root2.getArtifact().setVersion(version.toString()));
            try {
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(root2.getArtifact());
                descriptorRequest.setRepositories(request.getRepositories());
                descriptorRequest.setRequestContext(request.getRequestContext());
                descriptorRequest.setTrace(trace2);
                descriptorResult = DependencyCollectorDelegate.isLackingDescriptor(root2.getArtifact()) ? new ArtifactDescriptorResult(descriptorRequest) : this.descriptorReader.readArtifactDescriptor(session2, descriptorRequest);
            }
            catch (ArtifactDescriptorException e3) {
                result.addException(e3);
                throw new DependencyCollectionException(result, e3.getMessage());
            }
            root2 = root2.setArtifact(descriptorResult.getArtifact());
            if (!session2.isIgnoreArtifactDescriptorRepositories()) {
                repositories = this.remoteRepositoryManager.aggregateRepositories(session2, repositories, descriptorResult.getRepositories(), true);
            }
            dependencies = this.mergeDeps(dependencies, descriptorResult.getDependencies());
            managedDependencies = this.mergeDeps(managedDependencies, descriptorResult.getManagedDependencies());
            node2 = new DefaultDependencyNode(root2);
            node2.setRequestContext(request.getRequestContext());
            node2.setRelocations(descriptorResult.getRelocations());
            node2.setVersionConstraint(rangeResult.getVersionConstraint());
            node2.setVersion(version);
            node2.setAliases(descriptorResult.getAliases());
            node2.setRepositories(request.getRepositories());
        } else {
            node2 = new DefaultDependencyNode(request.getRootArtifact());
            node2.setRequestContext(request.getRequestContext());
            node2.setRepositories(request.getRepositories());
        }
        result.setRoot(node2);
        boolean traverse = root2 == null || depTraverser == null || depTraverser.traverseDependency(root2);
        String errorPath = null;
        if (traverse && !dependencies.isEmpty()) {
            DataPool pool = new DataPool(session2);
            DefaultDependencyCollectionContext context = new DefaultDependencyCollectionContext(session2, request.getRootArtifact(), root2, managedDependencies);
            DefaultVersionFilterContext versionContext = new DefaultVersionFilterContext(session2);
            Results results = new Results(result, session2);
            this.doCollectDependencies(session2, trace2, pool, context, versionContext, request, node2, repositories, dependencies, managedDependencies, results);
            errorPath = results.getErrorPath();
        }
        long time2 = System.nanoTime();
        DependencyGraphTransformer transformer = session2.getDependencyGraphTransformer();
        if (transformer != null) {
            try {
                DefaultDependencyGraphTransformationContext context = new DefaultDependencyGraphTransformationContext(session2);
                context.put(TransformationContextKeys.STATS, stats);
                result.setRoot(transformer.transformGraph(node2, context));
            }
            catch (RepositoryException e4) {
                result.addException(e4);
            }
        }
        long time3 = System.nanoTime();
        if (this.logger.isDebugEnabled()) {
            stats.put(this.getClass().getSimpleName() + ".collectTime", time2 - time1);
            stats.put(this.getClass().getSimpleName() + ".transformTime", time3 - time2);
            this.logger.debug("Dependency collection stats {}", (Object)stats);
        }
        if (errorPath != null) {
            throw new DependencyCollectionException(result, "Failed to collect dependencies at " + errorPath);
        }
        if (!result.getExceptions().isEmpty()) {
            throw new DependencyCollectionException(result);
        }
        return result;
    }

    protected RequestTrace collectStepTrace(RequestTrace trace2, String context, List<DependencyNode> path2, Dependency node2) {
        return RequestTrace.newChild(trace2, new CollectStepDataImpl(context, path2, node2));
    }

    protected abstract void doCollectDependencies(RepositorySystemSession var1, RequestTrace var2, DataPool var3, DefaultDependencyCollectionContext var4, DefaultVersionFilterContext var5, CollectRequest var6, DependencyNode var7, List<RemoteRepository> var8, List<Dependency> var9, List<Dependency> var10, Results var11);

    protected RepositorySystemSession optimizeSession(RepositorySystemSession session2) {
        DefaultRepositorySystemSession optimized = new DefaultRepositorySystemSession(session2);
        optimized.setArtifactTypeRegistry(CachingArtifactTypeRegistry.newInstance(session2));
        return optimized;
    }

    protected List<Dependency> mergeDeps(List<Dependency> dominant, List<Dependency> recessive) {
        List<Dependency> result;
        if (dominant == null || dominant.isEmpty()) {
            result = recessive;
        } else if (recessive == null || recessive.isEmpty()) {
            result = dominant;
        } else {
            int initialCapacity = dominant.size() + recessive.size();
            result = new ArrayList<Dependency>(initialCapacity);
            HashSet<String> ids = new HashSet<String>(initialCapacity, 1.0f);
            for (Dependency dependency : dominant) {
                ids.add(DependencyCollectorDelegate.getId(dependency.getArtifact()));
                result.add(dependency);
            }
            for (Dependency dependency : recessive) {
                if (ids.contains(DependencyCollectorDelegate.getId(dependency.getArtifact()))) continue;
                result.add(dependency);
            }
        }
        return result;
    }

    protected static String getId(Artifact a) {
        return a.getGroupId() + ':' + a.getArtifactId() + ':' + a.getClassifier() + ':' + a.getExtension();
    }

    protected static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d, Collection<Artifact> aliases, List<RemoteRepository> repos, String requestContext) {
        DefaultDependencyNode child = new DefaultDependencyNode(d);
        preManaged.applyTo(child);
        child.setRelocations(relocations);
        child.setVersionConstraint(rangeResult.getVersionConstraint());
        child.setVersion(version);
        child.setAliases(aliases);
        child.setRepositories(repos);
        child.setRequestContext(requestContext);
        return child;
    }

    protected static DefaultDependencyNode createDependencyNode(List<Artifact> relocations, PremanagedDependency preManaged, VersionRangeResult rangeResult, Version version, Dependency d, ArtifactDescriptorResult descriptorResult, DependencyNode cycleNode) {
        DefaultDependencyNode child = DependencyCollectorDelegate.createDependencyNode(relocations, preManaged, rangeResult, version, d, descriptorResult.getAliases(), cycleNode.getRepositories(), cycleNode.getRequestContext());
        child.setChildren(cycleNode.getChildren());
        return child;
    }

    protected static ArtifactDescriptorRequest createArtifactDescriptorRequest(String requestContext, RequestTrace requestTrace, List<RemoteRepository> repositories, Dependency d) {
        ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
        descriptorRequest.setArtifact(d.getArtifact());
        descriptorRequest.setRepositories(repositories);
        descriptorRequest.setRequestContext(requestContext);
        descriptorRequest.setTrace(requestTrace);
        return descriptorRequest;
    }

    protected static VersionRangeRequest createVersionRangeRequest(String requestContext, RequestTrace requestTrace, List<RemoteRepository> repositories, Dependency dependency) {
        VersionRangeRequest rangeRequest = new VersionRangeRequest();
        rangeRequest.setArtifact(dependency.getArtifact());
        rangeRequest.setRepositories(repositories);
        rangeRequest.setRequestContext(requestContext);
        rangeRequest.setTrace(requestTrace);
        return rangeRequest;
    }

    protected VersionRangeResult cachedResolveRangeResult(VersionRangeRequest rangeRequest, DataPool pool, RepositorySystemSession session2) throws VersionRangeResolutionException {
        Object key2 = pool.toKey(rangeRequest);
        VersionRangeResult rangeResult = pool.getConstraint(key2, rangeRequest);
        if (rangeResult == null) {
            rangeResult = this.versionRangeResolver.resolveVersionRange(session2, rangeRequest);
            pool.putConstraint(key2, rangeResult);
        }
        return rangeResult;
    }

    protected static boolean isLackingDescriptor(Artifact artifact) {
        return artifact.getProperty("localPath", null) != null;
    }

    protected static List<RemoteRepository> getRemoteRepositories(ArtifactRepository repository, List<RemoteRepository> repositories) {
        if (repository instanceof RemoteRepository) {
            return Collections.singletonList((RemoteRepository)repository);
        }
        if (repository != null) {
            return Collections.emptyList();
        }
        return repositories;
    }

    protected static List<? extends Version> filterVersions(Dependency dependency, VersionRangeResult rangeResult, VersionFilter verFilter, DefaultVersionFilterContext verContext) throws VersionRangeResolutionException {
        List<Version> versions;
        if (rangeResult.getVersions().isEmpty()) {
            throw new VersionRangeResolutionException(rangeResult, "No versions available for " + dependency.getArtifact() + " within specified range");
        }
        if (verFilter != null && rangeResult.getVersionConstraint().getRange() != null) {
            verContext.set(dependency, rangeResult);
            try {
                verFilter.filterVersions(verContext);
            }
            catch (RepositoryException e2) {
                throw new VersionRangeResolutionException(rangeResult, "Failed to filter versions for " + dependency.getArtifact(), e2);
            }
            versions = verContext.get();
            if (versions.isEmpty()) {
                throw new VersionRangeResolutionException(rangeResult, "No acceptable versions for " + dependency.getArtifact() + ": " + rangeResult.getVersions());
            }
        } else {
            versions = rangeResult.getVersions();
        }
        return versions;
    }

    protected static class Results {
        private final CollectResult result;
        final int maxExceptions;
        final int maxCycles;
        String errorPath;

        public Results(CollectResult result, RepositorySystemSession session2) {
            this.result = result;
            this.maxExceptions = ConfigUtils.getInteger(session2, 50, DependencyCollectorDelegate.CONFIG_PROP_MAX_EXCEPTIONS);
            this.maxCycles = ConfigUtils.getInteger(session2, 10, DependencyCollectorDelegate.CONFIG_PROP_MAX_CYCLES);
        }

        public String getErrorPath() {
            return this.errorPath;
        }

        public void addException(Dependency dependency, Exception e2, List<DependencyNode> nodes2) {
            if (this.maxExceptions < 0 || this.result.getExceptions().size() < this.maxExceptions) {
                this.result.addException(e2);
                if (this.errorPath == null) {
                    StringBuilder buffer2 = new StringBuilder(256);
                    for (DependencyNode node2 : nodes2) {
                        Dependency dep;
                        if (buffer2.length() > 0) {
                            buffer2.append(" -> ");
                        }
                        if ((dep = node2.getDependency()) == null) continue;
                        buffer2.append(dep.getArtifact());
                    }
                    if (buffer2.length() > 0) {
                        buffer2.append(" -> ");
                    }
                    buffer2.append(dependency.getArtifact());
                    this.errorPath = buffer2.toString();
                }
            }
        }

        public void addCycle(List<DependencyNode> nodes2, int cycleEntry, Dependency dependency) {
            if (this.maxCycles < 0 || this.result.getCycles().size() < this.maxCycles) {
                this.result.addCycle(new DefaultDependencyCycle(nodes2, cycleEntry, dependency));
            }
        }
    }
}

