/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.eula;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public abstract class EULABaseDialog
extends BaseDialog {
    private final String eula;

    public EULABaseDialog(@NotNull Shell parentShell, @Nullable String eula) {
        super(parentShell, CoreMessages.core_eula_dialog_title, (DBPImage)DBIcon.TREE_INFO);
        this.eula = eula;
    }

    @Nullable
    public String getEula() {
        return this.eula;
    }

    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite eulaArea = new Composite(super.createDialogArea(parent), 2048);
        eulaArea.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        eulaArea.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Font)eulaArea.getFont()) * 40;
        gd.widthHint = UIUtils.getFontHeight((Font)eulaArea.getFont()) * 50;
        Text eulaText = new Text(eulaArea, 524874);
        eulaText.setLayoutData((Object)gd);
        eulaText.setText(this.eula == null ? "End-User Agreement not found" : this.eula);
        return eulaArea;
    }
}

