/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.sql.SQLConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class SQLEditorHandlerGoToMatchingBracket
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SQLEditorBase editor = (SQLEditorBase)((Object)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditorBase.class));
        if (editor != null) {
            this.gotoMatchingBracket(editor, "org.jkiss.dbeaver.ui.editors.sql.selectToMatchingBracket".equals(event.getCommand().getId()));
        }
        return null;
    }

    private void gotoMatchingBracket(SQLEditorBase editor, boolean selectText) {
        SourceViewer sourceViewer = editor.getViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = SQLEditorHandlerGoToMatchingBracket.getSignedSelection((ISourceViewer)sourceViewer);
        ICharacterPairMatcher characterPairMatcher = editor.getCharacterPairMatcher();
        IRegion region = characterPairMatcher.match(document, selection.getOffset());
        if (region == null) {
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = characterPairMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length - 1;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            return;
        }
        int adjustment = SQLEditorHandlerGoToMatchingBracket.getOffsetAdjustment(document, selection.getOffset() + selection.getLength(), selection.getLength());
        targetOffset += adjustment;
        int direction = Integer.compare(selection.getLength(), 0);
        if (selectText) {
            sourceViewer.setSelectedRange(offset + 1, length - 2);
        } else {
            sourceViewer.setSelectedRange(targetOffset, direction);
            sourceViewer.revealRange(targetOffset, direction);
        }
    }

    private static IRegion getSignedSelection(ISourceViewer sourceViewer) {
        Point viewerSelection = sourceViewer.getSelectedRange();
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            viewerSelection.x += viewerSelection.y;
            viewerSelection.y = -viewerSelection.y;
        }
        return new Region(viewerSelection.x, viewerSelection.y);
    }

    private static int getOffsetAdjustment(IDocument document, int offset, int length) {
        block7: {
            block6: {
                if (length == 0 || Math.abs(length) > 1) {
                    return 0;
                }
                try {
                    if (length >= 0) break block6;
                    if (SQLEditorHandlerGoToMatchingBracket.isOpeningBracket(document.getChar(offset))) {
                        return 1;
                    }
                    break block7;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (SQLEditorHandlerGoToMatchingBracket.isClosingBracket(document.getChar(offset - 1))) {
                return -1;
            }
        }
        return 0;
    }

    private static boolean isOpeningBracket(char character) {
        int i = 0;
        while (i < SQLConstants.BRACKETS.length) {
            if (character == SQLConstants.BRACKETS[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private static boolean isClosingBracket(char character) {
        int i = 1;
        while (i < SQLConstants.BRACKETS.length) {
            if (character == SQLConstants.BRACKETS[i]) {
                return true;
            }
            i += 2;
        }
        return false;
    }
}

