/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import java.util.concurrent.locks.Lock;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.LoggerFactory;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Converter;
import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.compression.Compression;
import net.schmizz.sshj.transport.mac.MAC;
import net.schmizz.sshj.transport.random.Random;
import org.slf4j.Logger;

final class Encoder
extends Converter {
    private final Logger log;
    private final Random prng;
    private final Lock encodeLock;

    Encoder(Random prng, Lock encodeLock, LoggerFactory loggerFactory) {
        this.prng = prng;
        this.encodeLock = encodeLock;
        this.log = loggerFactory.getLogger(this.getClass());
    }

    private void compress(SSHPacket buffer) {
        this.compression.compress(buffer);
    }

    private void putMAC(SSHPacket buffer, int startOfPacket, int endOfPadding) {
        buffer.wpos(endOfPadding + this.mac.getBlockSize());
        this.mac.update(this.seq);
        this.mac.update(buffer.array(), startOfPacket, endOfPadding);
        this.mac.doFinal(buffer.array(), endOfPadding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long encode(SSHPacket buffer) {
        this.encodeLock.lock();
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Encoding packet #{}: {}", (Object)(this.seq + 1L), (Object)buffer.printHex());
            }
            if (this.usingCompression()) {
                this.compress(buffer);
            }
            int payloadSize = buffer.available();
            int lengthWithoutPadding = this.etm ? 1 + payloadSize : 5 + payloadSize;
            int padLen = this.cipherSize - lengthWithoutPadding % this.cipherSize;
            if (padLen < 4 || this.authMode && padLen < this.cipherSize) {
                padLen += this.cipherSize;
            }
            int startOfPacket = buffer.rpos() - 5;
            int packetLen = 1 + payloadSize + padLen;
            if (packetLen < 16) {
                packetLen = 1 + payloadSize + (padLen += this.cipherSize);
            }
            if (this.authMode && packetLen % this.cipherSize != 0) {
                padLen += this.cipherSize - packetLen % this.cipherSize;
                packetLen = 1 + payloadSize + padLen;
            }
            int endOfPadding = startOfPacket + 4 + packetLen;
            buffer.wpos(startOfPacket);
            buffer.putUInt32(packetLen);
            buffer.putByte((byte)padLen);
            buffer.wpos(endOfPadding);
            this.prng.fill(buffer.array(), endOfPadding - padLen, padLen);
            this.seq = this.seq + 1L & 0xFFFFFFFFL;
            if (this.authMode) {
                int wpos = buffer.wpos();
                buffer.wpos(wpos + this.cipherSize);
                this.aeadOutgoingBuffer(buffer, startOfPacket, packetLen);
            } else if (this.etm) {
                this.cipher.update(buffer.array(), startOfPacket + 4, packetLen);
                this.putMAC(buffer, startOfPacket, endOfPadding);
            } else {
                if (this.mac != null) {
                    this.putMAC(buffer, startOfPacket, endOfPadding);
                }
                this.cipher.update(buffer.array(), startOfPacket, 4 + packetLen);
            }
            buffer.rpos(startOfPacket);
            long l = this.seq;
            return l;
        }
        finally {
            this.encodeLock.unlock();
        }
    }

    protected void aeadOutgoingBuffer(Buffer<?> buf, int offset, int len) {
        if (this.cipher == null || this.cipher.getAuthenticationTagSize() == 0) {
            throw new IllegalArgumentException("AEAD mode requires an AEAD cipher");
        }
        byte[] data = buf.array();
        this.cipher.setSequenceNumber(this.seq);
        this.cipher.updateWithAAD(data, offset, 4, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setAlgorithms(Cipher cipher, MAC mac, Compression compression) {
        this.encodeLock.lock();
        try {
            super.setAlgorithms(cipher, mac, compression);
        }
        finally {
            this.encodeLock.unlock();
        }
    }

    @Override
    void setAuthenticated() {
        this.encodeLock.lock();
        try {
            super.setAuthenticated();
        }
        finally {
            this.encodeLock.unlock();
        }
    }

    @Override
    Compression.Mode getCompressionType() {
        return Compression.Mode.DEFLATE;
    }
}

