/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.DOMTypeInfo;
import io.sf.carte.doc.dom.NamespacedNode;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.TypeInfo;

abstract class DOMAttr
extends NamespacedNode
implements Attr {
    private static final long serialVersionUID = 1L;
    private TypeInfo schemaTypeInfo = null;
    private final String localName;
    boolean specified = true;
    String value = "";

    DOMAttr(String string, String string2) {
        super((short)2, string2);
        this.localName = string;
    }

    @Override
    void checkAppendNodeHierarchy(Node node) {
        throw new DOMException(3, "Cannot append to attribute node");
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getName() {
        String string = this.getLocalName();
        String string2 = this.getPrefix();
        if (string2 != null) {
            string = string2 + ':' + string;
        }
        return string;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setNodeValue(String string) throws DOMException {
        this.setValue(string);
    }

    @Override
    public DOMElement getOwnerElement() {
        return (DOMElement)super.getParentNode();
    }

    @Override
    public DOMNode getParentNode() throws DOMException {
        return null;
    }

    @Override
    void setParentNode(AbstractDOMNode abstractDOMNode) throws DOMException {
        throw new DOMException(3, "Attributes do no have a parent node");
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        if (this.schemaTypeInfo == null) {
            this.schemaTypeInfo = new AttributeTypeInfo();
        }
        return this.schemaTypeInfo;
    }

    @Override
    public boolean getSpecified() {
        return this.specified;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String string) {
        if (string == null) {
            string = "";
        }
        this.value = string;
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.getValue();
    }

    @Override
    public void setTextContent(String string) throws DOMException {
        this.setValue(string);
    }

    @Override
    public String lookupNamespaceURI(String string) {
        DOMElement dOMElement;
        String string2 = super.lookupNamespaceURI(string);
        if (string2 == null && (dOMElement = this.getOwnerElement()) != null) {
            string2 = dOMElement.lookupNamespaceURI(string);
        }
        return string2;
    }

    @Override
    public String lookupPrefix(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals(this.getNamespaceURI())) {
            return this.getPrefix();
        }
        DOMElement dOMElement = this.getOwnerElement();
        if (dOMElement != null) {
            return dOMElement.lookupPrefix(string);
        }
        return null;
    }

    @Override
    public void setPrefix(String string) throws DOMException {
        if ("xmlns".equals(this.getLocalName()) || "xmlns".equals(string) && !"http://www.w3.org/2000/xmlns/".equals(this.getNamespaceURI())) {
            throw new DOMException(14, "Cannot set prefix to this node");
        }
        String string2 = this.getPrefix();
        super.setPrefix(string);
        DOMElement dOMElement = this.getOwnerElement();
        if (dOMElement != null) {
            dOMElement.nodeMap.updatePrefix(this, string, string2);
        }
    }

    @Override
    public abstract Attr cloneNode(boolean var1);

    public String toString() {
        StringBuilder stringBuilder;
        String string = this.getLocalName();
        String string2 = this.getPrefix();
        String string3 = this.getValue();
        int n = string3.length();
        if (string2 != null) {
            stringBuilder = new StringBuilder(string.length() + string2.length() + n + 4);
            stringBuilder.append(string2);
            stringBuilder.append(':');
        } else {
            stringBuilder = new StringBuilder(string.length() + n + 3);
        }
        stringBuilder.append(string);
        if (n != 0 || !this.isBooleanAttribute()) {
            stringBuilder.append("=\"");
            stringBuilder.append(DOMAttr.escapeAttributeEntities(string3));
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    boolean isBooleanAttribute() {
        String string;
        return this.getOwnerDocument().isHTML() && ((string = this.getNamespaceURI()) == null || string == "http://www.w3.org/1999/xhtml");
    }

    void write(SimpleWriter simpleWriter) throws IOException {
        String string = this.getLocalName();
        String string2 = this.getPrefix();
        if (string2 != null) {
            simpleWriter.write((CharSequence)string2);
            simpleWriter.write(':');
        }
        simpleWriter.write((CharSequence)string);
        String string3 = this.getValue();
        if (string3.length() != 0) {
            simpleWriter.write((CharSequence)"=\"");
            simpleWriter.write((CharSequence)DOMAttr.escapeAttributeEntities(string3));
            simpleWriter.write('\"');
        }
    }

    static String escapeAttributeEntities(String string) {
        StringBuilder stringBuilder = null;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "lt", string, i, n);
                continue;
            }
            if (c == '>') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "gt", string, i, n);
                continue;
            }
            if (c == '&') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "amp", string, i, n);
                continue;
            }
            if (c == '\"') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "quot", string, i, n);
                continue;
            }
            if (c == '\u00a0') {
                stringBuilder = DOMDocument.appendEntityToBuffer(stringBuilder, "nbsp", string, i, n);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        if (stringBuilder != null) {
            string = stringBuilder.toString();
        }
        return string;
    }

    private class AttributeTypeInfo
    extends DOMTypeInfo {
        private AttributeTypeInfo() {
        }

        @Override
        public String getTypeName() {
            if (DOMAttr.this.isId()) {
                return "ID";
            }
            return null;
        }

        @Override
        public String getTypeNamespace() {
            return "https://www.w3.org/TR/xml/";
        }
    }
}

