#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-975FJAxulAW7iCTFVoJqjv
key:                  gitit-0.15.1.2-975FJAxulAW7iCTFVoJqjv
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  ec8cb9f5a64bb761c0b304e516d0edaa
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-975FJAxulAW7iCTFVoJqjv
depends:
    HStringTemplate-0.8.8-Ihzoa4htcCO6EfRszJQUtl
    HTTP-4000.4.1-ICjTIL3GkJGBSmcdse9PNR
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti base-4.17.2.1
    base64-bytestring-1.2.1.0-F6smDE5HGDf8fxaFSXDtqF
    blaze-html-0.9.2.0-BIKMCCBg4WREbcLt4aWKrB bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-2JzlhZlXs0K9ar3HZA9WkH
    feed-1.3.2.1-FfejKYRkFGIHDs0pEv4iWa filepath-1.4.2.2
    filestore-0.6.5.1-64Y7BBJMgx46igO8NC5pQe ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-Ivq3KbfG3TRJ0BsTvjstGa
    hoauth2-2.13.1-8KC9gvxlCtSFiryglDptTF
    hslogger-1.3.2.0-7zYqs02wJH3DQ7LuOKBrfO
    http-client-tls-0.3.6.4-8td26AWajcgBrlQRooycma
    http-conduit-2.3.9.1-9oPlHGYlrOYaw1Zlna69I
    json-0.10-57oJ4WkmsuXLoHf9S5Apon mtl-2.2.2
    network-3.1.4.0-Fdysxcu9OH32QGRZPBFSYA
    network-bsd-2.8.1.0-C8vJ62aadtcBQ7RU2ArwHo
    network-uri-2.6.4.2-H8OxlLs11Qp5PfJGWOmWWd
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-F0L5wGuz18C3eYB3cEwqVI
    pandoc-types-1.23.1-FzOEjPim1Mi4srvGNxwxwz parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-KqHaq6YE0664JHSWbd4LQ1
    recaptcha-0.1.0.4-HVymthXiViq9GdmCuIMlwE
    safe-0.3.21-F7VtiJ5GidLJaCroTndPfj
    skylighting-0.14.3-4Vc1K63cxEmDYph8TRCcDX
    split-0.2.5-7pUrG9PApSj8XvuAHaIoHq syb-0.7.3-Lsoysh53X7v5q5bHFTGcmg
    tagsoup-0.14.8-7XosC3kpgipIogylT1hzm
    temporary-1.3-Ax8CaoeD4FL9Q4Xeulod9t text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-68BBr3BvO3xEtxJ29PG4lb
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-KrqEYwQHk9BJTxj3mNS695 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-ATlJNrQIee7JTs8PjzVQNY
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-IoQ6MeA8xlf5ip9mm4Y7wh
    zlib-0.7.0.0-9LTVaTQCVSRLjipNGe0Z99

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

