# frozen_string_literal: true

module Labkit
  ##
  # Fields is intended to be a SSOT for all of the common field names that
  # we emit via any observability we add to our systems.
  #
  # These fields should span multiple services. This is
  #
  # The goal of this package is to reduce the likelihood for typos or
  # subtly different naming conventions. This will help to ensure we
  # are able to marry up logs between different systems as a request
  # is being processed.
  #
  # Usage:
  #   require 'labkit/fields'
  #   ...
  #   data[Labkit::Fields::GL_USER_ID] = user.id
  #   ...
  #
  module Fields
    # correlation_id - string
    #
    # This field is used to correlate
    # the logs emitted by all of our systems.
    #
    # This should be present in all log line
    # emissions.
    CORRELATION_ID = "correlation_id"

    # We'll need to add the rest of the top
    # level fields here:
    # [endpoint_id, duration_s, status_code]

    # gl_user_id - integer
    GL_USER_ID = "gl_user_id"

    # gl_user_name - string
    GL_USER_NAME = "gl_user_name"
  end
end
