/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers;

import io.undertow.UndertowLogger;
import io.undertow.server.BasicSSLSessionInfo;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.builder.HandlerBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.cert.CertificateException;

public class SSLHeaderHandler
implements HttpHandler {
    public static final String HTTPS = "https";
    private final HttpHandler next;

    public SSLHeaderHandler(HttpHandler next) {
        this.next = next;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        String sessionId = exchange.getRequestHeader("SSL_SESSION_ID");
        String cipher = exchange.getRequestHeader("SSL_CIPHER");
        String clientCert = exchange.getRequestHeader("SSL_CLIENT_CERT");
        if (clientCert != null && clientCert.length() > 28) {
            StringBuilder sb = new StringBuilder(clientCert.length() + 1);
            sb.append("-----BEGIN CERTIFICATE-----");
            sb.append('\n');
            sb.append(clientCert.replace(' ', '\n').substring(28, clientCert.length() - 26));
            sb.append('\n');
            sb.append("-----END CERTIFICATE-----");
            clientCert = sb.toString();
        }
        if (clientCert != null || sessionId != null || cipher != null) {
            try {
                BasicSSLSessionInfo info = new BasicSSLSessionInfo(sessionId, cipher, clientCert);
                exchange.setRequestScheme(HTTPS);
                exchange.setSslSessionInfo(info);
            }
            catch (java.security.cert.CertificateException | CertificateException e) {
                UndertowLogger.REQUEST_LOGGER.debugf(e, "Could not create certificate from header %s", clientCert);
            }
        }
        this.next.handleRequest(exchange);
    }

    private static class Wrapper
    implements HandlerWrapper {
        private Wrapper() {
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            return new SSLHeaderHandler(handler);
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "ssl-headers";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            return Collections.emptyMap();
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.emptySet();
        }

        @Override
        public String defaultParameter() {
            return null;
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper();
        }
    }
}

