/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.impl.verifier;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.AnnotationElement;
import io.github.dmlloyd.classfile.AnnotationValue;
import io.github.dmlloyd.classfile.Attribute;
import io.github.dmlloyd.classfile.AttributedElement;
import io.github.dmlloyd.classfile.Attributes;
import io.github.dmlloyd.classfile.ClassFileElement;
import io.github.dmlloyd.classfile.ClassModel;
import io.github.dmlloyd.classfile.CodeModel;
import io.github.dmlloyd.classfile.CompoundElement;
import io.github.dmlloyd.classfile.CustomAttribute;
import io.github.dmlloyd.classfile.FieldModel;
import io.github.dmlloyd.classfile.MethodModel;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.github.dmlloyd.classfile.TypeKind;
import io.github.dmlloyd.classfile.attribute.AnnotationDefaultAttribute;
import io.github.dmlloyd.classfile.attribute.BootstrapMethodsAttribute;
import io.github.dmlloyd.classfile.attribute.CharacterRangeTableAttribute;
import io.github.dmlloyd.classfile.attribute.CodeAttribute;
import io.github.dmlloyd.classfile.attribute.CompilationIDAttribute;
import io.github.dmlloyd.classfile.attribute.ConstantValueAttribute;
import io.github.dmlloyd.classfile.attribute.DeprecatedAttribute;
import io.github.dmlloyd.classfile.attribute.EnclosingMethodAttribute;
import io.github.dmlloyd.classfile.attribute.ExceptionsAttribute;
import io.github.dmlloyd.classfile.attribute.InnerClassInfo;
import io.github.dmlloyd.classfile.attribute.InnerClassesAttribute;
import io.github.dmlloyd.classfile.attribute.LineNumberTableAttribute;
import io.github.dmlloyd.classfile.attribute.LocalVariableTableAttribute;
import io.github.dmlloyd.classfile.attribute.LocalVariableTypeTableAttribute;
import io.github.dmlloyd.classfile.attribute.MethodParametersAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleExportInfo;
import io.github.dmlloyd.classfile.attribute.ModuleHashInfo;
import io.github.dmlloyd.classfile.attribute.ModuleHashesAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleMainClassAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleOpenInfo;
import io.github.dmlloyd.classfile.attribute.ModulePackagesAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleProvideInfo;
import io.github.dmlloyd.classfile.attribute.ModuleResolutionAttribute;
import io.github.dmlloyd.classfile.attribute.ModuleTargetAttribute;
import io.github.dmlloyd.classfile.attribute.NestHostAttribute;
import io.github.dmlloyd.classfile.attribute.NestMembersAttribute;
import io.github.dmlloyd.classfile.attribute.PermittedSubclassesAttribute;
import io.github.dmlloyd.classfile.attribute.RecordAttribute;
import io.github.dmlloyd.classfile.attribute.RecordComponentInfo;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.SignatureAttribute;
import io.github.dmlloyd.classfile.attribute.SourceDebugExtensionAttribute;
import io.github.dmlloyd.classfile.attribute.SourceFileAttribute;
import io.github.dmlloyd.classfile.attribute.SourceIDAttribute;
import io.github.dmlloyd.classfile.attribute.StackMapFrameInfo;
import io.github.dmlloyd.classfile.attribute.StackMapTableAttribute;
import io.github.dmlloyd.classfile.attribute.SyntheticAttribute;
import io.github.dmlloyd.classfile.attribute.UnknownAttribute;
import io.github.dmlloyd.classfile.constantpool.ClassEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantDynamicEntry;
import io.github.dmlloyd.classfile.constantpool.ConstantValueEntry;
import io.github.dmlloyd.classfile.constantpool.DoubleEntry;
import io.github.dmlloyd.classfile.constantpool.FieldRefEntry;
import io.github.dmlloyd.classfile.constantpool.FloatEntry;
import io.github.dmlloyd.classfile.constantpool.IntegerEntry;
import io.github.dmlloyd.classfile.constantpool.InterfaceMethodRefEntry;
import io.github.dmlloyd.classfile.constantpool.InvokeDynamicEntry;
import io.github.dmlloyd.classfile.constantpool.LongEntry;
import io.github.dmlloyd.classfile.constantpool.MethodHandleEntry;
import io.github.dmlloyd.classfile.constantpool.MethodRefEntry;
import io.github.dmlloyd.classfile.constantpool.MethodTypeEntry;
import io.github.dmlloyd.classfile.constantpool.ModuleEntry;
import io.github.dmlloyd.classfile.constantpool.NameAndTypeEntry;
import io.github.dmlloyd.classfile.constantpool.PackageEntry;
import io.github.dmlloyd.classfile.constantpool.PoolEntry;
import io.github.dmlloyd.classfile.constantpool.StringEntry;
import io.github.dmlloyd.classfile.constantpool.Utf8Entry;
import io.github.dmlloyd.classfile.extras.reflect.AccessFlag;
import io.github.dmlloyd.classfile.impl.BoundAttribute;
import io.github.dmlloyd.classfile.impl.Util;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;

public record ParserVerifier(ClassModel classModel) {
    List<VerifyError> verify() {
        ArrayList<VerifyError> errors = new ArrayList<VerifyError>();
        this.verifyConstantPool(errors);
        this.verifyInterfaces(errors);
        this.verifyFields(errors);
        this.verifyMethods(errors);
        this.verifyAttributes(this.classModel, errors);
        return errors;
    }

    private void verifyConstantPool(List<VerifyError> errors) {
        for (PoolEntry cpe : this.classModel.constantPool()) {
            try {
                switch (cpe.tag()) {
                    case 6: {
                        ((DoubleEntry)cpe).doubleValue();
                        break;
                    }
                    case 4: {
                        ((FloatEntry)cpe).floatValue();
                        break;
                    }
                    case 3: {
                        ((IntegerEntry)cpe).intValue();
                        break;
                    }
                    case 5: {
                        ((LongEntry)cpe).longValue();
                        break;
                    }
                    case 1: {
                        ((Utf8Entry)cpe).stringValue();
                        break;
                    }
                    case 17: {
                        ((ConstantDynamicEntry)cpe).asSymbol();
                        break;
                    }
                    case 18: {
                        ((InvokeDynamicEntry)cpe).asSymbol();
                        break;
                    }
                    case 7: {
                        ((ClassEntry)cpe).asSymbol();
                        break;
                    }
                    case 8: {
                        ((StringEntry)cpe).stringValue();
                        break;
                    }
                    case 15: {
                        ((MethodHandleEntry)cpe).asSymbol();
                        break;
                    }
                    case 16: {
                        ((MethodTypeEntry)cpe).asSymbol();
                        break;
                    }
                    case 9: {
                        FieldRefEntry fre = (FieldRefEntry)cpe;
                        try {
                            fre.owner().asSymbol();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        try {
                            fre.typeSymbol();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        this.verifyFieldName(fre.name().stringValue());
                        break;
                    }
                    case 11: {
                        InterfaceMethodRefEntry imre = (InterfaceMethodRefEntry)cpe;
                        try {
                            imre.owner().asSymbol();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        try {
                            imre.typeSymbol();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        this.verifyMethodName(imre.name().stringValue());
                        break;
                    }
                    case 10: {
                        MethodRefEntry mre = (MethodRefEntry)cpe;
                        try {
                            mre.owner().asSymbol();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        try {
                            mre.typeSymbol();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        this.verifyMethodName(mre.name().stringValue());
                        break;
                    }
                    case 19: {
                        ((ModuleEntry)cpe).asSymbol();
                        break;
                    }
                    case 12: {
                        NameAndTypeEntry nate = (NameAndTypeEntry)cpe;
                        try {
                            nate.name().stringValue();
                        }
                        catch (Exception | VerifyError e) {
                            errors.add(this.cpeVerifyError(cpe, e));
                        }
                        nate.type().stringValue();
                        break;
                    }
                    case 20: {
                        ((PackageEntry)cpe).asSymbol();
                    }
                }
            }
            catch (Exception | VerifyError e) {
                errors.add(this.cpeVerifyError(cpe, e));
            }
        }
    }

    private VerifyError cpeVerifyError(PoolEntry cpe, Throwable e) {
        return new VerifyError("%s at constant pool index %d in %s".formatted(e.getMessage(), cpe.index(), this.toString(this.classModel)));
    }

    private void verifyFieldName(String name) {
        if (name.length() == 0 || name.chars().anyMatch(ch -> switch (ch) {
            case 46, 47, 59, 91 -> true;
            default -> false;
        })) {
            throw new VerifyError("Illegal field name %s in %s".formatted(name, this.toString(this.classModel)));
        }
    }

    private void verifyMethodName(String name) {
        if (!(name.equals("<init>") || name.equals("<clinit>") || name.length() != 0 && !name.chars().anyMatch(ch -> switch (ch) {
            case 46, 47, 59, 60, 62, 91 -> true;
            default -> false;
        }))) {
            throw new VerifyError("Illegal method name %s in %s".formatted(name, this.toString(this.classModel)));
        }
    }

    private void verifyInterfaces(List<VerifyError> errors) {
        HashSet<ClassEntry> intfs = new HashSet<ClassEntry>();
        for (ClassEntry intf : this.classModel.interfaces()) {
            if (intfs.add(intf)) continue;
            errors.add(new VerifyError("Duplicate interface %s in %s".formatted(intf.asSymbol().displayName(), this.toString(this.classModel))));
        }
    }

    private void verifyFields(List<VerifyError> errors) {
        record F(Utf8Entry name, Utf8Entry type) {
        }
        HashSet<F> fields = new HashSet<F>();
        for (FieldModel f : this.classModel.fields()) {
            try {
                if (!fields.add(new F(f.fieldName(), f.fieldType()))) {
                    errors.add(new VerifyError("Duplicate field name %s with signature %s in %s".formatted(f.fieldName().stringValue(), f.fieldType().stringValue(), this.toString(this.classModel))));
                }
                this.verifyFieldName(f.fieldName().stringValue());
            }
            catch (VerifyError ve) {
                errors.add(ve);
            }
        }
    }

    private void verifyMethods(List<VerifyError> errors) {
        record M(Utf8Entry name, Utf8Entry type) {
        }
        HashSet<M> methods = new HashSet<M>();
        for (MethodModel m : this.classModel.methods()) {
            try {
                if (!methods.add(new M(m.methodName(), m.methodType()))) {
                    errors.add(new VerifyError("Duplicate method name %s with signature %s in %s".formatted(m.methodName().stringValue(), m.methodType().stringValue(), this.toString(this.classModel))));
                }
                if (m.methodName().equalsString("<clinit>") && !m.flags().has(AccessFlag.STATIC)) {
                    errors.add(new VerifyError("Method <clinit> is not static in %s".formatted(this.toString(this.classModel))));
                }
                if (this.classModel.flags().has(AccessFlag.INTERFACE) && m.methodName().equalsString("<init>")) {
                    errors.add(new VerifyError("Interface cannot have a method named <init> in %s".formatted(this.toString(this.classModel))));
                }
                this.verifyMethodName(m.methodName().stringValue());
            }
            catch (VerifyError ve) {
                errors.add(ve);
            }
        }
    }

    private void verifyAttributes(ClassFileElement cfe, List<VerifyError> errors) {
        block6: {
            block5: {
                if (cfe instanceof AttributedElement) {
                    AttributedElement ae = (AttributedElement)cfe;
                    HashSet<String> attrNames = new HashSet<String>();
                    for (Attribute attribute : ae.attributes()) {
                        if (!attribute.attributeMapper().allowMultiple() && !attrNames.add(attribute.attributeName().stringValue())) {
                            errors.add(new VerifyError("Multiple %s attributes in %s".formatted(attribute.attributeName().stringValue(), this.toString(ae))));
                        }
                        this.verifyAttribute(ae, attribute, errors);
                    }
                }
                if (!(cfe instanceof CompoundElement)) break block5;
                CompoundElement comp = (CompoundElement)cfe;
                for (ClassFileElement classFileElement : comp) {
                    this.verifyAttributes(classFileElement, errors);
                }
                break block6;
            }
            if (!(cfe instanceof RecordAttribute)) break block6;
            RecordAttribute ra = (RecordAttribute)cfe;
            for (RecordComponentInfo recordComponentInfo : ra.components()) {
                this.verifyAttributes(recordComponentInfo, errors);
            }
        }
    }

    /*
     * Handled duff style switch with additional control
     * Enabled aggressive block sorting
     */
    private void verifyAttribute(AttributedElement ae, Attribute<?> a, List<VerifyError> errors) {
        int size;
        if (a instanceof AnnotationDefaultAttribute) {
            AnnotationDefaultAttribute aa = (AnnotationDefaultAttribute)a;
            size = ParserVerifier.valueSize(aa.defaultValue());
        } else if (a instanceof BootstrapMethodsAttribute) {
            BootstrapMethodsAttribute bma = (BootstrapMethodsAttribute)a;
            size = 2 + bma.bootstrapMethods().stream().mapToInt(bm -> 4 + 2 * bm.arguments().size()).sum();
        } else if (a instanceof CharacterRangeTableAttribute) {
            CharacterRangeTableAttribute cra = (CharacterRangeTableAttribute)a;
            size = 2 + 14 * cra.characterRangeTable().size();
        } else if (a instanceof CodeAttribute) {
            CodeAttribute ca = (CodeAttribute)a;
            MethodModel mm = (MethodModel)ae;
            if (mm.flags().has(AccessFlag.NATIVE) || mm.flags().has(AccessFlag.ABSTRACT)) {
                errors.add(new VerifyError("Code attribute in native or abstract %s".formatted(this.toString(ae))));
            }
            if (ca.maxLocals() < Util.maxLocals(mm.flags().flagsMask(), mm.methodTypeSymbol())) {
                errors.add(new VerifyError("Arguments can't fit into locals in %s".formatted(this.toString(ae))));
            }
            size = 10 + ca.codeLength() + 8 * ca.exceptionHandlers().size() + ParserVerifier.attributesSize(ca.attributes());
        } else if (a instanceof CompilationIDAttribute) {
            CompilationIDAttribute cida = (CompilationIDAttribute)a;
            cida.compilationId();
            size = 2;
        } else if (a instanceof ConstantValueAttribute) {
            ConstantValueAttribute cva = (ConstantValueAttribute)a;
            ClassDesc type = ((FieldModel)ae).fieldTypeSymbol();
            ConstantValueEntry cve = cva.constant();
            int n = 0;
            block8: do {
                switch (n == 0 ? 1.$SwitchMap$io$github$dmlloyd$classfile$TypeKind[TypeKind.from(type).ordinal()] : n) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        n = 10;
                        if (!(cve instanceof IntegerEntry)) continue block8;
                        break;
                    }
                    case 6: {
                        n = 10;
                        if (!(cve instanceof DoubleEntry)) continue block8;
                        break;
                    }
                    case 7: {
                        n = 10;
                        if (!(cve instanceof FloatEntry)) continue block8;
                        break;
                    }
                    case 8: {
                        n = 10;
                        if (!(cve instanceof LongEntry)) continue block8;
                        break;
                    }
                    case 9: {
                        if (type.equals(ConstantDescs.CD_String) && cve instanceof StringEntry) break;
                    }
                    case 10: {
                        errors.add(new VerifyError("Bad constant value type in %s".formatted(this.toString(ae))));
                    }
                }
                break;
            } while (true);
            size = 2;
        } else if (a instanceof DeprecatedAttribute) {
            size = 0;
        } else if (a instanceof EnclosingMethodAttribute) {
            EnclosingMethodAttribute ema = (EnclosingMethodAttribute)a;
            ema.enclosingClass();
            ema.enclosingMethod();
            size = 4;
        } else if (a instanceof ExceptionsAttribute) {
            ExceptionsAttribute ea = (ExceptionsAttribute)a;
            size = 2 + 2 * ea.exceptions().size();
        } else if (a instanceof InnerClassesAttribute) {
            InnerClassesAttribute ica = (InnerClassesAttribute)a;
            for (InnerClassInfo ici : ica.classes()) {
                if (!ici.outerClass().isPresent() || !ici.outerClass().get().equals(ici.innerClass())) continue;
                errors.add(new VerifyError("Class is both outer and inner class in %s".formatted(this.toString(ae))));
            }
            size = 2 + 8 * ica.classes().size();
        } else if (a instanceof LineNumberTableAttribute) {
            LineNumberTableAttribute lta = (LineNumberTableAttribute)a;
            size = 2 + 4 * lta.lineNumbers().size();
        } else if (a instanceof LocalVariableTableAttribute) {
            LocalVariableTableAttribute lvta = (LocalVariableTableAttribute)a;
            size = 2 + 10 * lvta.localVariables().size();
        } else if (a instanceof LocalVariableTypeTableAttribute) {
            LocalVariableTypeTableAttribute lvta = (LocalVariableTypeTableAttribute)a;
            size = 2 + 10 * lvta.localVariableTypes().size();
        } else if (a instanceof MethodParametersAttribute) {
            MethodParametersAttribute mpa = (MethodParametersAttribute)a;
            size = 1 + 4 * mpa.parameters().size();
        } else if (a instanceof ModuleAttribute) {
            ModuleAttribute ma = (ModuleAttribute)a;
            size = 16 + ParserVerifier.subSize(ma.exports(), ModuleExportInfo::exportsTo, 6, 2) + ParserVerifier.subSize(ma.opens(), ModuleOpenInfo::opensTo, 6, 2) + ParserVerifier.subSize(ma.provides(), ModuleProvideInfo::providesWith, 4, 2) + 6 * ma.requires().size() + 2 * ma.uses().size();
        } else if (a instanceof ModuleHashesAttribute) {
            ModuleHashesAttribute mha = (ModuleHashesAttribute)a;
            size = 2 + ParserVerifier.moduleHashesSize(mha.hashes());
        } else if (a instanceof ModuleMainClassAttribute) {
            ModuleMainClassAttribute mmca = (ModuleMainClassAttribute)a;
            mmca.mainClass();
            size = 2;
        } else if (a instanceof ModulePackagesAttribute) {
            ModulePackagesAttribute mpa = (ModulePackagesAttribute)a;
            size = 2 + 2 * mpa.packages().size();
        } else if (a instanceof ModuleResolutionAttribute) {
            size = 2;
        } else if (a instanceof ModuleTargetAttribute) {
            ModuleTargetAttribute mta = (ModuleTargetAttribute)a;
            mta.targetPlatform();
            size = 2;
        } else if (a instanceof NestHostAttribute) {
            NestHostAttribute nha = (NestHostAttribute)a;
            nha.nestHost();
            size = 2;
        } else if (a instanceof NestMembersAttribute) {
            NestMembersAttribute nma = (NestMembersAttribute)a;
            if (ae.findAttribute(Attributes.nestHost()).isPresent()) {
                errors.add(new VerifyError("Conflicting NestHost and NestMembers attributes in %s".formatted(this.toString(ae))));
            }
            size = 2 + 2 * nma.nestMembers().size();
        } else if (a instanceof PermittedSubclassesAttribute) {
            PermittedSubclassesAttribute psa = (PermittedSubclassesAttribute)a;
            if (this.classModel.flags().has(AccessFlag.FINAL)) {
                errors.add(new VerifyError("PermittedSubclasses attribute in final %s".formatted(this.toString(ae))));
            }
            size = 2 + 2 * psa.permittedSubclasses().size();
        } else if (a instanceof RecordAttribute) {
            RecordAttribute ra = (RecordAttribute)a;
            size = ParserVerifier.componentsSize(ra.components());
        } else if (a instanceof RuntimeVisibleAnnotationsAttribute) {
            RuntimeVisibleAnnotationsAttribute aa = (RuntimeVisibleAnnotationsAttribute)a;
            size = ParserVerifier.annotationsSize(aa.annotations());
        } else if (a instanceof RuntimeInvisibleAnnotationsAttribute) {
            RuntimeInvisibleAnnotationsAttribute aa = (RuntimeInvisibleAnnotationsAttribute)a;
            size = ParserVerifier.annotationsSize(aa.annotations());
        } else if (a instanceof RuntimeVisibleTypeAnnotationsAttribute) {
            RuntimeVisibleTypeAnnotationsAttribute aa = (RuntimeVisibleTypeAnnotationsAttribute)a;
            size = ParserVerifier.typeAnnotationsSize(aa.annotations());
        } else if (a instanceof RuntimeInvisibleTypeAnnotationsAttribute) {
            RuntimeInvisibleTypeAnnotationsAttribute aa = (RuntimeInvisibleTypeAnnotationsAttribute)a;
            size = ParserVerifier.typeAnnotationsSize(aa.annotations());
        } else if (a instanceof RuntimeVisibleParameterAnnotationsAttribute) {
            RuntimeVisibleParameterAnnotationsAttribute aa = (RuntimeVisibleParameterAnnotationsAttribute)a;
            size = ParserVerifier.parameterAnnotationsSize(aa.parameterAnnotations());
        } else if (a instanceof RuntimeInvisibleParameterAnnotationsAttribute) {
            RuntimeInvisibleParameterAnnotationsAttribute aa = (RuntimeInvisibleParameterAnnotationsAttribute)a;
            size = ParserVerifier.parameterAnnotationsSize(aa.parameterAnnotations());
        } else if (a instanceof SignatureAttribute) {
            SignatureAttribute sa = (SignatureAttribute)a;
            sa.signature();
            size = 2;
        } else if (a instanceof SourceDebugExtensionAttribute) {
            SourceDebugExtensionAttribute sda = (SourceDebugExtensionAttribute)a;
            size = sda.contents().length;
        } else if (a instanceof SourceFileAttribute) {
            SourceFileAttribute sfa = (SourceFileAttribute)a;
            sfa.sourceFile();
            size = 2;
        } else if (a instanceof SourceIDAttribute) {
            SourceIDAttribute sida = (SourceIDAttribute)a;
            sida.sourceId();
            size = 2;
        } else if (a instanceof StackMapTableAttribute) {
            StackMapTableAttribute smta = (StackMapTableAttribute)a;
            size = 2 + ParserVerifier.subSize(smta.entries(), this::stackMapFrameSize);
        } else if (a instanceof SyntheticAttribute) {
            size = 0;
        } else {
            if (a instanceof UnknownAttribute) {
                return;
            }
            if (a instanceof CustomAttribute) return;
            throw new AssertionError(a);
        }
        if (size < 0) return;
        if (size == ((BoundAttribute)a).payloadLen()) return;
        errors.add(new VerifyError("Wrong %s attribute length in %s".formatted(a.attributeName().stringValue(), this.toString(ae))));
    }

    private static <T, S extends Collection<?>> int subSize(Collection<T> entries, Function<T, S> subMH, int entrySize, int subSize) {
        return ParserVerifier.subSize(entries, t -> entrySize + subSize * ((Collection)subMH.apply(t)).size());
    }

    private static <T> int subSize(Collection<T> entries, ToIntFunction<T> subMH) {
        int l = 0;
        for (T entry : entries) {
            l += subMH.applyAsInt(entry);
        }
        return l;
    }

    private static int componentsSize(List<RecordComponentInfo> comps) {
        int l = 2;
        for (RecordComponentInfo rc : comps) {
            l += 4 + ParserVerifier.attributesSize(rc.attributes());
        }
        return l;
    }

    private static int attributesSize(List<Attribute<?>> attrs) {
        int l = 2;
        for (Attribute<?> a : attrs) {
            l += 6 + ((BoundAttribute)a).payloadLen();
        }
        return l;
    }

    private static int parameterAnnotationsSize(List<List<Annotation>> pans) {
        int l = 1;
        for (List<Annotation> ans : pans) {
            l += ParserVerifier.annotationsSize(ans);
        }
        return l;
    }

    private static int annotationsSize(List<Annotation> ans) {
        int l = 2;
        for (Annotation an : ans) {
            l += ParserVerifier.annotationSize(an);
        }
        return l;
    }

    private static int typeAnnotationsSize(List<TypeAnnotation> ans) {
        int l = 2;
        for (TypeAnnotation an : ans) {
            l += 2 + an.targetInfo().size() + 2 * an.targetPath().size() + ParserVerifier.annotationSize(an.annotation());
        }
        return l;
    }

    private static int annotationSize(Annotation an) {
        int l = 4;
        for (AnnotationElement el : an.elements()) {
            l += 2 + ParserVerifier.valueSize(el.value());
        }
        return l;
    }

    private static int valueSize(AnnotationValue val) {
        if (val instanceof AnnotationValue.OfAnnotation) {
            AnnotationValue.OfAnnotation oan = (AnnotationValue.OfAnnotation)val;
            return 1 + ParserVerifier.annotationSize(oan.annotation());
        }
        if (val instanceof AnnotationValue.OfArray) {
            AnnotationValue.OfArray oar = (AnnotationValue.OfArray)val;
            int l = 2;
            for (AnnotationValue v : oar.values()) {
                l += ParserVerifier.valueSize(v);
            }
            return 1 + l;
        }
        if (val instanceof AnnotationValue.OfConstant || val instanceof AnnotationValue.OfClass) {
            return 3;
        }
        if (val instanceof AnnotationValue.OfEnum) {
            return 5;
        }
        throw new IllegalStateException();
    }

    private static int moduleHashesSize(List<ModuleHashInfo> hashes) {
        int l = 2;
        for (ModuleHashInfo h : hashes) {
            h.moduleName();
            l += 4 + h.hash().length;
        }
        return l;
    }

    private int stackMapFrameSize(StackMapFrameInfo frame) {
        int ft = frame.frameType();
        if (ft < 64) {
            return 1;
        }
        if (ft < 128) {
            return 1 + ParserVerifier.verificationTypeSize(frame.stack().get(0));
        }
        if (ft > 246) {
            if (ft == 247) {
                return 3 + ParserVerifier.verificationTypeSize(frame.stack().get(0));
            }
            if (ft < 252) {
                return 3;
            }
            if (ft < 255) {
                List<StackMapFrameInfo.VerificationTypeInfo> loc = frame.locals();
                int l = 3;
                for (int i = loc.size() + 251 - ft; i < loc.size(); ++i) {
                    l += ParserVerifier.verificationTypeSize(loc.get(i));
                }
                return l;
            }
            if (ft == 255) {
                int l = 7;
                for (StackMapFrameInfo.VerificationTypeInfo vt : frame.stack()) {
                    l += ParserVerifier.verificationTypeSize(vt);
                }
                for (StackMapFrameInfo.VerificationTypeInfo vt : frame.locals()) {
                    l += ParserVerifier.verificationTypeSize(vt);
                }
                return l;
            }
        }
        throw new IllegalArgumentException("Invalid stack map frame type " + ft);
    }

    private static int verificationTypeSize(StackMapFrameInfo.VerificationTypeInfo vti) {
        if (vti instanceof StackMapFrameInfo.SimpleVerificationTypeInfo) {
            return 1;
        }
        if (vti instanceof StackMapFrameInfo.ObjectVerificationTypeInfo) {
            StackMapFrameInfo.ObjectVerificationTypeInfo ovti = (StackMapFrameInfo.ObjectVerificationTypeInfo)vti;
            ovti.classSymbol();
            return 3;
        }
        if (vti instanceof StackMapFrameInfo.UninitializedVerificationTypeInfo) {
            return 3;
        }
        throw new IllegalStateException();
    }

    private String className() {
        return this.classModel.thisClass().asSymbol().displayName();
    }

    private String toString(AttributedElement ae) {
        Object object;
        if (ae instanceof CodeModel) {
            CodeModel m = (CodeModel)ae;
            object = "Code attribute for " + this.toString(m.parent().get());
        } else if (ae instanceof FieldModel) {
            FieldModel m = (FieldModel)ae;
            object = "field %s.%s".formatted(this.className(), m.fieldName().stringValue());
        } else if (ae instanceof MethodModel) {
            MethodModel m = (MethodModel)ae;
            object = "method %s::%s(%s)".formatted(this.className(), m.methodName().stringValue(), m.methodTypeSymbol().parameterList().stream().map(ClassDesc::displayName).collect(Collectors.joining(",")));
        } else if (ae instanceof RecordComponentInfo) {
            RecordComponentInfo i = (RecordComponentInfo)ae;
            object = "Record component %s of class %s".formatted(i.name().stringValue(), this.className());
        } else {
            object = "class " + this.className();
        }
        return object;
    }
}

