/*

    This file was generated with glesw_gen.cmake, part of glXXw
    (hosted at https://github.com/paroj/glXXw-cmake)

    This is free and unencumbered software released into the public domain.

    Anyone is free to copy, modify, publish, use, compile, sell, or
    distribute this software, either in source code form or as a compiled
    binary, for any purpose, commercial or non-commercial, and by any
    means.

    In jurisdictions that recognize copyright laws, the author or authors
    of this software dedicate any and all copyright interest in the
    software to the public domain. We make this dedication for the benefit
    of the public at large and to the detriment of our heirs and
    successors. We intend this dedication to be an overt act of
    relinquishment in perpetuity of all present and future rights to this
    software under copyright law.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR
    OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
    ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
    OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __glesw_h_
#define __glesw_h_

#include <GLES3/gl3.h>
#include <KHR/khrplatform.h>
#include <GLES3/gl3platform.h>
#include <GLES2/gl2ext.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void (*GLESWglProc)(void);
typedef GLESWglProc (*GLESWGetProcAddressProc)(const char *proc);

/* glesw api */
int gleswInit(void);
int gleswInit2(GLESWGetProcAddressProc proc);
int gleswIsSupported(int major, int minor);
GLESWglProc gleswGetProcAddress(const char *proc);

/* OpenGL functions */
extern PFNGLACTIVESHADERPROGRAMEXTPROC                         gleswActiveShaderProgramEXT;
extern PFNGLACTIVETEXTUREPROC                                  gleswActiveTexture;
extern PFNGLALPHAFUNCQCOMPROC                                  gleswAlphaFuncQCOM;
extern PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC            gleswApplyFramebufferAttachmentCMAAINTEL;
extern PFNGLATTACHSHADERPROC                                   gleswAttachShader;
extern PFNGLBEGINCONDITIONALRENDERNVPROC                       gleswBeginConditionalRenderNV;
extern PFNGLBEGINPERFMONITORAMDPROC                            gleswBeginPerfMonitorAMD;
extern PFNGLBEGINPERFQUERYINTELPROC                            gleswBeginPerfQueryINTEL;
extern PFNGLBEGINQUERYPROC                                     gleswBeginQuery;
extern PFNGLBEGINQUERYEXTPROC                                  gleswBeginQueryEXT;
extern PFNGLBEGINTRANSFORMFEEDBACKPROC                         gleswBeginTransformFeedback;
extern PFNGLBINDATTRIBLOCATIONPROC                             gleswBindAttribLocation;
extern PFNGLBINDBUFFERPROC                                     gleswBindBuffer;
extern PFNGLBINDBUFFERBASEPROC                                 gleswBindBufferBase;
extern PFNGLBINDBUFFERRANGEPROC                                gleswBindBufferRange;
extern PFNGLBINDFRAGDATALOCATIONEXTPROC                        gleswBindFragDataLocationEXT;
extern PFNGLBINDFRAGDATALOCATIONINDEXEDEXTPROC                 gleswBindFragDataLocationIndexedEXT;
extern PFNGLBINDFRAMEBUFFERPROC                                gleswBindFramebuffer;
extern PFNGLBINDPROGRAMPIPELINEEXTPROC                         gleswBindProgramPipelineEXT;
extern PFNGLBINDRENDERBUFFERPROC                               gleswBindRenderbuffer;
extern PFNGLBINDSAMPLERPROC                                    gleswBindSampler;
extern PFNGLBINDTEXTUREPROC                                    gleswBindTexture;
extern PFNGLBINDTRANSFORMFEEDBACKPROC                          gleswBindTransformFeedback;
extern PFNGLBINDVERTEXARRAYPROC                                gleswBindVertexArray;
extern PFNGLBINDVERTEXARRAYOESPROC                             gleswBindVertexArrayOES;
extern PFNGLBLENDBARRIERKHRPROC                                gleswBlendBarrierKHR;
extern PFNGLBLENDBARRIERNVPROC                                 gleswBlendBarrierNV;
extern PFNGLBLENDCOLORPROC                                     gleswBlendColor;
extern PFNGLBLENDEQUATIONPROC                                  gleswBlendEquation;
extern PFNGLBLENDEQUATIONSEPARATEPROC                          gleswBlendEquationSeparate;
extern PFNGLBLENDEQUATIONSEPARATEIEXTPROC                      gleswBlendEquationSeparateiEXT;
extern PFNGLBLENDEQUATIONSEPARATEIOESPROC                      gleswBlendEquationSeparateiOES;
extern PFNGLBLENDEQUATIONIEXTPROC                              gleswBlendEquationiEXT;
extern PFNGLBLENDEQUATIONIOESPROC                              gleswBlendEquationiOES;
extern PFNGLBLENDFUNCPROC                                      gleswBlendFunc;
extern PFNGLBLENDFUNCSEPARATEPROC                              gleswBlendFuncSeparate;
extern PFNGLBLENDFUNCSEPARATEIEXTPROC                          gleswBlendFuncSeparateiEXT;
extern PFNGLBLENDFUNCSEPARATEIOESPROC                          gleswBlendFuncSeparateiOES;
extern PFNGLBLENDFUNCIEXTPROC                                  gleswBlendFunciEXT;
extern PFNGLBLENDFUNCIOESPROC                                  gleswBlendFunciOES;
extern PFNGLBLENDPARAMETERINVPROC                              gleswBlendParameteriNV;
extern PFNGLBLITFRAMEBUFFERPROC                                gleswBlitFramebuffer;
extern PFNGLBLITFRAMEBUFFERANGLEPROC                           gleswBlitFramebufferANGLE;
extern PFNGLBLITFRAMEBUFFERNVPROC                              gleswBlitFramebufferNV;
extern PFNGLBUFFERDATAPROC                                     gleswBufferData;
extern PFNGLBUFFERSTORAGEEXTPROC                               gleswBufferStorageEXT;
extern PFNGLBUFFERSUBDATAPROC                                  gleswBufferSubData;
extern PFNGLCHECKFRAMEBUFFERSTATUSPROC                         gleswCheckFramebufferStatus;
extern PFNGLCLEARPROC                                          gleswClear;
extern PFNGLCLEARBUFFERFIPROC                                  gleswClearBufferfi;
extern PFNGLCLEARBUFFERFVPROC                                  gleswClearBufferfv;
extern PFNGLCLEARBUFFERIVPROC                                  gleswClearBufferiv;
extern PFNGLCLEARBUFFERUIVPROC                                 gleswClearBufferuiv;
extern PFNGLCLEARCOLORPROC                                     gleswClearColor;
extern PFNGLCLEARDEPTHFPROC                                    gleswClearDepthf;
extern PFNGLCLEARPIXELLOCALSTORAGEUIEXTPROC                    gleswClearPixelLocalStorageuiEXT;
extern PFNGLCLEARSTENCILPROC                                   gleswClearStencil;
extern PFNGLCLIENTWAITSYNCPROC                                 gleswClientWaitSync;
extern PFNGLCLIENTWAITSYNCAPPLEPROC                            gleswClientWaitSyncAPPLE;
extern PFNGLCOLORMASKPROC                                      gleswColorMask;
extern PFNGLCOLORMASKIEXTPROC                                  gleswColorMaskiEXT;
extern PFNGLCOLORMASKIOESPROC                                  gleswColorMaskiOES;
extern PFNGLCOMPILESHADERPROC                                  gleswCompileShader;
extern PFNGLCOMPRESSEDTEXIMAGE2DPROC                           gleswCompressedTexImage2D;
extern PFNGLCOMPRESSEDTEXIMAGE3DPROC                           gleswCompressedTexImage3D;
extern PFNGLCOMPRESSEDTEXIMAGE3DOESPROC                        gleswCompressedTexImage3DOES;
extern PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC                        gleswCompressedTexSubImage2D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC                        gleswCompressedTexSubImage3D;
extern PFNGLCOMPRESSEDTEXSUBIMAGE3DOESPROC                     gleswCompressedTexSubImage3DOES;
extern PFNGLCOPYBUFFERSUBDATAPROC                              gleswCopyBufferSubData;
extern PFNGLCOPYBUFFERSUBDATANVPROC                            gleswCopyBufferSubDataNV;
extern PFNGLCOPYIMAGESUBDATAEXTPROC                            gleswCopyImageSubDataEXT;
extern PFNGLCOPYIMAGESUBDATAOESPROC                            gleswCopyImageSubDataOES;
extern PFNGLCOPYPATHNVPROC                                     gleswCopyPathNV;
extern PFNGLCOPYTEXIMAGE2DPROC                                 gleswCopyTexImage2D;
extern PFNGLCOPYTEXSUBIMAGE2DPROC                              gleswCopyTexSubImage2D;
extern PFNGLCOPYTEXSUBIMAGE3DPROC                              gleswCopyTexSubImage3D;
extern PFNGLCOPYTEXSUBIMAGE3DOESPROC                           gleswCopyTexSubImage3DOES;
extern PFNGLCOPYTEXTURELEVELSAPPLEPROC                         gleswCopyTextureLevelsAPPLE;
extern PFNGLCOVERFILLPATHINSTANCEDNVPROC                       gleswCoverFillPathInstancedNV;
extern PFNGLCOVERFILLPATHNVPROC                                gleswCoverFillPathNV;
extern PFNGLCOVERSTROKEPATHINSTANCEDNVPROC                     gleswCoverStrokePathInstancedNV;
extern PFNGLCOVERSTROKEPATHNVPROC                              gleswCoverStrokePathNV;
extern PFNGLCOVERAGEMASKNVPROC                                 gleswCoverageMaskNV;
extern PFNGLCOVERAGEMODULATIONNVPROC                           gleswCoverageModulationNV;
extern PFNGLCOVERAGEMODULATIONTABLENVPROC                      gleswCoverageModulationTableNV;
extern PFNGLCOVERAGEOPERATIONNVPROC                            gleswCoverageOperationNV;
extern PFNGLCREATEPERFQUERYINTELPROC                           gleswCreatePerfQueryINTEL;
extern PFNGLCREATEPROGRAMPROC                                  gleswCreateProgram;
extern PFNGLCREATESHADERPROC                                   gleswCreateShader;
extern PFNGLCREATESHADERPROGRAMVEXTPROC                        gleswCreateShaderProgramvEXT;
extern PFNGLCULLFACEPROC                                       gleswCullFace;
extern PFNGLDEBUGMESSAGECALLBACKKHRPROC                        gleswDebugMessageCallbackKHR;
extern PFNGLDEBUGMESSAGECONTROLKHRPROC                         gleswDebugMessageControlKHR;
extern PFNGLDEBUGMESSAGEINSERTKHRPROC                          gleswDebugMessageInsertKHR;
extern PFNGLDELETEBUFFERSPROC                                  gleswDeleteBuffers;
extern PFNGLDELETEFENCESNVPROC                                 gleswDeleteFencesNV;
extern PFNGLDELETEFRAMEBUFFERSPROC                             gleswDeleteFramebuffers;
extern PFNGLDELETEPATHSNVPROC                                  gleswDeletePathsNV;
extern PFNGLDELETEPERFMONITORSAMDPROC                          gleswDeletePerfMonitorsAMD;
extern PFNGLDELETEPERFQUERYINTELPROC                           gleswDeletePerfQueryINTEL;
extern PFNGLDELETEPROGRAMPROC                                  gleswDeleteProgram;
extern PFNGLDELETEPROGRAMPIPELINESEXTPROC                      gleswDeleteProgramPipelinesEXT;
extern PFNGLDELETEQUERIESPROC                                  gleswDeleteQueries;
extern PFNGLDELETEQUERIESEXTPROC                               gleswDeleteQueriesEXT;
extern PFNGLDELETERENDERBUFFERSPROC                            gleswDeleteRenderbuffers;
extern PFNGLDELETESAMPLERSPROC                                 gleswDeleteSamplers;
extern PFNGLDELETESHADERPROC                                   gleswDeleteShader;
extern PFNGLDELETESYNCPROC                                     gleswDeleteSync;
extern PFNGLDELETESYNCAPPLEPROC                                gleswDeleteSyncAPPLE;
extern PFNGLDELETETEXTURESPROC                                 gleswDeleteTextures;
extern PFNGLDELETETRANSFORMFEEDBACKSPROC                       gleswDeleteTransformFeedbacks;
extern PFNGLDELETEVERTEXARRAYSPROC                             gleswDeleteVertexArrays;
extern PFNGLDELETEVERTEXARRAYSOESPROC                          gleswDeleteVertexArraysOES;
extern PFNGLDEPTHFUNCPROC                                      gleswDepthFunc;
extern PFNGLDEPTHMASKPROC                                      gleswDepthMask;
extern PFNGLDEPTHRANGEARRAYFVNVPROC                            gleswDepthRangeArrayfvNV;
extern PFNGLDEPTHRANGEINDEXEDFNVPROC                           gleswDepthRangeIndexedfNV;
extern PFNGLDEPTHRANGEFPROC                                    gleswDepthRangef;
extern PFNGLDETACHSHADERPROC                                   gleswDetachShader;
extern PFNGLDISABLEPROC                                        gleswDisable;
extern PFNGLDISABLEDRIVERCONTROLQCOMPROC                       gleswDisableDriverControlQCOM;
extern PFNGLDISABLEVERTEXATTRIBARRAYPROC                       gleswDisableVertexAttribArray;
extern PFNGLDISABLEIEXTPROC                                    gleswDisableiEXT;
extern PFNGLDISABLEINVPROC                                     gleswDisableiNV;
extern PFNGLDISABLEIOESPROC                                    gleswDisableiOES;
extern PFNGLDISCARDFRAMEBUFFEREXTPROC                          gleswDiscardFramebufferEXT;
extern PFNGLDRAWARRAYSPROC                                     gleswDrawArrays;
extern PFNGLDRAWARRAYSINSTANCEDPROC                            gleswDrawArraysInstanced;
extern PFNGLDRAWARRAYSINSTANCEDANGLEPROC                       gleswDrawArraysInstancedANGLE;
extern PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEEXTPROC             gleswDrawArraysInstancedBaseInstanceEXT;
extern PFNGLDRAWARRAYSINSTANCEDEXTPROC                         gleswDrawArraysInstancedEXT;
extern PFNGLDRAWARRAYSINSTANCEDNVPROC                          gleswDrawArraysInstancedNV;
extern PFNGLDRAWBUFFERSPROC                                    gleswDrawBuffers;
extern PFNGLDRAWBUFFERSEXTPROC                                 gleswDrawBuffersEXT;
extern PFNGLDRAWBUFFERSINDEXEDEXTPROC                          gleswDrawBuffersIndexedEXT;
extern PFNGLDRAWBUFFERSNVPROC                                  gleswDrawBuffersNV;
extern PFNGLDRAWELEMENTSPROC                                   gleswDrawElements;
extern PFNGLDRAWELEMENTSBASEVERTEXEXTPROC                      gleswDrawElementsBaseVertexEXT;
extern PFNGLDRAWELEMENTSBASEVERTEXOESPROC                      gleswDrawElementsBaseVertexOES;
extern PFNGLDRAWELEMENTSINSTANCEDPROC                          gleswDrawElementsInstanced;
extern PFNGLDRAWELEMENTSINSTANCEDANGLEPROC                     gleswDrawElementsInstancedANGLE;
extern PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEEXTPROC           gleswDrawElementsInstancedBaseInstanceEXT;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEEXTPROC gleswDrawElementsInstancedBaseVertexBaseInstanceEXT;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXEXTPROC             gleswDrawElementsInstancedBaseVertexEXT;
extern PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXOESPROC             gleswDrawElementsInstancedBaseVertexOES;
extern PFNGLDRAWELEMENTSINSTANCEDEXTPROC                       gleswDrawElementsInstancedEXT;
extern PFNGLDRAWELEMENTSINSTANCEDNVPROC                        gleswDrawElementsInstancedNV;
extern PFNGLDRAWRANGEELEMENTSPROC                              gleswDrawRangeElements;
extern PFNGLDRAWRANGEELEMENTSBASEVERTEXEXTPROC                 gleswDrawRangeElementsBaseVertexEXT;
extern PFNGLDRAWRANGEELEMENTSBASEVERTEXOESPROC                 gleswDrawRangeElementsBaseVertexOES;
extern PFNGLEGLIMAGETARGETRENDERBUFFERSTORAGEOESPROC           gleswEGLImageTargetRenderbufferStorageOES;
extern PFNGLEGLIMAGETARGETTEXTURE2DOESPROC                     gleswEGLImageTargetTexture2DOES;
extern PFNGLENABLEPROC                                         gleswEnable;
extern PFNGLENABLEDRIVERCONTROLQCOMPROC                        gleswEnableDriverControlQCOM;
extern PFNGLENABLEVERTEXATTRIBARRAYPROC                        gleswEnableVertexAttribArray;
extern PFNGLENABLEIEXTPROC                                     gleswEnableiEXT;
extern PFNGLENABLEINVPROC                                      gleswEnableiNV;
extern PFNGLENABLEIOESPROC                                     gleswEnableiOES;
extern PFNGLENDCONDITIONALRENDERNVPROC                         gleswEndConditionalRenderNV;
extern PFNGLENDPERFMONITORAMDPROC                              gleswEndPerfMonitorAMD;
extern PFNGLENDPERFQUERYINTELPROC                              gleswEndPerfQueryINTEL;
extern PFNGLENDQUERYPROC                                       gleswEndQuery;
extern PFNGLENDQUERYEXTPROC                                    gleswEndQueryEXT;
extern PFNGLENDTILINGQCOMPROC                                  gleswEndTilingQCOM;
extern PFNGLENDTRANSFORMFEEDBACKPROC                           gleswEndTransformFeedback;
extern PFNGLEXTGETBUFFERPOINTERVQCOMPROC                       gleswExtGetBufferPointervQCOM;
extern PFNGLEXTGETBUFFERSQCOMPROC                              gleswExtGetBuffersQCOM;
extern PFNGLEXTGETFRAMEBUFFERSQCOMPROC                         gleswExtGetFramebuffersQCOM;
extern PFNGLEXTGETPROGRAMBINARYSOURCEQCOMPROC                  gleswExtGetProgramBinarySourceQCOM;
extern PFNGLEXTGETPROGRAMSQCOMPROC                             gleswExtGetProgramsQCOM;
extern PFNGLEXTGETRENDERBUFFERSQCOMPROC                        gleswExtGetRenderbuffersQCOM;
extern PFNGLEXTGETSHADERSQCOMPROC                              gleswExtGetShadersQCOM;
extern PFNGLEXTGETTEXLEVELPARAMETERIVQCOMPROC                  gleswExtGetTexLevelParameterivQCOM;
extern PFNGLEXTGETTEXSUBIMAGEQCOMPROC                          gleswExtGetTexSubImageQCOM;
extern PFNGLEXTGETTEXTURESQCOMPROC                             gleswExtGetTexturesQCOM;
extern PFNGLEXTISPROGRAMBINARYQCOMPROC                         gleswExtIsProgramBinaryQCOM;
extern PFNGLEXTTEXOBJECTSTATEOVERRIDEIQCOMPROC                 gleswExtTexObjectStateOverrideiQCOM;
extern PFNGLFENCESYNCPROC                                      gleswFenceSync;
extern PFNGLFENCESYNCAPPLEPROC                                 gleswFenceSyncAPPLE;
extern PFNGLFINISHPROC                                         gleswFinish;
extern PFNGLFINISHFENCENVPROC                                  gleswFinishFenceNV;
extern PFNGLFLUSHPROC                                          gleswFlush;
extern PFNGLFLUSHMAPPEDBUFFERRANGEPROC                         gleswFlushMappedBufferRange;
extern PFNGLFLUSHMAPPEDBUFFERRANGEEXTPROC                      gleswFlushMappedBufferRangeEXT;
extern PFNGLFRAGMENTCOVERAGECOLORNVPROC                        gleswFragmentCoverageColorNV;
extern PFNGLFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC            gleswFramebufferPixelLocalStorageSizeEXT;
extern PFNGLFRAMEBUFFERRENDERBUFFERPROC                        gleswFramebufferRenderbuffer;
extern PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC                 gleswFramebufferSampleLocationsfvNV;
extern PFNGLFRAMEBUFFERTEXTURE2DPROC                           gleswFramebufferTexture2D;
extern PFNGLFRAMEBUFFERTEXTURE2DDOWNSAMPLEIMGPROC              gleswFramebufferTexture2DDownsampleIMG;
extern PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEEXTPROC             gleswFramebufferTexture2DMultisampleEXT;
extern PFNGLFRAMEBUFFERTEXTURE2DMULTISAMPLEIMGPROC             gleswFramebufferTexture2DMultisampleIMG;
extern PFNGLFRAMEBUFFERTEXTURE3DOESPROC                        gleswFramebufferTexture3DOES;
extern PFNGLFRAMEBUFFERTEXTUREEXTPROC                          gleswFramebufferTextureEXT;
extern PFNGLFRAMEBUFFERTEXTURELAYERPROC                        gleswFramebufferTextureLayer;
extern PFNGLFRAMEBUFFERTEXTURELAYERDOWNSAMPLEIMGPROC           gleswFramebufferTextureLayerDownsampleIMG;
extern PFNGLFRAMEBUFFERTEXTUREMULTISAMPLEMULTIVIEWOVRPROC      gleswFramebufferTextureMultisampleMultiviewOVR;
extern PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC                 gleswFramebufferTextureMultiviewOVR;
extern PFNGLFRAMEBUFFERTEXTUREOESPROC                          gleswFramebufferTextureOES;
extern PFNGLFRONTFACEPROC                                      gleswFrontFace;
extern PFNGLGENBUFFERSPROC                                     gleswGenBuffers;
extern PFNGLGENFENCESNVPROC                                    gleswGenFencesNV;
extern PFNGLGENFRAMEBUFFERSPROC                                gleswGenFramebuffers;
extern PFNGLGENPATHSNVPROC                                     gleswGenPathsNV;
extern PFNGLGENPERFMONITORSAMDPROC                             gleswGenPerfMonitorsAMD;
extern PFNGLGENPROGRAMPIPELINESEXTPROC                         gleswGenProgramPipelinesEXT;
extern PFNGLGENQUERIESPROC                                     gleswGenQueries;
extern PFNGLGENQUERIESEXTPROC                                  gleswGenQueriesEXT;
extern PFNGLGENRENDERBUFFERSPROC                               gleswGenRenderbuffers;
extern PFNGLGENSAMPLERSPROC                                    gleswGenSamplers;
extern PFNGLGENTEXTURESPROC                                    gleswGenTextures;
extern PFNGLGENTRANSFORMFEEDBACKSPROC                          gleswGenTransformFeedbacks;
extern PFNGLGENVERTEXARRAYSPROC                                gleswGenVertexArrays;
extern PFNGLGENVERTEXARRAYSOESPROC                             gleswGenVertexArraysOES;
extern PFNGLGENERATEMIPMAPPROC                                 gleswGenerateMipmap;
extern PFNGLGETACTIVEATTRIBPROC                                gleswGetActiveAttrib;
extern PFNGLGETACTIVEUNIFORMPROC                               gleswGetActiveUniform;
extern PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC                      gleswGetActiveUniformBlockName;
extern PFNGLGETACTIVEUNIFORMBLOCKIVPROC                        gleswGetActiveUniformBlockiv;
extern PFNGLGETACTIVEUNIFORMSIVPROC                            gleswGetActiveUniformsiv;
extern PFNGLGETATTACHEDSHADERSPROC                             gleswGetAttachedShaders;
extern PFNGLGETATTRIBLOCATIONPROC                              gleswGetAttribLocation;
extern PFNGLGETBOOLEANVPROC                                    gleswGetBooleanv;
extern PFNGLGETBUFFERPARAMETERI64VPROC                         gleswGetBufferParameteri64v;
extern PFNGLGETBUFFERPARAMETERIVPROC                           gleswGetBufferParameteriv;
extern PFNGLGETBUFFERPOINTERVPROC                              gleswGetBufferPointerv;
extern PFNGLGETBUFFERPOINTERVOESPROC                           gleswGetBufferPointervOES;
extern PFNGLGETCOVERAGEMODULATIONTABLENVPROC                   gleswGetCoverageModulationTableNV;
extern PFNGLGETDEBUGMESSAGELOGKHRPROC                          gleswGetDebugMessageLogKHR;
extern PFNGLGETDRIVERCONTROLSTRINGQCOMPROC                     gleswGetDriverControlStringQCOM;
extern PFNGLGETDRIVERCONTROLSQCOMPROC                          gleswGetDriverControlsQCOM;
extern PFNGLGETERRORPROC                                       gleswGetError;
extern PFNGLGETFENCEIVNVPROC                                   gleswGetFenceivNV;
extern PFNGLGETFIRSTPERFQUERYIDINTELPROC                       gleswGetFirstPerfQueryIdINTEL;
extern PFNGLGETFLOATI_VNVPROC                                  gleswGetFloati_vNV;
extern PFNGLGETFLOATVPROC                                      gleswGetFloatv;
extern PFNGLGETFRAGDATAINDEXEXTPROC                            gleswGetFragDataIndexEXT;
extern PFNGLGETFRAGDATALOCATIONPROC                            gleswGetFragDataLocation;
extern PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC            gleswGetFramebufferAttachmentParameteriv;
extern PFNGLGETFRAMEBUFFERPIXELLOCALSTORAGESIZEEXTPROC         gleswGetFramebufferPixelLocalStorageSizeEXT;
extern PFNGLGETGRAPHICSRESETSTATUSEXTPROC                      gleswGetGraphicsResetStatusEXT;
extern PFNGLGETGRAPHICSRESETSTATUSKHRPROC                      gleswGetGraphicsResetStatusKHR;
extern PFNGLGETIMAGEHANDLENVPROC                               gleswGetImageHandleNV;
extern PFNGLGETINTEGER64I_VPROC                                gleswGetInteger64i_v;
extern PFNGLGETINTEGER64VPROC                                  gleswGetInteger64v;
extern PFNGLGETINTEGER64VAPPLEPROC                             gleswGetInteger64vAPPLE;
extern PFNGLGETINTEGERI_VPROC                                  gleswGetIntegeri_v;
extern PFNGLGETINTEGERI_VEXTPROC                               gleswGetIntegeri_vEXT;
extern PFNGLGETINTEGERVPROC                                    gleswGetIntegerv;
extern PFNGLGETINTERNALFORMATSAMPLEIVNVPROC                    gleswGetInternalformatSampleivNV;
extern PFNGLGETINTERNALFORMATIVPROC                            gleswGetInternalformativ;
extern PFNGLGETNEXTPERFQUERYIDINTELPROC                        gleswGetNextPerfQueryIdINTEL;
extern PFNGLGETOBJECTLABELEXTPROC                              gleswGetObjectLabelEXT;
extern PFNGLGETOBJECTLABELKHRPROC                              gleswGetObjectLabelKHR;
extern PFNGLGETOBJECTPTRLABELKHRPROC                           gleswGetObjectPtrLabelKHR;
extern PFNGLGETPATHCOMMANDSNVPROC                              gleswGetPathCommandsNV;
extern PFNGLGETPATHCOORDSNVPROC                                gleswGetPathCoordsNV;
extern PFNGLGETPATHDASHARRAYNVPROC                             gleswGetPathDashArrayNV;
extern PFNGLGETPATHLENGTHNVPROC                                gleswGetPathLengthNV;
extern PFNGLGETPATHMETRICRANGENVPROC                           gleswGetPathMetricRangeNV;
extern PFNGLGETPATHMETRICSNVPROC                               gleswGetPathMetricsNV;
extern PFNGLGETPATHPARAMETERFVNVPROC                           gleswGetPathParameterfvNV;
extern PFNGLGETPATHPARAMETERIVNVPROC                           gleswGetPathParameterivNV;
extern PFNGLGETPATHSPACINGNVPROC                               gleswGetPathSpacingNV;
extern PFNGLGETPERFCOUNTERINFOINTELPROC                        gleswGetPerfCounterInfoINTEL;
extern PFNGLGETPERFMONITORCOUNTERDATAAMDPROC                   gleswGetPerfMonitorCounterDataAMD;
extern PFNGLGETPERFMONITORCOUNTERINFOAMDPROC                   gleswGetPerfMonitorCounterInfoAMD;
extern PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC                 gleswGetPerfMonitorCounterStringAMD;
extern PFNGLGETPERFMONITORCOUNTERSAMDPROC                      gleswGetPerfMonitorCountersAMD;
extern PFNGLGETPERFMONITORGROUPSTRINGAMDPROC                   gleswGetPerfMonitorGroupStringAMD;
extern PFNGLGETPERFMONITORGROUPSAMDPROC                        gleswGetPerfMonitorGroupsAMD;
extern PFNGLGETPERFQUERYDATAINTELPROC                          gleswGetPerfQueryDataINTEL;
extern PFNGLGETPERFQUERYIDBYNAMEINTELPROC                      gleswGetPerfQueryIdByNameINTEL;
extern PFNGLGETPERFQUERYINFOINTELPROC                          gleswGetPerfQueryInfoINTEL;
extern PFNGLGETPOINTERVKHRPROC                                 gleswGetPointervKHR;
extern PFNGLGETPROGRAMBINARYPROC                               gleswGetProgramBinary;
extern PFNGLGETPROGRAMBINARYOESPROC                            gleswGetProgramBinaryOES;
extern PFNGLGETPROGRAMINFOLOGPROC                              gleswGetProgramInfoLog;
extern PFNGLGETPROGRAMPIPELINEINFOLOGEXTPROC                   gleswGetProgramPipelineInfoLogEXT;
extern PFNGLGETPROGRAMPIPELINEIVEXTPROC                        gleswGetProgramPipelineivEXT;
extern PFNGLGETPROGRAMRESOURCELOCATIONINDEXEXTPROC             gleswGetProgramResourceLocationIndexEXT;
extern PFNGLGETPROGRAMRESOURCEFVNVPROC                         gleswGetProgramResourcefvNV;
extern PFNGLGETPROGRAMIVPROC                                   gleswGetProgramiv;
extern PFNGLGETQUERYOBJECTI64VEXTPROC                          gleswGetQueryObjecti64vEXT;
extern PFNGLGETQUERYOBJECTIVEXTPROC                            gleswGetQueryObjectivEXT;
extern PFNGLGETQUERYOBJECTUI64VEXTPROC                         gleswGetQueryObjectui64vEXT;
extern PFNGLGETQUERYOBJECTUIVPROC                              gleswGetQueryObjectuiv;
extern PFNGLGETQUERYOBJECTUIVEXTPROC                           gleswGetQueryObjectuivEXT;
extern PFNGLGETQUERYIVPROC                                     gleswGetQueryiv;
extern PFNGLGETQUERYIVEXTPROC                                  gleswGetQueryivEXT;
extern PFNGLGETRENDERBUFFERPARAMETERIVPROC                     gleswGetRenderbufferParameteriv;
extern PFNGLGETSAMPLERPARAMETERIIVEXTPROC                      gleswGetSamplerParameterIivEXT;
extern PFNGLGETSAMPLERPARAMETERIIVOESPROC                      gleswGetSamplerParameterIivOES;
extern PFNGLGETSAMPLERPARAMETERIUIVEXTPROC                     gleswGetSamplerParameterIuivEXT;
extern PFNGLGETSAMPLERPARAMETERIUIVOESPROC                     gleswGetSamplerParameterIuivOES;
extern PFNGLGETSAMPLERPARAMETERFVPROC                          gleswGetSamplerParameterfv;
extern PFNGLGETSAMPLERPARAMETERIVPROC                          gleswGetSamplerParameteriv;
extern PFNGLGETSHADERINFOLOGPROC                               gleswGetShaderInfoLog;
extern PFNGLGETSHADERPRECISIONFORMATPROC                       gleswGetShaderPrecisionFormat;
extern PFNGLGETSHADERSOURCEPROC                                gleswGetShaderSource;
extern PFNGLGETSHADERIVPROC                                    gleswGetShaderiv;
extern PFNGLGETSTRINGPROC                                      gleswGetString;
extern PFNGLGETSTRINGIPROC                                     gleswGetStringi;
extern PFNGLGETSYNCIVPROC                                      gleswGetSynciv;
extern PFNGLGETSYNCIVAPPLEPROC                                 gleswGetSyncivAPPLE;
extern PFNGLGETTEXPARAMETERIIVEXTPROC                          gleswGetTexParameterIivEXT;
extern PFNGLGETTEXPARAMETERIIVOESPROC                          gleswGetTexParameterIivOES;
extern PFNGLGETTEXPARAMETERIUIVEXTPROC                         gleswGetTexParameterIuivEXT;
extern PFNGLGETTEXPARAMETERIUIVOESPROC                         gleswGetTexParameterIuivOES;
extern PFNGLGETTEXPARAMETERFVPROC                              gleswGetTexParameterfv;
extern PFNGLGETTEXPARAMETERIVPROC                              gleswGetTexParameteriv;
extern PFNGLGETTEXTUREHANDLENVPROC                             gleswGetTextureHandleNV;
extern PFNGLGETTEXTURESAMPLERHANDLENVPROC                      gleswGetTextureSamplerHandleNV;
extern PFNGLGETTRANSFORMFEEDBACKVARYINGPROC                    gleswGetTransformFeedbackVarying;
extern PFNGLGETTRANSLATEDSHADERSOURCEANGLEPROC                 gleswGetTranslatedShaderSourceANGLE;
extern PFNGLGETUNIFORMBLOCKINDEXPROC                           gleswGetUniformBlockIndex;
extern PFNGLGETUNIFORMINDICESPROC                              gleswGetUniformIndices;
extern PFNGLGETUNIFORMLOCATIONPROC                             gleswGetUniformLocation;
extern PFNGLGETUNIFORMFVPROC                                   gleswGetUniformfv;
extern PFNGLGETUNIFORMIVPROC                                   gleswGetUniformiv;
extern PFNGLGETUNIFORMUIVPROC                                  gleswGetUniformuiv;
extern PFNGLGETVERTEXATTRIBIIVPROC                             gleswGetVertexAttribIiv;
extern PFNGLGETVERTEXATTRIBIUIVPROC                            gleswGetVertexAttribIuiv;
extern PFNGLGETVERTEXATTRIBPOINTERVPROC                        gleswGetVertexAttribPointerv;
extern PFNGLGETVERTEXATTRIBFVPROC                              gleswGetVertexAttribfv;
extern PFNGLGETVERTEXATTRIBIVPROC                              gleswGetVertexAttribiv;
extern PFNGLGETNUNIFORMFVEXTPROC                               gleswGetnUniformfvEXT;
extern PFNGLGETNUNIFORMFVKHRPROC                               gleswGetnUniformfvKHR;
extern PFNGLGETNUNIFORMIVEXTPROC                               gleswGetnUniformivEXT;
extern PFNGLGETNUNIFORMIVKHRPROC                               gleswGetnUniformivKHR;
extern PFNGLGETNUNIFORMUIVKHRPROC                              gleswGetnUniformuivKHR;
extern PFNGLHINTPROC                                           gleswHint;
extern PFNGLINSERTEVENTMARKEREXTPROC                           gleswInsertEventMarkerEXT;
extern PFNGLINTERPOLATEPATHSNVPROC                             gleswInterpolatePathsNV;
extern PFNGLINVALIDATEFRAMEBUFFERPROC                          gleswInvalidateFramebuffer;
extern PFNGLINVALIDATESUBFRAMEBUFFERPROC                       gleswInvalidateSubFramebuffer;
extern PFNGLISBUFFERPROC                                       gleswIsBuffer;
extern PFNGLISENABLEDPROC                                      gleswIsEnabled;
extern PFNGLISENABLEDIEXTPROC                                  gleswIsEnablediEXT;
extern PFNGLISENABLEDINVPROC                                   gleswIsEnablediNV;
extern PFNGLISENABLEDIOESPROC                                  gleswIsEnablediOES;
extern PFNGLISFENCENVPROC                                      gleswIsFenceNV;
extern PFNGLISFRAMEBUFFERPROC                                  gleswIsFramebuffer;
extern PFNGLISIMAGEHANDLERESIDENTNVPROC                        gleswIsImageHandleResidentNV;
extern PFNGLISPATHNVPROC                                       gleswIsPathNV;
extern PFNGLISPOINTINFILLPATHNVPROC                            gleswIsPointInFillPathNV;
extern PFNGLISPOINTINSTROKEPATHNVPROC                          gleswIsPointInStrokePathNV;
extern PFNGLISPROGRAMPROC                                      gleswIsProgram;
extern PFNGLISPROGRAMPIPELINEEXTPROC                           gleswIsProgramPipelineEXT;
extern PFNGLISQUERYPROC                                        gleswIsQuery;
extern PFNGLISQUERYEXTPROC                                     gleswIsQueryEXT;
extern PFNGLISRENDERBUFFERPROC                                 gleswIsRenderbuffer;
extern PFNGLISSAMPLERPROC                                      gleswIsSampler;
extern PFNGLISSHADERPROC                                       gleswIsShader;
extern PFNGLISSYNCPROC                                         gleswIsSync;
extern PFNGLISSYNCAPPLEPROC                                    gleswIsSyncAPPLE;
extern PFNGLISTEXTUREPROC                                      gleswIsTexture;
extern PFNGLISTEXTUREHANDLERESIDENTNVPROC                      gleswIsTextureHandleResidentNV;
extern PFNGLISTRANSFORMFEEDBACKPROC                            gleswIsTransformFeedback;
extern PFNGLISVERTEXARRAYPROC                                  gleswIsVertexArray;
extern PFNGLISVERTEXARRAYOESPROC                               gleswIsVertexArrayOES;
extern PFNGLLABELOBJECTEXTPROC                                 gleswLabelObjectEXT;
extern PFNGLLINEWIDTHPROC                                      gleswLineWidth;
extern PFNGLLINKPROGRAMPROC                                    gleswLinkProgram;
extern PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC                   gleswMakeImageHandleNonResidentNV;
extern PFNGLMAKEIMAGEHANDLERESIDENTNVPROC                      gleswMakeImageHandleResidentNV;
extern PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC                 gleswMakeTextureHandleNonResidentNV;
extern PFNGLMAKETEXTUREHANDLERESIDENTNVPROC                    gleswMakeTextureHandleResidentNV;
extern PFNGLMAPBUFFEROESPROC                                   gleswMapBufferOES;
extern PFNGLMAPBUFFERRANGEPROC                                 gleswMapBufferRange;
extern PFNGLMAPBUFFERRANGEEXTPROC                              gleswMapBufferRangeEXT;
extern PFNGLMATRIXLOAD3X2FNVPROC                               gleswMatrixLoad3x2fNV;
extern PFNGLMATRIXLOAD3X3FNVPROC                               gleswMatrixLoad3x3fNV;
extern PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC                      gleswMatrixLoadTranspose3x3fNV;
extern PFNGLMATRIXMULT3X2FNVPROC                               gleswMatrixMult3x2fNV;
extern PFNGLMATRIXMULT3X3FNVPROC                               gleswMatrixMult3x3fNV;
extern PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC                      gleswMatrixMultTranspose3x3fNV;
extern PFNGLMINSAMPLESHADINGOESPROC                            gleswMinSampleShadingOES;
extern PFNGLMULTIDRAWARRAYSEXTPROC                             gleswMultiDrawArraysEXT;
extern PFNGLMULTIDRAWARRAYSINDIRECTEXTPROC                     gleswMultiDrawArraysIndirectEXT;
extern PFNGLMULTIDRAWELEMENTSBASEVERTEXEXTPROC                 gleswMultiDrawElementsBaseVertexEXT;
extern PFNGLMULTIDRAWELEMENTSBASEVERTEXOESPROC                 gleswMultiDrawElementsBaseVertexOES;
extern PFNGLMULTIDRAWELEMENTSEXTPROC                           gleswMultiDrawElementsEXT;
extern PFNGLMULTIDRAWELEMENTSINDIRECTEXTPROC                   gleswMultiDrawElementsIndirectEXT;
extern PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC            gleswNamedFramebufferSampleLocationsfvNV;
extern PFNGLOBJECTLABELKHRPROC                                 gleswObjectLabelKHR;
extern PFNGLOBJECTPTRLABELKHRPROC                              gleswObjectPtrLabelKHR;
extern PFNGLPATCHPARAMETERIEXTPROC                             gleswPatchParameteriEXT;
extern PFNGLPATCHPARAMETERIOESPROC                             gleswPatchParameteriOES;
extern PFNGLPATHCOMMANDSNVPROC                                 gleswPathCommandsNV;
extern PFNGLPATHCOORDSNVPROC                                   gleswPathCoordsNV;
extern PFNGLPATHCOVERDEPTHFUNCNVPROC                           gleswPathCoverDepthFuncNV;
extern PFNGLPATHDASHARRAYNVPROC                                gleswPathDashArrayNV;
extern PFNGLPATHGLYPHINDEXARRAYNVPROC                          gleswPathGlyphIndexArrayNV;
extern PFNGLPATHGLYPHINDEXRANGENVPROC                          gleswPathGlyphIndexRangeNV;
extern PFNGLPATHGLYPHRANGENVPROC                               gleswPathGlyphRangeNV;
extern PFNGLPATHGLYPHSNVPROC                                   gleswPathGlyphsNV;
extern PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC                    gleswPathMemoryGlyphIndexArrayNV;
extern PFNGLPATHPARAMETERFNVPROC                               gleswPathParameterfNV;
extern PFNGLPATHPARAMETERFVNVPROC                              gleswPathParameterfvNV;
extern PFNGLPATHPARAMETERINVPROC                               gleswPathParameteriNV;
extern PFNGLPATHPARAMETERIVNVPROC                              gleswPathParameterivNV;
extern PFNGLPATHSTENCILDEPTHOFFSETNVPROC                       gleswPathStencilDepthOffsetNV;
extern PFNGLPATHSTENCILFUNCNVPROC                              gleswPathStencilFuncNV;
extern PFNGLPATHSTRINGNVPROC                                   gleswPathStringNV;
extern PFNGLPATHSUBCOMMANDSNVPROC                              gleswPathSubCommandsNV;
extern PFNGLPATHSUBCOORDSNVPROC                                gleswPathSubCoordsNV;
extern PFNGLPAUSETRANSFORMFEEDBACKPROC                         gleswPauseTransformFeedback;
extern PFNGLPIXELSTOREIPROC                                    gleswPixelStorei;
extern PFNGLPOINTALONGPATHNVPROC                               gleswPointAlongPathNV;
extern PFNGLPOLYGONMODENVPROC                                  gleswPolygonModeNV;
extern PFNGLPOLYGONOFFSETPROC                                  gleswPolygonOffset;
extern PFNGLPOLYGONOFFSETCLAMPEXTPROC                          gleswPolygonOffsetClampEXT;
extern PFNGLPOPDEBUGGROUPKHRPROC                               gleswPopDebugGroupKHR;
extern PFNGLPOPGROUPMARKEREXTPROC                              gleswPopGroupMarkerEXT;
extern PFNGLPRIMITIVEBOUNDINGBOXEXTPROC                        gleswPrimitiveBoundingBoxEXT;
extern PFNGLPRIMITIVEBOUNDINGBOXOESPROC                        gleswPrimitiveBoundingBoxOES;
extern PFNGLPROGRAMBINARYPROC                                  gleswProgramBinary;
extern PFNGLPROGRAMBINARYOESPROC                               gleswProgramBinaryOES;
extern PFNGLPROGRAMPARAMETERIPROC                              gleswProgramParameteri;
extern PFNGLPROGRAMPARAMETERIEXTPROC                           gleswProgramParameteriEXT;
extern PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC                  gleswProgramPathFragmentInputGenNV;
extern PFNGLPROGRAMUNIFORM1FEXTPROC                            gleswProgramUniform1fEXT;
extern PFNGLPROGRAMUNIFORM1FVEXTPROC                           gleswProgramUniform1fvEXT;
extern PFNGLPROGRAMUNIFORM1IEXTPROC                            gleswProgramUniform1iEXT;
extern PFNGLPROGRAMUNIFORM1IVEXTPROC                           gleswProgramUniform1ivEXT;
extern PFNGLPROGRAMUNIFORM1UIEXTPROC                           gleswProgramUniform1uiEXT;
extern PFNGLPROGRAMUNIFORM1UIVEXTPROC                          gleswProgramUniform1uivEXT;
extern PFNGLPROGRAMUNIFORM2FEXTPROC                            gleswProgramUniform2fEXT;
extern PFNGLPROGRAMUNIFORM2FVEXTPROC                           gleswProgramUniform2fvEXT;
extern PFNGLPROGRAMUNIFORM2IEXTPROC                            gleswProgramUniform2iEXT;
extern PFNGLPROGRAMUNIFORM2IVEXTPROC                           gleswProgramUniform2ivEXT;
extern PFNGLPROGRAMUNIFORM2UIEXTPROC                           gleswProgramUniform2uiEXT;
extern PFNGLPROGRAMUNIFORM2UIVEXTPROC                          gleswProgramUniform2uivEXT;
extern PFNGLPROGRAMUNIFORM3FEXTPROC                            gleswProgramUniform3fEXT;
extern PFNGLPROGRAMUNIFORM3FVEXTPROC                           gleswProgramUniform3fvEXT;
extern PFNGLPROGRAMUNIFORM3IEXTPROC                            gleswProgramUniform3iEXT;
extern PFNGLPROGRAMUNIFORM3IVEXTPROC                           gleswProgramUniform3ivEXT;
extern PFNGLPROGRAMUNIFORM3UIEXTPROC                           gleswProgramUniform3uiEXT;
extern PFNGLPROGRAMUNIFORM3UIVEXTPROC                          gleswProgramUniform3uivEXT;
extern PFNGLPROGRAMUNIFORM4FEXTPROC                            gleswProgramUniform4fEXT;
extern PFNGLPROGRAMUNIFORM4FVEXTPROC                           gleswProgramUniform4fvEXT;
extern PFNGLPROGRAMUNIFORM4IEXTPROC                            gleswProgramUniform4iEXT;
extern PFNGLPROGRAMUNIFORM4IVEXTPROC                           gleswProgramUniform4ivEXT;
extern PFNGLPROGRAMUNIFORM4UIEXTPROC                           gleswProgramUniform4uiEXT;
extern PFNGLPROGRAMUNIFORM4UIVEXTPROC                          gleswProgramUniform4uivEXT;
extern PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC                     gleswProgramUniformHandleui64NV;
extern PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC                    gleswProgramUniformHandleui64vNV;
extern PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC                     gleswProgramUniformMatrix2fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC                   gleswProgramUniformMatrix2x3fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC                   gleswProgramUniformMatrix2x4fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC                     gleswProgramUniformMatrix3fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC                   gleswProgramUniformMatrix3x2fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC                   gleswProgramUniformMatrix3x4fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC                     gleswProgramUniformMatrix4fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC                   gleswProgramUniformMatrix4x2fvEXT;
extern PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC                   gleswProgramUniformMatrix4x3fvEXT;
extern PFNGLPUSHDEBUGGROUPKHRPROC                              gleswPushDebugGroupKHR;
extern PFNGLPUSHGROUPMARKEREXTPROC                             gleswPushGroupMarkerEXT;
extern PFNGLQUERYCOUNTEREXTPROC                                gleswQueryCounterEXT;
extern PFNGLRASTERSAMPLESEXTPROC                               gleswRasterSamplesEXT;
extern PFNGLREADBUFFERPROC                                     gleswReadBuffer;
extern PFNGLREADBUFFERINDEXEDEXTPROC                           gleswReadBufferIndexedEXT;
extern PFNGLREADBUFFERNVPROC                                   gleswReadBufferNV;
extern PFNGLREADPIXELSPROC                                     gleswReadPixels;
extern PFNGLREADNPIXELSEXTPROC                                 gleswReadnPixelsEXT;
extern PFNGLREADNPIXELSKHRPROC                                 gleswReadnPixelsKHR;
extern PFNGLRELEASESHADERCOMPILERPROC                          gleswReleaseShaderCompiler;
extern PFNGLRENDERBUFFERSTORAGEPROC                            gleswRenderbufferStorage;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC                 gleswRenderbufferStorageMultisample;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEANGLEPROC            gleswRenderbufferStorageMultisampleANGLE;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEAPPLEPROC            gleswRenderbufferStorageMultisampleAPPLE;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC              gleswRenderbufferStorageMultisampleEXT;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLEIMGPROC              gleswRenderbufferStorageMultisampleIMG;
extern PFNGLRENDERBUFFERSTORAGEMULTISAMPLENVPROC               gleswRenderbufferStorageMultisampleNV;
extern PFNGLRESOLVEDEPTHVALUESNVPROC                           gleswResolveDepthValuesNV;
extern PFNGLRESOLVEMULTISAMPLEFRAMEBUFFERAPPLEPROC             gleswResolveMultisampleFramebufferAPPLE;
extern PFNGLRESUMETRANSFORMFEEDBACKPROC                        gleswResumeTransformFeedback;
extern PFNGLSAMPLECOVERAGEPROC                                 gleswSampleCoverage;
extern PFNGLSAMPLERPARAMETERIIVEXTPROC                         gleswSamplerParameterIivEXT;
extern PFNGLSAMPLERPARAMETERIIVOESPROC                         gleswSamplerParameterIivOES;
extern PFNGLSAMPLERPARAMETERIUIVEXTPROC                        gleswSamplerParameterIuivEXT;
extern PFNGLSAMPLERPARAMETERIUIVOESPROC                        gleswSamplerParameterIuivOES;
extern PFNGLSAMPLERPARAMETERFPROC                              gleswSamplerParameterf;
extern PFNGLSAMPLERPARAMETERFVPROC                             gleswSamplerParameterfv;
extern PFNGLSAMPLERPARAMETERIPROC                              gleswSamplerParameteri;
extern PFNGLSAMPLERPARAMETERIVPROC                             gleswSamplerParameteriv;
extern PFNGLSCISSORPROC                                        gleswScissor;
extern PFNGLSCISSORARRAYVNVPROC                                gleswScissorArrayvNV;
extern PFNGLSCISSORINDEXEDNVPROC                               gleswScissorIndexedNV;
extern PFNGLSCISSORINDEXEDVNVPROC                              gleswScissorIndexedvNV;
extern PFNGLSELECTPERFMONITORCOUNTERSAMDPROC                   gleswSelectPerfMonitorCountersAMD;
extern PFNGLSETFENCENVPROC                                     gleswSetFenceNV;
extern PFNGLSHADERBINARYPROC                                   gleswShaderBinary;
extern PFNGLSHADERSOURCEPROC                                   gleswShaderSource;
extern PFNGLSTARTTILINGQCOMPROC                                gleswStartTilingQCOM;
extern PFNGLSTENCILFILLPATHINSTANCEDNVPROC                     gleswStencilFillPathInstancedNV;
extern PFNGLSTENCILFILLPATHNVPROC                              gleswStencilFillPathNV;
extern PFNGLSTENCILFUNCPROC                                    gleswStencilFunc;
extern PFNGLSTENCILFUNCSEPARATEPROC                            gleswStencilFuncSeparate;
extern PFNGLSTENCILMASKPROC                                    gleswStencilMask;
extern PFNGLSTENCILMASKSEPARATEPROC                            gleswStencilMaskSeparate;
extern PFNGLSTENCILOPPROC                                      gleswStencilOp;
extern PFNGLSTENCILOPSEPARATEPROC                              gleswStencilOpSeparate;
extern PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC                   gleswStencilStrokePathInstancedNV;
extern PFNGLSTENCILSTROKEPATHNVPROC                            gleswStencilStrokePathNV;
extern PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC            gleswStencilThenCoverFillPathInstancedNV;
extern PFNGLSTENCILTHENCOVERFILLPATHNVPROC                     gleswStencilThenCoverFillPathNV;
extern PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC          gleswStencilThenCoverStrokePathInstancedNV;
extern PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC                   gleswStencilThenCoverStrokePathNV;
extern PFNGLSUBPIXELPRECISIONBIASNVPROC                        gleswSubpixelPrecisionBiasNV;
extern PFNGLTESTFENCENVPROC                                    gleswTestFenceNV;
extern PFNGLTEXBUFFEREXTPROC                                   gleswTexBufferEXT;
extern PFNGLTEXBUFFEROESPROC                                   gleswTexBufferOES;
extern PFNGLTEXBUFFERRANGEEXTPROC                              gleswTexBufferRangeEXT;
extern PFNGLTEXBUFFERRANGEOESPROC                              gleswTexBufferRangeOES;
extern PFNGLTEXIMAGE2DPROC                                     gleswTexImage2D;
extern PFNGLTEXIMAGE3DPROC                                     gleswTexImage3D;
extern PFNGLTEXIMAGE3DOESPROC                                  gleswTexImage3DOES;
extern PFNGLTEXPAGECOMMITMENTEXTPROC                           gleswTexPageCommitmentEXT;
extern PFNGLTEXPARAMETERIIVEXTPROC                             gleswTexParameterIivEXT;
extern PFNGLTEXPARAMETERIIVOESPROC                             gleswTexParameterIivOES;
extern PFNGLTEXPARAMETERIUIVEXTPROC                            gleswTexParameterIuivEXT;
extern PFNGLTEXPARAMETERIUIVOESPROC                            gleswTexParameterIuivOES;
extern PFNGLTEXPARAMETERFPROC                                  gleswTexParameterf;
extern PFNGLTEXPARAMETERFVPROC                                 gleswTexParameterfv;
extern PFNGLTEXPARAMETERIPROC                                  gleswTexParameteri;
extern PFNGLTEXPARAMETERIVPROC                                 gleswTexParameteriv;
extern PFNGLTEXSTORAGE1DEXTPROC                                gleswTexStorage1DEXT;
extern PFNGLTEXSTORAGE2DPROC                                   gleswTexStorage2D;
extern PFNGLTEXSTORAGE2DEXTPROC                                gleswTexStorage2DEXT;
extern PFNGLTEXSTORAGE3DPROC                                   gleswTexStorage3D;
extern PFNGLTEXSTORAGE3DEXTPROC                                gleswTexStorage3DEXT;
extern PFNGLTEXSTORAGE3DMULTISAMPLEOESPROC                     gleswTexStorage3DMultisampleOES;
extern PFNGLTEXSUBIMAGE2DPROC                                  gleswTexSubImage2D;
extern PFNGLTEXSUBIMAGE3DPROC                                  gleswTexSubImage3D;
extern PFNGLTEXSUBIMAGE3DOESPROC                               gleswTexSubImage3DOES;
extern PFNGLTEXTURESTORAGE1DEXTPROC                            gleswTextureStorage1DEXT;
extern PFNGLTEXTURESTORAGE2DEXTPROC                            gleswTextureStorage2DEXT;
extern PFNGLTEXTURESTORAGE3DEXTPROC                            gleswTextureStorage3DEXT;
extern PFNGLTEXTUREVIEWEXTPROC                                 gleswTextureViewEXT;
extern PFNGLTEXTUREVIEWOESPROC                                 gleswTextureViewOES;
extern PFNGLTRANSFORMFEEDBACKVARYINGSPROC                      gleswTransformFeedbackVaryings;
extern PFNGLTRANSFORMPATHNVPROC                                gleswTransformPathNV;
extern PFNGLUNIFORM1FPROC                                      gleswUniform1f;
extern PFNGLUNIFORM1FVPROC                                     gleswUniform1fv;
extern PFNGLUNIFORM1IPROC                                      gleswUniform1i;
extern PFNGLUNIFORM1IVPROC                                     gleswUniform1iv;
extern PFNGLUNIFORM1UIPROC                                     gleswUniform1ui;
extern PFNGLUNIFORM1UIVPROC                                    gleswUniform1uiv;
extern PFNGLUNIFORM2FPROC                                      gleswUniform2f;
extern PFNGLUNIFORM2FVPROC                                     gleswUniform2fv;
extern PFNGLUNIFORM2IPROC                                      gleswUniform2i;
extern PFNGLUNIFORM2IVPROC                                     gleswUniform2iv;
extern PFNGLUNIFORM2UIPROC                                     gleswUniform2ui;
extern PFNGLUNIFORM2UIVPROC                                    gleswUniform2uiv;
extern PFNGLUNIFORM3FPROC                                      gleswUniform3f;
extern PFNGLUNIFORM3FVPROC                                     gleswUniform3fv;
extern PFNGLUNIFORM3IPROC                                      gleswUniform3i;
extern PFNGLUNIFORM3IVPROC                                     gleswUniform3iv;
extern PFNGLUNIFORM3UIPROC                                     gleswUniform3ui;
extern PFNGLUNIFORM3UIVPROC                                    gleswUniform3uiv;
extern PFNGLUNIFORM4FPROC                                      gleswUniform4f;
extern PFNGLUNIFORM4FVPROC                                     gleswUniform4fv;
extern PFNGLUNIFORM4IPROC                                      gleswUniform4i;
extern PFNGLUNIFORM4IVPROC                                     gleswUniform4iv;
extern PFNGLUNIFORM4UIPROC                                     gleswUniform4ui;
extern PFNGLUNIFORM4UIVPROC                                    gleswUniform4uiv;
extern PFNGLUNIFORMBLOCKBINDINGPROC                            gleswUniformBlockBinding;
extern PFNGLUNIFORMHANDLEUI64NVPROC                            gleswUniformHandleui64NV;
extern PFNGLUNIFORMHANDLEUI64VNVPROC                           gleswUniformHandleui64vNV;
extern PFNGLUNIFORMMATRIX2FVPROC                               gleswUniformMatrix2fv;
extern PFNGLUNIFORMMATRIX2X3FVPROC                             gleswUniformMatrix2x3fv;
extern PFNGLUNIFORMMATRIX2X3FVNVPROC                           gleswUniformMatrix2x3fvNV;
extern PFNGLUNIFORMMATRIX2X4FVPROC                             gleswUniformMatrix2x4fv;
extern PFNGLUNIFORMMATRIX2X4FVNVPROC                           gleswUniformMatrix2x4fvNV;
extern PFNGLUNIFORMMATRIX3FVPROC                               gleswUniformMatrix3fv;
extern PFNGLUNIFORMMATRIX3X2FVPROC                             gleswUniformMatrix3x2fv;
extern PFNGLUNIFORMMATRIX3X2FVNVPROC                           gleswUniformMatrix3x2fvNV;
extern PFNGLUNIFORMMATRIX3X4FVPROC                             gleswUniformMatrix3x4fv;
extern PFNGLUNIFORMMATRIX3X4FVNVPROC                           gleswUniformMatrix3x4fvNV;
extern PFNGLUNIFORMMATRIX4FVPROC                               gleswUniformMatrix4fv;
extern PFNGLUNIFORMMATRIX4X2FVPROC                             gleswUniformMatrix4x2fv;
extern PFNGLUNIFORMMATRIX4X2FVNVPROC                           gleswUniformMatrix4x2fvNV;
extern PFNGLUNIFORMMATRIX4X3FVPROC                             gleswUniformMatrix4x3fv;
extern PFNGLUNIFORMMATRIX4X3FVNVPROC                           gleswUniformMatrix4x3fvNV;
extern PFNGLUNMAPBUFFERPROC                                    gleswUnmapBuffer;
extern PFNGLUNMAPBUFFEROESPROC                                 gleswUnmapBufferOES;
extern PFNGLUSEPROGRAMPROC                                     gleswUseProgram;
extern PFNGLUSEPROGRAMSTAGESEXTPROC                            gleswUseProgramStagesEXT;
extern PFNGLVALIDATEPROGRAMPROC                                gleswValidateProgram;
extern PFNGLVALIDATEPROGRAMPIPELINEEXTPROC                     gleswValidateProgramPipelineEXT;
extern PFNGLVERTEXATTRIB1FPROC                                 gleswVertexAttrib1f;
extern PFNGLVERTEXATTRIB1FVPROC                                gleswVertexAttrib1fv;
extern PFNGLVERTEXATTRIB2FPROC                                 gleswVertexAttrib2f;
extern PFNGLVERTEXATTRIB2FVPROC                                gleswVertexAttrib2fv;
extern PFNGLVERTEXATTRIB3FPROC                                 gleswVertexAttrib3f;
extern PFNGLVERTEXATTRIB3FVPROC                                gleswVertexAttrib3fv;
extern PFNGLVERTEXATTRIB4FPROC                                 gleswVertexAttrib4f;
extern PFNGLVERTEXATTRIB4FVPROC                                gleswVertexAttrib4fv;
extern PFNGLVERTEXATTRIBDIVISORPROC                            gleswVertexAttribDivisor;
extern PFNGLVERTEXATTRIBDIVISORANGLEPROC                       gleswVertexAttribDivisorANGLE;
extern PFNGLVERTEXATTRIBDIVISOREXTPROC                         gleswVertexAttribDivisorEXT;
extern PFNGLVERTEXATTRIBDIVISORNVPROC                          gleswVertexAttribDivisorNV;
extern PFNGLVERTEXATTRIBI4IPROC                                gleswVertexAttribI4i;
extern PFNGLVERTEXATTRIBI4IVPROC                               gleswVertexAttribI4iv;
extern PFNGLVERTEXATTRIBI4UIPROC                               gleswVertexAttribI4ui;
extern PFNGLVERTEXATTRIBI4UIVPROC                              gleswVertexAttribI4uiv;
extern PFNGLVERTEXATTRIBIPOINTERPROC                           gleswVertexAttribIPointer;
extern PFNGLVERTEXATTRIBPOINTERPROC                            gleswVertexAttribPointer;
extern PFNGLVIEWPORTPROC                                       gleswViewport;
extern PFNGLVIEWPORTARRAYVNVPROC                               gleswViewportArrayvNV;
extern PFNGLVIEWPORTINDEXEDFNVPROC                             gleswViewportIndexedfNV;
extern PFNGLVIEWPORTINDEXEDFVNVPROC                            gleswViewportIndexedfvNV;
extern PFNGLWAITSYNCPROC                                       gleswWaitSync;
extern PFNGLWAITSYNCAPPLEPROC                                  gleswWaitSyncAPPLE;
extern PFNGLWEIGHTPATHSNVPROC                                  gleswWeightPathsNV;
#define glActiveShaderProgramEXT                               gleswActiveShaderProgramEXT
#define glActiveTexture                                        gleswActiveTexture
#define glAlphaFuncQCOM                                        gleswAlphaFuncQCOM
#define glApplyFramebufferAttachmentCMAAINTEL                  gleswApplyFramebufferAttachmentCMAAINTEL
#define glAttachShader                                         gleswAttachShader
#define glBeginConditionalRenderNV                             gleswBeginConditionalRenderNV
#define glBeginPerfMonitorAMD                                  gleswBeginPerfMonitorAMD
#define glBeginPerfQueryINTEL                                  gleswBeginPerfQueryINTEL
#define glBeginQuery                                           gleswBeginQuery
#define glBeginQueryEXT                                        gleswBeginQueryEXT
#define glBeginTransformFeedback                               gleswBeginTransformFeedback
#define glBindAttribLocation                                   gleswBindAttribLocation
#define glBindBuffer                                           gleswBindBuffer
#define glBindBufferBase                                       gleswBindBufferBase
#define glBindBufferRange                                      gleswBindBufferRange
#define glBindFragDataLocationEXT                              gleswBindFragDataLocationEXT
#define glBindFragDataLocationIndexedEXT                       gleswBindFragDataLocationIndexedEXT
#define glBindFramebuffer                                      gleswBindFramebuffer
#define glBindProgramPipelineEXT                               gleswBindProgramPipelineEXT
#define glBindRenderbuffer                                     gleswBindRenderbuffer
#define glBindSampler                                          gleswBindSampler
#define glBindTexture                                          gleswBindTexture
#define glBindTransformFeedback                                gleswBindTransformFeedback
#define glBindVertexArray                                      gleswBindVertexArray
#define glBindVertexArrayOES                                   gleswBindVertexArrayOES
#define glBlendBarrierKHR                                      gleswBlendBarrierKHR
#define glBlendBarrierNV                                       gleswBlendBarrierNV
#define glBlendColor                                           gleswBlendColor
#define glBlendEquation                                        gleswBlendEquation
#define glBlendEquationSeparate                                gleswBlendEquationSeparate
#define glBlendEquationSeparateiEXT                            gleswBlendEquationSeparateiEXT
#define glBlendEquationSeparateiOES                            gleswBlendEquationSeparateiOES
#define glBlendEquationiEXT                                    gleswBlendEquationiEXT
#define glBlendEquationiOES                                    gleswBlendEquationiOES
#define glBlendFunc                                            gleswBlendFunc
#define glBlendFuncSeparate                                    gleswBlendFuncSeparate
#define glBlendFuncSeparateiEXT                                gleswBlendFuncSeparateiEXT
#define glBlendFuncSeparateiOES                                gleswBlendFuncSeparateiOES
#define glBlendFunciEXT                                        gleswBlendFunciEXT
#define glBlendFunciOES                                        gleswBlendFunciOES
#define glBlendParameteriNV                                    gleswBlendParameteriNV
#define glBlitFramebuffer                                      gleswBlitFramebuffer
#define glBlitFramebufferANGLE                                 gleswBlitFramebufferANGLE
#define glBlitFramebufferNV                                    gleswBlitFramebufferNV
#define glBufferData                                           gleswBufferData
#define glBufferStorageEXT                                     gleswBufferStorageEXT
#define glBufferSubData                                        gleswBufferSubData
#define glCheckFramebufferStatus                               gleswCheckFramebufferStatus
#define glClear                                                gleswClear
#define glClearBufferfi                                        gleswClearBufferfi
#define glClearBufferfv                                        gleswClearBufferfv
#define glClearBufferiv                                        gleswClearBufferiv
#define glClearBufferuiv                                       gleswClearBufferuiv
#define glClearColor                                           gleswClearColor
#define glClearDepthf                                          gleswClearDepthf
#define glClearPixelLocalStorageuiEXT                          gleswClearPixelLocalStorageuiEXT
#define glClearStencil                                         gleswClearStencil
#define glClientWaitSync                                       gleswClientWaitSync
#define glClientWaitSyncAPPLE                                  gleswClientWaitSyncAPPLE
#define glColorMask                                            gleswColorMask
#define glColorMaskiEXT                                        gleswColorMaskiEXT
#define glColorMaskiOES                                        gleswColorMaskiOES
#define glCompileShader                                        gleswCompileShader
#define glCompressedTexImage2D                                 gleswCompressedTexImage2D
#define glCompressedTexImage3D                                 gleswCompressedTexImage3D
#define glCompressedTexImage3DOES                              gleswCompressedTexImage3DOES
#define glCompressedTexSubImage2D                              gleswCompressedTexSubImage2D
#define glCompressedTexSubImage3D                              gleswCompressedTexSubImage3D
#define glCompressedTexSubImage3DOES                           gleswCompressedTexSubImage3DOES
#define glCopyBufferSubData                                    gleswCopyBufferSubData
#define glCopyBufferSubDataNV                                  gleswCopyBufferSubDataNV
#define glCopyImageSubDataEXT                                  gleswCopyImageSubDataEXT
#define glCopyImageSubDataOES                                  gleswCopyImageSubDataOES
#define glCopyPathNV                                           gleswCopyPathNV
#define glCopyTexImage2D                                       gleswCopyTexImage2D
#define glCopyTexSubImage2D                                    gleswCopyTexSubImage2D
#define glCopyTexSubImage3D                                    gleswCopyTexSubImage3D
#define glCopyTexSubImage3DOES                                 gleswCopyTexSubImage3DOES
#define glCopyTextureLevelsAPPLE                               gleswCopyTextureLevelsAPPLE
#define glCoverFillPathInstancedNV                             gleswCoverFillPathInstancedNV
#define glCoverFillPathNV                                      gleswCoverFillPathNV
#define glCoverStrokePathInstancedNV                           gleswCoverStrokePathInstancedNV
#define glCoverStrokePathNV                                    gleswCoverStrokePathNV
#define glCoverageMaskNV                                       gleswCoverageMaskNV
#define glCoverageModulationNV                                 gleswCoverageModulationNV
#define glCoverageModulationTableNV                            gleswCoverageModulationTableNV
#define glCoverageOperationNV                                  gleswCoverageOperationNV
#define glCreatePerfQueryINTEL                                 gleswCreatePerfQueryINTEL
#define glCreateProgram                                        gleswCreateProgram
#define glCreateShader                                         gleswCreateShader
#define glCreateShaderProgramvEXT                              gleswCreateShaderProgramvEXT
#define glCullFace                                             gleswCullFace
#define glDebugMessageCallbackKHR                              gleswDebugMessageCallbackKHR
#define glDebugMessageControlKHR                               gleswDebugMessageControlKHR
#define glDebugMessageInsertKHR                                gleswDebugMessageInsertKHR
#define glDeleteBuffers                                        gleswDeleteBuffers
#define glDeleteFencesNV                                       gleswDeleteFencesNV
#define glDeleteFramebuffers                                   gleswDeleteFramebuffers
#define glDeletePathsNV                                        gleswDeletePathsNV
#define glDeletePerfMonitorsAMD                                gleswDeletePerfMonitorsAMD
#define glDeletePerfQueryINTEL                                 gleswDeletePerfQueryINTEL
#define glDeleteProgram                                        gleswDeleteProgram
#define glDeleteProgramPipelinesEXT                            gleswDeleteProgramPipelinesEXT
#define glDeleteQueries                                        gleswDeleteQueries
#define glDeleteQueriesEXT                                     gleswDeleteQueriesEXT
#define glDeleteRenderbuffers                                  gleswDeleteRenderbuffers
#define glDeleteSamplers                                       gleswDeleteSamplers
#define glDeleteShader                                         gleswDeleteShader
#define glDeleteSync                                           gleswDeleteSync
#define glDeleteSyncAPPLE                                      gleswDeleteSyncAPPLE
#define glDeleteTextures                                       gleswDeleteTextures
#define glDeleteTransformFeedbacks                             gleswDeleteTransformFeedbacks
#define glDeleteVertexArrays                                   gleswDeleteVertexArrays
#define glDeleteVertexArraysOES                                gleswDeleteVertexArraysOES
#define glDepthFunc                                            gleswDepthFunc
#define glDepthMask                                            gleswDepthMask
#define glDepthRangeArrayfvNV                                  gleswDepthRangeArrayfvNV
#define glDepthRangeIndexedfNV                                 gleswDepthRangeIndexedfNV
#define glDepthRangef                                          gleswDepthRangef
#define glDetachShader                                         gleswDetachShader
#define glDisable                                              gleswDisable
#define glDisableDriverControlQCOM                             gleswDisableDriverControlQCOM
#define glDisableVertexAttribArray                             gleswDisableVertexAttribArray
#define glDisableiEXT                                          gleswDisableiEXT
#define glDisableiNV                                           gleswDisableiNV
#define glDisableiOES                                          gleswDisableiOES
#define glDiscardFramebufferEXT                                gleswDiscardFramebufferEXT
#define glDrawArrays                                           gleswDrawArrays
#define glDrawArraysInstanced                                  gleswDrawArraysInstanced
#define glDrawArraysInstancedANGLE                             gleswDrawArraysInstancedANGLE
#define glDrawArraysInstancedBaseInstanceEXT                   gleswDrawArraysInstancedBaseInstanceEXT
#define glDrawArraysInstancedEXT                               gleswDrawArraysInstancedEXT
#define glDrawArraysInstancedNV                                gleswDrawArraysInstancedNV
#define glDrawBuffers                                          gleswDrawBuffers
#define glDrawBuffersEXT                                       gleswDrawBuffersEXT
#define glDrawBuffersIndexedEXT                                gleswDrawBuffersIndexedEXT
#define glDrawBuffersNV                                        gleswDrawBuffersNV
#define glDrawElements                                         gleswDrawElements
#define glDrawElementsBaseVertexEXT                            gleswDrawElementsBaseVertexEXT
#define glDrawElementsBaseVertexOES                            gleswDrawElementsBaseVertexOES
#define glDrawElementsInstanced                                gleswDrawElementsInstanced
#define glDrawElementsInstancedANGLE                           gleswDrawElementsInstancedANGLE
#define glDrawElementsInstancedBaseInstanceEXT                 gleswDrawElementsInstancedBaseInstanceEXT
#define glDrawElementsInstancedBaseVertexBaseInstanceEXT       gleswDrawElementsInstancedBaseVertexBaseInstanceEXT
#define glDrawElementsInstancedBaseVertexEXT                   gleswDrawElementsInstancedBaseVertexEXT
#define glDrawElementsInstancedBaseVertexOES                   gleswDrawElementsInstancedBaseVertexOES
#define glDrawElementsInstancedEXT                             gleswDrawElementsInstancedEXT
#define glDrawElementsInstancedNV                              gleswDrawElementsInstancedNV
#define glDrawRangeElements                                    gleswDrawRangeElements
#define glDrawRangeElementsBaseVertexEXT                       gleswDrawRangeElementsBaseVertexEXT
#define glDrawRangeElementsBaseVertexOES                       gleswDrawRangeElementsBaseVertexOES
#define glEGLImageTargetRenderbufferStorageOES                 gleswEGLImageTargetRenderbufferStorageOES
#define glEGLImageTargetTexture2DOES                           gleswEGLImageTargetTexture2DOES
#define glEnable                                               gleswEnable
#define glEnableDriverControlQCOM                              gleswEnableDriverControlQCOM
#define glEnableVertexAttribArray                              gleswEnableVertexAttribArray
#define glEnableiEXT                                           gleswEnableiEXT
#define glEnableiNV                                            gleswEnableiNV
#define glEnableiOES                                           gleswEnableiOES
#define glEndConditionalRenderNV                               gleswEndConditionalRenderNV
#define glEndPerfMonitorAMD                                    gleswEndPerfMonitorAMD
#define glEndPerfQueryINTEL                                    gleswEndPerfQueryINTEL
#define glEndQuery                                             gleswEndQuery
#define glEndQueryEXT                                          gleswEndQueryEXT
#define glEndTilingQCOM                                        gleswEndTilingQCOM
#define glEndTransformFeedback                                 gleswEndTransformFeedback
#define glExtGetBufferPointervQCOM                             gleswExtGetBufferPointervQCOM
#define glExtGetBuffersQCOM                                    gleswExtGetBuffersQCOM
#define glExtGetFramebuffersQCOM                               gleswExtGetFramebuffersQCOM
#define glExtGetProgramBinarySourceQCOM                        gleswExtGetProgramBinarySourceQCOM
#define glExtGetProgramsQCOM                                   gleswExtGetProgramsQCOM
#define glExtGetRenderbuffersQCOM                              gleswExtGetRenderbuffersQCOM
#define glExtGetShadersQCOM                                    gleswExtGetShadersQCOM
#define glExtGetTexLevelParameterivQCOM                        gleswExtGetTexLevelParameterivQCOM
#define glExtGetTexSubImageQCOM                                gleswExtGetTexSubImageQCOM
#define glExtGetTexturesQCOM                                   gleswExtGetTexturesQCOM
#define glExtIsProgramBinaryQCOM                               gleswExtIsProgramBinaryQCOM
#define glExtTexObjectStateOverrideiQCOM                       gleswExtTexObjectStateOverrideiQCOM
#define glFenceSync                                            gleswFenceSync
#define glFenceSyncAPPLE                                       gleswFenceSyncAPPLE
#define glFinish                                               gleswFinish
#define glFinishFenceNV                                        gleswFinishFenceNV
#define glFlush                                                gleswFlush
#define glFlushMappedBufferRange                               gleswFlushMappedBufferRange
#define glFlushMappedBufferRangeEXT                            gleswFlushMappedBufferRangeEXT
#define glFragmentCoverageColorNV                              gleswFragmentCoverageColorNV
#define glFramebufferPixelLocalStorageSizeEXT                  gleswFramebufferPixelLocalStorageSizeEXT
#define glFramebufferRenderbuffer                              gleswFramebufferRenderbuffer
#define glFramebufferSampleLocationsfvNV                       gleswFramebufferSampleLocationsfvNV
#define glFramebufferTexture2D                                 gleswFramebufferTexture2D
#define glFramebufferTexture2DDownsampleIMG                    gleswFramebufferTexture2DDownsampleIMG
#define glFramebufferTexture2DMultisampleEXT                   gleswFramebufferTexture2DMultisampleEXT
#define glFramebufferTexture2DMultisampleIMG                   gleswFramebufferTexture2DMultisampleIMG
#define glFramebufferTexture3DOES                              gleswFramebufferTexture3DOES
#define glFramebufferTextureEXT                                gleswFramebufferTextureEXT
#define glFramebufferTextureLayer                              gleswFramebufferTextureLayer
#define glFramebufferTextureLayerDownsampleIMG                 gleswFramebufferTextureLayerDownsampleIMG
#define glFramebufferTextureMultisampleMultiviewOVR            gleswFramebufferTextureMultisampleMultiviewOVR
#define glFramebufferTextureMultiviewOVR                       gleswFramebufferTextureMultiviewOVR
#define glFramebufferTextureOES                                gleswFramebufferTextureOES
#define glFrontFace                                            gleswFrontFace
#define glGenBuffers                                           gleswGenBuffers
#define glGenFencesNV                                          gleswGenFencesNV
#define glGenFramebuffers                                      gleswGenFramebuffers
#define glGenPathsNV                                           gleswGenPathsNV
#define glGenPerfMonitorsAMD                                   gleswGenPerfMonitorsAMD
#define glGenProgramPipelinesEXT                               gleswGenProgramPipelinesEXT
#define glGenQueries                                           gleswGenQueries
#define glGenQueriesEXT                                        gleswGenQueriesEXT
#define glGenRenderbuffers                                     gleswGenRenderbuffers
#define glGenSamplers                                          gleswGenSamplers
#define glGenTextures                                          gleswGenTextures
#define glGenTransformFeedbacks                                gleswGenTransformFeedbacks
#define glGenVertexArrays                                      gleswGenVertexArrays
#define glGenVertexArraysOES                                   gleswGenVertexArraysOES
#define glGenerateMipmap                                       gleswGenerateMipmap
#define glGetActiveAttrib                                      gleswGetActiveAttrib
#define glGetActiveUniform                                     gleswGetActiveUniform
#define glGetActiveUniformBlockName                            gleswGetActiveUniformBlockName
#define glGetActiveUniformBlockiv                              gleswGetActiveUniformBlockiv
#define glGetActiveUniformsiv                                  gleswGetActiveUniformsiv
#define glGetAttachedShaders                                   gleswGetAttachedShaders
#define glGetAttribLocation                                    gleswGetAttribLocation
#define glGetBooleanv                                          gleswGetBooleanv
#define glGetBufferParameteri64v                               gleswGetBufferParameteri64v
#define glGetBufferParameteriv                                 gleswGetBufferParameteriv
#define glGetBufferPointerv                                    gleswGetBufferPointerv
#define glGetBufferPointervOES                                 gleswGetBufferPointervOES
#define glGetCoverageModulationTableNV                         gleswGetCoverageModulationTableNV
#define glGetDebugMessageLogKHR                                gleswGetDebugMessageLogKHR
#define glGetDriverControlStringQCOM                           gleswGetDriverControlStringQCOM
#define glGetDriverControlsQCOM                                gleswGetDriverControlsQCOM
#define glGetError                                             gleswGetError
#define glGetFenceivNV                                         gleswGetFenceivNV
#define glGetFirstPerfQueryIdINTEL                             gleswGetFirstPerfQueryIdINTEL
#define glGetFloati_vNV                                        gleswGetFloati_vNV
#define glGetFloatv                                            gleswGetFloatv
#define glGetFragDataIndexEXT                                  gleswGetFragDataIndexEXT
#define glGetFragDataLocation                                  gleswGetFragDataLocation
#define glGetFramebufferAttachmentParameteriv                  gleswGetFramebufferAttachmentParameteriv
#define glGetFramebufferPixelLocalStorageSizeEXT               gleswGetFramebufferPixelLocalStorageSizeEXT
#define glGetGraphicsResetStatusEXT                            gleswGetGraphicsResetStatusEXT
#define glGetGraphicsResetStatusKHR                            gleswGetGraphicsResetStatusKHR
#define glGetImageHandleNV                                     gleswGetImageHandleNV
#define glGetInteger64i_v                                      gleswGetInteger64i_v
#define glGetInteger64v                                        gleswGetInteger64v
#define glGetInteger64vAPPLE                                   gleswGetInteger64vAPPLE
#define glGetIntegeri_v                                        gleswGetIntegeri_v
#define glGetIntegeri_vEXT                                     gleswGetIntegeri_vEXT
#define glGetIntegerv                                          gleswGetIntegerv
#define glGetInternalformatSampleivNV                          gleswGetInternalformatSampleivNV
#define glGetInternalformativ                                  gleswGetInternalformativ
#define glGetNextPerfQueryIdINTEL                              gleswGetNextPerfQueryIdINTEL
#define glGetObjectLabelEXT                                    gleswGetObjectLabelEXT
#define glGetObjectLabelKHR                                    gleswGetObjectLabelKHR
#define glGetObjectPtrLabelKHR                                 gleswGetObjectPtrLabelKHR
#define glGetPathCommandsNV                                    gleswGetPathCommandsNV
#define glGetPathCoordsNV                                      gleswGetPathCoordsNV
#define glGetPathDashArrayNV                                   gleswGetPathDashArrayNV
#define glGetPathLengthNV                                      gleswGetPathLengthNV
#define glGetPathMetricRangeNV                                 gleswGetPathMetricRangeNV
#define glGetPathMetricsNV                                     gleswGetPathMetricsNV
#define glGetPathParameterfvNV                                 gleswGetPathParameterfvNV
#define glGetPathParameterivNV                                 gleswGetPathParameterivNV
#define glGetPathSpacingNV                                     gleswGetPathSpacingNV
#define glGetPerfCounterInfoINTEL                              gleswGetPerfCounterInfoINTEL
#define glGetPerfMonitorCounterDataAMD                         gleswGetPerfMonitorCounterDataAMD
#define glGetPerfMonitorCounterInfoAMD                         gleswGetPerfMonitorCounterInfoAMD
#define glGetPerfMonitorCounterStringAMD                       gleswGetPerfMonitorCounterStringAMD
#define glGetPerfMonitorCountersAMD                            gleswGetPerfMonitorCountersAMD
#define glGetPerfMonitorGroupStringAMD                         gleswGetPerfMonitorGroupStringAMD
#define glGetPerfMonitorGroupsAMD                              gleswGetPerfMonitorGroupsAMD
#define glGetPerfQueryDataINTEL                                gleswGetPerfQueryDataINTEL
#define glGetPerfQueryIdByNameINTEL                            gleswGetPerfQueryIdByNameINTEL
#define glGetPerfQueryInfoINTEL                                gleswGetPerfQueryInfoINTEL
#define glGetPointervKHR                                       gleswGetPointervKHR
#define glGetProgramBinary                                     gleswGetProgramBinary
#define glGetProgramBinaryOES                                  gleswGetProgramBinaryOES
#define glGetProgramInfoLog                                    gleswGetProgramInfoLog
#define glGetProgramPipelineInfoLogEXT                         gleswGetProgramPipelineInfoLogEXT
#define glGetProgramPipelineivEXT                              gleswGetProgramPipelineivEXT
#define glGetProgramResourceLocationIndexEXT                   gleswGetProgramResourceLocationIndexEXT
#define glGetProgramResourcefvNV                               gleswGetProgramResourcefvNV
#define glGetProgramiv                                         gleswGetProgramiv
#define glGetQueryObjecti64vEXT                                gleswGetQueryObjecti64vEXT
#define glGetQueryObjectivEXT                                  gleswGetQueryObjectivEXT
#define glGetQueryObjectui64vEXT                               gleswGetQueryObjectui64vEXT
#define glGetQueryObjectuiv                                    gleswGetQueryObjectuiv
#define glGetQueryObjectuivEXT                                 gleswGetQueryObjectuivEXT
#define glGetQueryiv                                           gleswGetQueryiv
#define glGetQueryivEXT                                        gleswGetQueryivEXT
#define glGetRenderbufferParameteriv                           gleswGetRenderbufferParameteriv
#define glGetSamplerParameterIivEXT                            gleswGetSamplerParameterIivEXT
#define glGetSamplerParameterIivOES                            gleswGetSamplerParameterIivOES
#define glGetSamplerParameterIuivEXT                           gleswGetSamplerParameterIuivEXT
#define glGetSamplerParameterIuivOES                           gleswGetSamplerParameterIuivOES
#define glGetSamplerParameterfv                                gleswGetSamplerParameterfv
#define glGetSamplerParameteriv                                gleswGetSamplerParameteriv
#define glGetShaderInfoLog                                     gleswGetShaderInfoLog
#define glGetShaderPrecisionFormat                             gleswGetShaderPrecisionFormat
#define glGetShaderSource                                      gleswGetShaderSource
#define glGetShaderiv                                          gleswGetShaderiv
#define glGetString                                            gleswGetString
#define glGetStringi                                           gleswGetStringi
#define glGetSynciv                                            gleswGetSynciv
#define glGetSyncivAPPLE                                       gleswGetSyncivAPPLE
#define glGetTexParameterIivEXT                                gleswGetTexParameterIivEXT
#define glGetTexParameterIivOES                                gleswGetTexParameterIivOES
#define glGetTexParameterIuivEXT                               gleswGetTexParameterIuivEXT
#define glGetTexParameterIuivOES                               gleswGetTexParameterIuivOES
#define glGetTexParameterfv                                    gleswGetTexParameterfv
#define glGetTexParameteriv                                    gleswGetTexParameteriv
#define glGetTextureHandleNV                                   gleswGetTextureHandleNV
#define glGetTextureSamplerHandleNV                            gleswGetTextureSamplerHandleNV
#define glGetTransformFeedbackVarying                          gleswGetTransformFeedbackVarying
#define glGetTranslatedShaderSourceANGLE                       gleswGetTranslatedShaderSourceANGLE
#define glGetUniformBlockIndex                                 gleswGetUniformBlockIndex
#define glGetUniformIndices                                    gleswGetUniformIndices
#define glGetUniformLocation                                   gleswGetUniformLocation
#define glGetUniformfv                                         gleswGetUniformfv
#define glGetUniformiv                                         gleswGetUniformiv
#define glGetUniformuiv                                        gleswGetUniformuiv
#define glGetVertexAttribIiv                                   gleswGetVertexAttribIiv
#define glGetVertexAttribIuiv                                  gleswGetVertexAttribIuiv
#define glGetVertexAttribPointerv                              gleswGetVertexAttribPointerv
#define glGetVertexAttribfv                                    gleswGetVertexAttribfv
#define glGetVertexAttribiv                                    gleswGetVertexAttribiv
#define glGetnUniformfvEXT                                     gleswGetnUniformfvEXT
#define glGetnUniformfvKHR                                     gleswGetnUniformfvKHR
#define glGetnUniformivEXT                                     gleswGetnUniformivEXT
#define glGetnUniformivKHR                                     gleswGetnUniformivKHR
#define glGetnUniformuivKHR                                    gleswGetnUniformuivKHR
#define glHint                                                 gleswHint
#define glInsertEventMarkerEXT                                 gleswInsertEventMarkerEXT
#define glInterpolatePathsNV                                   gleswInterpolatePathsNV
#define glInvalidateFramebuffer                                gleswInvalidateFramebuffer
#define glInvalidateSubFramebuffer                             gleswInvalidateSubFramebuffer
#define glIsBuffer                                             gleswIsBuffer
#define glIsEnabled                                            gleswIsEnabled
#define glIsEnablediEXT                                        gleswIsEnablediEXT
#define glIsEnablediNV                                         gleswIsEnablediNV
#define glIsEnablediOES                                        gleswIsEnablediOES
#define glIsFenceNV                                            gleswIsFenceNV
#define glIsFramebuffer                                        gleswIsFramebuffer
#define glIsImageHandleResidentNV                              gleswIsImageHandleResidentNV
#define glIsPathNV                                             gleswIsPathNV
#define glIsPointInFillPathNV                                  gleswIsPointInFillPathNV
#define glIsPointInStrokePathNV                                gleswIsPointInStrokePathNV
#define glIsProgram                                            gleswIsProgram
#define glIsProgramPipelineEXT                                 gleswIsProgramPipelineEXT
#define glIsQuery                                              gleswIsQuery
#define glIsQueryEXT                                           gleswIsQueryEXT
#define glIsRenderbuffer                                       gleswIsRenderbuffer
#define glIsSampler                                            gleswIsSampler
#define glIsShader                                             gleswIsShader
#define glIsSync                                               gleswIsSync
#define glIsSyncAPPLE                                          gleswIsSyncAPPLE
#define glIsTexture                                            gleswIsTexture
#define glIsTextureHandleResidentNV                            gleswIsTextureHandleResidentNV
#define glIsTransformFeedback                                  gleswIsTransformFeedback
#define glIsVertexArray                                        gleswIsVertexArray
#define glIsVertexArrayOES                                     gleswIsVertexArrayOES
#define glLabelObjectEXT                                       gleswLabelObjectEXT
#define glLineWidth                                            gleswLineWidth
#define glLinkProgram                                          gleswLinkProgram
#define glMakeImageHandleNonResidentNV                         gleswMakeImageHandleNonResidentNV
#define glMakeImageHandleResidentNV                            gleswMakeImageHandleResidentNV
#define glMakeTextureHandleNonResidentNV                       gleswMakeTextureHandleNonResidentNV
#define glMakeTextureHandleResidentNV                          gleswMakeTextureHandleResidentNV
#define glMapBufferOES                                         gleswMapBufferOES
#define glMapBufferRange                                       gleswMapBufferRange
#define glMapBufferRangeEXT                                    gleswMapBufferRangeEXT
#define glMatrixLoad3x2fNV                                     gleswMatrixLoad3x2fNV
#define glMatrixLoad3x3fNV                                     gleswMatrixLoad3x3fNV
#define glMatrixLoadTranspose3x3fNV                            gleswMatrixLoadTranspose3x3fNV
#define glMatrixMult3x2fNV                                     gleswMatrixMult3x2fNV
#define glMatrixMult3x3fNV                                     gleswMatrixMult3x3fNV
#define glMatrixMultTranspose3x3fNV                            gleswMatrixMultTranspose3x3fNV
#define glMinSampleShadingOES                                  gleswMinSampleShadingOES
#define glMultiDrawArraysEXT                                   gleswMultiDrawArraysEXT
#define glMultiDrawArraysIndirectEXT                           gleswMultiDrawArraysIndirectEXT
#define glMultiDrawElementsBaseVertexEXT                       gleswMultiDrawElementsBaseVertexEXT
#define glMultiDrawElementsBaseVertexOES                       gleswMultiDrawElementsBaseVertexOES
#define glMultiDrawElementsEXT                                 gleswMultiDrawElementsEXT
#define glMultiDrawElementsIndirectEXT                         gleswMultiDrawElementsIndirectEXT
#define glNamedFramebufferSampleLocationsfvNV                  gleswNamedFramebufferSampleLocationsfvNV
#define glObjectLabelKHR                                       gleswObjectLabelKHR
#define glObjectPtrLabelKHR                                    gleswObjectPtrLabelKHR
#define glPatchParameteriEXT                                   gleswPatchParameteriEXT
#define glPatchParameteriOES                                   gleswPatchParameteriOES
#define glPathCommandsNV                                       gleswPathCommandsNV
#define glPathCoordsNV                                         gleswPathCoordsNV
#define glPathCoverDepthFuncNV                                 gleswPathCoverDepthFuncNV
#define glPathDashArrayNV                                      gleswPathDashArrayNV
#define glPathGlyphIndexArrayNV                                gleswPathGlyphIndexArrayNV
#define glPathGlyphIndexRangeNV                                gleswPathGlyphIndexRangeNV
#define glPathGlyphRangeNV                                     gleswPathGlyphRangeNV
#define glPathGlyphsNV                                         gleswPathGlyphsNV
#define glPathMemoryGlyphIndexArrayNV                          gleswPathMemoryGlyphIndexArrayNV
#define glPathParameterfNV                                     gleswPathParameterfNV
#define glPathParameterfvNV                                    gleswPathParameterfvNV
#define glPathParameteriNV                                     gleswPathParameteriNV
#define glPathParameterivNV                                    gleswPathParameterivNV
#define glPathStencilDepthOffsetNV                             gleswPathStencilDepthOffsetNV
#define glPathStencilFuncNV                                    gleswPathStencilFuncNV
#define glPathStringNV                                         gleswPathStringNV
#define glPathSubCommandsNV                                    gleswPathSubCommandsNV
#define glPathSubCoordsNV                                      gleswPathSubCoordsNV
#define glPauseTransformFeedback                               gleswPauseTransformFeedback
#define glPixelStorei                                          gleswPixelStorei
#define glPointAlongPathNV                                     gleswPointAlongPathNV
#define glPolygonModeNV                                        gleswPolygonModeNV
#define glPolygonOffset                                        gleswPolygonOffset
#define glPolygonOffsetClampEXT                                gleswPolygonOffsetClampEXT
#define glPopDebugGroupKHR                                     gleswPopDebugGroupKHR
#define glPopGroupMarkerEXT                                    gleswPopGroupMarkerEXT
#define glPrimitiveBoundingBoxEXT                              gleswPrimitiveBoundingBoxEXT
#define glPrimitiveBoundingBoxOES                              gleswPrimitiveBoundingBoxOES
#define glProgramBinary                                        gleswProgramBinary
#define glProgramBinaryOES                                     gleswProgramBinaryOES
#define glProgramParameteri                                    gleswProgramParameteri
#define glProgramParameteriEXT                                 gleswProgramParameteriEXT
#define glProgramPathFragmentInputGenNV                        gleswProgramPathFragmentInputGenNV
#define glProgramUniform1fEXT                                  gleswProgramUniform1fEXT
#define glProgramUniform1fvEXT                                 gleswProgramUniform1fvEXT
#define glProgramUniform1iEXT                                  gleswProgramUniform1iEXT
#define glProgramUniform1ivEXT                                 gleswProgramUniform1ivEXT
#define glProgramUniform1uiEXT                                 gleswProgramUniform1uiEXT
#define glProgramUniform1uivEXT                                gleswProgramUniform1uivEXT
#define glProgramUniform2fEXT                                  gleswProgramUniform2fEXT
#define glProgramUniform2fvEXT                                 gleswProgramUniform2fvEXT
#define glProgramUniform2iEXT                                  gleswProgramUniform2iEXT
#define glProgramUniform2ivEXT                                 gleswProgramUniform2ivEXT
#define glProgramUniform2uiEXT                                 gleswProgramUniform2uiEXT
#define glProgramUniform2uivEXT                                gleswProgramUniform2uivEXT
#define glProgramUniform3fEXT                                  gleswProgramUniform3fEXT
#define glProgramUniform3fvEXT                                 gleswProgramUniform3fvEXT
#define glProgramUniform3iEXT                                  gleswProgramUniform3iEXT
#define glProgramUniform3ivEXT                                 gleswProgramUniform3ivEXT
#define glProgramUniform3uiEXT                                 gleswProgramUniform3uiEXT
#define glProgramUniform3uivEXT                                gleswProgramUniform3uivEXT
#define glProgramUniform4fEXT                                  gleswProgramUniform4fEXT
#define glProgramUniform4fvEXT                                 gleswProgramUniform4fvEXT
#define glProgramUniform4iEXT                                  gleswProgramUniform4iEXT
#define glProgramUniform4ivEXT                                 gleswProgramUniform4ivEXT
#define glProgramUniform4uiEXT                                 gleswProgramUniform4uiEXT
#define glProgramUniform4uivEXT                                gleswProgramUniform4uivEXT
#define glProgramUniformHandleui64NV                           gleswProgramUniformHandleui64NV
#define glProgramUniformHandleui64vNV                          gleswProgramUniformHandleui64vNV
#define glProgramUniformMatrix2fvEXT                           gleswProgramUniformMatrix2fvEXT
#define glProgramUniformMatrix2x3fvEXT                         gleswProgramUniformMatrix2x3fvEXT
#define glProgramUniformMatrix2x4fvEXT                         gleswProgramUniformMatrix2x4fvEXT
#define glProgramUniformMatrix3fvEXT                           gleswProgramUniformMatrix3fvEXT
#define glProgramUniformMatrix3x2fvEXT                         gleswProgramUniformMatrix3x2fvEXT
#define glProgramUniformMatrix3x4fvEXT                         gleswProgramUniformMatrix3x4fvEXT
#define glProgramUniformMatrix4fvEXT                           gleswProgramUniformMatrix4fvEXT
#define glProgramUniformMatrix4x2fvEXT                         gleswProgramUniformMatrix4x2fvEXT
#define glProgramUniformMatrix4x3fvEXT                         gleswProgramUniformMatrix4x3fvEXT
#define glPushDebugGroupKHR                                    gleswPushDebugGroupKHR
#define glPushGroupMarkerEXT                                   gleswPushGroupMarkerEXT
#define glQueryCounterEXT                                      gleswQueryCounterEXT
#define glRasterSamplesEXT                                     gleswRasterSamplesEXT
#define glReadBuffer                                           gleswReadBuffer
#define glReadBufferIndexedEXT                                 gleswReadBufferIndexedEXT
#define glReadBufferNV                                         gleswReadBufferNV
#define glReadPixels                                           gleswReadPixels
#define glReadnPixelsEXT                                       gleswReadnPixelsEXT
#define glReadnPixelsKHR                                       gleswReadnPixelsKHR
#define glReleaseShaderCompiler                                gleswReleaseShaderCompiler
#define glRenderbufferStorage                                  gleswRenderbufferStorage
#define glRenderbufferStorageMultisample                       gleswRenderbufferStorageMultisample
#define glRenderbufferStorageMultisampleANGLE                  gleswRenderbufferStorageMultisampleANGLE
#define glRenderbufferStorageMultisampleAPPLE                  gleswRenderbufferStorageMultisampleAPPLE
#define glRenderbufferStorageMultisampleEXT                    gleswRenderbufferStorageMultisampleEXT
#define glRenderbufferStorageMultisampleIMG                    gleswRenderbufferStorageMultisampleIMG
#define glRenderbufferStorageMultisampleNV                     gleswRenderbufferStorageMultisampleNV
#define glResolveDepthValuesNV                                 gleswResolveDepthValuesNV
#define glResolveMultisampleFramebufferAPPLE                   gleswResolveMultisampleFramebufferAPPLE
#define glResumeTransformFeedback                              gleswResumeTransformFeedback
#define glSampleCoverage                                       gleswSampleCoverage
#define glSamplerParameterIivEXT                               gleswSamplerParameterIivEXT
#define glSamplerParameterIivOES                               gleswSamplerParameterIivOES
#define glSamplerParameterIuivEXT                              gleswSamplerParameterIuivEXT
#define glSamplerParameterIuivOES                              gleswSamplerParameterIuivOES
#define glSamplerParameterf                                    gleswSamplerParameterf
#define glSamplerParameterfv                                   gleswSamplerParameterfv
#define glSamplerParameteri                                    gleswSamplerParameteri
#define glSamplerParameteriv                                   gleswSamplerParameteriv
#define glScissor                                              gleswScissor
#define glScissorArrayvNV                                      gleswScissorArrayvNV
#define glScissorIndexedNV                                     gleswScissorIndexedNV
#define glScissorIndexedvNV                                    gleswScissorIndexedvNV
#define glSelectPerfMonitorCountersAMD                         gleswSelectPerfMonitorCountersAMD
#define glSetFenceNV                                           gleswSetFenceNV
#define glShaderBinary                                         gleswShaderBinary
#define glShaderSource                                         gleswShaderSource
#define glStartTilingQCOM                                      gleswStartTilingQCOM
#define glStencilFillPathInstancedNV                           gleswStencilFillPathInstancedNV
#define glStencilFillPathNV                                    gleswStencilFillPathNV
#define glStencilFunc                                          gleswStencilFunc
#define glStencilFuncSeparate                                  gleswStencilFuncSeparate
#define glStencilMask                                          gleswStencilMask
#define glStencilMaskSeparate                                  gleswStencilMaskSeparate
#define glStencilOp                                            gleswStencilOp
#define glStencilOpSeparate                                    gleswStencilOpSeparate
#define glStencilStrokePathInstancedNV                         gleswStencilStrokePathInstancedNV
#define glStencilStrokePathNV                                  gleswStencilStrokePathNV
#define glStencilThenCoverFillPathInstancedNV                  gleswStencilThenCoverFillPathInstancedNV
#define glStencilThenCoverFillPathNV                           gleswStencilThenCoverFillPathNV
#define glStencilThenCoverStrokePathInstancedNV                gleswStencilThenCoverStrokePathInstancedNV
#define glStencilThenCoverStrokePathNV                         gleswStencilThenCoverStrokePathNV
#define glSubpixelPrecisionBiasNV                              gleswSubpixelPrecisionBiasNV
#define glTestFenceNV                                          gleswTestFenceNV
#define glTexBufferEXT                                         gleswTexBufferEXT
#define glTexBufferOES                                         gleswTexBufferOES
#define glTexBufferRangeEXT                                    gleswTexBufferRangeEXT
#define glTexBufferRangeOES                                    gleswTexBufferRangeOES
#define glTexImage2D                                           gleswTexImage2D
#define glTexImage3D                                           gleswTexImage3D
#define glTexImage3DOES                                        gleswTexImage3DOES
#define glTexPageCommitmentEXT                                 gleswTexPageCommitmentEXT
#define glTexParameterIivEXT                                   gleswTexParameterIivEXT
#define glTexParameterIivOES                                   gleswTexParameterIivOES
#define glTexParameterIuivEXT                                  gleswTexParameterIuivEXT
#define glTexParameterIuivOES                                  gleswTexParameterIuivOES
#define glTexParameterf                                        gleswTexParameterf
#define glTexParameterfv                                       gleswTexParameterfv
#define glTexParameteri                                        gleswTexParameteri
#define glTexParameteriv                                       gleswTexParameteriv
#define glTexStorage1DEXT                                      gleswTexStorage1DEXT
#define glTexStorage2D                                         gleswTexStorage2D
#define glTexStorage2DEXT                                      gleswTexStorage2DEXT
#define glTexStorage3D                                         gleswTexStorage3D
#define glTexStorage3DEXT                                      gleswTexStorage3DEXT
#define glTexStorage3DMultisampleOES                           gleswTexStorage3DMultisampleOES
#define glTexSubImage2D                                        gleswTexSubImage2D
#define glTexSubImage3D                                        gleswTexSubImage3D
#define glTexSubImage3DOES                                     gleswTexSubImage3DOES
#define glTextureStorage1DEXT                                  gleswTextureStorage1DEXT
#define glTextureStorage2DEXT                                  gleswTextureStorage2DEXT
#define glTextureStorage3DEXT                                  gleswTextureStorage3DEXT
#define glTextureViewEXT                                       gleswTextureViewEXT
#define glTextureViewOES                                       gleswTextureViewOES
#define glTransformFeedbackVaryings                            gleswTransformFeedbackVaryings
#define glTransformPathNV                                      gleswTransformPathNV
#define glUniform1f                                            gleswUniform1f
#define glUniform1fv                                           gleswUniform1fv
#define glUniform1i                                            gleswUniform1i
#define glUniform1iv                                           gleswUniform1iv
#define glUniform1ui                                           gleswUniform1ui
#define glUniform1uiv                                          gleswUniform1uiv
#define glUniform2f                                            gleswUniform2f
#define glUniform2fv                                           gleswUniform2fv
#define glUniform2i                                            gleswUniform2i
#define glUniform2iv                                           gleswUniform2iv
#define glUniform2ui                                           gleswUniform2ui
#define glUniform2uiv                                          gleswUniform2uiv
#define glUniform3f                                            gleswUniform3f
#define glUniform3fv                                           gleswUniform3fv
#define glUniform3i                                            gleswUniform3i
#define glUniform3iv                                           gleswUniform3iv
#define glUniform3ui                                           gleswUniform3ui
#define glUniform3uiv                                          gleswUniform3uiv
#define glUniform4f                                            gleswUniform4f
#define glUniform4fv                                           gleswUniform4fv
#define glUniform4i                                            gleswUniform4i
#define glUniform4iv                                           gleswUniform4iv
#define glUniform4ui                                           gleswUniform4ui
#define glUniform4uiv                                          gleswUniform4uiv
#define glUniformBlockBinding                                  gleswUniformBlockBinding
#define glUniformHandleui64NV                                  gleswUniformHandleui64NV
#define glUniformHandleui64vNV                                 gleswUniformHandleui64vNV
#define glUniformMatrix2fv                                     gleswUniformMatrix2fv
#define glUniformMatrix2x3fv                                   gleswUniformMatrix2x3fv
#define glUniformMatrix2x3fvNV                                 gleswUniformMatrix2x3fvNV
#define glUniformMatrix2x4fv                                   gleswUniformMatrix2x4fv
#define glUniformMatrix2x4fvNV                                 gleswUniformMatrix2x4fvNV
#define glUniformMatrix3fv                                     gleswUniformMatrix3fv
#define glUniformMatrix3x2fv                                   gleswUniformMatrix3x2fv
#define glUniformMatrix3x2fvNV                                 gleswUniformMatrix3x2fvNV
#define glUniformMatrix3x4fv                                   gleswUniformMatrix3x4fv
#define glUniformMatrix3x4fvNV                                 gleswUniformMatrix3x4fvNV
#define glUniformMatrix4fv                                     gleswUniformMatrix4fv
#define glUniformMatrix4x2fv                                   gleswUniformMatrix4x2fv
#define glUniformMatrix4x2fvNV                                 gleswUniformMatrix4x2fvNV
#define glUniformMatrix4x3fv                                   gleswUniformMatrix4x3fv
#define glUniformMatrix4x3fvNV                                 gleswUniformMatrix4x3fvNV
#define glUnmapBuffer                                          gleswUnmapBuffer
#define glUnmapBufferOES                                       gleswUnmapBufferOES
#define glUseProgram                                           gleswUseProgram
#define glUseProgramStagesEXT                                  gleswUseProgramStagesEXT
#define glValidateProgram                                      gleswValidateProgram
#define glValidateProgramPipelineEXT                           gleswValidateProgramPipelineEXT
#define glVertexAttrib1f                                       gleswVertexAttrib1f
#define glVertexAttrib1fv                                      gleswVertexAttrib1fv
#define glVertexAttrib2f                                       gleswVertexAttrib2f
#define glVertexAttrib2fv                                      gleswVertexAttrib2fv
#define glVertexAttrib3f                                       gleswVertexAttrib3f
#define glVertexAttrib3fv                                      gleswVertexAttrib3fv
#define glVertexAttrib4f                                       gleswVertexAttrib4f
#define glVertexAttrib4fv                                      gleswVertexAttrib4fv
#define glVertexAttribDivisor                                  gleswVertexAttribDivisor
#define glVertexAttribDivisorANGLE                             gleswVertexAttribDivisorANGLE
#define glVertexAttribDivisorEXT                               gleswVertexAttribDivisorEXT
#define glVertexAttribDivisorNV                                gleswVertexAttribDivisorNV
#define glVertexAttribI4i                                      gleswVertexAttribI4i
#define glVertexAttribI4iv                                     gleswVertexAttribI4iv
#define glVertexAttribI4ui                                     gleswVertexAttribI4ui
#define glVertexAttribI4uiv                                    gleswVertexAttribI4uiv
#define glVertexAttribIPointer                                 gleswVertexAttribIPointer
#define glVertexAttribPointer                                  gleswVertexAttribPointer
#define glViewport                                             gleswViewport
#define glViewportArrayvNV                                     gleswViewportArrayvNV
#define glViewportIndexedfNV                                   gleswViewportIndexedfNV
#define glViewportIndexedfvNV                                  gleswViewportIndexedfvNV
#define glWaitSync                                             gleswWaitSync
#define glWaitSyncAPPLE                                        gleswWaitSyncAPPLE
#define glWeightPathsNV                                        gleswWeightPathsNV

#ifdef __cplusplus
}
#endif

#endif
