/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import oracle.jdbc.DatabaseFunction;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;

final class ConnectionTraceContext
implements TraceEventListener.TraceContext {
    private PhysicalConnection physicalConnection;
    private DatabaseFunction databaseFunction;
    private boolean isCompletedExceptionally;
    private OracleStatement statement;

    ConnectionTraceContext(PhysicalConnection physicalConnection, DatabaseFunction function, boolean isCompletedExceptionally) {
        this(physicalConnection, function, isCompletedExceptionally, null);
    }

    ConnectionTraceContext(PhysicalConnection physicalConnection, DatabaseFunction function, boolean isCompletedExceptionally, OracleStatement statement) {
        this.physicalConnection = physicalConnection;
        this.isCompletedExceptionally = isCompletedExceptionally;
        this.statement = statement;
        this.databaseFunction = function;
    }

    @Override
    public String getConnectionId() {
        this.throwIfIllegalState();
        try {
            return this.physicalConnection.getNetConnectionId();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String databaseOperation() {
        this.throwIfIllegalState();
        return this.databaseFunction.getDescription();
    }

    @Override
    public DatabaseFunction databaseFunction() {
        this.throwIfIllegalState();
        return this.databaseFunction;
    }

    @Override
    public String originalSqlText() {
        this.throwIfIllegalState();
        if (this.statement == null) {
            return null;
        }
        return this.statement.sqlObject.getOriginalSql();
    }

    @Override
    public String actualSqlText() {
        this.throwIfIllegalState();
        if (this.statement == null) {
            return null;
        }
        return this.statement.sqlObject.actualSql;
    }

    @Override
    public String user() {
        this.throwIfIllegalState();
        try {
            return this.physicalConnection.getUserName();
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public String tenant() {
        this.throwIfIllegalState();
        return this.physicalConnection.getTenantName();
    }

    @Override
    public String getSqlId() {
        this.throwIfIllegalState();
        if (this.statement == null) {
            return null;
        }
        try {
            return this.statement.getSqlId();
        }
        catch (SQLException sqlException) {
            return null;
        }
    }

    @Override
    public Boolean isCompletedExceptionally() {
        this.throwIfIllegalState();
        return this.isCompletedExceptionally;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.throwIfIllegalState();
        this.physicalConnection.setClientInfo(name, value);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.throwIfIllegalState();
        return this.physicalConnection.getClientInfo(name);
    }

    private void throwIfIllegalState() {
        if (this.physicalConnection == null) {
            throw new IllegalStateException();
        }
    }

    void reset() {
        this.physicalConnection = null;
    }
}

