/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.model;

import com.google.common.base.Objects;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.timeseries.annotation.Generated;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.FeatureData;

public abstract class IndexableResult
implements Writeable,
ToXContentObject {
    protected final String configId;
    protected final List<FeatureData> featureData;
    protected final Instant dataStartTime;
    protected final Instant dataEndTime;
    protected final Instant executionStartTime;
    protected final Instant executionEndTime;
    protected final String error;
    protected final Optional<Entity> optionalEntity;
    protected User user;
    protected final Integer schemaVersion;
    protected final String taskId;

    public IndexableResult(String configId, List<FeatureData> featureData, Instant dataStartTime, Instant dataEndTime, Instant executionStartTime, Instant executionEndTime, String error, Optional<Entity> entity, User user, Integer schemaVersion, String taskId) {
        this.configId = configId;
        this.featureData = featureData;
        this.dataStartTime = dataStartTime;
        this.dataEndTime = dataEndTime;
        this.executionStartTime = executionStartTime;
        this.executionEndTime = executionEndTime;
        this.error = error;
        this.optionalEntity = entity;
        this.user = user;
        this.schemaVersion = schemaVersion;
        this.taskId = taskId;
    }

    public IndexableResult(StreamInput input) throws IOException {
        this.configId = input.readString();
        int featureSize = input.readVInt();
        this.featureData = new ArrayList<FeatureData>(featureSize);
        for (int i = 0; i < featureSize; ++i) {
            this.featureData.add(new FeatureData(input));
        }
        this.dataStartTime = input.readInstant();
        this.dataEndTime = input.readInstant();
        this.executionStartTime = input.readInstant();
        this.executionEndTime = input.readInstant();
        this.error = input.readOptionalString();
        this.optionalEntity = input.readBoolean() ? Optional.of(new Entity(input)) : Optional.empty();
        this.user = input.readBoolean() ? new User(input) : null;
        this.schemaVersion = input.readInt();
        this.taskId = input.readOptionalString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.configId);
        out.writeVInt(this.featureData.size());
        for (FeatureData feature : this.featureData) {
            feature.writeTo(out);
        }
        out.writeInstant(this.dataStartTime);
        out.writeInstant(this.dataEndTime);
        out.writeInstant(this.executionStartTime);
        out.writeInstant(this.executionEndTime);
        out.writeOptionalString(this.error);
        if (this.optionalEntity.isPresent()) {
            out.writeBoolean(true);
            this.optionalEntity.get().writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.user != null) {
            out.writeBoolean(true);
            this.user.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.schemaVersion.intValue());
        out.writeOptionalString(this.taskId);
    }

    public String getConfigId() {
        return this.configId;
    }

    public List<FeatureData> getFeatureData() {
        return this.featureData;
    }

    public Instant getDataStartTime() {
        return this.dataStartTime;
    }

    public Instant getDataEndTime() {
        return this.dataEndTime;
    }

    public Instant getExecutionStartTime() {
        return this.executionStartTime;
    }

    public Instant getExecutionEndTime() {
        return this.executionEndTime;
    }

    public String getError() {
        return this.error;
    }

    public Optional<Entity> getEntity() {
        return this.optionalEntity;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public static String getEntityId(Optional<Entity> entity, String configId) {
        return entity.flatMap(e -> e.getModelId(configId)).orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexableResult that = (IndexableResult)o;
        return Objects.equal((Object)this.configId, (Object)that.configId) && Objects.equal((Object)this.taskId, (Object)that.taskId) && Objects.equal(this.featureData, that.featureData) && Objects.equal((Object)this.dataStartTime, (Object)that.dataStartTime) && Objects.equal((Object)this.dataEndTime, (Object)that.dataEndTime) && Objects.equal((Object)this.executionStartTime, (Object)that.executionStartTime) && Objects.equal((Object)this.executionEndTime, (Object)that.executionEndTime) && Objects.equal((Object)this.error, (Object)that.error) && Objects.equal(this.optionalEntity, that.optionalEntity);
    }

    @Generated
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.configId, this.taskId, this.featureData, this.dataStartTime, this.dataEndTime, this.executionStartTime, this.executionEndTime, this.error, this.optionalEntity});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("configId", (Object)this.configId).append("taskId", (Object)this.taskId).append("featureData", this.featureData).append("dataStartTime", (Object)this.dataStartTime).append("dataEndTime", (Object)this.dataEndTime).append("executionStartTime", (Object)this.executionStartTime).append("executionEndTime", (Object)this.executionEndTime).append("error", (Object)this.error).append("entity", this.optionalEntity).toString();
    }

    public abstract boolean isHighPriority();
}

