/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.url;

import com.plantuml.ubrex.TextNavigator;
import com.plantuml.ubrex.UMatcher;
import com.plantuml.ubrex.UnicodeBracketedExpression;
import java.util.List;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.url.UrlMode;

public class UbrexUrlBuilder {
    private static final String START_PART = "[[ \u3007*\u3034s";
    private static final String END_PART = "\u3007*\u3034s  ]]";
    private static final String S_QUOTED = "[[ \u3007*\u3034s\u3003  \u3036$URL=\u3007+\u300c\u3024\u3003\u300d \u3003\u3007?\u3018 \u3007*\u3034s { \u3036$TOOLTIP=\u3007*\u300c\u3024{}\u300d } \u3019\u3007?\u3018 \u3034s \u3036$LABEL=\u3018\u300c\u3024\u3034s{}[]\u300d  \u3007*\u300c\u3024[]\u300d\u3019  \u3019\u3007*\u3034s  ]]";
    private static final String S_ONLY_TOOLTIP = "[[ \u3007*\u3034s{  \u3036$TOOLTIP=\u3004>\u3018 }\u3007*\u3034s]]\u3019";
    private static final String S_ONLY_TOOLTIP_AND_LABEL = "[[ \u3007*\u3034s{  \u3036$TOOLTIP=\u3007+\u300c\u3024{}\u300d }\u3007*\u3034s\u3036$LABEL=\u3018\u300c\u3024\u3034s[]{}\u300d \u3007*\u300c\u3024[]\u300d\u3019\u3007*\u3034s  ]]";
    private static final String S_LINK_TOOLTIP_NOLABEL = "[[ \u3007*\u3034s\u3036$URL=\u3007+\u300c\u3024\u3034s\u3034g{}[]\u300d\u3007*\u3034s{  \u3036$TOOLTIP=\u3004>\u3018 }\u3007*\u3034s]]\u3019";
    private static final String S_LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL = "[[ \u3007*\u3034s\u3036$URL=\u3007+\u300c\u3024\u3034s\u3034g{}[]\u300d\u3007?\u3018  \u3007*\u3034s  {  \u3036$TOOLTIP=\u3007*\u300c\u3024{}\u300d  } \u3019\u3007?\u3018  \u3034s \u3036$LABEL=\u3018\u300c\u3024\u3034s{}[]\u300d \u3007*\u300c\u3024[]\u300d\u3019  \u3019\u3007*\u3034s  ]]";
    private static final String S_LINK_NOTOOLTIP_WITH_OPTIONAL_LABEL = "[[ \u3007*\u3034s\u3036$URL=\u3007+\u300c\u3024\u3034s\u3034g[]\u300d\u3007?\u3018  \u3034s \u3036$LABEL=\u3018\u300c\u3024\u3034s{}[]\u300d \u3007*\u300c\u3024[]\u300d\u3019  \u3019\u3007*\u3034s  ]]";
    private static final UnicodeBracketedExpression QUOTED = UnicodeBracketedExpression.build("[[ \u3007*\u3034s\u3003  \u3036$URL=\u3007+\u300c\u3024\u3003\u300d \u3003\u3007?\u3018 \u3007*\u3034s { \u3036$TOOLTIP=\u3007*\u300c\u3024{}\u300d } \u3019\u3007?\u3018 \u3034s \u3036$LABEL=\u3018\u300c\u3024\u3034s{}[]\u300d  \u3007*\u300c\u3024[]\u300d\u3019  \u3019\u3007*\u3034s  ]]");
    private static final UnicodeBracketedExpression ONLY_TOOLTIP = UnicodeBracketedExpression.build("[[ \u3007*\u3034s{  \u3036$TOOLTIP=\u3004>\u3018 }\u3007*\u3034s]]\u3019");
    private static final UnicodeBracketedExpression ONLY_TOOLTIP_AND_LABEL = UnicodeBracketedExpression.build("[[ \u3007*\u3034s{  \u3036$TOOLTIP=\u3007+\u300c\u3024{}\u300d }\u3007*\u3034s\u3036$LABEL=\u3018\u300c\u3024\u3034s[]{}\u300d \u3007*\u300c\u3024[]\u300d\u3019\u3007*\u3034s  ]]");
    private static final UnicodeBracketedExpression LINK_TOOLTIP_NOLABEL = UnicodeBracketedExpression.build("[[ \u3007*\u3034s\u3036$URL=\u3007+\u300c\u3024\u3034s\u3034g{}[]\u300d\u3007*\u3034s{  \u3036$TOOLTIP=\u3004>\u3018 }\u3007*\u3034s]]\u3019");
    private static final UnicodeBracketedExpression LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL = UnicodeBracketedExpression.build("[[ \u3007*\u3034s\u3036$URL=\u3007+\u300c\u3024\u3034s\u3034g{}[]\u300d\u3007?\u3018  \u3007*\u3034s  {  \u3036$TOOLTIP=\u3007*\u300c\u3024{}\u300d  } \u3019\u3007?\u3018  \u3034s \u3036$LABEL=\u3018\u300c\u3024\u3034s{}[]\u300d \u3007*\u300c\u3024[]\u300d\u3019  \u3019\u3007*\u3034s  ]]");
    private static final UnicodeBracketedExpression LINK_NOTOOLTIP_WITH_OPTIONAL_LABEL = UnicodeBracketedExpression.build("[[ \u3007*\u3034s\u3036$URL=\u3007+\u300c\u3024\u3034s\u3034g[]\u300d\u3007?\u3018  \u3034s \u3036$LABEL=\u3018\u300c\u3024\u3034s{}[]\u300d \u3007*\u300c\u3024[]\u300d\u3019  \u3019\u3007*\u3034s  ]]");
    private final String topurl;
    private UrlMode mode;

    public UbrexUrlBuilder(String topurl, UrlMode mode) {
        this.topurl = topurl;
        this.mode = mode;
    }

    public Url getUrl(String s) {
        UMatcher m = this.getMatcher(QUOTED, s);
        if (this.matchesOrFind(m)) {
            return this.buildUrl(m);
        }
        m = this.getMatcher(ONLY_TOOLTIP, s);
        if (this.matchesOrFind(m)) {
            return this.buildUrl(m);
        }
        m = this.getMatcher(ONLY_TOOLTIP_AND_LABEL, s);
        if (this.matchesOrFind(m)) {
            return this.buildUrl(m);
        }
        m = this.getMatcher(LINK_TOOLTIP_NOLABEL, s);
        if (this.matchesOrFind(m)) {
            return this.buildUrl(m);
        }
        m = this.getMatcher(LINK_WITH_OPTIONAL_TOOLTIP_WITH_OPTIONAL_LABEL, s);
        if (this.matchesOrFind(m)) {
            return this.buildUrl(m);
        }
        m = this.getMatcher(LINK_NOTOOLTIP_WITH_OPTIONAL_LABEL, s);
        if (this.matchesOrFind(m)) {
            return this.buildUrl(m);
        }
        return null;
    }

    private UMatcher getMatcher(UnicodeBracketedExpression ubrex, String s) {
        if (this.mode == UrlMode.STRICT) {
            return ubrex.match(s);
        }
        TextNavigator tn = TextNavigator.build(s);
        for (int i = 0; i < tn.length() - 2; ++i) {
            UMatcher matcher = ubrex.match(tn, i);
            if (!matcher.startMatch()) continue;
            return matcher;
        }
        return new UMatchNone();
    }

    private Url buildUrl(UMatcher m) {
        String url = this.getValue(m, "URL");
        String tooltip = this.getValue(m, "TOOLTIP");
        String label = this.getValue(m, "LABEL");
        return new Url(this.withTopUrl(url), tooltip, label);
    }

    private String getValue(UMatcher m, String key) {
        List<String> list = m.getCapture(key);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    private boolean matchesOrFind(UMatcher m) {
        if (this.mode == UrlMode.STRICT) {
            return m.exactMatch();
        }
        if (this.mode == UrlMode.ANYWHERE) {
            return m.startMatch();
        }
        throw new IllegalStateException();
    }

    private String withTopUrl(String url) {
        if (url == null) {
            return "";
        }
        if (!(url.startsWith("http:") || url.startsWith("https:") || url.startsWith("file:") || this.topurl == null)) {
            return this.topurl + url;
        }
        return url;
    }

    static class UMatchNone
    implements UMatcher {
        UMatchNone() {
        }

        @Override
        public boolean startMatch() {
            return false;
        }

        @Override
        public boolean exactMatch() {
            return false;
        }

        @Override
        public String getAcceptedMatch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getCapture(String path) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getKeysToBeRefactored() {
            throw new UnsupportedOperationException();
        }
    }
}

