/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UDrawable;
import net.sourceforge.plantuml.klimt.shape.UPolygon;
import net.sourceforge.plantuml.project.core.GSide;

public class GArrows
implements UDrawable {
    private static final double delta2 = 4.0;
    private final GSide atEnd;
    private final HColor backColor;
    private final List<XPoint2D> points = new ArrayList<XPoint2D>();

    public GArrows(GSide atEnd, HColor backColor) {
        this.atEnd = atEnd;
        this.backColor = backColor;
    }

    @Override
    public void drawU(UGraphic ug) {
        UPath path = UPath.none();
        path.moveTo(this.points.get(0));
        for (int i = 1; i < this.points.size() - 1; ++i) {
            path.lineTo(this.points.get(i));
        }
        path.lineTo(this.lastPointPatched());
        path.closePath();
        ug.draw(path);
        ug = ug.apply(UStroke.simple()).apply(this.backColor.bg());
        ug.draw(this.getHead());
    }

    private XPoint2D lastPointPatched() {
        XPoint2D last = this.points.get(this.points.size() - 1);
        if (this.atEnd == GSide.LEFT) {
            return new XPoint2D(last.getX() - 3.0, last.getY());
        }
        if (this.atEnd == GSide.RIGHT) {
            return new XPoint2D(last.getX() + 3.0, last.getY());
        }
        return last;
    }

    public void addPoint(double x, double y) {
        this.points.add(new XPoint2D(x, y));
    }

    private UPolygon getHead() {
        XPoint2D last = this.points.get(this.points.size() - 1);
        double x = last.getX();
        double y = last.getY();
        if (this.atEnd == GSide.LEFT) {
            UPolygon polygon = new UPolygon("asToRight");
            polygon.addPoint(x - 4.0, y - 4.0);
            polygon.addPoint(x, y);
            polygon.addPoint(x - 4.0, y + 4.0);
            polygon.addPoint(x - 4.0, y - 4.0);
            return polygon;
        }
        if (this.atEnd == GSide.RIGHT) {
            UPolygon polygon = new UPolygon("asToLeft");
            polygon.addPoint(x + 4.0, y - 4.0);
            polygon.addPoint(x, y);
            polygon.addPoint(x + 4.0, y + 4.0);
            polygon.addPoint(x + 4.0, y - 4.0);
            return polygon;
        }
        assert (false);
        return new UPolygon();
    }
}

