%%
%% This is file `udiss.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% udiss.dtx  (with options: `class')
%% ---------------------------------------------------------
%% Bundle:      udiss
%% Version:     v0.1 (October 1, 2024)
%% Author:      Indian TeX Users Group
%% Description: A LaTeX bundle for typesetting dissertations
%% Bugs:        puszcza.gnu.org.ua/bugs/?group=udiss
%% Licenses:    GPLv3+, GFDLv1.3+
%% ---------------------------------------------------------
%% 
%% The LaTeX bundle udiss v0.1
%% Copyright © 2024 Indian TeX Users Group
%% 
%% This program is free software: you can redistribute it
%% and/or modify it under the terms of the GNU General
%% Public License as published by the Free Software
%% Foundation, either version 3 of the License, or (at your
%% option) any later version.
%% 
%% This program is distributed in the hope that it will be
%% useful, but WITHOUT ANY WARRANTY; without even the
%% implied warranty of MERCHANTABILITY or FITNESS FOR A
%% PARTICULAR PURPOSE. See the GNU General Public License
%% for more details.
%% 
%% You should have received a copy of the GNU General Public
%% License along with this program. If not, see
%% <https://www.gnu.org/licenses/>.
%% ---------------------------------------------------------
\ProvidesClass{udiss}[2024/10/01 v0.1
  A LaTeX bundle for typesetting dissertations (TUGIndia)]
\RequirePackage{expkv-def,expkv-opt}
\newif\ifudiss@pronouns
\newif\ifudiss@blind
\NewDocumentCommand{ \pronouns }{ m }{%
  \ifudiss@blind
  \else
    \def\udiss@pronouns{#1}%
  \fi
}
\ekvdefinekeys{udiss}{%
  code    pronouns       = {%
    \ifudiss@blind
    \else
      \def\udiss@pronouns{(#1)}%
    \fi
    \udiss@pronounstrue
  }%
}
\newif\ifudiss@title
\def\udiss@blank@title@err{%
  \ClassError{udiss}{%
    The `title' field cannot be blank%
  }{%
    You have provided an empty argument to the `title'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\def\udiss@blank@author@err{%
  \ClassError{udiss}{%
    The `author' field cannot be blank%
  }{%
    You have provided an empty argument to the `author'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\ekvdefinekeys{udiss}{%
  code    title          = {%
    \def\udiss@tmp@title{#1}%
    \ifx\udiss@tmp@title\empty
      \def\udiss@title{-NoValidTitle-}%
      \udiss@blank@title@err
    \else
      \def\udiss@title{#1}%
    \fi
  },%
  code    author         = {%
    \def\udiss@tmp@author{#1}%
    \ifx\udiss@tmp@author\empty
      \def\udiss@author{-NoValidAuthor-}%
      \udiss@blank@author@err
    \else
      \def\udiss@author{#1}%
    \fi
  }%
}
\newif\ifudiss@subtitle
\newif\ifudiss@shorttitle
\ekvdefinekeys{udiss}{%
  code    subtitle       = {%
    \IfBlankTF{#1}{%
      \def\udiss@subtitle{-NoValidSubtitle-}%
      \udiss@subtitletrue
    }{%
      \def\udiss@subtitle{#1}%
      \udiss@subtitletrue
    }%
  },%
  code    shorttitle     = {%
    \IfBlankTF{#1}{%
      \def\udiss@shorttitle{-NoValidSubtitle-}%
      \udiss@shorttitletrue
    }{%
      \def\udiss@shorttitle{#1}%
      \udiss@shorttitletrue
    }%
  }%
}
\NewDocumentCommand{ \subtitle }{ m }{%
  \def\udiss@subtitle{#1}%
  \udiss@subtitletrue
}
\NewDocumentCommand{ \shorttitle }{ m }{%
  \def\udiss@shorttitle{#1}%
  \udiss@shorttitletrue
}
\newif\ifudiss@stream
\def\udiss@blank@stream@err{%
  \ClassError{udiss}{%
    The `stream' field cannot be blank%
  }{%
    You have provided an empty argument to the `stream'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\newif\ifudiss@discipline
\def\udiss@blank@discipline@err{%
  \ClassError{udiss}{%
    The `discipline' field cannot be blank%
  }{%
    You have provided an empty argument to the `discipline'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\newif\ifudiss@degree
\def\udiss@blank@degree@err{%
  \ClassError{udiss}{%
    The `degree' field cannot be blank%
  }{%
    You have provided an empty argument to the `degree'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\ekvdefinekeys{udiss}{%
  code    stream         = {%
    \def\udiss@tmp@stream{#1}%
    \ifx\udiss@tmp@stream\empty
      \def\udiss@stream{-NoValidStream-}%
      \udiss@blank@stream@err
    \else
      \def\udiss@stream{#1}%
    \fi
  },%
  code    discipline     = {%
    \def\udiss@tmp@discipline{#1}%
    \ifx\udiss@tmp@discipline\empty
      \def\udiss@discipline{-NoValidDiscipline-}%
      \udiss@blank@discipline@err
    \else
      \def\udiss@discipline{#1}%
    \fi
  },%
  code    degree         = {%
    \def\udiss@tmp@degree{#1}%
    \ifx\udiss@tmp@degree\empty
      \def\udiss@degree{-NoValidDegree-}%
      \udiss@blank@degree@err
    \else
      \def\udiss@degree{#1}%
    \fi
  }%
}
\NewDocumentCommand{ \stream }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@stream@err
    \def\udiss@stream{-NoValidStream-}%
  }{%
    \def\udiss@stream{#1}%
  }%
  \IfBlankTF{#1}{%
    \udiss@streamtrue
  }{%
    \def\udiss@stream{#1}%
    \udiss@streamtrue
  }%
}
\NewDocumentCommand{ \discipline }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@discipline@err
    \def\udiss@discipline{-NoValidDiscipline-}%
  }{%
    \def\udiss@discipline{#1}%
  }%
  \IfBlankTF{#1}{%
    \udiss@disciplinetrue
  }{%
    \def\udiss@discipline{#1}%
    \udiss@disciplinetrue
  }%
}
\NewDocumentCommand{ \degree }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@degree@err
    \def\udiss@degree{-NoValidDegree-}%
  }{%
    \def\udiss@degree{#1}%
  }%
  \IfBlankTF{#1}{%
    \udiss@degreetrue
  }{%
    \def\udiss@degree{#1}%
    \udiss@degreetrue
  }%
}
\newif\ifudiss@supervisor
\newif\ifudiss@university
\newif\ifudiss@department
\def\udiss@blank@supervisor@err{%
  \ClassError{udiss}{%
    The `supervisor' field cannot be blank%
  }{%
    You have provided an empty argument to the `supervisor'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\def\udiss@blank@university@err{%
  \ClassError{udiss}{%
    The `university' field cannot be blank%
  }{%
    You have provided an empty argument to the `university'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\def\udiss@blank@department@err{%
  \ClassError{udiss}{%
    The `department' field cannot be blank%
  }{%
    You have provided an empty argument to the `department'
    field. This is not\MessageBreak permitted by the class.%
  }%
}
\ekvdefinekeys{udiss}{%
  code    supervisor         = {%
    \def\udiss@tmp@supervisor{#1}%
    \ifx\udiss@tmp@supervisor\empty
      \def\udiss@supervisor{-NoValidSupervisor-}%
      \udiss@blank@supervisor@err
    \else
      \def\udiss@supervisor{#1}%
    \fi
  },%
  code    university         = {%
    \def\udiss@tmp@university{#1}%
    \ifx\udiss@tmp@university\empty
      \def\udiss@university{-NoValidUniversity-}%
      \udiss@blank@university@err
    \else
      \def\udiss@university{#1}%
    \fi
  },%
  code    department         = {%
    \def\udiss@tmp@department{#1}%
    \ifx\udiss@tmp@department\empty
      \def\udiss@department{-NoValidDepartment-}%
      \udiss@blank@department@err
    \else
      \def\udiss@department{#1}%
    \fi
  }%
}
\NewDocumentCommand{ \supervisor }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@supervisor@err
    \def\udiss@supervisor{-NoValidSupervisor-}%
  }{%
    \def\udiss@supervisor{#1}%
  }%
  \IfBlankTF{#1}{%
    \udiss@supervisortrue
  }{%
    \def\udiss@supervisor{#1}%
    \udiss@supervisortrue
  }%
}
\NewDocumentCommand{ \university }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@university@err
    \def\udiss@author{-NoValidUniversity-}%
  }{%
    \def\udiss@university{#1}%
  }%
  \IfBlankTF{#1}{%
    \udiss@universitytrue
  }{%
    \def\udiss@university{#1}%
    \udiss@universitytrue
  }%
}
\NewDocumentCommand{ \department }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@department@err
    \def\udiss@author{-NoValidDepartment-}%
  }{%
    \def\udiss@department{#1}%
  }%
  \IfBlankTF{#1}{%
    \udiss@departmenttrue
  }{%
    \def\udiss@department{#1}%
    \udiss@departmenttrue
  }%
}
\newif\ifudiss@logo
\newif\ifudiss@texlogo
\NewDocumentCommand{ \logo }{ s +m }{%
  \IfBooleanTF{#1}{%
    \def\udiss@texlogo{#2}%
    \udiss@texlogotrue
  }{%
    \def\udiss@logo{#2}%
  }%
  \udiss@logotrue
}
\ekvdefinekeys{udiss}{%
  code    logo           = {%
    \def\udiss@logo{#1}%
    \udiss@logotrue
  },%
  code    logo*          = {%
    \def\udiss@texlogo{#1}%
    \udiss@logotrue
    \udiss@texlogotrue
  }%
}
\newcounter{udiss@langbabel}
\stepcounter{udiss@langbabel}
\def\udiss@int@langbabel#1{%
  \expandafter\edef
    \csname
      udiss@langbabel@\alph{udiss@langbabel}%
    \endcsname{#1}%
  \stepcounter{udiss@langbabel}%
}
\NewDocumentCommand\udiss@lgbbl{ >{ \SplitList{,} } m }{%
  \ProcessList{#1}{\udiss@int@langbabel}%
}
\newif\ifudiss@lg@used
\newif\ifudiss@ldfbabel
\ekvdefinekeys{udiss}{%
  code    language       = {%
    \udiss@lgbbl{#1}%
    \udiss@lg@usedtrue
  },%
  code    ldfbabel       = {%
    \def\udiss@ldfbabel@list{#1}%
    \udiss@lg@usedtrue
    \udiss@ldfbabeltrue
  },%
  invbool nofontwarning  = {\ifudiss@font@warning}%
}
\newif\ifudiss@free@culture
\newif\ifudiss@ccbysa
\newif\ifudiss@gfdl
\ekvdefinekeys{udiss}{%
  choice  license        = {%
    all-rights-reserved    = {%
      \def\udiss@license@notice{%
        All rights reserved.\textLF
      }%
    },%
    CC-BY-SA               = {%
      \def\udiss@license@notice{%
        This work is available under the "Creative Commons
        Attribution ShareAlike 4.0 International" license.%
      }%
      \def\udiss@free@license@url{%
        https://creativecommons.org/licenses/%
        by-sa/4.0/legalcode.txt%
      }%
      \udiss@free@culturetrue
      \udiss@ccbysatrue
    },%
    GFDL                   = {%
      \def\udiss@license@notice{%
        Permission is granted to copy, distribute and/or
        modify this document under the terms of the GNU Free
        Documentation License, Version 1.3 or any later
        version published by the Free Software Foundation;
        with no Invariant Sections, no Front-Cover Texts,
        and no Back-Cover Texts. A copy of the license is
        included in the section entitled “GNU Free
        Documentation License”.%
      }%
      \def\udiss@free@license@url{%
        https://www.gnu.org/licenses/fdl-1.3.txt%
      }%
      \udiss@free@culturetrue
      \udiss@gfdltrue
    },%
  },%
  initial license        = {all-rights-reserved},%
  store   copyright-yrs  = {\udiss@copyrightable@years},%
  initial copyright-yrs  = {\the\year},%
  store   localcopyright = {\udiss@local@copyright},%
  initial localcopyright = {Copyright},%
  nmeta   placeholders   = {%
            title          = {%
              A groundbreaking dissertation%
            },%
            author         = {%
              Jane Doe%
            },%
            pronouns       = {She/her},%
            subtitle       = {%
              A milestone study on a longstanding question
              in a discipline%
            },%
            shorttitle     = {A Milestone study},%
            stream         = {intriguing stream},%
            discipline     = {rigorous discipline},
            degree         = {enriching degree},%
            supervisor     = {A kind supervisor},%
            university     = {An ideal university},%
            department     = {A homely department},%
            license        = {CC-BY-SA},%
            copyright-yrs  = {2022, 2023, 2024}%
          }%
}
\ekvdefinekeys{udiss}{%
  bool    lot            = {\ifudiss@lot},%
  bool    lof            = {\ifudiss@lof},%
  bool    declaration    = {\ifudiss@declaration},%
  long
  store   declarationtxt = {\udiss@declaration},%
  initial declarationtxt = {%
    \noindent As required by the university regulations, I
    wish to state that the work embodied in this thesis
    titled \enquote{\udiss@title: \udiss@subtitle} forms
    my own contribution to the research work carried out
    under the guidance of \udiss@supervisor\ at the
    \udiss@university, \udiss@department.

    This work has not been submitted for any other degree
    of this or any other university. Whenever references
    have been made to previous works of others, it has
    been clearly indicated as such and included in the
    bibliography.

    \bigskip
    \flushright{%
      Date: \today

      \vspace{4em}%

      Name: \udiss@author
    }%

    \bigskip\bigskip
    \flushleft{%
      Certified by:%

      \vspace{4em}%

      \udiss@supervisor
    }%
  },%
  store   decllocal      = {\udiss@decllocal},%
  initial decllocal      = {Declaration}%
}
\ekvdefinekeys{udiss}{%
  bool    print          = {\ifudiss@print},%
  invbool norefcolors    = {\ifudiss@colors},%
  store   udisslinkclr   = {\udiss@int@link@color},%
  initial udisslinkclr   = {udisslink},%
  store   udissurlclr    = {\udiss@int@url@color},%
  initial udissurlclr    = {udissurl},%
  store   udissciteclr   = {\udiss@int@cite@color},%
  initial udissciteclr   = {udisscite}%
}
\ekvdefinekeys{udiss}{%
  bool    blind          = {\ifudiss@blind}%
}
\ekvdefinekeys{udiss}{%
  bool    framed-title   = {\ifudiss@ftitle}%
}
\ekvdefinekeys{udiss}{%
  invbool oldstylenumoff = {\ifudiss@oldstylenum},%
  bool    oldone         = {\ifudiss@oldone}%
}
\ekvdefinekeys{udiss}{%
  bool    explicitext    = {\ifudiss@explicitext},%
  invbool ignorefsoff    = {\ifudiss@ignorefontspec}%
}
\ekvdefinekeys{udiss}{%
  store   fulfilment     = {\udiss@fulfilment},%
  initial fulfilment     = {%
    A dissertation submitted in the partial fulfilment of
    the requirements for the \udiss@degree\ program in
    \udiss@discipline.%
  }%
}
\ekvdefinekeys{udiss}{%
  store   rmfont         = {\udiss@rmfont},%
  initial rmfont         = {NewCM10-Book.otf},%
  store   rmbffont       = {\udiss@rmbffont},%
  initial rmbffont       = {NewCM10-Bold.otf},%
  store   rmitfont       = {\udiss@rmitfont},%
  initial rmitfont       = {NewCM10-BookItalic.otf},%
  store   rmbfitfont     = {\udiss@rmbfitfont},%
  initial rmbfitfont     = {NewCM10-BoldItalic.otf},%
  store   rmslfont       = {\udiss@rmslfont},%
  initial rmslfont       = {NewCM10-Book.otf},%
  store   rmbfslfont     = {\udiss@rmbfslfont},%
  initial rmbfslfont     = {NewCM10-Bold.otf},%
  store   sffont         = {\udiss@sffont},%
  initial sffont         = {NewCMSans10-Book.otf},%
  store   sfbffont       = {\udiss@sfbffont},%
  initial sfbffont       = {NewCMSans10-Bold.otf},%
  store   sfitfont       = {\udiss@sfitfont},
  initial sfitfont       = {NewCMSans10-BookOblique.otf},%
  store   sfbfitfont     = {\udiss@sfbfitfont},%
  initial sfbfitfont     = {NewCMSans10-BoldOblique.otf},%
  store   sfslfont       = {\udiss@sfslfont},%
  initial sfslfont       = {NewCMSans10-BookOblique.otf},%
  store   sfbfslfont     = {\udiss@sfbfslfont},%
  initial sfbfslfont     = {NewCMSans10-BoldOblique.otf},%
  store   ttfont         = {\udiss@ttfont},%
  initial ttfont         = {NewCMMono10-Book.otf},%
  store   ttbffont       = {\udiss@ttbffont},
  initial ttbffont       = {NewCMMono10-Bold.otf},%
  store   ttitfont       = {\udiss@ttitfont},%
  initial ttitfont       = {NewCMMono10-BookItalic.otf},%
  store   ttbfitfont     = {\udiss@ttbfitfont},%
  initial ttbfitfont     = {NewCMMono10-BoldOblique.otf},%
  store   ttslfont       = {\udiss@ttslfont},%
  initial ttslfont       = {NewCM10-Book.otf},%
  store   ttbfslfont     = {\udiss@ttbfslfont},%
  initial ttbfslfont     = {NewCMMono10-BoldOblique.otf},%
  store   mathfont       = {\udiss@mathfont},%
  initial mathfont       = {NewCMMath-Book.otf},%
  store   mathbffont     = {\udiss@mathbffont},%
  initial mathbffont     = {NewCMMath-Bold.otf},%
  store   rmfeatures     = {\udiss@rmfeatures},%
  choice  rmfntext       = {%
            ttf            = {%
              \ifudiss@explicitext
                \def\udiss@rmfntext{ttf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `rmfntext' to
                  add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  FreeSerif, you may choose one of the
                  following two methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<---------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    rmfont = {FreeSerif.ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<---------------8<----%
                  \MessageBreak\MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    rmfont = {FreeSerif},\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    rmfntext = {ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<------------8<----%
                }%
              \fi
            },%
            otf            = {%
              \ifudiss@explicitext
                \def\udiss@rmfntext{otf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `rmfntext' to
                  add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  KpRoman-Regular.otf, you may choose one of
                  the following two\MessageBreak
                  methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<---------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    rmfont = {KpRoman-Regular.otf}%
                    \@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<---------------------8<----%
                  \MessageBreak
                  \MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    rmfont = {KpRoman-Regular},%
                    \@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    rmfntext = {otf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<------------------8<----%
                }%
              \fi
            }%
          },%
  store   sffeatures     = {\udiss@sffeatures},%
  choice  sffntext       = {%
            ttf            = {%
              \ifudiss@explicitext
                \def\udiss@sffntext{ttf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `sffntext' to
                  add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  FreeSans, you may choose one of the
                  following two methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<---------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    sffont = {FreeSans.ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<---------------8<----%
                  \MessageBreak\MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    sffont = {FreeSans},\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    sffntext = {ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<------------8<----%
                }%
              \fi
            },%
            otf            = {%
              \ifudiss@explicitext
                \def\udiss@sffntext{otf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `sffntext' to
                  add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  KpSans-Regular.otf, you may choose one of
                  the following two\MessageBreak
                  methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<---------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    sffont = {KpSans-Regular.otf}%
                    \@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<---------------------8<----%
                  \MessageBreak
                  \MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    sffont = {KpSans-Regular},%
                    \@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    sffntext = {otf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<------------------8<----%
                }%
              \fi
            }%
          },%
  store   ttfeatures     = {\udiss@ttfeatures},%
  choice  ttfntext       = {%
            ttf            = {%
              \ifudiss@explicitext
                \def\udiss@ttfntext{ttf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `ttfntext' to
                  add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  FreeMono, you may choose one of the
                  following two methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<---------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    ttfont = {FreeMono.ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<---------------8<----%
                  \MessageBreak\MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    ttfont = {FreeMono},\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    ttfntext = {ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<------------8<----%
                }%
              \fi
            },%
            otf            = {%
              \ifudiss@explicitext
                \def\udiss@ttfntext{otf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `ttfntext' to
                  add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  KpMono-Regular.otf, you may choose one of
                  the following two\MessageBreak
                  methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<---------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    ttfont = {KpMono-Regular.otf}%
                    \@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<---------------------8<----%
                  \MessageBreak
                  \MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    ttfont = {KpMono-Regular},%
                    \@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    ttfntext = {otf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<------------------8<----%
                }%
              \fi
            }%
          },%
  store   mathfeatures   = {\udiss@mathfeatures},%
  choice  mathfntext     = {%
            ttf            = {%
              \ifudiss@explicitext
                \def\udiss@mathfntext{ttf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `mathfntext'
                  to add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  NotoSansMath-Regular, you may choose one
                  of the following two\MessageBreak
                  methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<----------------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    mathfont = {NotoSansMath-Regular.ttf}%
                    \@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<----------------------------8<----%
                  \MessageBreak\MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<-------------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    mathfont = {NotoSansMath-Regular},%
                    \@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    mathfntext = {ttf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<-------------------------8<----%
                }%
              \fi
            },%
            otf            = {%
              \ifudiss@explicitext
                \def\udiss@mathfntext{otf}%
              \else
                \ClassError{udiss}{%
                  Option `explicitext' is needed for adding
                  font extensions%
                }{%
                  You have loaded font-option `mathfntext'
                  to add extension to font-names.
                  This\MessageBreak option is supposed to be
                  used only with the `explicitext' option.
                  E.g., for\MessageBreak loading, say,
                  XITSMath-Regular, you may choose one of
                  the following two\MessageBreak methods:%
                  \MessageBreak\MessageBreak
                  1. The recommended method:%
                  \MessageBreak
                  \space\space\space
                  ----8<----------------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    mathfont = {XITSMath-Regular.otf}%
                    \@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}\MessageBreak
                  \space\space\space
                  ----8<----------------------------8<----%
                  \MessageBreak\MessageBreak
                  2. The alternative:%
                  \MessageBreak
                  \space\space\space
                  ----8<-------------------------8<----%
                  \MessageBreak
                  \space\space\space
                  \string\documentclass[\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    explicitext,\@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    mathfont = {XITSMath-Regular},%
                    \@percentchar
                    \MessageBreak
                    \space\space\space\space\space
                    mathfntext = {otf}\@percentchar
                    \MessageBreak
                    \space\space\space
                  ]{udiss}%
                  \MessageBreak
                  \space\space\space
                  ----8<-------------------------8<----%
                }%
              \fi
            }%
          },%
}
\ekvdefinekeys{udiss}{%
  store   titleshape     = {\udiss@title@shape},%
  initial titleshape     = {\bfseries},%
  store   titlefont      = {\udiss@title@font},%
  store   titlesize      = {\udiss@title@size},%
  initial titlesize      = {\udiss@int@huge},%
  store   titlecolor     = {\udiss@title@color},%
  initial titlecolor     = {black},%
  store   titleffeat     = {\udiss@title@fontfeats},%
  initial titleffeat     = {}%
}
\ekvdefinekeys{udiss}{%
  store   subtitleshape  = {\udiss@subtitle@shape},%
  initial subtitleshape  = {\normalfont},%
  store   subtitlefont   = {\udiss@subtitle@font},%
  store   subtitlesize   = {\udiss@subtitle@size},%
  initial subtitlesize   = {\udiss@int@large},%
  store   subtitlecolor  = {\udiss@subtitle@color},%
  initial subtitlecolor  = {black},%
  store   subtitleffeat  = {\udiss@subtitle@fontfeats},%
  initial subtitleffeat  = {}%
}
\ekvdefinekeys{udiss}{%
  store   authorshape    = {\udiss@author@shape},%
  initial authorshape    = {\normalfont},%
  store   authorfont     = {\udiss@author@font},%
  store   authorsize     = {\udiss@author@size},%
  initial authorsize     = {\udiss@int@large},%
  store   authorcolor    = {\udiss@author@color},%
  initial authorcolor    = {black},%
  store   authorffeat    = {\udiss@author@fontfeats},%
  initial authorffeat    = {}%
}
\ekvdefinekeys{udiss}{%
  store   unishape       = {\udiss@uni@shape},%
  initial unishape       = {\itshape},%
  store   unifont        = {\udiss@uni@font},%
  store   unisize        = {\udiss@uni@size},%
  initial unisize        = {\normalsize},%
  store   unicolor       = {\udiss@uni@color},%
  initial unicolor       = {black},%
  store   uniffeat       = {\udiss@uni@fontfeats}%
}
\ekvdefinekeys{udiss}{%
  store   deptshape      = {\udiss@dept@shape},%
  initial deptshape      = {\normalfont},%
  store   deptfont       = {\udiss@dept@font},%
  store   deptsize       = {\udiss@dept@size},%
  initial deptsize       = {\udiss@int@small},%
  store   deptcolor      = {\udiss@dept@color},%
  initial deptcolor      = {black},%
  store   deptffeat      = {\udiss@dept@fontfeats},%
  initial deptffeat      = {}%
}
\ekvdefinekeys{udiss}{%
  store   ffshape        = {\udiss@fulfilment@shape},%
  initial ffshape        = {\normalfont},%
  store   fffont         = {\udiss@fulfilment@font},%
  store   ffsize         = {\udiss@fulfilment@size},%
  initial ffsize         = {\udiss@int@small},%
  store   ffcolor        = {\udiss@fulfilment@color},%
  initial ffcolor        = {black},%
  store   fffeat         = {\udiss@fulfilment@fontfeats},%
  initial fffeat         = {}%
}
\ekvdefinekeys{udiss}{%
  store   logowidth      = {\udiss@logo@width},%
  initial logowidth      = {0.3},%
  store   logoheight     = {\udiss@logo@hght},%
  initial logoheight     = {0.075}%
}
\ekvoProcessGlobalOptions{udiss}
\NewDocumentCommand{ \dissertationstyle }{ m }{%
  \AddToHook{begindocument/before}{%
    \input{udiss-style-#1}%
  }%
}
\ifudiss@print
\else
  \PassOptionsToClass{oneside}{memoir}%
\fi
\LoadClass{memoir}
\RenewDocumentCommand{ \title }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@title@err
    \def\udiss@title{-NoValidTitle-}%
  }{%
    \def\udiss@title{#1}%
  }%
}
\RenewDocumentCommand{ \author }{ m }{%
  \IfBlankTF{#1}{%
    \udiss@blank@author@err
    \def\udiss@author{-NoValidAuthor-}%
  }{%
    \def\udiss@author{#1}%
  }%
}
\RequirePackage{iftex}
\RequireTUTeX
\def\udiss@int@HUGE{%
  \addfontfeature{Scale={2.5}}%
}
\def\udiss@int@Huge{%
  \addfontfeature{Scale={2}}%
}
\def\udiss@int@huge{%
  \addfontfeature{Scale={1.7}}%
}
\def\udiss@int@LARGE{%
  \addfontfeature{Scale={1.4}}%
}
\def\udiss@int@Large{%
  \addfontfeature{Scale={1.2}}%
}
\def\udiss@int@large{%
  \addfontfeature{Scale={1.1}}%
}
\def\udiss@int@small{%
  \addfontfeature{Scale={0.9}}%
}
\def\udiss@int@footnotesize{%
  \addfontfeature{Scale={0.8}}%
}
\def\udiss@int@scriptsize{%
  \addfontfeature{Scale={0.7}}%
}
\def\udiss@int@tiny{%
  \addfontfeature{Scale={0.6}}%
}
\def\udiss@int@miniscule{%
  \addfontfeature{Scale={0.5}}%
}
\ifudiss@lg@used
  \ifudiss@ldfbabel
    \PassOptionsToPackage{%
      \udiss@ldfbabel@list
    }{babel}%
  \fi
\else
  \PassOptionsToPackage{english,provide*=*}{babel}%
\fi
\RequirePackage{babel}
\RequirePackage{iflang}
\newcounter{udiss@tmp@langcnt}
\ifudiss@ldfbabel
\else
  \ifudiss@lg@used
    \ifnum\theudiss@langbabel=2\relax
      \addtocounter{udiss@langbabel}{-1}%
      \ifLuaTeX
        \babelprovide[%
          main,%
          import,%
          onchar                 ={ids fonts}%
        ]{%
          \csname
            udiss@langbabel@\alph{udiss@langbabel}%
          \endcsname
        }%
      \else
        \babelprovide[main,import]{%
          \csname
            udiss@langbabel@\alph{udiss@langbabel}%
          \endcsname
        }%
      \fi
    \fi
    \ifnum\theudiss@langbabel>2\relax
      \setcounter{udiss@tmp@langcnt}{%
        \numexpr\theudiss@langbabel -1\relax
      }%
      \setcounter{udiss@langbabel}{1}%
      \loop
        \ifLuaTeX
          \babelprovide[%
            import,%
            onchar                 ={ids fonts}%
          ]{%
            \csname
              udiss@langbabel@\alph{udiss@langbabel}%
            \endcsname
          }%
        \else
          \babelprovide[import]{%
            \csname
              udiss@langbabel@\alph{udiss@langbabel}%
            \endcsname
          }%
        \fi
        \ifnum\theudiss@tmp@langcnt=1\relax
        \else
          \addtocounter{udiss@langbabel}{1}%
        \fi
        \ifnum\theudiss@langbabel<\theudiss@tmp@langcnt
        \relax
      \repeat
    \fi
    \ifnum\theudiss@langbabel=1\relax
    \else
      \ifLuaTeX
        \babelprovide[%
          main,%
          import,%
          onchar                 ={ids fonts}%
        ]{%
          \csname
            udiss@langbabel@\alph{udiss@langbabel}%
          \endcsname
        }%
      \else
        \babelprovide[main,import]{%
          \csname
            udiss@langbabel@\alph{udiss@langbabel}%
          \endcsname
        }%
      \fi
    \fi
    \setcounter{udiss@tmp@langcnt}{%
      \numexpr\theudiss@langbabel + 1\relax
    }%
    \setcounter{udiss@langbabel}{1}%
    \loop
      \IfFileExists{%
        udiss-fonts-\csname
          udiss@langbabel@\alph{udiss@langbabel}%
        \endcsname
      }{%
        \input{%
          udiss-fonts-\csname
            udiss@langbabel@\alph{udiss@langbabel}%
          \endcsname
        }%
      }{%
        \ifudiss@font@warning
          \ClassWarningNoLine{udiss}{%
            We don't support \csname
              udiss@langbabel@\alph{udiss@langbabel}%
            \endcsname\space yet.%
            \MessageBreak
            It requires a font-setup. You may add the fonts
            directly\MessageBreak to your preamble using:%
            \MessageBreak\MessageBreak
            \space\space\string\babelfont[%
              \csname
                udiss@langbabel@\alph{udiss@langbabel}%
              \endcsname
            ]{rm}{main font}%
            \MessageBreak
            \space\space\string\babelfont[%
              \csname
                udiss@langbabel@\alph{udiss@langbabel}%
              \endcsname
            ]{sf}{sans font}%
            \MessageBreak
            \space\space\string\babelfont[%
              \csname
                udiss@langbabel@\alph{udiss@langbabel}%
              \endcsname
            ]{tt}{mono font}%
            \MessageBreak\MessageBreak
            Read more about this in the documentation of
            `udiss' in a\MessageBreak section called
            `multilingual typesetting'. Consider%
            \MessageBreak contacting us with a support
            request and let us know some\MessageBreak
            suitable free (libre) fonts for this
            language. If you\MessageBreak don't wish to see
            this warning again, use the option%
            \MessageBreak `nofontwarning' to suppress it%
          }%
        \fi
      }%
      \addtocounter{udiss@langbabel}{1}%
      \ifnum\theudiss@langbabel<\theudiss@tmp@langcnt\relax
    \repeat
  \fi
\fi
\babelfont{rm}[%
  \ifudiss@ignorefontspec
    IgnoreFontspecFile,%
  \fi
  \ifudiss@explicitext
    Extension            = {.\udiss@rmfntext},%
  \fi
  BoldFont               = {\udiss@rmbffont},%
  ItalicFont             = {\udiss@rmitfont},%
  BoldItalicFont         = {\udiss@rmbfitfont},%
  SlantedFont            = {\udiss@rmslfont},%
  BoldSlantedFont        = {\udiss@rmbfslfont},%
  \ifudiss@oldstylenum
    Numbers              = {OldStyle},%
    \ifudiss@oldone
      CharacterVariant   = {6},%
    \fi
  \fi
  \ifLuaTeX
    Renderer             = {HarfBuzz},%
  \fi
  \udiss@rmfeatures
]{\udiss@rmfont}
\babelfont{sf}[%
  \ifudiss@ignorefontspec
    IgnoreFontspecFile,%
  \fi
  \ifudiss@explicitext
    Extension            = {.\udiss@sffntext},%
  \fi
  BoldFont               = {\udiss@sfbffont},%
  ItalicFont             = {\udiss@sfitfont},%
  BoldItalicFont         = {\udiss@sfbfitfont},%
  SlantedFont            = {\udiss@sfslfont},%
  BoldSlantedFont        = {\udiss@sfbfslfont},%
  \ifudiss@oldstylenum
    Numbers              = {OldStyle},%
    \ifudiss@oldone
      CharacterVariant   = {6},%
    \fi
  \fi
  \ifLuaTeX
    Renderer             = {HarfBuzz},%
  \fi
  \udiss@sffeatures
]{\udiss@sffont}
\babelfont{tt}[%
  \ifudiss@ignorefontspec
    IgnoreFontspecFile,%
  \fi
  \ifudiss@explicitext
    Extension            = {.\udiss@ttfntext},%
  \fi
  BoldFont               = {\udiss@ttbffont},%
  ItalicFont             = {\udiss@ttitfont},%
  BoldItalicFont         = {\udiss@ttbfitfont},%
  SlantedFont            = {\udiss@ttslfont},%
  BoldSlantedFont        = {\udiss@ttbfslfont},%
  \ifLuaTeX
    Renderer             = {HarfBuzz},%
  \fi
  \udiss@ttfeatures
]{\udiss@ttfont}
\RequirePackage{unicode-math}
\expanded{%
  \setmathfont[%
    \ifudiss@ignorefontspec%
      IgnoreFontspecFile,%
    \fi%
    \ifudiss@explicitext
      Extension            = {.\udiss@mathfntext},%
    \fi
    BoldFont               = {\udiss@mathbffont},%
    SlantedFont            = {\udiss@mathfont},%
    BoldSlantedFont        = {\udiss@mathbffont},%
    \udiss@mathfeatures%
  ]{\udiss@mathfont}%
}
\RequirePackage{graphicx}
\RequirePackage{xcolor}
\RequirePackage{csquotes}
\ifudiss@ccbysa
  \RequirePackage[%
    hyperxmp           = {false},%
    type               = {CC},%
    modifier           = {by-sa},%
    version            = {4.0}%
  ]{doclicense}
\fi
\ifudiss@colors
  \colorlet{udisslink}{red!60!black}
  \colorlet{udissurl}{blue!60!black}
  \colorlet{udisscite}{green!60!black}
\else
  \colorlet{udisslink}{black}
  \colorlet{udissurl}{black}
  \colorlet{udisscite}{black}
\fi
\AddToHook{begindocument/before}{%
  \ifdefined\udiss@title
  \else
    \def\udiss@title{\textbf{-NoValidTitle-}}%
    \ClassError{udiss}{%
      Title not given%
    }{%
      `title' is a compulsory field. Provide it in the
      preamble like in the following:%
      \MessageBreak
      \MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\title{title-of-the-dissertation}%
      \MessageBreak\MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@author
  \else
    \def\udiss@author{\textbf{-NoValidAuthor-}}%
    \ClassError{udiss}{%
      No author given in a normal (non-blind) document%
    }{%
      Do you want a blind document? If yes, then use the
      package option `blind' like\MessageBreak in the
      following:%
      \MessageBreak
      ----8<------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\documentclass[blind]{udiss}%
      \MessageBreak\MessageBreak
      ----8<------------------8<----%
      \MessageBreak
      Otherwise, `author' is a compulsory field. Provide it
      in the preamble like in\MessageBreak the following:%
      \MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\author{author-name}%
      \MessageBreak\MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@stream
  \else
    \def\udiss@stream{\textbf{-NoValidStream-}}%
    \ClassError{udiss}{%
      Stream not given%
    }{%
      `stream' is a compulsory field. Provide it in the
      preamble like in the following:%
      \MessageBreak
      \MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\stream{stream-of-the-candidate}%
      \MessageBreak\MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@discipline
  \else
    \def\udiss@discipline{\textbf{-NoValidDiscipline-}}%
    \ClassError{udiss}{%
      Discipline not given%
    }{%
      `discipline' is a compulsory field. Provide it in the
      preamble like in the following:%
      \MessageBreak
      \MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\discipline%
      {discipline-of-the-candidate}%
      \MessageBreak\MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@degree
  \else
    \def\udiss@degree{\textbf{-NoValidDegree-}}%
    \ClassError{udiss}{%
      Degree not given%
    }{%
      `degree' is a compulsory field. Provide it in the
      preamble like in the following:%
      \MessageBreak
      \MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\degree{degree-of-the-candidate}%
      \MessageBreak\MessageBreak
      ----8<-----------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@supervisor
  \else
    \def\udiss@title{\textbf{-NoValidTitle-}}%
    \ClassError{udiss}{%
      No supervisor given in a normal (non-blind) document%
    }{%
      Do you want a blind document? If yes, then use the
      package option `blind' like\MessageBreak in the
      following:%
      \MessageBreak
      ----8<------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\documentclass[blind]{udiss}%
      \MessageBreak\MessageBreak
      ----8<------------------8<----%
      \MessageBreak
      Otherwise, `supervisor' is a compulsory field. Provide
      it in the preamble like\MessageBreak in the
      following:%
      \MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\supervisor{supervisor's-name}%
      \MessageBreak\MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@university
  \else
    \def\udiss@university{\textbf{-NoValidUniversity-}}%
    \ClassError{udiss}{%
      No university given in a normal (non-blind) document%
    }{%
      Do you want a blind document? If yes, then use the
      package option `blind' like\MessageBreak in the
      following:%
      \MessageBreak
      ----8<------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\documentclass[blind]{udiss}%
      \MessageBreak\MessageBreak
      ----8<------------------8<----%
      \MessageBreak
      Otherwise, `university' is a compulsory field. Provide
      it in the preamble like\MessageBreak in the
      following:%
      \MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\university{university-name}%
      \MessageBreak\MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifdefined\udiss@department
  \else
    \def\udiss@department{\textbf{-NoValidDepartment-}}%
    \ClassError{udiss}{%
      No department given in a normal (non-blind) document%
    }{%
      Do you want a blind document? If yes, then use the
      package option `blind' like\MessageBreak in the
      following:%
      \MessageBreak
      ----8<------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\documentclass[blind]{udiss}%
      \MessageBreak\MessageBreak
      ----8<------------------8<----%
      \MessageBreak
      Otherwise, `department'\space is a compulsory field.
      Provide it in the preamble like in\MessageBreak the
      following:%
      \MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak\MessageBreak
      \space\space\string\department{department-name}%
      \MessageBreak\MessageBreak
      ----8<-------------------------8<----%
      \MessageBreak
    }%
  \fi
  \ifudiss@print
  \else
    \RequirePackage{hyperref}%
    \RequirePackage{hyperxmp}%
    \hypersetup{%
      unicode,%
      colorlinks,%
      pdftitle           = {\udiss@title}%
    }%
    \ifudiss@subtitle
      \hypersetup{%
        pdfsubject         = {\udiss@subtitle}%
      }%
    \fi
    \ifudiss@blind
    \else
      \hypersetup{%
        pdfauthor          = {\udiss@author},%
        pdfcopyright       = {%
          \udiss@title\textLF
          \udiss@local@copyright\
          ©
          \udiss@copyrightable@years\
          \udiss@author\textLF
          \udiss@license@notice
        },%
      }%
      \ifudiss@free@culture
        \hypersetup{%
          pdflicenseurl      = {%
            \udiss@free@license@url
          }%
        }%
      \fi
    \fi
    \ifudiss@colors
      \hypersetup{%
        linkcolor        = {\udiss@int@link@color},%
        urlcolor         = {\udiss@int@url@color},%
        citecolor        = {\udiss@int@cite@color}%
      }%
    \else
      \hypersetup{%
        hidelinks%
      }%
    \fi
  \fi
}
\AddToHook{begindocument/end}{%
  \begingroup
  \thispagestyle{titlingpage}%
  \ifudiss@ftitle
    \setlength{\fboxsep}{25pt}%
    \noindent\fbox{%
      \begin{minipage}%
        [c][\dimexpr\textheight-2\fboxsep-2\fboxrule]%
        [c]{\dimexpr\linewidth-2\fboxsep-2\fboxrule}%
  \fi
        \hspace{0pt}%
        \vspace{3em}%
        \begin{center}
          \begingroup
          \udiss@title@shape
          \ifx\udiss@title@font\empty
          \else
            \fontspec[\udiss@title@fontfeats]%
                     {\udiss@title@font}%
          \fi
          \udiss@title@size
          \color{\udiss@title@color}%
          \udiss@title
          \endgroup

          \medskip

          \ifudiss@subtitle
            \begingroup
            \udiss@subtitle@shape
            \ifx\udiss@subtitle@font\empty
            \else
              \fontspec[\udiss@subtitle@fontfeats]%
                       {\udiss@subtitle@font}%
            \fi
            \udiss@subtitle@size
            \color{\udiss@subtitle@color}%
            \udiss@subtitle
            \endgroup
          \fi

          \vfill

          \ifudiss@blind
          \else
            \begingroup
            \udiss@author@shape
            \ifx\udiss@author@font\empty
            \else
              \fontspec[\udiss@author@fontfeats]%
                       {\udiss@author@font}%
            \fi
            \udiss@author@size
            \color{\udiss@author@color}%
            \udiss@author
            \ifudiss@pronouns
              \begingroup
              \space
              \addfontfeature{Scale={0.6}}%
              \udiss@pronouns
              \endgroup
            \fi
            \endgroup

          \vspace{2em}%
          \fi

          \begingroup
          \udiss@fulfilment@shape
          \ifx\udiss@fulfilment@font\empty
          \else
            \fontspec[\udiss@fulfilment@fontfeats]%
                     {\udiss@fulfilment@font}%
          \fi
          \udiss@fulfilment@size
          \color{\udiss@fulfilment@color}%
          \udiss@fulfilment
          \endgroup

          \vfill

          \begingroup
          \udiss@uni@shape
          \ifx\udiss@uni@font\empty
          \else
            \fontspec[\udiss@university@fontfeats]%
                     {\udiss@uni@font}%
          \fi
          \udiss@uni@size
          \color{\udiss@uni@color}%
          \udiss@university
          \endgroup

          \vspace{0.5em}%

          \begingroup
          \udiss@dept@shape
          \ifx\udiss@dept@font\empty
          \else
            \fontspec[\udiss@dept@fontfeats]%
                     {\udiss@dept@font}%
          \fi
          \udiss@dept@size
          \color{\udiss@dept@color}%
          \udiss@department
          \endgroup

          \ifudiss@logo
            \bigskip
            \ifudiss@texlogo
              \udiss@texlogo
            \fi
            \includegraphics[%
              width        = {%
                \udiss@logo@width\linewidth
              },%
              height       = {%
                \udiss@logo@hght\textheight
              }%
            ]{%
              \udiss@logo
            }%
          \fi
        \end{center}
  \ifudiss@ftitle
      \end{minipage}%
    }%
  \fi

  \newpage

  \ifudiss@blind
  \else
    \ifudiss@free@culture
      \thispagestyle{titlingpage}%
      \vspace*{\stretch{1}}
      \begin{quote}
        \setlength{\parindent}{0pt}%
        \begingroup
        \begin{minipage}{\linewidth}
          \bfseries
          \udiss@title

          \udiss@local@copyright\
          ©
          \udiss@copyrightable@years\
          \udiss@author

          \medskip
          \noindent\hrule \linewidth 0.4pt\relax
        \end{minipage}
        \endgroup

        \ifudiss@gfdl
          Permission is granted to copy, distribute and/or
          modify this document under the terms of the GNU
          Free Documentation License, Version 1.3 or any
          later version published by the Free Software
          Foundation; with no Invariant Sections, no
          Front-Cover Texts, and no Back-Cover Texts. A copy
          of the license is included in the section entitled
          \enquote{GNU Free Documentation License}.%
        \fi
        \ifudiss@ccbysa
          \begin{minipage}{\linewidth}
            \doclicenseThis
          \end{minipage}
        \fi
        \vspace{\stretch{3}}
      \end{quote}
      \newpage
    \fi
  \fi

  \tableofcontents*

  \newpage

  \ifudiss@blind
  \else
    \ifudiss@declaration
      \thispagestyle{empty}%
      \begin{center}%
        {%
          \LARGE\bfseries
          \udiss@decllocal
        }%
      \end{center}%

      \udiss@declaration
    \fi
  \fi

  \newpage

  \ifudiss@lot
    \listoftables
  \fi

  \newpage

  \ifudiss@lof
    \listoffigures
  \fi
  \endgroup
}%
\ifudiss@blind
\else
  \ifudiss@gfdl
    \AddToHook{enddocument}{%
      \newpage
      \begingroup
      \pagestyle{plain}%
      \addcontentsline{toc}%
                      {chapter}%
                      {GNU Free Documentation License}%
      \input{gfdl-tex-1p3}%
      \clearpage
      \endgroup
    }%
  \fi
\fi
\endinput
%%
%% End of file `udiss.cls'.
