
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kcolorschemewatcher_wrapper.h"

// Wrappers providing overrides
#include "ksystemclipboard_wrapper.h"

// Argument includes
#include <kcolorschemewatcher.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KColorSchemeWatcher_Type = nullptr;
static PyTypeObject *Sbk_KColorSchemeWatcher_TypeF(void)
{
    return _Sbk_KColorSchemeWatcher_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KColorSchemeWatcherWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KColorSchemeWatcherWrapper::KColorSchemeWatcherWrapper(::QObject * parent) : KColorSchemeWatcher(parent)
{
}

void KColorSchemeWatcherWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_childEvent("KColorSchemeWatcher", funcName, gil, pyOverride, event);
}

void KColorSchemeWatcherWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KColorSchemeWatcher", funcName, gil, pyOverride, signal);
}

void KColorSchemeWatcherWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_customEvent("KColorSchemeWatcher", funcName, gil, pyOverride, event);
}

void KColorSchemeWatcherWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSystemClipboardWrapper::sbk_o_connectNotify("KColorSchemeWatcher", funcName, gil, pyOverride, signal);
}

bool KColorSchemeWatcherWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSystemClipboardWrapper::sbk_o_event("KColorSchemeWatcher", funcName, gil, pyOverride, event);
}

bool KColorSchemeWatcherWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSystemClipboardWrapper::sbk_o_eventFilter("KColorSchemeWatcher", funcName, gil, pyOverride, watched, event);
}

void KColorSchemeWatcherWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KColorSchemeWatcher_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSystemClipboardWrapper::sbk_o_timerEvent("KColorSchemeWatcher", funcName, gil, pyOverride, event);
}

const QMetaObject *KColorSchemeWatcherWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KColorSchemeWatcher::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KColorSchemeWatcherWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KColorSchemeWatcher::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KColorSchemeWatcherWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KColorSchemeWatcherWrapper *>(this));
    }
    return KColorSchemeWatcher::qt_metacast(_clname);
}

KColorSchemeWatcherWrapper::~KColorSchemeWatcherWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KColorSchemeWatcher_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KColorSchemeWatcher_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KColorSchemeWatcher >()))
        return -1;

    KColorSchemeWatcherWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KColorSchemeWatcher", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KColorSchemeWatcher::KColorSchemeWatcher(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KColorSchemeWatcher(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KColorSchemeWatcher(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        Shiboken::Warnings::warnDeprecated("KColorSchemeWatcher", "KColorSchemeWatcher(QObject *parent)");
        if (Shiboken::Errors::occurred() != nullptr)
            return -1;
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KColorSchemeWatcher(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KColorSchemeWatcherWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KColorSchemeWatcherWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KColorSchemeWatcher >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KColorSchemeWatcherFunc_systemPreference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KColorSchemeWatcher *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // systemPreference()const
        KColorSchemeWatcher::ColorPreference cppResult = const_cast<const ::KColorSchemeWatcher *>(cppSelf)->systemPreference();
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_ColorPreference_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KColorSchemeWatcher_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_KColorSchemeWatcher_EnumFlagInfo[] = {
    "ColorPreference:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KColorSchemeWatcher_methods[] = {
    {"systemPreference", reinterpret_cast<PyCFunction>(Sbk_KColorSchemeWatcherFunc_systemPreference), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KColorSchemeWatcher_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KColorSchemeWatcher *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KColorSchemeWatcherWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KColorSchemeWatcher_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KColorSchemeWatcher_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KColorSchemeWatcher_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KColorSchemeWatcher_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KColorSchemeWatcher_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KColorSchemeWatcher_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KColorSchemeWatcher_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KColorSchemeWatcher_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KColorSchemeWatcher_spec = {
    "1:KGuiAddons.KColorSchemeWatcher",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KColorSchemeWatcher_slots
};

} //extern "C"

static void *Sbk_KColorSchemeWatcher_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KColorSchemeWatcher *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_KColorSchemeWatcher_ColorPreference(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::KColorSchemeWatcher::ColorPreference>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::KColorSchemeWatcher::ColorPreference *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_KColorSchemeWatcher_ColorPreference_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_ColorPreference_IDX])))
        return Enum_PythonToCpp_KColorSchemeWatcher_ColorPreference;
    return {};
}

static PyObject *KColorSchemeWatcher_ColorPreference_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::KColorSchemeWatcher::ColorPreference>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::KColorSchemeWatcher::ColorPreference *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KColorSchemeWatcher_PythonToCpp_KColorSchemeWatcher_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KColorSchemeWatcher_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KColorSchemeWatcher_PythonToCpp_KColorSchemeWatcher_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KColorSchemeWatcher_TypeF()))
        return KColorSchemeWatcher_PythonToCpp_KColorSchemeWatcher_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KColorSchemeWatcher_PTR_CppToPython_KColorSchemeWatcher(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KColorSchemeWatcher *>(const_cast<void *>(cppIn)), Sbk_KColorSchemeWatcher_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KColorSchemeWatcher_SignatureStrings[] = {
    "KGuiAddons.KColorSchemeWatcher(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KGuiAddons.KColorSchemeWatcher.systemPreference(self)->KGuiAddons.KColorSchemeWatcher.ColorPreference",
    nullptr}; // Sentinel
#else
static constexpr size_t KColorSchemeWatcher_SignatureByteSize = 113;
static constexpr uint8_t KColorSchemeWatcher_SignatureBytes[113] = {
    0x78, 0xda, 0xf3, 0x76, 0x2f, 0xcd, 0x74, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6, 0xf3, 0x76, 0xce,
    0xcf, 0xc9, 0x2f, 0x0a, 0x4e, 0xce, 0x48, 0xcd, 0x4d, 0x0d, 0x4f, 0x2c, 0x01, 0xd2, 0x45, 0x1a,
    0xc5, 0xa9, 0x39, 0x69, 0x3a, 0x05, 0x89, 0x45, 0xa9, 0x79, 0x25, 0x56, 0x01, 0x95, 0xc1, 0x99,
    0x29, 0xa9, 0x66, 0x7a, 0x81, 0x25, 0xce, 0xf9, 0x45, 0xa9, 0x7a, 0x81, 0xfe, 0x49, 0x59, 0xa9,
    0xc9, 0x25, 0xb6, 0x79, 0xa5, 0x39, 0x39, 0x05, 0x25, 0x45, 0x9a, 0x5c, 0xde, 0x78, 0x8d, 0xd2,
    0x2b, 0xae, 0x2c, 0x2e, 0x49, 0xcd, 0x0d, 0x28, 0x4a, 0x4d, 0x4b, 0x05, 0x1a, 0x97, 0x9c, 0x0a,
    0x36, 0x5b, 0x53, 0xd7, 0x8e, 0x80, 0x36, 0xb0, 0x10, 0x42, 0x17, 0x17, 0x00, 0xca, 0xf6, 0x41,
    0xb4
};
#endif

PyTypeObject *init_KColorSchemeWatcher(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX].type;

    Shiboken::AutoDecRef Sbk_KColorSchemeWatcher_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KColorSchemeWatcher_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KColorSchemeWatcher",
        "KColorSchemeWatcher*",
        &Sbk_KColorSchemeWatcher_spec,
        &Shiboken::callCppDestructor< KColorSchemeWatcher >,
        Sbk_KColorSchemeWatcher_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KColorSchemeWatcher_Type; // references _Sbk_KColorSchemeWatcher_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KColorSchemeWatcher_SignatureStrings);
#else
    InitSignatureBytes(pyType, KColorSchemeWatcher_SignatureBytes, KColorSchemeWatcher_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KColorSchemeWatcher_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KColorSchemeWatcher_PythonToCpp_KColorSchemeWatcher_PTR,
        is_KColorSchemeWatcher_PythonToCpp_KColorSchemeWatcher_PTR_Convertible,
        KColorSchemeWatcher_PTR_CppToPython_KColorSchemeWatcher);

    Shiboken::Conversions::registerConverterName(converter, "KColorSchemeWatcher");
    Shiboken::Conversions::registerConverterName(converter, "KColorSchemeWatcher*");
    Shiboken::Conversions::registerConverterName(converter, "KColorSchemeWatcher&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KColorSchemeWatcher).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KColorSchemeWatcherWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KColorSchemeWatcher_TypeF(), &Sbk_KColorSchemeWatcher_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_KColorSchemeWatcher_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'ColorPreference'.
    const char *ColorPreference_Initializer[] = {
        "NoPreference",
        "PreferDark",
        "PreferLight",
        "PreferHighContrast",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t ColorPreference_InitializerValues[] = {
        uint8_t(KColorSchemeWatcher::ColorPreference::NoPreference),      //  0x00  0
        uint8_t(KColorSchemeWatcher::ColorPreference::PreferDark),        //  0x01  1
        uint8_t(KColorSchemeWatcher::ColorPreference::PreferLight),       //  0x02  2
        uint8_t(KColorSchemeWatcher::ColorPreference::PreferHighContrast) //  0x03  3
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_KColorSchemeWatcher_TypeF(),
        "1:KGuiAddons.KColorSchemeWatcher.ColorPreference",
        ColorPreference_Initializer, ColorPreference_InitializerValues);
    SbkKGuiAddonsTypeStructs[SBK_KColorSchemeWatcher_ColorPreference_IDX].type = EType;
    // Register converter for enum 'KColorSchemeWatcher::ColorPreference'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            KColorSchemeWatcher_ColorPreference_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_KColorSchemeWatcher_ColorPreference,
            is_Enum_PythonToCpp_KColorSchemeWatcher_ColorPreference_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "KColorSchemeWatcher::ColorPreference");
        Shiboken::Conversions::registerConverterAlias(converter, "ColorPreference");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'ColorPreference' enum.

    PySide::Signal::registerSignals(pyType, &::KColorSchemeWatcher::staticMetaObject);
    qRegisterMetaType< ::KColorSchemeWatcher::ColorPreference >("KColorSchemeWatcher::ColorPreference");
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KColorSchemeWatcher::staticMetaObject, sizeof(KColorSchemeWatcherWrapper));

    return pyType;
}
