/* AllTray.c generated by valac 0.10.4, the Vala compiler
 * generated from AllTray.vala, do not modify */

/* -*- mode: vala; c-basic-offset: 2; tab-width: 8; -*-
 * AllTray.vala - Entrypoint for AllTray.
 * Copyright (c) 2009 Michael B. Trausch <mike@trausch.us>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libwnck/libwnck.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <config.h>
#include <signal.h>


#define ALL_TRAY_TYPE_PROGRAM (all_tray_program_get_type ())
#define ALL_TRAY_PROGRAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_PROGRAM, AllTrayProgram))
#define ALL_TRAY_PROGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_PROGRAM, AllTrayProgramClass))
#define ALL_TRAY_IS_PROGRAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_PROGRAM))
#define ALL_TRAY_IS_PROGRAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_PROGRAM))
#define ALL_TRAY_PROGRAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_PROGRAM, AllTrayProgramClass))

typedef struct _AllTrayProgram AllTrayProgram;
typedef struct _AllTrayProgramClass AllTrayProgramClass;
typedef struct _AllTrayProgramPrivate AllTrayProgramPrivate;

#define ALL_TRAY_TYPE_PROCESS (all_tray_process_get_type ())
#define ALL_TRAY_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_PROCESS, AllTrayProcess))
#define ALL_TRAY_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_PROCESS, AllTrayProcessClass))
#define ALL_TRAY_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_PROCESS))
#define ALL_TRAY_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_PROCESS))
#define ALL_TRAY_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_PROCESS, AllTrayProcessClass))

typedef struct _AllTrayProcess AllTrayProcess;
typedef struct _AllTrayProcessClass AllTrayProcessClass;

#define ALL_TRAY_TYPE_PROMPT_DIALOG (all_tray_prompt_dialog_get_type ())
#define ALL_TRAY_PROMPT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_PROMPT_DIALOG, AllTrayPromptDialog))
#define ALL_TRAY_PROMPT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_PROMPT_DIALOG, AllTrayPromptDialogClass))
#define ALL_TRAY_IS_PROMPT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_PROMPT_DIALOG))
#define ALL_TRAY_IS_PROMPT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_PROMPT_DIALOG))
#define ALL_TRAY_PROMPT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_PROMPT_DIALOG, AllTrayPromptDialogClass))

typedef struct _AllTrayPromptDialog AllTrayPromptDialog;
typedef struct _AllTrayPromptDialogClass AllTrayPromptDialogClass;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

#define ALL_TRAY_TYPE_CTT (all_tray_ctt_get_type ())
#define ALL_TRAY_CTT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_CTT, AllTrayCtt))
#define ALL_TRAY_CTT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_CTT, AllTrayCttClass))
#define ALL_TRAY_IS_CTT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_CTT))
#define ALL_TRAY_IS_CTT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_CTT))
#define ALL_TRAY_CTT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_CTT, AllTrayCttClass))

typedef struct _AllTrayCtt AllTrayCtt;
typedef struct _AllTrayCttClass AllTrayCttClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _all_tray_ctt_unref0(var) ((var == NULL) ? NULL : (var = (all_tray_ctt_unref (var), NULL)))

#define ALL_TRAY_DEBUG_TYPE_SUBSYSTEM (all_tray_debug_subsystem_get_type ())

#define ALL_TRAY_DEBUG_TYPE_LEVEL (all_tray_debug_level_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	ALL_TRAY_ALL_TRAY_ERROR_SET_PGID_FAILED,
	ALL_TRAY_ALL_TRAY_ERROR_FAILED
} AllTrayAllTrayError;
#define ALL_TRAY_ALL_TRAY_ERROR all_tray_all_tray_error_quark ()
struct _AllTrayProgram {
	GObject parent_instance;
	AllTrayProgramPrivate * priv;
};

struct _AllTrayProgramClass {
	GObjectClass parent_class;
};

struct _AllTrayProgramPrivate {
	char** _args;
	gint _args_length1;
	gint __args_size_;
	char** _cleanArgs;
	gint _cleanArgs_length1;
	gint __cleanArgs_size_;
	GList* _plist;
	GOptionContext* opt_ctx;
	AllTrayPromptDialog* _pd;
};

typedef enum  {
	ALL_TRAY_DEBUG_SUBSYSTEM_None = 0x00,
	ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine = 0x01,
	ALL_TRAY_DEBUG_SUBSYSTEM_Display = 0x02,
	ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon = 0x04,
	ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager = 0x08,
	ALL_TRAY_DEBUG_SUBSYSTEM_Process = 0x10,
	ALL_TRAY_DEBUG_SUBSYSTEM_Misc = 0x20,
	ALL_TRAY_DEBUG_SUBSYSTEM_Bug = 0x40,
	ALL_TRAY_DEBUG_SUBSYSTEM_Application = 0x80,
	ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper = 0x100,
	ALL_TRAY_DEBUG_SUBSYSTEM_Signal = 0x200,
	ALL_TRAY_DEBUG_SUBSYSTEM_Main = 0x400,
	ALL_TRAY_DEBUG_SUBSYSTEM_Ctt = 0x800,
	ALL_TRAY_DEBUG_SUBSYSTEM_All = ((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt
} AllTrayDebugSubsystem;

typedef enum  {
	ALL_TRAY_DEBUG_LEVEL_Information,
	ALL_TRAY_DEBUG_LEVEL_Warning,
	ALL_TRAY_DEBUG_LEVEL_Error,
	ALL_TRAY_DEBUG_LEVEL_Fatal
} AllTrayDebugLevel;

typedef enum  {
	ALL_TRAY_PROCESS_ERROR_SPAWN_FAILED,
	ALL_TRAY_PROCESS_ERROR_PROCESS_DOES_NOT_EXIST,
	ALL_TRAY_PROCESS_ERROR_FAILED
} AllTrayProcessError;
#define ALL_TRAY_PROCESS_ERROR all_tray_process_error_quark ()

static gboolean all_tray_program__attach;
static gboolean all_tray_program__attach = FALSE;
static gint all_tray_program__pid;
static gint all_tray_program__pid = 0;
static gboolean all_tray_program__cl_debug;
static gboolean all_tray_program__cl_debug = FALSE;
static gboolean all_tray_program__cl_dopts;
static gboolean all_tray_program__cl_dopts = FALSE;
static gboolean all_tray_program__display_ver;
static gboolean all_tray_program__display_ver = FALSE;
static gboolean all_tray_program__display_extended_ver;
static gboolean all_tray_program__display_extended_ver = FALSE;
static AllTrayProgram* all_tray_program__instance;
static AllTrayProgram* all_tray_program__instance = NULL;
extern gboolean all_tray_program__ctt_enabled;
gboolean all_tray_program__ctt_enabled = FALSE;
extern AllTrayCtt* all_tray_program__ctt_obj;
AllTrayCtt* all_tray_program__ctt_obj = NULL;
extern gboolean all_tray_program__initially_hide;
gboolean all_tray_program__initially_hide = FALSE;
extern WnckScreen* all_tray_program_WnckScreen;
WnckScreen* all_tray_program_WnckScreen = NULL;
extern GList* all_tray_program_WnckEarlyApps;
GList* all_tray_program_WnckEarlyApps = NULL;
extern GPid all_tray_program_pgid;
GPid all_tray_program_pgid = 0;
extern gboolean all_tray_attach_helper_success;
extern gint all_tray_attach_helper_target_process;
static gpointer all_tray_program_parent_class = NULL;

GQuark all_tray_all_tray_error_quark (void);
GType all_tray_program_get_type (void) G_GNUC_CONST;
GType all_tray_process_get_type (void) G_GNUC_CONST;
GType all_tray_prompt_dialog_get_type (void) G_GNUC_CONST;
#define ALL_TRAY_PROGRAM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALL_TRAY_TYPE_PROGRAM, AllTrayProgramPrivate))
enum  {
	ALL_TRAY_PROGRAM_DUMMY_PROPERTY,
	ALL_TRAY_PROGRAM_ARGS
};
static void _g_list_free_g_object_unref (GList* self);
gpointer all_tray_ctt_ref (gpointer instance);
void all_tray_ctt_unref (gpointer instance);
GParamSpec* all_tray_param_spec_ctt (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void all_tray_value_set_ctt (GValue* value, gpointer v_object);
void all_tray_value_take_ctt (GValue* value, gpointer v_object);
gpointer all_tray_value_get_ctt (const GValue* value);
GType all_tray_ctt_get_type (void) G_GNUC_CONST;
AllTrayProgram* all_tray_program_new (char*** args, int* args_length1);
AllTrayProgram* all_tray_program_construct (GType object_type, char*** args, int* args_length1);
static char** _vala_array_dup1 (char** self, int length);
char** all_tray_program_command_line_init (AllTrayProgram* self, char*** args, int* args_length1, int* result_length1);
AllTrayCtt* all_tray_ctt_new (void);
AllTrayCtt* all_tray_ctt_construct (GType object_type);
GType all_tray_debug_subsystem_get_type (void) G_GNUC_CONST;
GType all_tray_debug_level_get_type (void) G_GNUC_CONST;
void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg);
static void all_tray_program_display_version (AllTrayProgram* self);
static void all_tray_program_display_extended_version (AllTrayProgram* self);
void all_tray_debug_notification_display_debug_list (void);
void all_tray_debug_notification_init (void);
static char** _vala_array_dup2 (char** self, int length);
static void all_tray_program_maybe_set_pgid (AllTrayProgram* self);
gint all_tray_program_run (AllTrayProgram* self);
static void all_tray_program_install_signal_handlers (AllTrayProgram* self);
static void all_tray_program_prompt_and_attach (AllTrayProgram* self);
static void all_tray_program_attach_to_pid (AllTrayProgram* self, gint pid);
static void all_tray_program_display_help (AllTrayProgram* self);
static void all_tray_program_spawn_new_process (AllTrayProgram* self, GError** error);
static gboolean all_tray_program_delete_pd_window (AllTrayProgram* self);
static void all_tray_program_get_app_early (AllTrayProgram* self, WnckScreen* scr, WnckApplication* app);
AllTrayPromptDialog* all_tray_prompt_dialog_new (void);
AllTrayPromptDialog* all_tray_prompt_dialog_construct (GType object_type);
static void _all_tray_program_get_app_early_wnck_screen_application_opened (WnckScreen* _sender, WnckApplication* app, gpointer self);
gboolean all_tray_attach_helper_get_target_window (void);
static gboolean _all_tray_attach_helper_get_target_window_gsource_func (gpointer self);
static gboolean _all_tray_program_delete_pd_window_gsource_func (gpointer self);
static char** all_tray_program_get_command_line (AllTrayProgram* self, char** args, int args_length1, int* result_length1);
AllTrayProcess* all_tray_process_new (char** argv, int argv_length1);
AllTrayProcess* all_tray_process_construct (GType object_type, char** argv, int argv_length1);
static void all_tray_program_cleanup_for_process (AllTrayProgram* self, AllTrayProcess* p);
static void _all_tray_program_cleanup_for_process_all_tray_process_process_died (AllTrayProcess* _sender, AllTrayProcess* p, gpointer self);
GQuark all_tray_process_error_quark (void);
void all_tray_process_run (AllTrayProcess* self, GError** error);
gboolean all_tray_process_get_running (AllTrayProcess* self);
gint all_tray_program_main (char** args, int args_length1);
static void all_tray_program_sighandler (gint caught_signal);
static void _all_tray_program_sighandler_sighandler_t (gint signal);
void all_tray_process_set_visible (AllTrayProcess* self, gboolean value);
GPid all_tray_process_get_pid (AllTrayProcess* self);
char** all_tray_program_get_args (AllTrayProgram* self, int* result_length1);
static void all_tray_program_finalize (GObject* obj);
static void all_tray_program_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);

static const GOptionEntry ALL_TRAY_PROGRAM__acceptedCmdLineOptions[9] = {{"attach", 'a', 0, G_OPTION_ARG_NONE, &all_tray_program__attach, N_ ("Attach to a running program"), NULL}, {"enable-ctt", 'C', 0, G_OPTION_ARG_NONE, &all_tray_program__ctt_enabled, N_ ("Enable Close-To-Tray support"), NULL}, {"debug", 'D', (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &all_tray_program__cl_debug, N_ ("Enable debugging messages"), NULL}, {"list-debug-opts", 'L', (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &all_tray_program__cl_dopts, N_ ("Show types of debugging messages"), NULL}, {"hide", 'H', 0, G_OPTION_ARG_NONE, &all_tray_program__initially_hide, N_ ("Initially hide on spawn/attach"), NULL}, {"process", 'p', 0, G_OPTION_ARG_INT, &all_tray_program__pid, N_ ("Attach to already-running application"), "PID"}, {"version", 'v', 0, G_OPTION_ARG_NONE, &all_tray_program__display_ver, N_ ("Display AllTray version info and exit"), NULL}, {"extended-version", 'V', 0, G_OPTION_ARG_NONE, &all_tray_program__display_extended_ver, N_ ("Display extended version info and exit"), NULL}, {NULL}};


GQuark all_tray_all_tray_error_quark (void) {
	return g_quark_from_static_string ("all_tray_all_tray_error-quark");
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static char** _vala_array_dup1 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


AllTrayProgram* all_tray_program_construct (GType object_type, char*** args, int* args_length1) {
	AllTrayProgram * self = NULL;
	char** _tmp0_;
	char** _tmp1_;
	gint _tmp2_;
	char** _tmp3_;
	self = (AllTrayProgram*) g_object_new (object_type, NULL);
	self->priv->_args = (_tmp1_ = (_tmp0_ = *args, (_tmp0_ == NULL) ? ((gpointer) _tmp0_) : _vala_array_dup1 (_tmp0_, *args_length1)), self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL), self->priv->_args_length1 = *args_length1, self->priv->__args_size_ = self->priv->_args_length1, _tmp1_);
	gdk_init (&self->priv->_args_length1, &self->priv->_args);
	self->priv->_cleanArgs = (_tmp3_ = all_tray_program_command_line_init (self, &self->priv->_args, &self->priv->_args_length1, &_tmp2_), self->priv->_cleanArgs = (_vala_array_free (self->priv->_cleanArgs, self->priv->_cleanArgs_length1, (GDestroyNotify) g_free), NULL), self->priv->_cleanArgs_length1 = _tmp2_, self->priv->__cleanArgs_size_ = self->priv->_cleanArgs_length1, _tmp3_);
	if (all_tray_program__ctt_enabled == TRUE) {
		AllTrayCtt* _tmp4_;
		all_tray_program__ctt_obj = (_tmp4_ = all_tray_ctt_new (), _all_tray_ctt_unref0 (all_tray_program__ctt_obj), _tmp4_);
	}
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Command line options parsed."));
	return self;
}


AllTrayProgram* all_tray_program_new (char*** args, int* args_length1) {
	return all_tray_program_construct (ALL_TRAY_TYPE_PROGRAM, args, args_length1);
}


static char** _vala_array_dup2 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


char** all_tray_program_command_line_init (AllTrayProgram* self, char*** args, int* args_length1, int* result_length1) {
	char** result = NULL;
	char* default_flags;
	gint env_args_length1;
	gint _env_args_size_;
	char** _tmp0_;
	char** env_args;
	GOptionContext* _tmp3_;
	gboolean _tmp4_ = FALSE;
	char** _tmp8_;
	char** _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	gtk_init (args_length1, args);
	default_flags = g_strdup (g_getenv ("ALLTRAY_OPTIONS"));
	env_args = (_tmp0_ = NULL, env_args_length1 = 0, _env_args_size_ = env_args_length1, _tmp0_);
	if (default_flags != NULL) {
		GString* sb;
		char** _tmp1_;
		char** _tmp2_;
		sb = g_string_new ("");
		g_string_append_printf (sb, "%s", (*args)[0]);
		g_string_append_printf (sb, " %s", default_flags);
		env_args = (_tmp2_ = _tmp1_ = g_strsplit (sb->str, " ", 0), env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL), env_args_length1 = _vala_array_length (_tmp1_), _env_args_size_ = env_args_length1, _tmp2_);
		_g_string_free0 (sb);
	}
	self->priv->opt_ctx = (_tmp3_ = g_option_context_new (_ ("- Dock software to the systray")), _g_option_context_free0 (self->priv->opt_ctx), _tmp3_);
	g_option_context_add_main_entries (self->priv->opt_ctx, ALL_TRAY_PROGRAM__acceptedCmdLineOptions, NULL);
	g_option_context_add_group (self->priv->opt_ctx, gtk_get_option_group (TRUE));
	if (env_args != NULL) {
		{
			g_option_context_parse (self->priv->opt_ctx, &env_args_length1, &env_args, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_OPTION_ERROR) {
					goto __catch0_g_option_error;
				}
				env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (default_flags);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		goto __finally0;
		__catch0_g_option_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				fprintf (stderr, _ ("error: env flag parsing failed (%s)\n"), e->message);
				exit (1);
				_g_error_free0 (e);
			}
		}
		__finally0:
		if (_inner_error_ != NULL) {
			env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (default_flags);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	{
		g_option_context_parse (self->priv->opt_ctx, args_length1, args, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch1_g_option_error;
			}
			env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (default_flags);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally1;
	__catch1_g_option_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, _ ("error: command line parsing failed (%s)\n"), e->message);
			exit (1);
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (default_flags);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (all_tray_program__display_ver) {
		_tmp4_ = !all_tray_program__display_extended_ver;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		all_tray_program_display_version (self);
		exit (0);
	}
	if (all_tray_program__display_extended_ver) {
		all_tray_program_display_extended_version (self);
		exit (0);
	}
	if (all_tray_program__cl_dopts) {
		all_tray_debug_notification_display_debug_list ();
		exit (0);
	}
	all_tray_program_display_version (self);
	if (all_tray_program__cl_debug) {
		all_tray_debug_notification_init ();
	}
	if (_vala_strcmp0 ((*args)[1], "--") == 0) {
		GString* sb;
		gint newargs_length1;
		gint _newargs_size_;
		char** _tmp6_;
		char** _tmp5_;
		char** newargs;
		char** _tmp7_;
		sb = g_string_new ("");
		{
			char** arg_collection;
			int arg_collection_length1;
			int arg_it;
			arg_collection = *args;
			arg_collection_length1 = *args_length1;
			for (arg_it = 0; arg_it < (*args_length1); arg_it = arg_it + 1) {
				char* arg;
				arg = g_strdup (arg_collection[arg_it]);
				{
					if (_vala_strcmp0 (arg, "--") == 0) {
						_g_free0 (arg);
						continue;
					}
					g_string_append_printf (sb, "%s@&@", arg);
					_g_free0 (arg);
				}
			}
		}
		newargs = (_tmp6_ = _tmp5_ = g_strsplit (sb->str, "@&@", 0), newargs_length1 = _vala_array_length (_tmp5_), _newargs_size_ = newargs_length1, _tmp6_);
		result = (_tmp7_ = newargs, *result_length1 = newargs_length1, _tmp7_);
		_g_string_free0 (sb);
		env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (default_flags);
		return result;
		newargs = (_vala_array_free (newargs, newargs_length1, (GDestroyNotify) g_free), NULL);
		_g_string_free0 (sb);
	}
	result = (_tmp9_ = (_tmp8_ = *args, (_tmp8_ == NULL) ? ((gpointer) _tmp8_) : _vala_array_dup2 (_tmp8_, *args_length1)), *result_length1 = *args_length1, _tmp9_);
	env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (default_flags);
	return result;
	env_args = (_vala_array_free (env_args, env_args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (default_flags);
}


static void all_tray_program_maybe_set_pgid (AllTrayProgram* self) {
	GPid cur_pgid;
	GPid needed_pgid;
	g_return_if_fail (self != NULL);
	cur_pgid = (GPid) getpgrp ();
	needed_pgid = (GPid) getpid ();
	if (cur_pgid != needed_pgid) {
		gint status;
		status = setpgid ((pid_t) 0, (pid_t) 0);
		if (status == (-1)) {
			g_warning ("AllTray.vala:165: %s", _ ("set pgid failed; alltray may behave strangely."));
			return;
		}
		all_tray_program_pgid = (GPid) getpgrp ();
		return;
	} else {
		all_tray_program_pgid = cur_pgid;
		return;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gint all_tray_program_run (AllTrayProgram* self) {
	gint result = 0;
	GList* _tmp0_;
	WnckScreen* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	self->priv->_plist = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->_plist), _tmp0_);
	wnck_set_client_type (WNCK_CLIENT_TYPE_PAGER);
	all_tray_program_maybe_set_pgid (self);
	all_tray_program_install_signal_handlers (self);
	all_tray_program_WnckScreen = (_tmp1_ = _g_object_ref0 (wnck_screen_get_default ()), _g_object_unref0 (all_tray_program_WnckScreen), _tmp1_);
	if (all_tray_program__attach) {
		_tmp2_ = all_tray_program__pid == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		all_tray_program_prompt_and_attach (self);
	} else {
		if (all_tray_program__pid > 0) {
			all_tray_program_attach_to_pid (self, all_tray_program__pid);
		} else {
			if (self->priv->_cleanArgs_length1 == 1) {
				all_tray_program_display_help (self);
				result = 1;
				return result;
			}
			{
				all_tray_program_spawn_new_process (self, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ALL_TRAY_ALL_TRAY_ERROR) {
						goto __catch2_all_tray_all_tray_error;
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			}
			goto __finally2;
			__catch2_all_tray_all_tray_error:
			{
				GError * e;
				e = _inner_error_;
				_inner_error_ = NULL;
				{
					fprintf (stderr, "%s", e->message);
					result = 1;
					_g_error_free0 (e);
					return result;
				}
			}
			__finally2:
			if (_inner_error_ != NULL) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	gtk_main ();
	result = 0;
	return result;
}


static void all_tray_program_display_version (AllTrayProgram* self) {
	g_return_if_fail (self != NULL);
	if (_vala_strcmp0 (ALLTRAY_BZR_BUILD, "TRUE") == 0) {
		fprintf (stdout, _ ("AllTray %s, from bzr branch %s rev %s,\n rev-id %s\n"), PACKAGE_VERSION, ALLTRAY_BZR_BRANCH, ALLTRAY_BZR_REVISION, ALLTRAY_BZR_REVID);
	} else {
		fprintf (stdout, "AllTray %s\n", PACKAGE_VERSION);
	}
	fprintf (stdout, _ ("Copyright (c) %s Michael B. Trausch <mike@trausch.us>\n"), ALLTRAY_COPYRIGHT_YEARS);
	fprintf (stdout, "%s", _ ("Licensed under the GNU GPL v3.0 as published by the Free Software Foun" \
"dation.\n" \
"\n"));
}


static void all_tray_program_display_extended_version (AllTrayProgram* self) {
	g_return_if_fail (self != NULL);
	all_tray_program_display_version (self);
	fprintf (stdout, _ ("Configured %s on %s %s\n"), ALLTRAY_COMPILE_BUILD_DATE, ALLTRAY_COMPILE_OS, ALLTRAY_COMPILE_OS_REL);
	fprintf (stdout, _ ("Compilers: %s and %s\n"), ALLTRAY_VALA_COMPILER, ALLTRAY_C_COMPILER);
	if (_vala_strcmp0 (ALLTRAY_CONFIGURE_FLAGS, "") == 0) {
		fprintf (stdout, "%s", _ ("Configure was run without flags\n"));
	} else {
		fprintf (stdout, _ ("Configure flags: %s\n"), ALLTRAY_CONFIGURE_FLAGS);
	}
}


static gboolean all_tray_program_delete_pd_window (AllTrayProgram* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_object_destroy ((GtkObject*) self->priv->_pd);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Misc, ALL_TRAY_DEBUG_LEVEL_Information, "delete_pd_window()");
	result = FALSE;
	return result;
}


static void all_tray_program_get_app_early (AllTrayProgram* self, WnckScreen* scr, WnckApplication* app) {
	GString* msg;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scr != NULL);
	g_return_if_fail (app != NULL);
	msg = g_string_new ("");
	g_string_append_printf (msg, _ ("Adding app (pid %d) to list of recv'd apps"), wnck_application_get_pid (app));
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Application, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
	all_tray_program_WnckEarlyApps = g_list_append (all_tray_program_WnckEarlyApps, _g_object_ref0 (app));
	_g_string_free0 (msg);
}


static void _all_tray_program_get_app_early_wnck_screen_application_opened (WnckScreen* _sender, WnckApplication* app, gpointer self) {
	all_tray_program_get_app_early (self, _sender, app);
}


static gboolean _all_tray_attach_helper_get_target_window_gsource_func (gpointer self) {
	gboolean result;
	result = all_tray_attach_helper_get_target_window ();
	return result;
}


static gboolean _all_tray_program_delete_pd_window_gsource_func (gpointer self) {
	gboolean result;
	result = all_tray_program_delete_pd_window (self);
	return result;
}


static void all_tray_program_prompt_and_attach (AllTrayProgram* self) {
	AllTrayPromptDialog* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->_pd = (_tmp0_ = g_object_ref_sink (all_tray_prompt_dialog_new ()), _g_object_unref0 (self->priv->_pd), _tmp0_);
	all_tray_program_WnckEarlyApps = (_tmp1_ = NULL, __g_list_free_g_object_unref0 (all_tray_program_WnckEarlyApps), _tmp1_);
	g_signal_connect_object (all_tray_program_WnckScreen, "application-opened", (GCallback) _all_tray_program_get_app_early_wnck_screen_application_opened, self, 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->_pd);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _all_tray_attach_helper_get_target_window_gsource_func, NULL, NULL);
	gtk_main ();
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _all_tray_program_delete_pd_window_gsource_func, g_object_ref (self), g_object_unref);
	g_signal_parse_name ("application-opened", WNCK_TYPE_SCREEN, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (all_tray_program_WnckScreen, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _all_tray_program_get_app_early_wnck_screen_application_opened, self);
	if (all_tray_attach_helper_success == FALSE) {
		fprintf (stderr, "%s", _ ("Failed to get a window; exiting.\n"));
		exit (1);
	}
	all_tray_program__pid = all_tray_attach_helper_target_process;
	all_tray_program_attach_to_pid (self, all_tray_program__pid);
}


static void all_tray_program_attach_to_pid (AllTrayProgram* self, gint pid) {
	char** _tmp0_ = NULL;
	char** _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->_cleanArgs = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("alltray-internal-fake-process"), _tmp0_[1] = g_strdup_printf ("%i", pid), _tmp0_), self->priv->_cleanArgs = (_vala_array_free (self->priv->_cleanArgs, self->priv->_cleanArgs_length1, (GDestroyNotify) g_free), NULL), self->priv->_cleanArgs_length1 = 2, self->priv->__cleanArgs_size_ = self->priv->_cleanArgs_length1, _tmp1_);
	{
		all_tray_program_spawn_new_process (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ALL_TRAY_ALL_TRAY_ERROR) {
				goto __catch3_all_tray_all_tray_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_all_tray_all_tray_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _all_tray_program_cleanup_for_process_all_tray_process_process_died (AllTrayProcess* _sender, AllTrayProcess* p, gpointer self) {
	all_tray_program_cleanup_for_process (self, p);
}


static void all_tray_program_spawn_new_process (AllTrayProgram* self, GError** error) {
	gint a_length1;
	gint _a_size_;
	char** _tmp1_;
	gint _tmp0_;
	char** a;
	AllTrayProcess* p;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	a = (_tmp1_ = all_tray_program_get_command_line (self, self->priv->_cleanArgs, self->priv->_cleanArgs_length1, &_tmp0_), a_length1 = _tmp0_, _a_size_ = a_length1, _tmp1_);
	p = all_tray_process_new (a, a_length1);
	g_signal_connect_object (p, "process-died", (GCallback) _all_tray_program_cleanup_for_process_all_tray_process_process_died, self, 0);
	{
		all_tray_process_run (p, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ALL_TRAY_PROCESS_ERROR) {
				goto __catch4_all_tray_process_error;
			}
			_g_object_unref0 (p);
			a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_all_tray_process_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GString* msg;
			all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Error, _ ("Oops.  Not running?"));
			msg = g_string_new ("");
			g_string_append_printf (msg, _ ("Failed to start process: %s"), e->message);
			_inner_error_ = g_error_new_literal (ALL_TRAY_ALL_TRAY_ERROR, ALL_TRAY_ALL_TRAY_ERROR_FAILED, msg->str);
			{
				_g_string_free0 (msg);
				_g_error_free0 (e);
				_g_object_unref0 (p);
				a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
				goto __finally4;
			}
			_g_string_free0 (msg);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ALL_TRAY_ALL_TRAY_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (p);
			a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			_g_object_unref0 (p);
			a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	if (!all_tray_process_get_running (p)) {
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Error, _ ("Oops.  Not running?"));
		_inner_error_ = g_error_new_literal (ALL_TRAY_ALL_TRAY_ERROR, ALL_TRAY_ALL_TRAY_ERROR_FAILED, _ ("Failed to start process"));
		{
			if (_inner_error_->domain == ALL_TRAY_ALL_TRAY_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (p);
				a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
				return;
			} else {
				_g_object_unref0 (p);
				a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	self->priv->_plist = g_list_append (self->priv->_plist, _g_object_ref0 (p));
	_g_object_unref0 (p);
	a = (_vala_array_free (a, a_length1, (GDestroyNotify) g_free), NULL);
}


gint all_tray_program_main (char** args, int args_length1) {
	gint result = 0;
	AllTrayProgram* atray;
	AllTrayProgram* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (GETTEXT_PACKAGE);
	atray = all_tray_program_new (&args, &args_length1);
	all_tray_program__instance = (_tmp0_ = _g_object_ref0 (atray), _g_object_unref0 (all_tray_program__instance), _tmp0_);
	result = all_tray_program_run (atray);
	_g_object_unref0 (atray);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return all_tray_program_main (argv, argc);
}


static void all_tray_program_cleanup_for_process (AllTrayProgram* self, AllTrayProcess* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Cleaning up for child..."));
	self->priv->_plist = g_list_remove (self->priv->_plist, p);
	if (g_list_length (self->priv->_plist) == 0) {
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Main, ALL_TRAY_DEBUG_LEVEL_Information, _ ("No more children. Dying."));
		gtk_main_quit ();
	}
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static char** all_tray_program_get_command_line (AllTrayProgram* self, char** args, int args_length1, int* result_length1) {
	char** result = NULL;
	gint curItem;
	gint retval_length1;
	gint _retval_size_;
	char** _tmp0_;
	char** retval;
	char** _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	curItem = 0;
	retval = (_tmp0_ = g_new0 (char*, args_length1 + 1), retval_length1 = args_length1, _retval_size_ = retval_length1, _tmp0_);
	{
		char** arg_collection;
		int arg_collection_length1;
		int arg_it;
		arg_collection = args;
		arg_collection_length1 = args_length1;
		for (arg_it = 0; arg_it < args_length1; arg_it = arg_it + 1) {
			char* arg;
			arg = g_strdup (arg_collection[arg_it]);
			{
				GString* sb;
				gboolean _tmp1_ = FALSE;
				char* *_tmp2_;
				char* _tmp3_;
				sb = g_string_new ("");
				g_string_append_printf (sb, _ ("Evaluating %s"), arg);
				all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine, ALL_TRAY_DEBUG_LEVEL_Information, sb->str);
				if (string_contains (arg, "alltray")) {
					_tmp1_ = !string_contains (arg, "internal-fake-process");
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					_g_string_free0 (sb);
					_g_free0 (arg);
					continue;
				}
				all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine, ALL_TRAY_DEBUG_LEVEL_Information, _ ("Actually processing arg"));
				_tmp2_ = &retval[curItem++];
				(*_tmp2_) = (_tmp3_ = g_strdup (arg), _g_free0 ((*_tmp2_)), _tmp3_);
				_g_string_free0 (sb);
				_g_free0 (arg);
			}
		}
	}
	result = (_tmp4_ = retval, *result_length1 = retval_length1, _tmp4_);
	return result;
	retval = (_vala_array_free (retval, retval_length1, (GDestroyNotify) g_free), NULL);
}


static void _all_tray_program_sighandler_sighandler_t (gint signal) {
	all_tray_program_sighandler (signal);
}


static void all_tray_program_install_signal_handlers (AllTrayProgram* self) {
	g_return_if_fail (self != NULL);
	signal (SIGHUP, _all_tray_program_sighandler_sighandler_t);
	signal (SIGTERM, _all_tray_program_sighandler_sighandler_t);
	signal (SIGINT, _all_tray_program_sighandler_sighandler_t);
}


static void all_tray_program_sighandler (gint caught_signal) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	if (caught_signal == SIGHUP) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = caught_signal == SIGINT;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = caught_signal == SIGTERM;
	}
	if (_tmp0_) {
		{
			GList* p_collection;
			GList* p_it;
			p_collection = all_tray_program__instance->priv->_plist;
			for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
				AllTrayProcess* p;
				p = _g_object_ref0 ((AllTrayProcess*) p_it->data);
				{
					all_tray_process_set_visible (p, TRUE);
					_g_object_unref0 (p);
				}
			}
		}
	} else {
		if (caught_signal == SIGTERM) {
			{
				GList* p_collection;
				GList* p_it;
				p_collection = all_tray_program__instance->priv->_plist;
				for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
					AllTrayProcess* p;
					p = _g_object_ref0 ((AllTrayProcess*) p_it->data);
					{
						kill ((pid_t) ((gint) all_tray_process_get_pid (p)), caught_signal);
						_g_object_unref0 (p);
					}
				}
			}
			gtk_main_quit ();
		} else {
			GString* msg;
			msg = g_string_new ("");
			g_string_append_printf (msg, _ ("Caught unwired signal %d"), caught_signal);
			all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Signal, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
			_g_string_free0 (msg);
		}
	}
}


static void all_tray_program_display_help (AllTrayProgram* self) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	fprintf (stderr, "%s", _tmp0_ = g_option_context_get_help (self->priv->opt_ctx, TRUE, NULL));
	_g_free0 (_tmp0_);
	exit (1);
}


char** all_tray_program_get_args (AllTrayProgram* self, int* result_length1) {
	char** result;
	char** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp0_ = self->priv->_args, *result_length1 = self->priv->_args_length1, _tmp0_);
	return result;
}


static void all_tray_program_class_init (AllTrayProgramClass * klass) {
	all_tray_program_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AllTrayProgramPrivate));
	G_OBJECT_CLASS (klass)->get_property = all_tray_program_get_property;
	G_OBJECT_CLASS (klass)->finalize = all_tray_program_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_PROGRAM_ARGS, g_param_spec_boxed ("args", "args", "args", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void all_tray_program_instance_init (AllTrayProgram * self) {
	self->priv = ALL_TRAY_PROGRAM_GET_PRIVATE (self);
}


static void all_tray_program_finalize (GObject* obj) {
	AllTrayProgram * self;
	self = ALL_TRAY_PROGRAM (obj);
	self->priv->_args = (_vala_array_free (self->priv->_args, self->priv->_args_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_cleanArgs = (_vala_array_free (self->priv->_cleanArgs, self->priv->_cleanArgs_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_object_unref0 (self->priv->_plist);
	_g_option_context_free0 (self->priv->opt_ctx);
	_g_object_unref0 (self->priv->_pd);
	G_OBJECT_CLASS (all_tray_program_parent_class)->finalize (obj);
}


GType all_tray_program_get_type (void) {
	static volatile gsize all_tray_program_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_program_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllTrayProgramClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_tray_program_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllTrayProgram), 0, (GInstanceInitFunc) all_tray_program_instance_init, NULL };
		GType all_tray_program_type_id;
		all_tray_program_type_id = g_type_register_static (G_TYPE_OBJECT, "AllTrayProgram", &g_define_type_info, 0);
		g_once_init_leave (&all_tray_program_type_id__volatile, all_tray_program_type_id);
	}
	return all_tray_program_type_id__volatile;
}


static void all_tray_program_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AllTrayProgram * self;
	int length;
	self = ALL_TRAY_PROGRAM (object);
	switch (property_id) {
		case ALL_TRAY_PROGRAM_ARGS:
		g_value_set_boxed (value, all_tray_program_get_args (self, &length));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




