/* Process.c generated by valac 0.10.4, the Vala compiler
 * generated from Process.vala, do not modify */

/* -*- mode: vala; c-basic-offset: 2; tab-width: 8; -*-
 * Process.vala - Child process management
 * Copyright (c) 2009 Michael B. Trausch <mike@trausch.us>
 * License: GNU GPL v3.0 as published by the Free Software Foundation
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>
#include <gtop_glue.h>
#include <unistd.h>
#include <libwnck/libwnck.h>
#include <stdio.h>


#define ALL_TRAY_TYPE_PROCESS (all_tray_process_get_type ())
#define ALL_TRAY_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_PROCESS, AllTrayProcess))
#define ALL_TRAY_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_PROCESS, AllTrayProcessClass))
#define ALL_TRAY_IS_PROCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_PROCESS))
#define ALL_TRAY_IS_PROCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_PROCESS))
#define ALL_TRAY_PROCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_PROCESS, AllTrayProcessClass))

typedef struct _AllTrayProcess AllTrayProcess;
typedef struct _AllTrayProcessClass AllTrayProcessClass;
typedef struct _AllTrayProcessPrivate AllTrayProcessPrivate;

#define ALL_TRAY_TYPE_APPLICATION (all_tray_application_get_type ())
#define ALL_TRAY_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ALL_TRAY_TYPE_APPLICATION, AllTrayApplication))
#define ALL_TRAY_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ALL_TRAY_TYPE_APPLICATION, AllTrayApplicationClass))
#define ALL_TRAY_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ALL_TRAY_TYPE_APPLICATION))
#define ALL_TRAY_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ALL_TRAY_TYPE_APPLICATION))
#define ALL_TRAY_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ALL_TRAY_TYPE_APPLICATION, AllTrayApplicationClass))

typedef struct _AllTrayApplication AllTrayApplication;
typedef struct _AllTrayApplicationClass AllTrayApplicationClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ALL_TRAY_DEBUG_TYPE_SUBSYSTEM (all_tray_debug_subsystem_get_type ())

#define ALL_TRAY_DEBUG_TYPE_LEVEL (all_tray_debug_level_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	ALL_TRAY_PROCESS_ERROR_SPAWN_FAILED,
	ALL_TRAY_PROCESS_ERROR_PROCESS_DOES_NOT_EXIST,
	ALL_TRAY_PROCESS_ERROR_FAILED
} AllTrayProcessError;
#define ALL_TRAY_PROCESS_ERROR all_tray_process_error_quark ()
struct _AllTrayProcess {
	GObject parent_instance;
	AllTrayProcessPrivate * priv;
};

struct _AllTrayProcessClass {
	GObjectClass parent_class;
};

struct _AllTrayProcessPrivate {
	GPid _child;
	gboolean _running;
	gboolean _timerRunning;
	guint _timerEventSource;
	char** _argv;
	gint _argv_length1;
	gint __argv_size_;
	AllTrayApplication* _app;
};

typedef enum  {
	ALL_TRAY_DEBUG_SUBSYSTEM_None = 0x00,
	ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine = 0x01,
	ALL_TRAY_DEBUG_SUBSYSTEM_Display = 0x02,
	ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon = 0x04,
	ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager = 0x08,
	ALL_TRAY_DEBUG_SUBSYSTEM_Process = 0x10,
	ALL_TRAY_DEBUG_SUBSYSTEM_Misc = 0x20,
	ALL_TRAY_DEBUG_SUBSYSTEM_Bug = 0x40,
	ALL_TRAY_DEBUG_SUBSYSTEM_Application = 0x80,
	ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper = 0x100,
	ALL_TRAY_DEBUG_SUBSYSTEM_Signal = 0x200,
	ALL_TRAY_DEBUG_SUBSYSTEM_Main = 0x400,
	ALL_TRAY_DEBUG_SUBSYSTEM_Ctt = 0x800,
	ALL_TRAY_DEBUG_SUBSYSTEM_All = ((((((((((ALL_TRAY_DEBUG_SUBSYSTEM_CommandLine | ALL_TRAY_DEBUG_SUBSYSTEM_Display) | ALL_TRAY_DEBUG_SUBSYSTEM_TrayIcon) | ALL_TRAY_DEBUG_SUBSYSTEM_WindowManager) | ALL_TRAY_DEBUG_SUBSYSTEM_Process) | ALL_TRAY_DEBUG_SUBSYSTEM_Misc) | ALL_TRAY_DEBUG_SUBSYSTEM_Bug) | ALL_TRAY_DEBUG_SUBSYSTEM_Application) | ALL_TRAY_DEBUG_SUBSYSTEM_AttachHelper) | ALL_TRAY_DEBUG_SUBSYSTEM_Signal) | ALL_TRAY_DEBUG_SUBSYSTEM_Main) | ALL_TRAY_DEBUG_SUBSYSTEM_Ctt
} AllTrayDebugSubsystem;

typedef enum  {
	ALL_TRAY_DEBUG_LEVEL_Information,
	ALL_TRAY_DEBUG_LEVEL_Warning,
	ALL_TRAY_DEBUG_LEVEL_Error,
	ALL_TRAY_DEBUG_LEVEL_Fatal
} AllTrayDebugLevel;


extern GPid all_tray_program_pgid;
extern WnckScreen* all_tray_program_WnckScreen;
static gpointer all_tray_process_parent_class = NULL;

GQuark all_tray_process_error_quark (void);
GType all_tray_process_get_type (void) G_GNUC_CONST;
GType all_tray_application_get_type (void) G_GNUC_CONST;
#define ALL_TRAY_PROCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ALL_TRAY_TYPE_PROCESS, AllTrayProcessPrivate))
enum  {
	ALL_TRAY_PROCESS_DUMMY_PROPERTY,
	ALL_TRAY_PROCESS_RUNNING,
	ALL_TRAY_PROCESS_VISIBLE,
	ALL_TRAY_PROCESS_TIMER_RUNNING,
	ALL_TRAY_PROCESS_TIMER_EVENT_SOURCE
};
AllTrayProcess* all_tray_process_new (char** argv, int argv_length1);
AllTrayProcess* all_tray_process_construct (GType object_type, char** argv, int argv_length1);
static char** _vala_array_dup3 (char** self, int length);
static void all_tray_process_on_ctt (AllTrayProcess* self, gulong XID);
GPid all_tray_process_get_pid (AllTrayProcess* self);
void all_tray_process_run (AllTrayProcess* self, GError** error);
static void all_tray_process_run_fake (AllTrayProcess* self, gint pid, GError** error);
void all_tray_process_child_died (AllTrayProcess* self);
static void _all_tray_process_child_died_gchild_watch_func (GPid pid, gint status, gpointer self);
GType all_tray_debug_subsystem_get_type (void) G_GNUC_CONST;
GType all_tray_debug_level_get_type (void) G_GNUC_CONST;
void all_tray_debug_notification_emit (AllTrayDebugSubsystem subsys, AllTrayDebugLevel lvl, const char* msg);
AllTrayApplication* all_tray_application_new (AllTrayProcess* p);
AllTrayApplication* all_tray_application_construct (GType object_type, AllTrayProcess* p);
void all_tray_process_run_kinda_fake (AllTrayProcess* self, gint pid, GError** error);
static gboolean all_tray_process_process_num_is_alive (AllTrayProcess* self, gint pid);
static gboolean all_tray_process_fake_child_monitor (AllTrayProcess* self);
static gboolean _all_tray_process_fake_child_monitor_gsource_func (gpointer self);
gboolean all_tray_application_get_caught_window (AllTrayApplication* self);
static gboolean all_tray_process_die_if_not_unset (AllTrayProcess* self);
static gboolean _all_tray_process_die_if_not_unset_gsource_func (gpointer self);
static gboolean all_tray_process_really_try_hard (AllTrayProcess* self);
void all_tray_application_maybe_setup_for_pid (AllTrayApplication* self, WnckApplication* app, gint pid);
gboolean all_tray_process_get_running (AllTrayProcess* self);
gboolean all_tray_process_get_visible (AllTrayProcess* self);
gboolean all_tray_application_get_visible (AllTrayApplication* self);
void all_tray_process_set_visible (AllTrayProcess* self, gboolean value);
void all_tray_application_set_visible (AllTrayApplication* self, gboolean value);
gboolean all_tray_process_get_timer_running (AllTrayProcess* self);
guint all_tray_process_get_timer_event_source (AllTrayProcess* self);
static void all_tray_process_finalize (GObject* obj);
static void all_tray_process_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void all_tray_process_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark all_tray_process_error_quark (void) {
	return g_quark_from_static_string ("all_tray_process_error-quark");
}


static char** _vala_array_dup3 (char** self, int length) {
	char** result;
	int i;
	result = g_new0 (char*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


AllTrayProcess* all_tray_process_construct (GType object_type, char** argv, int argv_length1) {
	AllTrayProcess * self = NULL;
	AllTrayApplication* _tmp0_;
	char** _tmp1_;
	char** _tmp2_;
	self = (AllTrayProcess*) g_object_new (object_type, NULL);
	self->priv->_child = (GPid) 0;
	self->priv->_running = FALSE;
	self->priv->_timerRunning = FALSE;
	self->priv->_timerEventSource = (guint) 0;
	self->priv->_app = (_tmp0_ = NULL, _g_object_unref0 (self->priv->_app), _tmp0_);
	self->priv->_argv = (_tmp2_ = (_tmp1_ = argv, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup3 (_tmp1_, argv_length1)), self->priv->_argv = (_vala_array_free (self->priv->_argv, self->priv->_argv_length1, (GDestroyNotify) g_free), NULL), self->priv->_argv_length1 = argv_length1, self->priv->__argv_size_ = self->priv->_argv_length1, _tmp2_);
	return self;
}


AllTrayProcess* all_tray_process_new (char** argv, int argv_length1) {
	return all_tray_process_construct (ALL_TRAY_TYPE_PROCESS, argv, argv_length1);
}


/**
     * CTT event handler.
     */
static void all_tray_process_on_ctt (AllTrayProcess* self, gulong XID) {
	g_return_if_fail (self != NULL);
	return;
}


GPid all_tray_process_get_pid (AllTrayProcess* self) {
	GPid result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_child;
	return result;
}


static void _all_tray_process_child_died_gchild_watch_func (GPid pid, gint status, gpointer self) {
	all_tray_process_child_died (self);
}


void all_tray_process_run (AllTrayProcess* self, GError** error) {
	AllTrayApplication* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	if (_vala_strcmp0 (self->priv->_argv[0], "alltray-internal-fake-process") == 0) {
		all_tray_process_run_fake (self, atoi (self->priv->_argv[1]), &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ALL_TRAY_PROCESS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		return;
	}
	{
		GString* msg;
		g_spawn_async (NULL, self->priv->_argv, NULL, G_SPAWN_DO_NOT_REAP_CHILD | G_SPAWN_SEARCH_PATH, NULL, NULL, &self->priv->_child, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch6_g_spawn_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->_running = TRUE;
		g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, self->priv->_child, _all_tray_process_child_died_gchild_watch_func, g_object_ref (self), g_object_unref);
		msg = g_string_new ("");
		g_string_append_printf (msg, _ ("Child process %d (%s) now running."), (gint) self->priv->_child, self->priv->_argv[0]);
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
		_g_string_free0 (msg);
	}
	goto __finally6;
	__catch6_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			self->priv->_running = FALSE;
			_inner_error_ = g_error_new_literal (ALL_TRAY_PROCESS_ERROR, ALL_TRAY_PROCESS_ERROR_SPAWN_FAILED, e->message);
			{
				_g_error_free0 (e);
				goto __finally6;
			}
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ALL_TRAY_PROCESS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_app = (_tmp0_ = all_tray_application_new (self), _g_object_unref0 (self->priv->_app), _tmp0_);
}


void all_tray_process_run_kinda_fake (AllTrayProcess* self, gint pid, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	all_tray_process_run_fake (self, pid, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ALL_TRAY_PROCESS_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gboolean _all_tray_process_fake_child_monitor_gsource_func (gpointer self) {
	gboolean result;
	result = all_tray_process_fake_child_monitor (self);
	return result;
}


static void all_tray_process_run_fake (AllTrayProcess* self, gint pid, GError** error) {
	GString* msg;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, "run_fake()");
	self->priv->_running = TRUE;
	self->priv->_child = (GPid) pid;
	if (!all_tray_process_process_num_is_alive (self, pid)) {
		_inner_error_ = g_error_new_literal (ALL_TRAY_PROCESS_ERROR, ALL_TRAY_PROCESS_ERROR_PROCESS_DOES_NOT_EXIST, _ ("The provided PID does not exist."));
		{
			if (_inner_error_->domain == ALL_TRAY_PROCESS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	msg = g_string_new ("");
	g_string_append_printf (msg, "Process %d now attached.", (gint) self->priv->_child);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 50, _all_tray_process_fake_child_monitor_gsource_func, g_object_ref (self), g_object_unref);
	if (self->priv->_app == NULL) {
		AllTrayApplication* _tmp0_;
		self->priv->_app = (_tmp0_ = all_tray_application_new (self), _g_object_unref0 (self->priv->_app), _tmp0_);
	}
	_g_string_free0 (msg);
}


static gboolean all_tray_process_fake_child_monitor (AllTrayProcess* self) {
	gboolean result = FALSE;
	GString* msg;
	g_return_val_if_fail (self != NULL, FALSE);
	if (all_tray_process_process_num_is_alive (self, (gint) self->priv->_child)) {
		result = TRUE;
		return result;
	}
	self->priv->_running = FALSE;
	msg = g_string_new ("");
	g_string_append_printf (msg, _ ("Attached process %d has died."), (gint) self->priv->_child);
	all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, msg->str);
	g_signal_emit_by_name (self, "process-died", self);
	result = FALSE;
	_g_string_free0 (msg);
	return result;
}


static gboolean all_tray_process_process_num_is_alive (AllTrayProcess* self, gint pid) {
	gboolean result = FALSE;
	gint kill_ret;
	g_return_val_if_fail (self != NULL, FALSE);
	kill_ret = kill ((pid_t) ((gint) self->priv->_child), 0);
	if (kill_ret == 0) {
		result = TRUE;
		return result;
	}
	if (errno == EPERM) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean _all_tray_process_die_if_not_unset_gsource_func (gpointer self) {
	gboolean result;
	result = all_tray_process_die_if_not_unset (self);
	return result;
}


void all_tray_process_child_died (AllTrayProcess* self) {
	g_return_if_fail (self != NULL);
	self->priv->_running = FALSE;
	if (all_tray_application_get_caught_window (self->priv->_app)) {
		char* _tmp0_;
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, _tmp0_ = g_strdup_printf (_ ("Child %d died okay"), (gint) self->priv->_child));
		_g_free0 (_tmp0_);
		g_signal_emit_by_name (self, "process-died", self);
	} else {
		char* _tmp1_;
		all_tray_debug_notification_emit (ALL_TRAY_DEBUG_SUBSYSTEM_Process, ALL_TRAY_DEBUG_LEVEL_Information, _tmp1_ = g_strdup_printf (_ ("Child %d died with nothing!"), (gint) self->priv->_child));
		_g_free0 (_tmp1_);
		self->priv->_timerRunning = TRUE;
		self->priv->_timerEventSource = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 3, _all_tray_process_die_if_not_unset_gsource_func, g_object_ref (self), g_object_unref);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean all_tray_process_really_try_hard (AllTrayProcess* self) {
	gboolean result = FALSE;
	gint procs_length1;
	gint _procs_size_;
	gint* procs;
	g_return_val_if_fail (self != NULL, FALSE);
	procs = (procs_length1 = 0, NULL);
	alltray_get_processes_in_pgrp ((gint) all_tray_program_pgid, &procs, &procs_length1);
	if (procs_length1 == 0) {
		result = FALSE;
		procs = (g_free (procs), NULL);
		return result;
	}
	{
		gint* proc_collection;
		int proc_collection_length1;
		int proc_it;
		proc_collection = procs;
		proc_collection_length1 = procs_length1;
		for (proc_it = 0; proc_it < procs_length1; proc_it = proc_it + 1) {
			gint proc;
			proc = proc_collection[proc_it];
			{
				if (proc != getpid ()) {
					{
						GList* w_collection;
						GList* w_it;
						w_collection = (GList*) wnck_screen_get_windows (all_tray_program_WnckScreen);
						for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
							WnckWindow* w;
							w = _g_object_ref0 ((WnckWindow*) w_it->data);
							{
								if (wnck_window_get_pid (w) == proc) {
									all_tray_application_maybe_setup_for_pid (self->priv->_app, wnck_window_get_application (w), wnck_window_get_pid (w));
									result = TRUE;
									_g_object_unref0 (w);
									procs = (g_free (procs), NULL);
									return result;
								}
								_g_object_unref0 (w);
							}
						}
					}
				}
			}
		}
	}
	fprintf (stderr, "%s", _ ("AllTray was unable to attach to any applications, and AllTray's child\n" \
"has died.\n" \
"\n" \
"This problem can be caused by application software that:\n" \
"  * is not compliant with the ICCCM and EWMH specs,\n" \
"  * backgrounds itself and leaves the AllTray process group, or\n" \
"  * unexpectedly died an early death and did not actually start\n" \
"\n" \
"If the problem is one of the first two problems, please report a bug\n" \
"in AllTray and it will be investigated and reported to the correct\n" \
"project, if necessary.  If the problem is the third one, then you will" \
"\n" \
"need to fix whatever went wrong and try again.\n"));
	exit (10);
	result = FALSE;
	procs = (g_free (procs), NULL);
	return result;
}


static gboolean all_tray_process_die_if_not_unset (AllTrayProcess* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (all_tray_process_really_try_hard (self) == FALSE) {
		g_signal_emit_by_name (self, "process-died", self);
	}
	result = FALSE;
	return result;
}


gboolean all_tray_process_get_running (AllTrayProcess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_running;
	return result;
}


gboolean all_tray_process_get_visible (AllTrayProcess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = all_tray_application_get_visible (self->priv->_app);
	return result;
}


void all_tray_process_set_visible (AllTrayProcess* self, gboolean value) {
	g_return_if_fail (self != NULL);
	all_tray_application_set_visible (self->priv->_app, value);
	g_object_notify ((GObject *) self, "visible");
}


gboolean all_tray_process_get_timer_running (AllTrayProcess* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_timerRunning;
	return result;
}


guint all_tray_process_get_timer_event_source (AllTrayProcess* self) {
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_timerEventSource;
	return result;
}


static void all_tray_process_class_init (AllTrayProcessClass * klass) {
	all_tray_process_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AllTrayProcessPrivate));
	G_OBJECT_CLASS (klass)->get_property = all_tray_process_get_property;
	G_OBJECT_CLASS (klass)->set_property = all_tray_process_set_property;
	G_OBJECT_CLASS (klass)->finalize = all_tray_process_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_PROCESS_RUNNING, g_param_spec_boolean ("running", "running", "running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_PROCESS_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_PROCESS_TIMER_RUNNING, g_param_spec_boolean ("timer-running", "timer-running", "timer-running", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ALL_TRAY_PROCESS_TIMER_EVENT_SOURCE, g_param_spec_uint ("timer-event-source", "timer-event-source", "timer-event-source", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("process_died", ALL_TRAY_TYPE_PROCESS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, ALL_TRAY_TYPE_PROCESS);
}


static void all_tray_process_instance_init (AllTrayProcess * self) {
	self->priv = ALL_TRAY_PROCESS_GET_PRIVATE (self);
}


static void all_tray_process_finalize (GObject* obj) {
	AllTrayProcess * self;
	self = ALL_TRAY_PROCESS (obj);
	self->priv->_argv = (_vala_array_free (self->priv->_argv, self->priv->_argv_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_app);
	G_OBJECT_CLASS (all_tray_process_parent_class)->finalize (obj);
}


GType all_tray_process_get_type (void) {
	static volatile gsize all_tray_process_type_id__volatile = 0;
	if (g_once_init_enter (&all_tray_process_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AllTrayProcessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) all_tray_process_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AllTrayProcess), 0, (GInstanceInitFunc) all_tray_process_instance_init, NULL };
		GType all_tray_process_type_id;
		all_tray_process_type_id = g_type_register_static (G_TYPE_OBJECT, "AllTrayProcess", &g_define_type_info, 0);
		g_once_init_leave (&all_tray_process_type_id__volatile, all_tray_process_type_id);
	}
	return all_tray_process_type_id__volatile;
}


static void all_tray_process_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AllTrayProcess * self;
	self = ALL_TRAY_PROCESS (object);
	switch (property_id) {
		case ALL_TRAY_PROCESS_RUNNING:
		g_value_set_boolean (value, all_tray_process_get_running (self));
		break;
		case ALL_TRAY_PROCESS_VISIBLE:
		g_value_set_boolean (value, all_tray_process_get_visible (self));
		break;
		case ALL_TRAY_PROCESS_TIMER_RUNNING:
		g_value_set_boolean (value, all_tray_process_get_timer_running (self));
		break;
		case ALL_TRAY_PROCESS_TIMER_EVENT_SOURCE:
		g_value_set_uint (value, all_tray_process_get_timer_event_source (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void all_tray_process_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AllTrayProcess * self;
	self = ALL_TRAY_PROCESS (object);
	switch (property_id) {
		case ALL_TRAY_PROCESS_VISIBLE:
		all_tray_process_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




