/* src/bazaar.p/bz-blocklist.h
 *
 * Copyright 2026 AUTOGEN
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <glib-object.h>
#include <gtk/gtk.h>
#include "bz-blocklist-condition.h"

G_BEGIN_DECLS



#define BZ_TYPE_BLOCKLIST (bz_blocklist_get_type ())
G_DECLARE_FINAL_TYPE (BzBlocklist, bz_blocklist, BZ, BLOCKLIST, GObject)

BzBlocklist *
bz_blocklist_new (void);

int
bz_blocklist_get_priority (BzBlocklist *self);

GListModel *
bz_blocklist_get_conditions (BzBlocklist *self);

GListModel *
bz_blocklist_get_allow (BzBlocklist *self);

GListModel *
bz_blocklist_get_allow_regex (BzBlocklist *self);

GListModel *
bz_blocklist_get_block (BzBlocklist *self);

GListModel *
bz_blocklist_get_block_regex (BzBlocklist *self);

void
bz_blocklist_set_priority (BzBlocklist *self,
    int priority);

void
bz_blocklist_set_conditions (BzBlocklist *self,
    GListModel *conditions);

void
bz_blocklist_set_allow (BzBlocklist *self,
    GListModel *allow);

void
bz_blocklist_set_allow_regex (BzBlocklist *self,
    GListModel *allow_regex);

void
bz_blocklist_set_block (BzBlocklist *self,
    GListModel *block);

void
bz_blocklist_set_block_regex (BzBlocklist *self,
    GListModel *block_regex);

G_END_DECLS

/* End of src/bazaar.p/bz-blocklist.h */
