/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers, elementary LLC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <locale.h>
#include <budgie-config.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SENDTO_APPLICATION (sendto_application_get_type ())
#define SENDTO_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SENDTO_APPLICATION, SendtoApplication))
#define SENDTO_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SENDTO_APPLICATION, SendtoApplicationClass))
#define IS_SENDTO_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SENDTO_APPLICATION))
#define IS_SENDTO_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SENDTO_APPLICATION))
#define SENDTO_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SENDTO_APPLICATION, SendtoApplicationClass))

typedef struct _SendtoApplication SendtoApplication;
typedef struct _SendtoApplicationClass SendtoApplicationClass;
typedef struct _SendtoApplicationPrivate SendtoApplicationPrivate;

#define BLUETOOTH_TYPE_OBJECT_MANAGER (bluetooth_object_manager_get_type ())
#define BLUETOOTH_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManager))
#define BLUETOOTH_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManagerClass))
#define BLUETOOTH_IS_OBJECT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_IS_OBJECT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_TYPE_OBJECT_MANAGER))
#define BLUETOOTH_OBJECT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_TYPE_OBJECT_MANAGER, BluetoothObjectManagerClass))

typedef struct _BluetoothObjectManager BluetoothObjectManager;
typedef struct _BluetoothObjectManagerClass BluetoothObjectManagerClass;

#define BLUETOOTH_OBEX_TYPE_AGENT (bluetooth_obex_agent_get_type ())
#define BLUETOOTH_OBEX_AGENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgent))
#define BLUETOOTH_OBEX_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgentClass))
#define BLUETOOTH_OBEX_IS_AGENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_AGENT))
#define BLUETOOTH_OBEX_IS_AGENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUETOOTH_OBEX_TYPE_AGENT))
#define BLUETOOTH_OBEX_AGENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUETOOTH_OBEX_TYPE_AGENT, BluetoothObexAgentClass))

typedef struct _BluetoothObexAgent BluetoothObexAgent;
typedef struct _BluetoothObexAgentClass BluetoothObexAgentClass;

#define BLUETOOTH_OBEX_TYPE_TRANSFER (bluetooth_obex_transfer_get_type ())
#define BLUETOOTH_OBEX_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransfer))
#define BLUETOOTH_OBEX_IS_TRANSFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER))
#define BLUETOOTH_OBEX_TRANSFER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_OBEX_TYPE_TRANSFER, BluetoothObexTransferIface))

typedef struct _BluetoothObexTransfer BluetoothObexTransfer;
typedef struct _BluetoothObexTransferIface BluetoothObexTransferIface;

#define BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY (bluetooth_obex_transfer_proxy_get_type ())

#define TYPE_BASE_DIALOG (base_dialog_get_type ())
#define BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_DIALOG, BaseDialog))
#define BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_DIALOG, BaseDialogClass))
#define IS_BASE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_DIALOG))
#define IS_BASE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_DIALOG))
#define BASE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_DIALOG, BaseDialogClass))

typedef struct _BaseDialog BaseDialog;
typedef struct _BaseDialogClass BaseDialogClass;

#define TYPE_FILE_RECEIVER (file_receiver_get_type ())
#define FILE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_RECEIVER, FileReceiver))
#define FILE_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_RECEIVER, FileReceiverClass))
#define IS_FILE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_RECEIVER))
#define IS_FILE_RECEIVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_RECEIVER))
#define FILE_RECEIVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_RECEIVER, FileReceiverClass))

typedef struct _FileReceiver FileReceiver;
typedef struct _FileReceiverClass FileReceiverClass;

#define TYPE_FILE_SENDER (file_sender_get_type ())
#define FILE_SENDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_SENDER, FileSender))
#define FILE_SENDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_SENDER, FileSenderClass))
#define IS_FILE_SENDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_SENDER))
#define IS_FILE_SENDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_SENDER))
#define FILE_SENDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_SENDER, FileSenderClass))

typedef struct _FileSender FileSender;
typedef struct _FileSenderClass FileSenderClass;

#define TYPE_SCAN_DIALOG (scan_dialog_get_type ())
#define SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DIALOG, ScanDialog))
#define SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DIALOG, ScanDialogClass))
#define IS_SCAN_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DIALOG))
#define IS_SCAN_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DIALOG))
#define SCAN_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DIALOG, ScanDialogClass))

typedef struct _ScanDialog ScanDialog;
typedef struct _ScanDialogClass ScanDialogClass;
enum  {
	SENDTO_APPLICATION_0_PROPERTY,
	SENDTO_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* sendto_application_properties[SENDTO_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BLUETOOTH_TYPE_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDevice))
#define BLUETOOTH_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUETOOTH_TYPE_DEVICE))
#define BLUETOOTH_DEVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BLUETOOTH_TYPE_DEVICE, BluetoothDeviceIface))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceIface BluetoothDeviceIface;

#define BLUETOOTH_TYPE_DEVICE_PROXY (bluetooth_device_proxy_get_type ())
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _BaseDialogPrivate BaseDialogPrivate;
typedef struct _Block3Data Block3Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _SendtoApplication {
	GtkApplication parent_instance;
	SendtoApplicationPrivate * priv;
};

struct _SendtoApplicationClass {
	GtkApplicationClass parent_class;
};

struct _BluetoothObexTransferIface {
	GTypeInterface parent_iface;
	void (*cancel) (BluetoothObexTransfer* self, GError** error);
	void (*resume) (BluetoothObexTransfer* self, GError** error);
	void (*suspend) (BluetoothObexTransfer* self, GError** error);
	gchar* (*get_status) (BluetoothObexTransfer* self);
	char* (*get_session) (BluetoothObexTransfer* self);
	gchar* (*get_name) (BluetoothObexTransfer* self);
	gchar* (*get_Type) (BluetoothObexTransfer* self);
	guint64 (*get_time) (BluetoothObexTransfer* self);
	guint64 (*get_size) (BluetoothObexTransfer* self);
	guint64 (*get_transferred) (BluetoothObexTransfer* self);
	gchar* (*get_filename) (BluetoothObexTransfer* self);
};

struct _SendtoApplicationPrivate {
	BluetoothObjectManager* manager;
	BluetoothObexAgent* agent;
	BluetoothObexTransfer* transfer;
	FileReceiver* file_receiver;
	FileSender* file_sender;
	GList* file_receivers;
	GList* file_senders;
	ScanDialog* scan_dialog;
};

struct _Block1Data {
	int _ref_count_;
	SendtoApplication* self;
	GFile** files;
	gint files_length1;
	gint _files_size_;
};

struct _BluetoothDeviceIface {
	GTypeInterface parent_iface;
	void (*cancel_pairing) (BluetoothDevice* self, GError** error);
	void (*connect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*connect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*disconnect) (BluetoothDevice* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*disconnect_finish) (BluetoothDevice* self, GAsyncResult* _res_, GError** error);
	void (*disconnect_profile) (BluetoothDevice* self, const gchar* UUID, GError** error);
	void (*pair) (BluetoothDevice* self, GError** error);
	gchar** (*get_UUIDs) (BluetoothDevice* self, gint* result_length1);
	gboolean (*get_blocked) (BluetoothDevice* self);
	void (*set_blocked) (BluetoothDevice* self, gboolean value);
	gboolean (*get_connected) (BluetoothDevice* self);
	gboolean (*get_legacy_pairing) (BluetoothDevice* self);
	gboolean (*get_paired) (BluetoothDevice* self);
	gboolean (*get_trusted) (BluetoothDevice* self);
	void (*set_trusted) (BluetoothDevice* self, gboolean value);
	gint16 (*get_RSSI) (BluetoothDevice* self);
	char* (*get_adapter) (BluetoothDevice* self);
	gchar* (*get_address) (BluetoothDevice* self);
	gchar* (*get_alias) (BluetoothDevice* self);
	void (*set_alias) (BluetoothDevice* self, const gchar* value);
	gchar* (*get_icon) (BluetoothDevice* self);
	gchar* (*get_modalias) (BluetoothDevice* self);
	gchar* (*get_name) (BluetoothDevice* self);
	guint16 (*get_appearance) (BluetoothDevice* self);
	guint32 (*get_class) (BluetoothDevice* self);
};

struct _Block2Data {
	int _ref_count_;
	SendtoApplication* self;
	gchar* session_path;
};

struct _BaseDialog {
	GtkDialog parent_instance;
	BaseDialogPrivate * priv;
	BluetoothObexTransfer* transfer;
	BluetoothDevice* device;
	gint start_time;
	guint64 total_size;
	GtkProgressBar* progress_bar;
	GtkLabel* device_label;
	GtkLabel* directory_label;
	GtkLabel* progress_label;
	GtkLabel* filename_label;
	GtkLabel* rate_label;
	GtkImage* device_image;
};

struct _BaseDialogClass {
	GtkDialogClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	SendtoApplication* self;
	gboolean exists;
	GFile** files;
	gint files_length1;
	BluetoothDevice* device;
};

static gint SendtoApplication_private_offset;
static gpointer sendto_application_parent_class = NULL;
static gboolean sendto_application_silent;
static gboolean sendto_application_send;
static gchar* sendto_application_device_addr;
static gchar** sendto_application_arg_files;
static gboolean sendto_application_silent = TRUE;
static gboolean sendto_application_send = FALSE;
static gboolean sendto_application_active_once;
static gboolean sendto_application_active_once = FALSE;
static gchar* sendto_application_device_addr = NULL;
static gchar** sendto_application_arg_files = NULL;

VALA_EXTERN GType sendto_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SendtoApplication, g_object_unref)
VALA_EXTERN GType bluetooth_object_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObjectManager, g_object_unref)
VALA_EXTERN GType bluetooth_obex_agent_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexAgent, g_object_unref)
VALA_EXTERN guint bluetooth_obex_agent_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
VALA_EXTERN GType bluetooth_obex_transfer_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_obex_transfer_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN GType bluetooth_obex_transfer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothObexTransfer, g_object_unref)
VALA_EXTERN GType base_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseDialog, g_object_unref)
VALA_EXTERN GType file_receiver_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileReceiver, g_object_unref)
VALA_EXTERN GType file_sender_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileSender, g_object_unref)
VALA_EXTERN GType scan_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScanDialog, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gint sendto_application_real_command_line (GApplication* base,
                                           GApplicationCommandLine* command);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _vala_array_add1 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void ___lambda35_ (Block1Data* _data1_,
                   GFile* file);
static void _vala_array_add2 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void ____lambda35__gfunc (gconstpointer data,
                          gpointer self);
static inline void _g_slist_free__g_object_unref0_ (GSList* self);
VALA_EXTERN ScanDialog* scan_dialog_new (GtkApplication* application,
                             BluetoothObjectManager* manager);
VALA_EXTERN ScanDialog* scan_dialog_construct (GType object_type,
                                   GtkApplication* application,
                                   BluetoothObjectManager* manager);
static gboolean ____lambda36_ (SendtoApplication* self);
static gboolean _____lambda36__gsource_func (gpointer self);
static void ___lambda37_ (SendtoApplication* self);
static void ____lambda37__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
VALA_EXTERN GType bluetooth_device_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint bluetooth_device_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN GType bluetooth_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BluetoothDevice, g_object_unref)
static void ___lambda38_ (SendtoApplication* self,
                   BluetoothDevice* device);
VALA_EXTERN gchar* bluetooth_device_get_address (BluetoothDevice* self);
static void ____lambda38__scan_dialog_send_file (ScanDialog* _sender,
                                          BluetoothDevice* device,
                                          gpointer self);
VALA_EXTERN BluetoothDevice* bluetooth_object_manager_get_device (BluetoothObjectManager* self,
                                                      const gchar* address);
static gboolean sendto_application_insert_sender (SendtoApplication* self,
                                           GFile** files,
                                           gint files_length1,
                                           BluetoothDevice* device);
VALA_EXTERN FileSender* file_sender_new (GtkApplication* application);
VALA_EXTERN FileSender* file_sender_construct (GType object_type,
                                   GtkApplication* application);
VALA_EXTERN void file_sender_add_files (FileSender* self,
                            GFile** files,
                            gint files_length1,
                            BluetoothDevice* device);
static void ___lambda40_ (SendtoApplication* self);
static void ____lambda40__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void sendto_application_real_activate (GApplication* base);
VALA_EXTERN BluetoothObjectManager* bluetooth_object_manager_new (void);
VALA_EXTERN BluetoothObjectManager* bluetooth_object_manager_construct (GType object_type);
static void __lambda30_ (SendtoApplication* self);
VALA_EXTERN gboolean bluetooth_object_manager_get_has_object (BluetoothObjectManager* self);
VALA_EXTERN BluetoothObexAgent* bluetooth_obex_agent_new (void);
VALA_EXTERN BluetoothObexAgent* bluetooth_obex_agent_construct (GType object_type);
static void sendto_application_dialog_active (SendtoApplication* self,
                                       const gchar* session_path);
static void _sendto_application_dialog_active_bluetooth_obex_agent_transfer_view (BluetoothObexAgent* _sender,
                                                                           const gchar* session_path,
                                                                           gpointer self);
static void sendto_application_response_accepted (SendtoApplication* self,
                                           const gchar* address,
                                           const char* path);
static void _sendto_application_response_accepted_bluetooth_obex_agent_response_accepted (BluetoothObexAgent* _sender,
                                                                                   const gchar* address,
                                                                                   const char* object_path,
                                                                                   gpointer self);
static void sendto_application_response_canceled (SendtoApplication* self,
                                           const char* path);
static void _sendto_application_response_canceled_bluetooth_obex_agent_response_canceled (BluetoothObexAgent* _sender,
                                                                                   const char* object_path,
                                                                                   gpointer self);
static void sendto_application_response_notify (SendtoApplication* self,
                                         const gchar* address,
                                         const char* object_path);
static void _sendto_application_response_notify_bluetooth_obex_agent_response_notify (BluetoothObexAgent* _sender,
                                                                               const gchar* address,
                                                                               const char* object_path,
                                                                               gpointer self);
static void ___lambda30__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda31_ (Block2Data* _data2_,
                  FileReceiver* receiver);
VALA_EXTERN char* bluetooth_obex_transfer_get_session (BluetoothObexTransfer* self);
static void ___lambda31__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda32_ (Block2Data* _data2_,
                  FileSender* sender);
static void ___lambda32__gfunc (gconstpointer data,
                         gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda39_ (Block3Data* _data3_,
                  FileSender* sender);
static void ___lambda39__gfunc (gconstpointer data,
                         gpointer self);
VALA_EXTERN gchar* bluetooth_obex_transfer_get_name (BluetoothObexTransfer* self);
VALA_EXTERN FileReceiver* file_receiver_new (GtkApplication* application);
VALA_EXTERN FileReceiver* file_receiver_construct (GType object_type,
                                       GtkApplication* application);
static void __lambda33_ (SendtoApplication* self);
static void ___lambda33__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
VALA_EXTERN void file_receiver_set_transfer (FileReceiver* self,
                                 BluetoothDevice* device,
                                 const gchar* path);
VALA_EXTERN void bluetooth_obex_transfer_cancel (BluetoothObexTransfer* self,
                                     GError** error);
VALA_EXTERN gchar* bluetooth_device_get_icon (BluetoothDevice* self);
static gboolean sendto_application_reject_if_exists (SendtoApplication* self,
                                              const gchar* name,
                                              guint64 size);
VALA_EXTERN guint64 bluetooth_obex_transfer_get_size (BluetoothObexTransfer* self);
static gboolean ___lambda34_ (SendtoApplication* self);
static gboolean ____lambda34__gsource_func (gpointer self);
VALA_EXTERN gchar* bluetooth_device_get_alias (BluetoothDevice* self);
VALA_EXTERN SendtoApplication* sendto_application_new (void);
VALA_EXTERN SendtoApplication* sendto_application_construct (GType object_type);
static GObject * sendto_application_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void sendto_application_finalize (GObject * obj);
static GType sendto_application_get_type_once (void);
static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry SENDTO_APPLICATION_OPTIONS[5] = {{"daemon", 'd', (gint) 0, G_OPTION_ARG_NONE, &sendto_application_silent, "Run the application in the background", NULL}, {"send", 'f', (gint) 0, G_OPTION_ARG_NONE, &sendto_application_send, "Send a file via Bluetooth", NULL}, {"device", 'a', (gint) 0, G_OPTION_ARG_STRING, &sendto_application_device_addr, "Bluetooth device to send files to", NULL}, {"", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, &sendto_application_arg_files, "Files to send via Bluetooth", NULL}, {NULL}};

static inline gpointer
sendto_application_get_instance_private (SendtoApplication* self)
{
	return G_STRUCT_MEMBER_P (self, SendtoApplication_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		SendtoApplication* self;
		self = _data1_->self;
		_data1_->files = (_vala_array_free (_data1_->files, _data1_->files_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add1 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
___lambda35_ (Block1Data* _data1_,
              GFile* file)
{
	SendtoApplication* self;
	GFile* _tmp0_;
	self = _data1_->self;
	g_return_if_fail (file != NULL);
	_tmp0_ = _g_object_ref0 (file);
	_vala_array_add2 (&_data1_->files, &_data1_->files_length1, &_data1_->_files_size_, _tmp0_);
}

static void
____lambda35__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda35_ (self, (GFile*) data);
}

static inline void
_g_slist_free__g_object_unref0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
____lambda36_ (SendtoApplication* self)
{
	ScanDialog* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->scan_dialog;
	gtk_widget_show_all ((GtkWidget*) _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
_____lambda36__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda36_ ((SendtoApplication*) self);
	return result;
}

static void
___lambda37_ (SendtoApplication* self)
{
	_g_object_unref0 (self->priv->scan_dialog);
	self->priv->scan_dialog = NULL;
}

static void
____lambda37__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda37_ ((SendtoApplication*) self);
}

static void
___lambda38_ (SendtoApplication* self,
              BluetoothDevice* device)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (device != NULL);
	_tmp0_ = bluetooth_device_get_address (device);
	_tmp1_ = _tmp0_;
	_g_free0 (sendto_application_device_addr);
	sendto_application_device_addr = _tmp1_;
}

static void
____lambda38__scan_dialog_send_file (ScanDialog* _sender,
                                     BluetoothDevice* device,
                                     gpointer self)
{
	___lambda38_ ((SendtoApplication*) self, device);
}

static void
___lambda40_ (SendtoApplication* self)
{
	GList* _tmp0_;
	FileSender* _tmp1_;
	GList* _tmp2_;
	_tmp0_ = self->priv->file_senders;
	_tmp1_ = self->priv->file_sender;
	_tmp2_ = g_list_find (_tmp0_, _tmp1_);
	self->priv->file_senders = g_list_remove_link (self->priv->file_senders, _tmp2_);
}

static void
____lambda40__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda40_ ((SendtoApplication*) self);
}

static gint
sendto_application_real_command_line (GApplication* base,
                                      GApplicationCommandLine* command)
{
	SendtoApplication * self;
	Block1Data* _data1_;
	gchar** args = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	GOptionContext* context = NULL;
	GOptionContext* _tmp2_;
	GOptionContext* _tmp3_;
	GFile** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	GFile** _tmp18_;
	gint _tmp18__length1;
	GFile** _tmp26_;
	gint _tmp26__length1;
	gboolean _tmp27_ = FALSE;
	const gchar* _tmp28_;
	BluetoothDevice* device = NULL;
	BluetoothObjectManager* _tmp36_;
	const gchar* _tmp37_;
	BluetoothDevice* _tmp38_;
	GFile** _tmp39_;
	gint _tmp39__length1;
	BluetoothDevice* _tmp40_;
	gchar** _tmp49_;
	GError* _inner_error0_ = NULL;
	gint result;
	self = (SendtoApplication*) base;
	g_return_val_if_fail (command != NULL, 0);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp1_ = g_application_command_line_get_arguments (command, &_tmp0_);
	args = _tmp1_;
	args_length1 = _tmp0_;
	_args_size_ = args_length1;
	_tmp2_ = g_option_context_new (NULL);
	context = _tmp2_;
	_tmp3_ = context;
	g_option_context_add_main_entries (_tmp3_, SENDTO_APPLICATION_OPTIONS, NULL);
	{
		GOptionContext* _tmp4_;
		_tmp4_ = context;
		g_option_context_parse_strv (_tmp4_, &args, &_inner_error0_);
		args_length1 = _vala_array_length (args);
		_args_size_ = args_length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Application.vala:52: Unable to parse command args: %s", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	g_application_activate ((GApplication*) self);
	if (!sendto_application_send) {
		result = 0;
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp8_ = g_new0 (GFile*, 0 + 1);
	_data1_->files = _tmp8_;
	_data1_->files_length1 = 0;
	_data1_->_files_size_ = _data1_->files_length1;
	_tmp9_ = sendto_application_arg_files;
	_tmp9__length1 = _vala_array_length (sendto_application_arg_files);
	{
		gchar** arg_file_collection = NULL;
		gint arg_file_collection_length1 = 0;
		gint _arg_file_collection_size_ = 0;
		gint arg_file_it = 0;
		arg_file_collection = _tmp9_;
		arg_file_collection_length1 = _tmp9__length1;
		for (arg_file_it = 0; arg_file_it < arg_file_collection_length1; arg_file_it = arg_file_it + 1) {
			const gchar* arg_file = NULL;
			arg_file = arg_file_collection[arg_file_it];
			{
				GFile* file = NULL;
				const gchar* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				_tmp10_ = arg_file;
				_tmp11_ = g_application_command_line_create_file_for_arg (command, _tmp10_);
				file = _tmp11_;
				_tmp12_ = file;
				if (g_file_query_exists (_tmp12_, NULL)) {
					GFile* _tmp13_;
					GFile* _tmp14_;
					_tmp13_ = file;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					_vala_array_add1 (&_data1_->files, &_data1_->files_length1, &_data1_->_files_size_, _tmp14_);
				} else {
					GFile* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = file;
					_tmp16_ = g_file_get_path (_tmp15_);
					_tmp17_ = _tmp16_;
					g_warning ("Application.vala:68: File not found: %s", _tmp17_);
					_g_free0 (_tmp17_);
				}
				_g_object_unref0 (file);
			}
		}
	}
	_tmp18_ = _data1_->files;
	_tmp18__length1 = _data1_->files_length1;
	if (_tmp18__length1 == 0) {
		GtkFileChooserDialog* picker = NULL;
		GtkFileChooserDialog* _tmp19_ = NULL;
		GtkFileChooserDialog* _tmp20_;
		GSList* picked_files = NULL;
		GtkFileChooserDialog* _tmp22_;
		GSList* _tmp23_;
		GSList* _tmp24_;
		GtkFileChooserDialog* _tmp25_;
		_tmp19_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Files to send"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Open"), GTK_RESPONSE_ACCEPT, NULL);
		gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp19_, TRUE);
		g_object_ref_sink (_tmp19_);
		picker = _tmp19_;
		_tmp20_ = picker;
		if (gtk_dialog_run ((GtkDialog*) _tmp20_) != ((gint) GTK_RESPONSE_ACCEPT)) {
			GtkFileChooserDialog* _tmp21_;
			_tmp21_ = picker;
			gtk_widget_destroy ((GtkWidget*) _tmp21_);
			result = 0;
			_g_object_unref0 (picker);
			_g_option_context_free0 (context);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return result;
		}
		_tmp22_ = picker;
		_tmp23_ = gtk_file_chooser_get_files ((GtkFileChooser*) _tmp22_);
		picked_files = _tmp23_;
		_tmp24_ = picked_files;
		g_slist_foreach (_tmp24_, ____lambda35__gfunc, _data1_);
		_tmp25_ = picker;
		gtk_widget_destroy ((GtkWidget*) _tmp25_);
		(picked_files == NULL) ? NULL : (picked_files = (_g_slist_free__g_object_unref0_ (picked_files), NULL));
		_g_object_unref0 (picker);
	}
	_tmp26_ = _data1_->files;
	_tmp26__length1 = _data1_->files_length1;
	if (_tmp26__length1 == 0) {
		result = 0;
		_g_option_context_free0 (context);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	_tmp28_ = sendto_application_device_addr;
	if (_tmp28_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		const gchar* _tmp29_;
		_tmp29_ = sendto_application_device_addr;
		_tmp27_ = g_strcmp0 (_tmp29_, "") == 0;
	}
	if (_tmp27_) {
		ScanDialog* _tmp30_;
		ScanDialog* _tmp34_;
		ScanDialog* _tmp35_;
		_tmp30_ = self->priv->scan_dialog;
		if (_tmp30_ == NULL) {
			BluetoothObjectManager* _tmp31_;
			ScanDialog* _tmp32_;
			_tmp31_ = self->priv->manager;
			_tmp32_ = scan_dialog_new ((GtkApplication*) self, _tmp31_);
			g_object_ref_sink (_tmp32_);
			_g_object_unref0 (self->priv->scan_dialog);
			self->priv->scan_dialog = _tmp32_;
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda36__gsource_func, g_object_ref (self), g_object_unref);
		} else {
			ScanDialog* _tmp33_;
			_tmp33_ = self->priv->scan_dialog;
			gtk_window_present ((GtkWindow*) _tmp33_);
		}
		_tmp34_ = self->priv->scan_dialog;
		g_signal_connect_object ((GtkWidget*) _tmp34_, "destroy", (GCallback) ____lambda37__gtk_widget_destroy, self, 0);
		_tmp35_ = self->priv->scan_dialog;
		g_signal_connect_object (_tmp35_, "send-file", (GCallback) ____lambda38__scan_dialog_send_file, self, 0);
	}
	_tmp36_ = self->priv->manager;
	_tmp37_ = sendto_application_device_addr;
	_tmp38_ = bluetooth_object_manager_get_device (_tmp36_, _tmp37_);
	device = _tmp38_;
	_tmp39_ = _data1_->files;
	_tmp39__length1 = _data1_->files_length1;
	_tmp40_ = device;
	if (!sendto_application_insert_sender (self, _tmp39_, (gint) _tmp39__length1, _tmp40_)) {
		FileSender* _tmp41_;
		FileSender* _tmp42_;
		GFile** _tmp43_;
		gint _tmp43__length1;
		BluetoothDevice* _tmp44_;
		FileSender* _tmp45_;
		FileSender* _tmp46_;
		FileSender* _tmp47_;
		FileSender* _tmp48_;
		_tmp41_ = file_sender_new ((GtkApplication*) self);
		g_object_ref_sink (_tmp41_);
		_g_object_unref0 (self->priv->file_sender);
		self->priv->file_sender = _tmp41_;
		_tmp42_ = self->priv->file_sender;
		_tmp43_ = _data1_->files;
		_tmp43__length1 = _data1_->files_length1;
		_tmp44_ = device;
		file_sender_add_files (_tmp42_, _tmp43_, (gint) _tmp43__length1, _tmp44_);
		_tmp45_ = self->priv->file_sender;
		_tmp46_ = _g_object_ref0 (_tmp45_);
		self->priv->file_senders = g_list_append (self->priv->file_senders, _tmp46_);
		_tmp47_ = self->priv->file_sender;
		gtk_widget_show_all ((GtkWidget*) _tmp47_);
		_tmp48_ = self->priv->file_sender;
		g_signal_connect_object ((GtkWidget*) _tmp48_, "destroy", (GCallback) ____lambda40__gtk_widget_destroy, self, 0);
	}
	_tmp49_ = g_new0 (gchar*, 0 + 1);
	sendto_application_arg_files = (_vala_array_free (sendto_application_arg_files, _vala_array_length (sendto_application_arg_files), (GDestroyNotify) g_free), NULL);
	sendto_application_arg_files = _tmp49_;
	sendto_application_send = FALSE;
	result = 0;
	_g_object_unref0 (device);
	_g_option_context_free0 (context);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
_sendto_application_dialog_active_bluetooth_obex_agent_transfer_view (BluetoothObexAgent* _sender,
                                                                      const gchar* session_path,
                                                                      gpointer self)
{
	sendto_application_dialog_active ((SendtoApplication*) self, session_path);
}

static void
_sendto_application_response_accepted_bluetooth_obex_agent_response_accepted (BluetoothObexAgent* _sender,
                                                                              const gchar* address,
                                                                              const char* object_path,
                                                                              gpointer self)
{
	sendto_application_response_accepted ((SendtoApplication*) self, address, object_path);
}

static void
_sendto_application_response_canceled_bluetooth_obex_agent_response_canceled (BluetoothObexAgent* _sender,
                                                                              const char* object_path,
                                                                              gpointer self)
{
	sendto_application_response_canceled ((SendtoApplication*) self, object_path);
}

static void
_sendto_application_response_notify_bluetooth_obex_agent_response_notify (BluetoothObexAgent* _sender,
                                                                          const gchar* address,
                                                                          const char* object_path,
                                                                          gpointer self)
{
	sendto_application_response_notify ((SendtoApplication*) self, address, object_path);
}

static void
__lambda30_ (SendtoApplication* self)
{
	gchar* build_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* file = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	gboolean file_exists = FALSE;
	GFile* _tmp10_;
	const gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	gboolean _tmp14_;
	BluetoothObjectManager* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_build_filename (_tmp0_, ".local", "share", "contractor", NULL);
	build_path = _tmp1_;
	_tmp2_ = build_path;
	_tmp3_ = g_get_application_name ();
	_tmp4_ = g_strconcat (_tmp3_, ".contract", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp2_, _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_new_for_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	file = _tmp9_;
	_tmp10_ = file;
	file_exists = g_file_query_exists (_tmp10_, NULL);
	_tmp11_ = build_path;
	_tmp12_ = g_file_new_for_path (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = !g_file_query_exists (_tmp13_, NULL);
	_g_object_unref0 (_tmp13_);
	if (_tmp14_) {
		const gchar* _tmp15_;
		_tmp15_ = build_path;
		g_mkdir (_tmp15_, 0700);
	}
	_tmp16_ = self->priv->manager;
	_tmp17_ = bluetooth_object_manager_get_has_object (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		if (!sendto_application_active_once) {
			BluetoothObexAgent* _tmp19_;
			BluetoothObexAgent* _tmp20_;
			BluetoothObexAgent* _tmp21_;
			BluetoothObexAgent* _tmp22_;
			BluetoothObexAgent* _tmp23_;
			_tmp19_ = bluetooth_obex_agent_new ();
			_g_object_unref0 (self->priv->agent);
			self->priv->agent = _tmp19_;
			_tmp20_ = self->priv->agent;
			g_signal_connect_object (_tmp20_, "transfer-view", (GCallback) _sendto_application_dialog_active_bluetooth_obex_agent_transfer_view, self, 0);
			_tmp21_ = self->priv->agent;
			g_signal_connect_object (_tmp21_, "response-accepted", (GCallback) _sendto_application_response_accepted_bluetooth_obex_agent_response_accepted, self, 0);
			_tmp22_ = self->priv->agent;
			g_signal_connect_object (_tmp22_, "response-canceled", (GCallback) _sendto_application_response_canceled_bluetooth_obex_agent_response_canceled, self, 0);
			_tmp23_ = self->priv->agent;
			g_signal_connect_object (_tmp23_, "response-notify", (GCallback) _sendto_application_response_notify_bluetooth_obex_agent_response_notify, self, 0);
			sendto_application_active_once = TRUE;
		}
		if (!file_exists) {
			GKeyFile* keyfile = NULL;
			GKeyFile* _tmp24_;
			GKeyFile* _tmp25_;
			GKeyFile* _tmp26_;
			GKeyFile* _tmp27_;
			GKeyFile* _tmp28_;
			GKeyFile* _tmp29_;
			_tmp24_ = g_key_file_new ();
			keyfile = _tmp24_;
			_tmp25_ = keyfile;
			g_key_file_set_string (_tmp25_, "Contractor Entry", "Name", _ ("Send Files via Bluetooth"));
			_tmp26_ = keyfile;
			g_key_file_set_string (_tmp26_, "Contractor Entry", "Icon", "bluetooth-active");
			_tmp27_ = keyfile;
			g_key_file_set_string (_tmp27_, "Contractor Entry", "Description", _ ("Send files to device…"));
			_tmp28_ = keyfile;
			g_key_file_set_string (_tmp28_, "Contractor Entry", "Exec", "org.buddiesofbudgie.sendto -f %F");
			_tmp29_ = keyfile;
			g_key_file_set_string (_tmp29_, "Contractor Entry", "MimeType", "!inode;");
			{
				GKeyFile* _tmp30_;
				GFile* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp30_ = keyfile;
				_tmp31_ = file;
				_tmp32_ = g_file_get_path (_tmp31_);
				_tmp33_ = _tmp32_;
				g_key_file_save_to_file (_tmp30_, _tmp33_, &_inner_error0_);
				_g_free0 (_tmp33_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp34_;
				const gchar* _tmp35_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp34_ = e;
				_tmp35_ = _tmp34_->message;
				g_critical ("Application.vala:202: Error saving contract file: %s", _tmp35_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_key_file_unref0 (keyfile);
				_g_object_unref0 (file);
				_g_free0 (build_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_key_file_unref0 (keyfile);
		}
	} else {
		if (file_exists) {
			{
				GFile* _tmp36_;
				_tmp36_ = file;
				g_file_delete (_tmp36_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp37_;
				const gchar* _tmp38_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp37_ = e;
				_tmp38_ = _tmp37_->message;
				g_critical ("Application.vala:211: Error deleting old contract file: %s", _tmp38_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_free0 (build_path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_g_object_unref0 (file);
	_g_free0 (build_path);
}

static void
___lambda30__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda30_ ((SendtoApplication*) self);
}

static void
sendto_application_real_activate (GApplication* base)
{
	SendtoApplication * self;
	BluetoothObjectManager* _tmp0_;
	BluetoothObjectManager* _tmp1_;
	BluetoothObjectManager* _tmp2_;
	self = (SendtoApplication*) base;
	if (sendto_application_silent) {
		if (sendto_application_active_once) {
			g_application_release ((GApplication*) self);
		}
		g_application_hold ((GApplication*) self);
		sendto_application_silent = FALSE;
	}
	_tmp0_ = self->priv->manager;
	if (_tmp0_ != NULL) {
		return;
	}
	(self->priv->file_receivers == NULL) ? NULL : (self->priv->file_receivers = (_g_list_free__g_object_unref0_ (self->priv->file_receivers), NULL));
	self->priv->file_receivers = NULL;
	(self->priv->file_senders == NULL) ? NULL : (self->priv->file_senders = (_g_list_free__g_object_unref0_ (self->priv->file_senders), NULL));
	self->priv->file_senders = NULL;
	_tmp1_ = bluetooth_object_manager_new ();
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp1_;
	_tmp2_ = self->priv->manager;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::has-object", (GCallback) ___lambda30__g_object_notify, self, 0);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		SendtoApplication* self;
		self = _data2_->self;
		_g_free0 (_data2_->session_path);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda31_ (Block2Data* _data2_,
             FileReceiver* receiver)
{
	SendtoApplication* self;
	BluetoothObexTransfer* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	gboolean _tmp4_;
	self = _data2_->self;
	g_return_if_fail (receiver != NULL);
	_tmp0_ = ((BaseDialog*) receiver)->transfer;
	_tmp1_ = bluetooth_obex_transfer_get_session (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, _data2_->session_path) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		gtk_widget_show_all ((GtkWidget*) receiver);
	}
}

static void
___lambda31__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda31_ (self, (FileReceiver*) data);
}

static void
__lambda32_ (Block2Data* _data2_,
             FileSender* sender)
{
	SendtoApplication* self;
	BluetoothObexTransfer* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	gboolean _tmp4_;
	self = _data2_->self;
	g_return_if_fail (sender != NULL);
	_tmp0_ = ((BaseDialog*) sender)->transfer;
	_tmp1_ = bluetooth_obex_transfer_get_session (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, _data2_->session_path) == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		gtk_widget_show_all ((GtkWidget*) sender);
	}
}

static void
___lambda32__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda32_ (self, (FileSender*) data);
}

static void
sendto_application_dialog_active (SendtoApplication* self,
                                  const gchar* session_path)
{
	Block2Data* _data2_;
	gchar* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (session_path != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = g_strdup (session_path);
	_g_free0 (_data2_->session_path);
	_data2_->session_path = _tmp0_;
	_tmp1_ = self->priv->file_receivers;
	g_list_foreach (_tmp1_, ___lambda31__gfunc, _data2_);
	_tmp2_ = self->priv->file_senders;
	g_list_foreach (_tmp2_, ___lambda32__gfunc, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		SendtoApplication* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->device);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda39_ (Block3Data* _data3_,
             FileSender* sender)
{
	SendtoApplication* self;
	BluetoothDevice* _tmp0_;
	self = _data3_->self;
	g_return_if_fail (sender != NULL);
	_tmp0_ = ((BaseDialog*) sender)->device;
	if (_tmp0_ == _data3_->device) {
		file_sender_add_files (sender, _data3_->files, (gint) _data3_->files_length1, _data3_->device);
		gtk_window_present ((GtkWindow*) sender);
		_data3_->exists = TRUE;
	}
}

static void
___lambda39__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda39_ (self, (FileSender*) data);
}

static gboolean
sendto_application_insert_sender (SendtoApplication* self,
                                  GFile** files,
                                  gint files_length1,
                                  BluetoothDevice* device)
{
	Block3Data* _data3_;
	BluetoothDevice* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->files = files;
	_data3_->files_length1 = files_length1;
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (_data3_->device);
	_data3_->device = _tmp0_;
	_data3_->exists = FALSE;
	_tmp1_ = self->priv->file_senders;
	g_list_foreach (_tmp1_, ___lambda39__gfunc, _data3_);
	result = _data3_->exists;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

static void
__lambda33_ (SendtoApplication* self)
{
	GList* _tmp0_;
	FileReceiver* _tmp1_;
	GList* _tmp2_;
	_tmp0_ = self->priv->file_receivers;
	_tmp1_ = self->priv->file_receiver;
	_tmp2_ = g_list_find (_tmp0_, _tmp1_);
	self->priv->file_receivers = g_list_remove_link (self->priv->file_receivers, _tmp2_);
}

static void
___lambda33__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda33_ ((SendtoApplication*) self);
}

static void
sendto_application_response_accepted (SendtoApplication* self,
                                      const gchar* address,
                                      const char* path)
{
	BluetoothObexTransfer* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	FileReceiver* _tmp10_;
	FileReceiver* _tmp11_;
	FileReceiver* _tmp12_;
	FileReceiver* _tmp13_;
	BluetoothDevice* device = NULL;
	BluetoothObjectManager* _tmp14_;
	BluetoothDevice* _tmp15_;
	FileReceiver* _tmp16_;
	BluetoothDevice* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	g_return_if_fail (path != NULL);
	{
		BluetoothObexTransfer* _tmp0_ = NULL;
		BluetoothObexTransfer* _tmp1_;
		BluetoothObexTransfer* _tmp2_;
		_tmp1_ = (BluetoothObexTransfer*) g_initable_new (BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) path, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
		_tmp0_ = (BluetoothObexTransfer*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->transfer);
		self->priv->transfer = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Application.vala:255: Error getting transfer proxy: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = self->priv->transfer;
	_tmp6_ = bluetooth_obex_transfer_get_name (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		return;
	}
	_tmp10_ = file_receiver_new ((GtkApplication*) self);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->file_receiver);
	self->priv->file_receiver = _tmp10_;
	_tmp11_ = self->priv->file_receiver;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	self->priv->file_receivers = g_list_append (self->priv->file_receivers, _tmp12_);
	_tmp13_ = self->priv->file_receiver;
	g_signal_connect_object ((GtkWidget*) _tmp13_, "destroy", (GCallback) ___lambda33__gtk_widget_destroy, self, 0);
	_tmp14_ = self->priv->manager;
	_tmp15_ = bluetooth_object_manager_get_device (_tmp14_, address);
	device = _tmp15_;
	_tmp16_ = self->priv->file_receiver;
	_tmp17_ = device;
	file_receiver_set_transfer (_tmp16_, _tmp17_, (const gchar*) path);
	_g_object_unref0 (device);
}

static void
sendto_application_response_canceled (SendtoApplication* self,
                                      const char* path)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BluetoothObexTransfer* transfer = NULL;
		BluetoothObexTransfer* _tmp11_;
		transfer = NULL;
		if (path == NULL) {
			FileReceiver* last_receiver = NULL;
			GList* _tmp0_;
			GList* _tmp1_;
			gconstpointer _tmp2_;
			FileReceiver* _tmp3_;
			FileReceiver* _tmp4_;
			FileReceiver* _tmp5_;
			BluetoothObexTransfer* _tmp6_;
			BluetoothObexTransfer* _tmp7_;
			_tmp0_ = self->priv->file_receivers;
			_tmp1_ = g_list_first (_tmp0_);
			_tmp2_ = _tmp1_->data;
			_tmp3_ = (FileReceiver*) _tmp2_;
			_tmp4_ = _g_object_ref0 (IS_FILE_RECEIVER (_tmp3_) ? ((FileReceiver*) _tmp3_) : NULL);
			last_receiver = _tmp4_;
			_tmp5_ = last_receiver;
			_tmp6_ = ((BaseDialog*) _tmp5_)->transfer;
			_tmp7_ = _g_object_ref0 (_tmp6_);
			_g_object_unref0 (transfer);
			transfer = _tmp7_;
			_g_object_unref0 (last_receiver);
		} else {
			BluetoothObexTransfer* _tmp8_ = NULL;
			BluetoothObexTransfer* _tmp9_;
			BluetoothObexTransfer* _tmp10_;
			_tmp9_ = (BluetoothObexTransfer*) g_initable_new (BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) path, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
			_tmp8_ = (BluetoothObexTransfer*) _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (transfer);
				goto __catch0_g_error;
			}
			_tmp10_ = _tmp8_;
			_tmp8_ = NULL;
			_g_object_unref0 (transfer);
			transfer = _tmp10_;
			_g_object_unref0 (_tmp8_);
		}
		_tmp11_ = transfer;
		bluetooth_obex_transfer_cancel (_tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (transfer);
			goto __catch0_g_error;
		}
		_g_object_unref0 (transfer);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("Application.vala:284: Error cancelling file transfer: %s", _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
___lambda34_ (SendtoApplication* self)
{
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	gboolean result;
	_tmp0_ = g_variant_new_string ("Cancel");
	g_variant_ref_sink (_tmp0_);
	_tmp1_ = _tmp0_;
	g_action_group_activate_action ((GActionGroup*) self, "btcancel", _tmp1_);
	_g_variant_unref0 (_tmp1_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda34__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda34_ ((SendtoApplication*) self);
	return result;
}

static void
sendto_application_response_notify (SendtoApplication* self,
                                    const gchar* address,
                                    const char* object_path)
{
	BluetoothDevice* device = NULL;
	BluetoothObjectManager* _tmp0_;
	BluetoothDevice* _tmp1_;
	GNotification* notification = NULL;
	GNotification* _tmp7_;
	GNotification* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GThemedIcon* _tmp12_;
	GThemedIcon* _tmp13_;
	BluetoothObexTransfer* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	BluetoothObexTransfer* _tmp18_;
	guint64 _tmp19_;
	guint64 _tmp20_;
	gboolean _tmp21_;
	GNotification* _tmp31_;
	GNotification* _tmp32_;
	GNotification* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	BluetoothObexTransfer* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	BluetoothObexTransfer* _tmp41_;
	guint64 _tmp42_;
	guint64 _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GNotification* _tmp48_;
	GVariant* _tmp49_;
	GVariant* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GNotification* _tmp53_;
	GVariant* _tmp54_;
	GVariant* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GNotification* _tmp58_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (address != NULL);
	g_return_if_fail (object_path != NULL);
	_tmp0_ = self->priv->manager;
	_tmp1_ = bluetooth_object_manager_get_device (_tmp0_, address);
	device = _tmp1_;
	{
		BluetoothObexTransfer* _tmp2_ = NULL;
		BluetoothObexTransfer* _tmp3_;
		BluetoothObexTransfer* _tmp4_;
		_tmp3_ = (BluetoothObexTransfer*) g_initable_new (BLUETOOTH_OBEX_TYPE_TRANSFER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) object_path, "g-interface-name", "org.bluez.obex.Transfer1", NULL);
		_tmp2_ = (BluetoothObexTransfer*) _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->transfer);
		self->priv->transfer = _tmp4_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("Application.vala:294: Error getting transfer proxy: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (device);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = g_notification_new ("Bluetooth");
	notification = _tmp7_;
	_tmp8_ = notification;
	_tmp9_ = bluetooth_device_get_icon (device);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp12_ = (GThemedIcon*) g_themed_icon_new (_tmp11_);
	_tmp13_ = _tmp12_;
	g_notification_set_icon (_tmp8_, (GIcon*) _tmp13_);
	_g_object_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	_tmp14_ = self->priv->transfer;
	_tmp15_ = bluetooth_obex_transfer_get_name (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->transfer;
	_tmp19_ = bluetooth_obex_transfer_get_size (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = sendto_application_reject_if_exists (self, _tmp17_, _tmp20_);
	_g_free0 (_tmp17_);
	if (_tmp21_) {
		GNotification* _tmp22_;
		GNotification* _tmp23_;
		BluetoothObexTransfer* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GNotification* _tmp30_;
		_tmp22_ = notification;
		g_notification_set_title (_tmp22_, _ ("Rejected file"));
		_tmp23_ = notification;
		_tmp24_ = self->priv->transfer;
		_tmp25_ = bluetooth_obex_transfer_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf (_ ("File already exists: %s"), _tmp27_);
		_tmp29_ = _tmp28_;
		g_notification_set_body (_tmp23_, _tmp29_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_tmp30_ = notification;
		g_application_send_notification ((GApplication*) self, "org.buddiesofbudgie.bluetooth", _tmp30_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda34__gsource_func, g_object_ref (self), g_object_unref);
		_g_object_unref0 (notification);
		_g_object_unref0 (device);
		return;
	}
	_tmp31_ = notification;
	g_notification_set_priority (_tmp31_, G_NOTIFICATION_PRIORITY_URGENT);
	_tmp32_ = notification;
	g_notification_set_title (_tmp32_, _ ("Receiving file"));
	_tmp33_ = notification;
	_tmp34_ = bluetooth_device_get_alias (device);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->transfer;
	_tmp38_ = bluetooth_obex_transfer_get_name (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_;
	_tmp41_ = self->priv->transfer;
	_tmp42_ = bluetooth_obex_transfer_get_size (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_format_size_full (_tmp43_, G_FORMAT_SIZE_DEFAULT);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strdup_printf (_ ("Device '%s' wants to send a file: %s %s"), _tmp36_, _tmp40_, _tmp45_);
	_tmp47_ = _tmp46_;
	g_notification_set_body (_tmp33_, _tmp47_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp36_);
	_tmp48_ = notification;
	_tmp49_ = g_variant_new_string ("Accept");
	g_variant_ref_sink (_tmp49_);
	_tmp50_ = _tmp49_;
	_tmp51_ = g_action_print_detailed_name ("app.btaccept", _tmp50_);
	_tmp52_ = _tmp51_;
	g_notification_add_button (_tmp48_, _ ("Accept"), _tmp52_);
	_g_free0 (_tmp52_);
	_g_variant_unref0 (_tmp50_);
	_tmp53_ = notification;
	_tmp54_ = g_variant_new_string ("Cancel");
	g_variant_ref_sink (_tmp54_);
	_tmp55_ = _tmp54_;
	_tmp56_ = g_action_print_detailed_name ("app.btcancel", _tmp55_);
	_tmp57_ = _tmp56_;
	g_notification_add_button (_tmp53_, _ ("Reject"), _tmp57_);
	_g_free0 (_tmp57_);
	_g_variant_unref0 (_tmp55_);
	_tmp58_ = notification;
	g_application_send_notification ((GApplication*) self, "org.buddiesofbudgie.bluetooth", _tmp58_);
	_g_object_unref0 (notification);
	_g_object_unref0 (device);
}

static gboolean
sendto_application_reject_if_exists (SendtoApplication* self,
                                     const gchar* name,
                                     guint64 size)
{
	gchar* input_path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* input_file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	guint64 file_size = 0ULL;
	GFile* _tmp4_;
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
	_tmp1_ = g_build_filename (_tmp0_, name, NULL);
	input_path = _tmp1_;
	_tmp2_ = input_path;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	input_file = _tmp3_;
	file_size = (guint64) 0;
	_tmp4_ = input_file;
	if (g_file_query_exists (_tmp4_, NULL)) {
		{
			GFileInfo* file_info = NULL;
			GFile* _tmp5_;
			GFileInfo* _tmp6_;
			GFileInfo* _tmp7_;
			_tmp5_ = input_file;
			_tmp6_ = g_file_query_info (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			file_info = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp7_ = file_info;
			file_size = (guint64) g_file_info_get_size (_tmp7_);
			_g_object_unref0 (file_info);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("Application.vala:338: Error getting file size: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			_g_object_unref0 (input_file);
			_g_free0 (input_path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	if (size == file_size) {
		GFile* _tmp12_;
		_tmp12_ = input_file;
		_tmp11_ = g_file_query_exists (_tmp12_, NULL);
	} else {
		_tmp11_ = FALSE;
	}
	result = _tmp11_;
	_g_object_unref0 (input_file);
	_g_free0 (input_path);
	return result;
}

SendtoApplication*
sendto_application_construct (GType object_type)
{
	SendtoApplication * self = NULL;
	self = (SendtoApplication*) g_object_new (object_type, NULL);
	return self;
}

SendtoApplication*
sendto_application_new (void)
{
	return sendto_application_construct (TYPE_SENDTO_APPLICATION);
}

static GObject *
sendto_application_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SendtoApplication * self;
	GApplicationFlags _tmp0_;
	GApplicationFlags _tmp1_;
	parent_class = G_OBJECT_CLASS (sendto_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SENDTO_APPLICATION, SendtoApplication);
	g_application_set_application_id ((GApplication*) self, "org.buddiesofbudgie.Sendto");
	_tmp0_ = g_application_get_flags ((GApplication*) self);
	_tmp1_ = _tmp0_;
	g_application_set_flags ((GApplication*) self, _tmp1_ | G_APPLICATION_HANDLES_COMMAND_LINE);
	return obj;
}

static void
sendto_application_class_init (SendtoApplicationClass * klass,
                               gpointer klass_data)
{
	gchar** _tmp0_;
	sendto_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SendtoApplication_private_offset);
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) sendto_application_real_command_line;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) sendto_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = sendto_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = sendto_application_finalize;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	sendto_application_arg_files = _tmp0_;
}

static void
sendto_application_instance_init (SendtoApplication * self,
                                  gpointer klass)
{
	self->priv = sendto_application_get_instance_private (self);
}

static void
sendto_application_finalize (GObject * obj)
{
	SendtoApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SENDTO_APPLICATION, SendtoApplication);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->agent);
	_g_object_unref0 (self->priv->transfer);
	_g_object_unref0 (self->priv->file_receiver);
	_g_object_unref0 (self->priv->file_sender);
	(self->priv->file_receivers == NULL) ? NULL : (self->priv->file_receivers = (_g_list_free__g_object_unref0_ (self->priv->file_receivers), NULL));
	(self->priv->file_senders == NULL) ? NULL : (self->priv->file_senders = (_g_list_free__g_object_unref0_ (self->priv->file_senders), NULL));
	_g_object_unref0 (self->priv->scan_dialog);
	G_OBJECT_CLASS (sendto_application_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sendto_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SendtoApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sendto_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SendtoApplication), 0, (GInstanceInitFunc) sendto_application_instance_init, NULL };
	GType sendto_application_type_id;
	sendto_application_type_id = g_type_register_static (gtk_application_get_type (), "SendtoApplication", &g_define_type_info, 0);
	SendtoApplication_private_offset = g_type_add_instance_private (sendto_application_type_id, sizeof (SendtoApplicationPrivate));
	return sendto_application_type_id;
}

GType
sendto_application_get_type (void)
{
	static volatile gsize sendto_application_type_id__once = 0;
	if (g_once_init_enter (&sendto_application_type_id__once)) {
		GType sendto_application_type_id;
		sendto_application_type_id = sendto_application_get_type_once ();
		g_once_init_leave (&sendto_application_type_id__once, sendto_application_type_id);
	}
	return sendto_application_type_id__once;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	SendtoApplication* app = NULL;
	SendtoApplication* _tmp0_;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (BUDGIE_GETTEXT_PACKAGE, BUDGIE_LOCALEDIR);
	bind_textdomain_codeset (BUDGIE_GETTEXT_PACKAGE, "UTF-8");
	textdomain (BUDGIE_GETTEXT_PACKAGE);
	_tmp0_ = sendto_application_new ();
	app = _tmp0_;
	result = g_application_run ((GApplication*) app, (gint) args_length1, args);
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

