/* MountItem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from MountItem.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "placesindicator.h"
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MOUNT_ITEM_0_PROPERTY,
	MOUNT_ITEM_NUM_PROPERTIES
};
static GParamSpec* mount_item_properties[MOUNT_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MountItemPrivate {
	MountHelper* operation;
	GMount* mount;
};

struct _Block2Data {
	int _ref_count_;
	MountItem* self;
	GMount* mount;
};

static gint MountItem_private_offset;
static gpointer mount_item_parent_class = NULL;
static GType mount_item_type_id = 0;

static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda10_ (Block2Data* _data2_);
static void mount_item_do_eject (MountItem* self);
static void mount_item_do_unmount (MountItem* self);
static void ___lambda10__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda11_ (Block2Data* _data2_);
static void ___lambda11__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void mount_item_on_eject (MountItem* self,
                          GObject* obj,
                          GAsyncResult* res);
static void _mount_item_on_eject_gasync_ready_callback (GObject* source_object,
                                                 GAsyncResult* res,
                                                 gpointer self);
static void mount_item_on_unmount (MountItem* self,
                            GObject* obj,
                            GAsyncResult* res);
static void _mount_item_on_unmount_gasync_ready_callback (GObject* source_object,
                                                   GAsyncResult* res,
                                                   gpointer self);
static void mount_item_finalize (GObject * obj);

static inline gpointer
mount_item_get_instance_private (MountItem* self)
{
	return G_STRUCT_MEMBER_P (self, MountItem_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		MountItem* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->mount);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda10_ (Block2Data* _data2_)
{
	MountItem* self;
	self = _data2_->self;
	if (g_mount_can_eject (_data2_->mount)) {
		mount_item_do_eject (self);
	} else {
		mount_item_do_unmount (self);
	}
}

static void
___lambda10__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda10_ (self);
}

static void
__lambda11_ (Block2Data* _data2_)
{
	MountItem* self;
	GFile* _tmp0_;
	GFile* _tmp1_;
	self = _data2_->self;
	_tmp0_ = g_mount_get_root (_data2_->mount);
	_tmp1_ = _tmp0_;
	list_item_open_directory ((ListItem*) self, _tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda11__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda11_ (self);
}

MountItem*
mount_item_construct (GType object_type,
                      GMount* mount,
                      const gchar* class)
{
	MountItem * self = NULL;
	Block2Data* _data2_;
	GMount* _tmp0_;
	gchar* _tmp1_;
	GMount* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GQuark _tmp6_ = 0U;
	static GQuark _tmp5_label0 = 0;
	static GQuark _tmp5_label1 = 0;
	static GQuark _tmp5_label2 = 0;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GIcon* _tmp13_;
	GIcon* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	MountHelper* _tmp17_;
	GtkButton* unmount_button = NULL;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkStyleContext* _tmp20_;
	GtkButton* _tmp21_;
	GtkButton* _tmp22_;
	GtkButton* _tmp23_;
	GtkOverlay* _tmp24_;
	GtkButton* _tmp25_;
	GtkButton* _tmp26_;
	GtkToolButton* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	GtkToolButton* _tmp34_;
	g_return_val_if_fail (mount != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (mount);
	_g_object_unref0 (_data2_->mount);
	_data2_->mount = _tmp0_;
	self = (MountItem*) list_item_construct (object_type);
	_data2_->self = g_object_ref (self);
	_tmp1_ = g_strdup (class);
	_g_free0 (((ListItem*) self)->item_class);
	((ListItem*) self)->item_class = _tmp1_;
	_tmp2_ = _g_object_ref0 (_data2_->mount);
	_g_object_unref0 (self->priv->mount);
	self->priv->mount = _tmp2_;
	_tmp3_ = ((ListItem*) self)->item_class;
	_tmp4_ = _tmp3_;
	_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
	if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("device")))) {
		switch (0) {
			default:
			{
				if (g_mount_can_eject (_data2_->mount)) {
					gchar* _tmp7_;
					_tmp7_ = g_strdup (_ ("Removable devices"));
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp7_;
				} else {
					gchar* _tmp8_;
					_tmp8_ = g_strdup (_ ("Local volumes"));
					_g_free0 (((ListItem*) self)->category_name);
					((ListItem*) self)->category_name = _tmp8_;
				}
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("network")))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup (_ ("Network folders"));
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp9_;
				break;
			}
		}
	} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string (NULL)))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup (_ ("Other"));
				_g_free0 (((ListItem*) self)->category_name);
				((ListItem*) self)->category_name = _tmp10_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_tmp11_ = g_mount_get_name (_data2_->mount);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_mount_get_symbolic_icon (_data2_->mount);
	_tmp14_ = _tmp13_;
	_tmp15_ = list_item_get_icon ((ListItem*) self, _tmp14_);
	_tmp16_ = _tmp15_;
	list_item_set_button ((ListItem*) self, _tmp12_, _tmp16_, FALSE, FALSE);
	_g_object_unref0 (_tmp16_);
	_g_object_unref0 (_tmp14_);
	_g_free0 (_tmp12_);
	_tmp17_ = mount_helper_new ();
	_g_object_unref0 (self->priv->operation);
	self->priv->operation = _tmp17_;
	_tmp18_ = (GtkButton*) gtk_button_new_from_icon_name ("media-eject-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp18_);
	unmount_button = _tmp18_;
	_tmp19_ = unmount_button;
	_tmp20_ = gtk_widget_get_style_context ((GtkWidget*) _tmp19_);
	gtk_style_context_add_class (_tmp20_, "unmount-button");
	_tmp21_ = unmount_button;
	gtk_button_set_relief (_tmp21_, GTK_RELIEF_NONE);
	_tmp22_ = unmount_button;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp22_, FALSE);
	_tmp23_ = unmount_button;
	gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_END);
	_tmp24_ = ((ListItem*) self)->overlay;
	_tmp25_ = unmount_button;
	gtk_overlay_add_overlay (_tmp24_, (GtkWidget*) _tmp25_);
	_tmp26_ = unmount_button;
	g_signal_connect_data (_tmp26_, "clicked", (GCallback) ___lambda10__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	if (g_mount_can_eject (_data2_->mount)) {
		GtkButton* _tmp27_;
		_tmp27_ = unmount_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp27_, _ ("Eject"));
	} else {
		GtkButton* _tmp28_;
		_tmp28_ = unmount_button;
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp28_, _ ("Unmount"));
	}
	_tmp29_ = ((ListItem*) self)->name_button;
	_tmp30_ = g_mount_get_name (_data2_->mount);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strdup_printf (_ ("Open \"%s\""), _tmp31_);
	_tmp33_ = _tmp32_;
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp29_, _tmp33_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_tmp34_ = ((ListItem*) self)->name_button;
	g_signal_connect_data (_tmp34_, "clicked", (GCallback) ___lambda11__gtk_tool_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_g_object_unref0 (unmount_button);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

MountItem*
mount_item_new (GMount* mount,
                const gchar* class)
{
	return mount_item_construct (TYPE_MOUNT_ITEM, mount, class);
}

static void
_mount_item_on_eject_gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self)
{
	mount_item_on_eject ((MountItem*) self, source_object, res);
	g_object_unref (self);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
mount_item_do_eject (MountItem* self)
{
	GMount* _tmp0_;
	MountHelper* _tmp1_;
	gchar* safe_remove = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	GMount* _tmp4_;
	GDrive* _tmp5_;
	GDrive* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* device_name = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mount;
	_tmp1_ = self->priv->operation;
	g_mount_eject_with_operation (_tmp0_, G_MOUNT_UNMOUNT_NONE, (GMountOperation*) _tmp1_, NULL, _mount_item_on_eject_gasync_ready_callback, g_object_ref (self));
	_tmp2_ = g_strdup (_ ("You can now safely remove"));
	safe_remove = _tmp2_;
	_tmp4_ = self->priv->mount;
	_tmp5_ = g_mount_get_drive (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_drive_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp6_);
	_tmp3_ = _tmp8_;
	if (_tmp3_ == NULL) {
		gchar* _tmp9_;
		_tmp9_ = g_strdup (_ ("Unknown Device"));
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp9_;
	}
	_tmp10_ = _tmp3_;
	_tmp3_ = NULL;
	device_name = _tmp10_;
	_tmp11_ = safe_remove;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = string_to_string (device_name);
	_tmp14_ = g_strconcat (_tmp12_, " \"", _tmp13_, "\"", NULL);
	_tmp15_ = _tmp14_;
	g_signal_emit_by_name ((ListItem*) self, "send-message", _tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (device_name);
	_g_free0 (_tmp3_);
	_g_free0 (safe_remove);
}

static void
mount_item_on_eject (MountItem* self,
                     GObject* obj,
                     GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	{
		GMount* _tmp0_;
		_tmp0_ = self->priv->mount;
		g_mount_eject_with_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_signal_emit_by_name ((ListItem*) self, "send-message", _ ("Error while ejecting device"));
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("MountItem.vala:85: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_mount_item_on_unmount_gasync_ready_callback (GObject* source_object,
                                              GAsyncResult* res,
                                              gpointer self)
{
	mount_item_on_unmount ((MountItem*) self, source_object, res);
	g_object_unref (self);
}

static void
mount_item_do_unmount (MountItem* self)
{
	GMount* _tmp0_;
	MountHelper* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mount;
	_tmp1_ = self->priv->operation;
	g_mount_unmount_with_operation (_tmp0_, G_MOUNT_UNMOUNT_NONE, (GMountOperation*) _tmp1_, NULL, _mount_item_on_unmount_gasync_ready_callback, g_object_ref (self));
}

static void
mount_item_on_unmount (MountItem* self,
                       GObject* obj,
                       GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	{
		GMount* _tmp0_;
		_tmp0_ = self->priv->mount;
		g_mount_unmount_with_operation_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_signal_emit_by_name ((ListItem*) self, "send-message", _ ("Error while unmounting volume"));
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("MountItem.vala:101: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
mount_item_class_init (MountItemClass * klass,
                       gpointer klass_data)
{
	mount_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MountItem_private_offset);
	G_OBJECT_CLASS (klass)->finalize = mount_item_finalize;
}

static void
mount_item_instance_init (MountItem * self,
                          gpointer klass)
{
	self->priv = mount_item_get_instance_private (self);
}

static void
mount_item_finalize (GObject * obj)
{
	MountItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_ITEM, MountItem);
	_g_object_unref0 (self->priv->operation);
	_g_object_unref0 (self->priv->mount);
	G_OBJECT_CLASS (mount_item_parent_class)->finalize (obj);
}

GType
mount_item_get_type (void)
{
	return mount_item_type_id;
}

GType
mount_item_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (MountItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountItem), 0, (GInstanceInitFunc) mount_item_instance_init, NULL };
	mount_item_type_id = g_type_module_register_type (module, TYPE_LIST_ITEM, "MountItem", &g_define_type_info, 0);
	MountItem_private_offset = sizeof (MountItemPrivate);
	return mount_item_type_id;
}

