/* mount_item.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from mount_item.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DESKTOP_ITEM (desktop_item_get_type ())
#define DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_ITEM, DesktopItem))
#define DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_ITEM, DesktopItemClass))
#define IS_DESKTOP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_ITEM))
#define IS_DESKTOP_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_ITEM))
#define DESKTOP_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_ITEM, DesktopItemClass))

typedef struct _DesktopItem DesktopItem;
typedef struct _DesktopItemClass DesktopItemClass;
typedef struct _DesktopItemPrivate DesktopItemPrivate;

#define TYPE_UNIFIED_PROPS (unified_props_get_type ())
#define UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIFIED_PROPS, UnifiedProps))
#define UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNIFIED_PROPS, UnifiedPropsClass))
#define IS_UNIFIED_PROPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIFIED_PROPS))
#define IS_UNIFIED_PROPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNIFIED_PROPS))
#define UNIFIED_PROPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNIFIED_PROPS, UnifiedPropsClass))

typedef struct _UnifiedProps UnifiedProps;
typedef struct _UnifiedPropsClass UnifiedPropsClass;

#define TYPE_MOUNT_ITEM (mount_item_get_type ())
#define MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ITEM, MountItem))
#define MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ITEM, MountItemClass))
#define IS_MOUNT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ITEM))
#define IS_MOUNT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ITEM))
#define MOUNT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ITEM, MountItemClass))

typedef struct _MountItem MountItem;
typedef struct _MountItemClass MountItemClass;
typedef struct _MountItemPrivate MountItemPrivate;
enum  {
	MOUNT_ITEM_0_PROPERTY,
	MOUNT_ITEM_NUM_PROPERTIES
};
static GParamSpec* mount_item_properties[MOUNT_ITEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
enum  {
	MOUNT_ITEM_DRIVE_DISCONNECTED_SIGNAL,
	MOUNT_ITEM_MOUNT_NAME_CHANGED_SIGNAL,
	MOUNT_ITEM_NUM_SIGNALS
};
static guint mount_item_signals[MOUNT_ITEM_NUM_SIGNALS] = {0};

struct _DesktopItem {
	GtkFlowBoxChild parent_instance;
	DesktopItemPrivate * priv;
	UnifiedProps* props;
	gint _label_width;
	gboolean _copying;
	gboolean _mount;
	gchar* _name;
	gchar* _type;
	gboolean _special_dir;
	GtkImage* image;
	GtkLabel* label;
	GtkEventBox* event_box;
	GtkBox* main_layout;
	GdkPixbuf* original_image_pixbuf;
	GIcon* icon;
};

struct _DesktopItemClass {
	GtkFlowBoxChildClass parent_class;
};

struct _MountItem {
	DesktopItem parent_instance;
	MountItemPrivate * priv;
	GMount* mount;
	GFile* mount_file;
	gchar* uuid;
};

struct _MountItemClass {
	DesktopItemClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	MountItem* self;
	gchar** new_icon_set;
	gint new_icon_set_length1;
	gint _new_icon_set_size_;
};

static gpointer mount_item_parent_class = NULL;

VALA_EXTERN GType desktop_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopItem, g_object_unref)
VALA_EXTERN GType unified_props_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnifiedProps, g_object_unref)
VALA_EXTERN GType mount_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountItem, g_object_unref)
VALA_EXTERN MountItem* mount_item_new (UnifiedProps* p,
                           GMount* provided_mount,
                           const gchar* true_uuid);
VALA_EXTERN MountItem* mount_item_construct (GType object_type,
                                 UnifiedProps* p,
                                 GMount* provided_mount,
                                 const gchar* true_uuid);
VALA_EXTERN DesktopItem* desktop_item_new (void);
VALA_EXTERN DesktopItem* desktop_item_construct (GType object_type);
VALA_EXTERN void desktop_item_set_is_mount (DesktopItem* self,
                                gboolean value);
VALA_EXTERN void desktop_item_set_icon_factors (DesktopItem* self,
                                    GError** error);
VALA_EXTERN void mount_item_update_item (MountItem* self);
static void __lambda8_ (MountItem* self);
static void ___lambda8__g_mount_changed (GMount* _sender,
                                  gpointer self);
static void __lambda9_ (MountItem* self);
static void ___lambda9__g_mount_unmounted (GMount* _sender,
                                    gpointer self);
static void ___lambda10_ (MountItem* self);
static void ____lambda10__g_drive_disconnected (GDrive* _sender,
                                         gpointer self);
static void ___lambda11_ (MountItem* self);
static void ____lambda11__g_volume_removed (GVolume* _sender,
                                     gpointer self);
static gboolean mount_item_on_button_press (MountItem* self,
                                     GdkEventButton* ev);
static gboolean _mount_item_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self);
VALA_EXTERN gboolean mount_item_on_button_release (MountItem* self,
                                       GdkEventButton* ev);
static gboolean _mount_item_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                        GdkEventButton* event,
                                                                        gpointer self);
VALA_EXTERN gboolean unified_props_get_is_single_click (UnifiedProps* self);
VALA_EXTERN gboolean unified_props_is_desired_primary_click_type (UnifiedProps* self,
                                                      GdkEventButton* ev);
VALA_EXTERN void mount_item_launch (MountItem* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN const gchar* desktop_item_get_label_name (DesktopItem* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN void desktop_item_set_label_name (DesktopItem* self,
                                  const gchar* value);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void __lambda7_ (Block4Data* _data4_,
                 const gchar* icon);
static void _vala_array_add18 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void ___lambda7__gfunc (gconstpointer data,
                        gpointer self);
VALA_EXTERN void desktop_item_set_icon (DesktopItem* self,
                            GIcon* ico,
                            GError** error);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
static void mount_item_finalize (GObject * obj);
static GType mount_item_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda8_ (MountItem* self)
{
	mount_item_update_item (self);
}

static void
___lambda8__g_mount_changed (GMount* _sender,
                             gpointer self)
{
	__lambda8_ ((MountItem*) self);
}

static void
__lambda9_ (MountItem* self)
{
	g_signal_emit (self, mount_item_signals[MOUNT_ITEM_DRIVE_DISCONNECTED_SIGNAL], 0, self);
}

static void
___lambda9__g_mount_unmounted (GMount* _sender,
                               gpointer self)
{
	__lambda9_ ((MountItem*) self);
}

static void
___lambda10_ (MountItem* self)
{
	g_signal_emit (self, mount_item_signals[MOUNT_ITEM_DRIVE_DISCONNECTED_SIGNAL], 0, self);
}

static void
____lambda10__g_drive_disconnected (GDrive* _sender,
                                    gpointer self)
{
	___lambda10_ ((MountItem*) self);
}

static void
___lambda11_ (MountItem* self)
{
	g_signal_emit (self, mount_item_signals[MOUNT_ITEM_DRIVE_DISCONNECTED_SIGNAL], 0, self);
}

static void
____lambda11__g_volume_removed (GVolume* _sender,
                                gpointer self)
{
	___lambda11_ ((MountItem*) self);
}

static gboolean
_mount_item_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                           GdkEventButton* event,
                                                           gpointer self)
{
	gboolean result;
	result = mount_item_on_button_press ((MountItem*) self, event);
	return result;
}

static gboolean
_mount_item_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                               GdkEventButton* event,
                                                               gpointer self)
{
	gboolean result;
	result = mount_item_on_button_release ((MountItem*) self, event);
	return result;
}

MountItem*
mount_item_construct (GType object_type,
                      UnifiedProps* p,
                      GMount* provided_mount,
                      const gchar* true_uuid)
{
	MountItem * self = NULL;
	GMount* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GMount* _tmp5_;
	GMount* _tmp6_;
	GDrive* mount_drive = NULL;
	GMount* _tmp7_;
	GDrive* _tmp8_;
	GDrive* _tmp9_;
	GVolume* mount_volume = NULL;
	GMount* _tmp11_;
	GVolume* _tmp12_;
	GVolume* _tmp13_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (p != NULL, NULL);
	g_return_val_if_fail (provided_mount != NULL, NULL);
	g_return_val_if_fail (true_uuid != NULL, NULL);
	self = (MountItem*) desktop_item_construct (object_type);
	((DesktopItem*) self)->props = p;
	desktop_item_set_is_mount ((DesktopItem*) self, TRUE);
	_tmp0_ = _g_object_ref0 (provided_mount);
	_g_object_unref0 (self->mount);
	self->mount = _tmp0_;
	_tmp1_ = g_strdup (true_uuid);
	_g_free0 (self->uuid);
	self->uuid = _tmp1_;
	_tmp2_ = g_strdup ("mount");
	_g_free0 (((DesktopItem*) self)->_type);
	((DesktopItem*) self)->_type = _tmp2_;
	{
		desktop_item_set_icon_factors ((DesktopItem*) self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("mount_item.vala:38: Failed to set icon factors when generating a Mount" \
"Item: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	mount_item_update_item (self);
	_tmp5_ = self->mount;
	g_signal_connect_object (_tmp5_, "changed", (GCallback) ___lambda8__g_mount_changed, self, 0);
	_tmp6_ = self->mount;
	g_signal_connect_object (_tmp6_, "unmounted", (GCallback) ___lambda9__g_mount_unmounted, self, 0);
	_tmp7_ = self->mount;
	_tmp8_ = g_mount_get_drive (_tmp7_);
	mount_drive = _tmp8_;
	_tmp9_ = mount_drive;
	if (_tmp9_ != NULL) {
		GDrive* _tmp10_;
		_tmp10_ = mount_drive;
		g_signal_connect_object (_tmp10_, "disconnected", (GCallback) ____lambda10__g_drive_disconnected, self, 0);
	}
	_tmp11_ = self->mount;
	_tmp12_ = g_mount_get_volume (_tmp11_);
	mount_volume = _tmp12_;
	_tmp13_ = mount_volume;
	if (_tmp13_ != NULL) {
		GVolume* _tmp14_;
		_tmp14_ = mount_volume;
		g_signal_connect_object (_tmp14_, "removed", (GCallback) ____lambda11__g_volume_removed, self, 0);
	}
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _mount_item_on_button_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _mount_item_on_button_release_gtk_widget_button_release_event, self, 0);
	_g_object_unref0 (mount_volume);
	_g_object_unref0 (mount_drive);
	return self;
}

MountItem*
mount_item_new (UnifiedProps* p,
                GMount* provided_mount,
                const gchar* true_uuid)
{
	return mount_item_construct (TYPE_MOUNT_ITEM, p, provided_mount, true_uuid);
}

gboolean
mount_item_on_button_release (MountItem* self,
                              GdkEventButton* ev)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	UnifiedProps* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	if (ev->button != ((guint) 1)) {
		result = GDK_EVENT_STOP;
		return result;
	}
	_tmp2_ = ((DesktopItem*) self)->props;
	_tmp3_ = unified_props_get_is_single_click (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = ev->type == GDK_BUTTON_RELEASE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		UnifiedProps* _tmp5_;
		_tmp5_ = ((DesktopItem*) self)->props;
		_tmp0_ = unified_props_is_desired_primary_click_type (_tmp5_, ev);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		mount_item_launch (self);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static gboolean
mount_item_on_button_press (MountItem* self,
                            GdkEventButton* ev)
{
	gboolean _tmp0_ = FALSE;
	UnifiedProps* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ev != NULL, FALSE);
	_tmp1_ = ((DesktopItem*) self)->props;
	_tmp2_ = unified_props_get_is_single_click (_tmp1_);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		UnifiedProps* _tmp4_;
		_tmp4_ = ((DesktopItem*) self)->props;
		_tmp0_ = unified_props_is_desired_primary_click_type (_tmp4_, ev);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		mount_item_launch (self);
		result = GDK_EVENT_STOP;
		return result;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
mount_item_launch (MountItem* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GAppInfo* appinfo = NULL;
		GFile* _tmp0_;
		GAppInfo* _tmp1_;
		GList* files = NULL;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GAppInfo* _tmp4_;
		GList* _tmp5_;
		_tmp0_ = self->mount_file;
		_tmp1_ = g_file_query_default_handler (_tmp0_, NULL, &_inner_error0_);
		appinfo = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		files = NULL;
		_tmp2_ = self->mount_file;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		files = g_list_append (files, _tmp3_);
		_tmp4_ = appinfo;
		_tmp5_ = files;
		g_app_info_launch (_tmp4_, _tmp5_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (appinfo);
			goto __catch0_g_error;
		}
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (appinfo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = desktop_item_get_label_name ((DesktopItem*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("mount_item.vala:108: Failed to launch %s: %s", _tmp7_, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MountItem* self;
		self = _data4_->self;
		_data4_->new_icon_set = (_vala_array_free (_data4_->new_icon_set, _data4_->new_icon_set_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
_vala_array_add18 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda7_ (Block4Data* _data4_,
            const gchar* icon)
{
	MountItem* self;
	gchar* _tmp0_;
	self = _data4_->self;
	g_return_if_fail (icon != NULL);
	_tmp0_ = g_strdup (icon);
	_vala_array_add18 (&_data4_->new_icon_set, &_data4_->new_icon_set_length1, &_data4_->_new_icon_set_size_, _tmp0_);
}

static void
___lambda7__gfunc (gconstpointer data,
                   gpointer self)
{
	__lambda7_ (self, (const gchar*) data);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

void
mount_item_update_item (MountItem* self)
{
	Block4Data* _data4_;
	gchar* mount_name = NULL;
	GMount* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GMount* _tmp9_;
	GFile* _tmp10_;
	GList* icons_list = NULL;
	gchar** sym_icons = NULL;
	GMount* _tmp11_;
	GIcon* _tmp12_;
	GThemedIcon* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
	gint sym_icons_length1;
	gint _sym_icons_size_;
	gchar** _tmp30_;
	GList* _tmp31_;
	GThemedIcon* icon = NULL;
	GThemedIcon* _tmp32_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->mount;
	_tmp1_ = g_mount_get_name (_tmp0_);
	mount_name = _tmp1_;
	_tmp2_ = desktop_item_get_label_name ((DesktopItem*) self);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		const gchar* _tmp4_;
		_tmp4_ = mount_name;
		desktop_item_set_label_name ((DesktopItem*) self, _tmp4_);
	} else {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = desktop_item_get_label_name ((DesktopItem*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = mount_name;
		if (g_strcmp0 (_tmp6_, _tmp7_) != 0) {
			const gchar* _tmp8_;
			_tmp8_ = mount_name;
			desktop_item_set_label_name ((DesktopItem*) self, _tmp8_);
			g_signal_emit (self, mount_item_signals[MOUNT_ITEM_MOUNT_NAME_CHANGED_SIGNAL], 0, self);
		}
	}
	_tmp9_ = self->mount;
	_tmp10_ = g_mount_get_default_location (_tmp9_);
	_g_object_unref0 (self->mount_file);
	self->mount_file = _tmp10_;
	icons_list = NULL;
	_tmp11_ = self->mount;
	_tmp12_ = g_mount_get_symbolic_icon (_tmp11_);
	_tmp13_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, g_themed_icon_get_type (), GThemedIcon);
	_tmp15_ = _tmp14_ = g_themed_icon_get_names (_tmp13_);
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup1 (_tmp15_, _vala_array_length (_tmp14_)) : _tmp15_;
	_tmp16__length1 = _vala_array_length (_tmp14_);
	_tmp17_ = _tmp16_;
	_tmp17__length1 = _tmp16__length1;
	_g_object_unref0 (_tmp13_);
	sym_icons = _tmp17_;
	sym_icons_length1 = _tmp17__length1;
	_sym_icons_size_ = sym_icons_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gchar** _tmp20_;
				gint _tmp20__length1;
				gchar* icon = NULL;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				GList* _tmp26_;
				const gchar* _tmp27_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = i;
					i = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = sym_icons;
				_tmp20__length1 = sym_icons_length1;
				if (!(i < _tmp20__length1)) {
					break;
				}
				_tmp21_ = sym_icons;
				_tmp21__length1 = sym_icons_length1;
				_tmp22_ = _tmp21_[i];
				_tmp23_ = g_strdup (_tmp22_);
				icon = _tmp23_;
				_tmp24_ = icon;
				_tmp25_ = string_replace (_tmp24_, "-symbolic", "");
				_g_free0 (icon);
				icon = _tmp25_;
				_tmp26_ = icons_list;
				_tmp27_ = icon;
				if (g_list_index (_tmp26_, _tmp27_) == -1) {
					const gchar* _tmp28_;
					gchar* _tmp29_;
					_tmp28_ = icon;
					_tmp29_ = g_strdup (_tmp28_);
					icons_list = g_list_append (icons_list, _tmp29_);
				}
				_g_free0 (icon);
			}
		}
	}
	_tmp30_ = g_new0 (gchar*, 0 + 1);
	_data4_->new_icon_set = _tmp30_;
	_data4_->new_icon_set_length1 = 0;
	_data4_->_new_icon_set_size_ = _data4_->new_icon_set_length1;
	_tmp31_ = icons_list;
	g_list_foreach (_tmp31_, ___lambda7__gfunc, _data4_);
	_tmp32_ = (GThemedIcon*) g_themed_icon_new_from_names (_data4_->new_icon_set, _data4_->new_icon_set_length1);
	icon = _tmp32_;
	{
		desktop_item_set_icon ((DesktopItem*) self, (GIcon*) icon, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		g_warning ("mount_item.vala:149: Failed to set the icon for a MountItem: %s", _tmp34_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (icon);
		sym_icons = (_vala_array_free (sym_icons, sym_icons_length1, (GDestroyNotify) g_free), NULL);
		(icons_list == NULL) ? NULL : (icons_list = (_g_list_free__g_free0_ (icons_list), NULL));
		_g_free0 (mount_name);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (icon);
	sym_icons = (_vala_array_free (sym_icons, sym_icons_length1, (GDestroyNotify) g_free), NULL);
	(icons_list == NULL) ? NULL : (icons_list = (_g_list_free__g_free0_ (icons_list), NULL));
	_g_free0 (mount_name);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
mount_item_class_init (MountItemClass * klass,
                       gpointer klass_data)
{
	mount_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = mount_item_finalize;
	mount_item_signals[MOUNT_ITEM_DRIVE_DISCONNECTED_SIGNAL] = g_signal_new ("drive-disconnected", TYPE_MOUNT_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_MOUNT_ITEM);
	mount_item_signals[MOUNT_ITEM_MOUNT_NAME_CHANGED_SIGNAL] = g_signal_new ("mount-name-changed", TYPE_MOUNT_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_MOUNT_ITEM);
}

static void
mount_item_instance_init (MountItem * self,
                          gpointer klass)
{
}

static void
mount_item_finalize (GObject * obj)
{
	MountItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOUNT_ITEM, MountItem);
	_g_object_unref0 (self->mount);
	_g_object_unref0 (self->mount_file);
	_g_free0 (self->uuid);
	G_OBJECT_CLASS (mount_item_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
mount_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MountItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountItem), 0, (GInstanceInitFunc) mount_item_instance_init, NULL };
	GType mount_item_type_id;
	mount_item_type_id = g_type_register_static (TYPE_DESKTOP_ITEM, "MountItem", &g_define_type_info, 0);
	return mount_item_type_id;
}

GType
mount_item_get_type (void)
{
	static volatile gsize mount_item_type_id__once = 0;
	if (g_once_init_enter (&mount_item_type_id__once)) {
		GType mount_item_type_id;
		mount_item_type_id = mount_item_get_type_once ();
		g_once_init_leave (&mount_item_type_id__once, mount_item_type_id);
	}
	return mount_item_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

