/* AbstractVpnInterface.c generated by valac 0.56.17, the Vala compiler
 * generated from AbstractVpnInterface.vala, do not modify */

/*
 * Copyright 2017-2020 elementary, Inc (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "networkapplet.h"
#include <glib.h>
#include <NetworkManager.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_ABSTRACT_VPN_INTERFACE_0_PROPERTY,
	NETWORK_ABSTRACT_VPN_INTERFACE_ACTIVE_VPN_ITEM_PROPERTY,
	NETWORK_ABSTRACT_VPN_INTERFACE_VPN_STATE_PROPERTY,
	NETWORK_ABSTRACT_VPN_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_abstract_vpn_interface_properties[NETWORK_ABSTRACT_VPN_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _NetworkAbstractVpnInterfacePrivate {
	NetworkVpnMenuItem* _active_vpn_item;
	NetworkState _vpn_state;
};

static gint NetworkAbstractVpnInterface_private_offset;
static gpointer network_abstract_vpn_interface_parent_class = NULL;
static GType network_abstract_vpn_interface_type_id = 0;

static void _network_widget_nm_interface_update_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void network_abstract_vpn_interface_vpn_added_cb (NetworkAbstractVpnInterface* self,
                                                  GObject* obj);
static void _network_abstract_vpn_interface_vpn_added_cb_nm_client_connection_added (NMClient* _sender,
                                                                              NMRemoteConnection* connection,
                                                                              gpointer self);
static void network_abstract_vpn_interface_vpn_removed_cb (NetworkAbstractVpnInterface* self,
                                                    NMRemoteConnection* vpn_);
static void _network_abstract_vpn_interface_vpn_removed_cb_nm_client_connection_removed (NMClient* _sender,
                                                                                  NMRemoteConnection* connection,
                                                                                  gpointer self);
static void __lambda31_ (NetworkAbstractVpnInterface* self,
                  NMRemoteConnection* connection);
static void ___lambda31__gfunc (gconstpointer data,
                         gpointer self);
static void network_abstract_vpn_interface_real_update_name (NetworkWidgetNMInterface* base,
                                                      gint count);
static void network_abstract_vpn_interface_real_update (NetworkWidgetNMInterface* base);
static NetworkVpnMenuItem* network_abstract_vpn_interface_get_item_by_uuid (NetworkAbstractVpnInterface* self,
                                                                     const gchar* uuid);
static void _network_abstract_vpn_interface_vpn_activate_cb_network_vpn_menu_item_user_action (NetworkVpnMenuItem* _sender,
                                                                                        gpointer self);
static void __lambda30_ (NetworkAbstractVpnInterface* self,
                  NMActiveConnection* ac);
static void _network_widget_nm_interface_update_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                              guint state,
                                                                              guint reason,
                                                                              gpointer self);
static void ___lambda30__gfunc (gconstpointer data,
                         gpointer self);
static void network_abstract_vpn_interface_real_vpn_activate_cb (NetworkAbstractVpnInterface* self,
                                                          NetworkVpnMenuItem* i);
static void network_abstract_vpn_interface_real_vpn_deactivate_cb (NetworkAbstractVpnInterface* self);
static GObject * network_abstract_vpn_interface_constructor (GType type,
                                                      guint n_construct_properties,
                                                      GObjectConstructParam * construct_properties);
static void network_abstract_vpn_interface_finalize (GObject * obj);
static void _vala_network_abstract_vpn_interface_get_property (GObject * object,
                                                        guint property_id,
                                                        GValue * value,
                                                        GParamSpec * pspec);
static void _vala_network_abstract_vpn_interface_set_property (GObject * object,
                                                        guint property_id,
                                                        const GValue * value,
                                                        GParamSpec * pspec);

static inline gpointer
network_abstract_vpn_interface_get_instance_private (NetworkAbstractVpnInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkAbstractVpnInterface_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_network_widget_nm_interface_update_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
_network_abstract_vpn_interface_vpn_added_cb_nm_client_connection_added (NMClient* _sender,
                                                                         NMRemoteConnection* connection,
                                                                         gpointer self)
{
	network_abstract_vpn_interface_vpn_added_cb ((NetworkAbstractVpnInterface*) self, connection);
}

static void
_network_abstract_vpn_interface_vpn_removed_cb_nm_client_connection_removed (NMClient* _sender,
                                                                             NMRemoteConnection* connection,
                                                                             gpointer self)
{
	network_abstract_vpn_interface_vpn_removed_cb ((NetworkAbstractVpnInterface*) self, connection);
}

static void
__lambda31_ (NetworkAbstractVpnInterface* self,
             NMRemoteConnection* connection)
{
	g_return_if_fail (connection != NULL);
	network_abstract_vpn_interface_vpn_added_cb (self, (GObject*) connection);
}

static void
___lambda31__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda31_ ((NetworkAbstractVpnInterface*) self, (NMRemoteConnection*) data);
}

void
network_abstract_vpn_interface_init_vpn_interface (NetworkAbstractVpnInterface* self,
                                                   NMClient* _nm_client)
{
	NMClient* _tmp0_;
	NetworkVpnMenuItem* _tmp1_;
	GtkListBox* _tmp2_;
	NetworkVpnMenuItem* _tmp3_;
	NMClient* _tmp4_;
	NMClient* _tmp5_;
	NMClient* _tmp6_;
	NMClient* _tmp7_;
	GPtrArray* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_nm_client != NULL);
	_tmp0_ = _g_object_ref0 (_nm_client);
	_g_object_unref0 (self->nm_client);
	self->nm_client = _tmp0_;
	network_widget_nm_interface_set_display_title ((NetworkWidgetNMInterface*) self, _ ("VPN"));
	_tmp1_ = network_vpn_menu_item_new_blank ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->blank_item);
	self->blank_item = _tmp1_;
	_tmp2_ = self->vpn_list;
	_tmp3_ = self->blank_item;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
	network_abstract_vpn_interface_set_active_vpn_item (self, NULL);
	_tmp4_ = self->nm_client;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::active-connections", (GCallback) _network_widget_nm_interface_update_g_object_notify, (NetworkWidgetNMInterface*) self, 0);
	_tmp5_ = self->nm_client;
	g_signal_connect_object (_tmp5_, "connection-added", (GCallback) _network_abstract_vpn_interface_vpn_added_cb_nm_client_connection_added, self, 0);
	_tmp6_ = self->nm_client;
	g_signal_connect_object (_tmp6_, "connection-removed", (GCallback) _network_abstract_vpn_interface_vpn_removed_cb_nm_client_connection_removed, self, 0);
	_tmp7_ = self->nm_client;
	_tmp8_ = nm_client_get_connections (_tmp7_);
	g_ptr_array_foreach (_tmp8_, ___lambda31__gfunc, self);
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
network_abstract_vpn_interface_real_update_name (NetworkWidgetNMInterface* base,
                                                 gint count)
{
	NetworkAbstractVpnInterface * self;
	self = (NetworkAbstractVpnInterface*) base;
	network_widget_nm_interface_set_display_title ((NetworkWidgetNMInterface*) self, _ ("VPN"));
}

static void
network_abstract_vpn_interface_real_update (NetworkWidgetNMInterface* base)
{
	NetworkAbstractVpnInterface * self;
	NetworkVpnMenuItem* item = NULL;
	NMVpnConnection* _tmp0_;
	NetworkVpnMenuItem* _tmp10_;
	self = (NetworkAbstractVpnInterface*) base;
	network_abstract_vpn_interface_update_active_connection (self);
	item = NULL;
	_tmp0_ = self->active_vpn_connection;
	if (_tmp0_ != NULL) {
		NMVpnConnection* _tmp1_;
		NMVpnConnectionState _tmp2_;
		NMVpnConnectionState _tmp3_;
		_tmp1_ = self->active_vpn_connection;
		_tmp2_ = nm_vpn_connection_get_vpn_state (_tmp1_);
		_tmp3_ = _tmp2_;
		switch (_tmp3_) {
			case NM_VPN_CONNECTION_STATE_UNKNOWN:
			case NM_VPN_CONNECTION_STATE_DISCONNECTED:
			{
				network_abstract_vpn_interface_set_vpn_state (self, NETWORK_STATE_DISCONNECTED);
				network_abstract_vpn_interface_set_active_vpn_item (self, NULL);
				break;
			}
			case NM_VPN_CONNECTION_STATE_PREPARE:
			case NM_VPN_CONNECTION_STATE_IP_CONFIG_GET:
			case NM_VPN_CONNECTION_STATE_CONNECT:
			{
				NMVpnConnection* _tmp4_;
				const gchar* _tmp5_;
				NetworkVpnMenuItem* _tmp6_;
				network_abstract_vpn_interface_set_vpn_state (self, NETWORK_STATE_CONNECTING_VPN);
				_tmp4_ = self->active_vpn_connection;
				_tmp5_ = nm_active_connection_get_uuid ((NMActiveConnection*) _tmp4_);
				_tmp6_ = network_abstract_vpn_interface_get_item_by_uuid (self, _tmp5_);
				_g_object_unref0 (item);
				item = _tmp6_;
				break;
			}
			case NM_VPN_CONNECTION_STATE_FAILED:
			{
				network_abstract_vpn_interface_set_vpn_state (self, NETWORK_STATE_FAILED_VPN);
				network_abstract_vpn_interface_set_active_vpn_item (self, NULL);
				break;
			}
			case NM_VPN_CONNECTION_STATE_ACTIVATED:
			{
				NMVpnConnection* _tmp7_;
				const gchar* _tmp8_;
				NetworkVpnMenuItem* _tmp9_;
				network_abstract_vpn_interface_set_vpn_state (self, NETWORK_STATE_CONNECTED_VPN);
				_tmp7_ = self->active_vpn_connection;
				_tmp8_ = nm_active_connection_get_uuid ((NMActiveConnection*) _tmp7_);
				_tmp9_ = network_abstract_vpn_interface_get_item_by_uuid (self, _tmp8_);
				_g_object_unref0 (item);
				item = _tmp9_;
				gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
				break;
			}
			default:
			break;
		}
	} else {
		network_abstract_vpn_interface_set_vpn_state (self, NETWORK_STATE_DISCONNECTED);
	}
	_tmp10_ = item;
	if (_tmp10_ == NULL) {
		NetworkVpnMenuItem* _tmp11_;
		NetworkVpnMenuItem* _tmp12_;
		_tmp11_ = self->blank_item;
		network_vpn_menu_item_set_active (_tmp11_, TRUE);
		_tmp12_ = self->priv->_active_vpn_item;
		if (_tmp12_ != NULL) {
			NetworkVpnMenuItem* _tmp13_;
			NetworkVpnMenuItem* _tmp14_;
			NetworkVpnMenuItem* _tmp15_;
			NetworkState _tmp16_;
			_tmp13_ = self->priv->_active_vpn_item;
			gtk_widget_set_no_show_all ((GtkWidget*) _tmp13_, FALSE);
			_tmp14_ = self->priv->_active_vpn_item;
			gtk_widget_set_visible ((GtkWidget*) _tmp14_, TRUE);
			_tmp15_ = self->priv->_active_vpn_item;
			_tmp16_ = self->priv->_vpn_state;
			network_vpn_menu_item_set_vpn_state (_tmp15_, _tmp16_);
		}
	}
	NETWORK_WIDGET_NM_INTERFACE_CLASS (network_abstract_vpn_interface_parent_class)->update (G_TYPE_CHECK_INSTANCE_CAST (self, NETWORK_TYPE_WIDGET_NM_INTERFACE, NetworkWidgetNMInterface));
	_g_object_unref0 (item);
}

/**
      * The vpn_added_cb is called on new_connection signal,
      * (we get the vpn connections from there)
      * then we filter the connection that make sense for us.
    */
static void
_network_abstract_vpn_interface_vpn_activate_cb_network_vpn_menu_item_user_action (NetworkVpnMenuItem* _sender,
                                                                                   gpointer self)
{
	network_abstract_vpn_interface_vpn_activate_cb ((NetworkAbstractVpnInterface*) self, _sender);
}

static void
network_abstract_vpn_interface_vpn_added_cb (NetworkAbstractVpnInterface* self,
                                             GObject* obj)
{
	NMRemoteConnection* vpn = NULL;
	NMRemoteConnection* _tmp0_;
	NMRemoteConnection* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (obj, nm_remote_connection_get_type (), NMRemoteConnection));
	vpn = _tmp0_;
	_tmp1_ = vpn;
	_tmp2_ = nm_connection_get_connection_type ((NMConnection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string (NM_SETTING_VPN_SETTING_NAME)))) {
		switch (0) {
			default:
			{
				NetworkVpnMenuItem* item = NULL;
				NMRemoteConnection* _tmp6_;
				NetworkVpnMenuItem* _tmp7_;
				NetworkVpnMenuItem* _tmp8_;
				NetworkVpnMenuItem* _tmp9_;
				GtkListBox* _tmp10_;
				NetworkVpnMenuItem* _tmp11_;
				_tmp6_ = vpn;
				_tmp7_ = network_vpn_menu_item_new (_tmp6_);
				g_object_ref_sink (_tmp7_);
				item = _tmp7_;
				_tmp8_ = item;
				gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
				_tmp9_ = item;
				g_signal_connect_object (_tmp9_, "user-action", (GCallback) _network_abstract_vpn_interface_vpn_activate_cb_network_vpn_menu_item_user_action, self, 0);
				_tmp10_ = self->vpn_list;
				_tmp11_ = item;
				gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
				network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
				_g_object_unref0 (item);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	_g_object_unref0 (vpn);
}

static void
network_abstract_vpn_interface_vpn_removed_cb (NetworkAbstractVpnInterface* self,
                                               NMRemoteConnection* vpn_)
{
	NetworkVpnMenuItem* item = NULL;
	const gchar* _tmp0_;
	NetworkVpnMenuItem* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (vpn_ != NULL);
	_tmp0_ = nm_connection_get_uuid ((NMConnection*) vpn_);
	_tmp1_ = network_abstract_vpn_interface_get_item_by_uuid (self, _tmp0_);
	item = _tmp1_;
	gtk_widget_destroy ((GtkWidget*) item);
	_g_object_unref0 (item);
}

static NetworkVpnMenuItem*
network_abstract_vpn_interface_get_item_by_uuid (NetworkAbstractVpnInterface* self,
                                                 const gchar* uuid)
{
	NetworkVpnMenuItem* item = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	NetworkVpnMenuItem* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	item = NULL;
	_tmp0_ = self->vpn_list;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				NetworkVpnMenuItem* _item = NULL;
				GtkWidget* _tmp2_;
				NetworkVpnMenuItem* _tmp3_;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				NetworkVpnMenuItem* _tmp6_;
				NMRemoteConnection* _tmp7_;
				NMRemoteConnection* _tmp8_;
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem));
				_item = _tmp3_;
				_tmp6_ = _item;
				_tmp7_ = network_vpn_menu_item_get_connection (_tmp6_);
				_tmp8_ = _tmp7_;
				if (_tmp8_ != NULL) {
					NetworkVpnMenuItem* _tmp9_;
					NMRemoteConnection* _tmp10_;
					NMRemoteConnection* _tmp11_;
					const gchar* _tmp12_;
					_tmp9_ = _item;
					_tmp10_ = network_vpn_menu_item_get_connection (_tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = nm_connection_get_uuid ((NMConnection*) _tmp11_);
					_tmp5_ = g_strcmp0 (_tmp12_, uuid) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					NetworkVpnMenuItem* _tmp13_;
					_tmp13_ = item;
					_tmp4_ = _tmp13_ == NULL;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GtkWidget* _tmp14_;
					NetworkVpnMenuItem* _tmp15_;
					_tmp14_ = child;
					_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem));
					_g_object_unref0 (item);
					item = _tmp15_;
				}
				_g_object_unref0 (_item);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = item;
	return result;
}

/**
     * Loop through each active connection to find out the vpn.
    */
static void
_network_widget_nm_interface_update_nm_vpn_connection_vpn_state_changed (NMVpnConnection* _sender,
                                                                         guint state,
                                                                         guint reason,
                                                                         gpointer self)
{
	network_widget_nm_interface_update ((NetworkWidgetNMInterface*) self);
}

static void
__lambda30_ (NetworkAbstractVpnInterface* self,
             NMActiveConnection* ac)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (ac != NULL);
	if (nm_active_connection_get_vpn (ac)) {
		NMVpnConnection* _tmp1_;
		_tmp1_ = self->active_vpn_connection;
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NMVpnConnection* _tmp2_;
		NMVpnConnection* _tmp3_;
		GtkListBox* _tmp4_;
		GList* _tmp5_;
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ac, nm_vpn_connection_get_type (), NMVpnConnection));
		_g_object_unref0 (self->active_vpn_connection);
		self->active_vpn_connection = _tmp2_;
		_tmp3_ = self->active_vpn_connection;
		g_signal_connect_object (_tmp3_, "vpn-state-changed", (GCallback) _network_widget_nm_interface_update_nm_vpn_connection_vpn_state_changed, (NetworkWidgetNMInterface*) self, 0);
		_tmp4_ = self->vpn_list;
		_tmp5_ = gtk_container_get_children ((GtkContainer*) _tmp4_);
		{
			GList* v_collection = NULL;
			GList* v_it = NULL;
			v_collection = _tmp5_;
			for (v_it = v_collection; v_it != NULL; v_it = v_it->next) {
				GtkWidget* v = NULL;
				v = (GtkWidget*) v_it->data;
				{
					NetworkVpnMenuItem* menu_item = NULL;
					GtkWidget* _tmp6_;
					NetworkVpnMenuItem* _tmp7_;
					NetworkVpnMenuItem* _tmp8_;
					NMRemoteConnection* _tmp9_;
					NMRemoteConnection* _tmp10_;
					NetworkVpnMenuItem* _tmp11_;
					NMRemoteConnection* _tmp12_;
					NMRemoteConnection* _tmp13_;
					const gchar* _tmp14_;
					NMVpnConnection* _tmp15_;
					const gchar* _tmp16_;
					const gchar* _tmp17_;
					_tmp6_ = v;
					_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, NETWORK_TYPE_VPN_MENU_ITEM, NetworkVpnMenuItem));
					menu_item = _tmp7_;
					_tmp8_ = menu_item;
					_tmp9_ = network_vpn_menu_item_get_connection (_tmp8_);
					_tmp10_ = _tmp9_;
					if (_tmp10_ == NULL) {
						_g_object_unref0 (menu_item);
						continue;
					}
					_tmp11_ = menu_item;
					_tmp12_ = network_vpn_menu_item_get_connection (_tmp11_);
					_tmp13_ = _tmp12_;
					_tmp14_ = nm_connection_get_uuid ((NMConnection*) _tmp13_);
					_tmp15_ = self->active_vpn_connection;
					_tmp16_ = nm_active_connection_get_uuid ((NMActiveConnection*) _tmp15_);
					_tmp17_ = _tmp16_;
					if (g_strcmp0 (_tmp14_, _tmp17_) == 0) {
						NetworkVpnMenuItem* _tmp18_;
						NetworkVpnMenuItem* _tmp19_;
						NetworkVpnMenuItem* _tmp20_;
						NetworkState _tmp21_;
						_tmp18_ = menu_item;
						network_vpn_menu_item_set_active (_tmp18_, TRUE);
						_tmp19_ = menu_item;
						network_abstract_vpn_interface_set_active_vpn_item (self, _tmp19_);
						_tmp20_ = self->priv->_active_vpn_item;
						_tmp21_ = self->priv->_vpn_state;
						network_vpn_menu_item_set_vpn_state (_tmp20_, _tmp21_);
					}
					_g_object_unref0 (menu_item);
				}
			}
			(v_collection == NULL) ? NULL : (v_collection = (g_list_free (v_collection), NULL));
		}
	}
}

static void
___lambda30__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda30_ ((NetworkAbstractVpnInterface*) self, (NMActiveConnection*) data);
}

void
network_abstract_vpn_interface_update_active_connection (NetworkAbstractVpnInterface* self)
{
	NMClient* _tmp0_;
	GPtrArray* _tmp1_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->active_vpn_connection);
	self->active_vpn_connection = NULL;
	_tmp0_ = self->nm_client;
	_tmp1_ = nm_client_get_active_connections (_tmp0_);
	g_ptr_array_foreach (_tmp1_, ___lambda30__gfunc, self);
}

static void
network_abstract_vpn_interface_real_vpn_activate_cb (NetworkAbstractVpnInterface* self,
                                                     NetworkVpnMenuItem* i)
{
	g_critical ("Type `%s' does not implement abstract method `network_abstract_vpn_interface_vpn_activate_cb'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
network_abstract_vpn_interface_vpn_activate_cb (NetworkAbstractVpnInterface* self,
                                                NetworkVpnMenuItem* i)
{
	NetworkAbstractVpnInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_ABSTRACT_VPN_INTERFACE_GET_CLASS (self);
	if (_klass_->vpn_activate_cb) {
		_klass_->vpn_activate_cb (self, i);
	}
}

static void
network_abstract_vpn_interface_real_vpn_deactivate_cb (NetworkAbstractVpnInterface* self)
{
	g_critical ("Type `%s' does not implement abstract method `network_abstract_vpn_interface_vpn_deactivate_cb'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
network_abstract_vpn_interface_vpn_deactivate_cb (NetworkAbstractVpnInterface* self)
{
	NetworkAbstractVpnInterfaceClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = NETWORK_ABSTRACT_VPN_INTERFACE_GET_CLASS (self);
	if (_klass_->vpn_deactivate_cb) {
		_klass_->vpn_deactivate_cb (self);
	}
}

NetworkAbstractVpnInterface*
network_abstract_vpn_interface_construct (GType object_type)
{
	NetworkAbstractVpnInterface * self = NULL;
	self = (NetworkAbstractVpnInterface*) network_widget_nm_interface_construct (object_type);
	return self;
}

NetworkVpnMenuItem*
network_abstract_vpn_interface_get_active_vpn_item (NetworkAbstractVpnInterface* self)
{
	NetworkVpnMenuItem* result;
	NetworkVpnMenuItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_vpn_item;
	result = _tmp0_;
	return result;
}

void
network_abstract_vpn_interface_set_active_vpn_item (NetworkAbstractVpnInterface* self,
                                                    NetworkVpnMenuItem* value)
{
	NetworkVpnMenuItem* old_value;
	g_return_if_fail (self != NULL);
	old_value = network_abstract_vpn_interface_get_active_vpn_item (self);
	if (old_value != value) {
		NetworkVpnMenuItem* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_active_vpn_item);
		self->priv->_active_vpn_item = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, network_abstract_vpn_interface_properties[NETWORK_ABSTRACT_VPN_INTERFACE_ACTIVE_VPN_ITEM_PROPERTY]);
	}
}

NetworkState
network_abstract_vpn_interface_get_vpn_state (NetworkAbstractVpnInterface* self)
{
	NetworkState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_vpn_state;
	return result;
}

void
network_abstract_vpn_interface_set_vpn_state (NetworkAbstractVpnInterface* self,
                                              NetworkState value)
{
	NetworkState old_value;
	g_return_if_fail (self != NULL);
	old_value = network_abstract_vpn_interface_get_vpn_state (self);
	if (old_value != value) {
		self->priv->_vpn_state = value;
		g_object_notify_by_pspec ((GObject *) self, network_abstract_vpn_interface_properties[NETWORK_ABSTRACT_VPN_INTERFACE_VPN_STATE_PROPERTY]);
	}
}

static GObject *
network_abstract_vpn_interface_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkAbstractVpnInterface * self;
	GtkListBox* _tmp0_ = NULL;
	parent_class = G_OBJECT_CLASS (network_abstract_vpn_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_ABSTRACT_VPN_INTERFACE, NetworkAbstractVpnInterface);
	_tmp0_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp0_, FALSE);
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, TRUE);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->vpn_list);
	self->vpn_list = _tmp0_;
	return obj;
}

static void
network_abstract_vpn_interface_class_init (NetworkAbstractVpnInterfaceClass * klass,
                                           gpointer klass_data)
{
	network_abstract_vpn_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkAbstractVpnInterface_private_offset);
	((NetworkWidgetNMInterfaceClass *) klass)->update_name = (void (*) (NetworkWidgetNMInterface*, gint)) network_abstract_vpn_interface_real_update_name;
	((NetworkWidgetNMInterfaceClass *) klass)->update = (void (*) (NetworkWidgetNMInterface*)) network_abstract_vpn_interface_real_update;
	((NetworkAbstractVpnInterfaceClass *) klass)->vpn_activate_cb = (void (*) (NetworkAbstractVpnInterface*, NetworkVpnMenuItem*)) network_abstract_vpn_interface_real_vpn_activate_cb;
	((NetworkAbstractVpnInterfaceClass *) klass)->vpn_deactivate_cb = (void (*) (NetworkAbstractVpnInterface*)) network_abstract_vpn_interface_real_vpn_deactivate_cb;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_abstract_vpn_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_abstract_vpn_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_abstract_vpn_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_abstract_vpn_interface_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_ABSTRACT_VPN_INTERFACE_ACTIVE_VPN_ITEM_PROPERTY, network_abstract_vpn_interface_properties[NETWORK_ABSTRACT_VPN_INTERFACE_ACTIVE_VPN_ITEM_PROPERTY] = g_param_spec_object ("active-vpn-item", "active-vpn-item", "active-vpn-item", NETWORK_TYPE_VPN_MENU_ITEM, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * If we want to add a visual feedback on DisplayWidget later,
	     * we just need to remove vpn_state and swap it to state on the code
	    **/
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_ABSTRACT_VPN_INTERFACE_VPN_STATE_PROPERTY, network_abstract_vpn_interface_properties[NETWORK_ABSTRACT_VPN_INTERFACE_VPN_STATE_PROPERTY] = g_param_spec_enum ("vpn-state", "vpn-state", "vpn-state", NETWORK_TYPE_STATE, NETWORK_STATE_DISCONNECTED, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
network_abstract_vpn_interface_instance_init (NetworkAbstractVpnInterface * self,
                                              gpointer klass)
{
	self->priv = network_abstract_vpn_interface_get_instance_private (self);
	self->active_vpn_connection = NULL;
	self->blank_item = NULL;
	self->priv->_vpn_state = NETWORK_STATE_DISCONNECTED;
}

static void
network_abstract_vpn_interface_finalize (GObject * obj)
{
	NetworkAbstractVpnInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_ABSTRACT_VPN_INTERFACE, NetworkAbstractVpnInterface);
	_g_object_unref0 (self->active_vpn_connection);
	_g_object_unref0 (self->vpn_list);
	_g_object_unref0 (self->nm_client);
	_g_object_unref0 (self->priv->_active_vpn_item);
	_g_object_unref0 (self->blank_item);
	G_OBJECT_CLASS (network_abstract_vpn_interface_parent_class)->finalize (obj);
}

GType
network_abstract_vpn_interface_get_type (void)
{
	return network_abstract_vpn_interface_type_id;
}

GType
network_abstract_vpn_interface_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkAbstractVpnInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_abstract_vpn_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkAbstractVpnInterface), 0, (GInstanceInitFunc) network_abstract_vpn_interface_instance_init, NULL };
	network_abstract_vpn_interface_type_id = g_type_module_register_type (module, NETWORK_TYPE_WIDGET_NM_INTERFACE, "NetworkAbstractVpnInterface", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	NetworkAbstractVpnInterface_private_offset = sizeof (NetworkAbstractVpnInterfacePrivate);
	return network_abstract_vpn_interface_type_id;
}

static void
_vala_network_abstract_vpn_interface_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec)
{
	NetworkAbstractVpnInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_ABSTRACT_VPN_INTERFACE, NetworkAbstractVpnInterface);
	switch (property_id) {
		case NETWORK_ABSTRACT_VPN_INTERFACE_ACTIVE_VPN_ITEM_PROPERTY:
		g_value_set_object (value, network_abstract_vpn_interface_get_active_vpn_item (self));
		break;
		case NETWORK_ABSTRACT_VPN_INTERFACE_VPN_STATE_PROPERTY:
		g_value_set_enum (value, network_abstract_vpn_interface_get_vpn_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_abstract_vpn_interface_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec)
{
	NetworkAbstractVpnInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_ABSTRACT_VPN_INTERFACE, NetworkAbstractVpnInterface);
	switch (property_id) {
		case NETWORK_ABSTRACT_VPN_INTERFACE_ACTIVE_VPN_ITEM_PROPERTY:
		network_abstract_vpn_interface_set_active_vpn_item (self, g_value_get_object (value));
		break;
		case NETWORK_ABSTRACT_VPN_INTERFACE_VPN_STATE_PROPERTY:
		network_abstract_vpn_interface_set_vpn_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

