// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum unit.yaml. DO NOT EDIT.

package length

import (
	"fmt"
	"iter"
)

// Unit represents units of measurement for the length of a string.
//
// The most commonly used [Unit] in protocompile is [TermWidth], which
// approximates columns in a terminal emulator. This takes into account the
// Unicode width of runes, and tabstops. The rune A is one column wide, the rune
// 貓 is two columns wide, and the multi-rune emoji presentation sequence 🐈‍⬛ is
// also two columns wide.
//
// Other units of length can be used to cope with the needs of other rendering
// contexts, such as the Language Server Protocol.
type Unit int

const (
	Bytes     Unit = iota // The length in UTF-8 code units (bytes).
	UTF16                 // The length in UTF-16 code units (uint16s).
	Runes                 // The length in UTF-32 code units (runes).
	TermWidth             // The length in approximate terminal columns.
)

// String implements [fmt.Stringer].
func (v Unit) String() string {
	if int(v) < 0 || int(v) > len(_table_Unit_String) {
		return fmt.Sprintf("Unit(%v)", int(v))
	}
	return _table_Unit_String[v]
}

// GoString implements [fmt.GoStringer].
func (v Unit) GoString() string {
	if int(v) < 0 || int(v) > len(_table_Unit_GoString) {
		return fmt.Sprintf("length.Unit(%v)", int(v))
	}
	return _table_Unit_GoString[v]
}

// Units returns an iterator over all of the [Unit]s
func Units() iter.Seq[Unit] {
	return func(yield func(Unit) bool) {
		for i := 0; i < 4; i++ {
			if !yield(Unit(i)) {
				return
			}
		}
	}
}

var _table_Unit_String = [...]string{
	Bytes:     "Bytes",
	UTF16:     "UTF16",
	Runes:     "Runes",
	TermWidth: "TermWidth",
}

var _table_Unit_GoString = [...]string{
	Bytes:     "length.Bytes",
	UTF16:     "length.UTF16",
	Runes:     "length.Runes",
	TermWidth: "length.TermWidth",
}
var _ iter.Seq[int] // Mark iter as used.
