// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by github.com/bufbuild/protocompile/internal/enum option_target.yaml. DO NOT EDIT.

package ir

import (
	"fmt"
	"iter"
)

// OptionTarget is target for an Editions feature, corresponding to
// google.protobuf.FieldOptions.OptionTargetType. The values of this enum match
// those in descriptor.proto one-to-one.
type OptionTarget int32

const (
	OptionTargetInvalid OptionTarget = iota
	OptionTargetFile
	OptionTargetRange
	OptionTargetMessage
	OptionTargetField
	OptionTargetOneof
	OptionTargetEnum
	OptionTargetEnumValue
	OptionTargetService
	OptionTargetMethod
	optionTargetMax
)

// String implements [fmt.Stringer].
func (v OptionTarget) String() string {
	if int(v) < 0 || int(v) > len(_table_OptionTarget_String) {
		return fmt.Sprintf("OptionTarget(%v)", int(v))
	}
	return _table_OptionTarget_String[v]
}

// GoString implements [fmt.GoStringer].
func (v OptionTarget) GoString() string {
	if int(v) < 0 || int(v) > len(_table_OptionTarget_GoString) {
		return fmt.Sprintf("ir.OptionTarget(%v)", int(v))
	}
	return _table_OptionTarget_GoString[v]
}

// OptionTargets returns an iterator over all of the possible valid targets,
// which excludes [OptionTargetInvalid].
func OptionTargets() iter.Seq[OptionTarget] {
	return func(yield func(OptionTarget) bool) {
		for i := 1; i < 10; i++ {
			if !yield(OptionTarget(i)) {
				return
			}
		}
	}
}

var _table_OptionTarget_String = [...]string{
	OptionTargetInvalid:   "OptionTargetInvalid",
	OptionTargetFile:      "OptionTargetFile",
	OptionTargetRange:     "OptionTargetRange",
	OptionTargetMessage:   "OptionTargetMessage",
	OptionTargetField:     "OptionTargetField",
	OptionTargetOneof:     "OptionTargetOneof",
	OptionTargetEnum:      "OptionTargetEnum",
	OptionTargetEnumValue: "OptionTargetEnumValue",
	OptionTargetService:   "OptionTargetService",
	OptionTargetMethod:    "OptionTargetMethod",
}

var _table_OptionTarget_GoString = [...]string{
	OptionTargetInvalid:   "ir.OptionTargetInvalid",
	OptionTargetFile:      "ir.OptionTargetFile",
	OptionTargetRange:     "ir.OptionTargetRange",
	OptionTargetMessage:   "ir.OptionTargetMessage",
	OptionTargetField:     "ir.OptionTargetField",
	OptionTargetOneof:     "ir.OptionTargetOneof",
	OptionTargetEnum:      "ir.OptionTargetEnum",
	OptionTargetEnumValue: "ir.OptionTargetEnumValue",
	OptionTargetService:   "ir.OptionTargetService",
	OptionTargetMethod:    "ir.OptionTargetMethod",
}
var _ iter.Seq[int] // Mark iter as used.
