#ifndef WRITEODFSTYLE_H
#define WRITEODFSTYLE_H
#include "writeodf.h"
namespace writeodf {
class style_column_sep : public OdfWriter {
public:
    style_column_sep(OdfWriter* x, const QString& style_width) :OdfWriter(x, "style:column-sep", false) {
        addAttribute("style:width", style_width);
    }
    style_column_sep(KoXmlWriter* x, const QString& style_width) :OdfWriter(x, "style:column-sep", false) {
        addAttribute("style:width", style_width);
    }
    void set_style_color(const QString& value) {
        addAttribute("style:color", value);
    }
    void set_style_height(const QString& value) {
        addAttribute("style:height", value);
    }
    template<class T>
    void set_style_style(const T& value) {
        addAttribute("style:style", value);
    }
    template<class T>
    void set_style_vertical_align(const T& value) {
        addAttribute("style:vertical-align", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_default_page_layout : public OdfWriter, public group_style_page_layout_content {
public:
    style_default_page_layout(OdfWriter* x) :OdfWriter(x, "style:default-page-layout", true), group_style_page_layout_content(*static_cast<OdfWriter*>(this)) {
    }
    style_default_page_layout(KoXmlWriter* x) :OdfWriter(x, "style:default-page-layout", true), group_style_page_layout_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_drawing_page_properties : public OdfWriter, public group_presentation_sound, public group_style_graphic_fill_properties_attlist {
public:
    style_drawing_page_properties(OdfWriter* x) :OdfWriter(x, "style:drawing-page-properties", true), group_presentation_sound(*static_cast<OdfWriter*>(this)), group_style_graphic_fill_properties_attlist(*static_cast<OdfWriter*>(this)) {
    }
    style_drawing_page_properties(KoXmlWriter* x) :OdfWriter(x, "style:drawing-page-properties", true), group_presentation_sound(*static_cast<OdfWriter*>(this)), group_style_graphic_fill_properties_attlist(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_draw_background_size(const T& value) {
        addAttribute("draw:background-size", value);
    }
    template<class T>
    void set_presentation_background_objects_visible(const T& value) {
        addAttribute("presentation:background-objects-visible", value);
    }
    template<class T>
    void set_presentation_background_visible(const T& value) {
        addAttribute("presentation:background-visible", value);
    }
    template<class T>
    void set_presentation_display_date_time(const T& value) {
        addAttribute("presentation:display-date-time", value);
    }
    template<class T>
    void set_presentation_display_footer(const T& value) {
        addAttribute("presentation:display-footer", value);
    }
    template<class T>
    void set_presentation_display_header(const T& value) {
        addAttribute("presentation:display-header", value);
    }
    template<class T>
    void set_presentation_display_page_number(const T& value) {
        addAttribute("presentation:display-page-number", value);
    }
    void set_presentation_duration(Duration value) {
        addAttribute("presentation:duration", value);
    }
    template<class T>
    void set_presentation_transition_speed(const T& value) {
        addAttribute("presentation:transition-speed", value);
    }
    template<class T>
    void set_presentation_transition_style(const T& value) {
        addAttribute("presentation:transition-style", value);
    }
    template<class T>
    void set_presentation_transition_type(const T& value) {
        addAttribute("presentation:transition-type", value);
    }
    template<class T>
    void set_presentation_visibility(const T& value) {
        addAttribute("presentation:visibility", value);
    }
    template<class T>
    void set_smil_direction(const T& value) {
        addAttribute("smil:direction", value);
    }
    void set_smil_fadeColor(const QString& value) {
        addAttribute("smil:fadeColor", value);
    }
    void set_smil_subtype(const QString& value) {
        addAttribute("smil:subtype", value);
    }
    void set_smil_type(const QString& value) {
        addAttribute("smil:type", value);
    }
};
class style_font_face : public OdfWriter {
public:
    style_font_face(OdfWriter* x, const QString& style_name) :OdfWriter(x, "style:font-face", true) {
        addAttribute("style:name", style_name);
    }
    style_font_face(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "style:font-face", true) {
        addAttribute("style:name", style_name);
    }
    svg_definition_src add_svg_definition_src(const QUrl& xlink_href);
    svg_font_face_src add_svg_font_face_src();
    void set_style_font_adornments(const QString& value) {
        addAttribute("style:font-adornments", value);
    }
    void set_style_font_charset(const QString& value) {
        addAttribute("style:font-charset", value);
    }
    template<class T>
    void set_style_font_family_generic(const T& value) {
        addAttribute("style:font-family-generic", value);
    }
    template<class T>
    void set_style_font_pitch(const T& value) {
        addAttribute("style:font-pitch", value);
    }
    void set_svg_accent_height(qint64 value) {
        addAttribute("svg:accent-height", value);
    }
    void set_svg_alphabetic(qint64 value) {
        addAttribute("svg:alphabetic", value);
    }
    void set_svg_ascent(qint64 value) {
        addAttribute("svg:ascent", value);
    }
    void set_svg_bbox(const QString& value) {
        addAttribute("svg:bbox", value);
    }
    void set_svg_cap_height(qint64 value) {
        addAttribute("svg:cap-height", value);
    }
    void set_svg_descent(qint64 value) {
        addAttribute("svg:descent", value);
    }
    void set_svg_font_family(const QString& value) {
        addAttribute("svg:font-family", value);
    }
    void set_svg_font_size(const QString& value) {
        addAttribute("svg:font-size", value);
    }
    template<class T>
    void set_svg_font_stretch(const T& value) {
        addAttribute("svg:font-stretch", value);
    }
    template<class T>
    void set_svg_font_style(const T& value) {
        addAttribute("svg:font-style", value);
    }
    template<class T>
    void set_svg_font_variant(const T& value) {
        addAttribute("svg:font-variant", value);
    }
    template<class T>
    void set_svg_font_weight(const T& value) {
        addAttribute("svg:font-weight", value);
    }
    void set_svg_hanging(qint64 value) {
        addAttribute("svg:hanging", value);
    }
    void set_svg_ideographic(qint64 value) {
        addAttribute("svg:ideographic", value);
    }
    void set_svg_mathematical(qint64 value) {
        addAttribute("svg:mathematical", value);
    }
    void set_svg_overline_position(qint64 value) {
        addAttribute("svg:overline-position", value);
    }
    void set_svg_overline_thickness(qint64 value) {
        addAttribute("svg:overline-thickness", value);
    }
    void set_svg_panose_1(const QString& value) {
        addAttribute("svg:panose-1", value);
    }
    void set_svg_slope(qint64 value) {
        addAttribute("svg:slope", value);
    }
    void set_svg_stemh(qint64 value) {
        addAttribute("svg:stemh", value);
    }
    void set_svg_stemv(qint64 value) {
        addAttribute("svg:stemv", value);
    }
    void set_svg_strikethrough_position(qint64 value) {
        addAttribute("svg:strikethrough-position", value);
    }
    void set_svg_strikethrough_thickness(qint64 value) {
        addAttribute("svg:strikethrough-thickness", value);
    }
    void set_svg_underline_position(qint64 value) {
        addAttribute("svg:underline-position", value);
    }
    void set_svg_underline_thickness(qint64 value) {
        addAttribute("svg:underline-thickness", value);
    }
    void set_svg_unicode_range(const QString& value) {
        addAttribute("svg:unicode-range", value);
    }
    void set_svg_units_per_em(qint64 value) {
        addAttribute("svg:units-per-em", value);
    }
    void set_svg_v_alphabetic(qint64 value) {
        addAttribute("svg:v-alphabetic", value);
    }
    void set_svg_v_hanging(qint64 value) {
        addAttribute("svg:v-hanging", value);
    }
    void set_svg_v_ideographic(qint64 value) {
        addAttribute("svg:v-ideographic", value);
    }
    void set_svg_v_mathematical(qint64 value) {
        addAttribute("svg:v-mathematical", value);
    }
    void set_svg_widths(const QString& value) {
        addAttribute("svg:widths", value);
    }
    void set_svg_x_height(qint64 value) {
        addAttribute("svg:x-height", value);
    }
};
class style_footnote_sep : public OdfWriter {
public:
    style_footnote_sep(OdfWriter* x) :OdfWriter(x, "style:footnote-sep", false) {
    }
    style_footnote_sep(KoXmlWriter* x) :OdfWriter(x, "style:footnote-sep", false) {
    }
    template<class T>
    void set_style_adjustment(const T& value) {
        addAttribute("style:adjustment", value);
    }
    void set_style_color(const QString& value) {
        addAttribute("style:color", value);
    }
    void set_style_distance_after_sep(const QString& value) {
        addAttribute("style:distance-after-sep", value);
    }
    void set_style_distance_before_sep(const QString& value) {
        addAttribute("style:distance-before-sep", value);
    }
    template<class T>
    void set_style_line_style(const T& value) {
        addAttribute("style:line-style", value);
    }
    void set_style_rel_width(const QString& value) {
        addAttribute("style:rel-width", value);
    }
    void set_style_width(const QString& value) {
        addAttribute("style:width", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_presentation_page_layout : public OdfWriter {
public:
    style_presentation_page_layout(OdfWriter* x, const QString& style_name) :OdfWriter(x, "style:presentation-page-layout", true) {
        addAttribute("style:name", style_name);
    }
    style_presentation_page_layout(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "style:presentation-page-layout", true) {
        addAttribute("style:name", style_name);
    }
    presentation_placeholder add_presentation_placeholder(const QString& presentation_object, const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y);
    void set_style_display_name(const QString& value) {
        addAttribute("style:display-name", value);
    }
};
class style_ruby_properties : public OdfWriter {
public:
    style_ruby_properties(OdfWriter* x) :OdfWriter(x, "style:ruby-properties", false) {
    }
    style_ruby_properties(KoXmlWriter* x) :OdfWriter(x, "style:ruby-properties", false) {
    }
    template<class T>
    void set_style_ruby_align(const T& value) {
        addAttribute("style:ruby-align", value);
    }
    template<class T>
    void set_style_ruby_position(const T& value) {
        addAttribute("style:ruby-position", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_tab_stops : public OdfWriter {
public:
    style_tab_stops(OdfWriter* x) :OdfWriter(x, "style:tab-stops", true) {
    }
    style_tab_stops(KoXmlWriter* x) :OdfWriter(x, "style:tab-stops", true) {
    }
    style_tab_stop add_style_tab_stop(const QString& style_position);
};
class style_table_column_properties : public OdfWriter, public group_common_break_attlist {
public:
    style_table_column_properties(OdfWriter* x) :OdfWriter(x, "style:table-column-properties", false), group_common_break_attlist(*static_cast<OdfWriter*>(this)) {
    }
    style_table_column_properties(KoXmlWriter* x) :OdfWriter(x, "style:table-column-properties", false), group_common_break_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_style_column_width(const QString& value) {
        addAttribute("style:column-width", value);
    }
    void set_style_rel_column_width(const QString& value) {
        addAttribute("style:rel-column-width", value);
    }
    template<class T>
    void set_style_use_optimal_column_width(const T& value) {
        addAttribute("style:use-optimal-column-width", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_table_row_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_break_attlist, public group_style_background_image {
public:
    style_table_row_properties(OdfWriter* x) :OdfWriter(x, "style:table-row-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_break_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    style_table_row_properties(KoXmlWriter* x) :OdfWriter(x, "style:table-row-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_break_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_fo_keep_together(const T& value) {
        addAttribute("fo:keep-together", value);
    }
    void set_style_min_row_height(const QString& value) {
        addAttribute("style:min-row-height", value);
    }
    void set_style_row_height(const QString& value) {
        addAttribute("style:row-height", value);
    }
    template<class T>
    void set_style_use_optimal_row_height(const T& value) {
        addAttribute("style:use-optimal-row-height", value);
    }
};
class style_background_image : public OdfWriter, public group_common_draw_data_attlist, public group_office_binary_data {
public:
    style_background_image(OdfWriter* x) :OdfWriter(x, "style:background-image", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)) {
    }
    style_background_image(KoXmlWriter* x) :OdfWriter(x, "style:background-image", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_opacity(const QString& value) {
        addAttribute("draw:opacity", value);
    }
    void set_style_filter_name(const QString& value) {
        addAttribute("style:filter-name", value);
    }
    template<class T>
    void set_style_position(const T& value) {
        addAttribute("style:position", value);
    }
    template<class T>
    void set_style_repeat(const T& value) {
        addAttribute("style:repeat", value);
    }
};
class style_column : public OdfWriter {
public:
    style_column(OdfWriter* x, const QString& style_rel_width) :OdfWriter(x, "style:column", false) {
        addAttribute("style:rel-width", style_rel_width);
    }
    style_column(KoXmlWriter* x, const QString& style_rel_width) :OdfWriter(x, "style:column", false) {
        addAttribute("style:rel-width", style_rel_width);
    }
    void set_fo_end_indent(const QString& value) {
        addAttribute("fo:end-indent", value);
    }
    void set_fo_space_after(const QString& value) {
        addAttribute("fo:space-after", value);
    }
    void set_fo_space_before(const QString& value) {
        addAttribute("fo:space-before", value);
    }
    void set_fo_start_indent(const QString& value) {
        addAttribute("fo:start-indent", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_text_properties : public OdfWriter, public group_common_background_color_attlist {
public:
    style_text_properties(OdfWriter* x) :OdfWriter(x, "style:text-properties", false), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)) {
    }
    style_text_properties(KoXmlWriter* x) :OdfWriter(x, "style:text-properties", false), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)) {
    }
    void set_fo_color(const QString& value) {
        addAttribute("fo:color", value);
    }
    void set_fo_country(const QString& value) {
        addAttribute("fo:country", value);
    }
    void set_fo_font_family(const QString& value) {
        addAttribute("fo:font-family", value);
    }
    void set_fo_font_size(const QString& value) {
        addAttribute("fo:font-size", value);
    }
    template<class T>
    void set_fo_font_style(const T& value) {
        addAttribute("fo:font-style", value);
    }
    template<class T>
    void set_fo_font_variant(const T& value) {
        addAttribute("fo:font-variant", value);
    }
    template<class T>
    void set_fo_font_weight(const T& value) {
        addAttribute("fo:font-weight", value);
    }
    template<class T>
    void set_fo_hyphenate(const T& value) {
        addAttribute("fo:hyphenate", value);
    }
    void set_fo_hyphenation_push_char_count(quint64 value) {
        addAttribute("fo:hyphenation-push-char-count", value);
    }
    void set_fo_hyphenation_remain_char_count(quint64 value) {
        addAttribute("fo:hyphenation-remain-char-count", value);
    }
    void set_fo_language(const QString& value) {
        addAttribute("fo:language", value);
    }
    template<class T>
    void set_fo_letter_spacing(const T& value) {
        addAttribute("fo:letter-spacing", value);
    }
    void set_fo_script(const QString& value) {
        addAttribute("fo:script", value);
    }
    template<class T>
    void set_fo_text_shadow(const T& value) {
        addAttribute("fo:text-shadow", value);
    }
    template<class T>
    void set_fo_text_transform(const T& value) {
        addAttribute("fo:text-transform", value);
    }
    void set_style_country_asian(const QString& value) {
        addAttribute("style:country-asian", value);
    }
    void set_style_country_complex(const QString& value) {
        addAttribute("style:country-complex", value);
    }
    void set_style_font_charset(const QString& value) {
        addAttribute("style:font-charset", value);
    }
    void set_style_font_charset_asian(const QString& value) {
        addAttribute("style:font-charset-asian", value);
    }
    void set_style_font_charset_complex(const QString& value) {
        addAttribute("style:font-charset-complex", value);
    }
    void set_style_font_family_asian(const QString& value) {
        addAttribute("style:font-family-asian", value);
    }
    void set_style_font_family_complex(const QString& value) {
        addAttribute("style:font-family-complex", value);
    }
    template<class T>
    void set_style_font_family_generic(const T& value) {
        addAttribute("style:font-family-generic", value);
    }
    template<class T>
    void set_style_font_family_generic_asian(const T& value) {
        addAttribute("style:font-family-generic-asian", value);
    }
    template<class T>
    void set_style_font_family_generic_complex(const T& value) {
        addAttribute("style:font-family-generic-complex", value);
    }
    void set_style_font_name(const QString& value) {
        addAttribute("style:font-name", value);
    }
    void set_style_font_name_asian(const QString& value) {
        addAttribute("style:font-name-asian", value);
    }
    void set_style_font_name_complex(const QString& value) {
        addAttribute("style:font-name-complex", value);
    }
    template<class T>
    void set_style_font_pitch(const T& value) {
        addAttribute("style:font-pitch", value);
    }
    template<class T>
    void set_style_font_pitch_asian(const T& value) {
        addAttribute("style:font-pitch-asian", value);
    }
    template<class T>
    void set_style_font_pitch_complex(const T& value) {
        addAttribute("style:font-pitch-complex", value);
    }
    template<class T>
    void set_style_font_relief(const T& value) {
        addAttribute("style:font-relief", value);
    }
    void set_style_font_size_asian(const QString& value) {
        addAttribute("style:font-size-asian", value);
    }
    void set_style_font_size_complex(const QString& value) {
        addAttribute("style:font-size-complex", value);
    }
    void set_style_font_size_rel(const QString& value) {
        addAttribute("style:font-size-rel", value);
    }
    void set_style_font_size_rel_asian(const QString& value) {
        addAttribute("style:font-size-rel-asian", value);
    }
    void set_style_font_size_rel_complex(const QString& value) {
        addAttribute("style:font-size-rel-complex", value);
    }
    template<class T>
    void set_style_font_style_asian(const T& value) {
        addAttribute("style:font-style-asian", value);
    }
    template<class T>
    void set_style_font_style_complex(const T& value) {
        addAttribute("style:font-style-complex", value);
    }
    void set_style_font_style_name(const QString& value) {
        addAttribute("style:font-style-name", value);
    }
    void set_style_font_style_name_asian(const QString& value) {
        addAttribute("style:font-style-name-asian", value);
    }
    void set_style_font_style_name_complex(const QString& value) {
        addAttribute("style:font-style-name-complex", value);
    }
    template<class T>
    void set_style_font_weight_asian(const T& value) {
        addAttribute("style:font-weight-asian", value);
    }
    template<class T>
    void set_style_font_weight_complex(const T& value) {
        addAttribute("style:font-weight-complex", value);
    }
    void set_style_language_asian(const QString& value) {
        addAttribute("style:language-asian", value);
    }
    void set_style_language_complex(const QString& value) {
        addAttribute("style:language-complex", value);
    }
    template<class T>
    void set_style_letter_kerning(const T& value) {
        addAttribute("style:letter-kerning", value);
    }
    void set_style_rfc_language_tag(const QString& value) {
        addAttribute("style:rfc-language-tag", value);
    }
    void set_style_rfc_language_tag_asian(const QString& value) {
        addAttribute("style:rfc-language-tag-asian", value);
    }
    void set_style_rfc_language_tag_complex(const QString& value) {
        addAttribute("style:rfc-language-tag-complex", value);
    }
    void set_style_script_asian(const QString& value) {
        addAttribute("style:script-asian", value);
    }
    void set_style_script_complex(const QString& value) {
        addAttribute("style:script-complex", value);
    }
    template<class T>
    void set_style_script_type(const T& value) {
        addAttribute("style:script-type", value);
    }
    template<class T>
    void set_style_text_blinking(const T& value) {
        addAttribute("style:text-blinking", value);
    }
    template<class T>
    void set_style_text_combine(const T& value) {
        addAttribute("style:text-combine", value);
    }
    void set_style_text_combine_end_char(const QString& value) {
        addAttribute("style:text-combine-end-char", value);
    }
    void set_style_text_combine_start_char(const QString& value) {
        addAttribute("style:text-combine-start-char", value);
    }
    template<class T>
    void set_style_text_emphasize(const T& value) {
        addAttribute("style:text-emphasize", value);
    }
    template<class T>
    void set_style_text_line_through_color(const T& value) {
        addAttribute("style:text-line-through-color", value);
    }
    template<class T>
    void set_style_text_line_through_mode(const T& value) {
        addAttribute("style:text-line-through-mode", value);
    }
    template<class T>
    void set_style_text_line_through_style(const T& value) {
        addAttribute("style:text-line-through-style", value);
    }
    void set_style_text_line_through_text(const QString& value) {
        addAttribute("style:text-line-through-text", value);
    }
    void set_style_text_line_through_text_style(const QString& value) {
        addAttribute("style:text-line-through-text-style", value);
    }
    template<class T>
    void set_style_text_line_through_type(const T& value) {
        addAttribute("style:text-line-through-type", value);
    }
    template<class T>
    void set_style_text_line_through_width(const T& value) {
        addAttribute("style:text-line-through-width", value);
    }
    template<class T>
    void set_style_text_outline(const T& value) {
        addAttribute("style:text-outline", value);
    }
    template<class T>
    void set_style_text_overline_color(const T& value) {
        addAttribute("style:text-overline-color", value);
    }
    template<class T>
    void set_style_text_overline_mode(const T& value) {
        addAttribute("style:text-overline-mode", value);
    }
    template<class T>
    void set_style_text_overline_style(const T& value) {
        addAttribute("style:text-overline-style", value);
    }
    template<class T>
    void set_style_text_overline_type(const T& value) {
        addAttribute("style:text-overline-type", value);
    }
    template<class T>
    void set_style_text_overline_width(const T& value) {
        addAttribute("style:text-overline-width", value);
    }
    template<class T>
    void set_style_text_position(const T& value) {
        addAttribute("style:text-position", value);
    }
    void set_style_text_rotation_angle(const QString& value) {
        addAttribute("style:text-rotation-angle", value);
    }
    template<class T>
    void set_style_text_rotation_scale(const T& value) {
        addAttribute("style:text-rotation-scale", value);
    }
    void set_style_text_scale(const QString& value) {
        addAttribute("style:text-scale", value);
    }
    template<class T>
    void set_style_text_underline_color(const T& value) {
        addAttribute("style:text-underline-color", value);
    }
    template<class T>
    void set_style_text_underline_mode(const T& value) {
        addAttribute("style:text-underline-mode", value);
    }
    template<class T>
    void set_style_text_underline_style(const T& value) {
        addAttribute("style:text-underline-style", value);
    }
    template<class T>
    void set_style_text_underline_type(const T& value) {
        addAttribute("style:text-underline-type", value);
    }
    template<class T>
    void set_style_text_underline_width(const T& value) {
        addAttribute("style:text-underline-width", value);
    }
    template<class T>
    void set_style_use_window_font_color(const T& value) {
        addAttribute("style:use-window-font-color", value);
    }
    template<class T>
    void set_text_condition(const T& value) {
        addAttribute("text:condition", value);
    }
    template<class T>
    void set_text_display(const T& value) {
        addAttribute("text:display", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_columns : public OdfWriter {
public:
    style_columns(OdfWriter* x, quint64 fo_column_count) :OdfWriter(x, "style:columns", true) {
        addAttribute("fo:column-count", fo_column_count);
    }
    style_columns(KoXmlWriter* x, quint64 fo_column_count) :OdfWriter(x, "style:columns", true) {
        addAttribute("fo:column-count", fo_column_count);
    }
    style_column add_style_column(const QString& style_rel_width);
    style_column_sep add_style_column_sep(const QString& style_width);
    void set_fo_column_gap(const QString& value) {
        addAttribute("fo:column-gap", value);
    }
};
class style_drop_cap : public OdfWriter {
public:
    style_drop_cap(OdfWriter* x) :OdfWriter(x, "style:drop-cap", false) {
    }
    style_drop_cap(KoXmlWriter* x) :OdfWriter(x, "style:drop-cap", false) {
    }
    void set_style_distance(const QString& value) {
        addAttribute("style:distance", value);
    }
    template<class T>
    void set_style_length(const T& value) {
        addAttribute("style:length", value);
    }
    void set_style_lines(quint64 value) {
        addAttribute("style:lines", value);
    }
    void set_style_style_name(const QString& value) {
        addAttribute("style:style-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_list_level_label_alignment : public OdfWriter {
public:
    style_list_level_label_alignment(OdfWriter* x, const QString& text_label_followed_by) :OdfWriter(x, "style:list-level-label-alignment", false) {
        addAttribute("text:label-followed-by", text_label_followed_by);
    }
    style_list_level_label_alignment(KoXmlWriter* x, const QString& text_label_followed_by) :OdfWriter(x, "style:list-level-label-alignment", false) {
        addAttribute("text:label-followed-by", text_label_followed_by);
    }
    void set_fo_margin_left(const QString& value) {
        addAttribute("fo:margin-left", value);
    }
    void set_fo_text_indent(const QString& value) {
        addAttribute("fo:text-indent", value);
    }
    void set_text_list_tab_stop_position(const QString& value) {
        addAttribute("text:list-tab-stop-position", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_map : public OdfWriter {
public:
    style_map(OdfWriter* x, const QString& style_apply_style_name, const QString& style_condition) :OdfWriter(x, "style:map", false) {
        addAttribute("style:apply-style-name", style_apply_style_name);
        addAttribute("style:condition", style_condition);
    }
    style_map(KoXmlWriter* x, const QString& style_apply_style_name, const QString& style_condition) :OdfWriter(x, "style:map", false) {
        addAttribute("style:apply-style-name", style_apply_style_name);
        addAttribute("style:condition", style_condition);
    }
    void set_style_base_cell_address(const QString& value) {
        addAttribute("style:base-cell-address", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_page_layout : public OdfWriter, public group_style_page_layout_content {
public:
    style_page_layout(OdfWriter* x, const QString& style_name) :OdfWriter(x, "style:page-layout", true), group_style_page_layout_content(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:name", style_name);
    }
    style_page_layout(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "style:page-layout", true), group_style_page_layout_content(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:name", style_name);
    }
    template<class T>
    void set_style_page_usage(const T& value) {
        addAttribute("style:page-usage", value);
    }
};
class style_tab_stop : public OdfWriter {
public:
    style_tab_stop(OdfWriter* x, const QString& style_position) :OdfWriter(x, "style:tab-stop", false) {
        addAttribute("style:position", style_position);
    }
    style_tab_stop(KoXmlWriter* x, const QString& style_position) :OdfWriter(x, "style:tab-stop", false) {
        addAttribute("style:position", style_position);
    }
    void set_style_char(const QString& value) {
        addAttribute("style:char", value);
    }
    template<class T>
    void set_style_leader_color(const T& value) {
        addAttribute("style:leader-color", value);
    }
    template<class T>
    void set_style_leader_style(const T& value) {
        addAttribute("style:leader-style", value);
    }
    void set_style_leader_text(const QString& value) {
        addAttribute("style:leader-text", value);
    }
    void set_style_leader_text_style(const QString& value) {
        addAttribute("style:leader-text-style", value);
    }
    template<class T>
    void set_style_leader_type(const T& value) {
        addAttribute("style:leader-type", value);
    }
    template<class T>
    void set_style_leader_width(const T& value) {
        addAttribute("style:leader-width", value);
    }
    template<class T>
    void set_style_type(const T& value) {
        addAttribute("style:type", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class style_graphic_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_background_transparency_attlist, public group_common_border_attlist, public group_common_border_line_width_attlist, public group_common_draw_rel_size_attlist, public group_common_editable_attlist, public group_common_horizontal_margin_attlist, public group_common_margin_attlist, public group_common_padding_attlist, public group_common_shadow_attlist, public group_common_text_anchor_attlist, public group_common_vertical_margin_attlist, public group_common_vertical_pos_attlist, public group_common_vertical_rel_attlist, public group_common_writing_mode_attlist, public group_style_background_image, public group_style_columns, public group_style_graphic_fill_properties_attlist, public group_text_list_style {
public:
    style_graphic_properties(OdfWriter* x) :OdfWriter(x, "style:graphic-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_background_transparency_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_rel_size_attlist(*static_cast<OdfWriter*>(this)), group_common_editable_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_text_anchor_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_rel_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)), group_style_columns(*static_cast<OdfWriter*>(this)), group_style_graphic_fill_properties_attlist(*static_cast<OdfWriter*>(this)), group_text_list_style(*static_cast<OdfWriter*>(this)) {
    }
    style_graphic_properties(KoXmlWriter* x) :OdfWriter(x, "style:graphic-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_background_transparency_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_rel_size_attlist(*static_cast<OdfWriter*>(this)), group_common_editable_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_text_anchor_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_rel_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)), group_style_columns(*static_cast<OdfWriter*>(this)), group_style_graphic_fill_properties_attlist(*static_cast<OdfWriter*>(this)), group_text_list_style(*static_cast<OdfWriter*>(this)) {
    }
    void set_dr3d_ambient_color(const QString& value) {
        addAttribute("dr3d:ambient-color", value);
    }
    void set_dr3d_back_scale(const QString& value) {
        addAttribute("dr3d:back-scale", value);
    }
    template<class T>
    void set_dr3d_backface_culling(const T& value) {
        addAttribute("dr3d:backface-culling", value);
    }
    template<class T>
    void set_dr3d_close_back(const T& value) {
        addAttribute("dr3d:close-back", value);
    }
    template<class T>
    void set_dr3d_close_front(const T& value) {
        addAttribute("dr3d:close-front", value);
    }
    void set_dr3d_depth(const QString& value) {
        addAttribute("dr3d:depth", value);
    }
    void set_dr3d_diffuse_color(const QString& value) {
        addAttribute("dr3d:diffuse-color", value);
    }
    void set_dr3d_edge_rounding(const QString& value) {
        addAttribute("dr3d:edge-rounding", value);
    }
    template<class T>
    void set_dr3d_edge_rounding_mode(const T& value) {
        addAttribute("dr3d:edge-rounding-mode", value);
    }
    void set_dr3d_emissive_color(const QString& value) {
        addAttribute("dr3d:emissive-color", value);
    }
    void set_dr3d_end_angle(const QString& value) {
        addAttribute("dr3d:end-angle", value);
    }
    void set_dr3d_horizontal_segments(quint64 value) {
        addAttribute("dr3d:horizontal-segments", value);
    }
    template<class T>
    void set_dr3d_lighting_mode(const T& value) {
        addAttribute("dr3d:lighting-mode", value);
    }
    template<class T>
    void set_dr3d_normals_direction(const T& value) {
        addAttribute("dr3d:normals-direction", value);
    }
    template<class T>
    void set_dr3d_normals_kind(const T& value) {
        addAttribute("dr3d:normals-kind", value);
    }
    template<class T>
    void set_dr3d_shadow(const T& value) {
        addAttribute("dr3d:shadow", value);
    }
    void set_dr3d_shininess(const QString& value) {
        addAttribute("dr3d:shininess", value);
    }
    void set_dr3d_specular_color(const QString& value) {
        addAttribute("dr3d:specular-color", value);
    }
    template<class T>
    void set_dr3d_texture_filter(const T& value) {
        addAttribute("dr3d:texture-filter", value);
    }
    template<class T>
    void set_dr3d_texture_generation_mode_x(const T& value) {
        addAttribute("dr3d:texture-generation-mode-x", value);
    }
    template<class T>
    void set_dr3d_texture_generation_mode_y(const T& value) {
        addAttribute("dr3d:texture-generation-mode-y", value);
    }
    template<class T>
    void set_dr3d_texture_kind(const T& value) {
        addAttribute("dr3d:texture-kind", value);
    }
    template<class T>
    void set_dr3d_texture_mode(const T& value) {
        addAttribute("dr3d:texture-mode", value);
    }
    void set_dr3d_vertical_segments(quint64 value) {
        addAttribute("dr3d:vertical-segments", value);
    }
    template<class T>
    void set_draw_auto_grow_height(const T& value) {
        addAttribute("draw:auto-grow-height", value);
    }
    template<class T>
    void set_draw_auto_grow_width(const T& value) {
        addAttribute("draw:auto-grow-width", value);
    }
    void set_draw_blue(const QString& value) {
        addAttribute("draw:blue", value);
    }
    void set_draw_caption_angle(const QString& value) {
        addAttribute("draw:caption-angle", value);
    }
    template<class T>
    void set_draw_caption_angle_type(const T& value) {
        addAttribute("draw:caption-angle-type", value);
    }
    void set_draw_caption_escape(const QString& value) {
        addAttribute("draw:caption-escape", value);
    }
    template<class T>
    void set_draw_caption_escape_direction(const T& value) {
        addAttribute("draw:caption-escape-direction", value);
    }
    template<class T>
    void set_draw_caption_fit_line_length(const T& value) {
        addAttribute("draw:caption-fit-line-length", value);
    }
    void set_draw_caption_gap(const QString& value) {
        addAttribute("draw:caption-gap", value);
    }
    void set_draw_caption_line_length(const QString& value) {
        addAttribute("draw:caption-line-length", value);
    }
    template<class T>
    void set_draw_caption_type(const T& value) {
        addAttribute("draw:caption-type", value);
    }
    template<class T>
    void set_draw_color_inversion(const T& value) {
        addAttribute("draw:color-inversion", value);
    }
    template<class T>
    void set_draw_color_mode(const T& value) {
        addAttribute("draw:color-mode", value);
    }
    void set_draw_contrast(const QString& value) {
        addAttribute("draw:contrast", value);
    }
    void set_draw_decimal_places(quint64 value) {
        addAttribute("draw:decimal-places", value);
    }
    template<class T>
    void set_draw_draw_aspect(const T& value) {
        addAttribute("draw:draw-aspect", value);
    }
    void set_draw_end_guide(const QString& value) {
        addAttribute("draw:end-guide", value);
    }
    void set_draw_end_line_spacing_horizontal(const QString& value) {
        addAttribute("draw:end-line-spacing-horizontal", value);
    }
    void set_draw_end_line_spacing_vertical(const QString& value) {
        addAttribute("draw:end-line-spacing-vertical", value);
    }
    template<class T>
    void set_draw_fit_to_contour(const T& value) {
        addAttribute("draw:fit-to-contour", value);
    }
    template<class T>
    void set_draw_fit_to_size(const T& value) {
        addAttribute("draw:fit-to-size", value);
    }
    template<class T>
    void set_draw_frame_display_border(const T& value) {
        addAttribute("draw:frame-display-border", value);
    }
    template<class T>
    void set_draw_frame_display_scrollbar(const T& value) {
        addAttribute("draw:frame-display-scrollbar", value);
    }
    void set_draw_frame_margin_horizontal(const QString& value) {
        addAttribute("draw:frame-margin-horizontal", value);
    }
    void set_draw_frame_margin_vertical(const QString& value) {
        addAttribute("draw:frame-margin-vertical", value);
    }
    void set_draw_gamma(const QString& value) {
        addAttribute("draw:gamma", value);
    }
    void set_draw_green(const QString& value) {
        addAttribute("draw:green", value);
    }
    void set_draw_guide_distance(const QString& value) {
        addAttribute("draw:guide-distance", value);
    }
    void set_draw_guide_overhang(const QString& value) {
        addAttribute("draw:guide-overhang", value);
    }
    void set_draw_image_opacity(const QString& value) {
        addAttribute("draw:image-opacity", value);
    }
    void set_draw_line_distance(const QString& value) {
        addAttribute("draw:line-distance", value);
    }
    void set_draw_luminance(const QString& value) {
        addAttribute("draw:luminance", value);
    }
    void set_draw_marker_end(const QString& value) {
        addAttribute("draw:marker-end", value);
    }
    template<class T>
    void set_draw_marker_end_center(const T& value) {
        addAttribute("draw:marker-end-center", value);
    }
    void set_draw_marker_end_width(const QString& value) {
        addAttribute("draw:marker-end-width", value);
    }
    void set_draw_marker_start(const QString& value) {
        addAttribute("draw:marker-start", value);
    }
    template<class T>
    void set_draw_marker_start_center(const T& value) {
        addAttribute("draw:marker-start-center", value);
    }
    void set_draw_marker_start_width(const QString& value) {
        addAttribute("draw:marker-start-width", value);
    }
    template<class T>
    void set_draw_measure_align(const T& value) {
        addAttribute("draw:measure-align", value);
    }
    template<class T>
    void set_draw_measure_vertical_align(const T& value) {
        addAttribute("draw:measure-vertical-align", value);
    }
    void set_draw_ole_draw_aspect(quint64 value) {
        addAttribute("draw:ole-draw-aspect", value);
    }
    template<class T>
    void set_draw_parallel(const T& value) {
        addAttribute("draw:parallel", value);
    }
    template<class T>
    void set_draw_placing(const T& value) {
        addAttribute("draw:placing", value);
    }
    void set_draw_red(const QString& value) {
        addAttribute("draw:red", value);
    }
    template<class T>
    void set_draw_shadow(const T& value) {
        addAttribute("draw:shadow", value);
    }
    void set_draw_shadow_color(const QString& value) {
        addAttribute("draw:shadow-color", value);
    }
    void set_draw_shadow_offset_x(const QString& value) {
        addAttribute("draw:shadow-offset-x", value);
    }
    void set_draw_shadow_offset_y(const QString& value) {
        addAttribute("draw:shadow-offset-y", value);
    }
    void set_draw_shadow_opacity(const QString& value) {
        addAttribute("draw:shadow-opacity", value);
    }
    template<class T>
    void set_draw_show_unit(const T& value) {
        addAttribute("draw:show-unit", value);
    }
    void set_draw_start_guide(const QString& value) {
        addAttribute("draw:start-guide", value);
    }
    void set_draw_start_line_spacing_horizontal(const QString& value) {
        addAttribute("draw:start-line-spacing-horizontal", value);
    }
    void set_draw_start_line_spacing_vertical(const QString& value) {
        addAttribute("draw:start-line-spacing-vertical", value);
    }
    template<class T>
    void set_draw_stroke(const T& value) {
        addAttribute("draw:stroke", value);
    }
    void set_draw_stroke_dash(const QString& value) {
        addAttribute("draw:stroke-dash", value);
    }
    template<class T>
    void set_draw_stroke_dash_names(const T& value) {
        addAttribute("draw:stroke-dash-names", value);
    }
    template<class T>
    void set_draw_stroke_linejoin(const T& value) {
        addAttribute("draw:stroke-linejoin", value);
    }
    void set_draw_symbol_color(const QString& value) {
        addAttribute("draw:symbol-color", value);
    }
    template<class T>
    void set_draw_textarea_horizontal_align(const T& value) {
        addAttribute("draw:textarea-horizontal-align", value);
    }
    template<class T>
    void set_draw_textarea_vertical_align(const T& value) {
        addAttribute("draw:textarea-vertical-align", value);
    }
    template<class T>
    void set_draw_unit(const T& value) {
        addAttribute("draw:unit", value);
    }
    void set_draw_visible_area_height(const QString& value) {
        addAttribute("draw:visible-area-height", value);
    }
    void set_draw_visible_area_left(const QString& value) {
        addAttribute("draw:visible-area-left", value);
    }
    void set_draw_visible_area_top(const QString& value) {
        addAttribute("draw:visible-area-top", value);
    }
    void set_draw_visible_area_width(const QString& value) {
        addAttribute("draw:visible-area-width", value);
    }
    template<class T>
    void set_draw_wrap_influence_on_position(const T& value) {
        addAttribute("draw:wrap-influence-on-position", value);
    }
    template<class T>
    void set_fo_clip(const T& value) {
        addAttribute("fo:clip", value);
    }
    void set_fo_max_height(const QString& value) {
        addAttribute("fo:max-height", value);
    }
    void set_fo_max_width(const QString& value) {
        addAttribute("fo:max-width", value);
    }
    void set_fo_min_height(const QString& value) {
        addAttribute("fo:min-height", value);
    }
    void set_fo_min_width(const QString& value) {
        addAttribute("fo:min-width", value);
    }
    template<class T>
    void set_fo_wrap_option(const T& value) {
        addAttribute("fo:wrap-option", value);
    }
    template<class T>
    void set_style_flow_with_text(const T& value) {
        addAttribute("style:flow-with-text", value);
    }
    template<class T>
    void set_style_horizontal_pos(const T& value) {
        addAttribute("style:horizontal-pos", value);
    }
    template<class T>
    void set_style_horizontal_rel(const T& value) {
        addAttribute("style:horizontal-rel", value);
    }
    template<class T>
    void set_style_mirror(const T& value) {
        addAttribute("style:mirror", value);
    }
    template<class T>
    void set_style_number_wrapped_paragraphs(const T& value) {
        addAttribute("style:number-wrapped-paragraphs", value);
    }
    template<class T>
    void set_style_overflow_behavior(const T& value) {
        addAttribute("style:overflow-behavior", value);
    }
    template<class T>
    void set_style_print_content(const T& value) {
        addAttribute("style:print-content", value);
    }
    template<class T>
    void set_style_protect(const T& value) {
        addAttribute("style:protect", value);
    }
    template<class T>
    void set_style_run_through(const T& value) {
        addAttribute("style:run-through", value);
    }
    template<class T>
    void set_style_shrink_to_fit(const T& value) {
        addAttribute("style:shrink-to-fit", value);
    }
    template<class T>
    void set_style_wrap(const T& value) {
        addAttribute("style:wrap", value);
    }
    template<class T>
    void set_style_wrap_contour(const T& value) {
        addAttribute("style:wrap-contour", value);
    }
    template<class T>
    void set_style_wrap_contour_mode(const T& value) {
        addAttribute("style:wrap-contour-mode", value);
    }
    void set_style_wrap_dynamic_threshold(const QString& value) {
        addAttribute("style:wrap-dynamic-threshold", value);
    }
    void set_svg_stroke_color(const QString& value) {
        addAttribute("svg:stroke-color", value);
    }
    template<class T>
    void set_svg_stroke_linecap(const T& value) {
        addAttribute("svg:stroke-linecap", value);
    }
    template<class T>
    void set_svg_stroke_opacity(const T& value) {
        addAttribute("svg:stroke-opacity", value);
    }
    void set_svg_stroke_width(const QString& value) {
        addAttribute("svg:stroke-width", value);
    }
    void set_svg_x(const QString& value) {
        addAttribute("svg:x", value);
    }
    template<class T>
    void set_text_animation(const T& value) {
        addAttribute("text:animation", value);
    }
    void set_text_animation_delay(Duration value) {
        addAttribute("text:animation-delay", value);
    }
    template<class T>
    void set_text_animation_direction(const T& value) {
        addAttribute("text:animation-direction", value);
    }
    void set_text_animation_repeat(quint64 value) {
        addAttribute("text:animation-repeat", value);
    }
    template<class T>
    void set_text_animation_start_inside(const T& value) {
        addAttribute("text:animation-start-inside", value);
    }
    void set_text_animation_steps(const QString& value) {
        addAttribute("text:animation-steps", value);
    }
    template<class T>
    void set_text_animation_stop_inside(const T& value) {
        addAttribute("text:animation-stop-inside", value);
    }
};
class style_list_level_properties : public OdfWriter, public group_common_text_align, public group_common_vertical_pos_attlist, public group_common_vertical_rel_attlist {
public:
    style_list_level_properties(OdfWriter* x) :OdfWriter(x, "style:list-level-properties", true), group_common_text_align(*static_cast<OdfWriter*>(this)), group_common_vertical_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_rel_attlist(*static_cast<OdfWriter*>(this)) {
    }
    style_list_level_properties(KoXmlWriter* x) :OdfWriter(x, "style:list-level-properties", true), group_common_text_align(*static_cast<OdfWriter*>(this)), group_common_vertical_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_rel_attlist(*static_cast<OdfWriter*>(this)) {
    }
    style_list_level_label_alignment add_style_list_level_label_alignment(const QString& text_label_followed_by);
    void set_fo_height(const QString& value) {
        addAttribute("fo:height", value);
    }
    void set_fo_width(const QString& value) {
        addAttribute("fo:width", value);
    }
    void set_style_font_name(const QString& value) {
        addAttribute("style:font-name", value);
    }
    template<class T>
    void set_text_list_level_position_and_space_mode(const T& value) {
        addAttribute("text:list-level-position-and-space-mode", value);
    }
    void set_text_min_label_distance(const QString& value) {
        addAttribute("text:min-label-distance", value);
    }
    void set_text_min_label_width(const QString& value) {
        addAttribute("text:min-label-width", value);
    }
    void set_text_space_before(const QString& value) {
        addAttribute("text:space-before", value);
    }
};
class style_page_layout_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_border_attlist, public group_common_border_line_width_attlist, public group_common_horizontal_margin_attlist, public group_common_margin_attlist, public group_common_num_format_attlist, public group_common_num_format_prefix_suffix_attlist, public group_common_padding_attlist, public group_common_shadow_attlist, public group_common_vertical_margin_attlist, public group_common_writing_mode_attlist, public group_style_background_image, public group_style_columns {
public:
    style_page_layout_properties(OdfWriter* x) :OdfWriter(x, "style:page-layout-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)), group_style_columns(*static_cast<OdfWriter*>(this)) {
    }
    style_page_layout_properties(KoXmlWriter* x) :OdfWriter(x, "style:page-layout-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_attlist(*static_cast<OdfWriter*>(this)), group_common_num_format_prefix_suffix_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)), group_style_columns(*static_cast<OdfWriter*>(this)) {
    }
    style_footnote_sep add_style_footnote_sep();
    void set_fo_page_height(const QString& value) {
        addAttribute("fo:page-height", value);
    }
    void set_fo_page_width(const QString& value) {
        addAttribute("fo:page-width", value);
    }
    template<class T>
    void set_style_first_page_number(const T& value) {
        addAttribute("style:first-page-number", value);
    }
    void set_style_footnote_max_height(const QString& value) {
        addAttribute("style:footnote-max-height", value);
    }
    void set_style_layout_grid_base_height(const QString& value) {
        addAttribute("style:layout-grid-base-height", value);
    }
    void set_style_layout_grid_base_width(const QString& value) {
        addAttribute("style:layout-grid-base-width", value);
    }
    void set_style_layout_grid_color(const QString& value) {
        addAttribute("style:layout-grid-color", value);
    }
    template<class T>
    void set_style_layout_grid_display(const T& value) {
        addAttribute("style:layout-grid-display", value);
    }
    void set_style_layout_grid_lines(quint64 value) {
        addAttribute("style:layout-grid-lines", value);
    }
    template<class T>
    void set_style_layout_grid_mode(const T& value) {
        addAttribute("style:layout-grid-mode", value);
    }
    template<class T>
    void set_style_layout_grid_print(const T& value) {
        addAttribute("style:layout-grid-print", value);
    }
    template<class T>
    void set_style_layout_grid_ruby_below(const T& value) {
        addAttribute("style:layout-grid-ruby-below", value);
    }
    void set_style_layout_grid_ruby_height(const QString& value) {
        addAttribute("style:layout-grid-ruby-height", value);
    }
    template<class T>
    void set_style_layout_grid_snap_to(const T& value) {
        addAttribute("style:layout-grid-snap-to", value);
    }
    template<class T>
    void set_style_layout_grid_standard_mode(const T& value) {
        addAttribute("style:layout-grid-standard-mode", value);
    }
    template<class T>
    void set_style_paper_tray_name(const T& value) {
        addAttribute("style:paper-tray-name", value);
    }
    template<class T>
    void set_style_print(const T& value) {
        addAttribute("style:print", value);
    }
    template<class T>
    void set_style_print_orientation(const T& value) {
        addAttribute("style:print-orientation", value);
    }
    template<class T>
    void set_style_print_page_order(const T& value) {
        addAttribute("style:print-page-order", value);
    }
    void set_style_register_truth_ref_style_name(const QString& value) {
        addAttribute("style:register-truth-ref-style-name", value);
    }
    void set_style_scale_to(const QString& value) {
        addAttribute("style:scale-to", value);
    }
    void set_style_scale_to_pages(quint64 value) {
        addAttribute("style:scale-to-pages", value);
    }
    template<class T>
    void set_style_table_centering(const T& value) {
        addAttribute("style:table-centering", value);
    }
};
class style_table_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_break_attlist, public group_common_horizontal_margin_attlist, public group_common_keep_with_next_attlist, public group_common_margin_attlist, public group_common_page_number_attlist, public group_common_shadow_attlist, public group_common_vertical_margin_attlist, public group_common_writing_mode_attlist, public group_style_background_image {
public:
    style_table_properties(OdfWriter* x) :OdfWriter(x, "style:table-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_break_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_keep_with_next_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_page_number_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    style_table_properties(KoXmlWriter* x) :OdfWriter(x, "style:table-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_break_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_keep_with_next_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_page_number_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_style_may_break_between_rows(const T& value) {
        addAttribute("style:may-break-between-rows", value);
    }
    void set_style_rel_width(const QString& value) {
        addAttribute("style:rel-width", value);
    }
    void set_style_width(const QString& value) {
        addAttribute("style:width", value);
    }
    template<class T>
    void set_table_align(const T& value) {
        addAttribute("table:align", value);
    }
    template<class T>
    void set_table_border_model(const T& value) {
        addAttribute("table:border-model", value);
    }
    template<class T>
    void set_table_display(const T& value) {
        addAttribute("table:display", value);
    }
};
class style_default_style : public OdfWriter, public group_style_style_content {
public:
    style_default_style(OdfWriter* x) :OdfWriter(x, "style:default-style", true), group_style_style_content(*static_cast<OdfWriter*>(this)) {
    }
    style_default_style(KoXmlWriter* x) :OdfWriter(x, "style:default-style", true), group_style_style_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_footer_left : public OdfWriter, public group_common_style_header_footer_attlist, public group_header_footer_content {
public:
    style_footer_left(OdfWriter* x) :OdfWriter(x, "style:footer-left", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
    style_footer_left(KoXmlWriter* x) :OdfWriter(x, "style:footer-left", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_header_footer_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_border_attlist, public group_common_border_line_width_attlist, public group_common_horizontal_margin_attlist, public group_common_margin_attlist, public group_common_padding_attlist, public group_common_shadow_attlist, public group_common_vertical_margin_attlist, public group_style_background_image {
public:
    style_header_footer_properties(OdfWriter* x) :OdfWriter(x, "style:header-footer-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    style_header_footer_properties(KoXmlWriter* x) :OdfWriter(x, "style:header-footer-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    void set_fo_min_height(const QString& value) {
        addAttribute("fo:min-height", value);
    }
    template<class T>
    void set_style_dynamic_spacing(const T& value) {
        addAttribute("style:dynamic-spacing", value);
    }
    void set_svg_height(const QString& value) {
        addAttribute("svg:height", value);
    }
};
class style_header_style : public OdfWriter, public group_style_header_footer_properties {
public:
    style_header_style(OdfWriter* x) :OdfWriter(x, "style:header-style", true), group_style_header_footer_properties(*static_cast<OdfWriter*>(this)) {
    }
    style_header_style(KoXmlWriter* x) :OdfWriter(x, "style:header-style", true), group_style_header_footer_properties(*static_cast<OdfWriter*>(this)) {
    }
};
class style_paragraph_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_background_transparency_attlist, public group_common_border_attlist, public group_common_border_line_width_attlist, public group_common_break_attlist, public group_common_horizontal_margin_attlist, public group_common_keep_with_next_attlist, public group_common_margin_attlist, public group_common_padding_attlist, public group_common_page_number_attlist, public group_common_shadow_attlist, public group_common_text_align, public group_common_vertical_margin_attlist, public group_common_writing_mode_attlist, public group_style_background_image {
public:
    style_paragraph_properties(OdfWriter* x) :OdfWriter(x, "style:paragraph-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_background_transparency_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_break_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_keep_with_next_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_page_number_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_text_align(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    style_paragraph_properties(KoXmlWriter* x) :OdfWriter(x, "style:paragraph-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_background_transparency_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_break_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_keep_with_next_attlist(*static_cast<OdfWriter*>(this)), group_common_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_page_number_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_text_align(*static_cast<OdfWriter*>(this)), group_common_vertical_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    style_drop_cap add_style_drop_cap();
    style_tab_stops add_style_tab_stops();
    template<class T>
    void set_fo_hyphenation_keep(const T& value) {
        addAttribute("fo:hyphenation-keep", value);
    }
    template<class T>
    void set_fo_hyphenation_ladder_count(const T& value) {
        addAttribute("fo:hyphenation-ladder-count", value);
    }
    template<class T>
    void set_fo_keep_together(const T& value) {
        addAttribute("fo:keep-together", value);
    }
    template<class T>
    void set_fo_line_height(const T& value) {
        addAttribute("fo:line-height", value);
    }
    void set_fo_orphans(quint64 value) {
        addAttribute("fo:orphans", value);
    }
    template<class T>
    void set_fo_text_align_last(const T& value) {
        addAttribute("fo:text-align-last", value);
    }
    void set_fo_text_indent(const QString& value) {
        addAttribute("fo:text-indent", value);
    }
    void set_fo_widows(quint64 value) {
        addAttribute("fo:widows", value);
    }
    template<class T>
    void set_style_auto_text_indent(const T& value) {
        addAttribute("style:auto-text-indent", value);
    }
    template<class T>
    void set_style_font_independent_line_spacing(const T& value) {
        addAttribute("style:font-independent-line-spacing", value);
    }
    template<class T>
    void set_style_join_border(const T& value) {
        addAttribute("style:join-border", value);
    }
    template<class T>
    void set_style_justify_single_word(const T& value) {
        addAttribute("style:justify-single-word", value);
    }
    template<class T>
    void set_style_line_break(const T& value) {
        addAttribute("style:line-break", value);
    }
    void set_style_line_height_at_least(const QString& value) {
        addAttribute("style:line-height-at-least", value);
    }
    void set_style_line_spacing(const QString& value) {
        addAttribute("style:line-spacing", value);
    }
    template<class T>
    void set_style_punctuation_wrap(const T& value) {
        addAttribute("style:punctuation-wrap", value);
    }
    template<class T>
    void set_style_register_true(const T& value) {
        addAttribute("style:register-true", value);
    }
    template<class T>
    void set_style_snap_to_layout_grid(const T& value) {
        addAttribute("style:snap-to-layout-grid", value);
    }
    void set_style_tab_stop_distance(const QString& value) {
        addAttribute("style:tab-stop-distance", value);
    }
    template<class T>
    void set_style_text_autospace(const T& value) {
        addAttribute("style:text-autospace", value);
    }
    template<class T>
    void set_style_vertical_align(const T& value) {
        addAttribute("style:vertical-align", value);
    }
    template<class T>
    void set_style_writing_mode_automatic(const T& value) {
        addAttribute("style:writing-mode-automatic", value);
    }
    void set_text_line_number(quint64 value) {
        addAttribute("text:line-number", value);
    }
    template<class T>
    void set_text_number_lines(const T& value) {
        addAttribute("text:number-lines", value);
    }
};
class style_region_left : public OdfWriter, public group_region_content {
public:
    style_region_left(OdfWriter* x) :OdfWriter(x, "style:region-left", true), group_region_content(*static_cast<OdfWriter*>(this)) {
    }
    style_region_left(KoXmlWriter* x) :OdfWriter(x, "style:region-left", true), group_region_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_section_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_editable_attlist, public group_common_horizontal_margin_attlist, public group_common_writing_mode_attlist, public group_style_background_image, public group_style_columns, public group_text_notes_configuration {
public:
    style_section_properties(OdfWriter* x) :OdfWriter(x, "style:section-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_editable_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)), group_style_columns(*static_cast<OdfWriter*>(this)), group_text_notes_configuration(*static_cast<OdfWriter*>(this)) {
    }
    style_section_properties(KoXmlWriter* x) :OdfWriter(x, "style:section-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_editable_attlist(*static_cast<OdfWriter*>(this)), group_common_horizontal_margin_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)), group_style_columns(*static_cast<OdfWriter*>(this)), group_text_notes_configuration(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_style_protect(const T& value) {
        addAttribute("style:protect", value);
    }
    template<class T>
    void set_text_dont_balance_text_columns(const T& value) {
        addAttribute("text:dont-balance-text-columns", value);
    }
};
class style_table_cell_properties : public OdfWriter, public group_common_background_color_attlist, public group_common_border_attlist, public group_common_border_line_width_attlist, public group_common_padding_attlist, public group_common_rotation_angle_attlist, public group_common_shadow_attlist, public group_common_style_direction_attlist, public group_common_writing_mode_attlist, public group_style_background_image {
public:
    style_table_cell_properties(OdfWriter* x) :OdfWriter(x, "style:table-cell-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_rotation_angle_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_style_direction_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    style_table_cell_properties(KoXmlWriter* x) :OdfWriter(x, "style:table-cell-properties", true), group_common_background_color_attlist(*static_cast<OdfWriter*>(this)), group_common_border_attlist(*static_cast<OdfWriter*>(this)), group_common_border_line_width_attlist(*static_cast<OdfWriter*>(this)), group_common_padding_attlist(*static_cast<OdfWriter*>(this)), group_common_rotation_angle_attlist(*static_cast<OdfWriter*>(this)), group_common_shadow_attlist(*static_cast<OdfWriter*>(this)), group_common_style_direction_attlist(*static_cast<OdfWriter*>(this)), group_common_writing_mode_attlist(*static_cast<OdfWriter*>(this)), group_style_background_image(*static_cast<OdfWriter*>(this)) {
    }
    template<class T>
    void set_fo_wrap_option(const T& value) {
        addAttribute("fo:wrap-option", value);
    }
    template<class T>
    void set_style_cell_protect(const T& value) {
        addAttribute("style:cell-protect", value);
    }
    void set_style_decimal_places(quint64 value) {
        addAttribute("style:decimal-places", value);
    }
    void set_style_diagonal_bl_tr(const QString& value) {
        addAttribute("style:diagonal-bl-tr", value);
    }
    template<class T>
    void set_style_diagonal_bl_tr_widths(const T& value) {
        addAttribute("style:diagonal-bl-tr-widths", value);
    }
    void set_style_diagonal_tl_br(const QString& value) {
        addAttribute("style:diagonal-tl-br", value);
    }
    template<class T>
    void set_style_diagonal_tl_br_widths(const T& value) {
        addAttribute("style:diagonal-tl-br-widths", value);
    }
    template<class T>
    void set_style_glyph_orientation_vertical(const T& value) {
        addAttribute("style:glyph-orientation-vertical", value);
    }
    template<class T>
    void set_style_print_content(const T& value) {
        addAttribute("style:print-content", value);
    }
    template<class T>
    void set_style_repeat_content(const T& value) {
        addAttribute("style:repeat-content", value);
    }
    template<class T>
    void set_style_rotation_align(const T& value) {
        addAttribute("style:rotation-align", value);
    }
    template<class T>
    void set_style_shrink_to_fit(const T& value) {
        addAttribute("style:shrink-to-fit", value);
    }
    template<class T>
    void set_style_text_align_source(const T& value) {
        addAttribute("style:text-align-source", value);
    }
    template<class T>
    void set_style_vertical_align(const T& value) {
        addAttribute("style:vertical-align", value);
    }
};
class style_footer : public OdfWriter, public group_common_style_header_footer_attlist, public group_header_footer_content {
public:
    style_footer(OdfWriter* x) :OdfWriter(x, "style:footer", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
    style_footer(KoXmlWriter* x) :OdfWriter(x, "style:footer", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_handout_master : public OdfWriter, public group_common_presentation_header_footer_attlist, public group_shape {
public:
    style_handout_master(OdfWriter* x, const QString& style_page_layout_name) :OdfWriter(x, "style:handout-master", true), group_common_presentation_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:page-layout-name", style_page_layout_name);
    }
    style_handout_master(KoXmlWriter* x, const QString& style_page_layout_name) :OdfWriter(x, "style:handout-master", true), group_common_presentation_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:page-layout-name", style_page_layout_name);
    }
    void set_draw_style_name(const QString& value) {
        addAttribute("draw:style-name", value);
    }
    void set_presentation_presentation_page_layout_name(const QString& value) {
        addAttribute("presentation:presentation-page-layout-name", value);
    }
};
class style_header_left : public OdfWriter, public group_common_style_header_footer_attlist, public group_header_footer_content {
public:
    style_header_left(OdfWriter* x) :OdfWriter(x, "style:header-left", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
    style_header_left(KoXmlWriter* x) :OdfWriter(x, "style:header-left", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_region_center : public OdfWriter, public group_region_content {
public:
    style_region_center(OdfWriter* x) :OdfWriter(x, "style:region-center", true), group_region_content(*static_cast<OdfWriter*>(this)) {
    }
    style_region_center(KoXmlWriter* x) :OdfWriter(x, "style:region-center", true), group_region_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_style : public OdfWriter, public group_style_map, public group_style_style_content {
public:
    style_style(OdfWriter* x, const QString& style_name) :OdfWriter(x, "style:style", true), group_style_map(*static_cast<OdfWriter*>(this)), group_style_style_content(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:name", style_name);
    }
    style_style(KoXmlWriter* x, const QString& style_name) :OdfWriter(x, "style:style", true), group_style_map(*static_cast<OdfWriter*>(this)), group_style_style_content(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:name", style_name);
    }
    template<class T>
    void set_style_auto_update(const T& value) {
        addAttribute("style:auto-update", value);
    }
    void set_style_class(const QString& value) {
        addAttribute("style:class", value);
    }
    void set_style_data_style_name(const QString& value) {
        addAttribute("style:data-style-name", value);
    }
    void set_style_default_outline_level(quint64 value) {
        addAttribute("style:default-outline-level", value);
    }
    void set_style_display_name(const QString& value) {
        addAttribute("style:display-name", value);
    }
    void set_style_list_level(quint64 value) {
        addAttribute("style:list-level", value);
    }
    void set_style_list_style_name(const QString& value) {
        addAttribute("style:list-style-name", value);
    }
    void set_style_master_page_name(const QString& value) {
        addAttribute("style:master-page-name", value);
    }
    void set_style_next_style_name(const QString& value) {
        addAttribute("style:next-style-name", value);
    }
    void set_style_parent_style_name(const QString& value) {
        addAttribute("style:parent-style-name", value);
    }
    void set_style_percentage_data_style_name(const QString& value) {
        addAttribute("style:percentage-data-style-name", value);
    }
};
class style_footer_style : public OdfWriter, public group_style_header_footer_properties {
public:
    style_footer_style(OdfWriter* x) :OdfWriter(x, "style:footer-style", true), group_style_header_footer_properties(*static_cast<OdfWriter*>(this)) {
    }
    style_footer_style(KoXmlWriter* x) :OdfWriter(x, "style:footer-style", true), group_style_header_footer_properties(*static_cast<OdfWriter*>(this)) {
    }
};
class style_master_page : public OdfWriter, public group_animation_element, public group_draw_layer_set, public group_office_forms, public group_presentation_notes, public group_shape {
public:
    style_master_page(OdfWriter* x, const QString& style_name, const QString& style_page_layout_name) :OdfWriter(x, "style:master-page", true), group_animation_element(*static_cast<OdfWriter*>(this)), group_draw_layer_set(*static_cast<OdfWriter*>(this)), group_office_forms(*static_cast<OdfWriter*>(this)), group_presentation_notes(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:name", style_name);
        addAttribute("style:page-layout-name", style_page_layout_name);
    }
    style_master_page(KoXmlWriter* x, const QString& style_name, const QString& style_page_layout_name) :OdfWriter(x, "style:master-page", true), group_animation_element(*static_cast<OdfWriter*>(this)), group_draw_layer_set(*static_cast<OdfWriter*>(this)), group_office_forms(*static_cast<OdfWriter*>(this)), group_presentation_notes(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)) {
        addAttribute("style:name", style_name);
        addAttribute("style:page-layout-name", style_page_layout_name);
    }
    style_footer add_style_footer();
    style_footer_left add_style_footer_left();
    style_header add_style_header();
    style_header_left add_style_header_left();
    void set_draw_style_name(const QString& value) {
        addAttribute("draw:style-name", value);
    }
    void set_style_display_name(const QString& value) {
        addAttribute("style:display-name", value);
    }
    void set_style_next_style_name(const QString& value) {
        addAttribute("style:next-style-name", value);
    }
};
class style_chart_properties : public OdfWriter, public group_common_rotation_angle_attlist, public group_common_style_direction_attlist {
public:
    style_chart_properties(OdfWriter* x) :OdfWriter(x, "style:chart-properties", true), group_common_rotation_angle_attlist(*static_cast<OdfWriter*>(this)), group_common_style_direction_attlist(*static_cast<OdfWriter*>(this)) {
    }
    style_chart_properties(KoXmlWriter* x) :OdfWriter(x, "style:chart-properties", true), group_common_rotation_angle_attlist(*static_cast<OdfWriter*>(this)), group_common_style_direction_attlist(*static_cast<OdfWriter*>(this)) {
    }
    chart_label_separator add_chart_label_separator();
    chart_symbol_image add_chart_symbol_image(const QUrl& xlink_href);
    void set_chart_angle_offset(const QString& value) {
        addAttribute("chart:angle-offset", value);
    }
    template<class T>
    void set_chart_auto_position(const T& value) {
        addAttribute("chart:auto-position", value);
    }
    template<class T>
    void set_chart_auto_size(const T& value) {
        addAttribute("chart:auto-size", value);
    }
    template<class T>
    void set_chart_axis_label_position(const T& value) {
        addAttribute("chart:axis-label-position", value);
    }
    template<class T>
    void set_chart_axis_position(const T& value) {
        addAttribute("chart:axis-position", value);
    }
    template<class T>
    void set_chart_connect_bars(const T& value) {
        addAttribute("chart:connect-bars", value);
    }
    template<class T>
    void set_chart_data_label_number(const T& value) {
        addAttribute("chart:data-label-number", value);
    }
    template<class T>
    void set_chart_data_label_symbol(const T& value) {
        addAttribute("chart:data-label-symbol", value);
    }
    template<class T>
    void set_chart_data_label_text(const T& value) {
        addAttribute("chart:data-label-text", value);
    }
    template<class T>
    void set_chart_deep(const T& value) {
        addAttribute("chart:deep", value);
    }
    template<class T>
    void set_chart_display_label(const T& value) {
        addAttribute("chart:display-label", value);
    }
    template<class T>
    void set_chart_error_category(const T& value) {
        addAttribute("chart:error-category", value);
    }
    template<class T>
    void set_chart_error_lower_indicator(const T& value) {
        addAttribute("chart:error-lower-indicator", value);
    }
    void set_chart_error_lower_limit(double value) {
        addAttribute("chart:error-lower-limit", value);
    }
    void set_chart_error_lower_range(const QString& value) {
        addAttribute("chart:error-lower-range", value);
    }
    void set_chart_error_margin(double value) {
        addAttribute("chart:error-margin", value);
    }
    void set_chart_error_percentage(double value) {
        addAttribute("chart:error-percentage", value);
    }
    template<class T>
    void set_chart_error_upper_indicator(const T& value) {
        addAttribute("chart:error-upper-indicator", value);
    }
    void set_chart_error_upper_limit(double value) {
        addAttribute("chart:error-upper-limit", value);
    }
    void set_chart_error_upper_range(const QString& value) {
        addAttribute("chart:error-upper-range", value);
    }
    void set_chart_gap_width(qint64 value) {
        addAttribute("chart:gap-width", value);
    }
    template<class T>
    void set_chart_group_bars_per_axis(const T& value) {
        addAttribute("chart:group-bars-per-axis", value);
    }
    void set_chart_hole_size(const QString& value) {
        addAttribute("chart:hole-size", value);
    }
    template<class T>
    void set_chart_include_hidden_cells(const T& value) {
        addAttribute("chart:include-hidden-cells", value);
    }
    template<class T>
    void set_chart_interpolation(const T& value) {
        addAttribute("chart:interpolation", value);
    }
    void set_chart_interval_major(double value) {
        addAttribute("chart:interval-major", value);
    }
    void set_chart_interval_minor_divisor(quint64 value) {
        addAttribute("chart:interval-minor-divisor", value);
    }
    template<class T>
    void set_chart_japanese_candle_stick(const T& value) {
        addAttribute("chart:japanese-candle-stick", value);
    }
    template<class T>
    void set_chart_label_arrangement(const T& value) {
        addAttribute("chart:label-arrangement", value);
    }
    template<class T>
    void set_chart_label_position(const T& value) {
        addAttribute("chart:label-position", value);
    }
    template<class T>
    void set_chart_label_position_negative(const T& value) {
        addAttribute("chart:label-position-negative", value);
    }
    template<class T>
    void set_chart_lines(const T& value) {
        addAttribute("chart:lines", value);
    }
    template<class T>
    void set_chart_link_data_style_to_source(const T& value) {
        addAttribute("chart:link-data-style-to-source", value);
    }
    template<class T>
    void set_chart_logarithmic(const T& value) {
        addAttribute("chart:logarithmic", value);
    }
    void set_chart_maximum(double value) {
        addAttribute("chart:maximum", value);
    }
    template<class T>
    void set_chart_mean_value(const T& value) {
        addAttribute("chart:mean-value", value);
    }
    void set_chart_minimum(double value) {
        addAttribute("chart:minimum", value);
    }
    void set_chart_origin(double value) {
        addAttribute("chart:origin", value);
    }
    void set_chart_overlap(qint64 value) {
        addAttribute("chart:overlap", value);
    }
    template<class T>
    void set_chart_percentage(const T& value) {
        addAttribute("chart:percentage", value);
    }
    void set_chart_pie_offset(quint64 value) {
        addAttribute("chart:pie-offset", value);
    }
    template<class T>
    void set_chart_regression_type(const T& value) {
        addAttribute("chart:regression-type", value);
    }
    template<class T>
    void set_chart_reverse_direction(const T& value) {
        addAttribute("chart:reverse-direction", value);
    }
    template<class T>
    void set_chart_right_angled_axes(const T& value) {
        addAttribute("chart:right-angled-axes", value);
    }
    template<class T>
    void set_chart_scale_text(const T& value) {
        addAttribute("chart:scale-text", value);
    }
    template<class T>
    void set_chart_series_source(const T& value) {
        addAttribute("chart:series-source", value);
    }
    template<class T>
    void set_chart_solid_type(const T& value) {
        addAttribute("chart:solid-type", value);
    }
    template<class T>
    void set_chart_sort_by_x_values(const T& value) {
        addAttribute("chart:sort-by-x-values", value);
    }
    void set_chart_spline_order(quint64 value) {
        addAttribute("chart:spline-order", value);
    }
    void set_chart_spline_resolution(quint64 value) {
        addAttribute("chart:spline-resolution", value);
    }
    template<class T>
    void set_chart_stacked(const T& value) {
        addAttribute("chart:stacked", value);
    }
    void set_chart_symbol_height(const QString& value) {
        addAttribute("chart:symbol-height", value);
    }
    template<class T>
    void set_chart_symbol_name(const T& value) {
        addAttribute("chart:symbol-name", value);
    }
    template<class T>
    void set_chart_symbol_type(const T& value) {
        addAttribute("chart:symbol-type", value);
    }
    void set_chart_symbol_width(const QString& value) {
        addAttribute("chart:symbol-width", value);
    }
    template<class T>
    void set_chart_text_overlap(const T& value) {
        addAttribute("chart:text-overlap", value);
    }
    template<class T>
    void set_chart_three_dimensional(const T& value) {
        addAttribute("chart:three-dimensional", value);
    }
    template<class T>
    void set_chart_tick_mark_position(const T& value) {
        addAttribute("chart:tick-mark-position", value);
    }
    template<class T>
    void set_chart_tick_marks_major_inner(const T& value) {
        addAttribute("chart:tick-marks-major-inner", value);
    }
    template<class T>
    void set_chart_tick_marks_major_outer(const T& value) {
        addAttribute("chart:tick-marks-major-outer", value);
    }
    template<class T>
    void set_chart_tick_marks_minor_inner(const T& value) {
        addAttribute("chart:tick-marks-minor-inner", value);
    }
    template<class T>
    void set_chart_tick_marks_minor_outer(const T& value) {
        addAttribute("chart:tick-marks-minor-outer", value);
    }
    template<class T>
    void set_chart_treat_empty_cells(const T& value) {
        addAttribute("chart:treat-empty-cells", value);
    }
    template<class T>
    void set_chart_vertical(const T& value) {
        addAttribute("chart:vertical", value);
    }
    template<class T>
    void set_chart_visible(const T& value) {
        addAttribute("chart:visible", value);
    }
    template<class T>
    void set_text_line_break(const T& value) {
        addAttribute("text:line-break", value);
    }
};
class style_region_right : public OdfWriter, public group_region_content {
public:
    style_region_right(OdfWriter* x) :OdfWriter(x, "style:region-right", true), group_region_content(*static_cast<OdfWriter*>(this)) {
    }
    style_region_right(KoXmlWriter* x) :OdfWriter(x, "style:region-right", true), group_region_content(*static_cast<OdfWriter*>(this)) {
    }
};
class style_header : public OdfWriter, public group_common_style_header_footer_attlist, public group_header_footer_content {
public:
    style_header(OdfWriter* x) :OdfWriter(x, "style:header", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
    style_header(KoXmlWriter* x) :OdfWriter(x, "style:header", true), group_common_style_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_header_footer_content(*static_cast<OdfWriter*>(this)) {
    }
};
}
inline writeodf::style_background_image
writeodf::group_style_background_image::add_style_background_image() {
    return writeodf::style_background_image(&xml);
}
inline writeodf::style_list_level_properties
writeodf::group_style_list_level_properties::add_style_list_level_properties() {
    return writeodf::style_list_level_properties(&xml);
}
inline writeodf::style_footer_style
writeodf::group_style_page_layout_content::add_style_footer_style() {
    return writeodf::style_footer_style(&xml);
}
inline writeodf::style_header_style
writeodf::group_style_page_layout_content::add_style_header_style() {
    return writeodf::style_header_style(&xml);
}
inline writeodf::style_page_layout_properties
writeodf::group_style_page_layout_content::add_style_page_layout_properties() {
    return writeodf::style_page_layout_properties(&xml);
}
inline writeodf::style_text_properties
writeodf::group_style_text_properties::add_style_text_properties() {
    return writeodf::style_text_properties(&xml);
}
inline writeodf::style_tab_stop
writeodf::style_tab_stops::add_style_tab_stop(const QString& style_position) {
    return writeodf::style_tab_stop(this, style_position);
}
inline writeodf::style_columns
writeodf::group_style_columns::add_style_columns(quint64 fo_column_count) {
    return writeodf::style_columns(&xml, fo_column_count);
}
inline writeodf::style_map
writeodf::group_style_map::add_style_map(const QString& style_apply_style_name, const QString& style_condition) {
    return writeodf::style_map(&xml, style_apply_style_name, style_condition);
}
inline writeodf::style_header_footer_properties
writeodf::group_style_header_footer_properties::add_style_header_footer_properties() {
    return writeodf::style_header_footer_properties(&xml);
}
inline writeodf::style_column
writeodf::style_columns::add_style_column(const QString& style_rel_width) {
    return writeodf::style_column(this, style_rel_width);
}
inline writeodf::style_column_sep
writeodf::style_columns::add_style_column_sep(const QString& style_width) {
    return writeodf::style_column_sep(this, style_width);
}
inline writeodf::style_style
writeodf::group_styles::add_style_style(const QString& style_name) {
    return writeodf::style_style(&xml, style_name);
}
inline writeodf::style_list_level_label_alignment
writeodf::style_list_level_properties::add_style_list_level_label_alignment(const QString& text_label_followed_by) {
    return writeodf::style_list_level_label_alignment(this, text_label_followed_by);
}
inline writeodf::style_footnote_sep
writeodf::style_page_layout_properties::add_style_footnote_sep() {
    return writeodf::style_footnote_sep(this);
}
inline writeodf::style_region_center
writeodf::group_header_footer_content::add_style_region_center() {
    return writeodf::style_region_center(&xml);
}
inline writeodf::style_region_left
writeodf::group_header_footer_content::add_style_region_left() {
    return writeodf::style_region_left(&xml);
}
inline writeodf::style_region_right
writeodf::group_header_footer_content::add_style_region_right() {
    return writeodf::style_region_right(&xml);
}
inline writeodf::style_chart_properties
writeodf::group_style_style_content::add_style_chart_properties() {
    return writeodf::style_chart_properties(&xml);
}
inline writeodf::style_drawing_page_properties
writeodf::group_style_style_content::add_style_drawing_page_properties() {
    return writeodf::style_drawing_page_properties(&xml);
}
inline writeodf::style_graphic_properties
writeodf::group_style_style_content::add_style_graphic_properties() {
    return writeodf::style_graphic_properties(&xml);
}
inline writeodf::style_paragraph_properties
writeodf::group_style_style_content::add_style_paragraph_properties() {
    return writeodf::style_paragraph_properties(&xml);
}
inline writeodf::style_ruby_properties
writeodf::group_style_style_content::add_style_ruby_properties() {
    return writeodf::style_ruby_properties(&xml);
}
inline writeodf::style_section_properties
writeodf::group_style_style_content::add_style_section_properties() {
    return writeodf::style_section_properties(&xml);
}
inline writeodf::style_table_cell_properties
writeodf::group_style_style_content::add_style_table_cell_properties() {
    return writeodf::style_table_cell_properties(&xml);
}
inline writeodf::style_table_column_properties
writeodf::group_style_style_content::add_style_table_column_properties() {
    return writeodf::style_table_column_properties(&xml);
}
inline writeodf::style_table_properties
writeodf::group_style_style_content::add_style_table_properties() {
    return writeodf::style_table_properties(&xml);
}
inline writeodf::style_table_row_properties
writeodf::group_style_style_content::add_style_table_row_properties() {
    return writeodf::style_table_row_properties(&xml);
}
inline writeodf::style_drop_cap
writeodf::style_paragraph_properties::add_style_drop_cap() {
    return writeodf::style_drop_cap(this);
}
inline writeodf::style_tab_stops
writeodf::style_paragraph_properties::add_style_tab_stops() {
    return writeodf::style_tab_stops(this);
}
inline writeodf::style_footer
writeodf::style_master_page::add_style_footer() {
    return writeodf::style_footer(this);
}
inline writeodf::style_footer_left
writeodf::style_master_page::add_style_footer_left() {
    return writeodf::style_footer_left(this);
}
inline writeodf::style_header
writeodf::style_master_page::add_style_header() {
    return writeodf::style_header(this);
}
inline writeodf::style_header_left
writeodf::style_master_page::add_style_header_left() {
    return writeodf::style_header_left(this);
}
#endif
