/* config_window.c generated by valac 0.56.17, the Vala compiler
 * generated from config_window.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <json-glib/json-glib.h>
#include <cairo-gobject.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;
enum  {
	WIDGETS_CONFIG_WINDOW_0_PROPERTY,
	WIDGETS_CONFIG_WINDOW_NUM_PROPERTIES
};
static GParamSpec* widgets_config_window_properties[WIDGETS_CONFIG_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;
typedef struct _WidgetsWorkspaceManagerPrivate WidgetsWorkspaceManagerPrivate;
typedef struct _Block11Data Block11Data;

#define WIDGETS_TYPE_TERM (widgets_term_get_type ())
#define WIDGETS_TERM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TERM, WidgetsTerm))
#define WIDGETS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TERM, WidgetsTermClass))
#define WIDGETS_IS_TERM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TERM))
#define WIDGETS_IS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TERM))
#define WIDGETS_TERM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TERM, WidgetsTermClass))

typedef struct _WidgetsTerm WidgetsTerm;
typedef struct _WidgetsTermClass WidgetsTermClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define WIDGETS_TYPE_DIALOG (widgets_dialog_get_type ())
#define WIDGETS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialog))
#define WIDGETS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))
#define WIDGETS_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_DIALOG))
#define WIDGETS_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_DIALOG))
#define WIDGETS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))

typedef struct _WidgetsDialog WidgetsDialog;
typedef struct _WidgetsDialogClass WidgetsDialogClass;

#define WIDGETS_TYPE_CONFIRM_DIALOG (widgets_confirm_dialog_get_type ())
#define WIDGETS_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIRM_DIALOG, WidgetsConfirmDialog))
#define WIDGETS_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIRM_DIALOG, WidgetsConfirmDialogClass))
#define WIDGETS_IS_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIRM_DIALOG))
#define WIDGETS_IS_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIRM_DIALOG))
#define WIDGETS_CONFIRM_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIRM_DIALOG, WidgetsConfirmDialogClass))

typedef struct _WidgetsConfirmDialog WidgetsConfirmDialog;
typedef struct _WidgetsConfirmDialogClass WidgetsConfirmDialogClass;

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _WidgetsConfigWindowPrivate {
	gboolean is_show_shortcut_viewer;
};

struct _WidgetsWorkspaceManager {
	GtkBox parent_instance;
	WidgetsWorkspaceManagerPrivate * priv;
	GeeHashMap* workspace_map;
	WidgetsTabbar* tabbar;
	WidgetsWorkspace* focus_workspace;
	gint workspace_index;
};

struct _WidgetsWorkspaceManagerClass {
	GtkBoxClass parent_class;
};

struct _Block11Data {
	int _ref_count_;
	WidgetsConfigWindow* self;
	WidgetsTabbar* tabbar;
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

static gint WidgetsConfigWindow_private_offset;
static gpointer widgets_config_window_parent_class = NULL;
VALA_EXTERN gint constant_ACTIVE_TAB_UNDERLINE_HEIGHT;

VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN void widgets_config_window_toggle_fullscreen (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_config_window_window_save_before_quit (WidgetsConfigWindow* self);
VALA_EXTERN GdkCursorType* widgets_config_window_get_frame_cursor_type (WidgetsConfigWindow* self,
                                                            gdouble x,
                                                            gdouble y);
VALA_EXTERN void widgets_config_window_update_frame (WidgetsConfigWindow* self);
VALA_EXTERN GdkCursorType* widgets_config_window_get_cursor_type (WidgetsConfigWindow* self,
                                                      gdouble x,
                                                      gdouble y);
VALA_EXTERN WidgetsConfigWindow* widgets_config_window_new (void);
VALA_EXTERN WidgetsConfigWindow* widgets_config_window_construct (GType object_type);
VALA_EXTERN void widgets_config_window_load_config (WidgetsConfigWindow* self);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
VALA_EXTERN void widgets_config_window_init (WidgetsConfigWindow* self,
                                 WidgetsWorkspaceManager* manager,
                                 WidgetsTabbar* tabbar);
static void __lambda192_ (WidgetsConfigWindow* self);
static void ___lambda192__gdk_screen_composited_changed (GdkScreen* _sender,
                                                  gpointer self);
static gboolean __lambda193_ (WidgetsConfigWindow* self,
                       GdkEventAny* w);
VALA_EXTERN void widgets_config_window_quit (WidgetsConfigWindow* self);
static gboolean ___lambda193__gtk_widget_delete_event (GtkWidget* _sender,
                                                GdkEventAny* event,
                                                gpointer self);
static void __lambda194_ (WidgetsConfigWindow* self,
                   GtkWidget* t);
static void ___lambda194__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static gboolean __lambda195_ (WidgetsConfigWindow* self,
                       GtkWidget* w,
                       GdkEventKey* e);
static gboolean widgets_config_window_on_key_press (WidgetsConfigWindow* self,
                                             GtkWidget* widget,
                                             GdkEventKey* key_event);
static gboolean ___lambda195__gtk_widget_key_press_event (GtkWidget* _sender,
                                                   GdkEventKey* event,
                                                   gpointer self);
static gboolean __lambda214_ (WidgetsConfigWindow* self,
                       GtkWidget* w,
                       GdkEventKey* e);
static gboolean widgets_config_window_on_key_release (WidgetsConfigWindow* self,
                                               GtkWidget* widget,
                                               GdkEventKey* key_event);
static gboolean ___lambda214__gtk_widget_key_release_event (GtkWidget* _sender,
                                                     GdkEventKey* event,
                                                     gpointer self);
static gboolean __lambda215_ (WidgetsConfigWindow* self,
                       GtkWidget* w,
                       GdkEventCrossing* e);
static gboolean ___lambda216_ (WidgetsConfigWindow* self);
VALA_EXTERN void utils_get_pointer_position (gint* x,
                                 gint* y);
VALA_EXTERN gboolean widgets_config_window_window_is_normal (WidgetsConfigWindow* self);
static gboolean ____lambda216__gsource_func (gpointer self);
static guint* _uint_dup (guint* self);
static gboolean ___lambda215__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
static gboolean __lambda217_ (WidgetsConfigWindow* self,
                       GtkWidget* w,
                       GdkEventCrossing* e);
static gboolean ___lambda218_ (WidgetsConfigWindow* self);
static gboolean ____lambda218__gsource_func (gpointer self);
static gboolean ___lambda217__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
static gboolean __lambda219_ (WidgetsConfigWindow* self,
                       GtkWidget* w,
                       GdkEventCrossing* e);
static gboolean ___lambda220_ (WidgetsConfigWindow* self);
static gboolean ____lambda220__gsource_func (gpointer self);
static gboolean ___lambda219__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                      GdkEventCrossing* event,
                                                      gpointer self);
static gboolean __lambda221_ (WidgetsConfigWindow* self,
                       GdkEventFocus* w);
VALA_EXTERN void widgets_config_window_remove_shortcut_viewer (WidgetsConfigWindow* self);
static gboolean ___lambda221__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static gboolean __lambda222_ (WidgetsConfigWindow* self,
                       GdkEventConfigure* w);
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN void widgets_workspace_remove_theme_panel (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_remove_remote_panel (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_remove_encoding_panel (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_remove_command_panel (WidgetsWorkspace* self);
static gboolean ___lambda222__gtk_widget_configure_event (GtkWidget* _sender,
                                                   GdkEventConfigure* event,
                                                   gpointer self);
VALA_EXTERN void widgets_config_window_init_active_tab_underline (WidgetsConfigWindow* self,
                                                      WidgetsTabbar* tabbar);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void __lambda223_ (Block11Data* _data11_,
                   WidgetsTabbar* t,
                   gint x,
                   gint width);
VALA_EXTERN void widgets_config_window_redraw_window (WidgetsConfigWindow* self);
static void ___lambda223__widgets_tabbar_update_tab_underline (WidgetsTabbar* _sender,
                                                        gint x,
                                                        gint width,
                                                        gpointer self);
VALA_EXTERN ConfigConfig* config_config_new (void);
VALA_EXTERN ConfigConfig* config_config_construct (GType object_type);
static void __lambda261_ (WidgetsConfigWindow* self,
                   ConfigConfig* w);
VALA_EXTERN void widgets_config_window_update_theme_style (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_config_window_update_terminal (WidgetsConfigWindow* self,
                                            GtkContainer* container);
static void ___lambda261__config_config_update (ConfigConfig* _sender,
                                         gpointer self);
static void __lambda262_ (WidgetsConfigWindow* self,
                   GtkWidget* child);
VALA_EXTERN GType widgets_term_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTerm, g_object_unref)
VALA_EXTERN void widgets_term_setup_from_config (WidgetsTerm* self);
static void ___lambda262__gtk_callback (GtkWidget* widget,
                                 gpointer self);
VALA_EXTERN void widgets_config_window_show_shortcut_viewer (WidgetsConfigWindow* self,
                                                 gint x,
                                                 gint y);
VALA_EXTERN gchar* widgets_config_window_get_shortcut_data (WidgetsConfigWindow* self);
VALA_EXTERN void widgets_config_window_insert_shortcut_key (WidgetsConfigWindow* self,
                                                JsonBuilder* builder,
                                                const gchar* name,
                                                const gchar* key);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN gboolean widgets_workspace_manager_has_active_term (WidgetsWorkspaceManager* self);
VALA_EXTERN GType widgets_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsDialog, g_object_unref)
VALA_EXTERN GType widgets_confirm_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfirmDialog, g_object_unref)
VALA_EXTERN WidgetsConfirmDialog* widgets_create_running_confirm_dialog (WidgetsConfigWindow* window);
static void ___lambda85_ (WidgetsConfigWindow* self,
                   WidgetsConfirmDialog* d);
static void widgets_config_window_fast_quit (WidgetsConfigWindow* self);
static void ____lambda85__widgets_confirm_dialog_confirm (WidgetsConfirmDialog* _sender,
                                                   gpointer self);
VALA_EXTERN gchar* keymap_get_keyevent_name (GdkEventKey* key_event);
VALA_EXTERN void utils_show_manual (void);
VALA_EXTERN WidgetsTerm* widgets_workspace_get_focus_term (WidgetsWorkspace* self,
                                               GtkContainer* container);
VALA_EXTERN void widgets_workspace_search (WidgetsWorkspace* self,
                               const gchar* search_text);
VALA_EXTERN gchar* widgets_term_get_selection_text (WidgetsTerm* self);
VALA_EXTERN void widgets_tabbar_close_current_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_next_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_previous_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_workspace_resize_workspace_left (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_resize_workspace_right (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_resize_workspace_up (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_resize_workspace_down (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_remove_all_panels (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_split_vertical (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_split_horizontal (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_select_up_window (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_select_down_window (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_select_left_window (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_select_right_window (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_close_focus_term (WidgetsWorkspace* self);
VALA_EXTERN void widgets_workspace_close_other_terms (WidgetsWorkspace* self);
VALA_EXTERN void widgets_term_rename_title (WidgetsTerm* self);
VALA_EXTERN gboolean utils_is_command_exist (const gchar* command_name);
VALA_EXTERN gint config_config_get_terminal_monitor (ConfigConfig* self);
VALA_EXTERN void widgets_workspace_toggle_command_panel (WidgetsWorkspace* self,
                                             WidgetsWorkspace* workspace);
VALA_EXTERN void widgets_workspace_toggle_remote_panel (WidgetsWorkspace* self,
                                            WidgetsWorkspace* workspace);
VALA_EXTERN void widgets_workspace_toggle_select_all (WidgetsWorkspace* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
VALA_EXTERN void widgets_workspace_manager_switch_workspace_with_index (WidgetsWorkspaceManager* self,
                                                            gint index);
VALA_EXTERN gchar* keymap_get_key_name (guint keyval);
VALA_EXTERN gboolean keymap_is_no_key_press (GdkEventKey* key_event);
VALA_EXTERN void widgets_workspace_manager_new_workspace_with_current_directory (WidgetsWorkspaceManager* self,
                                                                     gboolean remote_serve_action);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN void widgets_config_window_draw_titlebar_underline (WidgetsConfigWindow* self,
                                                    cairo_t* cr,
                                                    gint x,
                                                    gint y,
                                                    gint width,
                                                    gint offset);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void widgets_config_window_draw_active_tab_underline (WidgetsConfigWindow* self,
                                                      cairo_t* cr,
                                                      gint x,
                                                      gint y);
static void widgets_config_window_real_toggle_fullscreen (WidgetsConfigWindow* self);
static void widgets_config_window_real_window_save_before_quit (WidgetsConfigWindow* self);
static GdkCursorType* widgets_config_window_real_get_frame_cursor_type (WidgetsConfigWindow* self,
                                                                 gdouble x,
                                                                 gdouble y);
static void widgets_config_window_real_update_frame (WidgetsConfigWindow* self);
static GdkCursorType* widgets_config_window_real_get_cursor_type (WidgetsConfigWindow* self,
                                                           gdouble x,
                                                           gdouble y);
VALA_EXTERN gboolean widgets_config_window_window_is_max (WidgetsConfigWindow* self);
VALA_EXTERN gboolean widgets_config_window_window_is_tiled (WidgetsConfigWindow* self);
VALA_EXTERN gboolean widgets_config_window_window_is_fullscreen (WidgetsConfigWindow* self);
static void widgets_config_window_finalize (GObject * obj);
static GType widgets_config_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
widgets_config_window_get_instance_private (WidgetsConfigWindow* self)
{
	return G_STRUCT_MEMBER_P (self, WidgetsConfigWindow_private_offset);
}

WidgetsConfigWindow*
widgets_config_window_construct (GType object_type)
{
	WidgetsConfigWindow * self = NULL;
	GdkRGBA _tmp0_ = {0};
	GdkRGBA _tmp1_ = {0};
	self = (WidgetsConfigWindow*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	widgets_config_window_load_config (self);
	utils_hex_to_rgba ("#000000", 0.3, &_tmp0_);
	self->title_line_dark_color = _tmp0_;
	utils_hex_to_rgba ("#000000", 0.1, &_tmp1_);
	self->title_line_light_color = _tmp1_;
	return self;
}

WidgetsConfigWindow*
widgets_config_window_new (void)
{
	return widgets_config_window_construct (WIDGETS_TYPE_CONFIG_WINDOW);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda192_ (WidgetsConfigWindow* self)
{
	widgets_config_window_update_frame (self);
}

static void
___lambda192__gdk_screen_composited_changed (GdkScreen* _sender,
                                             gpointer self)
{
	__lambda192_ ((WidgetsConfigWindow*) self);
}

static gboolean
__lambda193_ (WidgetsConfigWindow* self,
              GdkEventAny* w)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	widgets_config_window_quit (self);
	result = TRUE;
	return result;
}

static gboolean
___lambda193__gtk_widget_delete_event (GtkWidget* _sender,
                                       GdkEventAny* event,
                                       gpointer self)
{
	gboolean result;
	result = __lambda193_ ((WidgetsConfigWindow*) self, event);
	return result;
}

static void
__lambda194_ (WidgetsConfigWindow* self,
              GtkWidget* t)
{
	g_return_if_fail (t != NULL);
	widgets_config_window_quit (self);
}

static void
___lambda194__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda194_ ((WidgetsConfigWindow*) self, _sender);
}

static gboolean
__lambda195_ (WidgetsConfigWindow* self,
              GtkWidget* w,
              GdkEventKey* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	result = widgets_config_window_on_key_press (self, w, e);
	return result;
}

static gboolean
___lambda195__gtk_widget_key_press_event (GtkWidget* _sender,
                                          GdkEventKey* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda195_ ((WidgetsConfigWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda214_ (WidgetsConfigWindow* self,
              GtkWidget* w,
              GdkEventKey* e)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	result = widgets_config_window_on_key_release (self, w, e);
	return result;
}

static gboolean
___lambda214__gtk_widget_key_release_event (GtkWidget* _sender,
                                            GdkEventKey* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda214_ ((WidgetsConfigWindow*) self, _sender, event);
	return result;
}

static gboolean
___lambda216_ (WidgetsConfigWindow* self)
{
	gint pointer_x = 0;
	gint pointer_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean result;
	utils_get_pointer_position (&_tmp0_, &_tmp1_);
	pointer_x = _tmp0_;
	pointer_y = _tmp1_;
	if (!widgets_config_window_window_is_normal (self)) {
		GdkWindow* _tmp2_;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp2_, NULL);
	} else {
		gboolean _tmp3_ = FALSE;
		if (pointer_x != self->resize_cache_x) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = pointer_y != self->resize_cache_y;
		}
		if (_tmp3_) {
			GdkCursorType* cursor_type = NULL;
			GdkCursorType* _tmp4_;
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp5_;
			GdkDisplay* _tmp6_;
			GdkCursorType* _tmp7_;
			self->resize_cache_x = pointer_x;
			self->resize_cache_y = pointer_y;
			_tmp4_ = widgets_config_window_get_cursor_type (self, (gdouble) pointer_x, (gdouble) pointer_y);
			cursor_type = _tmp4_;
			_tmp5_ = gdk_display_get_default ();
			_tmp6_ = _g_object_ref0 (_tmp5_);
			display = _tmp6_;
			_tmp7_ = cursor_type;
			if (_tmp7_ != NULL) {
				GdkWindow* _tmp8_;
				GdkDisplay* _tmp9_;
				GdkCursorType* _tmp10_;
				GdkCursor* _tmp11_;
				GdkCursor* _tmp12_;
				_tmp8_ = gtk_widget_get_window ((GtkWidget*) self);
				_tmp9_ = display;
				_tmp10_ = cursor_type;
				_tmp11_ = gdk_cursor_new_for_display (_tmp9_, *_tmp10_);
				_tmp12_ = _tmp11_;
				gdk_window_set_cursor (_tmp8_, _tmp12_);
				_g_object_unref0 (_tmp12_);
			} else {
				GdkWindow* _tmp13_;
				_tmp13_ = gtk_widget_get_window ((GtkWidget*) self);
				gdk_window_set_cursor (_tmp13_, NULL);
			}
			_g_object_unref0 (display);
			_g_free0 (cursor_type);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda216__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda216_ ((WidgetsConfigWindow*) self);
	return result;
}

static guint*
_uint_dup (guint* self)
{
	guint* dup;
	dup = g_new0 (guint, 1);
	memcpy (dup, self, sizeof (guint));
	return dup;
}

static gpointer
__uint_dup0 (gpointer self)
{
	return self ? _uint_dup (self) : NULL;
}

static gboolean
__lambda215_ (WidgetsConfigWindow* self,
              GtkWidget* w,
              GdkEventCrossing* e)
{
	guint* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->resize_timeout_source_id;
	if (_tmp0_ == NULL) {
		guint _tmp1_;
		guint* _tmp2_;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->resize_timeout_delay, ____lambda216__gsource_func, g_object_ref (self), g_object_unref);
		_tmp2_ = __uint_dup0 (&_tmp1_);
		_g_free0 (self->resize_timeout_source_id);
		self->resize_timeout_source_id = _tmp2_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda215__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda215_ ((WidgetsConfigWindow*) self, _sender, event);
	return result;
}

static gboolean
___lambda218_ (WidgetsConfigWindow* self)
{
	gint pointer_x = 0;
	gint pointer_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean result;
	utils_get_pointer_position (&_tmp0_, &_tmp1_);
	pointer_x = _tmp0_;
	pointer_y = _tmp1_;
	if (!widgets_config_window_window_is_normal (self)) {
		GdkWindow* _tmp2_;
		_tmp2_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp2_, NULL);
	} else {
		gboolean _tmp3_ = FALSE;
		if (pointer_x != self->resize_cache_x) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = pointer_y != self->resize_cache_y;
		}
		if (_tmp3_) {
			GdkCursorType* cursor_type = NULL;
			GdkCursorType* _tmp4_;
			GdkDisplay* display = NULL;
			GdkDisplay* _tmp5_;
			GdkDisplay* _tmp6_;
			GdkCursorType* _tmp7_;
			self->resize_cache_x = pointer_x;
			self->resize_cache_y = pointer_y;
			_tmp4_ = widgets_config_window_get_cursor_type (self, (gdouble) pointer_x, (gdouble) pointer_y);
			cursor_type = _tmp4_;
			_tmp5_ = gdk_display_get_default ();
			_tmp6_ = _g_object_ref0 (_tmp5_);
			display = _tmp6_;
			_tmp7_ = cursor_type;
			if (_tmp7_ != NULL) {
				GdkWindow* _tmp8_;
				GdkDisplay* _tmp9_;
				GdkCursorType* _tmp10_;
				GdkCursor* _tmp11_;
				GdkCursor* _tmp12_;
				_tmp8_ = gtk_widget_get_window ((GtkWidget*) self);
				_tmp9_ = display;
				_tmp10_ = cursor_type;
				_tmp11_ = gdk_cursor_new_for_display (_tmp9_, *_tmp10_);
				_tmp12_ = _tmp11_;
				gdk_window_set_cursor (_tmp8_, _tmp12_);
				_g_object_unref0 (_tmp12_);
			} else {
				GdkWindow* _tmp13_;
				_tmp13_ = gtk_widget_get_window ((GtkWidget*) self);
				gdk_window_set_cursor (_tmp13_, NULL);
			}
			_g_object_unref0 (display);
			_g_free0 (cursor_type);
		}
	}
	result = TRUE;
	return result;
}

static gboolean
____lambda218__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda218_ ((WidgetsConfigWindow*) self);
	return result;
}

static gboolean
__lambda217_ (WidgetsConfigWindow* self,
              GtkWidget* w,
              GdkEventCrossing* e)
{
	guint* _tmp0_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->resize_timeout_source_id;
	if (_tmp0_ == NULL) {
		guint _tmp1_;
		guint* _tmp2_;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->resize_timeout_delay, ____lambda218__gsource_func, g_object_ref (self), g_object_unref);
		_tmp2_ = __uint_dup0 (&_tmp1_);
		_g_free0 (self->resize_timeout_source_id);
		self->resize_timeout_source_id = _tmp2_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda217__gtk_widget_enter_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda217_ ((WidgetsConfigWindow*) self, _sender, event);
	return result;
}

static gboolean
___lambda220_ (WidgetsConfigWindow* self)
{
	gint pointer_x = 0;
	gint pointer_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GdkCursorType* cursor_type = NULL;
	GdkCursorType* _tmp2_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	GdkCursorType* _tmp5_;
	GdkCursorType* _tmp12_;
	GdkCursorType* _tmp14_;
	gboolean result;
	utils_get_pointer_position (&_tmp0_, &_tmp1_);
	pointer_x = _tmp0_;
	pointer_y = _tmp1_;
	_tmp2_ = widgets_config_window_get_cursor_type (self, (gdouble) pointer_x, (gdouble) pointer_y);
	cursor_type = _tmp2_;
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	display = _tmp4_;
	_tmp5_ = cursor_type;
	if (_tmp5_ != NULL) {
		GdkWindow* _tmp6_;
		GdkDisplay* _tmp7_;
		GdkCursorType* _tmp8_;
		GdkCursor* _tmp9_;
		GdkCursor* _tmp10_;
		_tmp6_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp7_ = display;
		_tmp8_ = cursor_type;
		_tmp9_ = gdk_cursor_new_for_display (_tmp7_, *_tmp8_);
		_tmp10_ = _tmp9_;
		gdk_window_set_cursor (_tmp6_, _tmp10_);
		_g_object_unref0 (_tmp10_);
	} else {
		GdkWindow* _tmp11_;
		_tmp11_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_cursor (_tmp11_, NULL);
	}
	_tmp12_ = cursor_type;
	if (_tmp12_ == NULL) {
		guint* _tmp13_;
		_tmp13_ = self->reset_timeout_source_id;
		g_source_remove (*_tmp13_);
		_g_free0 (self->reset_timeout_source_id);
		self->reset_timeout_source_id = NULL;
	}
	_tmp14_ = cursor_type;
	result = _tmp14_ != NULL;
	_g_object_unref0 (display);
	_g_free0 (cursor_type);
	return result;
}

static gboolean
____lambda220__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda220_ ((WidgetsConfigWindow*) self);
	return result;
}

static gboolean
__lambda219_ (WidgetsConfigWindow* self,
              GtkWidget* w,
              GdkEventCrossing* e)
{
	guint* _tmp0_;
	guint* _tmp2_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->resize_timeout_source_id;
	if (_tmp0_ != NULL) {
		guint* _tmp1_;
		_tmp1_ = self->resize_timeout_source_id;
		g_source_remove (*_tmp1_);
		_g_free0 (self->resize_timeout_source_id);
		self->resize_timeout_source_id = NULL;
	}
	_tmp2_ = self->reset_timeout_source_id;
	if (_tmp2_ == NULL) {
		guint _tmp3_;
		guint* _tmp4_;
		_tmp3_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) self->reset_timeout_delay, ____lambda220__gsource_func, g_object_ref (self), g_object_unref);
		_tmp4_ = __uint_dup0 (&_tmp3_);
		_g_free0 (self->reset_timeout_source_id);
		self->reset_timeout_source_id = _tmp4_;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda219__gtk_widget_leave_notify_event (GtkWidget* _sender,
                                             GdkEventCrossing* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda219_ ((WidgetsConfigWindow*) self, _sender, event);
	return result;
}

static gboolean
__lambda221_ (WidgetsConfigWindow* self,
              GdkEventFocus* w)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	widgets_config_window_remove_shortcut_viewer (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda221__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda221_ ((WidgetsConfigWindow*) self, event);
	return result;
}

static gboolean
__lambda222_ (WidgetsConfigWindow* self,
              GdkEventConfigure* w)
{
	gint width = 0;
	gint height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	width = _tmp0_;
	height = _tmp1_;
	if (self->cache_width != width) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = self->cache_height != height;
	}
	if (_tmp2_) {
		{
			GeeIterator* _workspace_entry_it = NULL;
			WidgetsWorkspaceManager* _tmp3_;
			GeeHashMap* _tmp4_;
			GeeSet* _tmp5_;
			GeeSet* _tmp6_;
			GeeSet* _tmp7_;
			GeeIterator* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp3_ = self->workspace_manager;
			_tmp4_ = _tmp3_->workspace_map;
			_tmp5_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_iterable_iterator ((GeeIterable*) _tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			_workspace_entry_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				GeeMapEntry* workspace_entry = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				GeeMapEntry* _tmp13_;
				gconstpointer _tmp14_;
				gconstpointer _tmp15_;
				GeeMapEntry* _tmp16_;
				gconstpointer _tmp17_;
				gconstpointer _tmp18_;
				GeeMapEntry* _tmp19_;
				gconstpointer _tmp20_;
				gconstpointer _tmp21_;
				GeeMapEntry* _tmp22_;
				gconstpointer _tmp23_;
				gconstpointer _tmp24_;
				_tmp10_ = _workspace_entry_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _workspace_entry_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				workspace_entry = (GeeMapEntry*) _tmp12_;
				_tmp13_ = workspace_entry;
				_tmp14_ = gee_map_entry_get_value (_tmp13_);
				_tmp15_ = _tmp14_;
				widgets_workspace_remove_theme_panel ((WidgetsWorkspace*) _tmp15_);
				_tmp16_ = workspace_entry;
				_tmp17_ = gee_map_entry_get_value (_tmp16_);
				_tmp18_ = _tmp17_;
				widgets_workspace_remove_remote_panel ((WidgetsWorkspace*) _tmp18_);
				_tmp19_ = workspace_entry;
				_tmp20_ = gee_map_entry_get_value (_tmp19_);
				_tmp21_ = _tmp20_;
				widgets_workspace_remove_encoding_panel ((WidgetsWorkspace*) _tmp21_);
				_tmp22_ = workspace_entry;
				_tmp23_ = gee_map_entry_get_value (_tmp22_);
				_tmp24_ = _tmp23_;
				widgets_workspace_remove_command_panel ((WidgetsWorkspace*) _tmp24_);
				_g_object_unref0 (workspace_entry);
			}
			_g_object_unref0 (_workspace_entry_it);
		}
		self->cache_width = width;
		self->cache_height = height;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda222__gtk_widget_configure_event (GtkWidget* _sender,
                                          GdkEventConfigure* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda222_ ((WidgetsConfigWindow*) self, event);
	return result;
}

void
widgets_config_window_init (WidgetsConfigWindow* self,
                            WidgetsWorkspaceManager* manager,
                            WidgetsTabbar* tabbar)
{
	WidgetsWorkspaceManager* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GdkScreen* _tmp3_;
	GdkScreen* _tmp4_;
	GdkScreen* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (manager != NULL);
	g_return_if_fail (tabbar != NULL);
	gtk_widget_set_redraw_on_allocate ((GtkWidget*) self, TRUE);
	_tmp0_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->workspace_manager);
	self->workspace_manager = _tmp0_;
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->box);
	self->box = _tmp1_;
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->top_box);
	self->top_box = _tmp2_;
	_tmp3_ = gdk_screen_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->screen_monitor);
	self->screen_monitor = _tmp4_;
	_tmp5_ = self->screen_monitor;
	g_signal_connect_object (_tmp5_, "composited-changed", (GCallback) ___lambda192__gdk_screen_composited_changed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda193__gtk_widget_delete_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "destroy", (GCallback) ___lambda194__gtk_widget_destroy, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) ___lambda195__gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) ___lambda214__gtk_widget_key_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda215__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) ___lambda217__gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) ___lambda219__gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) ___lambda221__gtk_widget_focus_out_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) ___lambda222__gtk_widget_configure_event, self, 0);
	widgets_config_window_init_active_tab_underline (self, tabbar);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		WidgetsConfigWindow* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->tabbar);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
__lambda223_ (Block11Data* _data11_,
              WidgetsTabbar* t,
              gint x,
              gint width)
{
	WidgetsConfigWindow* self;
	gint offset_x = 0;
	gint offset_y = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint tab_x = 0;
	gint tab_width = 0;
	gboolean _tmp2_ = FALSE;
	self = _data11_->self;
	g_return_if_fail (t != NULL);
	gtk_widget_translate_coordinates ((GtkWidget*) _data11_->tabbar, (GtkWidget*) self, 0, 0, &_tmp0_, &_tmp1_);
	offset_x = _tmp0_;
	offset_y = _tmp1_;
	tab_x = x + offset_x;
	tab_width = width;
	if (tab_x != self->active_tab_underline_x) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = tab_width != self->active_tab_underline_width;
	}
	if (_tmp2_) {
		self->active_tab_underline_x = x + offset_x;
		self->active_tab_underline_width = width;
		widgets_config_window_redraw_window (self);
	}
}

static void
___lambda223__widgets_tabbar_update_tab_underline (WidgetsTabbar* _sender,
                                                   gint x,
                                                   gint width,
                                                   gpointer self)
{
	__lambda223_ (self, _sender, x, width);
}

void
widgets_config_window_init_active_tab_underline (WidgetsConfigWindow* self,
                                                 WidgetsTabbar* tabbar)
{
	Block11Data* _data11_;
	WidgetsTabbar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tabbar != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (tabbar);
	_g_object_unref0 (_data11_->tabbar);
	_data11_->tabbar = _tmp0_;
	g_signal_connect_data (_data11_->tabbar, "update-tab-underline", (GCallback) ___lambda223__widgets_tabbar_update_tab_underline, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}

static void
__lambda261_ (WidgetsConfigWindow* self,
              ConfigConfig* w)
{
	g_return_if_fail (w != NULL);
	widgets_config_window_update_theme_style (self);
	widgets_config_window_update_terminal (self, (GtkContainer*) self);
	widgets_config_window_redraw_window (self);
}

static void
___lambda261__config_config_update (ConfigConfig* _sender,
                                    gpointer self)
{
	__lambda261_ ((WidgetsConfigWindow*) self, _sender);
}

void
widgets_config_window_load_config (WidgetsConfigWindow* self)
{
	ConfigConfig* _tmp0_;
	ConfigConfig* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = config_config_new ();
	_g_object_unref0 (self->config);
	self->config = _tmp0_;
	_tmp1_ = self->config;
	g_signal_connect_object (_tmp1_, "update", (GCallback) ___lambda261__config_config_update, self, 0);
}

static void
__lambda262_ (WidgetsConfigWindow* self,
              GtkWidget* child)
{
	GType child_type = 0UL;
	g_return_if_fail (child != NULL);
	child_type = G_TYPE_FROM_INSTANCE ((GObject*) child);
	if (g_type_is_a (child_type, WIDGETS_TYPE_TERM)) {
		widgets_term_setup_from_config (G_TYPE_CHECK_INSTANCE_CAST (child, WIDGETS_TYPE_TERM, WidgetsTerm));
	} else {
		if (g_type_is_a (child_type, gtk_container_get_type ())) {
			widgets_config_window_update_terminal (self, G_TYPE_CHECK_INSTANCE_CAST (child, gtk_container_get_type (), GtkContainer));
		}
	}
}

static void
___lambda262__gtk_callback (GtkWidget* widget,
                            gpointer self)
{
	__lambda262_ ((WidgetsConfigWindow*) self, widget);
}

void
widgets_config_window_update_terminal (WidgetsConfigWindow* self,
                                       GtkContainer* container)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	gtk_container_forall (container, ___lambda262__gtk_callback, self);
}

void
widgets_config_window_show_shortcut_viewer (WidgetsConfigWindow* self,
                                            gint x,
                                            gint y)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	widgets_config_window_remove_shortcut_viewer (self);
	if (!self->priv->is_show_shortcut_viewer) {
		gchar* data = NULL;
		gchar* _tmp0_;
		_tmp0_ = widgets_config_window_get_shortcut_data (self);
		data = _tmp0_;
		{
			GAppInfo* appinfo = NULL;
			const gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			GAppInfo* _tmp4_;
			GAppInfo* _tmp5_;
			GAppInfo* _tmp6_;
			_tmp1_ = data;
			_tmp2_ = g_strdup_printf ("deepin-shortcut-viewer -j='%s' -p=%i,%i", _tmp1_, x, y);
			_tmp3_ = _tmp2_;
			_tmp4_ = g_app_info_create_from_commandline (_tmp3_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
			_tmp5_ = _tmp4_;
			_g_free0 (_tmp3_);
			appinfo = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp6_ = appinfo;
			g_app_info_launch (_tmp6_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (appinfo);
				goto __catch0_g_error;
			}
			self->priv->is_show_shortcut_viewer = TRUE;
			_g_object_unref0 (appinfo);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			const gchar* _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp7_ = e;
			_tmp8_ = _tmp7_->message;
			g_print ("ConfigWindow show_shortcut_viewer: %s\n", _tmp8_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (data);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (data);
	}
}

void
widgets_config_window_remove_shortcut_viewer (WidgetsConfigWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->is_show_shortcut_viewer) {
		{
			GAppInfo* appinfo = NULL;
			GAppInfo* _tmp0_;
			GAppInfo* _tmp1_;
			_tmp0_ = g_app_info_create_from_commandline ("deepin-shortcut-viewer -j=''", NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
			appinfo = _tmp0_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp1_ = appinfo;
			g_app_info_launch (_tmp1_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (appinfo);
				goto __catch0_g_error;
			}
			_g_object_unref0 (appinfo);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_print ("Main on_key_press: %s\n", _tmp3_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		self->priv->is_show_shortcut_viewer = FALSE;
	}
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

gchar*
widgets_config_window_get_shortcut_data (WidgetsConfigWindow* self)
{
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp0_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp180_;
	JsonNode* root = NULL;
	JsonBuilder* _tmp181_;
	JsonNode* _tmp182_;
	gchar* _tmp183_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = json_builder_new ();
	builder = _tmp0_;
	{
		JsonBuilder* _tmp1_;
		JsonBuilder* _tmp2_;
		JsonBuilder* _tmp3_;
		JsonBuilder* _tmp4_;
		JsonBuilder* _tmp5_;
		JsonBuilder* _tmp6_;
		gchar* _tmp7_ = NULL;
		ConfigConfig* _tmp8_;
		GKeyFile* _tmp9_;
		gchar* _tmp10_;
		JsonBuilder* _tmp11_;
		gchar* _tmp12_ = NULL;
		ConfigConfig* _tmp13_;
		GKeyFile* _tmp14_;
		gchar* _tmp15_;
		JsonBuilder* _tmp16_;
		gchar* _tmp17_ = NULL;
		ConfigConfig* _tmp18_;
		GKeyFile* _tmp19_;
		gchar* _tmp20_;
		JsonBuilder* _tmp21_;
		gchar* _tmp22_ = NULL;
		ConfigConfig* _tmp23_;
		GKeyFile* _tmp24_;
		gchar* _tmp25_;
		JsonBuilder* _tmp26_;
		gchar* _tmp27_ = NULL;
		ConfigConfig* _tmp28_;
		GKeyFile* _tmp29_;
		gchar* _tmp30_;
		JsonBuilder* _tmp31_;
		gchar* _tmp32_ = NULL;
		ConfigConfig* _tmp33_;
		GKeyFile* _tmp34_;
		gchar* _tmp35_;
		JsonBuilder* _tmp36_;
		gchar* _tmp37_ = NULL;
		ConfigConfig* _tmp38_;
		GKeyFile* _tmp39_;
		gchar* _tmp40_;
		JsonBuilder* _tmp41_;
		gchar* _tmp42_ = NULL;
		ConfigConfig* _tmp43_;
		GKeyFile* _tmp44_;
		gchar* _tmp45_;
		JsonBuilder* _tmp46_;
		gchar* _tmp47_ = NULL;
		ConfigConfig* _tmp48_;
		GKeyFile* _tmp49_;
		gchar* _tmp50_;
		JsonBuilder* _tmp51_;
		gchar* _tmp52_ = NULL;
		ConfigConfig* _tmp53_;
		GKeyFile* _tmp54_;
		gchar* _tmp55_;
		JsonBuilder* _tmp56_;
		JsonBuilder* _tmp57_;
		JsonBuilder* _tmp58_;
		JsonBuilder* _tmp59_;
		JsonBuilder* _tmp60_;
		JsonBuilder* _tmp61_;
		JsonBuilder* _tmp62_;
		JsonBuilder* _tmp63_;
		gchar* select_workspace_key = NULL;
		ConfigConfig* _tmp64_;
		GKeyFile* _tmp65_;
		gchar* _tmp66_;
		gchar* new_theme_terminal_key = NULL;
		ConfigConfig* _tmp67_;
		GKeyFile* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_ = NULL;
		ConfigConfig* _tmp71_;
		GKeyFile* _tmp72_;
		gchar* _tmp73_;
		JsonBuilder* _tmp74_;
		gchar* _tmp75_ = NULL;
		ConfigConfig* _tmp76_;
		GKeyFile* _tmp77_;
		gchar* _tmp78_;
		JsonBuilder* _tmp79_;
		gchar* _tmp80_ = NULL;
		ConfigConfig* _tmp81_;
		GKeyFile* _tmp82_;
		gchar* _tmp83_;
		JsonBuilder* _tmp84_;
		gchar* _tmp85_ = NULL;
		ConfigConfig* _tmp86_;
		GKeyFile* _tmp87_;
		gchar* _tmp88_;
		JsonBuilder* _tmp89_;
		JsonBuilder* _tmp90_;
		const gchar* _tmp91_;
		const gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		JsonBuilder* _tmp95_;
		const gchar* _tmp96_;
		const gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_ = NULL;
		ConfigConfig* _tmp101_;
		GKeyFile* _tmp102_;
		gchar* _tmp103_;
		JsonBuilder* _tmp104_;
		gchar* _tmp105_ = NULL;
		ConfigConfig* _tmp106_;
		GKeyFile* _tmp107_;
		gchar* _tmp108_;
		JsonBuilder* _tmp109_;
		gchar* _tmp110_ = NULL;
		ConfigConfig* _tmp111_;
		GKeyFile* _tmp112_;
		gchar* _tmp113_;
		JsonBuilder* _tmp114_;
		gchar* _tmp115_ = NULL;
		ConfigConfig* _tmp116_;
		GKeyFile* _tmp117_;
		gchar* _tmp118_;
		JsonBuilder* _tmp119_;
		gchar* _tmp120_ = NULL;
		ConfigConfig* _tmp121_;
		GKeyFile* _tmp122_;
		gchar* _tmp123_;
		JsonBuilder* _tmp124_;
		gchar* _tmp125_ = NULL;
		ConfigConfig* _tmp126_;
		GKeyFile* _tmp127_;
		gchar* _tmp128_;
		JsonBuilder* _tmp129_;
		gchar* _tmp130_ = NULL;
		ConfigConfig* _tmp131_;
		GKeyFile* _tmp132_;
		gchar* _tmp133_;
		JsonBuilder* _tmp134_;
		gchar* _tmp135_ = NULL;
		ConfigConfig* _tmp136_;
		GKeyFile* _tmp137_;
		gchar* _tmp138_;
		JsonBuilder* _tmp139_;
		JsonBuilder* _tmp140_;
		JsonBuilder* _tmp141_;
		JsonBuilder* _tmp142_;
		JsonBuilder* _tmp143_;
		JsonBuilder* _tmp144_;
		JsonBuilder* _tmp145_;
		JsonBuilder* _tmp146_;
		gchar* _tmp147_ = NULL;
		ConfigConfig* _tmp148_;
		GKeyFile* _tmp149_;
		gchar* _tmp150_;
		JsonBuilder* _tmp151_;
		gchar* _tmp152_ = NULL;
		ConfigConfig* _tmp153_;
		GKeyFile* _tmp154_;
		gchar* _tmp155_;
		JsonBuilder* _tmp156_;
		gchar* _tmp157_ = NULL;
		ConfigConfig* _tmp158_;
		GKeyFile* _tmp159_;
		gchar* _tmp160_;
		JsonBuilder* _tmp161_;
		gchar* _tmp162_ = NULL;
		ConfigConfig* _tmp163_;
		GKeyFile* _tmp164_;
		gchar* _tmp165_;
		JsonBuilder* _tmp166_;
		gchar* _tmp167_ = NULL;
		ConfigConfig* _tmp168_;
		GKeyFile* _tmp169_;
		gchar* _tmp170_;
		JsonBuilder* _tmp171_;
		JsonBuilder* _tmp172_;
		JsonBuilder* _tmp173_;
		JsonBuilder* _tmp174_;
		JsonBuilder* _tmp175_;
		JsonBuilder* _tmp176_;
		JsonBuilder* _tmp177_;
		_tmp1_ = builder;
		json_builder_begin_object (_tmp1_);
		_tmp2_ = builder;
		json_builder_set_member_name (_tmp2_, "shortcut");
		_tmp3_ = builder;
		json_builder_begin_array (_tmp3_);
		_tmp4_ = builder;
		json_builder_begin_object (_tmp4_);
		_tmp5_ = builder;
		json_builder_set_member_name (_tmp5_, "groupItems");
		_tmp6_ = builder;
		json_builder_begin_array (_tmp6_);
		_tmp8_ = self->config;
		_tmp9_ = _tmp8_->config_file;
		_tmp10_ = g_key_file_get_string (_tmp9_, "shortcut", "copy", &_inner_error0_);
		_tmp7_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp11_, _ ("Copy"), _tmp7_);
		_tmp13_ = self->config;
		_tmp14_ = _tmp13_->config_file;
		_tmp15_ = g_key_file_get_string (_tmp14_, "shortcut", "paste", &_inner_error0_);
		_tmp12_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp16_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp16_, _ ("Paste"), _tmp12_);
		_tmp18_ = self->config;
		_tmp19_ = _tmp18_->config_file;
		_tmp20_ = g_key_file_get_string (_tmp19_, "shortcut", "open", &_inner_error0_);
		_tmp17_ = _tmp20_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp21_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp21_, _ ("Open"), _tmp17_);
		_tmp23_ = self->config;
		_tmp24_ = _tmp23_->config_file;
		_tmp25_ = g_key_file_get_string (_tmp24_, "shortcut", "search", &_inner_error0_);
		_tmp22_ = _tmp25_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp26_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp26_, _ ("Search"), _tmp22_);
		_tmp28_ = self->config;
		_tmp29_ = _tmp28_->config_file;
		_tmp30_ = g_key_file_get_string (_tmp29_, "shortcut", "zoom_in", &_inner_error0_);
		_tmp27_ = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp31_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp31_, _ ("Zoom in"), _tmp27_);
		_tmp33_ = self->config;
		_tmp34_ = _tmp33_->config_file;
		_tmp35_ = g_key_file_get_string (_tmp34_, "shortcut", "zoom_out", &_inner_error0_);
		_tmp32_ = _tmp35_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp36_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp36_, _ ("Zoom out"), _tmp32_);
		_tmp38_ = self->config;
		_tmp39_ = _tmp38_->config_file;
		_tmp40_ = g_key_file_get_string (_tmp39_, "shortcut", "default_size", &_inner_error0_);
		_tmp37_ = _tmp40_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp41_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp41_, _ ("Default size"), _tmp37_);
		_tmp43_ = self->config;
		_tmp44_ = _tmp43_->config_file;
		_tmp45_ = g_key_file_get_string (_tmp44_, "shortcut", "select_all", &_inner_error0_);
		_tmp42_ = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp46_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp46_, _ ("Select all"), _tmp42_);
		_tmp48_ = self->config;
		_tmp49_ = _tmp48_->config_file;
		_tmp50_ = g_key_file_get_string (_tmp49_, "shortcut", "jump_to_next_command", &_inner_error0_);
		_tmp47_ = _tmp50_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp51_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp51_, _ ("Jump to next command"), _tmp47_);
		_tmp53_ = self->config;
		_tmp54_ = _tmp53_->config_file;
		_tmp55_ = g_key_file_get_string (_tmp54_, "shortcut", "jump_to_previous_command", &_inner_error0_);
		_tmp52_ = _tmp55_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp56_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp56_, _ ("Jump to previous command"), _tmp52_);
		_tmp57_ = builder;
		json_builder_end_array (_tmp57_);
		_tmp58_ = builder;
		json_builder_set_member_name (_tmp58_, "groupName");
		_tmp59_ = builder;
		json_builder_add_string_value (_tmp59_, _ ("Terminal"));
		_tmp60_ = builder;
		json_builder_end_object (_tmp60_);
		_tmp61_ = builder;
		json_builder_begin_object (_tmp61_);
		_tmp62_ = builder;
		json_builder_set_member_name (_tmp62_, "groupItems");
		_tmp63_ = builder;
		json_builder_begin_array (_tmp63_);
		_tmp64_ = self->config;
		_tmp65_ = _tmp64_->config_file;
		_tmp66_ = g_key_file_get_string (_tmp65_, "shortcut", "select_workspace", &_inner_error0_);
		select_workspace_key = _tmp66_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp67_ = self->config;
		_tmp68_ = _tmp67_->config_file;
		_tmp69_ = g_key_file_get_string (_tmp68_, "shortcut", "new_theme_terminal", &_inner_error0_);
		new_theme_terminal_key = _tmp69_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp71_ = self->config;
		_tmp72_ = _tmp71_->config_file;
		_tmp73_ = g_key_file_get_string (_tmp72_, "shortcut", "new_workspace", &_inner_error0_);
		_tmp70_ = _tmp73_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp74_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp74_, _ ("New workspace"), _tmp70_);
		_tmp76_ = self->config;
		_tmp77_ = _tmp76_->config_file;
		_tmp78_ = g_key_file_get_string (_tmp77_, "shortcut", "close_workspace", &_inner_error0_);
		_tmp75_ = _tmp78_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp79_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp79_, _ ("Close workspace"), _tmp75_);
		_tmp81_ = self->config;
		_tmp82_ = _tmp81_->config_file;
		_tmp83_ = g_key_file_get_string (_tmp82_, "shortcut", "next_workspace", &_inner_error0_);
		_tmp80_ = _tmp83_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp84_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp84_, _ ("Next workspace"), _tmp80_);
		_tmp86_ = self->config;
		_tmp87_ = _tmp86_->config_file;
		_tmp88_ = g_key_file_get_string (_tmp87_, "shortcut", "previous_workspace", &_inner_error0_);
		_tmp85_ = _tmp88_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp89_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp89_, _ ("Previous workspace"), _tmp85_);
		_tmp90_ = builder;
		_tmp91_ = select_workspace_key;
		_tmp92_ = select_workspace_key;
		_tmp93_ = g_strdup_printf ("%s + 1 ~ %s + 9", _tmp91_, _tmp92_);
		_tmp94_ = _tmp93_;
		widgets_config_window_insert_shortcut_key (self, _tmp90_, _ ("Select workspace"), _tmp94_);
		_g_free0 (_tmp94_);
		_tmp95_ = builder;
		_tmp96_ = new_theme_terminal_key;
		_tmp97_ = new_theme_terminal_key;
		_tmp98_ = g_strdup_printf ("%s + 1 ~ %s + 9", _tmp96_, _tmp97_);
		_tmp99_ = _tmp98_;
		widgets_config_window_insert_shortcut_key (self, _tmp95_, _ ("Open terminal with a new theme"), _tmp99_);
		_g_free0 (_tmp99_);
		_tmp101_ = self->config;
		_tmp102_ = _tmp101_->config_file;
		_tmp103_ = g_key_file_get_string (_tmp102_, "shortcut", "vertical_split", &_inner_error0_);
		_tmp100_ = _tmp103_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp104_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp104_, _ ("Vertical split"), _tmp100_);
		_tmp106_ = self->config;
		_tmp107_ = _tmp106_->config_file;
		_tmp108_ = g_key_file_get_string (_tmp107_, "shortcut", "horizontal_split", &_inner_error0_);
		_tmp105_ = _tmp108_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp109_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp109_, _ ("Horizontal split"), _tmp105_);
		_tmp111_ = self->config;
		_tmp112_ = _tmp111_->config_file;
		_tmp113_ = g_key_file_get_string (_tmp112_, "shortcut", "select_upper_window", &_inner_error0_);
		_tmp110_ = _tmp113_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp114_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp114_, _ ("Select upper window"), _tmp110_);
		_tmp116_ = self->config;
		_tmp117_ = _tmp116_->config_file;
		_tmp118_ = g_key_file_get_string (_tmp117_, "shortcut", "select_lower_window", &_inner_error0_);
		_tmp115_ = _tmp118_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp119_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp119_, _ ("Select lower window"), _tmp115_);
		_tmp121_ = self->config;
		_tmp122_ = _tmp121_->config_file;
		_tmp123_ = g_key_file_get_string (_tmp122_, "shortcut", "select_left_window", &_inner_error0_);
		_tmp120_ = _tmp123_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp124_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp124_, _ ("Select left window"), _tmp120_);
		_tmp126_ = self->config;
		_tmp127_ = _tmp126_->config_file;
		_tmp128_ = g_key_file_get_string (_tmp127_, "shortcut", "select_right_window", &_inner_error0_);
		_tmp125_ = _tmp128_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp129_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp129_, _ ("Select right window"), _tmp125_);
		_tmp131_ = self->config;
		_tmp132_ = _tmp131_->config_file;
		_tmp133_ = g_key_file_get_string (_tmp132_, "shortcut", "close_window", &_inner_error0_);
		_tmp130_ = _tmp133_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp134_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp134_, _ ("Close window"), _tmp130_);
		_tmp136_ = self->config;
		_tmp137_ = _tmp136_->config_file;
		_tmp138_ = g_key_file_get_string (_tmp137_, "shortcut", "close_other_windows", &_inner_error0_);
		_tmp135_ = _tmp138_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp130_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp139_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp139_, _ ("Close other windows"), _tmp135_);
		_tmp140_ = builder;
		json_builder_end_array (_tmp140_);
		_tmp141_ = builder;
		json_builder_set_member_name (_tmp141_, "groupName");
		_tmp142_ = builder;
		json_builder_add_string_value (_tmp142_, _ ("Workspace"));
		_tmp143_ = builder;
		json_builder_end_object (_tmp143_);
		_tmp144_ = builder;
		json_builder_begin_object (_tmp144_);
		_tmp145_ = builder;
		json_builder_set_member_name (_tmp145_, "groupItems");
		_tmp146_ = builder;
		json_builder_begin_array (_tmp146_);
		_tmp148_ = self->config;
		_tmp149_ = _tmp148_->config_file;
		_tmp150_ = g_key_file_get_string (_tmp149_, "shortcut", "rename_title", &_inner_error0_);
		_tmp147_ = _tmp150_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp135_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp151_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp151_, _ ("Rename title"), _tmp147_);
		_tmp153_ = self->config;
		_tmp154_ = _tmp153_->config_file;
		_tmp155_ = g_key_file_get_string (_tmp154_, "shortcut", "switch_fullscreen", &_inner_error0_);
		_tmp152_ = _tmp155_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp147_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp156_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp156_, _ ("Toggle fullscreen"), _tmp152_);
		_tmp158_ = self->config;
		_tmp159_ = _tmp158_->config_file;
		_tmp160_ = g_key_file_get_string (_tmp159_, "shortcut", "display_shortcuts", &_inner_error0_);
		_tmp157_ = _tmp160_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp152_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp161_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp161_, _ ("Display shortcuts"), _tmp157_);
		_tmp163_ = self->config;
		_tmp164_ = _tmp163_->config_file;
		_tmp165_ = g_key_file_get_string (_tmp164_, "shortcut", "custom_commands", &_inner_error0_);
		_tmp162_ = _tmp165_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp157_);
			_g_free0 (_tmp152_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp166_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp166_, _ ("Custom commands"), _tmp162_);
		_tmp168_ = self->config;
		_tmp169_ = _tmp168_->config_file;
		_tmp170_ = g_key_file_get_string (_tmp169_, "shortcut", "remote_management", &_inner_error0_);
		_tmp167_ = _tmp170_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp162_);
			_g_free0 (_tmp157_);
			_g_free0 (_tmp152_);
			_g_free0 (_tmp147_);
			_g_free0 (_tmp135_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp125_);
			_g_free0 (_tmp120_);
			_g_free0 (_tmp115_);
			_g_free0 (_tmp110_);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp80_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp70_);
			_g_free0 (new_theme_terminal_key);
			_g_free0 (select_workspace_key);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp47_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			goto __catch0_g_error;
		}
		_tmp171_ = builder;
		widgets_config_window_insert_shortcut_key (self, _tmp171_, _ ("Remote management"), _tmp167_);
		_tmp172_ = builder;
		json_builder_end_array (_tmp172_);
		_tmp173_ = builder;
		json_builder_set_member_name (_tmp173_, "groupName");
		_tmp174_ = builder;
		json_builder_add_string_value (_tmp174_, _ ("Advanced"));
		_tmp175_ = builder;
		json_builder_end_object (_tmp175_);
		_tmp176_ = builder;
		json_builder_end_array (_tmp176_);
		_tmp177_ = builder;
		json_builder_end_object (_tmp177_);
		_g_free0 (_tmp167_);
		_g_free0 (_tmp162_);
		_g_free0 (_tmp157_);
		_g_free0 (_tmp152_);
		_g_free0 (_tmp147_);
		_g_free0 (_tmp135_);
		_g_free0 (_tmp130_);
		_g_free0 (_tmp125_);
		_g_free0 (_tmp120_);
		_g_free0 (_tmp115_);
		_g_free0 (_tmp110_);
		_g_free0 (_tmp105_);
		_g_free0 (_tmp100_);
		_g_free0 (_tmp85_);
		_g_free0 (_tmp80_);
		_g_free0 (_tmp75_);
		_g_free0 (_tmp70_);
		_g_free0 (new_theme_terminal_key);
		_g_free0 (select_workspace_key);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp42_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp7_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp178_;
		const gchar* _tmp179_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp178_ = e;
		_tmp179_ = _tmp178_->message;
		g_print ("Main get_shortcut_data: %s\n", _tmp179_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp180_ = json_generator_new ();
	generator = _tmp180_;
	_tmp181_ = builder;
	_tmp182_ = json_builder_get_root (_tmp181_);
	root = _tmp182_;
	json_generator_set_root (generator, root);
	_tmp183_ = json_generator_to_data (generator, NULL);
	result = _tmp183_;
	__vala_JsonNode_free0 (root);
	_g_object_unref0 (generator);
	_g_object_unref0 (builder);
	return result;
}

void
widgets_config_window_insert_shortcut_key (WidgetsConfigWindow* self,
                                           JsonBuilder* builder,
                                           const gchar* name,
                                           const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (key != NULL);
	json_builder_begin_object (builder);
	json_builder_set_member_name (builder, "name");
	json_builder_add_string_value (builder, name);
	json_builder_set_member_name (builder, "value");
	json_builder_add_string_value (builder, key);
	json_builder_end_object (builder);
}

static void
___lambda85_ (WidgetsConfigWindow* self,
              WidgetsConfirmDialog* d)
{
	g_return_if_fail (d != NULL);
	widgets_config_window_window_save_before_quit (self);
	widgets_config_window_fast_quit (self);
}

static void
____lambda85__widgets_confirm_dialog_confirm (WidgetsConfirmDialog* _sender,
                                              gpointer self)
{
	___lambda85_ ((WidgetsConfigWindow*) self, _sender);
}

void
widgets_config_window_quit (WidgetsConfigWindow* self)
{
	WidgetsWorkspaceManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->workspace_manager;
	if (widgets_workspace_manager_has_active_term (_tmp0_)) {
		WidgetsConfirmDialog* dialog = NULL;
		WidgetsConfirmDialog* _tmp1_;
		WidgetsConfirmDialog* _tmp2_;
		_tmp1_ = widgets_create_running_confirm_dialog (self);
		dialog = _tmp1_;
		_tmp2_ = dialog;
		g_signal_connect_object (_tmp2_, "confirm", (GCallback) ____lambda85__widgets_confirm_dialog_confirm, self, 0);
		_g_object_unref0 (dialog);
	} else {
		widgets_config_window_window_save_before_quit (self);
		widgets_config_window_fast_quit (self);
	}
}

static void
widgets_config_window_fast_quit (WidgetsConfigWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	gtk_main_quit ();
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
widgets_config_window_on_key_press (WidgetsConfigWindow* self,
                                    GtkWidget* widget,
                                    GdkEventKey* key_event)
{
	gboolean _tmp338_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (key_event != NULL, FALSE);
	{
		gchar* keyname = NULL;
		gchar* _tmp0_;
		gchar* select_workspace_key = NULL;
		ConfigConfig* _tmp1_;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gchar** select_workspace_shortcuts = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar** _tmp23_;
		gint select_workspace_shortcuts_length1;
		gint _select_workspace_shortcuts_size_;
		gchar* new_theme_terminal_key = NULL;
		ConfigConfig* _tmp24_;
		GKeyFile* _tmp25_;
		gchar* _tmp26_;
		gchar** new_terminal_shortcuts = NULL;
		const gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar* _tmp45_;
		gchar** _tmp46_;
		gint new_terminal_shortcuts_length1;
		gint _new_terminal_shortcuts_size_;
		const gchar* _tmp47_;
		gchar* search_key = NULL;
		ConfigConfig* _tmp48_;
		GKeyFile* _tmp49_;
		gchar* _tmp50_;
		gboolean _tmp52_ = FALSE;
		const gchar* _tmp53_;
		gchar* close_workspace_key = NULL;
		ConfigConfig* _tmp66_;
		GKeyFile* _tmp67_;
		gchar* _tmp68_;
		gboolean _tmp70_ = FALSE;
		const gchar* _tmp71_;
		gchar* next_workspace_key = NULL;
		ConfigConfig* _tmp76_;
		GKeyFile* _tmp77_;
		gchar* _tmp78_;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp81_;
		gchar* previous_workspace_key = NULL;
		ConfigConfig* _tmp86_;
		GKeyFile* _tmp87_;
		gchar* _tmp88_;
		gboolean _tmp90_ = FALSE;
		const gchar* _tmp91_;
		gchar* resize_workspace_left_key = NULL;
		ConfigConfig* _tmp96_;
		GKeyFile* _tmp97_;
		gchar* _tmp98_;
		gboolean _tmp100_ = FALSE;
		const gchar* _tmp101_;
		gchar* resize_workspace_right_key = NULL;
		ConfigConfig* _tmp106_;
		GKeyFile* _tmp107_;
		gchar* _tmp108_;
		gboolean _tmp110_ = FALSE;
		const gchar* _tmp111_;
		gchar* resize_workspace_up_key = NULL;
		ConfigConfig* _tmp116_;
		GKeyFile* _tmp117_;
		gchar* _tmp118_;
		gboolean _tmp120_ = FALSE;
		const gchar* _tmp121_;
		gchar* resize_workspace_down_key = NULL;
		ConfigConfig* _tmp126_;
		GKeyFile* _tmp127_;
		gchar* _tmp128_;
		gboolean _tmp130_ = FALSE;
		const gchar* _tmp131_;
		gchar* split_vertically_key = NULL;
		ConfigConfig* _tmp136_;
		GKeyFile* _tmp137_;
		gchar* _tmp138_;
		gboolean _tmp140_ = FALSE;
		const gchar* _tmp141_;
		gchar* split_horizontally_key = NULL;
		ConfigConfig* _tmp148_;
		GKeyFile* _tmp149_;
		gchar* _tmp150_;
		gboolean _tmp152_ = FALSE;
		const gchar* _tmp153_;
		gchar* select_up_window_key = NULL;
		ConfigConfig* _tmp160_;
		GKeyFile* _tmp161_;
		gchar* _tmp162_;
		gboolean _tmp164_ = FALSE;
		const gchar* _tmp165_;
		gchar* select_down_window_key = NULL;
		ConfigConfig* _tmp172_;
		GKeyFile* _tmp173_;
		gchar* _tmp174_;
		gboolean _tmp176_ = FALSE;
		const gchar* _tmp177_;
		gchar* select_left_window_key = NULL;
		ConfigConfig* _tmp184_;
		GKeyFile* _tmp185_;
		gchar* _tmp186_;
		gboolean _tmp188_ = FALSE;
		const gchar* _tmp189_;
		gchar* select_right_window_key = NULL;
		ConfigConfig* _tmp196_;
		GKeyFile* _tmp197_;
		gchar* _tmp198_;
		gboolean _tmp200_ = FALSE;
		const gchar* _tmp201_;
		gchar* close_window_key = NULL;
		ConfigConfig* _tmp208_;
		GKeyFile* _tmp209_;
		gchar* _tmp210_;
		gboolean _tmp212_ = FALSE;
		const gchar* _tmp213_;
		gchar* close_other_windows_key = NULL;
		ConfigConfig* _tmp220_;
		GKeyFile* _tmp221_;
		gchar* _tmp222_;
		gboolean _tmp224_ = FALSE;
		const gchar* _tmp225_;
		gchar* toggle_fullscreen_key = NULL;
		ConfigConfig* _tmp232_;
		GKeyFile* _tmp233_;
		gchar* _tmp234_;
		gboolean _tmp236_ = FALSE;
		const gchar* _tmp237_;
		gchar* rename_title_key = NULL;
		ConfigConfig* _tmp240_;
		GKeyFile* _tmp241_;
		gchar* _tmp242_;
		gboolean _tmp244_ = FALSE;
		const gchar* _tmp245_;
		gchar* show_command_panel_key = NULL;
		ConfigConfig* _tmp275_;
		GKeyFile* _tmp276_;
		gchar* _tmp277_;
		gboolean _tmp279_ = FALSE;
		const gchar* _tmp280_;
		gchar* show_remote_panel_key = NULL;
		ConfigConfig* _tmp287_;
		GKeyFile* _tmp288_;
		gchar* _tmp289_;
		gboolean _tmp291_ = FALSE;
		const gchar* _tmp292_;
		gchar* select_all_key = NULL;
		ConfigConfig* _tmp299_;
		GKeyFile* _tmp300_;
		gchar* _tmp301_;
		gboolean _tmp303_ = FALSE;
		const gchar* _tmp304_;
		const gchar* _tmp311_;
		gchar** _tmp312_;
		gint _tmp312__length1;
		const gchar* _tmp316_;
		gchar** _tmp317_;
		gint _tmp317__length1;
		_tmp0_ = keymap_get_keyevent_name (key_event);
		keyname = _tmp0_;
		_tmp1_ = self->config;
		_tmp2_ = _tmp1_->config_file;
		_tmp3_ = g_key_file_get_string (_tmp2_, "shortcut", "select_workspace", &_inner_error0_);
		select_workspace_key = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_tmp5_ = select_workspace_key;
		_tmp6_ = g_strdup_printf ("%s + 1", _tmp5_);
		_tmp7_ = select_workspace_key;
		_tmp8_ = g_strdup_printf ("%s + 2", _tmp7_);
		_tmp9_ = select_workspace_key;
		_tmp10_ = g_strdup_printf ("%s + 3", _tmp9_);
		_tmp11_ = select_workspace_key;
		_tmp12_ = g_strdup_printf ("%s + 4", _tmp11_);
		_tmp13_ = select_workspace_key;
		_tmp14_ = g_strdup_printf ("%s + 5", _tmp13_);
		_tmp15_ = select_workspace_key;
		_tmp16_ = g_strdup_printf ("%s + 6", _tmp15_);
		_tmp17_ = select_workspace_key;
		_tmp18_ = g_strdup_printf ("%s + 7", _tmp17_);
		_tmp19_ = select_workspace_key;
		_tmp20_ = g_strdup_printf ("%s + 8", _tmp19_);
		_tmp21_ = select_workspace_key;
		_tmp22_ = g_strdup_printf ("%s + 9", _tmp21_);
		_tmp23_ = g_new0 (gchar*, 9 + 1);
		_tmp23_[0] = _tmp6_;
		_tmp23_[1] = _tmp8_;
		_tmp23_[2] = _tmp10_;
		_tmp23_[3] = _tmp12_;
		_tmp23_[4] = _tmp14_;
		_tmp23_[5] = _tmp16_;
		_tmp23_[6] = _tmp18_;
		_tmp23_[7] = _tmp20_;
		_tmp23_[8] = _tmp22_;
		select_workspace_shortcuts = _tmp23_;
		select_workspace_shortcuts_length1 = 9;
		_select_workspace_shortcuts_size_ = select_workspace_shortcuts_length1;
		_tmp24_ = self->config;
		_tmp25_ = _tmp24_->config_file;
		_tmp26_ = g_key_file_get_string (_tmp25_, "shortcut", "new_theme_terminal", &_inner_error0_);
		new_theme_terminal_key = _tmp26_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp27_ = FALSE;
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp27_;
		}
		_tmp28_ = new_theme_terminal_key;
		_tmp29_ = g_strdup_printf ("%s + 1", _tmp28_);
		_tmp30_ = new_theme_terminal_key;
		_tmp31_ = g_strdup_printf ("%s + 2", _tmp30_);
		_tmp32_ = new_theme_terminal_key;
		_tmp33_ = g_strdup_printf ("%s + 3", _tmp32_);
		_tmp34_ = new_theme_terminal_key;
		_tmp35_ = g_strdup_printf ("%s + 4", _tmp34_);
		_tmp36_ = new_theme_terminal_key;
		_tmp37_ = g_strdup_printf ("%s + 5", _tmp36_);
		_tmp38_ = new_theme_terminal_key;
		_tmp39_ = g_strdup_printf ("%s + 6", _tmp38_);
		_tmp40_ = new_theme_terminal_key;
		_tmp41_ = g_strdup_printf ("%s + 7", _tmp40_);
		_tmp42_ = new_theme_terminal_key;
		_tmp43_ = g_strdup_printf ("%s + 8", _tmp42_);
		_tmp44_ = new_theme_terminal_key;
		_tmp45_ = g_strdup_printf ("%s + 9", _tmp44_);
		_tmp46_ = g_new0 (gchar*, 9 + 1);
		_tmp46_[0] = _tmp29_;
		_tmp46_[1] = _tmp31_;
		_tmp46_[2] = _tmp33_;
		_tmp46_[3] = _tmp35_;
		_tmp46_[4] = _tmp37_;
		_tmp46_[5] = _tmp39_;
		_tmp46_[6] = _tmp41_;
		_tmp46_[7] = _tmp43_;
		_tmp46_[8] = _tmp45_;
		new_terminal_shortcuts = _tmp46_;
		new_terminal_shortcuts_length1 = 9;
		_new_terminal_shortcuts_size_ = new_terminal_shortcuts_length1;
		_tmp47_ = keyname;
		if (g_strcmp0 (_tmp47_, "F1") == 0) {
			utils_show_manual ();
			result = TRUE;
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp48_ = self->config;
		_tmp49_ = _tmp48_->config_file;
		_tmp50_ = g_key_file_get_string (_tmp49_, "shortcut", "search", &_inner_error0_);
		search_key = _tmp50_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp51_ = FALSE;
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp51_;
		}
		_tmp53_ = search_key;
		if (g_strcmp0 (_tmp53_, "") != 0) {
			const gchar* _tmp54_;
			const gchar* _tmp55_;
			_tmp54_ = keyname;
			_tmp55_ = search_key;
			_tmp52_ = g_strcmp0 (_tmp54_, _tmp55_) == 0;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			WidgetsTerm* focus_term = NULL;
			WidgetsWorkspaceManager* _tmp56_;
			WidgetsWorkspace* _tmp57_;
			WidgetsWorkspaceManager* _tmp58_;
			WidgetsWorkspace* _tmp59_;
			WidgetsTerm* _tmp60_;
			WidgetsWorkspaceManager* _tmp61_;
			WidgetsWorkspace* _tmp62_;
			WidgetsTerm* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp56_ = self->workspace_manager;
			_tmp57_ = _tmp56_->focus_workspace;
			_tmp58_ = self->workspace_manager;
			_tmp59_ = _tmp58_->focus_workspace;
			_tmp60_ = widgets_workspace_get_focus_term (_tmp57_, (GtkContainer*) _tmp59_);
			focus_term = _tmp60_;
			_tmp61_ = self->workspace_manager;
			_tmp62_ = _tmp61_->focus_workspace;
			_tmp63_ = focus_term;
			_tmp64_ = widgets_term_get_selection_text (_tmp63_);
			_tmp65_ = _tmp64_;
			widgets_workspace_search (_tmp62_, _tmp65_);
			_g_free0 (_tmp65_);
			result = TRUE;
			_g_object_unref0 (focus_term);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp66_ = self->config;
		_tmp67_ = _tmp66_->config_file;
		_tmp68_ = g_key_file_get_string (_tmp67_, "shortcut", "close_workspace", &_inner_error0_);
		close_workspace_key = _tmp68_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp69_ = FALSE;
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp69_;
		}
		_tmp71_ = close_workspace_key;
		if (g_strcmp0 (_tmp71_, "") != 0) {
			const gchar* _tmp72_;
			const gchar* _tmp73_;
			_tmp72_ = keyname;
			_tmp73_ = close_workspace_key;
			_tmp70_ = g_strcmp0 (_tmp72_, _tmp73_) == 0;
		} else {
			_tmp70_ = FALSE;
		}
		if (_tmp70_) {
			WidgetsWorkspaceManager* _tmp74_;
			WidgetsTabbar* _tmp75_;
			_tmp74_ = self->workspace_manager;
			_tmp75_ = _tmp74_->tabbar;
			widgets_tabbar_close_current_tab (_tmp75_);
			result = TRUE;
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp76_ = self->config;
		_tmp77_ = _tmp76_->config_file;
		_tmp78_ = g_key_file_get_string (_tmp77_, "shortcut", "next_workspace", &_inner_error0_);
		next_workspace_key = _tmp78_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp79_ = FALSE;
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp79_;
		}
		_tmp81_ = next_workspace_key;
		if (g_strcmp0 (_tmp81_, "") != 0) {
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			_tmp82_ = keyname;
			_tmp83_ = next_workspace_key;
			_tmp80_ = g_strcmp0 (_tmp82_, _tmp83_) == 0;
		} else {
			_tmp80_ = FALSE;
		}
		if (_tmp80_) {
			WidgetsWorkspaceManager* _tmp84_;
			WidgetsTabbar* _tmp85_;
			_tmp84_ = self->workspace_manager;
			_tmp85_ = _tmp84_->tabbar;
			widgets_tabbar_select_next_tab (_tmp85_);
			result = TRUE;
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp86_ = self->config;
		_tmp87_ = _tmp86_->config_file;
		_tmp88_ = g_key_file_get_string (_tmp87_, "shortcut", "previous_workspace", &_inner_error0_);
		previous_workspace_key = _tmp88_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp89_ = FALSE;
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp89_;
		}
		_tmp91_ = previous_workspace_key;
		if (g_strcmp0 (_tmp91_, "") != 0) {
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			_tmp92_ = keyname;
			_tmp93_ = previous_workspace_key;
			_tmp90_ = g_strcmp0 (_tmp92_, _tmp93_) == 0;
		} else {
			_tmp90_ = FALSE;
		}
		if (_tmp90_) {
			WidgetsWorkspaceManager* _tmp94_;
			WidgetsTabbar* _tmp95_;
			_tmp94_ = self->workspace_manager;
			_tmp95_ = _tmp94_->tabbar;
			widgets_tabbar_select_previous_tab (_tmp95_);
			result = TRUE;
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp96_ = self->config;
		_tmp97_ = _tmp96_->config_file;
		_tmp98_ = g_key_file_get_string (_tmp97_, "shortcut", "resize_workspace_left", &_inner_error0_);
		resize_workspace_left_key = _tmp98_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp99_ = FALSE;
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp99_;
		}
		_tmp101_ = resize_workspace_left_key;
		if (g_strcmp0 (_tmp101_, "") != 0) {
			const gchar* _tmp102_;
			const gchar* _tmp103_;
			_tmp102_ = keyname;
			_tmp103_ = resize_workspace_left_key;
			_tmp100_ = g_strcmp0 (_tmp102_, _tmp103_) == 0;
		} else {
			_tmp100_ = FALSE;
		}
		if (_tmp100_) {
			WidgetsWorkspaceManager* _tmp104_;
			WidgetsWorkspace* _tmp105_;
			_tmp104_ = self->workspace_manager;
			_tmp105_ = _tmp104_->focus_workspace;
			widgets_workspace_resize_workspace_left (_tmp105_);
			result = TRUE;
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp106_ = self->config;
		_tmp107_ = _tmp106_->config_file;
		_tmp108_ = g_key_file_get_string (_tmp107_, "shortcut", "resize_workspace_right", &_inner_error0_);
		resize_workspace_right_key = _tmp108_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp109_ = FALSE;
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp109_;
		}
		_tmp111_ = resize_workspace_right_key;
		if (g_strcmp0 (_tmp111_, "") != 0) {
			const gchar* _tmp112_;
			const gchar* _tmp113_;
			_tmp112_ = keyname;
			_tmp113_ = resize_workspace_right_key;
			_tmp110_ = g_strcmp0 (_tmp112_, _tmp113_) == 0;
		} else {
			_tmp110_ = FALSE;
		}
		if (_tmp110_) {
			WidgetsWorkspaceManager* _tmp114_;
			WidgetsWorkspace* _tmp115_;
			_tmp114_ = self->workspace_manager;
			_tmp115_ = _tmp114_->focus_workspace;
			widgets_workspace_resize_workspace_right (_tmp115_);
			result = TRUE;
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp116_ = self->config;
		_tmp117_ = _tmp116_->config_file;
		_tmp118_ = g_key_file_get_string (_tmp117_, "shortcut", "resize_workspace_up", &_inner_error0_);
		resize_workspace_up_key = _tmp118_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp119_ = FALSE;
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp119_;
		}
		_tmp121_ = resize_workspace_up_key;
		if (g_strcmp0 (_tmp121_, "") != 0) {
			const gchar* _tmp122_;
			const gchar* _tmp123_;
			_tmp122_ = keyname;
			_tmp123_ = resize_workspace_up_key;
			_tmp120_ = g_strcmp0 (_tmp122_, _tmp123_) == 0;
		} else {
			_tmp120_ = FALSE;
		}
		if (_tmp120_) {
			WidgetsWorkspaceManager* _tmp124_;
			WidgetsWorkspace* _tmp125_;
			_tmp124_ = self->workspace_manager;
			_tmp125_ = _tmp124_->focus_workspace;
			widgets_workspace_resize_workspace_up (_tmp125_);
			result = TRUE;
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp126_ = self->config;
		_tmp127_ = _tmp126_->config_file;
		_tmp128_ = g_key_file_get_string (_tmp127_, "shortcut", "resize_workspace_down", &_inner_error0_);
		resize_workspace_down_key = _tmp128_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp129_ = FALSE;
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp129_;
		}
		_tmp131_ = resize_workspace_down_key;
		if (g_strcmp0 (_tmp131_, "") != 0) {
			const gchar* _tmp132_;
			const gchar* _tmp133_;
			_tmp132_ = keyname;
			_tmp133_ = resize_workspace_down_key;
			_tmp130_ = g_strcmp0 (_tmp132_, _tmp133_) == 0;
		} else {
			_tmp130_ = FALSE;
		}
		if (_tmp130_) {
			WidgetsWorkspaceManager* _tmp134_;
			WidgetsWorkspace* _tmp135_;
			_tmp134_ = self->workspace_manager;
			_tmp135_ = _tmp134_->focus_workspace;
			widgets_workspace_resize_workspace_down (_tmp135_);
			result = TRUE;
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp136_ = self->config;
		_tmp137_ = _tmp136_->config_file;
		_tmp138_ = g_key_file_get_string (_tmp137_, "shortcut", "vertical_split", &_inner_error0_);
		split_vertically_key = _tmp138_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp139_ = FALSE;
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp139_;
		}
		_tmp141_ = split_vertically_key;
		if (g_strcmp0 (_tmp141_, "") != 0) {
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp142_ = keyname;
			_tmp143_ = split_vertically_key;
			_tmp140_ = g_strcmp0 (_tmp142_, _tmp143_) == 0;
		} else {
			_tmp140_ = FALSE;
		}
		if (_tmp140_) {
			WidgetsWorkspaceManager* _tmp144_;
			WidgetsWorkspace* _tmp145_;
			WidgetsWorkspaceManager* _tmp146_;
			WidgetsWorkspace* _tmp147_;
			_tmp144_ = self->workspace_manager;
			_tmp145_ = _tmp144_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp145_);
			_tmp146_ = self->workspace_manager;
			_tmp147_ = _tmp146_->focus_workspace;
			widgets_workspace_split_vertical (_tmp147_);
			result = TRUE;
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp148_ = self->config;
		_tmp149_ = _tmp148_->config_file;
		_tmp150_ = g_key_file_get_string (_tmp149_, "shortcut", "horizontal_split", &_inner_error0_);
		split_horizontally_key = _tmp150_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp151_ = FALSE;
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp151_;
		}
		_tmp153_ = split_horizontally_key;
		if (g_strcmp0 (_tmp153_, "") != 0) {
			const gchar* _tmp154_;
			const gchar* _tmp155_;
			_tmp154_ = keyname;
			_tmp155_ = split_horizontally_key;
			_tmp152_ = g_strcmp0 (_tmp154_, _tmp155_) == 0;
		} else {
			_tmp152_ = FALSE;
		}
		if (_tmp152_) {
			WidgetsWorkspaceManager* _tmp156_;
			WidgetsWorkspace* _tmp157_;
			WidgetsWorkspaceManager* _tmp158_;
			WidgetsWorkspace* _tmp159_;
			_tmp156_ = self->workspace_manager;
			_tmp157_ = _tmp156_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp157_);
			_tmp158_ = self->workspace_manager;
			_tmp159_ = _tmp158_->focus_workspace;
			widgets_workspace_split_horizontal (_tmp159_);
			result = TRUE;
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp160_ = self->config;
		_tmp161_ = _tmp160_->config_file;
		_tmp162_ = g_key_file_get_string (_tmp161_, "shortcut", "select_upper_window", &_inner_error0_);
		select_up_window_key = _tmp162_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp163_ = FALSE;
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp163_;
		}
		_tmp165_ = select_up_window_key;
		if (g_strcmp0 (_tmp165_, "") != 0) {
			const gchar* _tmp166_;
			const gchar* _tmp167_;
			_tmp166_ = keyname;
			_tmp167_ = select_up_window_key;
			_tmp164_ = g_strcmp0 (_tmp166_, _tmp167_) == 0;
		} else {
			_tmp164_ = FALSE;
		}
		if (_tmp164_) {
			WidgetsWorkspaceManager* _tmp168_;
			WidgetsWorkspace* _tmp169_;
			WidgetsWorkspaceManager* _tmp170_;
			WidgetsWorkspace* _tmp171_;
			_tmp168_ = self->workspace_manager;
			_tmp169_ = _tmp168_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp169_);
			_tmp170_ = self->workspace_manager;
			_tmp171_ = _tmp170_->focus_workspace;
			widgets_workspace_select_up_window (_tmp171_);
			result = TRUE;
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp172_ = self->config;
		_tmp173_ = _tmp172_->config_file;
		_tmp174_ = g_key_file_get_string (_tmp173_, "shortcut", "select_lower_window", &_inner_error0_);
		select_down_window_key = _tmp174_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp175_ = FALSE;
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp175_;
		}
		_tmp177_ = select_down_window_key;
		if (g_strcmp0 (_tmp177_, "") != 0) {
			const gchar* _tmp178_;
			const gchar* _tmp179_;
			_tmp178_ = keyname;
			_tmp179_ = select_down_window_key;
			_tmp176_ = g_strcmp0 (_tmp178_, _tmp179_) == 0;
		} else {
			_tmp176_ = FALSE;
		}
		if (_tmp176_) {
			WidgetsWorkspaceManager* _tmp180_;
			WidgetsWorkspace* _tmp181_;
			WidgetsWorkspaceManager* _tmp182_;
			WidgetsWorkspace* _tmp183_;
			_tmp180_ = self->workspace_manager;
			_tmp181_ = _tmp180_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp181_);
			_tmp182_ = self->workspace_manager;
			_tmp183_ = _tmp182_->focus_workspace;
			widgets_workspace_select_down_window (_tmp183_);
			result = TRUE;
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp184_ = self->config;
		_tmp185_ = _tmp184_->config_file;
		_tmp186_ = g_key_file_get_string (_tmp185_, "shortcut", "select_left_window", &_inner_error0_);
		select_left_window_key = _tmp186_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp187_ = FALSE;
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp187_;
		}
		_tmp189_ = select_left_window_key;
		if (g_strcmp0 (_tmp189_, "") != 0) {
			const gchar* _tmp190_;
			const gchar* _tmp191_;
			_tmp190_ = keyname;
			_tmp191_ = select_left_window_key;
			_tmp188_ = g_strcmp0 (_tmp190_, _tmp191_) == 0;
		} else {
			_tmp188_ = FALSE;
		}
		if (_tmp188_) {
			WidgetsWorkspaceManager* _tmp192_;
			WidgetsWorkspace* _tmp193_;
			WidgetsWorkspaceManager* _tmp194_;
			WidgetsWorkspace* _tmp195_;
			_tmp192_ = self->workspace_manager;
			_tmp193_ = _tmp192_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp193_);
			_tmp194_ = self->workspace_manager;
			_tmp195_ = _tmp194_->focus_workspace;
			widgets_workspace_select_left_window (_tmp195_);
			result = TRUE;
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp196_ = self->config;
		_tmp197_ = _tmp196_->config_file;
		_tmp198_ = g_key_file_get_string (_tmp197_, "shortcut", "select_right_window", &_inner_error0_);
		select_right_window_key = _tmp198_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp199_ = FALSE;
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp199_;
		}
		_tmp201_ = select_right_window_key;
		if (g_strcmp0 (_tmp201_, "") != 0) {
			const gchar* _tmp202_;
			const gchar* _tmp203_;
			_tmp202_ = keyname;
			_tmp203_ = select_right_window_key;
			_tmp200_ = g_strcmp0 (_tmp202_, _tmp203_) == 0;
		} else {
			_tmp200_ = FALSE;
		}
		if (_tmp200_) {
			WidgetsWorkspaceManager* _tmp204_;
			WidgetsWorkspace* _tmp205_;
			WidgetsWorkspaceManager* _tmp206_;
			WidgetsWorkspace* _tmp207_;
			_tmp204_ = self->workspace_manager;
			_tmp205_ = _tmp204_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp205_);
			_tmp206_ = self->workspace_manager;
			_tmp207_ = _tmp206_->focus_workspace;
			widgets_workspace_select_right_window (_tmp207_);
			result = TRUE;
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp208_ = self->config;
		_tmp209_ = _tmp208_->config_file;
		_tmp210_ = g_key_file_get_string (_tmp209_, "shortcut", "close_window", &_inner_error0_);
		close_window_key = _tmp210_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp211_ = FALSE;
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp211_;
		}
		_tmp213_ = close_window_key;
		if (g_strcmp0 (_tmp213_, "") != 0) {
			const gchar* _tmp214_;
			const gchar* _tmp215_;
			_tmp214_ = keyname;
			_tmp215_ = close_window_key;
			_tmp212_ = g_strcmp0 (_tmp214_, _tmp215_) == 0;
		} else {
			_tmp212_ = FALSE;
		}
		if (_tmp212_) {
			WidgetsWorkspaceManager* _tmp216_;
			WidgetsWorkspace* _tmp217_;
			WidgetsWorkspaceManager* _tmp218_;
			WidgetsWorkspace* _tmp219_;
			_tmp216_ = self->workspace_manager;
			_tmp217_ = _tmp216_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp217_);
			_tmp218_ = self->workspace_manager;
			_tmp219_ = _tmp218_->focus_workspace;
			widgets_workspace_close_focus_term (_tmp219_);
			result = TRUE;
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp220_ = self->config;
		_tmp221_ = _tmp220_->config_file;
		_tmp222_ = g_key_file_get_string (_tmp221_, "shortcut", "close_other_windows", &_inner_error0_);
		close_other_windows_key = _tmp222_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp223_ = FALSE;
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp223_;
		}
		_tmp225_ = close_other_windows_key;
		if (g_strcmp0 (_tmp225_, "") != 0) {
			const gchar* _tmp226_;
			const gchar* _tmp227_;
			_tmp226_ = keyname;
			_tmp227_ = close_other_windows_key;
			_tmp224_ = g_strcmp0 (_tmp226_, _tmp227_) == 0;
		} else {
			_tmp224_ = FALSE;
		}
		if (_tmp224_) {
			WidgetsWorkspaceManager* _tmp228_;
			WidgetsWorkspace* _tmp229_;
			WidgetsWorkspaceManager* _tmp230_;
			WidgetsWorkspace* _tmp231_;
			_tmp228_ = self->workspace_manager;
			_tmp229_ = _tmp228_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp229_);
			_tmp230_ = self->workspace_manager;
			_tmp231_ = _tmp230_->focus_workspace;
			widgets_workspace_close_other_terms (_tmp231_);
			result = TRUE;
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp232_ = self->config;
		_tmp233_ = _tmp232_->config_file;
		_tmp234_ = g_key_file_get_string (_tmp233_, "shortcut", "switch_fullscreen", &_inner_error0_);
		toggle_fullscreen_key = _tmp234_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp235_ = FALSE;
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp235_;
		}
		_tmp237_ = toggle_fullscreen_key;
		if (g_strcmp0 (_tmp237_, "") != 0) {
			const gchar* _tmp238_;
			const gchar* _tmp239_;
			_tmp238_ = keyname;
			_tmp239_ = toggle_fullscreen_key;
			_tmp236_ = g_strcmp0 (_tmp238_, _tmp239_) == 0;
		} else {
			_tmp236_ = FALSE;
		}
		if (_tmp236_) {
			if (!self->quake_mode) {
				widgets_config_window_toggle_fullscreen (self);
			}
			result = TRUE;
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp240_ = self->config;
		_tmp241_ = _tmp240_->config_file;
		_tmp242_ = g_key_file_get_string (_tmp241_, "shortcut", "rename_title", &_inner_error0_);
		rename_title_key = _tmp242_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp243_ = FALSE;
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp243_;
		}
		_tmp245_ = rename_title_key;
		if (g_strcmp0 (_tmp245_, "") != 0) {
			const gchar* _tmp246_;
			const gchar* _tmp247_;
			_tmp246_ = keyname;
			_tmp247_ = rename_title_key;
			_tmp244_ = g_strcmp0 (_tmp246_, _tmp247_) == 0;
		} else {
			_tmp244_ = FALSE;
		}
		if (_tmp244_) {
			WidgetsTerm* focus_term = NULL;
			WidgetsWorkspaceManager* _tmp248_;
			WidgetsWorkspace* _tmp249_;
			WidgetsWorkspaceManager* _tmp250_;
			WidgetsWorkspace* _tmp251_;
			WidgetsTerm* _tmp252_;
			WidgetsTerm* _tmp253_;
			_tmp248_ = self->workspace_manager;
			_tmp249_ = _tmp248_->focus_workspace;
			_tmp250_ = self->workspace_manager;
			_tmp251_ = _tmp250_->focus_workspace;
			_tmp252_ = widgets_workspace_get_focus_term (_tmp249_, (GtkContainer*) _tmp251_);
			focus_term = _tmp252_;
			_tmp253_ = focus_term;
			widgets_term_rename_title (_tmp253_);
			result = TRUE;
			_g_object_unref0 (focus_term);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		if (utils_is_command_exist ("deepin-shortcut-viewer")) {
			gchar* show_helper_window_key = NULL;
			ConfigConfig* _tmp254_;
			GKeyFile* _tmp255_;
			gchar* _tmp256_;
			gboolean _tmp258_ = FALSE;
			const gchar* _tmp259_;
			_tmp254_ = self->config;
			_tmp255_ = _tmp254_->config_file;
			_tmp256_ = g_key_file_get_string (_tmp255_, "shortcut", "display_shortcuts", &_inner_error0_);
			show_helper_window_key = _tmp256_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp257_ = FALSE;
				_g_free0 (rename_title_key);
				_g_free0 (toggle_fullscreen_key);
				_g_free0 (close_other_windows_key);
				_g_free0 (close_window_key);
				_g_free0 (select_right_window_key);
				_g_free0 (select_left_window_key);
				_g_free0 (select_down_window_key);
				_g_free0 (select_up_window_key);
				_g_free0 (split_horizontally_key);
				_g_free0 (split_vertically_key);
				_g_free0 (resize_workspace_down_key);
				_g_free0 (resize_workspace_up_key);
				_g_free0 (resize_workspace_right_key);
				_g_free0 (resize_workspace_left_key);
				_g_free0 (previous_workspace_key);
				_g_free0 (next_workspace_key);
				_g_free0 (close_workspace_key);
				_g_free0 (search_key);
				new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (new_theme_terminal_key);
				select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (select_workspace_key);
				_g_free0 (keyname);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp257_;
			}
			_tmp259_ = show_helper_window_key;
			if (g_strcmp0 (_tmp259_, "") != 0) {
				const gchar* _tmp260_;
				const gchar* _tmp261_;
				_tmp260_ = keyname;
				_tmp261_ = show_helper_window_key;
				_tmp258_ = g_strcmp0 (_tmp260_, _tmp261_) == 0;
			} else {
				_tmp258_ = FALSE;
			}
			if (_tmp258_) {
				gint x = 0;
				gint y = 0;
				if (self->quake_mode) {
					GdkScreen* screen = NULL;
					GdkScreen* _tmp262_;
					GdkScreen* _tmp263_;
					gint monitor = 0;
					ConfigConfig* _tmp264_;
					GdkRectangle rect = {0};
					GdkScreen* _tmp265_;
					GdkRectangle _tmp266_ = {0};
					GdkRectangle _tmp267_;
					GdkRectangle _tmp268_;
					_tmp262_ = gdk_screen_get_default ();
					_tmp263_ = _g_object_ref0 (_tmp262_);
					screen = _tmp263_;
					_tmp264_ = self->config;
					monitor = config_config_get_terminal_monitor (_tmp264_);
					_tmp265_ = screen;
					gdk_screen_get_monitor_geometry (_tmp265_, monitor, &_tmp266_);
					rect = _tmp266_;
					_tmp267_ = rect;
					x = _tmp267_.width / 2;
					_tmp268_ = rect;
					y = _tmp268_.height / 2;
					widgets_config_window_show_shortcut_viewer (self, x, y);
					_g_object_unref0 (screen);
				} else {
					GtkAllocation window_rect = {0};
					GtkAllocation _tmp269_ = {0};
					gint win_x = 0;
					gint win_y = 0;
					GdkWindow* _tmp270_;
					gint _tmp271_ = 0;
					gint _tmp272_ = 0;
					GtkAllocation _tmp273_;
					GtkAllocation _tmp274_;
					gtk_widget_get_allocation ((GtkWidget*) self, &_tmp269_);
					window_rect = _tmp269_;
					_tmp270_ = gtk_widget_get_window ((GtkWidget*) self);
					gdk_window_get_origin (_tmp270_, &_tmp271_, &_tmp272_);
					win_x = _tmp271_;
					win_y = _tmp272_;
					_tmp273_ = window_rect;
					x = win_x + (_tmp273_.width / 2);
					_tmp274_ = window_rect;
					y = win_y + (_tmp274_.height / 2);
					widgets_config_window_show_shortcut_viewer (self, x, y);
				}
				result = TRUE;
				_g_free0 (show_helper_window_key);
				_g_free0 (rename_title_key);
				_g_free0 (toggle_fullscreen_key);
				_g_free0 (close_other_windows_key);
				_g_free0 (close_window_key);
				_g_free0 (select_right_window_key);
				_g_free0 (select_left_window_key);
				_g_free0 (select_down_window_key);
				_g_free0 (select_up_window_key);
				_g_free0 (split_horizontally_key);
				_g_free0 (split_vertically_key);
				_g_free0 (resize_workspace_down_key);
				_g_free0 (resize_workspace_up_key);
				_g_free0 (resize_workspace_right_key);
				_g_free0 (resize_workspace_left_key);
				_g_free0 (previous_workspace_key);
				_g_free0 (next_workspace_key);
				_g_free0 (close_workspace_key);
				_g_free0 (search_key);
				new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (new_theme_terminal_key);
				select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (select_workspace_key);
				_g_free0 (keyname);
				return result;
			}
			_g_free0 (show_helper_window_key);
		}
		_tmp275_ = self->config;
		_tmp276_ = _tmp275_->config_file;
		_tmp277_ = g_key_file_get_string (_tmp276_, "shortcut", "custom_commands", &_inner_error0_);
		show_command_panel_key = _tmp277_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp278_ = FALSE;
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp278_;
		}
		_tmp280_ = show_command_panel_key;
		if (g_strcmp0 (_tmp280_, "") != 0) {
			const gchar* _tmp281_;
			const gchar* _tmp282_;
			_tmp281_ = keyname;
			_tmp282_ = show_command_panel_key;
			_tmp279_ = g_strcmp0 (_tmp281_, _tmp282_) == 0;
		} else {
			_tmp279_ = FALSE;
		}
		if (_tmp279_) {
			WidgetsWorkspaceManager* _tmp283_;
			WidgetsWorkspace* _tmp284_;
			WidgetsWorkspaceManager* _tmp285_;
			WidgetsWorkspace* _tmp286_;
			_tmp283_ = self->workspace_manager;
			_tmp284_ = _tmp283_->focus_workspace;
			_tmp285_ = self->workspace_manager;
			_tmp286_ = _tmp285_->focus_workspace;
			widgets_workspace_toggle_command_panel (_tmp284_, _tmp286_);
			result = TRUE;
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp287_ = self->config;
		_tmp288_ = _tmp287_->config_file;
		_tmp289_ = g_key_file_get_string (_tmp288_, "shortcut", "remote_management", &_inner_error0_);
		show_remote_panel_key = _tmp289_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp290_ = FALSE;
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp290_;
		}
		_tmp292_ = show_remote_panel_key;
		if (g_strcmp0 (_tmp292_, "") != 0) {
			const gchar* _tmp293_;
			const gchar* _tmp294_;
			_tmp293_ = keyname;
			_tmp294_ = show_remote_panel_key;
			_tmp291_ = g_strcmp0 (_tmp293_, _tmp294_) == 0;
		} else {
			_tmp291_ = FALSE;
		}
		if (_tmp291_) {
			WidgetsWorkspaceManager* _tmp295_;
			WidgetsWorkspace* _tmp296_;
			WidgetsWorkspaceManager* _tmp297_;
			WidgetsWorkspace* _tmp298_;
			_tmp295_ = self->workspace_manager;
			_tmp296_ = _tmp295_->focus_workspace;
			_tmp297_ = self->workspace_manager;
			_tmp298_ = _tmp297_->focus_workspace;
			widgets_workspace_toggle_remote_panel (_tmp296_, _tmp298_);
			result = TRUE;
			_g_free0 (show_remote_panel_key);
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp299_ = self->config;
		_tmp300_ = _tmp299_->config_file;
		_tmp301_ = g_key_file_get_string (_tmp300_, "shortcut", "select_all", &_inner_error0_);
		select_all_key = _tmp301_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp302_ = FALSE;
			_g_free0 (show_remote_panel_key);
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp302_;
		}
		_tmp304_ = select_all_key;
		if (g_strcmp0 (_tmp304_, "") != 0) {
			const gchar* _tmp305_;
			const gchar* _tmp306_;
			_tmp305_ = keyname;
			_tmp306_ = select_all_key;
			_tmp303_ = g_strcmp0 (_tmp305_, _tmp306_) == 0;
		} else {
			_tmp303_ = FALSE;
		}
		if (_tmp303_) {
			WidgetsWorkspaceManager* _tmp307_;
			WidgetsWorkspace* _tmp308_;
			WidgetsWorkspaceManager* _tmp309_;
			WidgetsWorkspace* _tmp310_;
			_tmp307_ = self->workspace_manager;
			_tmp308_ = _tmp307_->focus_workspace;
			widgets_workspace_remove_all_panels (_tmp308_);
			_tmp309_ = self->workspace_manager;
			_tmp310_ = _tmp309_->focus_workspace;
			widgets_workspace_toggle_select_all (_tmp310_);
			result = TRUE;
			_g_free0 (select_all_key);
			_g_free0 (show_remote_panel_key);
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp311_ = keyname;
		_tmp312_ = select_workspace_shortcuts;
		_tmp312__length1 = select_workspace_shortcuts_length1;
		if (_vala_string_array_contains (_tmp312_, _tmp312__length1, _tmp311_)) {
			WidgetsWorkspaceManager* _tmp313_;
			gchar* _tmp314_;
			gchar* _tmp315_;
			_tmp313_ = self->workspace_manager;
			_tmp314_ = keymap_get_key_name (key_event->keyval);
			_tmp315_ = _tmp314_;
			widgets_workspace_manager_switch_workspace_with_index (_tmp313_, atoi (_tmp315_));
			_g_free0 (_tmp315_);
			result = TRUE;
			_g_free0 (select_all_key);
			_g_free0 (show_remote_panel_key);
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_tmp316_ = keyname;
		_tmp317_ = new_terminal_shortcuts;
		_tmp317__length1 = new_terminal_shortcuts_length1;
		if (_vala_string_array_contains (_tmp317_, _tmp317__length1, _tmp316_)) {
			gchar* theme_name = NULL;
			ConfigConfig* _tmp318_;
			GKeyFile* _tmp319_;
			gchar* _tmp320_;
			gchar* _tmp321_;
			gchar* _tmp322_;
			gchar* _tmp323_;
			gchar* _tmp324_;
			gchar* _tmp325_;
			_tmp318_ = self->config;
			_tmp319_ = _tmp318_->config_file;
			_tmp320_ = keymap_get_key_name (key_event->keyval);
			_tmp321_ = _tmp320_;
			_tmp322_ = g_strdup_printf ("theme%i", atoi (_tmp321_));
			_tmp323_ = _tmp322_;
			_tmp324_ = g_key_file_get_string (_tmp319_, "theme_terminal", _tmp323_, &_inner_error0_);
			_tmp325_ = _tmp324_;
			_g_free0 (_tmp323_);
			_g_free0 (_tmp321_);
			theme_name = _tmp325_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp326_ = FALSE;
				_g_free0 (select_all_key);
				_g_free0 (show_remote_panel_key);
				_g_free0 (show_command_panel_key);
				_g_free0 (rename_title_key);
				_g_free0 (toggle_fullscreen_key);
				_g_free0 (close_other_windows_key);
				_g_free0 (close_window_key);
				_g_free0 (select_right_window_key);
				_g_free0 (select_left_window_key);
				_g_free0 (select_down_window_key);
				_g_free0 (select_up_window_key);
				_g_free0 (split_horizontally_key);
				_g_free0 (split_vertically_key);
				_g_free0 (resize_workspace_down_key);
				_g_free0 (resize_workspace_up_key);
				_g_free0 (resize_workspace_right_key);
				_g_free0 (resize_workspace_left_key);
				_g_free0 (previous_workspace_key);
				_g_free0 (next_workspace_key);
				_g_free0 (close_workspace_key);
				_g_free0 (search_key);
				new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (new_theme_terminal_key);
				select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (select_workspace_key);
				_g_free0 (keyname);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp326_;
			}
			{
				GAppInfo* appinfo = NULL;
				const gchar* _tmp327_;
				gchar* _tmp328_;
				gchar* _tmp329_;
				GAppInfo* _tmp330_;
				GAppInfo* _tmp331_;
				GAppInfo* _tmp332_;
				_tmp327_ = theme_name;
				_tmp328_ = g_strdup_printf ("deepin-terminal-gtk --load-theme '%s'", _tmp327_);
				_tmp329_ = _tmp328_;
				_tmp330_ = g_app_info_create_from_commandline (_tmp329_, NULL, G_APP_INFO_CREATE_NONE, &_inner_error0_);
				_tmp331_ = _tmp330_;
				_g_free0 (_tmp329_);
				appinfo = _tmp331_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp332_ = appinfo;
				g_app_info_launch (_tmp332_, NULL, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (appinfo);
					goto __catch1_g_error;
				}
				_g_object_unref0 (appinfo);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp333_;
				const gchar* _tmp334_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp333_ = e;
				_tmp334_ = _tmp333_->message;
				g_print ("Appbar menu item 'new window': %s\n", _tmp334_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp335_ = FALSE;
				_g_free0 (theme_name);
				_g_free0 (select_all_key);
				_g_free0 (show_remote_panel_key);
				_g_free0 (show_command_panel_key);
				_g_free0 (rename_title_key);
				_g_free0 (toggle_fullscreen_key);
				_g_free0 (close_other_windows_key);
				_g_free0 (close_window_key);
				_g_free0 (select_right_window_key);
				_g_free0 (select_left_window_key);
				_g_free0 (select_down_window_key);
				_g_free0 (select_up_window_key);
				_g_free0 (split_horizontally_key);
				_g_free0 (split_vertically_key);
				_g_free0 (resize_workspace_down_key);
				_g_free0 (resize_workspace_up_key);
				_g_free0 (resize_workspace_right_key);
				_g_free0 (resize_workspace_left_key);
				_g_free0 (previous_workspace_key);
				_g_free0 (next_workspace_key);
				_g_free0 (close_workspace_key);
				_g_free0 (search_key);
				new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (new_theme_terminal_key);
				select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (select_workspace_key);
				_g_free0 (keyname);
				if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
					goto __catch0_g_key_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp335_;
			}
			result = TRUE;
			_g_free0 (theme_name);
			_g_free0 (select_all_key);
			_g_free0 (show_remote_panel_key);
			_g_free0 (show_command_panel_key);
			_g_free0 (rename_title_key);
			_g_free0 (toggle_fullscreen_key);
			_g_free0 (close_other_windows_key);
			_g_free0 (close_window_key);
			_g_free0 (select_right_window_key);
			_g_free0 (select_left_window_key);
			_g_free0 (select_down_window_key);
			_g_free0 (select_up_window_key);
			_g_free0 (split_horizontally_key);
			_g_free0 (split_vertically_key);
			_g_free0 (resize_workspace_down_key);
			_g_free0 (resize_workspace_up_key);
			_g_free0 (resize_workspace_right_key);
			_g_free0 (resize_workspace_left_key);
			_g_free0 (previous_workspace_key);
			_g_free0 (next_workspace_key);
			_g_free0 (close_workspace_key);
			_g_free0 (search_key);
			new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (new_theme_terminal_key);
			select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (select_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		result = FALSE;
		_g_free0 (select_all_key);
		_g_free0 (show_remote_panel_key);
		_g_free0 (show_command_panel_key);
		_g_free0 (rename_title_key);
		_g_free0 (toggle_fullscreen_key);
		_g_free0 (close_other_windows_key);
		_g_free0 (close_window_key);
		_g_free0 (select_right_window_key);
		_g_free0 (select_left_window_key);
		_g_free0 (select_down_window_key);
		_g_free0 (select_up_window_key);
		_g_free0 (split_horizontally_key);
		_g_free0 (split_vertically_key);
		_g_free0 (resize_workspace_down_key);
		_g_free0 (resize_workspace_up_key);
		_g_free0 (resize_workspace_right_key);
		_g_free0 (resize_workspace_left_key);
		_g_free0 (previous_workspace_key);
		_g_free0 (next_workspace_key);
		_g_free0 (close_workspace_key);
		_g_free0 (search_key);
		new_terminal_shortcuts = (_vala_array_free (new_terminal_shortcuts, new_terminal_shortcuts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (new_theme_terminal_key);
		select_workspace_shortcuts = (_vala_array_free (select_workspace_shortcuts, select_workspace_shortcuts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (select_workspace_key);
		_g_free0 (keyname);
		return result;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp336_;
		const gchar* _tmp337_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp336_ = e;
		_tmp337_ = _tmp336_->message;
		g_print ("Main on_key_press: %s\n", _tmp337_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp338_;
}

static gboolean
widgets_config_window_on_key_release (WidgetsConfigWindow* self,
                                      GtkWidget* widget,
                                      GdkEventKey* key_event)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (key_event != NULL, FALSE);
	if (keymap_is_no_key_press (key_event)) {
		if (utils_is_command_exist ("deepin-shortcut-viewer")) {
			widgets_config_window_remove_shortcut_viewer (self);
		}
	}
	{
		gchar* keyname = NULL;
		gchar* _tmp0_;
		gchar* new_workspace_key = NULL;
		ConfigConfig* _tmp1_;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = keymap_get_keyevent_name (key_event);
		keyname = _tmp0_;
		_tmp1_ = self->config;
		_tmp2_ = _tmp1_->config_file;
		_tmp3_ = g_key_file_get_string (_tmp2_, "shortcut", "new_workspace", &_inner_error0_);
		new_workspace_key = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			_g_free0 (keyname);
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		if (g_strcmp0 (new_workspace_key, "") != 0) {
			_tmp5_ = g_strcmp0 (keyname, new_workspace_key) == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			WidgetsWorkspaceManager* _tmp6_;
			_tmp6_ = self->workspace_manager;
			widgets_workspace_manager_new_workspace_with_current_directory (_tmp6_, FALSE);
			result = TRUE;
			_g_free0 (new_workspace_key);
			_g_free0 (keyname);
			return result;
		}
		_g_free0 (new_workspace_key);
		_g_free0 (keyname);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_print ("Main on_key_release: %s\n", _tmp8_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}

gboolean
widgets_config_window_is_light_theme (WidgetsConfigWindow* self)
{
	gboolean* _tmp0_;
	gboolean* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->config_theme_is_light;
	if (_tmp0_ == NULL) {
		widgets_config_window_update_theme_style (self);
	}
	_tmp1_ = self->config_theme_is_light;
	result = *_tmp1_;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

void
widgets_config_window_update_theme_style (WidgetsConfigWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gchar* _tmp0_ = NULL;
		ConfigConfig* _tmp1_;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_;
		gboolean* _tmp5_;
		_tmp1_ = self->config;
		_tmp2_ = _tmp1_->config_file;
		_tmp3_ = g_key_file_get_string (_tmp2_, "theme", "style", &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = g_strcmp0 (_tmp0_, "light") == 0;
		_tmp5_ = __bool_dup0 (&_tmp4_);
		_g_free0 (self->config_theme_is_light);
		self->config_theme_is_light = _tmp5_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_print ("ConfigWindow update_theme_style: %s\n", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
widgets_config_window_draw_titlebar_underline (WidgetsConfigWindow* self,
                                               cairo_t* cr,
                                               gint x,
                                               gint y,
                                               gint width,
                                               gint offset)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	cairo_save (cr);
	if (widgets_config_window_is_light_theme (self)) {
		GdkRGBA _tmp0_;
		_tmp0_ = self->title_line_light_color;
		utils_set_context_color (cr, &_tmp0_);
	} else {
		GdkRGBA _tmp1_;
		_tmp1_ = self->title_line_dark_color;
		utils_set_context_color (cr, &_tmp1_);
	}
	draw_draw_rectangle (cr, x, y + offset, width, 1, TRUE);
	cairo_restore (cr);
}

void
widgets_config_window_draw_active_tab_underline (WidgetsConfigWindow* self,
                                                 cairo_t* cr,
                                                 gint x,
                                                 gint y)
{
	GdkRGBA active_tab_color = {0};
	GdkRGBA _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	memset (&active_tab_color, 0, sizeof (GdkRGBA));
	{
		gchar* _tmp0_ = NULL;
		ConfigConfig* _tmp1_;
		GKeyFile* _tmp2_;
		gchar* _tmp3_;
		GdkRGBA _tmp4_ = {0};
		_tmp1_ = self->config;
		_tmp2_ = _tmp1_->config_file;
		_tmp3_ = g_key_file_get_string (_tmp2_, "theme", "tab", &_inner_error0_);
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		utils_hex_to_rgba (_tmp0_, 1.0, &_tmp4_);
		active_tab_color = _tmp4_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_print ("QuakeWindow draw_window_above: %s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	cairo_save (cr);
	_tmp7_ = active_tab_color;
	utils_set_context_color (cr, &_tmp7_);
	draw_draw_rectangle (cr, x, y, self->active_tab_underline_width, constant_ACTIVE_TAB_UNDERLINE_HEIGHT, TRUE);
	cairo_restore (cr);
}

static void
widgets_config_window_real_toggle_fullscreen (WidgetsConfigWindow* self)
{
}

void
widgets_config_window_toggle_fullscreen (WidgetsConfigWindow* self)
{
	WidgetsConfigWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WIDGETS_CONFIG_WINDOW_GET_CLASS (self);
	if (_klass_->toggle_fullscreen) {
		_klass_->toggle_fullscreen (self);
	}
}

static void
widgets_config_window_real_window_save_before_quit (WidgetsConfigWindow* self)
{
}

void
widgets_config_window_window_save_before_quit (WidgetsConfigWindow* self)
{
	WidgetsConfigWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WIDGETS_CONFIG_WINDOW_GET_CLASS (self);
	if (_klass_->window_save_before_quit) {
		_klass_->window_save_before_quit (self);
	}
}

static GdkCursorType*
widgets_config_window_real_get_frame_cursor_type (WidgetsConfigWindow* self,
                                                  gdouble x,
                                                  gdouble y)
{
	GdkCursorType* result;
	result = NULL;
	return result;
}

GdkCursorType*
widgets_config_window_get_frame_cursor_type (WidgetsConfigWindow* self,
                                             gdouble x,
                                             gdouble y)
{
	WidgetsConfigWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = WIDGETS_CONFIG_WINDOW_GET_CLASS (self);
	if (_klass_->get_frame_cursor_type) {
		return _klass_->get_frame_cursor_type (self, x, y);
	}
	return NULL;
}

static void
widgets_config_window_real_update_frame (WidgetsConfigWindow* self)
{
}

void
widgets_config_window_update_frame (WidgetsConfigWindow* self)
{
	WidgetsConfigWindowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = WIDGETS_CONFIG_WINDOW_GET_CLASS (self);
	if (_klass_->update_frame) {
		_klass_->update_frame (self);
	}
}

static GdkCursorType*
widgets_config_window_real_get_cursor_type (WidgetsConfigWindow* self,
                                            gdouble x,
                                            gdouble y)
{
	GdkCursorType* result;
	result = NULL;
	return result;
}

GdkCursorType*
widgets_config_window_get_cursor_type (WidgetsConfigWindow* self,
                                       gdouble x,
                                       gdouble y)
{
	WidgetsConfigWindowClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = WIDGETS_CONFIG_WINDOW_GET_CLASS (self);
	if (_klass_->get_cursor_type) {
		return _klass_->get_cursor_type (self, x, y);
	}
	return NULL;
}

void
widgets_config_window_redraw_window (WidgetsConfigWindow* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

gboolean
widgets_config_window_window_is_max (WidgetsConfigWindow* self)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	result = (gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED;
	return result;
}

gboolean
widgets_config_window_window_is_tiled (WidgetsConfigWindow* self)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	result = (gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_TILED) == GDK_WINDOW_STATE_TILED;
	return result;
}

gboolean
widgets_config_window_window_is_fullscreen (WidgetsConfigWindow* self)
{
	GdkWindow* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	result = (gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_FULLSCREEN) == GDK_WINDOW_STATE_FULLSCREEN;
	return result;
}

gboolean
widgets_config_window_window_is_normal (WidgetsConfigWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!widgets_config_window_window_is_max (self)) {
		_tmp1_ = !widgets_config_window_window_is_fullscreen (self);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !widgets_config_window_window_is_tiled (self);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
widgets_config_window_class_init (WidgetsConfigWindowClass * klass,
                                  gpointer klass_data)
{
	widgets_config_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WidgetsConfigWindow_private_offset);
	((WidgetsConfigWindowClass *) klass)->toggle_fullscreen = (void (*) (WidgetsConfigWindow*)) widgets_config_window_real_toggle_fullscreen;
	((WidgetsConfigWindowClass *) klass)->window_save_before_quit = (void (*) (WidgetsConfigWindow*)) widgets_config_window_real_window_save_before_quit;
	((WidgetsConfigWindowClass *) klass)->get_frame_cursor_type = (GdkCursorType* (*) (WidgetsConfigWindow*, gdouble, gdouble)) widgets_config_window_real_get_frame_cursor_type;
	((WidgetsConfigWindowClass *) klass)->update_frame = (void (*) (WidgetsConfigWindow*)) widgets_config_window_real_update_frame;
	((WidgetsConfigWindowClass *) klass)->get_cursor_type = (GdkCursorType* (*) (WidgetsConfigWindow*, gdouble, gdouble)) widgets_config_window_real_get_cursor_type;
	G_OBJECT_CLASS (klass)->finalize = widgets_config_window_finalize;
}

static void
widgets_config_window_instance_init (WidgetsConfigWindow * self,
                                     gpointer klass)
{
	self->priv = widgets_config_window_get_instance_private (self);
	self->quake_mode = FALSE;
	self->show_quake_menu = FALSE;
	self->cache_height = 0;
	self->cache_width = 0;
	self->reset_timeout_delay = 150;
	self->resize_cache_x = 0;
	self->resize_cache_y = 0;
	self->resize_cache_width = 0;
	self->resize_cache_height = 0;
	self->resize_timeout_delay = 150;
	self->reset_timeout_source_id = NULL;
	self->resize_timeout_source_id = NULL;
	self->priv->is_show_shortcut_viewer = FALSE;
}

static void
widgets_config_window_finalize (GObject * obj)
{
	WidgetsConfigWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow);
	_g_object_unref0 (self->config);
	_g_object_unref0 (self->screen_monitor);
	_g_object_unref0 (self->box);
	_g_object_unref0 (self->top_box);
	_g_object_unref0 (self->window_frame_box);
	_g_object_unref0 (self->window_widget_box);
	_g_object_unref0 (self->workspace_manager);
	_g_free0 (self->config_theme_is_light);
	_g_free0 (self->reset_timeout_source_id);
	_g_free0 (self->resize_timeout_source_id);
	G_OBJECT_CLASS (widgets_config_window_parent_class)->finalize (obj);
}

static GType
widgets_config_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsConfigWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_config_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsConfigWindow), 0, (GInstanceInitFunc) widgets_config_window_instance_init, NULL };
	GType widgets_config_window_type_id;
	widgets_config_window_type_id = g_type_register_static (gtk_window_get_type (), "WidgetsConfigWindow", &g_define_type_info, 0);
	WidgetsConfigWindow_private_offset = g_type_add_instance_private (widgets_config_window_type_id, sizeof (WidgetsConfigWindowPrivate));
	return widgets_config_window_type_id;
}

GType
widgets_config_window_get_type (void)
{
	static volatile gsize widgets_config_window_type_id__once = 0;
	if (g_once_init_enter (&widgets_config_window_type_id__once)) {
		GType widgets_config_window_type_id;
		widgets_config_window_type_id = widgets_config_window_get_type_once ();
		g_once_init_leave (&widgets_config_window_type_id__once, widgets_config_window_type_id);
	}
	return widgets_config_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

