/* encoding_panel.c generated by valac 0.56.17, the Vala compiler
 * generated from encoding_panel.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gee.h>
#include <vte/vte.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_ENCODING_PANEL (widgets_encoding_panel_get_type ())
#define WIDGETS_ENCODING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENCODING_PANEL, WidgetsEncodingPanel))
#define WIDGETS_ENCODING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENCODING_PANEL, WidgetsEncodingPanelClass))
#define WIDGETS_IS_ENCODING_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENCODING_PANEL))
#define WIDGETS_IS_ENCODING_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENCODING_PANEL))
#define WIDGETS_ENCODING_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENCODING_PANEL, WidgetsEncodingPanelClass))

typedef struct _WidgetsEncodingPanel WidgetsEncodingPanel;
typedef struct _WidgetsEncodingPanelClass WidgetsEncodingPanelClass;
typedef struct _WidgetsEncodingPanelPrivate WidgetsEncodingPanelPrivate;

#define WIDGETS_TYPE_SWITCHER (widgets_switcher_get_type ())
#define WIDGETS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcher))
#define WIDGETS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))
#define WIDGETS_IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SWITCHER))
#define WIDGETS_SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SWITCHER, WidgetsSwitcherClass))

typedef struct _WidgetsSwitcher WidgetsSwitcher;
typedef struct _WidgetsSwitcherClass WidgetsSwitcherClass;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_TERM (widgets_term_get_type ())
#define WIDGETS_TERM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TERM, WidgetsTerm))
#define WIDGETS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TERM, WidgetsTermClass))
#define WIDGETS_IS_TERM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TERM))
#define WIDGETS_IS_TERM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TERM))
#define WIDGETS_TERM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TERM, WidgetsTermClass))

typedef struct _WidgetsTerm WidgetsTerm;
typedef struct _WidgetsTermClass WidgetsTermClass;
enum  {
	WIDGETS_ENCODING_PANEL_0_PROPERTY,
	WIDGETS_ENCODING_PANEL_NUM_PROPERTIES
};
static GParamSpec* widgets_encoding_panel_properties[WIDGETS_ENCODING_PANEL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define WIDGETS_TYPE_ENCODING_LIST (widgets_encoding_list_get_type ())
#define WIDGETS_ENCODING_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingList))
#define WIDGETS_ENCODING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingListClass))
#define WIDGETS_IS_ENCODING_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENCODING_LIST))
#define WIDGETS_IS_ENCODING_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENCODING_LIST))
#define WIDGETS_ENCODING_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENCODING_LIST, WidgetsEncodingListClass))

typedef struct _WidgetsEncodingList WidgetsEncodingList;
typedef struct _WidgetsEncodingListClass WidgetsEncodingListClass;
typedef struct _Block13Data Block13Data;
typedef struct _WidgetsTermPrivate WidgetsTermPrivate;

#define MENU_TYPE_MENU (menu_menu_get_type ())
#define MENU_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MENU_TYPE_MENU, MenuMenu))
#define MENU_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MENU_TYPE_MENU, MenuMenuClass))
#define MENU_IS_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MENU_TYPE_MENU))
#define MENU_IS_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MENU_TYPE_MENU))
#define MENU_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MENU_TYPE_MENU, MenuMenuClass))

typedef struct _MenuMenu MenuMenu;
typedef struct _MenuMenuClass MenuMenuClass;
typedef struct _WidgetsEncodingListPrivate WidgetsEncodingListPrivate;

#define WIDGETS_TYPE_ENCODING_BUTTON (widgets_encoding_button_get_type ())
#define WIDGETS_ENCODING_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButton))
#define WIDGETS_ENCODING_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButtonClass))
#define WIDGETS_IS_ENCODING_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENCODING_BUTTON))
#define WIDGETS_IS_ENCODING_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENCODING_BUTTON))
#define WIDGETS_ENCODING_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENCODING_BUTTON, WidgetsEncodingButtonClass))

typedef struct _WidgetsEncodingButton WidgetsEncodingButton;
typedef struct _WidgetsEncodingButtonClass WidgetsEncodingButtonClass;
typedef void (*WidgetsEncodingPanelUpdatePageAfterEdit) (gpointer user_data);

struct _WidgetsEncodingPanel {
	GtkHBox parent_instance;
	WidgetsEncodingPanelPrivate * priv;
	WidgetsSwitcher* switcher;
	WidgetsConfigWindow* parent_window;
	WidgetsWorkspace* workspace;
	WidgetsWorkspaceManager* workspace_manager;
	GdkRGBA background_color;
	GdkRGBA line_dark_color;
	GdkRGBA line_light_color;
	GtkBox* home_page_box;
	GtkScrolledWindow* scrolledwindow;
	GtkWidget* focus_widget;
	GKeyFile* config_file;
	WidgetsTerm* focus_term;
	gint back_button_margin_left;
	gint back_button_margin_top;
	gint encoding_button_padding;
	gint encoding_list_margin_bottom;
	gint encoding_list_margin_top;
	gint split_line_margin_left;
	gint width;
};

struct _WidgetsEncodingPanelClass {
	GtkHBoxClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

struct _Block13Data {
	int _ref_count_;
	WidgetsEncodingPanel* self;
	WidgetsEncodingList* encoding_list;
};

struct _WidgetsTerm {
	GtkOverlay parent_instance;
	WidgetsTermPrivate * priv;
	GeeArrayList* command_execute_y_coordinates;
	GPid child_pid;
	GdkRGBA background_color;
	GdkRGBA foreground_color;
	GtkScrollbar* scrollbar;
	MenuMenu* menu;
	VteTerminal* term;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean child_has_exit;
	gboolean has_print_exit_notify;
	gboolean has_select_all;
	gboolean is_first_term;
	gboolean is_press_scrollbar;
	gboolean login_remote_server;
	gboolean press_anything;
	gdouble zoom_factor;
	gint font_size;
	gint hide_scrollbar_offset;
	gint show_scrollbar_offset;
	gchar* current_dir;
	gchar* current_title;
	gchar* expect_file_path;
	gchar* customize_title;
	gchar* remote_server_title;
	gchar* uri_at_right_press;
	gchar* server_info;
	guint launch_idle_id;
	guint* hide_scrollbar_timeout_source_id;
	GKeyFile* search_engine_config_file;
	gchar* search_engine_config_file_path;
};

struct _WidgetsTermClass {
	GtkOverlayClass parent_class;
};

struct _WidgetsEncodingList {
	GtkVBox parent_instance;
	WidgetsEncodingListPrivate * priv;
	gint encoding_button_padding;
	GeeHashMap* encoding_button_map;
	WidgetsEncodingButton* active_encoding_button;
};

struct _WidgetsEncodingListClass {
	GtkVBoxClass parent_class;
};

static gpointer widgets_encoding_panel_parent_class = NULL;
VALA_EXTERN gint constant_ENCODING_SLIDER_WIDTH;
VALA_EXTERN gint constant_ENCODING_BUTTON_HEIGHT;

VALA_EXTERN GType widgets_encoding_panel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEncodingPanel, g_object_unref)
VALA_EXTERN GType widgets_switcher_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSwitcher, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_term_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTerm, g_object_unref)
VALA_EXTERN WidgetsEncodingPanel* widgets_encoding_panel_new (WidgetsWorkspace* space,
                                                  WidgetsWorkspaceManager* manager,
                                                  WidgetsTerm* term);
VALA_EXTERN WidgetsEncodingPanel* widgets_encoding_panel_construct (GType object_type,
                                                        WidgetsWorkspace* space,
                                                        WidgetsWorkspaceManager* manager,
                                                        WidgetsTerm* term);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN WidgetsSwitcher* widgets_switcher_new (gint w);
VALA_EXTERN WidgetsSwitcher* widgets_switcher_construct (GType object_type,
                                             gint w);
VALA_EXTERN void widgets_encoding_panel_show_home_page (WidgetsEncodingPanel* self,
                                            GtkWidget* start_widget);
static gboolean widgets_encoding_panel_on_draw (WidgetsEncodingPanel* self,
                                         GtkWidget* widget,
                                         cairo_t* cr);
static gboolean _widgets_encoding_panel_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                          cairo_t* cr,
                                                          gpointer self);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN GType widgets_encoding_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEncodingList, g_object_unref)
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda110_ (WidgetsEncodingPanel* self,
                   GtkWidget* w);
VALA_EXTERN void widgets_encoding_panel_init_scrollbar (WidgetsEncodingPanel* self);
static void ___lambda110__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self);
VALA_EXTERN GType menu_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MenuMenu, g_object_unref)
VALA_EXTERN WidgetsEncodingList* widgets_encoding_list_new (const gchar* temrinal_encoding,
                                                GeeArrayList* encoding_names,
                                                WidgetsWorkspace* space);
VALA_EXTERN WidgetsEncodingList* widgets_encoding_list_construct (GType object_type,
                                                      const gchar* temrinal_encoding,
                                                      GeeArrayList* encoding_names,
                                                      WidgetsWorkspace* space);
static void __lambda112_ (WidgetsEncodingPanel* self,
                   const gchar* active_encoding_name);
static void ___lambda112__widgets_encoding_list_active_encoding (WidgetsEncodingList* _sender,
                                                          const gchar* encoding_name,
                                                          gpointer self);
VALA_EXTERN void widgets_switcher_add_to_left_box (WidgetsSwitcher* self,
                                       GtkWidget* start_widget);
static void __lambda113_ (Block13Data* _data13_,
                   GtkWidget* w);
static gboolean __lambda114_ (Block13Data* _data13_);
VALA_EXTERN GType widgets_encoding_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEncodingButton, g_object_unref)
static gboolean ___lambda114__gsource_func (gpointer self);
static void ___lambda113__gtk_widget_show (GtkWidget* _sender,
                                    gpointer self);
static void widgets_encoding_panel_finalize (GObject * obj);
static GType widgets_encoding_panel_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_widgets_encoding_panel_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                 cairo_t* cr,
                                                 gpointer self)
{
	gboolean result;
	result = widgets_encoding_panel_on_draw ((WidgetsEncodingPanel*) self, _sender, cr);
	return result;
}

WidgetsEncodingPanel*
widgets_encoding_panel_construct (GType object_type,
                                  WidgetsWorkspace* space,
                                  WidgetsWorkspaceManager* manager,
                                  WidgetsTerm* term)
{
	WidgetsEncodingPanel * self = NULL;
	WidgetsWorkspace* _tmp0_;
	WidgetsWorkspaceManager* _tmp1_;
	WidgetsTerm* _tmp2_;
	GKeyFile* _tmp3_;
	GdkRGBA _tmp4_ = {0};
	GdkRGBA _tmp5_ = {0};
	WidgetsWorkspace* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	WidgetsWorkspace* _tmp10_;
	GtkWidget* _tmp11_;
	WidgetsConfigWindow* _tmp12_;
	WidgetsSwitcher* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	WidgetsSwitcher* _tmp16_;
	g_return_val_if_fail (space != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	g_return_val_if_fail (term != NULL, NULL);
	self = (WidgetsEncodingPanel*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	_tmp0_ = _g_object_ref0 (space);
	_g_object_unref0 (self->workspace);
	self->workspace = _tmp0_;
	_tmp1_ = _g_object_ref0 (manager);
	_g_object_unref0 (self->workspace_manager);
	self->workspace_manager = _tmp1_;
	_tmp2_ = _g_object_ref0 (term);
	_g_object_unref0 (self->focus_term);
	self->focus_term = _tmp2_;
	_tmp3_ = g_key_file_new ();
	_g_key_file_unref0 (self->config_file);
	self->config_file = _tmp3_;
	utils_hex_to_rgba ("#ffffff", 0.1, &_tmp4_);
	self->line_dark_color = _tmp4_;
	utils_hex_to_rgba ("#000000", 0.1, &_tmp5_);
	self->line_light_color = _tmp5_;
	_tmp6_ = self->workspace;
	_tmp7_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp6_);
	_tmp8_ = gtk_window_get_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_window_get_type (), GtkWindow));
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->focus_widget);
	self->focus_widget = _tmp9_;
	_tmp10_ = self->workspace;
	_tmp11_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp10_);
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	_g_object_unref0 (self->parent_window);
	self->parent_window = _tmp12_;
	_tmp13_ = widgets_switcher_new (self->width);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->switcher);
	self->switcher = _tmp13_;
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->home_page_box);
	self->home_page_box = _tmp14_;
	gtk_widget_set_size_request ((GtkWidget*) self, self->width, -1);
	_tmp15_ = self->home_page_box;
	gtk_widget_set_size_request ((GtkWidget*) _tmp15_, self->width, -1);
	_tmp16_ = self->switcher;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp16_, TRUE, TRUE, (guint) 0);
	widgets_encoding_panel_show_home_page (self, NULL);
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_encoding_panel_on_draw_gtk_widget_draw, self, 0);
	return self;
}

WidgetsEncodingPanel*
widgets_encoding_panel_new (WidgetsWorkspace* space,
                            WidgetsWorkspaceManager* manager,
                            WidgetsTerm* term)
{
	return widgets_encoding_panel_construct (WIDGETS_TYPE_ENCODING_PANEL, space, manager, term);
}

static gboolean
widgets_encoding_panel_on_draw (WidgetsEncodingPanel* self,
                                GtkWidget* widget,
                                cairo_t* cr)
{
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp0_;
	GtkAllocation rect = {0};
	GtkAllocation _tmp1_ = {0};
	GdkRGBA _tmp11_;
	GdkRGBA _tmp12_;
	GdkRGBA _tmp13_;
	GtkAllocation _tmp14_;
	GtkAllocation _tmp15_;
	GtkAllocation _tmp18_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	gtk_widget_get_allocation (widget, &_tmp1_);
	rect = _tmp1_;
	{
		gchar* _tmp2_ = NULL;
		WidgetsConfigWindow* _tmp3_;
		ConfigConfig* _tmp4_;
		GKeyFile* _tmp5_;
		gchar* _tmp6_;
		GdkRGBA _tmp7_ = {0};
		_tmp3_ = self->parent_window;
		_tmp4_ = _tmp3_->config;
		_tmp5_ = _tmp4_->config_file;
		_tmp6_ = g_key_file_get_string (_tmp5_, "theme", "background", &_inner_error0_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		utils_hex_to_rgba (_tmp2_, 1.0, &_tmp7_);
		self->background_color = _tmp7_;
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_print ("EncodingPanel init: %s\n", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp10_;
	}
	_tmp11_ = self->background_color;
	_tmp12_ = self->background_color;
	_tmp13_ = self->background_color;
	cairo_set_source_rgba (cr, _tmp11_.red, _tmp12_.green, _tmp13_.blue, 0.8);
	_tmp14_ = rect;
	_tmp15_ = rect;
	draw_draw_rectangle (cr, 1, 0, _tmp14_.width - 1, _tmp15_.height, TRUE);
	if (is_light_theme) {
		GdkRGBA _tmp16_;
		_tmp16_ = self->line_light_color;
		utils_set_context_color (cr, &_tmp16_);
	} else {
		GdkRGBA _tmp17_;
		_tmp17_ = self->line_dark_color;
		utils_set_context_color (cr, &_tmp17_);
	}
	_tmp18_ = rect;
	draw_draw_rectangle (cr, 0, 0, 1, _tmp18_.height, TRUE);
	result = FALSE;
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		WidgetsEncodingPanel* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->encoding_list);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda110_ (WidgetsEncodingPanel* self,
              GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	widgets_encoding_panel_init_scrollbar (self);
}

static void
___lambda110__gtk_widget_realize (GtkWidget* _sender,
                                  gpointer self)
{
	__lambda110_ ((WidgetsEncodingPanel*) self, _sender);
}

static void
__lambda112_ (WidgetsEncodingPanel* self,
              const gchar* active_encoding_name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (active_encoding_name != NULL);
	{
		WidgetsTerm* _tmp0_;
		VteTerminal* _tmp1_;
		_tmp0_ = self->focus_term;
		_tmp1_ = _tmp0_->term;
		vte_terminal_set_encoding (_tmp1_, active_encoding_name, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_print ("EncodingPanel set_encoding error: %s\n", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	widgets_encoding_panel_init_scrollbar (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
___lambda112__widgets_encoding_list_active_encoding (WidgetsEncodingList* _sender,
                                                     const gchar* encoding_name,
                                                     gpointer self)
{
	__lambda112_ ((WidgetsEncodingPanel*) self, encoding_name);
}

static gboolean
__lambda114_ (Block13Data* _data13_)
{
	WidgetsEncodingPanel* self;
	gint widget_x = 0;
	gint widget_y = 0;
	WidgetsEncodingButton* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkAllocation rect = {0};
	GtkAllocation _tmp3_ = {0};
	GtkAdjustment* adjust = NULL;
	GtkScrolledWindow* _tmp4_;
	GtkAdjustment* _tmp5_;
	GtkAdjustment* _tmp6_;
	GtkAllocation _tmp7_;
	gboolean result;
	self = _data13_->self;
	_tmp0_ = _data13_->encoding_list->active_encoding_button;
	gtk_widget_translate_coordinates ((GtkWidget*) _tmp0_, (GtkWidget*) _data13_->encoding_list, 0, 0, &_tmp1_, &_tmp2_);
	widget_x = _tmp1_;
	widget_y = _tmp2_;
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
	rect = _tmp3_;
	_tmp4_ = self->scrolledwindow;
	_tmp5_ = gtk_scrolled_window_get_vadjustment (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	adjust = _tmp6_;
	_tmp7_ = rect;
	gtk_adjustment_set_value (adjust, (gdouble) (widget_y - ((_tmp7_.height - constant_ENCODING_BUTTON_HEIGHT) / 2)));
	result = FALSE;
	_g_object_unref0 (adjust);
	return result;
}

static gboolean
___lambda114__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda114_ (self);
	return result;
}

static void
__lambda113_ (Block13Data* _data13_,
              GtkWidget* w)
{
	WidgetsEncodingPanel* self;
	self = _data13_->self;
	g_return_if_fail (w != NULL);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda114__gsource_func, block13_data_ref (_data13_), block13_data_unref);
}

static void
___lambda113__gtk_widget_show (GtkWidget* _sender,
                               gpointer self)
{
	__lambda113_ (self, _sender);
}

void
widgets_encoding_panel_show_home_page (WidgetsEncodingPanel* self,
                                       GtkWidget* start_widget)
{
	Block13Data* _data13_;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkScrolledWindow* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkWidget* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkBox* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	WidgetsTerm* _tmp10_;
	VteTerminal* _tmp11_;
	const gchar* _tmp12_;
	WidgetsConfigWindow* _tmp13_;
	ConfigConfig* _tmp14_;
	GeeArrayList* _tmp15_;
	WidgetsWorkspace* _tmp16_;
	WidgetsEncodingList* _tmp17_;
	GtkScrolledWindow* _tmp18_;
	WidgetsSwitcher* _tmp19_;
	GtkBox* _tmp20_;
	g_return_if_fail (self != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->scrolledwindow);
	self->scrolledwindow = _tmp0_;
	_tmp1_ = self->scrolledwindow;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_add_class (_tmp2_, "scrolledwindow");
	_tmp3_ = self->scrolledwindow;
	gtk_scrolled_window_set_policy (_tmp3_, GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	_tmp4_ = self->scrolledwindow;
	gtk_scrolled_window_set_shadow_type (_tmp4_, GTK_SHADOW_NONE);
	_tmp5_ = self->scrolledwindow;
	_tmp6_ = gtk_scrolled_window_get_vscrollbar (_tmp5_);
	_tmp7_ = gtk_widget_get_style_context (_tmp6_);
	gtk_style_context_add_class (_tmp7_, "light_scrollbar");
	_tmp8_ = self->home_page_box;
	_tmp9_ = self->scrolledwindow;
	gtk_box_pack_start (_tmp8_, (GtkWidget*) _tmp9_, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) ___lambda110__gtk_widget_realize, self, 0);
	_tmp10_ = self->focus_term;
	_tmp11_ = _tmp10_->term;
	_tmp12_ = vte_terminal_get_encoding (_tmp11_);
	_tmp13_ = self->parent_window;
	_tmp14_ = _tmp13_->config;
	_tmp15_ = _tmp14_->encoding_names;
	_tmp16_ = self->workspace;
	_tmp17_ = widgets_encoding_list_new (_tmp12_, _tmp15_, _tmp16_);
	g_object_ref_sink (_tmp17_);
	_data13_->encoding_list = _tmp17_;
	gtk_widget_set_margin_top ((GtkWidget*) _data13_->encoding_list, self->encoding_list_margin_top);
	gtk_widget_set_margin_bottom ((GtkWidget*) _data13_->encoding_list, self->encoding_list_margin_bottom);
	g_signal_connect_object (_data13_->encoding_list, "active-encoding", (GCallback) ___lambda112__widgets_encoding_list_active_encoding, self, 0);
	_tmp18_ = self->scrolledwindow;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) _data13_->encoding_list);
	_tmp19_ = self->switcher;
	_tmp20_ = self->home_page_box;
	widgets_switcher_add_to_left_box (_tmp19_, (GtkWidget*) _tmp20_);
	g_signal_connect_data ((GtkWidget*) self, "show", (GCallback) ___lambda113__gtk_widget_show, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	gtk_widget_show_all ((GtkWidget*) self);
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

void
widgets_encoding_panel_init_scrollbar (WidgetsEncodingPanel* self)
{
	GtkScrolledWindow* _tmp0_;
	GtkWidget* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkScrolledWindow* _tmp3_;
	GtkWidget* _tmp4_;
	GtkStyleContext* _tmp5_;
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->scrolledwindow;
	_tmp1_ = gtk_scrolled_window_get_vscrollbar (_tmp0_);
	_tmp2_ = gtk_widget_get_style_context (_tmp1_);
	gtk_style_context_remove_class (_tmp2_, "light_scrollbar");
	_tmp3_ = self->scrolledwindow;
	_tmp4_ = gtk_scrolled_window_get_vscrollbar (_tmp3_);
	_tmp5_ = gtk_widget_get_style_context (_tmp4_);
	gtk_style_context_remove_class (_tmp5_, "dark_scrollbar");
	_tmp6_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	if (is_light_theme) {
		GtkScrolledWindow* _tmp7_;
		GtkWidget* _tmp8_;
		GtkStyleContext* _tmp9_;
		_tmp7_ = self->scrolledwindow;
		_tmp8_ = gtk_scrolled_window_get_vscrollbar (_tmp7_);
		_tmp9_ = gtk_widget_get_style_context (_tmp8_);
		gtk_style_context_add_class (_tmp9_, "light_scrollbar");
	} else {
		GtkScrolledWindow* _tmp10_;
		GtkWidget* _tmp11_;
		GtkStyleContext* _tmp12_;
		_tmp10_ = self->scrolledwindow;
		_tmp11_ = gtk_scrolled_window_get_vscrollbar (_tmp10_);
		_tmp12_ = gtk_widget_get_style_context (_tmp11_);
		gtk_style_context_add_class (_tmp12_, "dark_scrollbar");
	}
}

static void
widgets_encoding_panel_class_init (WidgetsEncodingPanelClass * klass,
                                   gpointer klass_data)
{
	widgets_encoding_panel_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_encoding_panel_finalize;
}

static void
widgets_encoding_panel_instance_init (WidgetsEncodingPanel * self,
                                      gpointer klass)
{
	self->back_button_margin_left = 8;
	self->back_button_margin_top = 6;
	self->encoding_button_padding = 5;
	self->encoding_list_margin_bottom = 5;
	self->encoding_list_margin_top = 5;
	self->split_line_margin_left = 1;
	self->width = constant_ENCODING_SLIDER_WIDTH;
}

static void
widgets_encoding_panel_finalize (GObject * obj)
{
	WidgetsEncodingPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_ENCODING_PANEL, WidgetsEncodingPanel);
	_g_object_unref0 (self->switcher);
	_g_object_unref0 (self->parent_window);
	_g_object_unref0 (self->workspace);
	_g_object_unref0 (self->workspace_manager);
	_g_object_unref0 (self->home_page_box);
	_g_object_unref0 (self->scrolledwindow);
	_g_object_unref0 (self->focus_widget);
	_g_key_file_unref0 (self->config_file);
	_g_object_unref0 (self->focus_term);
	G_OBJECT_CLASS (widgets_encoding_panel_parent_class)->finalize (obj);
}

static GType
widgets_encoding_panel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsEncodingPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_encoding_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsEncodingPanel), 0, (GInstanceInitFunc) widgets_encoding_panel_instance_init, NULL };
	GType widgets_encoding_panel_type_id;
	widgets_encoding_panel_type_id = g_type_register_static (gtk_hbox_get_type (), "WidgetsEncodingPanel", &g_define_type_info, 0);
	return widgets_encoding_panel_type_id;
}

GType
widgets_encoding_panel_get_type (void)
{
	static volatile gsize widgets_encoding_panel_type_id__once = 0;
	if (g_once_init_enter (&widgets_encoding_panel_type_id__once)) {
		GType widgets_encoding_panel_type_id;
		widgets_encoding_panel_type_id = widgets_encoding_panel_get_type_once ();
		g_once_init_leave (&widgets_encoding_panel_type_id__once, widgets_encoding_panel_type_id);
	}
	return widgets_encoding_panel_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

