/* util.c generated by valac 0.56.18, the Vala compiler
 * generated from util.vala, do not modify */

#include "omemo.h"
#include <omemo/curve.h>
#include <native/helper.h>
#include <glib.h>
#include <omemo/signal_protocol.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <omemo/session_pre_key.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _signal_type_unref_vapi0(var) ((var == NULL) ? NULL : (var = (signal_type_unref_vapi (var), NULL)))
typedef gint (*OmemoCodeErroringFunc) (gpointer user_data, GError** error);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

static const char* _omemo_error_code_to_string (int value);
VALA_EXTERN gchar* omemo_carr_to_string (gchar* carr,
                             gint carr_length1);
VALA_EXTERN gint omemo_catch_to_code (OmemoCodeErroringFunc func,
                          gpointer func_target);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const char*
_omemo_error_code_to_string (int value)
{
	switch (value) {
		case SG_SUCCESS:
		return "SG_SUCCESS";
		case SG_ERR_NOMEM:
		return "SG_ERR_NOMEM";
		case SG_ERR_INVAL:
		return "SG_ERR_INVAL";
		case SG_ERR_UNKNOWN:
		return "SG_ERR_UNKNOWN";
		case SG_ERR_DUPLICATE_MESSAGE:
		return "SG_ERR_DUPLICATE_MESSAGE";
		case SG_ERR_INVALID_KEY:
		return "SG_ERR_INVALID_KEY";
		case SG_ERR_INVALID_KEY_ID:
		return "SG_ERR_INVALID_KEY_ID";
		case SG_ERR_INVALID_MAC:
		return "SG_ERR_INVALID_MAC";
		case SG_ERR_INVALID_MESSAGE:
		return "SG_ERR_INVALID_MESSAGE";
		case SG_ERR_INVALID_VERSION:
		return "SG_ERR_INVALID_VERSION";
		case SG_ERR_LEGACY_MESSAGE:
		return "SG_ERR_LEGACY_MESSAGE";
		case SG_ERR_NO_SESSION:
		return "SG_ERR_NO_SESSION";
		case SG_ERR_STALE_KEY_EXCHANGE:
		return "SG_ERR_STALE_KEY_EXCHANGE";
		case SG_ERR_UNTRUSTED_IDENTITY:
		return "SG_ERR_UNTRUSTED_IDENTITY";
		case SG_ERR_VRF_SIG_VERIF_FAILED:
		return "SG_ERR_VRF_SIG_VERIF_FAILED";
		case SG_ERR_INVALID_PROTO_BUF:
		return "SG_ERR_INVALID_PROTO_BUF";
		case SG_ERR_FP_VERSION_MISMATCH:
		return "SG_ERR_FP_VERSION_MISMATCH";
		case SG_ERR_FP_IDENT_MISMATCH:
		return "SG_ERR_FP_IDENT_MISMATCH";
	}
	return NULL;
}

static gint
signal_throw_gerror_by_code_ (gint code,
                              const gchar* message,
                              GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gint result;
	if (code < 0) {
		_tmp0_ = code > SG_ERR_MINIMUM;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GError* _tmp3_;
		gint _tmp4_ = -1;
		_tmp1_ = message;
		if (_tmp1_ == NULL) {
			_tmp1_ = "libomemo-c error";
		}
		_tmp2_ = _omemo_error_code_to_string ((int) code);
		_tmp3_ = g_error_new ((GQuark) -1, code, "%s: %s", _tmp1_, _tmp2_);
		_inner_error0_ = _tmp3_;
		g_propagate_error (error, _inner_error0_);
		return _tmp4_;
	}
	result = code;
	return result;
}

ec_public_key*
omemo_generate_public_key (ec_private_key* private_key,
                           GError** error)
{
	ec_public_key* public_key = NULL;
	ec_public_key* _tmp0_ = NULL;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	ec_public_key* result;
	g_return_val_if_fail (private_key != NULL, NULL);
	_tmp1_ = curve_generate_public_key (&_tmp0_, private_key);
	_signal_type_unref_vapi0 (public_key);
	public_key = _tmp0_;
	signal_throw_gerror_by_code_ (_tmp1_, "Error generating public key", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (public_key);
		return NULL;
	}
	result = public_key;
	return result;
}

guint8*
omemo_calculate_agreement (ec_public_key* public_key,
                           ec_private_key* private_key,
                           gint* result_length1,
                           GError** error)
{
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint len = 0;
	guint8* _tmp0_ = NULL;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	GError* _inner_error0_ = NULL;
	guint8* result;
	g_return_val_if_fail (public_key != NULL, NULL);
	g_return_val_if_fail (private_key != NULL, NULL);
	_tmp1_ = curve_calculate_agreement (&_tmp0_, public_key, private_key);
	res = (g_free (res), NULL);
	res = _tmp0_;
	res_length1 = -1;
	_res_size_ = res_length1;
	len = _tmp1_;
	signal_throw_gerror_by_code_ (len, "Error calculating agreement", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		res = (g_free (res), NULL);
		return NULL;
	}
	res_length1 = len;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

gboolean
omemo_verify_signature (ec_public_key* signing_key,
                        guint8* message,
                        gint message_length1,
                        guint8* signature,
                        gint signature_length1,
                        GError** error)
{
	gint _tmp0_ = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (signing_key != NULL, FALSE);
	_tmp0_ = signal_throw_gerror_by_code_ (curve_verify_signature (signing_key, message, (gint) message_length1, signature, (gint) signature_length1), NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	result = _tmp0_ == 1;
	return result;
}

session_pre_key_bundle*
omemo_create_pre_key_bundle (guint32 registration_id,
                             gint device_id,
                             guint32 pre_key_id,
                             ec_public_key* pre_key_public,
                             guint32 signed_pre_key_id,
                             ec_public_key* signed_pre_key_public,
                             guint8* signed_pre_key_signature,
                             gint signed_pre_key_signature_length1,
                             ec_public_key* identity_key,
                             GError** error)
{
	session_pre_key_bundle* res = NULL;
	session_pre_key_bundle* _tmp0_ = NULL;
	gint _tmp1_;
	GError* _inner_error0_ = NULL;
	session_pre_key_bundle* result;
	_tmp1_ = session_pre_key_bundle_create (&_tmp0_, registration_id, device_id, pre_key_id, pre_key_public, signed_pre_key_id, signed_pre_key_public, signed_pre_key_signature, (gint) signed_pre_key_signature_length1, identity_key);
	_signal_type_unref_vapi0 (res);
	res = _tmp0_;
	signal_throw_gerror_by_code_ (_tmp1_, "Error creating PreKeyBundle", &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_signal_type_unref_vapi0 (res);
		return NULL;
	}
	result = res;
	return result;
}

gchar*
omemo_carr_to_string (gchar* carr,
                      gint carr_length1)
{
	gchar* nu = NULL;
	gchar* _tmp0_;
	gint nu_length1;
	gint _nu_size_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, carr_length1 + 1);
	nu = _tmp0_;
	nu_length1 = carr_length1 + 1;
	_nu_size_ = nu_length1;
	memcpy (nu, carr, (gsize) carr_length1);
	_tmp1_ = g_strdup ((const gchar*) nu);
	result = _tmp1_;
	nu = (g_free (nu), NULL);
	return result;
}

gint
omemo_catch_to_code (OmemoCodeErroringFunc func,
                     gpointer func_target)
{
	gint _tmp2_ = -1;
	GError* _inner_error0_ = NULL;
	gint result;
	{
		gint _tmp0_ = 0;
		_tmp0_ = func (func_target, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		result = _tmp0_;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		result = _tmp1_->code;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp2_;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

