/* hsluv.c generated by valac 0.56.18, the Vala compiler
 * generated from hsluv.vala, do not modify */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include "xmpp-vala.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define HSLUV_TYPE_BOUNDS (hsluv_bounds_get_type ())
typedef struct _HsluvBounds HsluvBounds;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _HsluvBounds {
	gdouble t0;
	gdouble t1;
};

VALA_EXTERN gdouble hsluv_RefX;
gdouble hsluv_RefX = 0.95045592705167;
VALA_EXTERN gdouble hsluv_RefY;
gdouble hsluv_RefY = 1.0;
VALA_EXTERN gdouble hsluv_RefZ;
gdouble hsluv_RefZ = 1.089057750759878;
VALA_EXTERN gdouble hsluv_RefU;
gdouble hsluv_RefU = 0.19783000664283;
VALA_EXTERN gdouble hsluv_RefV;
gdouble hsluv_RefV = 0.46831999493879;
VALA_EXTERN gdouble hsluv_Kappa;
gdouble hsluv_Kappa = 903.2962962;
VALA_EXTERN gdouble hsluv_Epsilon;
gdouble hsluv_Epsilon = 0.0088564516;

VALA_EXTERN GType hsluv_bounds_get_type (void) G_GNUC_CONST ;
VALA_EXTERN HsluvBounds* hsluv_bounds_dup (const HsluvBounds* self);
VALA_EXTERN void hsluv_bounds_free (HsluvBounds* self);
VALA_EXTERN void hsluv_get_bounds_sub (gdouble L,
                           gdouble sub1,
                           gdouble sub2,
                           gint t,
                           gdouble* m,
                           gint m_length1,
                           HsluvBounds* result);
VALA_EXTERN HsluvBounds* hsluv_get_bounds (gdouble L,
                               gint* result_length1);
VALA_EXTERN gdouble hsluv_intersect_line_line (gdouble* lineA,
                                   gint lineA_length1,
                                   gdouble* lineB,
                                   gint lineB_length1);
VALA_EXTERN gdouble hsluv_distance_from_pole (gdouble* point,
                                  gint point_length1);
VALA_EXTERN gboolean hsluv_length_of_ray_until_intersect (gdouble theta,
                                              HsluvBounds* line,
                                              gdouble* length);
VALA_EXTERN gdouble hsluv_max_safe_chroma_for_l (gdouble L);
VALA_EXTERN gdouble hsluv_max_chroma_for_lh (gdouble L,
                                 gdouble H);
VALA_EXTERN gdouble hsluv_dot_product (gdouble* a,
                           gint a_length1,
                           gdouble* b,
                           gint b_length1);
VALA_EXTERN gdouble hsluv_round (gdouble value,
                     gint places);
VALA_EXTERN gdouble hsluv_from_linear (gdouble c);
VALA_EXTERN gdouble hsluv_to_linear (gdouble c);
VALA_EXTERN gint* hsluv_rgb_prepare (gdouble* tuple,
                         gint tuple_length1,
                         gint* result_length1);
VALA_EXTERN gdouble* hsluv_xyz_to_rgb (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_rgb_to_xyz (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble hsluv_y_to_l (gdouble Y);
VALA_EXTERN gdouble hsluv_l_to_y (gdouble L);
VALA_EXTERN gdouble* hsluv_xyz_to_luv (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_luv_to_xyz (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_luv_to_lch (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_lch_to_luv (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_hsluv_to_lch (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_lch_to_hsluv (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_hpluv_to_lch (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_lch_to_hpluv (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gchar* hsluv_rgb_to_hex (gdouble* tuple,
                         gint tuple_length1);
VALA_EXTERN gdouble* hsluv_hex_to_tgb (const gchar* hex,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_lch_to_rgb (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_rgb_to_lch (gdouble* tuple,
                           gint tuple_length1,
                           gint* result_length1);
VALA_EXTERN gdouble* hsluv_hsluv_to_rgb (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_rgb_to_hsluv (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_hpluv_to_rgb (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_rgb_to_hpluv (gdouble* tuple,
                             gint tuple_length1,
                             gint* result_length1);
VALA_EXTERN gchar* hsluv_hsluv_to_hex (gdouble* tuple,
                           gint tuple_length1);
VALA_EXTERN gchar* hsluv_hpluv_to_hex (gdouble* tuple,
                           gint tuple_length1);
VALA_EXTERN gdouble* hsluv_hex_to_hsluv (const gchar* s,
                             gint* result_length1);
VALA_EXTERN gdouble* hsluv_hex_to_hpluv (const gchar* s,
                             gint* result_length1);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

const gdouble HSLUV_M0[3] = {3.240969941904521, -1.537383177570093, -0.498610760293};
const gdouble HSLUV_M1[3] = {-0.96924363628087, 1.87596750150772, 0.041555057407175};
const gdouble HSLUV_M2[3] = {0.055630079696993, -0.20397695888897, 1.056971514242878};
const gdouble HSLUV_MInv0[3] = {0.41239079926595, 0.35758433938387, 0.18048078840183};
const gdouble HSLUV_MInv1[3] = {0.21263900587151, 0.71516867876775, 0.072192315360733};
const gdouble HSLUV_MInv2[3] = {0.019330818715591, 0.11919477979462, 0.95053215224966};

HsluvBounds*
hsluv_bounds_dup (const HsluvBounds* self)
{
	HsluvBounds* dup;
	dup = g_new0 (HsluvBounds, 1);
	memcpy (dup, self, sizeof (HsluvBounds));
	return dup;
}

void
hsluv_bounds_free (HsluvBounds* self)
{
	g_free (self);
}

static GType
hsluv_bounds_get_type_once (void)
{
	GType hsluv_bounds_type_id;
	hsluv_bounds_type_id = g_boxed_type_register_static ("HsluvBounds", (GBoxedCopyFunc) hsluv_bounds_dup, (GBoxedFreeFunc) hsluv_bounds_free);
	return hsluv_bounds_type_id;
}

GType
hsluv_bounds_get_type (void)
{
	static volatile gsize hsluv_bounds_type_id__once = 0;
	if (g_once_init_enter (&hsluv_bounds_type_id__once)) {
		GType hsluv_bounds_type_id;
		hsluv_bounds_type_id = hsluv_bounds_get_type_once ();
		g_once_init_leave (&hsluv_bounds_type_id__once, hsluv_bounds_type_id);
	}
	return hsluv_bounds_type_id__once;
}

void
hsluv_get_bounds_sub (gdouble L,
                      gdouble sub1,
                      gdouble sub2,
                      gint t,
                      gdouble* m,
                      gint m_length1,
                      HsluvBounds* result)
{
	gdouble m1 = 0.0;
	gdouble _tmp0_;
	gdouble m2 = 0.0;
	gdouble _tmp1_;
	gdouble m3 = 0.0;
	gdouble _tmp2_;
	gdouble top1 = 0.0;
	gdouble top2 = 0.0;
	gdouble bottom = 0.0;
	HsluvBounds _tmp3_ = {0};
	_tmp0_ = m[0];
	m1 = _tmp0_;
	_tmp1_ = m[1];
	m2 = _tmp1_;
	_tmp2_ = m[2];
	m3 = _tmp2_;
	top1 = ((284517 * m1) - (94839 * m3)) * sub2;
	top2 = (((((838422 * m3) + (769860 * m2)) + (731718 * m1)) * L) * sub2) - ((769860 * t) * L);
	bottom = (((632260 * m3) - (126452 * m2)) * sub2) + (126452 * t);
	_tmp3_.t0 = top1 / bottom;
	_tmp3_.t1 = top2 / bottom;
	*result = _tmp3_;
	return;
}

HsluvBounds*
hsluv_get_bounds (gdouble L,
                  gint* result_length1)
{
	gdouble sub1 = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble sub2 = 0.0;
	HsluvBounds _tmp1_ = {0};
	HsluvBounds _tmp2_ = {0};
	HsluvBounds _tmp3_ = {0};
	HsluvBounds _tmp4_ = {0};
	HsluvBounds _tmp5_ = {0};
	HsluvBounds _tmp6_ = {0};
	HsluvBounds* _tmp7_;
	HsluvBounds* _tmp8_;
	gint _tmp8__length1;
	HsluvBounds* result;
	sub1 = pow (L + 16, (gdouble) 3) / 1560896;
	if (sub1 > hsluv_Epsilon) {
		_tmp0_ = sub1;
	} else {
		_tmp0_ = L / hsluv_Kappa;
	}
	sub2 = _tmp0_;
	hsluv_get_bounds_sub (L, sub1, sub2, 0, HSLUV_M0, (gint) G_N_ELEMENTS (HSLUV_M0), &_tmp1_);
	hsluv_get_bounds_sub (L, sub1, sub2, 1, HSLUV_M0, (gint) G_N_ELEMENTS (HSLUV_M0), &_tmp2_);
	hsluv_get_bounds_sub (L, sub1, sub2, 0, HSLUV_M1, (gint) G_N_ELEMENTS (HSLUV_M1), &_tmp3_);
	hsluv_get_bounds_sub (L, sub1, sub2, 1, HSLUV_M1, (gint) G_N_ELEMENTS (HSLUV_M1), &_tmp4_);
	hsluv_get_bounds_sub (L, sub1, sub2, 0, HSLUV_M2, (gint) G_N_ELEMENTS (HSLUV_M2), &_tmp5_);
	hsluv_get_bounds_sub (L, sub1, sub2, 1, HSLUV_M2, (gint) G_N_ELEMENTS (HSLUV_M2), &_tmp6_);
	_tmp7_ = g_new0 (HsluvBounds, 6);
	_tmp7_[0] = _tmp1_;
	_tmp7_[1] = _tmp2_;
	_tmp7_[2] = _tmp3_;
	_tmp7_[3] = _tmp4_;
	_tmp7_[4] = _tmp5_;
	_tmp7_[5] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 6;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

gdouble
hsluv_intersect_line_line (gdouble* lineA,
                           gint lineA_length1,
                           gdouble* lineB,
                           gint lineB_length1)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble result;
	_tmp0_ = lineA[1];
	_tmp1_ = lineB[1];
	_tmp2_ = lineB[0];
	_tmp3_ = lineA[0];
	result = (_tmp0_ - _tmp1_) / (_tmp2_ - _tmp3_);
	return result;
}

gdouble
hsluv_distance_from_pole (gdouble* point,
                          gint point_length1)
{
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble result;
	_tmp0_ = point[0];
	_tmp1_ = point[1];
	result = sqrt (pow (_tmp0_, (gdouble) 2) + pow (_tmp1_, (gdouble) 2));
	return result;
}

gboolean
hsluv_length_of_ray_until_intersect (gdouble theta,
                                     HsluvBounds* line,
                                     gdouble* length)
{
	gdouble _vala_length = 0.0;
	HsluvBounds _tmp0_;
	HsluvBounds _tmp1_;
	gboolean result;
	g_return_val_if_fail (line != NULL, FALSE);
	_tmp0_ = *line;
	_tmp1_ = *line;
	_vala_length = _tmp0_.t1 / (sin (theta) - (_tmp1_.t0 * cos (theta)));
	result = _vala_length >= ((gdouble) 0);
	if (length) {
		*length = _vala_length;
	}
	return result;
}

gdouble
hsluv_max_safe_chroma_for_l (gdouble L)
{
	HsluvBounds* bounds = NULL;
	gint _tmp0_ = 0;
	HsluvBounds* _tmp1_;
	gint bounds_length1;
	gint _bounds_size_;
	gdouble min = 0.0;
	gdouble result;
	_tmp1_ = hsluv_get_bounds (L, &_tmp0_);
	bounds = _tmp1_;
	bounds_length1 = _tmp0_;
	_bounds_size_ = bounds_length1;
	min = DBL_MAX;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gdouble m1 = 0.0;
				HsluvBounds* _tmp4_;
				gint _tmp4__length1;
				HsluvBounds _tmp5_;
				gdouble b1 = 0.0;
				HsluvBounds* _tmp6_;
				gint _tmp6__length1;
				HsluvBounds _tmp7_;
				gdouble* line = NULL;
				gdouble* _tmp8_;
				gint line_length1;
				gint _line_size_;
				gdouble x = 0.0;
				gdouble* _tmp9_;
				gint _tmp9__length1;
				gdouble* _tmp10_;
				gdouble* _tmp11_;
				gint _tmp11__length1;
				gdouble _tmp12_;
				gdouble length = 0.0;
				gdouble* _tmp13_;
				gdouble* _tmp14_;
				gint _tmp14__length1;
				gdouble _tmp15_;
				if (!_tmp2_) {
					gint _tmp3_;
					i = i + 1;
					_tmp3_ = i;
				}
				_tmp2_ = FALSE;
				if (!(i < 2)) {
					break;
				}
				_tmp4_ = bounds;
				_tmp4__length1 = bounds_length1;
				_tmp5_ = _tmp4_[i];
				m1 = _tmp5_.t0;
				_tmp6_ = bounds;
				_tmp6__length1 = bounds_length1;
				_tmp7_ = _tmp6_[i];
				b1 = _tmp7_.t1;
				_tmp8_ = g_new0 (gdouble, 2);
				_tmp8_[0] = m1;
				_tmp8_[1] = b1;
				line = _tmp8_;
				line_length1 = 2;
				_line_size_ = line_length1;
				_tmp9_ = line;
				_tmp9__length1 = line_length1;
				_tmp10_ = g_new0 (gdouble, 2);
				_tmp10_[0] = -1 / m1;
				_tmp10_[1] = (gdouble) 0;
				_tmp11_ = _tmp10_;
				_tmp11__length1 = 2;
				_tmp12_ = hsluv_intersect_line_line (_tmp9_, (gint) _tmp9__length1, _tmp11_, (gint) 2);
				_tmp11_ = (g_free (_tmp11_), NULL);
				x = _tmp12_;
				_tmp13_ = g_new0 (gdouble, 2);
				_tmp13_[0] = x;
				_tmp13_[1] = b1 + (x * m1);
				_tmp14_ = _tmp13_;
				_tmp14__length1 = 2;
				_tmp15_ = hsluv_distance_from_pole (_tmp14_, (gint) 2);
				_tmp14_ = (g_free (_tmp14_), NULL);
				length = _tmp15_;
				min = MIN (min, length);
				line = (g_free (line), NULL);
			}
		}
	}
	result = min;
	bounds = (g_free (bounds), NULL);
	return result;
}

gdouble
hsluv_max_chroma_for_lh (gdouble L,
                         gdouble H)
{
	gdouble hrad = 0.0;
	HsluvBounds* bounds = NULL;
	gint _tmp0_ = 0;
	HsluvBounds* _tmp1_;
	gint bounds_length1;
	gint _bounds_size_;
	gdouble min = 0.0;
	HsluvBounds* _tmp2_;
	gint _tmp2__length1;
	gdouble result;
	hrad = ((H / 360) * G_PI) * 2;
	_tmp1_ = hsluv_get_bounds (L, &_tmp0_);
	bounds = _tmp1_;
	bounds_length1 = _tmp0_;
	_bounds_size_ = bounds_length1;
	min = DBL_MAX;
	_tmp2_ = bounds;
	_tmp2__length1 = bounds_length1;
	{
		HsluvBounds* bound_collection = NULL;
		gint bound_collection_length1 = 0;
		gint _bound_collection_size_ = 0;
		gint bound_it = 0;
		bound_collection = _tmp2_;
		bound_collection_length1 = _tmp2__length1;
		for (bound_it = 0; bound_it < bound_collection_length1; bound_it = bound_it + 1) {
			HsluvBounds bound = {0};
			bound = bound_collection[bound_it];
			{
				gdouble length = 0.0;
				HsluvBounds _tmp3_;
				gdouble _tmp4_ = 0.0;
				gboolean _tmp5_;
				_tmp3_ = bound;
				_tmp5_ = hsluv_length_of_ray_until_intersect (hrad, &_tmp3_, &_tmp4_);
				length = _tmp4_;
				if (_tmp5_) {
					min = MIN (min, length);
				}
			}
		}
	}
	result = min;
	bounds = (g_free (bounds), NULL);
	return result;
}

gdouble
hsluv_dot_product (gdouble* a,
                   gint a_length1,
                   gdouble* b,
                   gint b_length1)
{
	gdouble sum = 0.0;
	gdouble result;
	sum = (gdouble) 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_;
				gdouble _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				if (!(i < a_length1)) {
					break;
				}
				_tmp2_ = a[i];
				_tmp3_ = b[i];
				sum += _tmp2_ * _tmp3_;
			}
		}
	}
	result = sum;
	return result;
}

gdouble
hsluv_round (gdouble value,
             gint places)
{
	gdouble n = 0.0;
	gdouble result;
	n = pow ((gdouble) 10, (gdouble) places);
	result = round (value * n) / n;
	return result;
}

gdouble
hsluv_from_linear (gdouble c)
{
	gdouble result;
	if (c <= 0.0031308) {
		result = 12.92 * c;
		return result;
	} else {
		result = (1.055 * pow (c, 1 / 2.4)) - 0.055;
		return result;
	}
}

gdouble
hsluv_to_linear (gdouble c)
{
	gdouble result;
	if (c > 0.04045) {
		result = pow ((c + 0.055) / (1 + 0.055), 2.4);
		return result;
	} else {
		result = c / 12.92;
		return result;
	}
}

gint*
hsluv_rgb_prepare (gdouble* tuple,
                   gint tuple_length1,
                   gint* result_length1)
{
	gint* results = NULL;
	gint* _tmp8_;
	gint results_length1;
	gint _results_size_;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint* result;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gdouble _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					i = i + 1;
					_tmp1_ = i;
				}
				_tmp0_ = FALSE;
				if (!(i < tuple_length1)) {
					break;
				}
				_tmp2_ = tuple[i];
				tuple[i] = hsluv_round (_tmp2_, 3);
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gdouble ch = 0.0;
				gdouble _tmp5_;
				gboolean _tmp6_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					i = i + 1;
					_tmp4_ = i;
				}
				_tmp3_ = FALSE;
				if (!(i < tuple_length1)) {
					break;
				}
				_tmp5_ = tuple[i];
				ch = _tmp5_;
				if (ch < (-0.0001)) {
					_tmp6_ = TRUE;
				} else {
					_tmp6_ = ch > 1.0001;
				}
				if (_tmp6_) {
					gint* _tmp7_;
					gint _tmp7__length1;
					_tmp7_ = NULL;
					_tmp7__length1 = 0;
					if (result_length1) {
						*result_length1 = _tmp7__length1;
					}
					result = _tmp7_;
					return result;
				}
			}
		}
	}
	_tmp8_ = g_new0 (gint, tuple_length1);
	results = _tmp8_;
	results_length1 = tuple_length1;
	_results_size_ = results_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint* _tmp11_;
				gint _tmp11__length1;
				gdouble _tmp12_;
				if (!_tmp9_) {
					gint _tmp10_;
					i = i + 1;
					_tmp10_ = i;
				}
				_tmp9_ = FALSE;
				if (!(i < tuple_length1)) {
					break;
				}
				_tmp11_ = results;
				_tmp11__length1 = results_length1;
				_tmp12_ = tuple[i];
				_tmp11_[i] = (gint) round (_tmp12_ * 255);
			}
		}
	}
	_tmp13_ = results;
	_tmp13__length1 = results_length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	return result;
}

gdouble*
hsluv_xyz_to_rgb (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gdouble* _tmp0_;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* result;
	_tmp0_ = g_new0 (gdouble, 3);
	_tmp0_[0] = hsluv_from_linear (hsluv_dot_product (HSLUV_M0, (gint) G_N_ELEMENTS (HSLUV_M0), tuple, (gint) tuple_length1));
	_tmp0_[1] = hsluv_from_linear (hsluv_dot_product (HSLUV_M1, (gint) G_N_ELEMENTS (HSLUV_M1), tuple, (gint) tuple_length1));
	_tmp0_[2] = hsluv_from_linear (hsluv_dot_product (HSLUV_M2, (gint) G_N_ELEMENTS (HSLUV_M2), tuple, (gint) tuple_length1));
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

gdouble*
hsluv_rgb_to_xyz (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gdouble* rgbl = NULL;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble* _tmp3_;
	gint rgbl_length1;
	gint _rgbl_size_;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	_tmp1_ = tuple[1];
	_tmp2_ = tuple[2];
	_tmp3_ = g_new0 (gdouble, 3);
	_tmp3_[0] = hsluv_to_linear (_tmp0_);
	_tmp3_[1] = hsluv_to_linear (_tmp1_);
	_tmp3_[2] = hsluv_to_linear (_tmp2_);
	rgbl = _tmp3_;
	rgbl_length1 = 3;
	_rgbl_size_ = rgbl_length1;
	_tmp4_ = g_new0 (gdouble, 3);
	_tmp4_[0] = hsluv_dot_product (HSLUV_MInv0, (gint) G_N_ELEMENTS (HSLUV_MInv0), rgbl, (gint) rgbl_length1);
	_tmp4_[1] = hsluv_dot_product (HSLUV_MInv1, (gint) G_N_ELEMENTS (HSLUV_MInv1), rgbl, (gint) rgbl_length1);
	_tmp4_[2] = hsluv_dot_product (HSLUV_MInv2, (gint) G_N_ELEMENTS (HSLUV_MInv2), rgbl, (gint) rgbl_length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	rgbl = (g_free (rgbl), NULL);
	return result;
}

gdouble
hsluv_y_to_l (gdouble Y)
{
	gdouble result;
	if (Y <= hsluv_Epsilon) {
		result = (Y / hsluv_RefY) * hsluv_Kappa;
		return result;
	} else {
		result = (116 * pow (Y / hsluv_RefY, 1.0 / 3.0)) - 16;
		return result;
	}
}

gdouble
hsluv_l_to_y (gdouble L)
{
	gdouble result;
	if (L <= ((gdouble) 8)) {
		result = (hsluv_RefY * L) / hsluv_Kappa;
		return result;
	} else {
		result = hsluv_RefY * pow ((L + 16) / 116, (gdouble) 3);
		return result;
	}
}

gdouble*
hsluv_xyz_to_luv (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gdouble X = 0.0;
	gdouble _tmp0_;
	gdouble Y = 0.0;
	gdouble _tmp1_;
	gdouble Z = 0.0;
	gdouble _tmp2_;
	gdouble varU = 0.0;
	gdouble varV = 0.0;
	gdouble L = 0.0;
	gdouble U = 0.0;
	gdouble V = 0.0;
	gdouble* _tmp5_;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	X = _tmp0_;
	_tmp1_ = tuple[1];
	Y = _tmp1_;
	_tmp2_ = tuple[2];
	Z = _tmp2_;
	varU = (4 * X) / ((X + (15 * Y)) + (3 * Z));
	varV = (9 * Y) / ((X + (15 * Y)) + (3 * Z));
	L = hsluv_y_to_l (Y);
	if (L == ((gdouble) 0)) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 3);
		_tmp3_[0] = (gdouble) 0;
		_tmp3_[1] = (gdouble) 0;
		_tmp3_[2] = (gdouble) 0;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	U = (13 * L) * (varU - hsluv_RefU);
	V = (13 * L) * (varV - hsluv_RefV);
	_tmp5_ = g_new0 (gdouble, 3);
	_tmp5_[0] = L;
	_tmp5_[1] = U;
	_tmp5_[2] = V;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gdouble*
hsluv_luv_to_xyz (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gdouble L = 0.0;
	gdouble _tmp0_;
	gdouble U = 0.0;
	gdouble _tmp1_;
	gdouble V = 0.0;
	gdouble _tmp2_;
	gdouble varU = 0.0;
	gdouble varV = 0.0;
	gdouble Y = 0.0;
	gdouble X = 0.0;
	gdouble Z = 0.0;
	gdouble* _tmp5_;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	L = _tmp0_;
	_tmp1_ = tuple[1];
	U = _tmp1_;
	_tmp2_ = tuple[2];
	V = _tmp2_;
	if (L == ((gdouble) 0)) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 3);
		_tmp3_[0] = (gdouble) 0;
		_tmp3_[1] = (gdouble) 0;
		_tmp3_[2] = (gdouble) 0;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	varU = (U / (13 * L)) + hsluv_RefU;
	varV = (V / (13 * L)) + hsluv_RefV;
	Y = hsluv_l_to_y (L);
	X = 0 - (((9 * Y) * varU) / (((varU - 4) * varV) - (varU * varV)));
	Z = (((9 * Y) - ((15 * varV) * Y)) - (varV * X)) / (3 * varV);
	_tmp5_ = g_new0 (gdouble, 3);
	_tmp5_[0] = X;
	_tmp5_[1] = Y;
	_tmp5_[2] = Z;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gdouble*
hsluv_luv_to_lch (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gdouble L = 0.0;
	gdouble _tmp0_;
	gdouble U = 0.0;
	gdouble _tmp1_;
	gdouble V = 0.0;
	gdouble _tmp2_;
	gdouble C = 0.0;
	gdouble Hrad = 0.0;
	gdouble H = 0.0;
	gdouble* _tmp3_;
	gdouble* _tmp4_;
	gint _tmp4__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	L = _tmp0_;
	_tmp1_ = tuple[1];
	U = _tmp1_;
	_tmp2_ = tuple[2];
	V = _tmp2_;
	C = pow (pow (U, (gdouble) 2) + pow (V, (gdouble) 2), 0.5);
	Hrad = atan2 (V, U);
	H = (Hrad * 180.0) / G_PI;
	if (H < ((gdouble) 0)) {
		H = 360 + H;
	}
	_tmp3_ = g_new0 (gdouble, 3);
	_tmp3_[0] = L;
	_tmp3_[1] = C;
	_tmp3_[2] = H;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

gdouble*
hsluv_lch_to_luv (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gdouble L = 0.0;
	gdouble _tmp0_;
	gdouble C = 0.0;
	gdouble _tmp1_;
	gdouble H = 0.0;
	gdouble _tmp2_;
	gdouble Hrad = 0.0;
	gdouble U = 0.0;
	gdouble V = 0.0;
	gdouble* _tmp3_;
	gdouble* _tmp4_;
	gint _tmp4__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	L = _tmp0_;
	_tmp1_ = tuple[1];
	C = _tmp1_;
	_tmp2_ = tuple[2];
	H = _tmp2_;
	Hrad = ((H / 360.0) * 2) * G_PI;
	U = cos (Hrad) * C;
	V = sin (Hrad) * C;
	_tmp3_ = g_new0 (gdouble, 3);
	_tmp3_[0] = L;
	_tmp3_[1] = U;
	_tmp3_[2] = V;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

gdouble*
hsluv_hsluv_to_lch (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gdouble H = 0.0;
	gdouble _tmp0_;
	gdouble S = 0.0;
	gdouble _tmp1_;
	gdouble L = 0.0;
	gdouble _tmp2_;
	gdouble max = 0.0;
	gdouble C = 0.0;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	H = _tmp0_;
	_tmp1_ = tuple[1];
	S = _tmp1_;
	_tmp2_ = tuple[2];
	L = _tmp2_;
	if (L > 99.9999999) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 3);
		_tmp3_[0] = (gdouble) 100;
		_tmp3_[1] = (gdouble) 0;
		_tmp3_[2] = H;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	if (L < 0.00000001) {
		gdouble* _tmp5_;
		gdouble* _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = g_new0 (gdouble, 3);
		_tmp5_[0] = (gdouble) 0;
		_tmp5_[1] = (gdouble) 0;
		_tmp5_[2] = H;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		return result;
	}
	max = hsluv_max_chroma_for_lh (L, H);
	C = (max / 100) * S;
	_tmp7_ = g_new0 (gdouble, 3);
	_tmp7_[0] = L;
	_tmp7_[1] = C;
	_tmp7_[2] = H;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

gdouble*
hsluv_lch_to_hsluv (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gdouble L = 0.0;
	gdouble _tmp0_;
	gdouble C = 0.0;
	gdouble _tmp1_;
	gdouble H = 0.0;
	gdouble _tmp2_;
	gdouble max = 0.0;
	gdouble S = 0.0;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	L = _tmp0_;
	_tmp1_ = tuple[1];
	C = _tmp1_;
	_tmp2_ = tuple[2];
	H = _tmp2_;
	if (L > 99.9999999) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 3);
		_tmp3_[0] = H;
		_tmp3_[1] = (gdouble) 0;
		_tmp3_[2] = (gdouble) 100;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	if (L < 0.00000001) {
		gdouble* _tmp5_;
		gdouble* _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = g_new0 (gdouble, 3);
		_tmp5_[0] = H;
		_tmp5_[1] = (gdouble) 0;
		_tmp5_[2] = (gdouble) 0;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		return result;
	}
	max = hsluv_max_chroma_for_lh (L, H);
	S = (C / max) * 100;
	_tmp7_ = g_new0 (gdouble, 3);
	_tmp7_[0] = H;
	_tmp7_[1] = S;
	_tmp7_[2] = L;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

gdouble*
hsluv_hpluv_to_lch (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gdouble H = 0.0;
	gdouble _tmp0_;
	gdouble S = 0.0;
	gdouble _tmp1_;
	gdouble L = 0.0;
	gdouble _tmp2_;
	gdouble max = 0.0;
	gdouble C = 0.0;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	H = _tmp0_;
	_tmp1_ = tuple[1];
	S = _tmp1_;
	_tmp2_ = tuple[2];
	L = _tmp2_;
	if (L > 99.9999999) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 3);
		_tmp3_[0] = (gdouble) 100;
		_tmp3_[1] = (gdouble) 0;
		_tmp3_[2] = H;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	if (L < 0.00000001) {
		gdouble* _tmp5_;
		gdouble* _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = g_new0 (gdouble, 3);
		_tmp5_[0] = (gdouble) 0;
		_tmp5_[1] = (gdouble) 0;
		_tmp5_[2] = H;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		return result;
	}
	max = hsluv_max_safe_chroma_for_l (L);
	C = (max / 100) * S;
	_tmp7_ = g_new0 (gdouble, 3);
	_tmp7_[0] = L;
	_tmp7_[1] = C;
	_tmp7_[2] = H;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

gdouble*
hsluv_lch_to_hpluv (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gdouble L = 0.0;
	gdouble _tmp0_;
	gdouble C = 0.0;
	gdouble _tmp1_;
	gdouble H = 0.0;
	gdouble _tmp2_;
	gdouble max = 0.0;
	gdouble S = 0.0;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* result;
	_tmp0_ = tuple[0];
	L = _tmp0_;
	_tmp1_ = tuple[1];
	C = _tmp1_;
	_tmp2_ = tuple[2];
	H = _tmp2_;
	if (L > 99.9999999) {
		gdouble* _tmp3_;
		gdouble* _tmp4_;
		gint _tmp4__length1;
		_tmp3_ = g_new0 (gdouble, 3);
		_tmp3_[0] = H;
		_tmp3_[1] = (gdouble) 0;
		_tmp3_[2] = (gdouble) 100;
		_tmp4_ = _tmp3_;
		_tmp4__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp4__length1;
		}
		result = _tmp4_;
		return result;
	}
	if (L < 0.00000001) {
		gdouble* _tmp5_;
		gdouble* _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = g_new0 (gdouble, 3);
		_tmp5_[0] = H;
		_tmp5_[1] = (gdouble) 0;
		_tmp5_[2] = (gdouble) 0;
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 3;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		return result;
	}
	max = hsluv_max_safe_chroma_for_l (L);
	S = (C / max) * 100;
	_tmp7_ = g_new0 (gdouble, 3);
	_tmp7_[0] = H;
	_tmp7_[1] = S;
	_tmp7_[2] = L;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 3;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

gchar*
hsluv_rgb_to_hex (gdouble* tuple,
                  gint tuple_length1)
{
	gint* prepared = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint prepared_length1;
	gint _prepared_size_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp1_ = hsluv_rgb_prepare (tuple, (gint) tuple_length1, &_tmp0_);
	prepared = _tmp1_;
	prepared_length1 = _tmp0_;
	_prepared_size_ = prepared_length1;
	_tmp2_ = prepared[0];
	_tmp3_ = prepared[1];
	_tmp4_ = prepared[2];
	_tmp5_ = g_strdup_printf ("#%.2x%.2x%.2x", (guint) _tmp2_, (guint) _tmp3_, (guint) _tmp4_);
	result = _tmp5_;
	prepared = (g_free (prepared), NULL);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gdouble*
hsluv_hex_to_tgb (const gchar* hex,
                  gint* result_length1)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gdouble* _tmp6_;
	gdouble* _tmp7_;
	gint _tmp7__length1;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* result;
	g_return_val_if_fail (hex != NULL, NULL);
	_tmp0_ = string_substring (hex, (glong) 1, (glong) 2);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_substring (hex, (glong) 3, (glong) 2);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_substring (hex, (glong) 5, (glong) 2);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_new0 (gdouble, 3);
	_tmp6_[0] = strtol (_tmp1_, NULL, 16) / 255.0;
	_tmp6_[1] = strtol (_tmp3_, NULL, 16) / 255.0;
	_tmp6_[2] = strtol (_tmp5_, NULL, 16) / 255.0;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 3;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

gdouble*
hsluv_lch_to_rgb (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble* result;
	_tmp1_ = hsluv_lch_to_luv (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_luv_to_xyz (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp7_ = hsluv_xyz_to_rgb (_tmp5_, (gint) _tmp3_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

gdouble*
hsluv_rgb_to_lch (gdouble* tuple,
                  gint tuple_length1,
                  gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	gdouble* _tmp7_;
	gdouble* _tmp8_;
	gint _tmp8__length1;
	gdouble* _tmp9_;
	gint _tmp9__length1;
	gdouble* result;
	_tmp1_ = hsluv_rgb_to_xyz (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_xyz_to_luv (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp7_ = hsluv_luv_to_lch (_tmp5_, (gint) _tmp3_, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	if (result_length1) {
		*result_length1 = _tmp9__length1;
	}
	result = _tmp9_;
	return result;
}

gdouble*
hsluv_hsluv_to_rgb (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	_tmp1_ = hsluv_hsluv_to_lch (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_lch_to_rgb (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gdouble*
hsluv_rgb_to_hsluv (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	_tmp1_ = hsluv_rgb_to_lch (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_lch_to_hsluv (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gdouble*
hsluv_hpluv_to_rgb (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	_tmp1_ = hsluv_hpluv_to_lch (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_lch_to_rgb (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gdouble*
hsluv_rgb_to_hpluv (gdouble* tuple,
                    gint tuple_length1,
                    gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	_tmp1_ = hsluv_rgb_to_lch (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_lch_to_hpluv (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gchar*
hsluv_hsluv_to_hex (gdouble* tuple,
                    gint tuple_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp1_ = hsluv_hsluv_to_rgb (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = hsluv_rgb_to_hex (_tmp2_, (gint) _tmp0_);
	_tmp4_ = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp4_;
	return result;
}

gchar*
hsluv_hpluv_to_hex (gdouble* tuple,
                    gint tuple_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp1_ = hsluv_hpluv_to_rgb (tuple, (gint) tuple_length1, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = hsluv_rgb_to_hex (_tmp2_, (gint) _tmp0_);
	_tmp4_ = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp4_;
	return result;
}

gdouble*
hsluv_hex_to_hsluv (const gchar* s,
                    gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp1_ = hsluv_hex_to_tgb (s, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_rgb_to_hsluv (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

gdouble*
hsluv_hex_to_hpluv (const gchar* s,
                    gint* result_length1)
{
	gint _tmp0_ = 0;
	gdouble* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_ = 0;
	gdouble* _tmp4_;
	gdouble* _tmp5_;
	gint _tmp5__length1;
	gdouble* _tmp6_;
	gint _tmp6__length1;
	gdouble* result;
	g_return_val_if_fail (s != NULL, NULL);
	_tmp1_ = hsluv_hex_to_tgb (s, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp4_ = hsluv_rgb_to_hpluv (_tmp2_, (gint) _tmp0_, &_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp3_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

