// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/******************************************************************

DO NOT MODIFY. AUTOGENERATED FILE.
This file is generated using the logic from <root>/src/scripts/genEventPipe.py

******************************************************************/

#include <common.h>
#include "eventpipeadapter.h"

#if defined(TARGET_UNIX)
#define wcslen PAL_wcslen
#endif

bool ResizeBuffer(BYTE *&buffer, size_t& size, size_t currLen, size_t newSize, bool &fixedBuffer);
bool WriteToBuffer(PCWSTR str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const char *str, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);
bool WriteToBuffer(const BYTE *src, size_t len, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer);

template <typename T>
bool WriteToBuffer(const T &value, BYTE *&buffer, size_t& offset, size_t& size, bool &fixedBuffer)
{
    if (sizeof(T) + offset > size)
    {
        if (!ResizeBuffer(buffer, size, offset, size + sizeof(T), fixedBuffer))
            return false;
    }

    memcpy(buffer + offset, (char *)&value, sizeof(T));
    offset += sizeof(T);
    return true;
}

const WCHAR* DotNETRuntimeStressName = W("Microsoft-Windows-DotNETRuntimeStress");
EventPipeProvider *EventPipeProviderDotNETRuntimeStress = nullptr;
EventPipeEvent *EventPipeEventStressLogEvent = nullptr;
EventPipeEvent *EventPipeEventStressLogEvent_V1 = nullptr;
EventPipeEvent *EventPipeEventCLRStackWalkStress = nullptr;

BOOL EventPipeEventEnabledStressLogEvent(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventStressLogEvent);
}

extern "C" ULONG EventPipeWriteEventStressLogEvent(
    const unsigned int Facility,
    const unsigned char LogLevel,
    LPCSTR Message,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledStressLogEvent())
        return ERROR_SUCCESS;

    size_t size = 37;
    BYTE stackBuffer[37];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Facility, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LogLevel, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Message, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventStressLogEvent, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledStressLogEvent_V1(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventStressLogEvent_V1);
}

extern "C" ULONG EventPipeWriteEventStressLogEvent_V1(
    const unsigned int Facility,
    const unsigned char LogLevel,
    LPCSTR Message,
    const unsigned short ClrInstanceID,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledStressLogEvent_V1())
        return ERROR_SUCCESS;

    size_t size = 39;
    BYTE stackBuffer[39];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(Facility, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(LogLevel, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Message, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventStressLogEvent_V1, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

BOOL EventPipeEventEnabledCLRStackWalkStress(void)
{
    return EventPipeAdapter::EventIsEnabled(EventPipeEventCLRStackWalkStress);
}

extern "C" ULONG EventPipeWriteEventCLRStackWalkStress(
    const unsigned short ClrInstanceID,
    const unsigned char Reserved1,
    const unsigned char Reserved2,
    const unsigned int FrameCount,
    const void** Stack,
    LPCGUID ActivityId,
    LPCGUID RelatedActivityId)
{
    if (!EventPipeEventEnabledCLRStackWalkStress())
        return ERROR_SUCCESS;

    size_t size = 32;
    BYTE stackBuffer[32];
    BYTE *buffer = stackBuffer;
    size_t offset = 0;
    bool fixedBuffer = true;
    bool success = true;

    success &= WriteToBuffer(ClrInstanceID, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved1, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Reserved2, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(FrameCount, buffer, offset, size, fixedBuffer);
    success &= WriteToBuffer(Stack, buffer, offset, size, fixedBuffer);

    if (!success)
    {
        if (!fixedBuffer)
            delete[] buffer;
        return ERROR_WRITE_FAULT;
    }

    EventPipeAdapter::WriteEvent(EventPipeEventCLRStackWalkStress, (BYTE *)buffer, (unsigned int)offset, ActivityId, RelatedActivityId);

    if (!fixedBuffer)
        delete[] buffer;


    return ERROR_SUCCESS;
}

extern "C" void InitDotNETRuntimeStress(void);

extern "C" void InitDotNETRuntimeStress(void)
{
    EventPipeProviderDotNETRuntimeStress = EventPipeAdapter::CreateProvider(SL(DotNETRuntimeStressName), reinterpret_cast<EventPipeCallback>(EventPipeEtwCallbackDotNETRuntimeStress));
    EventPipeEventStressLogEvent = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeStress,0,0,0,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventStressLogEvent_V1 = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeStress,0,0,1,EP_EVENT_LEVEL_INFORMATIONAL,true);
    EventPipeEventCLRStackWalkStress = EventPipeAdapter::AddEvent(EventPipeProviderDotNETRuntimeStress,1,1073741824,0,EP_EVENT_LEVEL_LOGALWAYS,true);
}
