#line 1 "/build/ecl/src/ecl-24.5.10/src/c/load.d"
/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*- */
/* vim: set filetype=c tabstop=2 shiftwidth=2 expandtab: */

/*
 * load.d - binary loader (contains also open_fasl_data)
 *
 * Copyright (c) 1990 Giuseppe Attardi
 * Copyright (c) 2001 Juan Jose Garcia Ripoll
 *
 * See file 'LICENSE' for the copyright details.
 *
 */

#include <ecl/ecl.h>
#include <ecl/ecl-inl.h>
#include <ecl/internal.h>
#include <errno.h>

#ifdef ENABLE_DLOPEN
cl_object
si_load_binary(cl_object filename, cl_object verbose,
               cl_object print, cl_object external_format)
{
  const cl_env_ptr the_env = ecl_process_env();
  cl_object block;
  cl_object basename;
  cl_object init_prefix, prefix;
  cl_object output;

  /* We need the full pathname */
  filename = cl_truename(filename);

  /* Try to load shared object file */
  block = ecl_library_open(filename, 1);
  if (block->cblock.handle == NULL) {
    output = ecl_library_error(block);
    goto OUTPUT;
  }

  /* Fist try to call "init_CODE()" */
  init_prefix = _ecl_library_default_entry();
  block->cblock.entry =
    ecl_library_symbol(block, (char *)init_prefix->base_string.self, 0);
  if (block->cblock.entry != NULL)
    goto GO_ON;

  /* Next try to call "init_FILE()" where FILE is the file name */
  prefix = ecl_symbol_value(ECL_SYM("SI::*INIT-FUNCTION-PREFIX*",1024));
  init_prefix = _ecl_library_init_prefix();
  if (Null(prefix)) {
    prefix = init_prefix;
  } else {
    prefix = si_base_string_concatenate(3,
                                          init_prefix,
                                          prefix,
                                          ecl_make_constant_base_string("_", -1));
  }
  basename = cl_pathname_name(1,filename);
  basename = si_base_string_concatenate(2, prefix, cl_string_upcase(1, funcall(4, ECL_SYM("NSUBSTITUTE",601), ECL_CODE_CHAR('_'), ECL_CODE_CHAR('-'), basename)));
  block->cblock.entry = ecl_library_symbol(block, (char*)basename->base_string.self, 0);

  if (block->cblock.entry == NULL) {
    output = ecl_library_error(block);
    ecl_library_close(block);
    goto OUTPUT;
  }

 GO_ON:
  /* Finally, perform initialization */
  ecl_init_module(block, (void (*)(cl_object))(block->cblock.entry));
  output = ECL_NIL;
 OUTPUT:
  ecl_return1(the_env, output);
}
#endif /* !ENABLE_DLOPEN */

cl_object
si_load_source(cl_object source, cl_object verbose, cl_object print, cl_object external_format)
{
  cl_env_ptr the_env = ecl_process_env();
  cl_object x, strm;

  /* Source may be either a stream or a filename */
  if (ecl_t_of(source) != t_pathname && ecl_t_of(source) != t_base_string) {
    /* INV: if "source" is not a valid stream, file.d will complain */
    strm = source;
  }
  else {
    strm = ecl_open_stream(source, ecl_smm_input, ECL_NIL, ECL_NIL, 8,
                           ECL_STREAM_C_STREAM, external_format);
    if (Null(strm)) {
      {
#line 92
	const cl_env_ptr the_env = ecl_process_env();
#line 92
	#line 92
	cl_object __value0 = ECL_NIL;
#line 92
	the_env->nvalues = 1;
#line 92
	the_env->values[0] = __value0;
#line 92
	#line 92
	return __value0;
#line 92
}
;
    }
  }
  ECL_UNWIND_PROTECT_BEGIN(the_env) {
    cl_object form_index = ecl_make_fixnum(0);
    cl_object pathname = ECL_SYM_VAL(the_env, ECL_SYM("*LOAD-PATHNAME*",38));
    cl_object location = CONS(pathname, form_index);
    ecl_bds_bind(the_env, ECL_SYM("EXT::*SOURCE-LOCATION*",1207), location);
    for (;;) {
      form_index = ecl_file_position(strm);
      ECL_RPLACD(location, form_index);
      x = si_read_object_or_ignore(strm, OBJNULL);
      if (x == OBJNULL)
        break;
      if (the_env->nvalues) {
        si_eval_with_env(1, x);
        if (print != ECL_NIL) {
          cl_write(1, x);
          cl_terpri(0);
        }
      }
    }
    ecl_bds_unwind1(the_env);
  } ECL_UNWIND_PROTECT_THREAD_SAFE_EXIT {
    /* We do not want to come back here if close_stream fails,
       therefore, first we frs_pop() current jump point, then
       try to close the stream, and then jump to next catch
       point */
    if (strm != source)
      cl_close(3, strm, ECL_SYM(":ABORT",1222), ECL_SYM("T",1));
  } ECL_UNWIND_PROTECT_THREAD_SAFE_END;
  {
#line 123
	const cl_env_ptr the_env = ecl_process_env();
#line 123
	#line 123
	cl_object __value0 = ECL_NIL;
#line 123
	the_env->nvalues = 1;
#line 123
	the_env->values[0] = __value0;
#line 123
	#line 123
	return __value0;
#line 123
}
;
}

static cl_object
read_forms(cl_object stream, cl_object errorp) {
  cl_env_ptr env = ecl_process_env();
  cl_object forms;
  env->packages_to_be_created_p = ECL_T;
  forms = cl_read(3, stream, errorp, ECL_NIL);
  env->packages_to_be_created_p = ECL_NIL;
  return forms;
}

cl_object
si_load_bytecodes(cl_object source, cl_object verbose, cl_object print, cl_object external_format)
{
  cl_env_ptr env = ecl_process_env();
  cl_object forms, strm;
  cl_object old_eptbc = env->packages_to_be_created;

  /* Source may be either a stream or a filename */
  if (ecl_t_of(source) != t_pathname && ecl_t_of(source) != t_base_string) {
    /* INV: if "source" is not a valid stream, file.d will complain */
    strm = source;
  } else {
    strm = ecl_open_stream(source, ecl_smm_input, ECL_NIL, ECL_NIL, 8,
                           ECL_STREAM_C_STREAM, external_format);
    if (Null(strm)) {
      {
#line 151
	const cl_env_ptr the_env = ecl_process_env();
#line 151
	#line 151
	cl_object __value0 = ECL_NIL;
#line 151
	the_env->nvalues = 1;
#line 151
	the_env->values[0] = __value0;
#line 151
	#line 151
	return __value0;
#line 151
}
;
    }
  }
  ECL_UNWIND_PROTECT_BEGIN(env) {
    {
      cl_object progv_list = ECL_SYM_VAL(env, ECL_SYM("SI::+ECL-SYNTAX-PROGV-LIST+",1799));
      cl_index bds_ndx = ecl_progv(env, ECL_CONS_CAR(progv_list),
                                   ECL_CONS_CDR(progv_list));
      forms = read_forms(strm, ECL_T);
      ecl_bds_unwind(env, bds_ndx);
    }
    while (!Null(forms)) {
      if (ECL_LISTP(forms)) {
        cl_object x = ECL_CONS_CAR(forms);
        forms = ECL_CONS_CDR(forms);
        if (ecl_t_of(x) == t_bytecodes) {
          _ecl_funcall1(x);
          if (Null(forms)) {
            forms = read_forms(strm, ECL_NIL);
          }
          continue;
        }
      }
      FEerror("Corrupt bytecodes file ~S", 1, source);
    }
    {
      cl_object x;
      x = cl_set_difference(2, env->packages_to_be_created, old_eptbc);
      old_eptbc = env->packages_to_be_created;
      unlikely_if (!Null(x)) {
        CEerror(ECL_T,
                Null(ECL_CONS_CDR(x))?
                "Package ~A referenced in "
                "compiled file~&  ~A~&but has not been created":
                "The packages~&  ~A~&were referenced in "
                "compiled file~&  ~A~&but have not been created",
                2, x, source);
      }
    }
  } ECL_UNWIND_PROTECT_THREAD_SAFE_EXIT {
    /* We do not want to come back here if close_stream fails,
       therefore, first we frs_pop() current jump point, then
       try to close the stream, and then jump to next catch
       point */
    if (strm != source) {
      cl_close(3, strm, ECL_SYM(":ABORT",1222), ECL_SYM("T",1));
    }
  } ECL_UNWIND_PROTECT_THREAD_SAFE_END;
  {
#line 199
	const cl_env_ptr the_env = ecl_process_env();
#line 199
	#line 199
	cl_object __value0 = ECL_NIL;
#line 199
	the_env->nvalues = 1;
#line 199
	the_env->values[0] = __value0;
#line 199
	#line 199
	return __value0;
#line 199
}
;
}

#line 208
cl_object cl_load(cl_narg narg, cl_object source, ...)
{
#line 208

  bool not_a_filename = 0;
#line 211
#if defined(__clang__) || defined(__GNUC__)
	__attribute__((unused)) const cl_env_ptr the_env = ecl_process_env();
#else
	const cl_env_ptr the_env = ecl_process_env();
#endif
#line 211
	static cl_object KEYS[5] = {(cl_object)(cl_symbols+1360), (cl_object)(cl_symbols+1324), (cl_object)(cl_symbols+1274), (cl_object)(cl_symbols+1264), (cl_object)(cl_symbols+1339)};
	cl_object verbose;
	cl_object print;
	cl_object if_does_not_exist;
	cl_object external_format;
	cl_object search_list;
#line 211
	cl_object pathname;
#line 211
	cl_object pntype;
#line 211
	cl_object hooks;
#line 211
	cl_object filename;
#line 211
	cl_object function;
#line 211
	cl_object ok;
#line 211
	cl_object file_kind;
#line 211
	cl_object KEY_VARS[10];
#line 211
	ecl_va_list ARGS;
	ecl_va_start(ARGS, source, narg, 1);
#line 211
	if (ecl_unlikely(narg < 1)) FEwrong_num_arguments(ecl_make_fixnum(489));
#line 211
	cl_parse_key(ARGS, 5, KEYS, KEY_VARS, NULL, 0);
#line 211
	if (KEY_VARS[5]==ECL_NIL) {
#line 211
	  verbose = ecl_symbol_value(ECL_SYM("*LOAD-VERBOSE*",41));
	} else {
#line 211
	  verbose = KEY_VARS[0];
	}
#line 211
	if (KEY_VARS[6]==ECL_NIL) {
#line 211
	  print = ecl_symbol_value(ECL_SYM("*LOAD-PRINT*",39));
	} else {
#line 211
	  print = KEY_VARS[1];
	}
#line 211
	if (KEY_VARS[7]==ECL_NIL) {
#line 211
	  if_does_not_exist = ECL_SYM(":ERROR",1257);
	} else {
#line 211
	  if_does_not_exist = KEY_VARS[2];
	}
#line 211
	if (KEY_VARS[8]==ECL_NIL) {
#line 211
	  external_format = ECL_SYM(":DEFAULT",1243);
	} else {
#line 211
	  external_format = KEY_VARS[3];
	}
#line 211
	if (KEY_VARS[9]==ECL_NIL) {
#line 211
	  search_list = ecl_symbol_value(ECL_SYM("SI::*LOAD-SEARCH-LIST*",1027));
	} else {
#line 211
	  search_list = KEY_VARS[4];
	}
#line 211
	pathname = ECL_NIL;
#line 211
	pntype = ECL_NIL;
#line 211
	hooks = ECL_NIL;
#line 211
	filename = ECL_NIL;
#line 211
	function = ECL_NIL;
#line 211
	ok = ECL_NIL;
#line 211
	file_kind = ECL_NIL;
#line 211
  /* If source is a stream, read conventional lisp code from it */
  if (ecl_t_of(source) != t_pathname && !ecl_stringp(source)) {
    /* INV: if "source" is not a valid stream, file.d will complain */
    filename = source;
    function = ECL_NIL;
    not_a_filename = 1;
    goto NOT_A_FILENAME;
  }
  /* INV: coerce_to_file_pathname() creates a fresh new pathname object */
  source   = cl_merge_pathnames(1, source);
  pathname = si_coerce_to_file_pathname(source);
  pntype   = pathname->pathname.type;

  filename = ECL_NIL;
  hooks = ecl_symbol_value(ECL_SYM("EXT::*LOAD-HOOKS*",1026));
  if (Null(pathname->pathname.directory) &&
      Null(pathname->pathname.host) &&
      Null(pathname->pathname.device) &&
      !Null(search_list))
    {
      loop_for_in(search_list) {
        cl_object d = CAR(search_list);
        cl_object f = cl_merge_pathnames(2, pathname, d);
        cl_object ok = cl_load(11, f, ECL_SYM(":VERBOSE",1360), verbose,
                               ECL_SYM(":PRINT",1324), print,
                               ECL_SYM(":IF-DOES-NOT-EXIST",1274), ECL_NIL,
                               ECL_SYM(":EXTERNAL-FORMAT",1264), external_format,
                               ECL_SYM(":SEARCH-LIST",1339), ECL_NIL);
        if (!Null(ok)) {
          {
#line 240
	#line 240
	cl_object __value0 = ok;
#line 240
	the_env->nvalues = 1;
#line 240
	the_env->values[0] = __value0;
#line 240
	ecl_va_end(ARGS);
#line 240
	return __value0;
#line 240
}
;
        }
      } end_loop_for_in;
    }
  if (!Null(pntype) && (pntype != ECL_SYM(":WILD",1362))) {
    /* If filename already has an extension, make sure
       that the file exists */
    filename = pathname;
    file_kind = si_file_kind(pathname, ECL_T);
    if (file_kind != ECL_SYM(":FILE",1266) && file_kind != ECL_SYM(":SPECIAL",1343)) {
      filename = ECL_NIL;
    } else {
      function = cl_cdr(ecl_assoc(pathname->pathname.type, hooks));
    }
  } else loop_for_in(hooks) {
      /* Otherwise try with known extensions until a matching
         file is found */
      filename = pathname;
      filename->pathname.type = CAAR(hooks);
      function = CDAR(hooks);
      file_kind = si_file_kind(filename, ECL_T);
      if (file_kind == ECL_SYM(":FILE",1266) || file_kind == ECL_SYM(":SPECIAL",1343))
        break;
      else
        filename = ECL_NIL;
    } end_loop_for_in;
  if (Null(filename)) {
    if (Null(if_does_not_exist)) {
      {
#line 268
	#line 268
	cl_object __value0 = ECL_NIL;
#line 268
	the_env->nvalues = 1;
#line 268
	the_env->values[0] = __value0;
#line 268
	ecl_va_end(ARGS);
#line 268
	return __value0;
#line 268
}
;
    } else {
      if (file_kind == ECL_SYM(":DIRECTORY",1247)) {
        errno = EISDIR;
#ifdef ECL_MS_WINDOWS_HOST
      } else {
        /* The functions used by si_file_kind report no useful errors
         * on Windows, so just stick with ENOENT here. */
        errno = ENOENT;
#endif
      }
      FEcannot_open(source);
    }
  }
 NOT_A_FILENAME:
  if (verbose != ECL_NIL) {
    cl_format(3, ECL_T, ecl_make_constant_base_string("~&;;; Loading ~s~%", -1),
              filename);
  }
  ecl_bds_bind(the_env, ECL_SYM("*PACKAGE*",45), ecl_symbol_value(ECL_SYM("*PACKAGE*",45)));
  ecl_bds_bind(the_env, ECL_SYM("*READTABLE*",67), ecl_symbol_value(ECL_SYM("*READTABLE*",67)));
  ecl_bds_bind(the_env, ECL_SYM("*LOAD-PATHNAME*",38), not_a_filename? ECL_NIL : source);
  ecl_bds_bind(the_env, ECL_SYM("*LOAD-TRUENAME*",40),
               not_a_filename? ECL_NIL : (filename = cl_truename(filename)));
  if (!Null(function)) {
    ok = funcall(5, function, filename, verbose, print, external_format);
  } else {
#if 0 /* defined(ENABLE_DLOPEN) && !defined(ECL_MS_WINDOWS_HOST)*/
    /*
     * DISABLED BECAUSE OF SECURITY ISSUES!
     * In systems where we can do this, we try to load the file
     * as a binary. When it fails, we will revert to source
     * loading below. Is this safe? Well, it depends on whether
     * your op.sys. checks integrity of binary exectables or
     * just loads _anything_.
     */
    if (not_a_filename) {
      ok = ECL_T;
    } else {
      ok = si_load_binary(filename, verbose, print);
    }
    if (!Null(ok))
#endif
      ok = si_load_source(filename, verbose, print, external_format);
  }
  ecl_bds_unwind_n(the_env, 4);
  if (!Null(ok))
    FEerror("LOAD: Could not load file ~S (Error: ~S)",
            2, filename, ok);
  if (print != ECL_NIL) {
    cl_format(3, ECL_T, ecl_make_constant_base_string("~&;;; Loading ~s~%", -1),
              filename);
  }
  {
#line 321
	#line 321
	cl_object __value0 = filename;
#line 321
	the_env->nvalues = 1;
#line 321
	the_env->values[0] = __value0;
#line 321
	ecl_va_end(ARGS);
#line 321
	return __value0;
#line 321
}
;
}
