
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "action_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_Action_Type = nullptr;
static PyTypeObject *Sbk_Action_TypeF(void)
{
    return _Sbk_Action_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ActionWrapper::pysideInitQtMetaTypes()
{
}

void ActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

ActionWrapper::ActionWrapper(::QObject * parent) : Action(parent)
{
}

ActionWrapper::ActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : Action(icon, text, parent)
{
}

ActionWrapper::ActionWrapper(const ::QString & text, ::QObject * parent) : Action(text, parent)
{
}

void ActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("Action", funcName, gil, pyOverride, event);
}

void ActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("Action", funcName, gil, pyOverride, signal);
}

void ActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("Action", funcName, gil, pyOverride, event);
}

void ActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("Action", funcName, gil, pyOverride, signal);
}

bool ActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAction::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("Action", funcName, gil, pyOverride, arg__1);
}

bool ActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("Action", funcName, gil, pyOverride, watched, event);
}

void ActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_Action_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("Action", funcName, gil, pyOverride, event);
}

const QMetaObject *ActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return Action::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = Action::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ActionWrapper *>(this));
    }
    return Action::qt_metacast(_clname);
}

ActionWrapper::~ActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_Action_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_Action_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::Action >()))
        return -1;

    ActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:Action", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: Action::Action(QObject*=)
    // 1: Action::Action(QIcon,QString,QObject*=)
    // 2: Action::Action(QString,QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // Action(QObject*)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // Action(QIcon,QString,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
            overloadId = 1; // Action(QIcon,QString,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Action(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // Action(QString,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
            overloadId = 2; // Action(QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Action_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_Action_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // Action(QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Action_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Action(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) ActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new ActionWrapper(cppArg0);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // Action(const QIcon &icon, const QString &text, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Action_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Action(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) ActionWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new ActionWrapper(*cppArg0, cppArg1, cppArg2);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 2: // Action(const QString &text, QObject *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Action_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // Action(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) ActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new ActionWrapper(cppArg0, cppArg1);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< Action >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Action_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_Action_IDX]);
    };


    return 1;
}

static PyObject *Sbk_ActionFunc_emitCtrlTriggered(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ActionWrapper *>(reinterpret_cast< ::Action *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Action_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // emitCtrlTriggered()
        cppSelf->emitCtrlTriggered();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ActionFunc_emitShiftTriggered(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ActionWrapper *>(reinterpret_cast< ::Action *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Action_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // emitShiftTriggered()
        cppSelf->emitShiftTriggered();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_Action_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_Action_methods[] = {
    {"emitCtrlTriggered", reinterpret_cast<PyCFunction>(Sbk_ActionFunc_emitCtrlTriggered), METH_NOARGS, nullptr},
    {"emitShiftTriggered", reinterpret_cast<PyCFunction>(Sbk_ActionFunc_emitShiftTriggered), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_Action_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::Action *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Action_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_Action_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_Action_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_Action_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_Action_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_Action_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_Action_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_Action_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_Action_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_Action_spec = {
    "1:PyFalkon.Action",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_Action_slots
};

} //extern "C"

static void *Sbk_Action_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::Action *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Action_PythonToCpp_Action_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_Action_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Action_PythonToCpp_Action_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_Action_TypeF()))
        return Action_PythonToCpp_Action_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Action_PTR_CppToPython_Action(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::Action *>(const_cast<void *>(cppIn)), Sbk_Action_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *Action_SignatureStrings[] = {
    "2:PyFalkon.Action(self,parent:PySide6.QtCore.QObject=nullptr)",
    "1:PyFalkon.Action(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject=nullptr)",
    "0:PyFalkon.Action(self,text:QString,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.Action.emitCtrlTriggered(self)",
    "PyFalkon.Action.emitShiftTriggered(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t Action_SignatureByteSize = 160;
static constexpr uint8_t Action_SignatureBytes[160] = {
    0x78, 0xda, 0x9d, 0x8e, 0xb1, 0x0a, 0xc2, 0x40, 0x10, 0x44, 0x7b, 0xbf, 0xc2, 0x52, 0x21, 0x1c,
    0x6a, 0x61, 0x71, 0x60, 0x21, 0x01, 0xc5, 0xca, 0x1c, 0xd1, 0x4a, 0x2c, 0x62, 0xb2, 0x89, 0xab,
    0x97, 0xbd, 0x63, 0xdd, 0x40, 0xf2, 0xf7, 0x1e, 0x36, 0xc2, 0x91, 0x42, 0x6c, 0x67, 0xde, 0x3c,
    0x66, 0xa5, 0xb3, 0x61, 0x57, 0xd8, 0xa7, 0x23, 0xb5, 0x2d, 0x05, 0x1d, 0xcd, 0x5e, 0x60, 0xeb,
    0xc4, 0x17, 0x0c, 0x24, 0xa1, 0xcb, 0xb1, 0x82, 0xb5, 0x32, 0x92, 0x3a, 0x06, 0x65, 0x8e, 0xb7,
    0x07, 0x94, 0xb2, 0xa1, 0xce, 0x5a, 0x2f, 0x3c, 0x9f, 0x2c, 0xc7, 0xd7, 0x58, 0x3a, 0xd2, 0x32,
    0x78, 0xa4, 0x46, 0x9d, 0x29, 0xc4, 0x97, 0xaf, 0x68, 0xdf, 0xa1, 0x32, 0x87, 0x00, 0x24, 0xd3,
    0x28, 0xcc, 0xb0, 0x6f, 0x0b, 0x7f, 0x4d, 0x04, 0x7a, 0xd1, 0x26, 0x17, 0x0e, 0xf3, 0x5f, 0x8f,
    0x2c, 0xc6, 0x8f, 0xfc, 0xa3, 0x8a, 0x44, 0x0a, 0x5a, 0x94, 0x54, 0xd8, 0x9e, 0x18, 0x9b, 0x06,
    0x18, 0xaa, 0x8f, 0x7a, 0x9c, 0xcb, 0xef, 0x58, 0x4b, 0x0c, 0xbe, 0x01, 0xec, 0x19, 0x80, 0x87
};
#endif

PyTypeObject *init_Action(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_Action_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_Action_IDX].type;

    Shiboken::AutoDecRef Sbk_Action_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]))));

    _Sbk_Action_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "Action",
        "Action*",
        &Sbk_Action_spec,
        &Shiboken::callCppDestructor< Action >,
        Sbk_Action_Type_bases.object(),
        0);
    auto *pyType = _Sbk_Action_Type; // references _Sbk_Action_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, Action_SignatureStrings);
#else
    InitSignatureBytes(pyType, Action_SignatureBytes, Action_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_Action_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_Action_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        Action_PythonToCpp_Action_PTR,
        is_Action_PythonToCpp_Action_PTR_Convertible,
        Action_PTR_CppToPython_Action);

    Shiboken::Conversions::registerConverterName(converter, "Action");
    Shiboken::Conversions::registerConverterName(converter, "Action*");
    Shiboken::Conversions::registerConverterName(converter, "Action&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::Action).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_Action_TypeF(), &Sbk_Action_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::Action::staticMetaObject);
    ActionWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::Action::staticMetaObject, sizeof(ActionWrapper));

    return pyType;
}
