
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "pluginspec_wrapper.h"

// Argument includes
#include <plugins.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PluginSpec_Type = nullptr;
static PyTypeObject *Sbk_PluginSpec_TypeF(void)
{
    return _Sbk_PluginSpec_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PluginSpec_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PluginSpec >()))
        return -1;

    ::PluginSpec *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "PluginSpec", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: PluginSpec::PluginSpec()
    // 1: PluginSpec::PluginSpec(PluginSpec)
    if (numArgs == 0) {
        overloadId = 0; // PluginSpec()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PluginSpec(PluginSpec)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // PluginSpec()
        {

            // PluginSpec()
            cptr = new ::PluginSpec();
            break;
        }
        case 1: // PluginSpec(const PluginSpec &PluginSpec)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::PluginSpec cppArg0_local;
            ::PluginSpec *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // PluginSpec(PluginSpec)
                cptr = new ::PluginSpec(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::PluginSpec >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_PluginSpec__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_PluginSpec_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PluginSpec_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_PluginSpec__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_PluginSpec_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), (pyArg)))) {
                // operator==(const PluginSpec &other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::PluginSpec cppArg0_local;
                ::PluginSpec *cppArg0 = &cppArg0_local;
                if (pythonToCpp.isValue())
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf == (*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
    }

    return Shiboken::returnFromRichCompare(pyResult);
}

static PyObject *Sbk_PluginSpec_get_name(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->name);
}
static int Sbk_PluginSpec_set_name(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("name");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("name", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->name;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_description(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->description);
}
static int Sbk_PluginSpec_set_description(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("description");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("description", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->description;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_author(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->author);
}
static int Sbk_PluginSpec_set_author(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("author");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("author", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->author;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_version(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->version);
}
static int Sbk_PluginSpec_set_version(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("version");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("version", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->version;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_icon(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->icon), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_PluginSpec_set_icon(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("icon");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("icon", "QPixmap");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_PluginSpec_get_hasSettings(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->hasSettings;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_PluginSpec_set_hasSettings(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("hasSettings");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("hasSettings", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->hasSettings;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->hasSettings = cppOut_local;

    return 0;
}

// Getters and Setters for PluginSpec
static PyGetSetDef Sbk_PluginSpec_getsetlist[] = {
    {"name", Sbk_PluginSpec_get_name, Sbk_PluginSpec_set_name, "QString", nullptr},
    {"description", Sbk_PluginSpec_get_description, Sbk_PluginSpec_set_description, "QString", nullptr},
    {"author", Sbk_PluginSpec_get_author, Sbk_PluginSpec_set_author, "QString", nullptr},
    {"version", Sbk_PluginSpec_get_version, Sbk_PluginSpec_set_version, "QString", nullptr},
    {"icon", Sbk_PluginSpec_get_icon, Sbk_PluginSpec_set_icon, "PySide6.QtGui.QPixmap", nullptr},
    {"hasSettings", Sbk_PluginSpec_get_hasSettings, Sbk_PluginSpec_set_hasSettings, "bool", nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_PluginSpec_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PluginSpec_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PluginSpec_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PluginSpec_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PluginSpec_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_PluginSpec_richcompare)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PluginSpec_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_PluginSpec_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PluginSpec_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PluginSpec_spec = {
    "1:PyFalkon.PluginSpec",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PluginSpec_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PluginSpec_PythonToCpp_PluginSpec_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PluginSpec_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PluginSpec_PythonToCpp_PluginSpec_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PluginSpec_TypeF()))
        return PluginSpec_PythonToCpp_PluginSpec_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PluginSpec_PTR_CppToPython_PluginSpec(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_PluginSpec_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_PluginSpec_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *PluginSpec_COPY_CppToPython_PluginSpec(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::PluginSpec *>(cppIn);
    return Shiboken::Object::newObject(Sbk_PluginSpec_TypeF(), new ::PluginSpec(*source), true, true);
}

// Python to C++ copy conversion.
static void PluginSpec_PythonToCpp_PluginSpec_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::PluginSpec *>(cppOut) = *reinterpret_cast< ::PluginSpec *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PluginSpec_PythonToCpp_PluginSpec_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_PluginSpec_TypeF()))
        return PluginSpec_PythonToCpp_PluginSpec_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PluginSpec_SignatureStrings[] = {
    "1:PyFalkon.PluginSpec(self)",
    "0:PyFalkon.PluginSpec(self,PluginSpec:PyFalkon.PluginSpec)",
    "PyFalkon.PluginSpec.__copy__(self)->typing._Self",
    "PyFalkon.PluginSpec.__eq__(self,other:PyFalkon.PluginSpec)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t PluginSpec_SignatureByteSize = 93;
static constexpr uint8_t PluginSpec_SignatureBytes[93] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0xc8, 0x29,
    0x4d, 0xcf, 0xcc, 0x0b, 0x2e, 0x48, 0x4d, 0xd6, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xe4, 0x32, 0xc0,
    0x29, 0xa7, 0x83, 0xe0, 0x63, 0x53, 0xa3, 0xc9, 0x85, 0x45, 0x50, 0x2f, 0x3e, 0x3e, 0x39, 0xbf,
    0xa0, 0x32, 0x3e, 0x1e, 0x62, 0xba, 0xae, 0x5d, 0x49, 0x65, 0x41, 0x66, 0x5e, 0xba, 0x5e, 0x7c,
    0x30, 0x90, 0x8b, 0x43, 0x43, 0x6a, 0x21, 0x54, 0xb9, 0x4e, 0x7e, 0x49, 0x46, 0x6a, 0x11, 0x56,
    0xbb, 0x74, 0xed, 0x92, 0xf2, 0xf3, 0x73, 0xb8, 0x00, 0xa2, 0x69, 0x48, 0xb3
};
#endif

PyTypeObject *init_PluginSpec(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX].type;

    Shiboken::AutoDecRef Sbk_PluginSpec_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_PluginSpec_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PluginSpec",
        "PluginSpec",
        &Sbk_PluginSpec_spec,
        &Shiboken::callCppDestructor< ::PluginSpec >,
        Sbk_PluginSpec_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_PluginSpec_Type; // references _Sbk_PluginSpec_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PluginSpec_SignatureStrings);
#else
    InitSignatureBytes(pyType, PluginSpec_SignatureBytes, PluginSpec_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PluginSpec_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PluginSpec_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PluginSpec_PythonToCpp_PluginSpec_PTR,
        is_PluginSpec_PythonToCpp_PluginSpec_PTR_Convertible,
        PluginSpec_PTR_CppToPython_PluginSpec,
        PluginSpec_COPY_CppToPython_PluginSpec);

    Shiboken::Conversions::registerConverterName(converter, "PluginSpec");
    Shiboken::Conversions::registerConverterName(converter, "PluginSpec*");
    Shiboken::Conversions::registerConverterName(converter, "PluginSpec&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PluginSpec).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PluginSpec_PythonToCpp_PluginSpec_COPY,
        is_PluginSpec_PythonToCpp_PluginSpec_COPY_Convertible);

    qRegisterMetaType< ::PluginSpec >("PluginSpec");

    return pyType;
}
